; =============================================================================
;
;                               Litos - Console
;
; =============================================================================

CONSOLE_NUM	EQU	32		; maximal number of consoles (hardcode)

; ------------- Console interface (primary or secondary)

struc		CONSOLE1

CON_DataWrite:	resd	1		; 0: private data for output interface
CON_Write:	resd	1		; 4: output function
					;	INPUT:	AL = character to write
					;		EBX = private data
CON_DataMWrite:	resd	1		; 8: private data for multi-output
CON_MWrite:	resd	1		; 0Ch: multi-output function
					;	INPUT:	EAX = output buffer
					;		EBX = private data
					;		ECX = number of bytes
CON_DataRead:	resd	1		; 10h: private data for input interface
CON_Read:	resd	1		; 14h: input function (without wait)
					;	INPUT:	EBX = private data
					;	OUTPUT:	AL = character (if NC)
					;		CY = no character ready
					;		  (AL = 0 if CY)
CON_DataKRead:	resd	1		; 18h: private data for input interface
CON_KRead:	resd	1		; 1Ch: key input function (without wait)
					;	INPUT:	EBX = private data
					;	OUTPUT:	EAX = key code (if NC)
					;		CY = no character ready
					;		  (EAX = 0 if CY)
CON_DataMRead:	resd	1		; 20h: private data for multi-input
CON_MRead:	resd	1		; 24h: multi-input function (no wait)
					;	INPUT:  EAX = input buffer
					;		EBX = private data
					;		ECX = buffer size
					;	OUTPUT:	ECX = read bytes
					;		CY = no character ready
					;		  (ECX = 0 if CY)

endstruc				; size 28h = 40 bytes

; ------------- Console interface

struc		CONSOLE

		resb	CONSOLE1_size	; 0: primary interface
CON_2:		resb	CONSOLE1_size	; 28h: secondary interface (echo)

endstruc				; size 50h = 80 bytes
