; =============================================================================
;
;                             Litos - Disk cache
;
; =============================================================================

; ------------- Cache buffer (32 KB or 16 KB)
; Cache buffer size determines maximal granularity of data device.

%ifdef MINI
CACHE_BUFBITS	EQU	14		; number of bits of cache buffer
%else
CACHE_BUFBITS	EQU	15		; number of bits of cache buffer
%endif
CACHE_BUFSIZE	EQU	1 << CACHE_BUFBITS ; size of cache buffer
CACHE_BUFMASK	EQU	CACHE_BUFSIZE-1	; cache buffer mask
CACHE_BUFINVMSK	EQU	~CACHE_BUFMASK	; cache buffer inverse mask

; ------------- Cache hash list (number of hash lists, 16 KB or 8 KB)

%ifdef MINI
CACHE_HASHBITS	EQU	11		; number of bits of hash list size
%else
CACHE_HASHBITS	EQU	12		; number of bits of hash list size
%endif
CACHE_HASHSIZE	EQU	1 << CACHE_HASHBITS ; hash list size
CACHE_HASHMASK	EQU	(CACHE_HASHSIZE-1) ; hash index mask

; ------------- Cache buffer head

struc		CACHE

		resb	HASHE_size	; 0: hash list entry
CACHE_List:	resb	LIST_size	; 8: list of buffers
CACHE_Lock:	resb	MUT_size	; 10h: mutex to lock access to data
CACHE_Data:	resd	1		; 2Ch: pointer to cache data block
CACHE_Offset:	resd	2		; 30h: offset of data in buffer
CACHE_Driver:	resd	1		; 38h: pointer to driver
CACHE_Size:	resd	1		; 3Ch: size of data in buffer
CACHE_Flags:	resb	1		; 40h: flags (see below)
		resb	3
CACHE_Used:	resd	1		; 44h: buffer is used
CACHE_NextWrite:resd	2		; 48h: time of next write
CACHE_MaxWrite:	resd	2		; 50h: maximal time of next write

endstruc				; sizhe 58h = 88 bytes

; ------------- Cache buffer flags

CACHE_READ_BIT	EQU	0		; buffer is loaded from disk
CACHE_READ	EQU	1 << CACHE_READ_BIT
CACHE_DIRTY	EQU	B1		; buffer is modified
CACHE_WRITE	EQU	B2		; buffer is saved to disk
