; =============================================================================
;
;                               Litos - Processor
;
; =============================================================================

; ------------- Macro - short delay (roughly 1.5 microsecond)
; Alternatives of dummy ports:
;	80h: AT diagnostic port used by Linux for short delay
;	0ebh: dummy port used by some BIOSes for short delays
;	0edh: dummy port used by some BIOSes for short delays

%define		SHORT_DELAY	out 80h,al

; ------------- Macro - get system time LOW in 100-ns (%1 = register)

%macro		GETSYSTIMELOW 1

		mov	%1,[CurrentTime] ; get current time LOW
		sub	%1,[StartTime]	; subtract start time LOW

%endmacro

; ------------- Macro - CPU instruction lock (only SMP mode)

%macro		LOCKSMP 0
%ifdef	SMP
		lock			; CPU instruction lock
%endif
%endmacro

; ------------- Macro - check if CPU supports INVLPG instruction
; Output: NC = CPU supports INVLPG instruction, CY = it does not

%macro		IS_INVTLB 0

		cmp	byte [CPUInfo+CPU_Type],CPU_486 ; min. 486 required

%endmacro

; ------------- Macro - invalidate TLB cache entry
; %1 = memory address, %2 = jump address if operation is not supported

%macro		INVTLB	2

		IS_INVTLB		; does CPU support INVLPG instruction?
		jc	%2		; skip to alternative address
		invlpg	[%1]		; invalidate TLB cache entry
%endmacro

; ------------- Registers in stack (pushed with PUSHA instruction)

struc		REGSTACK

REGS_EDI:	resd	1		; 0: EDI register
REGS_ESI:	resd	1		; 4: ESI register
REGS_EBP:	resd	1		; 8: EBP register
REGS_ESP:	resd	1		; 0Ch: ESP register
					; (points behind end of structure)
REGS_EBX:	resd	1		; 10h: EBX register
REGS_EDX:	resd	1		; 14h: EDX register
REGS_ECX:	resd	1		; 18h: ECX register
REGS_EAX:	resd	1		; 1Ch: EAX register

endstruc				; size 20h = 32 bytes

; ------------- Segments in stack (pushed with PUSH DS, ES, FS, GS)

struc		SEGSTACK

SEGS_GS:	resw	2		; 0: GS register (WORD)
SEGS_FS:	resw	2		; 4: FS register (WORD)
SEGS_ES:	resw	2		; 8: ES register (WORD)
SEGS_DS:	resw	2		; 0Ch: DS register (WORD)

endstruc				; size 16 bytes

; ------------- Stack content on interrupt

struc		REGINT

REGI_EIP:	resd	1		; 0: instruction pointer (EIP)
REGI_CS:	resw	2		; 4: code segment (WORD, CS)
REGI_Flags:	resd	1		; 8: flags (EFLAGS), see below

endstruc				; size 12 bytes

; ------------- FPU register

struc		FPUREG

FPUREG_Sign:	resb	8		; 0: significand (64 bits)
FPUREG_Exp:	resb	2		; 8: exponent (15 bits)+sign (1 bit)

endstruc				; size 10 bytes

; ------------- FPU state (saved with FSTENV/FNSTENV/FSAVE/FNSAVE instructions)

struc		FPUSTATE
				; --- state stored with FSTENV/FNSTENV
FPU_CW:		resw	2		; 0: control word
FPU_SW:		resw	2		; 4: status word
FPU_TW:		resw	2		; 8: tag word
FPU_IP:		resd	1		; 0Ch: instruction pointer
FPU_CS:		resw	1		; 10h: code selector
FPU_OP:		resw	1		; 12h: opcode
FPU_DP:		resd	1		; 14h: data pointer
FPU_DS:		resw	2		; 18h: data selector
				; --- extension stored with FSAVE/FNSAVE
FPU_ST:		resb	FPUREG_size*8	; 1Ch: data registers
		resd	1		; 6Ch: padding

endstruc				; size 70h = 112 bytes

; ------------- FPU register with padding

struc		FPUXREG

		resb	FPUREG_size	; 0: FPU register
		resb	3		; 0Ah: padding (reserved)

endstruc				; size 16 bytes

; ------------- FPU MMX register

struc		FPUMMX

FPUMMX_Data:	resd	4		; 0: MMX register

endstruc				; size 16 bytes

; ------------- FPU extended state (saved with FXSAVE instruction)

struc		FPUXSTATE

FPUX_CW:	resw	1		; 0: control word
FPUX_SW:	resw	1		; 2: status word
FPUX_TW:	resw	1		; 4: tag word
FPUX_OP:	resw	1		; 6: opcode
FPUX_IP:	resd	1		; 8: instruction pointer
FPUX_CS:	resw	2		; 0Ch: code selector
FPUX_DP:	resd	1		; 10h: data pointer
FPUX_DS:	resw	2		; 14h: data selector
FPUX_MXCSR:	resd	1		; 18h:
		resd	1		; 1Ch: ...reserved
FPUX_ST:	resb	FPUXREG_size*8	; 20: data registers
FPUX_MMX:	resb	FPUMMX_size*8	; 0A0h: MMX registers
		resb	14*16		; 120h: padding

endstruc				; size 200h = 512 bytes

; ------------- EFLAG bits

EFLAGS_CF_BIT	EQU	0		; carry flag
EFLAGS_CF	EQU	B0

EFLAGS_PF_BIT	EQU	2		; parity flag
EFLAGS_PF	EQU	B2

EFLAGS_AF_BIT	EQU	4		; auxiliary carry flag
EFLAGS_AF	EQU	B4

EFLAGS_ZF_BIT	EQU	6		; zero flag
EFLAGS_ZF	EQU	B6

EFLAGS_SF_BIT	EQU	7		; sign flag
EFLAGS_SF	EQU	B7

EFLAGS_TF_BIT	EQU	8		; trap flag
EFLAGS_TF	EQU	B8

EFLAGS_IF_BIT	EQU	9		; interrupt enable flag
EFLAGS_IF	EQU	B9

EFLAGS_DF_BIT	EQU	10		; direction flag
EFLAGS_DF	EQU	B10

EFLAGS_OF_BIT	EQU	11		; overflow flag
EFLAGS_OF	EQU	B11

EFLAGS_IOPL_MASK EQU	B12+B13		; I/O privilege level mask
EFLAGS_IOPL_SHIFT EQU	B12		; I/O privilege level bit shifts

EFLAGS_NT_BIT	EQU	14		; nested task
EFLAGS_NT	EQU	B14

EFLAGS_RF_BIT	EQU	16		; resume flag
EFLAGS_RF	EQU	B16

EFLAGS_VM_BIT	EQU	17		; virtual-8086 mode
EFLAGS_VM	EQU	B17

EFLAGS_AC_BIT	EQU	18		; alignment check
EFLAGS_AC	EQU	B18

EFLAGS_VIF_BIT	EQU	19		; virtual interrupt flag
EFLAGS_VIF	EQU	B19

EFLAGS_VIP_BIT	EQU	20		; virtual interrupt pending
EFLAGS_VIP	EQU	B20

EFLAGS_ID_BIT	EQU	21		; CPUID detection flag
EFLAGS_ID	EQU	B21
