; =============================================================================
;
;                             Litos - Constants
;
; =============================================================================

NULL		EQU	0		; invalid pointer

TRUE		EQU	1		; TRUE constant
FALSE		EQU	0		; FALSE constant

; ------------- ASCII control characters

NUL		EQU	0		; Nul (filling) character
SOH		EQU	1		; Start of Header
STX		EQU	2		; Start of Text
ETX		EQU	3		; End of Text
EOT		EQU	4		; End of Transmission
ENQ		EQU	5		; Enquiry
ACK		EQU	6		; Acknowledge
BEL		EQU	7		; Bell
BS		EQU	8		; Backspace
HT		EQU	9		; Horizontal Tabulator
TAB		EQU	HT
LF		EQU	10		; Line Feed
VT		EQU	11		; Vertical Tabulator
FF		EQU	12		; Form Feed
CR		EQU	13		; Carriage Return
SHO		EQU	14		; Shift Out (SO)
SHI		EQU	15		; Shift In (SI)
DLE		EQU	16		; Data Link Escape
DC1		EQU	17		; Device Control 1, XOn
DC2		EQU	18		; Device Control 2, XOff
DC3		EQU	19		; Device Control 3
DC4		EQU	20		; Device Control 4
NAK		EQU	21		; Negative Acknowledge
SYN		EQU	22		; Synchronous Idle
ETB		EQU	23		; End of Transmission Block
CAN		EQU	24		; Cancel
EM		EQU	25		; End of Medium
SUBS		EQU	26		; Substitute (SUB)
ESC		EQU	27		; Escape
FSEP		EQU	28		; File Separator (FS)
GSEP		EQU	29		; Group Separator (GS)
RSEP		EQU	30		; Record Separator (RS)
USEP		EQU	31		; Unit Separator (US)
SPACE		EQU	32		; Space

CSI		EQU	80h+ESC		; extended Escape

; ------------- Bits

B0		EQU	00000001b				; 1
B1		EQU	00000010b				; 2
B2		EQU	00000100b				; 4
B3		EQU	00001000b				; 8
B4		EQU	00010000b				; 10h
B5		EQU	00100000b				; 20h
B6		EQU	01000000b				; 40h
B7		EQU	10000000b				; 80h

B8		EQU	0000000100000000b			; 100h
B9		EQU	0000001000000000b			; 200h
B10		EQU	0000010000000000b			; 400h
B11		EQU	0000100000000000b			; 800h
B12		EQU	0001000000000000b			; 1000h
B13		EQU	0010000000000000b			; 2000h
B14		EQU	0100000000000000b			; 4000h
B15		EQU	1000000000000000b			; 8000h

B16		EQU	000000010000000000000000b		; 10000h
B17		EQU	000000100000000000000000b		; 20000h
B18		EQU	000001000000000000000000b		; 40000h
B19		EQU	000010000000000000000000b		; 80000h
B20		EQU	000100000000000000000000b		; 100000h
B21		EQU	001000000000000000000000b		; 200000h
B22		EQU	010000000000000000000000b		; 400000h
B23		EQU	100000000000000000000000b		; 800000h

B24		EQU	00000001000000000000000000000000b	; 1000000h
B25		EQU	00000010000000000000000000000000b	; 2000000h
B26		EQU	00000100000000000000000000000000b	; 4000000h
B27		EQU	00001000000000000000000000000000b	; 8000000h
B28		EQU	00010000000000000000000000000000b	; 10000000h
B29		EQU	00100000000000000000000000000000b	; 20000000h
B30		EQU	01000000000000000000000000000000b	; 40000000h
B31		EQU	10000000000000000000000000000000b	; 80000000h
