
; Export font into ASM, enter input name as parameter, output fill be ASM
; Notes: use one space as parameter separator

W		EQU	1		; font width (bytes)

		org	100h

; ------------- Input file name

		xor	bx,bx		; BX <- 0
		mov	bl,[80h]	; BL <- length
		mov	[bx+81h],bh	; end of text
		cmp	bl,1
		jbe	near Error

; ------------- Open input file name

		mov	ax,3D00h	; read only mode
		mov	dx,82h		; input file name
		int	21h		; open file
		jc	near Error	; error
		xchg	ax,bx		; BX <- input file

; ------------- Read input file

		mov	ah,3fh		; function code
		mov	cx,32*W*256	; CX <- bytes to read
		mov	dx,Buffer	; DX <- input buffer
		int	21h		; read file
		jc	near Error	; error

; ------------- Font height

		xor	dx,dx		; EDX <- 0
		mov	cx,W*256
		div	cx		; calculate font height
		mov	[Height],ax	; font height

; ------------- Close input file

		mov	ah,3eh		; function code
		int	21h		; close file

; ------------- Output file name

		xor	bx,bx		; BX <- 0
		mov	bl,[80h]	; BX <- length
Exp1:		cmp	byte [bx+81h],"."
		je	Exp12
		dec	bx
		jnz	Exp1
Exp12:		mov	byte [bx+81h],"."
		mov	byte [bx+81h+1],"a"
		mov	byte [bx+81h+2],"s"
		mov	byte [bx+81h+3],"m"
		mov	byte [bx+81h+4],0

; ------------- Create output file

		xor	cx,cx		; CX <- 0, attributes
		mov	ah,3Ch		; AH <- function code
		mov	dx,82h		; output file name
		int	21h		; create output file
		jc	Error		; error
		mov	[File],ax	; identifier

; ------------- Prepare registers

		mov	si,Buffer	; SI <- table buffer
		mov	di,256		; DI <- number of fonts
		xor	bp,bp		; BP <- character index

; ------------- Write character prefix

Exp2:		mov	ax,Pref1Text	; AX <- prefix 1
		call	WriteTxt	; write prefix 1

		mov	ax,bp		; AX <- character index
		call	WriteNum	; write character index DEC

		mov	ax,Pref2Text	; AX <- prefix 2
		call	WriteTxt	; write prefix 2

		mov	ax,bp		; AX <- character index
		call	WriteHex	; write character index HEX

		mov	ax,Pref3Text	; AX <- prefix 3
		call	WriteTxt	; write prefix 3

;		mov	ax,bp		; AX <- character index
;		cmp	al," "		; valid character?
;		jb	Exp22		; not valid character
;		call	Write		; write character

;Exp22:		mov	ax,Pref4Text	; AX <- prefix 4
;		call	WriteTxt	; write prefix 4

; ------------- Write "db"

		mov	dx,[Height]	; DX <- number of lines
Exp3:		mov	ax,DBText	; "db" text
		call	WriteTxt	; write text

; ------------- Load byte to write

		cld			; direction up
		lodsb			; load byte to write
		mov	ah,al		; AH <- byte to write

; ------------- Decode byte

		mov	cx,8		; CX <- width
Exp4:		mov	al,"0"		; zero
		shl	ah,1		; test one bite
		jnc	Exp5		; zero bite
		inc	ax		; AL <- "1"
Exp5:		call	Write		; write one bite
		loop	Exp4		; next bite

; ------------- Sufix

		mov	ax,BCRLFText	; sufix text
		call	WriteTxt	; write sufix

; ------------- Next row of character

		dec	dx		; lines counter
		jnz	Exp3		; write next line

; ------------- Next character

		inc	bp		; increase character index
		dec	di		; character counter
		jnz	Exp2		; write next character

; ------------- Close output file

		mov	bx,[File]	; BX <- identifier
		mov	ah,3Eh		; AH <- function code
		int	21h		; close output file

		int	20h		; quit the program

Error:		mov	dx,ErrText	; DX <- error text
		mov	ah,9		; AH <- function code
		int	21h		; display error text
		int	20h		; quit the program

; ------------- Output one character AL

Write:		push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		push	dx		; push DX
		push	si		; push SI

		mov	[OutBuf],al	; store character
		mov	bx,[File]	; BX <- identifier
		mov	cx,1		; 1 character to write
		mov	dx,OutBuf	; DX <- output buffer
		mov	ah,40h		; AH <- function code
		int	21h		; write character

		pop	si		; pop SI
		pop	dx		; pop DX
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret		

; ------------- Output ASCII text AX

WriteTxt:	push	ax		; push AX
		push	si		; push SI
		xchg	ax,si		; SI <- text

WriteText2:	cld			; direction up
		lodsb			; load character
		cmp	al,0		; end of text?
		je	WriteText4	; end of text
		call	Write		; write character
		jmp	short WriteText2 ; next character

WriteText4:	pop	si		; pop SI
		pop	ax		; pop AX
		ret

; ------------- Write number in AX

WriteNum:	push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		push	dx		; push DX

		mov	bx,10		; BX <- divider
		xor	cx,cx		; CX <- 0, character counter
WriteNum2:	xor	dx,dx		; DX <- 0
		div	bx		; AX <- number, DL <- rest
		add	dl,"0"		; convert to character
		push	dx		; push character
		inc	cx		; increase character counter
		or	ax,ax		; is next digit?
		jnz	WriteNum2	; next digit

WriteNum4:	pop	ax		; pop character
		call	Write		; write character
		loop	WriteNum4	; next character

		pop	dx		; pop DX
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; ------------- Output HEX byte AL

WriteHex:	push	ax		; push AX
		shr	al,4		; high digit
		call	WriteHex2	; write character HEX
		pop	ax		; pop AX

WriteHex2:	push	ax		; push AX
		and	al,0fh		; mask
		add	al,"0"		; convert to digit
		cmp	al,"9"		; check if it is HEX character
		jbe	WriteHex4
		add	al,7+20h
WriteHex4:	call	Write
		pop	ax		; pop AX
		ret

; ------------- Data

ErrText:	db	'ERROR!',13,10,'$'

Pref1Text:	db	9,9,9,9,9,'; ',0
Pref2Text:	db	' 0',0
Pref3Text:	db	'h',13,10,0
;Pref3Text:	db	'h "',0
;Pref4Text:	db	'"',13,10,0

DBText:		db	9,9,'db',9,0
BCRLFText:	db	'b'
CRLFText:	db	13,10,0
Height		dw	19		; font height

File:		dw	0		; output file identifier
OutBuf:		db	0		; output buffer

Buffer:
