; =============================================================================
;
;                       Litos - System kernel device
;
; =============================================================================

		CODE_SECTION

; *****************************************************************************
;
;                           Driver interface functions
;
; *****************************************************************************

; -----------------------------------------------------------------------------
;                           Install SYS device
; -----------------------------------------------------------------------------
; OUTPUT:	CY = error
; -----------------------------------------------------------------------------

; ------------- Push registers

SYSInstall:	push	ebx		; push EBX
		push	ecx		; push ECX

; ------------- Register IRQ device

		mov	ebx,SYSDev	; EBX <- device descriptor
		xor	ecx,ecx		; ECX <- 0, no parent device
		call	DevRegister	; register device

; ------------- Pop registers

		pop	ecx		; pop ECX
		pop	ebx		; pop EBX
		ret

; -----------------------------------------------------------------------------
;                           Uninstall SYS device
; -----------------------------------------------------------------------------
; OUTPUT:	CY = error
; -----------------------------------------------------------------------------

; ------------- Push registers

SYSUninstall:	push	ebx		; push EBX

; ------------- Unregister SYS device

		mov	ebx,SYSDev	; EBX <- device descriptor
		call	DevUnregister	; unregister device

; ------------- Pop registers

		pop	ebx		; pop EBX
		ret

; -----------------------------------------------------------------------------
;                   Driver function: Initialize SYS device
; -----------------------------------------------------------------------------
; INPUT:	EBX = device descriptor DEVSYS
; OUTPUT:	CY = error
; -----------------------------------------------------------------------------

SYSDevInit:	clc			; clear error flag
		ret

; -----------------------------------------------------------------------------
;                   Driver function: Deinitialize SYS device
; -----------------------------------------------------------------------------
; INPUT:	EBX = device descriptor DEVSYS
; OUTPUT:	CY = error
; -----------------------------------------------------------------------------

SYSDevDeinit:	clc			; clear error flag
		ret

; -----------------------------------------------------------------------------
;                              Constant Data
; -----------------------------------------------------------------------------

		CONST_SECTION

; ------------- Text strings

		align	4, db 0
SYSDevName:	CTEXTDATA 'kernel'
SYSDevShort:	CTEXTDATA 'System kernel'

SYSDevFull:	LANGTEXTSTR SYSDevFullEN,LANG_ENGLISH,SUBLANG_DEFAULT,2
 		LANGTEXTSTR SYSDevFullCZ,LANG_CZECH,  SUBLANG_DEFAULT,0

SYSDevFullEN:	CTEXTDATA 'System kernel'
SYSDevFullCZ:	CTEXTDATA 'J',0c3h,0a1h,'dro syst',0c3h,0a9h,'mu'

SYSDevInt:	dd	DEV_GEN_ID
		dd	DEV_SYS_ID
		dd	DEV_NUL_ID

SYSDevRes1Name:	CTEXTDATA 'null page'
SYSDevRes2Name:	CTEXTDATA 'code16'
SYSDevRes3Name:	CTEXTDATA 'data16'
SYSDevRes4Name:	CTEXTDATA 'code32'
SYSDevRes5Name:	CTEXTDATA 'data32'
SYSDevRes6Name:	CTEXTDATA 'const'
SYSDevRes7Name:	CTEXTDATA 'fixup'
SYSDevRes8Name:	CTEXTDATA 'except'
SYSDevRes9Name:	CTEXTDATA 'except2'
SYSDevRes10Name:CTEXTDATA 'bss16'
SYSDevRes11Name:CTEXTDATA 'bss32'

; -----------------------------------------------------------------------------
;                                   Data
; -----------------------------------------------------------------------------

		DATA_SECTION

; ------------- System device descriptor

		align	4, db 0
SYSDevice:	dd	SYSDev			; current system device descr.

; ------------- System kernel descriptor

%define		SYSDevVendor  DefaultVendor

		align	8, db 0
SYSDev:		DEVICESYS DEV_STATIC,1,0,0,SYSDev

SYSDevRes1:	DEVRESOURCE SYSDevRes2,SYSDevRes0,0,0fffh, \
		DEVRES_MEM,DEVRES_STATIC,SYSDevRes1Name

SYSDevRes2:	DEVRESOURCE SYSDevRes3,SYSDevRes1,Code16Start-SYSTEM_ADDR,\
		Code16End-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes2Name

SYSDevRes3:	DEVRESOURCE SYSDevRes4,SYSDevRes2,Data16Start-SYSTEM_ADDR,\
		Data16End-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes3Name

SYSDevRes4:	DEVRESOURCE SYSDevRes5,SYSDevRes3,CodeStart-SYSTEM_ADDR,\
		CodeEnd-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes4Name

SYSDevRes5:	DEVRESOURCE SYSDevRes6,SYSDevRes4,DataStart-SYSTEM_ADDR,\
		DataEnd-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes5Name

SYSDevRes6:	DEVRESOURCE SYSDevRes7,SYSDevRes5,ConstStart-SYSTEM_ADDR,\
		ConstEnd-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes6Name

SYSDevRes7:	DEVRESOURCE SYSDevRes8,SYSDevRes6,FixStart-SYSTEM_ADDR,\
		FixEnd-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes7Name

SYSDevRes8:	DEVRESOURCE SYSDevRes9,SYSDevRes7,ExcStart-SYSTEM_ADDR,\
		ExcEnd-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes8Name

SYSDevRes9:	DEVRESOURCE SYSDevRes10,SYSDevRes8,Exc2Start-SYSTEM_ADDR,\
		Exc2End-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes9Name

SYSDevRes10:	DEVRESOURCE SYSDevResN,SYSDevRes9,BSS16Start-SYSTEM_ADDR,\
		BSS16End-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes10Name

SYSDevResN:	DEVRESOURCE SYSDevRes0,SYSDevRes10,BSSStart-SYSTEM_ADDR,\
		BSSEnd-1-SYSTEM_ADDR,DEVRES_MEM,DEVRES_STATIC,SYSDevRes11Name
