; =============================================================================
;
;                           Litos - Fonts
;
; =============================================================================

		CODE_SECTION

; -----------------------------------------------------------------------------
;                    Initialize font tables
; -----------------------------------------------------------------------------

FontInit:	mov	ebx,F14		; EBX <- font 8x14
		call	FixFontInit	; initialize font
%ifndef MINI
		mov	ebx,F10		; EBX <- font 8x10
		call	FixFontInit	; initialize font
%endif
		mov	ebx,F08		; EBX <- font 8x8
		call	FixFontInit	; initialize font
		ret

; -----------------------------------------------------------------------------
;                       Initialize one fixed font
; -----------------------------------------------------------------------------
; INPUT:	EBX = font head
; DESTROYS:	EAX, ECX, EDX, ESI, EDI
; -----------------------------------------------------------------------------

; ------------- Prepare font data

FixFontInit:	lea	edx,[ebx+FIXFONT_Data] ; EDX <- start of font data

; ------------- Prepare to initialize one character

FixFontInit2:   mov	esi,edx		; ESI <- start of font
		lodsb			; AL <- number of codes
		and	al,FIXFONT_MASK	; mask number of codes
		movzx	ecx,al		; ECX <- number of codes

; ------------- Get one code

FixFontInit4:	lodsw			; AX <- Unicode code
		movzx	edi,ah		; EDI <- page index

; ------------- Get page address (-> EDI)

		shl	edi,2		; EDI <- offset of page address
		add	edi,[ebx+FIXFONT_Map] ; EDI <- table from Unicode
		cmp	dword [edi],byte 0 ; is subpage already allocated?
		jne	FixFontInit6	; page is already allocated

; ------------- Allocate new subpage

		mov	ebp,[FixFontFromNext] ; ECX <- next subpage
		add	dword [FixFontFromNext],4*256 ; shift pointer to next subpage
		mov	[edi],ebp	; store pointer to subpage

; ------------- Store character into page

FixFontInit6:	mov	edi,[edi]	; EDI <- page address
		movzx	eax,al		; EDI <- offset of the character
		mov	[eax*4+edi],edx	; store character

; ------------- Next code

		loop	FixFontInit4	; next code

; ------------- Next character

		add	esi,[ebx+FIXFONT_Height] ; ESI <- skip font data
		mov	edx,esi		; EDX <- next character
		cmp	edx,[ebx+FIXFONT_End] ; end of data?
		jb	FixFontInit2	; next character
		ret

; -----------------------------------------------------------------------------
;                        Check fixed fonts
; -----------------------------------------------------------------------------

%ifdef DEBUG_FONTNUM

; ------------- Prepare font data

FixFontTest:	lea	edx,[ebx+FIXFONT_Data] ; EDX <- start of font data
		xor	ebp,ebp		; EBP <- 0, font counter

; ------------- Prepare to initialize one character

FixFontTest2:   mov	esi,edx		; ESI <- start of font
		lodsb			; AL <- number of codes
		and	al,FIXFONT_MASK	; mask number of codes
		movzx	ecx,al		; ECX <- number of codes
		inc	ebp		; increase font counter

; ------------- Get one code

FixFontTest4:	lodsw			; AX <- Unicode code
		loop	FixFontTest4	; next code

; ------------- Next character

		add	esi,[ebx+FIXFONT_Height] ; ESI <- skip font data
		mov	edx,esi		; EDX <- next character
		cmp	edx,[ebx+FIXFONT_End] ; end of data?
		jb	FixFontTest2	; next character

		xor	eax,ebp		; EAX <- font number
		call	DebOutNum	; display number of fonts
		call	DebOutSpc	; display space character
		ret

%endif

; -----------------------------------------------------------------------------
;                 Get maximal Unicode character from fonts
; -----------------------------------------------------------------------------

%ifdef DEBUG_CODEPAGE

; ------------- Prepare font data

FixFontMaxChar:	lea	ebp,[ebx+FIXFONT_Data] ; EBP <- start of font data

; ------------- Prepare to initialize one character

FixFontMaxChar2:mov	esi,ebp		; ESI <- start of font
		lodsb			; AL <- number of codes
		and	al,FIXFONT_MASK	; mask number of codes
		movzx	ecx,al		; ECX <- number of codes

; ------------- Get one code

FixFontMaxChar4:lodsw			; AX <- Unicode code
                cmp	eax,edx
		jb	FixFontMaxChar6
		xchg	eax,edx
FixFontMaxChar6:loop	FixFontMaxChar4	; next code

; ------------- Next character

		add	esi,[ebx+FIXFONT_Height] ; ESI <- skip font data
		mov	ebp,esi		; EDX <- next character
		cmp	ebp,[ebx+FIXFONT_End] ; end of data?
		jb	FixFontMaxChar2	; next character
		ret
%endif

; -----------------------------------------------------------------------------
;                                   Data
; -----------------------------------------------------------------------------

		DATA_SECTION

FixFontFromNext:dd	FixFontFromSub	; pointer to next subtable from Unicode

; -----------------------------------------------------------------------------
;                            Uninitialized data
; -----------------------------------------------------------------------------

		BSS_SECTION

; ------------- Subtables from Unicode (45 KB)

		align	4, resb 1
FixFontFromSub:	resb	300*256
FixFontFromSub2:
