; =============================================================================
;
;                           Litos - Data device
;
; =============================================================================

		CODE_SECTION

; -----------------------------------------------------------------------------
;                                  Open data device
; -----------------------------------------------------------------------------
; OUTPUT:	CY = error
; -----------------------------------------------------------------------------

DataDevOpen:	DEVFNC	DDEV_Open

; -----------------------------------------------------------------------------
;                                 Close data device
; -----------------------------------------------------------------------------
; OUTPUT:	CY = error
; -----------------------------------------------------------------------------

DataDevClose:	DEVFNC	DDEV_Close

; -----------------------------------------------------------------------------
;                              Read data from device
; -----------------------------------------------------------------------------
; INPUT:	EDX:EAX = data offset
;		EBX = data device DATADEV
;		ECX = data length (bytes)
;		ESI = data buffer
; OUTPUT:	EAX = bytes OK read
;		CY = error
; -----------------------------------------------------------------------------

DataDevRead:	DEVFNC	DDEV_Read

; -----------------------------------------------------------------------------
;                              Write data to device
; -----------------------------------------------------------------------------
; INPUT:	EDX:EAX = data offset
;		EBX = data device DATADEV
;		ECX = data length (bytes)
;		ESI = data buffer
; OUTPUT:	EAX = bytes OK written
;		CY = error
; -----------------------------------------------------------------------------

DataDevWrite:	DEVFNC	DDEV_Write

; -----------------------------------------------------------------------------
;                              Verify data from device
; -----------------------------------------------------------------------------
; INPUT:	EDX:EAX = data offset
;		EBX = data device DATADEV
;		ECX = data length (bytes)
; OUTPUT:	EAX = bytes OK verified
;		CY = error
; -----------------------------------------------------------------------------

DataDevVerify:	DEVFNC	DDEV_Verify

; -----------------------------------------------------------------------------
;                            Compare data from device
; -----------------------------------------------------------------------------
; INPUT:	EDX:EAX = data offset
;		EBX = data device DATADEV
;		ECX = data length (bytes)
;		ESI = data buffer
; OUTPUT:	EAX = bytes OK compared
;		CY = error
; -----------------------------------------------------------------------------

DataDevComp:	DEVFNC	DDEV_Compare

; -----------------------------------------------------------------------------
;                              Lock door of data device
; -----------------------------------------------------------------------------
; INPUT:	AL = 0 unlock door, <> 0 lock door
; OUTPUT:	CY = error
; -----------------------------------------------------------------------------

DataDevLockDoor:DEVFNC	DDEV_LockDoor

; -----------------------------------------------------------------------------
;                              Get door open status
; -----------------------------------------------------------------------------
; OUTPUT:	EAX = 0 door is open
;		      1 door is close and empty
;		      2 door is close with media
;		CY = error
; -----------------------------------------------------------------------------

DataDevGetOpen:	DEVFNC	DDEV_GetOpen

; -----------------------------------------------------------------------------
;                            Set door open status
; -----------------------------------------------------------------------------
; INPUT:	AL = 0 open door, <> 0 close door
; OUTPUT:	CY = error
; -----------------------------------------------------------------------------

DataDevSetOpen:	DEVFNC	DDEV_SetOpen

; -----------------------------------------------------------------------------
;                              Test media change
; -----------------------------------------------------------------------------
; OUTPUT:	EAX = 0 media not changed, <> 0 media changed
;		CY = error
; -----------------------------------------------------------------------------

DataDevChanged:	DEVFNC	DDEV_Changed
