
// ****************************************************************************
//
//                           Bernoulli numbers
//
// ****************************************************************************
//#define BIGINT_BERN_NUM 512	// number of table Bernoulli numbers (only even numbers B2, B4,..)

//Big integer - constant
//typedef struct
//{
//	const u32*	data;	// array of segments
//	int			num;	// number of segments (0=zero number)
//	Bool		sign;	// sign flag
//} cbigint;

#ifdef GENERATOR
#include "bernoulli/include.h"
#else
#include "../include.h"
#endif

// Bernoulli numbers - numerators, data
const u32 bern_num_data0[1] = { 0x00000001 };
const u32 bern_num_data1[1] = { 0x00000001 };
const u32 bern_num_data2[1] = { 0x00000001 };
const u32 bern_num_data3[1] = { 0x00000001 };
const u32 bern_num_data4[1] = { 0x00000005 };
const u32 bern_num_data5[1] = { 0x000002b3 };
const u32 bern_num_data6[1] = { 0x00000007 };
const u32 bern_num_data7[1] = { 0x00000e21 };
const u32 bern_num_data8[1] = { 0x0000ab5b };
const u32 bern_num_data9[1] = { 0x0002aa13 };
const u32 bern_num_data10[1] = { 0x000d09f1 };
const u32 bern_num_data11[1] = { 0x0e16a13b };
const u32 bern_num_data12[1] = { 0x0082828f };
const u32 bern_num_data13[2] = { 0x87940425, 0x00000005 };
const u32 bern_num_data14[2] = { 0x0828a065, 0x000007d6 };
const u32 bern_num_data15[2] = { 0xf7579541, 0x00000702 };
const u32 bern_num_data16[2] = { 0x2a2b4cbf, 0x00000258 };
const u32 bern_num_data17[3] = { 0x9fb1c9fd, 0x6d32a00d, 0x00000001 };
const u32 bern_num_data18[2] = { 0x5e6db797, 0x000a68d0 };
const u32 bern_num_data19[3] = { 0x6e284f03, 0x27402532, 0x0000000e };
const u32 bern_num_data20[3] = { 0x2cd66903, 0x6797b152, 0x00000052 };
const u32 bern_num_data21[3] = { 0x539cfe0f, 0xd8358f64, 0x000005e4 };
const u32 bern_num_data22[3] = { 0x97429c89, 0xadf6e53c, 0x00007e4d };
const u32 bern_num_data23[3] = { 0xc21b3e7b, 0xf3642920, 0x121ffd5d };
const u32 bern_num_data24[3] = { 0x95fbe655, 0xdf10bb0f, 0x01998070 };
const u32 bern_num_data25[4] = { 0x05a55f6d, 0x2b9dbb0b, 0x1cb4bfde, 0x0000000a };
const u32 bern_num_data26[4] = { 0x2a855f53, 0xc7eda8fe, 0xec9cc680, 0x0000016f };
const u32 bern_num_data27[4] = { 0xae76237d, 0xf5724965, 0x56a20769, 0x00007a3e };
const u32 bern_num_data28[4] = { 0xefe92f35, 0x33a99b09, 0x1d809ea7, 0x0010455d };
const u32 bern_num_data29[5] = { 0xa7e64393, 0x5047daa8, 0x6a343f43, 0x3fcd7789, 0x00000df3 };
const u32 bern_num_data30[4] = { 0xf5e55927, 0xd9547361, 0x5d50d145, 0x094101af };
const u32 bern_num_data31[5] = { 0xae210b81, 0x7f11711c, 0x9aabfc7c, 0xcf399b16, 0x00000139 };
const u32 bern_num_data32[5] = { 0x2a70b25d, 0x5feb781d, 0x86dff384, 0x847fd772, 0x0042089e };
const u32 bern_num_data33[5] = { 0x9a363c79, 0xb76765ed, 0x32c16ca9, 0x6d0164e1, 0x00038845 };
const u32 bern_num_data34[6] = { 0x515a816b, 0x340ad867, 0x97a3a66f, 0x0f1d5e8b, 0x07afa25e, 0x00000001 };
const u32 bern_num_data35[6] = { 0x9315664d, 0xd17be20c, 0x7e590205, 0x12515c30, 0x9a3e273f, 0x003cd8c0 };
const u32 bern_num_data36[6] = { 0x46e465af, 0x22d78d22, 0x4fc8423e, 0x0323a2d3, 0x5e375b58, 0x00000017 };
const u32 bern_num_data37[6] = { 0xca7ffb09, 0xbcfbfefe, 0xf0e2f29a, 0xd6ce058e, 0xb24381a3, 0x000041e5 };
const u32 bern_num_data38[6] = { 0x9eb45c9f, 0x774cc3b7, 0x1191ea30, 0xf685050b, 0xdc714e8b, 0x10eb32b9 };
const u32 bern_num_data39[7] = { 0x41f609a3, 0xb6fe7c5d, 0x72e59e07, 0x0e0046e1, 0x747768a8, 0x6cd6d086, 0x000002dd };
const u32 bern_num_data40[7] = { 0x6809594d, 0xa5075f24, 0x816bfbb7, 0x82f2c644, 0x70d12bc3, 0x29ecac44, 0x0000010b };
const u32 bern_num_data41[7] = { 0x93e13f3d, 0xfe6d75ca, 0xe63aa1cd, 0x9f3dac68, 0x046ff4c6, 0x1f2002a1, 0x133978dc };
const u32 bern_num_data42[7] = { 0xd79084b7, 0x962077bf, 0x791166f6, 0x8aae8d75, 0x386304fb, 0xe95d0d91, 0x00019b29 };
const u32 bern_num_data43[8] = { 0x2f64badf, 0x2f2c2aa8, 0x3fc9e873, 0xd554d3d2, 0x1afbf274, 0x242495c8, 0xa4bd337b, 0x00000030 };
const u32 bern_num_data44[8] = { 0x61976d67, 0xb89a85ca, 0x124d88bc, 0xd852b7e8, 0x18cce492, 0x95346a54, 0xaa44e228, 0x0000aad5 };
const u32 bern_num_data45[8] = { 0x53e67587, 0x6cd99b8d, 0x60c5595b, 0xbe2c3fa0, 0x9d05c713, 0xa120545f, 0xf42443c5, 0x0000bbb7 };
const u32 bern_num_data46[8] = { 0x2ebab1e7, 0xd6ea05c6, 0x0d671282, 0xe74acaef, 0x8f6adc1f, 0xe7ec42f8, 0x803490f4, 0x0000b0e2 };
const u32 bern_num_data47[9] = { 0xfcbe99bb, 0xf4ff3683, 0x8ba43b65, 0x5dd07a32, 0xf53b1c62, 0x20d18760, 0x0be6048d, 0x6aca47d0, 0x00000723 };
const u32 bern_num_data48[8] = { 0xf898c63f, 0xed452f06, 0x9fa06d10, 0xc25cf05d, 0x1edd6fa9, 0x21c31e20, 0xb44a3f7a, 0x9622b6a5 };
const u32 bern_num_data49[9] = { 0x433468df, 0x2f4d0e7b, 0x7e797acd, 0xb5944a5e, 0xa6ebf5a3, 0xe99995ed, 0xe3d14e99, 0x997e8aea, 0x000c7744 };
const u32 bern_num_data50[9] = { 0x3ff729c7, 0xf3b5ac7f, 0xf12b9cd8, 0x397d5914, 0xb1082554, 0xcdac622b, 0xecdbd340, 0xaf9cfcdf, 0x01a637b3 };
const u32 bern_num_data51[9] = { 0x77980375, 0xb3d7804c, 0x5e53b8d9, 0xfb79da5f, 0x1a3f3125, 0x0ae699a1, 0xce9e8a2d, 0x7abd271a, 0xa47b55bb };
const u32 bern_num_data52[10] = { 0x7e944c65, 0x04e86848, 0x64875b1d, 0x21a464fd, 0xf35f8288, 0x33cf96da, 0x1464a64b, 0x68981c30, 0x23ad1715, 0x00000049 };
const u32 bern_num_data53[11] = { 0x5e0b9bc9, 0xd60ca7cc, 0xf98355e8, 0xccada531, 0x1d455166, 0x503db7da, 0xeec289d3, 0x49daa85d, 0x8d1dc292, 0x9fcdc892, 0x00000001 };
const u32 bern_num_data54[10] = { 0xc4e5182b, 0x22b77e46, 0x4734b5b1, 0x8059051c, 0x833e512f, 0x498da98a, 0x7bfb8a23, 0xf656ecac, 0x92fb2abd, 0x00ea97d4 };
const u32 bern_num_data55[11] = { 0x4117002d, 0x605b8b71, 0x651b4a70, 0xbf72e68b, 0x82be0e00, 0xb52cf656, 0xd4b918f0, 0x12d42690, 0xab427a9b, 0x0e585391, 0x000004d9 };
const u32 bern_num_data56[11] = { 0x5a505c59, 0x2d715931, 0x00f87ef8, 0x4c9e5061, 0xdfb2ed27, 0xb1982767, 0x9eae6fcd, 0xe95a262f, 0x2736d96d, 0x2d4c90f1, 0x0000000a };
const u32 bern_num_data57[11] = { 0xf9c58903, 0x626aa61b, 0x15e61fa9, 0x50496b2f, 0x1852f3bf, 0xe27e1e7f, 0x30710e43, 0x70aaac12, 0x406b8cb1, 0x200b403e, 0x0002361b };
const u32 bern_num_data58[11] = { 0x09459577, 0x66b747e7, 0x258a6429, 0x0c800670, 0x49c7e779, 0xf797318a, 0x73b331d9, 0xd344a384, 0x20f27418, 0x41950dbc, 0x00029f18 };
const u32 bern_num_data59[12] = { 0x3a1ffa73, 0x1097f892, 0xf57ecf67, 0xa0e798f1, 0x2111556a, 0xf6f1d67e, 0x9e876528, 0xc93a1423, 0xca3eb62c, 0x3e33fa9d, 0x5049fb29, 0x0055abae };
const u32 bern_num_data60[12] = { 0xbac570cf, 0xdfe022dc, 0x0dd71c9a, 0xb9ffdfe0, 0xc7881716, 0xdb160a31, 0x23599a04, 0xf685b5e7, 0xd1e0ef11, 0xff479520, 0x69069737, 0x00000005 };
const u32 bern_num_data61[12] = { 0x0c08c869, 0x7c6f0ed5, 0x031c9949, 0x31640d0b, 0x086615f2, 0x92093623, 0x929f7c0a, 0x4735a013, 0xba0b9f05, 0x18e5cc3b, 0xee1e4628, 0x000028d2 };
const u32 bern_num_data62[13] = { 0xe3ab07bf, 0xcf99f4c9, 0x93b87fd4, 0x895f3aa8, 0x75dfca6d, 0xd7951751, 0xae982eae, 0xdfe0d97b, 0x5b2718a3, 0xccf0b645, 0x0bcfcbca, 0x0434cfd6, 0x0000008d };
const u32 bern_num_data63[13] = { 0x62899801, 0x5971f672, 0xbb8e5eab, 0xc0b5ea74, 0xcfdc0712, 0x984c9c89, 0x8d53fb98, 0xf192e34d, 0x386383f8, 0xbcf8504b, 0x0bf8ad4e, 0xcba32f41, 0x00000006 };
const u32 bern_num_data64[13] = { 0x5031cd5f, 0x6ccaf707, 0xdc9806bd, 0xc689b117, 0x5a4f0d9c, 0x4a69a893, 0x0f35c7b8, 0x25ebad9c, 0x92910057, 0x0b6e9fdd, 0x90989c30, 0xfac9e664, 0x0000bf28 };
const u32 bern_num_data65[14] = { 0xbd4a948f, 0x2fef024a, 0xc6ccfdb6, 0xabf4cab7, 0x21a72207, 0x4ac179a2, 0x10381a27, 0x409a807e, 0x4491f792, 0xf7d66d56, 0x322c3d1f, 0xe9e16656, 0x6da8eb14, 0x00000002 };
const u32 bern_num_data66[13] = { 0xb7e379d7, 0xd21d75e2, 0x8f2cff67, 0xbcdd25d2, 0x6a333719, 0x56f16dcf, 0xf487b367, 0x52e8a20a, 0xcd8b2699, 0x2141c728, 0xe95901bf, 0xab595d08, 0x00667708 };
const u32 bern_num_data67[14] = { 0x094c6d09, 0x4f305b92, 0x98155679, 0x30b213ba, 0x1ccdf50c, 0x3b1cea32, 0x4050b595, 0x2b7e89c4, 0xa0e8d8d1, 0x4e5111e2, 0xdfaaadba, 0x60cac802, 0x1474e760, 0x000001f2 };
const u32 bern_num_data68[14] = { 0x351cf8ed, 0x92bc0475, 0x4ede97a0, 0x4abc7cbb, 0x43b9fd64, 0x0bf439b1, 0x7ec5a252, 0xf8e254e4, 0x03e4ffd0, 0xcc3a88ef, 0xc06ac603, 0xebbe7caa, 0xf199ff39, 0x00f2fc1c };
const u32 bern_num_data69[15] = { 0x5c1947c1, 0x47f8388a, 0xc6ce0d82, 0xb0fc29a2, 0xc216f2c0, 0x459f2c44, 0x49642524, 0xac4f4f28, 0xd12a326e, 0xbf7e996b, 0xa5c36531, 0x4b35a627, 0x57e904e0, 0x86979bda, 0x00000004 };
const u32 bern_num_data70[14] = { 0x44848307, 0x4a2934e9, 0x96ea3a12, 0xe987d72b, 0x0e8cb359, 0x8f3af804, 0xab4efabe, 0x64807627, 0x3e84f98c, 0x8989d9e2, 0xdabb2d78, 0x680b9c98, 0x42678e34, 0x05304f37 };
const u32 bern_num_data71[15] = { 0x17bf06ed, 0xd8677a2d, 0x9de06343, 0x1f0ff3d5, 0x543ff458, 0xb7b0bdc1, 0x656caf21, 0xef5510b9, 0xb3f31279, 0x68dc597e, 0x8bbd7801, 0x712b5a18, 0xcf1414b9, 0xff93a54f, 0xfa22e4c8 };
const u32 bern_num_data72[15] = { 0xc7b0e55f, 0xe11b4aeb, 0xc1cbc94d, 0xc4a3ba68, 0xbbe6a15b, 0x4969043d, 0x25f7e411, 0x1e72a06b, 0x4fcb3ebf, 0xfdf231d2, 0xd1a209e5, 0x7b7a1e64, 0x3068d227, 0x2ab8f455, 0x00001625 };
const u32 bern_num_data73[15] = { 0xdba8f28d, 0x53a342d3, 0xdd23c2ff, 0xb66920e4, 0x9d314e41, 0xcbe1f510, 0x592525a5, 0xfbd5c76a, 0xa6db6639, 0x6ddc48b0, 0xc324f964, 0xc11bb5a2, 0x6d2a72fb, 0xce005575, 0x8abb4070 };
const u32 bern_num_data74[16] = { 0x73417ba3, 0xdd5f1de5, 0x3620948a, 0x96c525ad, 0x82028b3e, 0x49b6256e, 0xe503131e, 0xb20848b1, 0x9d764bad, 0xcd3de049, 0xebea931e, 0x32cb07b0, 0xdf241d36, 0x303d12c1, 0x6c45e5f3, 0x000243cf };
const u32 bern_num_data75[16] = { 0xeda861a1, 0x53187949, 0xd799872b, 0xeaa7a2eb, 0x545458f4, 0x3bd92084, 0x6ed5d765, 0xc872d37f, 0xf23daf9d, 0x1479931c, 0xf3455958, 0x51947b47, 0x050c880b, 0x630567c6, 0x1761c335, 0x000004ad };
const u32 bern_num_data76[16] = { 0x8937afd9, 0xc28ccb99, 0x70c03feb, 0xb994aaea, 0x225748db, 0xbcff913d, 0xcc075375, 0x054c31f0, 0x81ca9dc0, 0x2fd3c379, 0xf2e98bee, 0xb70ea33a, 0x8050e502, 0x9408860e, 0x7e58d256, 0x00322601 };
const u32 bern_num_data77[17] = { 0xd9a26e5d, 0xa449d8c5, 0x6183627e, 0x97cd4404, 0x4f764e1e, 0x9ce0fafd, 0x9dc354d7, 0x6eb26436, 0x35153418, 0xb0c9f5d5, 0xe4754fa1, 0x431649b5, 0x2b428653, 0xcd8cb2cb, 0x7e9ca983, 0x4c9228f4, 0x005cffdd };
const u32 bern_num_data78[17] = { 0x74984367, 0x7641bc0b, 0x23677a27, 0x753894c2, 0xc8a63bf5, 0x867caf70, 0x59358393, 0xb0044e43, 0x0e093cb4, 0x49328785, 0x1e91fb6a, 0x400ec4d0, 0xe379a5ef, 0xf49a6d4a, 0x94a77bcc, 0xcdce90b4, 0x0000000c };
const u32 bern_num_data79[17] = { 0x406afc83, 0x4af9d695, 0xb68fc655, 0xc4d7f639, 0xb098c702, 0xfa6df268, 0x698447f7, 0xf72eb54c, 0xa9193dc3, 0x91c6e3c5, 0xa63546b7, 0xaecdfe66, 0x032b7154, 0xd00546fe, 0x99cb998a, 0xf7b26904, 0x12da5277 };
const u32 bern_num_data80[18] = { 0x6c89bf91, 0x2668d383, 0x33c4884e, 0xf2d67b59, 0xbb68600f, 0xef41b10b, 0x1fef8246, 0xa022af12, 0xb6eab8c2, 0x8e102e14, 0xaccad23a, 0x8297d348, 0xef22f42d, 0xb6cf4511, 0x72a16c48, 0x77781c3f, 0x83b4f3fc, 0x0000001b };
const u32 bern_num_data81[18] = { 0x35dc377b, 0x41ece66b, 0x95d9b170, 0xcd891eea, 0x6e18fb66, 0xd8e232ca, 0xe77dbb6d, 0xb477e51c, 0x82e5fe0c, 0xc2ac1528, 0x20aaab2e, 0x0bf841e5, 0xd1f77e4d, 0x85664f67, 0x7f724c9d, 0xf16b0379, 0xa6535b7f, 0x00000164 };
const u32 bern_num_data82[18] = { 0x875a7881, 0xeb97106b, 0x86d96739, 0x62aeb3a1, 0x8729e006, 0x418981ab, 0xdef8af19, 0x7b160262, 0x90437d75, 0x2f8ae986, 0xc3b04e07, 0xac749ce2, 0xc406fe1e, 0x4bfacf08, 0x9440a43f, 0x98610809, 0x37e7aebb, 0x000184f5 };
const u32 bern_num_data83[19] = { 0xf04ec905, 0x39ab7aa0, 0x7db908f8, 0xec59208e, 0x925d16c6, 0x135eec11, 0xe63ea812, 0xd48cb7fa, 0xb1698940, 0x3c5ebde5, 0xf1bae9b1, 0x175f4658, 0x2251a78f, 0x261765f2, 0x912bdbb8, 0x574d66de, 0xd9a80f6d, 0xfa208c8f, 0x00000037 };
const u32 bern_num_data84[18] = { 0xf4ba0b45, 0xbdb61b56, 0x5b020710, 0x505d5369, 0xb2547dd5, 0x754563e9, 0xafa2d5dd, 0x0a1411a2, 0xfd028d08, 0x3e397ad8, 0x90b33971, 0x48921326, 0xd921e971, 0xb18b8894, 0x28568ccd, 0x4b942edb, 0x07afc7e8, 0xca2e6311 };
const u32 bern_num_data85[19] = { 0xb02990d5, 0x28f12288, 0xd09f54e6, 0x0431985a, 0xe442c511, 0xe1e36c6d, 0x5f85d56e, 0xb8010328, 0x19d442ba, 0x83dc3ba2, 0x373971c6, 0xdbd88112, 0xa6e0d1ec, 0x328305a2, 0x950cefb3, 0xe74b816f, 0xca0ffbb5, 0xe2e11f7b, 0x0000b4bc };
const u32 bern_num_data86[19] = { 0x2336600b, 0xbcb022fd, 0x95e65f90, 0x1c7b52f1, 0xc7e230bc, 0xb9e15922, 0x7dd41133, 0x2f59a981, 0x3ab6b5d6, 0x7d107a38, 0xded91bef, 0x94f6f3da, 0x65a92d18, 0x6a0bb1f4, 0x0fb190aa, 0x20a47d22, 0xbaac2c6a, 0xa089ae8c, 0x010106e6 };
const u32 bern_num_data87[20] = { 0xbc6a1a9f, 0x0969b17f, 0xd72f5693, 0x33f487f8, 0x4b1e47d1, 0xd4f5ad5b, 0xb0cc5457, 0xd52985fa, 0xd8a88625, 0xce67b56c, 0x0f9ed527, 0x2742a8e8, 0x221f6f60, 0xb5842236, 0x713b3fec, 0x47664fa5, 0xe48c0420, 0xa2a171de, 0x11df8831, 0x00000509 };
const u32 bern_num_data88[20] = { 0x3910fbad, 0x67cffb9a, 0xa0685677, 0x1bc3808b, 0x9d37ec22, 0x8ac63427, 0xbb32428e, 0x11e009c7, 0xe519922b, 0x3081abcd, 0x96483266, 0x2aced3e2, 0x22a27fd4, 0x8f727273, 0x5cb9b688, 0x953982f3, 0x3b13c06a, 0xcb82cac0, 0x57adba56, 0x00000422 };
const u32 bern_num_data89[21] = { 0xcd08a241, 0x2558d03d, 0x76901647, 0xc5ff8db6, 0x7298b59c, 0xb70ec13a, 0x8919c115, 0x3720bcdf, 0xffa0d860, 0xb89f0ab1, 0x0dce37e8, 0x19ef2414, 0xeedb6fef, 0x4a770587, 0x2d5c888c, 0x64353079, 0x0f5c524b, 0x63552066, 0x7d6771d4, 0xd1bb232a, 0x0014a549 };
const u32 bern_num_data90[20] = { 0x439a96f7, 0x8affdf05, 0xacd1ea3e, 0x22066ca1, 0x470da1b7, 0xff4a0f80, 0x82d9f671, 0x09e00ec5, 0x339d644f, 0x79c3558d, 0x38aa7e02, 0xe31a8223, 0x90c69413, 0xc45885c9, 0xd3a09971, 0xde712e4c, 0xc240838d, 0xe8630251, 0x24784443, 0x003d7092 };
const u32 bern_num_data91[21] = { 0x8ebefe4f, 0xd4663802, 0x1583ff01, 0xfd39b1de, 0x01ad06bf, 0xf706cc3e, 0xdddcf204, 0x018200ee, 0x5f35974f, 0xd02c90cc, 0xf2f7400f, 0x0a4d510a, 0x292622cb, 0x01e72ba3, 0x29b953c7, 0x545627ee, 0x363a2fc8, 0x7edcfae6, 0x6ad3ca1f, 0xe892e451, 0x000000bb };
const u32 bern_num_data92[21] = { 0xbe4bf829, 0x16a2278e, 0xbca1d7ce, 0x13f71fd2, 0x24981522, 0x13b13ec4, 0xe49171a8, 0xfc90ee82, 0xf38ca1cf, 0x0ab83057, 0x6df95de3, 0xc3ab52bd, 0xe7a825bb, 0x56cbb597, 0xfb567cb3, 0xc25f61ec, 0xc6827e4e, 0xf30bced6, 0xdd979774, 0xabbd93fe, 0x0000130e };
const u32 bern_num_data93[21] = { 0xa10c14e9, 0x8cbe87bc, 0xe173d18d, 0x3278301b, 0x5c5e5d23, 0x7509b596, 0xa87e389c, 0x01725ce6, 0x3c43b235, 0xfcdc281b, 0xb92cd801, 0x63f803b5, 0x88269122, 0x57a311b6, 0x6f177c62, 0xc74fc45e, 0xe92ea197, 0x73a76d7a, 0x3d34e4a2, 0x8dd0d019, 0x002f59f8 };
const u32 bern_num_data94[22] = { 0x1adaec13, 0xd4578f8b, 0x96f870a9, 0x52c4fccd, 0x4e7739d3, 0xa9ce8f99, 0x254af9c6, 0xb5b1903b, 0x27ceafd6, 0x53b9ab5c, 0x1be32413, 0xd07dbf8a, 0x9d53a7a3, 0x82deec92, 0xb788c03d, 0xdccc701d, 0x2e54d33f, 0xca717ec3, 0xd4da1277, 0xf495a8fa, 0x29a84b24, 0x00000114 };
const u32 bern_num_data95[23] = { 0xf5ec283b, 0x31556b4b, 0x4115002d, 0x49c734de, 0xf95aecc8, 0xb259ce4f, 0x64deb815, 0x63e7153d, 0x4161bd53, 0xdab88dce, 0x69b8d719, 0x84842016, 0xe0706c3b, 0x4438dd9d, 0x6c066fb3, 0x43203ca2, 0x2db3a68a, 0xc609e435, 0xa52e1357, 0xb35cea3a, 0x8261ab9b, 0x1ddc6a14, 0x00000004 };
const u32 bern_num_data96[22] = { 0xeb962c7f, 0xc8f6726d, 0xe50bf9fc, 0x90f7c1d6, 0x688d3044, 0x911276b8, 0x98c7a082, 0xdf72cb93, 0x2cf0a6cb, 0x7192f9db, 0xefa5557d, 0x93450018, 0x4bb291d8, 0x71f4f05b, 0x9216f585, 0x3ac05f4f, 0x01fbd4d6, 0x858979a5, 0xd275afa2, 0x71ece31e, 0x3a878336, 0x0001c459 };
const u32 bern_num_data97[23] = { 0x587a5149, 0xe79650c8, 0x74979fda, 0xb18e44de, 0x72d034fb, 0x632e8c33, 0xcd54f832, 0x1dbcfb18, 0x92d49f6d, 0xcfdf90bc, 0xc21dfa1a, 0xa4ce9eb6, 0x4c993ec1, 0x90fde09e, 0xb83f4ccf, 0x1cc426f7, 0xe8a96bdf, 0xf06e5b7b, 0xa3fbfc3a, 0x164bbc62, 0x49104736, 0x9f2124c5, 0x000002e9 };
const u32 bern_num_data98[23] = { 0x1a16c039, 0x2fa93194, 0xa1b86686, 0x6aedef17, 0x8fa4c8a8, 0xe0ceedde, 0xe9f44a7e, 0x23cc4ee1, 0x78709303, 0x4beebff9, 0xade4b3c6, 0x13bdefa1, 0x6f66010d, 0x74b62102, 0xe828e3fc, 0x86ee8ebe, 0xa88784a6, 0xbc564a1a, 0x9f3a98f7, 0xfea50f8e, 0x567164c9, 0x075e0f03, 0x3eb24eb8 };
const u32 bern_num_data99[24] = { 0x220044ef, 0x70b5ab76, 0x00411e63, 0xbb003141, 0xf1803754, 0x827a013d, 0x992c9800, 0xb65ffa77, 0xc6802120, 0xf1d568ed, 0x2bbbe5f0, 0x09287cae, 0xc6106646, 0x960333e6, 0xd308592c, 0x9eb1a318, 0xb9f63b00, 0x43861fac, 0x4b1c0292, 0x9decdcf8, 0x52877b46, 0x26c68b07, 0x60f62273, 0x00000001 };
const u32 bern_num_data100[23] = { 0xb2bff8af, 0x693d6304, 0xe250ff40, 0xe33c241e, 0x1341f4fb, 0xff52965b, 0xb7821a44, 0x4828e554, 0x7b4c6612, 0xed1b259e, 0x3c151e33, 0x95b50404, 0x9a3d1601, 0x840d5e9e, 0x22586622, 0x3aa282a3, 0x4b900b4a, 0xef7a9f91, 0x39517702, 0xa2342313, 0x7f3fca5a, 0xfbc1da30, 0x01980675 };
const u32 bern_num_data101[24] = { 0x48114d85, 0x9cebbff7, 0x789448f0, 0x853bbaf5, 0x1212af78, 0x875f1059, 0xc0d36876, 0x86121c8b, 0xb4909ead, 0x22a2d8c8, 0x60c049d3, 0x6a6ee1cb, 0xabc7e6a4, 0x2abd4958, 0xe8d250b1, 0xd897393b, 0x5cd4b602, 0x0328852e, 0xd7c502d0, 0xe3b5efde, 0xc12bf253, 0x20213419, 0x009f0f39, 0x0004ab97 };
const u32 bern_num_data102[24] = { 0xb5ccf487, 0x54eb2330, 0x78801bf0, 0xdc93708c, 0x1e52c0ee, 0xd4bb311b, 0x30c9a813, 0x1f42afb0, 0x635aa390, 0x1a8cb623, 0xf4149524, 0x91edc845, 0x65d6c339, 0xc1bc8696, 0xc5fd9aa9, 0x9b7798bc, 0x3f2b0d2c, 0x7e5c9b3f, 0xe918d6a8, 0x7506982b, 0x8730eaf6, 0xc8a4c90d, 0x1a0eff60, 0x00001b4a };
const u32 bern_num_data103[25] = { 0xdff9d055, 0xfd79de5d, 0xee2348e6, 0xb9f7398d, 0xf7d0a400, 0xc10e75b2, 0xbd9a726f, 0x3f5734e5, 0x18a83fc8, 0x3100eea5, 0xff68e5a9, 0xa013803e, 0x55405219, 0xbf4f3aca, 0x66c1f827, 0xf2385570, 0x8918bcd0, 0x997da7f3, 0x6753480d, 0x0a9e1c45, 0xbaab1308, 0x05b4fd84, 0x63a38438, 0xfde59db9, 0x00000007 };
const u32 bern_num_data104[25] = { 0xfb43bd2b, 0x6a22a9c3, 0xec068af6, 0xb5dc6188, 0x95b2fc43, 0xc596c85e, 0x8333a77a, 0xcd6a966e, 0x7e9dad4e, 0x3fe9b3c5, 0x76e4ccc6, 0x3e82b325, 0x71b97906, 0x208e3eb1, 0x588801a3, 0x31902716, 0x7f062d41, 0x14c61cbb, 0x14a739a3, 0xa35dee68, 0x8ef8f744, 0x106f2c03, 0xff86b106, 0xe4f6ab1a, 0xb4c1f37e };
const u32 bern_num_data105[25] = { 0xf90e0ff3, 0x6ea0358d, 0xb69ce29e, 0xbeaaef6b, 0x5602ff02, 0x8091e4a7, 0xe701bb99, 0xba1895b4, 0xec84c937, 0x9b4d709f, 0xcd9b5f77, 0x34129241, 0x18fa6475, 0xbc0e7a65, 0x4b2e50db, 0x051847fa, 0x0a6e2a75, 0x71eeafd0, 0xf8c379a8, 0xf5bab1ea, 0x806a3b98, 0xcbefc585, 0xd12cb709, 0x7eec898d, 0x00123e1c };
const u32 bern_num_data106[25] = { 0xe5fa87b7, 0xfb9c56f4, 0x1c9841a9, 0x9fcc4837, 0x9b6c2b04, 0x328a8569, 0xb113c08d, 0x6a07cd53, 0x97791c82, 0xc89b3c98, 0xe1364d64, 0x5a2af148, 0xc7836002, 0x948b2ae4, 0xcda89aa0, 0x8fca64a4, 0xeb7414d6, 0xc17c932f, 0x074083aa, 0x7356ca5c, 0x5b7bb7b0, 0x96358dff, 0x8a50ada6, 0x7aae6684, 0x00275ec2 };
const u32 bern_num_data107[26] = { 0xc7ceb9e9, 0x854c2648, 0x589c69d6, 0xc0092afd, 0x0099c707, 0x677354fc, 0xada52505, 0x4401aba4, 0xdf00a291, 0x0bdb456c, 0x1b8f450b, 0xf14b6e4c, 0xbda8fb75, 0x25f69571, 0x8c0faba5, 0xf22667b5, 0x65509ee8, 0x7abf50a6, 0xaf9c651a, 0x0f22e499, 0xaafcff66, 0x4dbd26bd, 0x93312abc, 0x262df489, 0xb2f8773b, 0x6b348800 };
const u32 bern_num_data108[26] = { 0x29d4ff0f, 0xe39677f3, 0x2dec2e21, 0xf899d0ed, 0x180162ce, 0x41dd49cc, 0x5530490e, 0x475ff738, 0x5cf9fc40, 0x1163f83f, 0x4a015f78, 0xacbf951c, 0x5b08e11c, 0x3ad0e3f2, 0x5b5c74e4, 0x9eb88ae9, 0x1710f851, 0x7f8b54d3, 0x2d209b7d, 0x05cf3b94, 0xcb834c1b, 0xb670ed49, 0x94434ba6, 0xdbc31f13, 0xca757c4f, 0x0000034e };
const u32 bern_num_data109[26] = { 0x9a828785, 0x97e29425, 0xa367c32b, 0x522a7652, 0x2603e906, 0x515428e2, 0xcccb9a2e, 0xb7851b74, 0x32cb07f6, 0x52218d66, 0x6a001180, 0x3780082f, 0x4cf99df9, 0x28c93733, 0x54ba05eb, 0x82e6d706, 0xd090f49a, 0xca625021, 0xecc5a7b9, 0xb5bf4a86, 0x0c4db065, 0x44e82698, 0xb2e27f55, 0xc1f4f508, 0x33aeb860, 0x4debbec8 };
const u32 bern_num_data110[27] = { 0xed49b48f, 0xd43bf319, 0x4c08b21d, 0x2f49afc0, 0x0527b2ed, 0xd07419e6, 0x43d9ca51, 0x2a271128, 0xc97d3bb5, 0xc11c67bc, 0x34c2a89a, 0x293937fe, 0x2a695e82, 0xd153a576, 0x25d14b4a, 0xf3d9f050, 0x932d1841, 0xaf179b84, 0xf6522871, 0x741494a1, 0xc100c871, 0x30aa9b50, 0x01431329, 0xf291b740, 0xcfda58f7, 0xc78d195a, 0x000001d2 };
const u32 bern_num_data111[27] = { 0xe08f588d, 0xe1777785, 0x31874fe6, 0x3bb7e40c, 0xb9bb0082, 0x7a96c38c, 0x1d3bdbac, 0x1cc6274d, 0x40562bea, 0x4a847653, 0xdbf5fe4d, 0xba6d4882, 0xd7ba92be, 0x1721a6dd, 0x6dda7160, 0xfb8d3492, 0x94b5372d, 0x3ff07b6d, 0xa9823ba2, 0x04d0286d, 0xdb485646, 0x8bb57915, 0x4866f746, 0x4472ca54, 0x9935c542, 0xbfc67bf3, 0x06481dc4 };
const u32 bern_num_data112[27] = { 0x143fc2dd, 0x8778f587, 0x568eac28, 0x5a8babd4, 0x54cd55ca, 0x098c6df4, 0xc52021f6, 0x0f8c3485, 0xa9f0f3c3, 0x384f12ea, 0x3e4f07cf, 0xa0a2e07c, 0x789e7b1d, 0x7f821038, 0x2409349b, 0x2966431d, 0x03397314, 0x5b13984c, 0x7d83ccf9, 0xda6275f9, 0x10f73488, 0x9d36ee84, 0x0c9f7759, 0x2f15fb1b, 0xaf73f81b, 0x357bb8a6, 0x069806af };
const u32 bern_num_data113[28] = { 0xcb40686f, 0x3975993e, 0x2809eafe, 0x7f69873c, 0xb32b919d, 0xa8cc84f9, 0x488798a7, 0x5c6cc7b9, 0xd8ccdb54, 0xf679fad8, 0x831d5aba, 0x10282f38, 0x8627e34f, 0xe1c82840, 0x7a6f3855, 0xd3882e2b, 0x3451d323, 0x14216984, 0xc9b158fa, 0x62b43d06, 0x66dcf261, 0xb149ea20, 0x45b3b942, 0x81d55856, 0xaba8bf5b, 0x2643acdc, 0xa04140dc, 0x00003c8b };
const u32 bern_num_data114[28] = { 0x69c97a73, 0x8895f4d7, 0x4be06fb7, 0xfa667e26, 0x7e970c11, 0x222d0294, 0xffbee885, 0x909180b4, 0xb74e7766, 0xd4bea803, 0x945cbf9b, 0xc0c90b50, 0xe3134c33, 0xb2d0f83d, 0x4fad7040, 0xc184cbd2, 0x1a74985f, 0xaa77495c, 0x339ecf22, 0xfacc7c7e, 0x70d30f1d, 0x108818a5, 0x841064e3, 0x8a95a45b, 0x7af7c5d0, 0xade29d9d, 0xfc5ca227, 0x000190cc };
const u32 bern_num_data115[29] = { 0x0ef84773, 0xc4b00a94, 0x4d11b1c0, 0xb133f471, 0xc4d3458d, 0x7fcec182, 0x0ce0c8c0, 0x5438ccd8, 0x6512ae4d, 0xadc2e4f8, 0xbc4b66cd, 0xc92cb245, 0x89224550, 0x4719487b, 0xa39ed3f1, 0xb5c7f9d9, 0x5c90b3a4, 0xdc036397, 0x55a2aed3, 0xeff90855, 0x6d8e4dcc, 0x88fba180, 0x648ef49f, 0x06109422, 0x00177790, 0x960a9176, 0x77a2adad, 0x4fc38fbf, 0x00000004 };
const u32 bern_num_data116[29] = { 0xb7c7fac5, 0x4baa93e5, 0x9ee1c856, 0x5fddd123, 0xe47246a1, 0x793ce83d, 0xcd268b6b, 0xce472904, 0x5333f83e, 0x61a89bd4, 0x10e2b28b, 0x88552d2b, 0x27284b18, 0xa673ca5c, 0xb57fb374, 0x9f849012, 0x87ca60d0, 0xe3f26c6c, 0x2f9f4591, 0x4ae120c0, 0x7d7abf01, 0xb2f8046e, 0x5b7567ab, 0x4ea9ac78, 0x6b90ccb1, 0x049b2f4b, 0x1c69e555, 0x39c32da3, 0x0000038e };
const u32 bern_num_data117[29] = { 0x91f43a49, 0x1f0011ac, 0xee9407e2, 0x99228e6a, 0x762af838, 0x5c349eb8, 0xb040acb7, 0x8d452616, 0x0c4fca31, 0x71526c30, 0x1f8b9d5c, 0x56dd8ae7, 0xf472ae63, 0x169e3942, 0x0ae8fced, 0xf46c54ba, 0x6574b915, 0x92af3f4e, 0x6e8e8af6, 0xac94efd1, 0x2841c254, 0xc19e6e95, 0x3d8d19de, 0x6a6d0f5f, 0x92d5e625, 0x1fbd0803, 0xafe256a5, 0x7ff50223, 0x00000260 };
const u32 bern_num_data118[29] = { 0xff30d549, 0x16b97942, 0x706f48e1, 0xc976bde5, 0x50f9165e, 0x1ddc2de2, 0xc8f21639, 0x9dfed030, 0xd2edfade, 0x5cb3c67c, 0xeb266208, 0x7b4fdaf6, 0x1a9422ce, 0x8958f6f2, 0xd0b8852b, 0x8dfff3f1, 0x68c9b018, 0x015fa80f, 0x6e400e7d, 0xd7d71668, 0x6f9b4bc6, 0xdb838a35, 0x007b1793, 0xf55592c0, 0x346cffd5, 0xf0360276, 0x79cf9dc4, 0xc7bf0b6b, 0x027a1fab };
const u32 bern_num_data119[31] = { 0xa455adc3, 0x0660e532, 0xa08812d8, 0xf418da03, 0x5a00c0b6, 0xeec35485, 0x6149e066, 0xd8f1677a, 0x24252232, 0x78789cf2, 0x8bbcccfc, 0xcf2e6c9d, 0xf862402d, 0x91089f35, 0x403e6b68, 0xaca91849, 0x2e7bd565, 0x8d2f5f89, 0x23059dbe, 0x6adc5511, 0xa779c4bf, 0x2036367f, 0x8ae7f9e4, 0xb06b187b, 0x325321e2, 0x6d1af4f4, 0xd87c9174, 0xbbf6e078, 0x2e141f6c, 0xc60d9aca, 0x00000015 };
const u32 bern_num_data120[30] = { 0x1351fb49, 0x34c51c93, 0xc2a2f50a, 0x57e7b845, 0x7b4bb64e, 0x78ee823e, 0x6297a924, 0xd6440e88, 0x33963cd6, 0xc9535f50, 0xeef6823d, 0xf2009920, 0x242032d2, 0xce45fa2f, 0x1b9d56d2, 0xee1463f2, 0x1a2bf541, 0xf9c7be1f, 0x8f7fbed9, 0x9229cf06, 0x0cc768f9, 0x51bc67ca, 0x827269ef, 0xda566143, 0x6e3f59c4, 0x495edf9f, 0xa426b3e7, 0x690a57f1, 0xb164389d, 0x000007ce };
const u32 bern_num_data121[30] = { 0x0983ced9, 0x9783c2a2, 0x13006772, 0x38e1e500, 0xbb2989c6, 0xefc8ecac, 0xdb08e693, 0x24b0804c, 0x798db61a, 0x87e09be0, 0xe9f566e8, 0xc50f7d56, 0x64b15025, 0x090fb0ec, 0x3fb2a75c, 0x749e5be2, 0x1242c929, 0x4bf69413, 0x8fd3ba8c, 0x098741e7, 0xc4b8000d, 0x8c621777, 0x0589f2ed, 0xc7829887, 0x16cc40df, 0xeea650e0, 0xa346069c, 0x6b22f777, 0x40101aab, 0x0009f516 };
const u32 bern_num_data122[31] = { 0x54ad8613, 0x85063113, 0xa79e84c4, 0xf524535c, 0xdf9ab7c2, 0x0625572f, 0x1c2a72f3, 0x02c8b909, 0xd8ac3b82, 0x4fafe305, 0xd12c29e0, 0xa7df10eb, 0x30b310de, 0x46b80117, 0x15745e51, 0x1069682d, 0x3e91c301, 0x93bd7925, 0x37bba97b, 0xfe19e318, 0xe3c4db9d, 0x6346e600, 0x5f8924f1, 0x8283e991, 0x40f49f63, 0x890d82d2, 0x62aff16d, 0xb345ce8d, 0xf0ad69e4, 0xf40d093e, 0x0000001a };
const u32 bern_num_data123[31] = { 0x85179061, 0x1ce9dbec, 0xd21e7d5f, 0xd50dfa76, 0x46f29145, 0xc5f07a59, 0xf37297e9, 0xa1bb77a6, 0x9d04885c, 0x1a096331, 0x87561a8c, 0x72ae20cf, 0xbba85d06, 0x37b7b9d8, 0x89f6116f, 0x3e1d1314, 0x8b26c94f, 0x1223366b, 0x82026d8b, 0xda179abd, 0xa7a6c084, 0x739cdf40, 0xde6e59f2, 0x08fd5f04, 0x7d3a6fc7, 0xb0a4199f, 0xf121cd8a, 0x82edd573, 0xd6f930dd, 0xe9363017, 0x00000167 };
const u32 bern_num_data124[31] = { 0x5cbdd387, 0x7bef75b7, 0x95f15887, 0x4bd3d6ba, 0x0670924a, 0xbab4859d, 0xe920974a, 0x5a966136, 0x99811850, 0x1e7f892c, 0xf9e4a84b, 0x6c6bc4f6, 0x5f93ed7b, 0x113dc194, 0xeddf7d11, 0x352f6768, 0xf48503ef, 0x8c381c76, 0x12b3704f, 0xcd98df3b, 0xae005ede, 0x5cf7e226, 0xfed0dcc2, 0x7d73e943, 0x8b095000, 0x114f8a0b, 0xa6e1e2d6, 0xefb58f83, 0xbb290ad7, 0x2353da6d, 0x12adcc30 };
const u32 bern_num_data125[32] = { 0xc9435a0d, 0x9f2002af, 0x7a2aa282, 0x23463ba0, 0x0d1baa3e, 0x0f79dcda, 0x5bcd6c74, 0xb39fd987, 0x7c394e14, 0x2591ed93, 0x4bd317f8, 0x2e89b9cc, 0xd783453d, 0x226511aa, 0x753da169, 0xc244fe06, 0xf23c6261, 0x7f6b2652, 0x41713bc2, 0x7dc1b146, 0x7fb15553, 0x0a8d81fe, 0x9abaef7a, 0xb4fffcb4, 0xf2745027, 0x0cd8c816, 0xe079625e, 0x7cf59503, 0x16b37414, 0x49c13476, 0xa17ca9df, 0x7fd7c3c4 };
const u32 bern_num_data126[32] = { 0x8703cda7, 0x642d04a8, 0xcea3788f, 0x83f99bff, 0x744c7c1c, 0x94d6f8a5, 0xd251f1eb, 0x8c94f9c6, 0x1fdf599b, 0xfebe989a, 0x5f5c4189, 0x09e9c30b, 0xb4adebb8, 0x736eeb74, 0xf1a5a49e, 0xbf566421, 0x43455266, 0x928e7c8f, 0x64e621c2, 0x4f1d3ed5, 0x4efcc711, 0x2137cc86, 0xce6a5f08, 0xb8d63725, 0xc06d4d48, 0x9c18b18e, 0x4794cac7, 0x9d3ebc6c, 0xf66c7f07, 0x6e0cae4f, 0xebdeadb3, 0x00000044 };
const u32 bern_num_data127[32] = { 0x13623201, 0x99f2dda7, 0x899edc29, 0xb0ac8209, 0xc0a0aa95, 0xa30acd93, 0x53b0f347, 0x0e94ced9, 0x58a9a344, 0xe1e0fc82, 0x1c425049, 0x422b0746, 0x15a4f0e3, 0xde9a56bd, 0xe11ffc04, 0x66618cad, 0xf21dbb2e, 0xa65a5b38, 0xc9fb6bd2, 0x0aef8295, 0x56774be2, 0x986f13ad, 0xf83e4261, 0x678bd41d, 0x427fd26e, 0x03ceab3e, 0x7645a663, 0x648d2a39, 0x3fbf1dec, 0x24336639, 0x35dbe6dc, 0x9463ff82 };
const u32 bern_num_data128[32] = { 0xabcf49f9, 0x5f80a913, 0x6b35ee39, 0x0eb4aa54, 0x377a306c, 0x6e979005, 0x3fb3cce9, 0x5586cc01, 0xdc5a85eb, 0x5e2c7b53, 0xd8634c23, 0xcf916ee1, 0x58f95410, 0x91b7e862, 0x91a95da5, 0x03ad2bcd, 0x1841b6d3, 0x3bfd6a64, 0x25639521, 0x58716983, 0xd176eefa, 0x3e17c7d6, 0x055aa672, 0xccc446b9, 0x079b6a23, 0xb19fccbd, 0xea8051f8, 0x36cbfa41, 0x661c5147, 0x65e19eee, 0xca5a8bf0, 0x4fdcec6d };
const u32 bern_num_data129[33] = { 0xe57531ad, 0x7fec51b0, 0x730294c8, 0xbab2a0d2, 0xb6d6ef07, 0x32a7b5d5, 0x093e0718, 0xa458a5f5, 0x9ec8d31e, 0xfeaadef9, 0xe3bbc0b8, 0xfdec09ff, 0x0957cc6b, 0xc7b915b9, 0xd3a4b419, 0x6c981cd3, 0x52047643, 0xb4026c43, 0x5553b07a, 0x3cce1c3f, 0xa025379f, 0xe3ecaa52, 0x9ce05ff2, 0x15ee351f, 0xcea014ee, 0xa6f181de, 0x63a124a7, 0xc14f6fd6, 0x6d237c12, 0x809be118, 0xb3e8c915, 0x6f6a5ba2, 0x01baf22f };
const u32 bern_num_data130[33] = { 0x044380e1, 0xc420ab29, 0x4ccad1cb, 0x3b544089, 0x8773489f, 0x536f1762, 0xf4cd4e91, 0x2928195e, 0xd5b812cf, 0x1f1e5bef, 0x5b21da3b, 0xc995e4ca, 0xce4fe204, 0x6be983c1, 0x088c8c97, 0x256ab0f7, 0xee08bc1a, 0xca3167d4, 0x8cf7ab09, 0x32e64c15, 0x8dd037f7, 0xe069834a, 0xf2754007, 0x2abf5b78, 0xb5b911cb, 0xc3f544b1, 0x31aef854, 0x3a4dc70e, 0x3c533a9e, 0x98760e2b, 0xa34e8921, 0x8a3184aa, 0x02106b5f };
const u32 bern_num_data131[34] = { 0xc8fde6af, 0x67cedac0, 0x7e49537a, 0x7782bc77, 0x6aa4c56b, 0xf0b93048, 0xc13e926e, 0x45c03e7b, 0xbfc0f60a, 0xf9388024, 0x7dd0b695, 0x516ab8d4, 0xa421d088, 0xf22fa8e6, 0xd70de078, 0x5070917d, 0xa029b799, 0x96f81f7c, 0xb66d9818, 0xbb6961cd, 0x85a88130, 0xb562e068, 0x44ff1753, 0x2df1028d, 0x43239441, 0x9ce85eed, 0x9bee1a3f, 0xb667fc55, 0x39c0b730, 0xdc7fecca, 0xeb665bcc, 0x43d053ce, 0xa58abec1, 0x00335761 };
const u32 bern_num_data132[34] = { 0x672b822f, 0xb0f97a23, 0xdfba86a0, 0xba20daa0, 0x7cd5cdc8, 0xa1cbed10, 0x2c2a934b, 0xc4463e89, 0xab0c88da, 0x01e30766, 0xfe94a954, 0xc0a714b8, 0x25ce837b, 0x3fec6cf7, 0x6294db9d, 0xd08980cb, 0xdbe8a6d6, 0xeb879a46, 0x230f5ff8, 0x712e0d66, 0x55f292e7, 0xcd949146, 0x1854568d, 0xdd1ca47c, 0x95388c55, 0x624fdd67, 0xd89c96d4, 0x4aa63b7d, 0x6681f4b6, 0x5a5cdebc, 0x170e4583, 0x748a39cd, 0x463ee7e6, 0x00000060 };
const u32 bern_num_data133[34] = { 0x66740ff5, 0x78f6a133, 0xa0fc7001, 0xa7b0035e, 0x44c2c3ae, 0xfa469db5, 0x113e8297, 0x4fbac8a2, 0x48828837, 0xcbaf6e8b, 0xe9d0246d, 0x0ae257e6, 0x451d98cf, 0x628fc5f9, 0x6f059e97, 0x1dc51c70, 0x4e82e4cb, 0xfbfd2e57, 0xaa66bb07, 0xdcf44191, 0xb5465ba5, 0x3413639a, 0x3522df07, 0x5517c137, 0xd3044c23, 0x344ff055, 0x1109b71f, 0xb59edc67, 0xd9df4b8f, 0xec0640f5, 0x940db52f, 0x39a1cf47, 0xab3df37c, 0x0dfd4a38 };
const u32 bern_num_data134[35] = { 0x38ee52d1, 0x808974c0, 0xa55d4f7f, 0x3597d155, 0x74b31a9b, 0xc68ad23a, 0x535caad2, 0x1619973a, 0x17638a1b, 0x0e677620, 0x1660f477, 0x64ca593d, 0x0e9daf83, 0x192e7c1a, 0x57e926cf, 0xf6c78d83, 0xa7235acf, 0x6d51a70f, 0xc2cea1af, 0x5b3e2725, 0x5a5c32a4, 0xf89abbdc, 0x705cbfda, 0x25dbc72c, 0x4ec47fc9, 0xf57ccf68, 0x839f2064, 0x8aae7a6f, 0x1d466361, 0xe17fd282, 0x389be6f5, 0x6486f680, 0x17a363d1, 0xc7628f83, 0x000e04a1 };
const u32 bern_num_data135[35] = { 0xcaea51a9, 0x68aaf06c, 0x06bc44cd, 0x56585dcf, 0xfbf3d8a5, 0x4ea791b7, 0x2d1aa3bc, 0x2e4e8121, 0x0a2a7f48, 0x50ef4fc4, 0x37e17899, 0xd6235f75, 0xad7c70ae, 0x5745b08f, 0x8c3a44c0, 0x88a85e3b, 0xc3a065bd, 0x54586eeb, 0x281de311, 0x95bd9384, 0x5f24b52d, 0xbc9408bb, 0xc1d24064, 0xe320225d, 0xda49cdc7, 0x80bc2a80, 0x7cb39014, 0x0071d684, 0x0f118e77, 0x6e5ca593, 0x005fb2e6, 0x8906a1c8, 0x4f4ed5a7, 0xa13b9433, 0x0018cc81 };
const u32 bern_num_data136[35] = { 0x1f45185f, 0xc6258852, 0x2842085e, 0x8bbc44ff, 0xd0c81aaa, 0x2ec9583f, 0x080e640f, 0xf060672b, 0xc70341f9, 0x03dd9808, 0x858bff82, 0xdaa76baf, 0x38034070, 0xd45eba5b, 0x5d2df70d, 0xf318eb87, 0xa30ca009, 0x7e98b861, 0x05fa7e15, 0x0484101b, 0xb914a51c, 0x0df8cf45, 0xc27f859e, 0xc14f1236, 0xc27754f9, 0x5fd87561, 0xf3ff33ec, 0x1a4d268d, 0x1fba9f7c, 0x30abcd3c, 0xb31ad046, 0xb65467cc, 0xa193b612, 0xffd2c73d, 0x000408f6 };
const u32 bern_num_data137[36] = { 0xbf22219b, 0xbe11cc0a, 0xae13ccaf, 0x73081d61, 0xc07f5ebc, 0x0512c205, 0xf20eb377, 0x96584e60, 0xb7a42945, 0x36cfdc19, 0x76893459, 0xb8dc1a08, 0x97b73e0f, 0xcd1bf0a7, 0x9b9a8448, 0x61bc9a09, 0x98879680, 0x44665bc0, 0x8b5efcb2, 0xebbbd261, 0xaee26e13, 0xa48bf935, 0x5a7e57a1, 0x00dfb575, 0xf99b4c63, 0xabe0694e, 0xe391a34f, 0xe946de94, 0x41041f71, 0x45b0ff8f, 0x1b1d3370, 0x9a0d45a6, 0x72b5dd9b, 0xc4f96b33, 0xd0992a23, 0x05cf3520 };
const u32 bern_num_data138[36] = { 0x09854937, 0x5c7b0e93, 0xf313f572, 0x686f8dc1, 0xeaf0da5d, 0x3eec2a9a, 0xd8480b76, 0xe9e454f6, 0x413b2e06, 0x1a3e04a9, 0x9c1e09c5, 0xc9566c45, 0x25266827, 0x254d85be, 0x158048e1, 0x0c1ea5e9, 0xb47fe1bb, 0xb9235ade, 0x5e85e5f7, 0x6d7295ea, 0x4514256f, 0xba16c5a4, 0x34e9de7a, 0xca9ecbee, 0xc7e1c5e8, 0x62119730, 0x3681653b, 0xf8a7e1f8, 0xc110d7f2, 0x7c91ed98, 0xee618615, 0x4d27543b, 0x607ca5c7, 0xbe56978b, 0xe4d86f91, 0x000000e6 };
const u32 bern_num_data139[37] = { 0xbbbdc319, 0xacdba52d, 0xda707c47, 0x7a34656b, 0xdb79dc26, 0x47e144db, 0xdb9051c1, 0xc9a3d2c0, 0xe89ee628, 0x5f912a15, 0x73d1bbdd, 0x0b1b9afa, 0x8cf4e4ae, 0xa8b2967c, 0x02e874df, 0xf243391f, 0xc0273927, 0x6f389b59, 0xb30906b0, 0x5731d4c1, 0xad25d104, 0xeb7b909f, 0xb961276a, 0xc3063f4d, 0x0126a05c, 0xcf8f295a, 0x8749e7fd, 0x1df6fe9c, 0x85b7c911, 0xc1c24408, 0x2e69556b, 0x880dcee7, 0x3df4832f, 0x930dfe27, 0xad5b133e, 0xf9fedbc6, 0x00021e27 };
const u32 bern_num_data140[37] = { 0xa3f1da93, 0x7139c14b, 0x12b097f8, 0x1cbe2e66, 0xda460d80, 0xc0193573, 0xc15105be, 0x252b85fc, 0xcf795888, 0x436c713c, 0xa1999119, 0x64dcca9f, 0xf8f8081d, 0xd644c188, 0xbd88d01a, 0xedf7aec9, 0xeb0fd1a9, 0xeb62203d, 0xb54a9aac, 0xb7595826, 0x30d39028, 0xb369ca19, 0xca20b6fc, 0xe08e5cf6, 0x1425b98d, 0xab631452, 0xb3645b7a, 0xcabcf92c, 0xf390e67e, 0x8e0067d8, 0xea14e4cc, 0x50525c63, 0x140db3dc, 0xde786d0e, 0x85c56ee6, 0xfebd7f04, 0x000001a6 };
const u32 bern_num_data141[37] = { 0xe2d017a9, 0x517c733e, 0xd315f947, 0x2574664d, 0xe72b50c7, 0xaa17ba28, 0x5d8c1522, 0x7ee498d8, 0xefb7545e, 0x5f04e4bc, 0xc4589c63, 0x5e5da330, 0x17522822, 0x2cf2d86a, 0xd14e6ae7, 0xb7373f03, 0x9aeccab6, 0xc50af45f, 0xafb4be41, 0x20fc6619, 0x07e6b539, 0xb0b28a0b, 0xc0ebf9bb, 0x2786045b, 0xbbbe6459, 0x8af88854, 0x9271e3b9, 0x05c5dc10, 0x8760a794, 0xf541029d, 0x5792c587, 0x183b7dcb, 0x2628384f, 0x57d44a56, 0x6e98e1b5, 0x87fe0295, 0x0000087d };
const u32 bern_num_data142[37] = { 0xad46b341, 0x1baa3f46, 0xbe84c115, 0x1a6e5016, 0x2acc2435, 0xb6d6377e, 0x7f4a6b39, 0x7500846d, 0x738d17e0, 0x24c37b40, 0x9dda179c, 0x0c1a8804, 0xc8275991, 0xd9463b31, 0xf006210c, 0xe282f7d5, 0x6f09ad96, 0x7c9658d5, 0xaababd90, 0x1d340f3f, 0x6a40bec9, 0xc66616fe, 0xd83dfc42, 0x74b323cc, 0x6092c103, 0x1b9a4ab9, 0xec7aefef, 0xa61f5b50, 0xd9a0db9d, 0xb441fa9d, 0x33a3a4aa, 0x9538217f, 0xbbd8ea69, 0x637411b4, 0x255253f8, 0xd3d0a5fd, 0x013afd19 };
const u32 bern_num_data143[39] = { 0x4ecee56d, 0x67958909, 0x9254b134, 0xe09f6c51, 0xb82237da, 0xae52cb40, 0x40f176df, 0xd71886e6, 0x92008bc7, 0x5992b0e2, 0x22cc44c7, 0x83762941, 0x39220d7e, 0xf8e944dc, 0xaa4446a8, 0xe0ea7945, 0x5b77885c, 0xbbb0d08c, 0x28b50fdc, 0x386acb89, 0x930f4da7, 0xa719eeb5, 0x6507c7db, 0x63e33ecc, 0x2a20436f, 0xac405306, 0x21d001cb, 0xb66b4300, 0x14d1ca83, 0x6158ca47, 0x16d39806, 0xd9be10fb, 0x5b77bcb7, 0x255295bf, 0x4e7a4733, 0xd225b407, 0x871073e8, 0xec229818, 0x00000003 };
const u32 bern_num_data144[38] = { 0x24d8a637, 0x8305f9b5, 0xd8311b94, 0xe5b5e34f, 0x82f444fb, 0x164858b8, 0x5d94e8a0, 0xc2f6a17d, 0x94a9b2ba, 0x1cde2b72, 0x1bc58d57, 0x7dca60f6, 0xfd2fa40c, 0xfe85f07b, 0xe8a13e0b, 0x7cbca004, 0x2fe260b6, 0x7887a821, 0x86892e67, 0x7f477c0e, 0xa9279ea8, 0xb47ea107, 0xf69e2ec7, 0x44316511, 0x746ac2ad, 0x1a9be376, 0xd6bc2f73, 0xbc0e785c, 0xb3e90113, 0x2b9ed156, 0x501743c6, 0xc4b1f2e8, 0x121e83f4, 0x4cc5cf1c, 0x0ad50a61, 0x4258bbc4, 0x04673a2b, 0x000932bd };
const u32 bern_num_data145[38] = { 0x2ac0e13d, 0x8c7ca7b2, 0x137b8486, 0xd80cd1e3, 0x37ba8ff0, 0x15920256, 0xf6d3868c, 0x9b1d5fbf, 0x73666114, 0x3deb1863, 0x2453c80f, 0x2d55d7b1, 0x1123519e, 0x484b2898, 0x7d71db32, 0xcf237d4e, 0x8caa73c7, 0x9158caae, 0x598eab6d, 0x1ea104b4, 0x6871e7f0, 0x620aa7a4, 0x4843f6ee, 0xfe71dd72, 0xfb5921ce, 0x5013c859, 0x1fad6750, 0xdff7b1e1, 0x4b0087f0, 0x2b469b3b, 0x9901fcc1, 0x0767f896, 0x41c41269, 0xa386ba69, 0x61447ed8, 0xde75314f, 0x555ad0c2, 0xae92240b };
const u32 bern_num_data146[39] = { 0x08386a8b, 0x8a9f3ab9, 0xd0d1d05c, 0xa55b1243, 0x5139d70b, 0x33616f88, 0x39040c36, 0x8d1f8fde, 0xdfca2a53, 0x9a8301ff, 0xf3e9ac59, 0x6b6b6b99, 0xf5956b5e, 0x0dcc6176, 0x3fcc36aa, 0x67608711, 0xb16f2ae3, 0x07049837, 0xffcbb43c, 0x5f43716b, 0xae6cd97b, 0xeace584a, 0xe5ef9c08, 0x3a857262, 0xc5e4782f, 0xcdddcc38, 0xd4d7a83b, 0xde1ad727, 0xea841de1, 0x661d420c, 0x35099ce5, 0x5c906622, 0x13b49b1d, 0x13143954, 0x55535a43, 0xd0b95e40, 0x7515c77b, 0xb6e21165, 0x00000131 };
const u32 bern_num_data147[39] = { 0x54cfc755, 0x7a3edfc2, 0xb8375e21, 0xe54a654a, 0x0835a62c, 0x77f2f8b0, 0x91403fc5, 0x72f7a804, 0x8fce836e, 0x624b7c81, 0xfe304265, 0x749b0be0, 0x4c2a0ca2, 0xf27300ef, 0x805471c8, 0x6b66b665, 0x2fba7f52, 0x898977e0, 0x113cf196, 0xd003dd74, 0x4065d890, 0x993b859a, 0x154b239d, 0x2340f543, 0xf77fddf4, 0xe257e557, 0xd884033f, 0x4ce65dbd, 0x06cb91a1, 0x12cac530, 0x6be15bd8, 0xd0fd590c, 0x7c5675ea, 0x78101bbe, 0xb17c96d9, 0x8021ef79, 0xf7e17523, 0xbe1a336b, 0x0019899e };
const u32 bern_num_data148[39] = { 0x8f90b6ef, 0x2ed0c604, 0x5a2d507f, 0x8a83b381, 0x558e96f5, 0xe1880a4c, 0xa503cd37, 0x6a89f5b9, 0x57d684c6, 0x8d9bd847, 0x95b1091d, 0xedd3b6d8, 0x4bd6cbad, 0x1976ce8d, 0xee8fe3ef, 0x2ad38bfb, 0x1fb0cea4, 0x9ffd2a9b, 0x74767dd1, 0xd3132b50, 0xb9d35567, 0x3cd02f56, 0xf2169a62, 0x74e1c530, 0x5e901c24, 0x826e6ad0, 0x1f48d81f, 0x5155fcf5, 0xde9e325b, 0x809d2cb2, 0x53165c4c, 0x046aab19, 0xb07998eb, 0x33f0022d, 0x733243f2, 0x3e063057, 0x2463bacc, 0x2904c015, 0x004cd943 };
const u32 bern_num_data149[41] = { 0x71f30949, 0x039509da, 0x5cde502f, 0x83722aca, 0xfbc1f01e, 0x16390215, 0xd02e02b9, 0x5d18792c, 0xd991f623, 0x19832bf1, 0x9b04b750, 0x4c034ee8, 0x739af428, 0x1d3892b2, 0xe1e0cf32, 0x05fd3ec1, 0x9fb179d0, 0x68d51881, 0x78379ef9, 0x4cc7e040, 0x3add3c70, 0xd0cf9704, 0x9c86d66f, 0x83db66de, 0x49aef8bc, 0x047a88a2, 0x6f257f41, 0x429e4e28, 0x2b6ff49c, 0x7e8bf556, 0x594cd949, 0x6c87c1b3, 0x2c9f8628, 0xed1f814b, 0x266ec65a, 0x1eeb6d83, 0x0f32a11b, 0x0cb91260, 0xdf01411d, 0x8a90dd61, 0x00000059 };
const u32 bern_num_data150[40] = { 0x8230cec7, 0x7b37bef8, 0xe37209e1, 0x8069f3da, 0x691f3826, 0x18b6855b, 0xecb1a6dd, 0xa9a69f33, 0x18a2ced9, 0x639db4b9, 0x22d2b5f7, 0x0cc94bb6, 0x014e35eb, 0xe14ef6fc, 0x1e50f1ae, 0x321adb87, 0xa528437b, 0x0016b9ce, 0x90e21745, 0xee63e6ba, 0x01f82f22, 0xe4819f71, 0x41039b74, 0xb8c5037e, 0xdb38a9be, 0xaa27028d, 0x78860939, 0x745899be, 0x109b5c2d, 0x3d172bed, 0x92816de1, 0xdfa81647, 0x9d8966f2, 0x46d8ae64, 0xec256c00, 0xb3b0ae8c, 0xbf1926ac, 0x5d15b28d, 0xd5cada7d, 0x000017f6 };
const u32 bern_num_data151[40] = { 0x83a3c661, 0x466e8f47, 0xd4b0236b, 0x0a66a567, 0x3fc6b062, 0xdc59bd5a, 0x5b3066aa, 0xc90a7bf2, 0x48a68ab7, 0xda97c8dd, 0xa192b5c6, 0xaf33956f, 0x50681f51, 0x688c239e, 0x2acd13f7, 0xa279d3fe, 0x560a336b, 0x42aa048c, 0xa23e7570, 0x79760993, 0x15504027, 0xef4f58e0, 0xc5e59190, 0xddbbb4d9, 0xdd3e0275, 0x88a6a7d0, 0xd3b70b92, 0x177751ba, 0x719fad64, 0x0f6f3c27, 0x4b72c687, 0x86696ef3, 0x0f7429e7, 0x06b69640, 0xd625af60, 0xfba77df2, 0xfd959718, 0x72b89a9a, 0x24e32af0, 0x48852558 };
const u32 bern_num_data152[41] = { 0xde038407, 0x9227657b, 0xe43a4e46, 0x9d6434a3, 0x87705126, 0xbce00895, 0x1e23b49b, 0xabd2bd8c, 0xfd31b141, 0xa0c9ec95, 0x8e7f2ef9, 0x142d3da5, 0x88a6198c, 0xac9fd7ca, 0xa71d7564, 0x32673bd5, 0x46cd4b2d, 0x1bd7c065, 0x23522433, 0x71690abd, 0xb5ae96e7, 0x4664b749, 0x97636b65, 0xd461ce28, 0xc03d9103, 0xa1533a69, 0x91e33ea3, 0xd17a860e, 0x10f4287d, 0x2efcf89a, 0xdf8a7473, 0xf1667b22, 0x4c49ac86, 0x19acbe99, 0xc522fc10, 0x46af9257, 0xee13236e, 0xb601d408, 0x0942d277, 0x9220881a, 0x01f999fb };
const u32 bern_num_data153[41] = { 0x1898f0e3, 0xda5c89f8, 0xb8c10241, 0x773a57e9, 0x1e24f674, 0xce8e6bac, 0xa507d049, 0xc8eb8a3c, 0x59a7e186, 0x74ee3db2, 0xf7be6b1c, 0xf60890b1, 0xb0132578, 0xf92e0840, 0x8366532e, 0xf15a7fcc, 0xd5517b44, 0x919db869, 0x8abb99e3, 0x032386b3, 0x22efc1bf, 0x9936ed6c, 0x91a5a573, 0x0626859c, 0xea326c8f, 0x173ff3c5, 0xe231e50d, 0xf937c7e6, 0x9353dbb2, 0xba92dbb5, 0xbe263968, 0x75bb4992, 0x2cf58db7, 0xa9fb4dbf, 0x96d5c5ea, 0xa0d3f86b, 0xf0cc3ef5, 0xb9792efb, 0xa0fd906c, 0xeb8ff9a2, 0x03c04c71 };
const u32 bern_num_data154[42] = { 0xbe0af9bb, 0xe5ba036f, 0x13c93be0, 0xe07e9d18, 0xef2597d5, 0x56842ae2, 0xb9d2886d, 0xa1ccf00b, 0x866b1e27, 0xcf1b0658, 0x494789e6, 0x1cf0f30b, 0x11a548c3, 0xfc7609a0, 0x6050cb99, 0xa33f043b, 0x209f3be8, 0x9c50d637, 0xad2152bd, 0x84d7bdd5, 0xcb25557e, 0xa55e4757, 0xf4ff898d, 0x8d235bb3, 0xad681c25, 0x9832b0e3, 0x6d5063e5, 0x9f6cc9fd, 0x1b61eafd, 0xbb3cc80a, 0x86ea96b2, 0x3f3e131d, 0x77c0c405, 0x06b69ce4, 0x33a2190b, 0x5f2d0d0e, 0x6c6f2b48, 0x110d9d85, 0x10483406, 0x0e0fcba2, 0x787f7d74, 0x00000024 };
const u32 bern_num_data155[43] = { 0x1821078d, 0x308d2160, 0xa8b6fd96, 0xc55467cb, 0xcaf4e27a, 0xb9682124, 0xdb1392ca, 0x8ba7af13, 0x04373881, 0xa1f32e0f, 0xe0508f43, 0xd995289a, 0x0f6fd790, 0x05edc467, 0x4b80a3c7, 0xfb2955fc, 0xd1fcdfb7, 0x8a2e9df6, 0xf85bd1a3, 0x1b579c1e, 0x46d0913e, 0x0725061e, 0x74098dd6, 0xcc091ecd, 0xc2692d5b, 0x4da31437, 0x5dc7ccce, 0xb9d7b479, 0xf4532529, 0xe32a021a, 0xb705181c, 0x9dfe9f71, 0xa64b05ee, 0x4ffd9ef4, 0xcdf8c6ba, 0x0789eeea, 0x0e6cbc35, 0x2737d9d6, 0x660b332c, 0xb65ad6ae, 0x5d10b729, 0x248e2aa6, 0x0000023b };
const u32 bern_num_data156[42] = { 0xb8512d4f, 0x0ab905f4, 0x6c62a6bb, 0x9711d56f, 0x52cfff80, 0xc9b7456e, 0x99e18ac4, 0x10d8970d, 0x8ae08612, 0xb3e7756b, 0xded50bb9, 0x4ac44a02, 0x63b25492, 0x23d4dfd3, 0xf2ba1615, 0xaae05356, 0xe577f023, 0x004cf83a, 0xe0e3be21, 0x3cb2b7ee, 0x6d87fe92, 0xabf8e003, 0xd3c9c8bd, 0xb0145c98, 0xdb39d5e1, 0x957b498b, 0x74580513, 0xe5dd2b13, 0x14d6a692, 0xc287b0a8, 0x62b87119, 0x84492262, 0x2d33ce51, 0xd91e245b, 0xd26462ba, 0x3ef8f048, 0xef035134, 0x4d42bc9f, 0x25a2f44d, 0xdedcd111, 0xf72d0443, 0x0000fecf };
const u32 bern_num_data157[43] = { 0xf0c5d985, 0x8addcbcf, 0x6712780b, 0xdef23482, 0xc23c7816, 0xad09c998, 0x2c6e213a, 0x734343c8, 0xb32ffbb6, 0xe80e51b6, 0x095ebaec, 0x97fade21, 0xaa472e3f, 0x3917033c, 0x587be0c2, 0x098b3e92, 0x46c6578f, 0x0d3a6b69, 0x58e8877c, 0x651d5a8c, 0x4ddbabb6, 0x4d3db833, 0x9a24d034, 0xa035fac9, 0x05a8ff55, 0xbfe2db68, 0x9d2b08a1, 0x2bc33c2c, 0xb699ddf0, 0x0458bb91, 0x3e9ea289, 0x126e8372, 0x47b14b90, 0x55c36f87, 0x895ac02d, 0x0b641640, 0xc43491ca, 0x4f313828, 0x9dbfad55, 0x4c5346ce, 0xadb88af7, 0xb27391aa, 0x0000003c };
const u32 bern_num_data158[43] = { 0x79c2a51b, 0xac3508f7, 0x92fa63eb, 0xf9cfaa10, 0x621685f2, 0x20f09bbf, 0x4ffb7eca, 0x9e55dc7d, 0x3a546106, 0xe3abde06, 0xdfadc91b, 0x1413331f, 0x9bda3b15, 0x815b14d6, 0x8805cad8, 0xd264129e, 0xab1843e8, 0x5b125b16, 0xb021e9b6, 0x87f73887, 0x55eb170d, 0x3d951ba7, 0xe4db2ef3, 0x61b66601, 0x1a5b220a, 0x818b4469, 0xd6f542a3, 0x425e8983, 0x79b1fbf4, 0x42ab35be, 0x35495531, 0x0762ec03, 0xfe1b4156, 0x0284bb74, 0x669c67bc, 0x8a2df6ca, 0x9f22da62, 0x7d4e57b5, 0xa8b0b1e5, 0xa52f0cbd, 0x58c3dfaf, 0xc4e18cb5, 0x00011e17 };
const u32 bern_num_data159[44] = { 0xd2bc5a43, 0x8538097f, 0x3bd89bea, 0xae5a6288, 0x16e19765, 0x57489902, 0x26a8cbd2, 0x52704ab6, 0x999d4c74, 0x9ce77987, 0x9b4ef803, 0xc6392fb3, 0x6e7eae2f, 0x77de6b79, 0x2c699d43, 0x2491a55d, 0xb6ea1abc, 0x8c45d88f, 0x403c5654, 0xe6f6f462, 0x2466a505, 0xd0999d28, 0xcca8e183, 0x87da2ee7, 0xae79bae5, 0x10d23e86, 0xbdc81450, 0xe32a2a6a, 0x1445e231, 0x35d73844, 0x99fcc965, 0x51431b3a, 0xa583272a, 0x88ff9666, 0x3df8ce98, 0x7d6d2055, 0xada66a0b, 0x11302195, 0xb7e01838, 0x21fb4a53, 0x6584a0d2, 0x003c2c27, 0x41b9c3c3, 0x00000002 };
const u32 bern_num_data160[44] = { 0xa19dc851, 0xf4f2d144, 0x69924770, 0x2be8fce9, 0x6d2e7ca7, 0x694c253c, 0xa70e695a, 0x5f519758, 0x9b8f0a03, 0x7b2687dd, 0x1a381e19, 0x8d67c883, 0xff5e1b9a, 0xa205e216, 0xa87c3054, 0x6372b312, 0xe63b4db7, 0xe3c9d1dc, 0x57cf9acd, 0x4e2f3cf6, 0x210d3dbc, 0xb21b31a9, 0x4a0c17b0, 0xa560d1a3, 0x7192c641, 0x82a769be, 0x6c532cd8, 0xfb2d8b18, 0x855d8144, 0xd68658cd, 0xac2dc68e, 0xb221e5d6, 0xbfb17773, 0xe38b1682, 0x3b0f1951, 0xa4d2c57e, 0x70a28527, 0xfba55235, 0x8049eba3, 0x7747a4b8, 0x46ff0da9, 0x2ba9c8c6, 0x3e7e366e, 0x00000007 };
const u32 bern_num_data161[45] = { 0x16c37e8b, 0xe3ab6f76, 0x27b276d8, 0xe07e2650, 0xdfd07dbf, 0x072f5c48, 0x5cd82a95, 0xadf72710, 0x2f3a4c39, 0x04d78fec, 0xbeb69439, 0x279580e9, 0x39d461c8, 0x73b3f465, 0xf89a0d0b, 0xd9751f37, 0x46bf73d9, 0x89f7abfa, 0x2b114bab, 0x0db8878a, 0x5587c46c, 0x3b7c5a02, 0xd5b41726, 0x19fe1c59, 0x731594aa, 0xbea9e7d2, 0x29676bfa, 0xed5c533c, 0xe50babc6, 0x1d0b75cf, 0x5c46aafb, 0x63b4c35f, 0x73c988f3, 0xa61ef32c, 0x3dd1b591, 0xade19987, 0x43fc298d, 0x4241bc39, 0xb311d567, 0x2ce734f5, 0xf169c5e6, 0x91b5374c, 0xd5bbbf9a, 0xa001125b, 0x0000021c };
const u32 bern_num_data162[44] = { 0xa7a0de57, 0x0eda414d, 0x199d1aba, 0x09a87144, 0x6886ac61, 0xac625220, 0xdbf583fb, 0xc060f829, 0xd308f7b2, 0x220a3b69, 0x9cf36ce4, 0xa91f6d4b, 0x57d98133, 0xa26e2ead, 0x91242dfc, 0xe463e816, 0x75e23da8, 0x9efeec2b, 0x8a05b030, 0xa250ad89, 0x4d0d806c, 0x4a481013, 0x0dcd5cc5, 0x37ed4ada, 0x10396821, 0x44eb5049, 0x20c714e5, 0xff9a68f4, 0xa579a480, 0x687daa91, 0xb77e6b70, 0x9eaba840, 0xe9bf4290, 0x031bb949, 0x61bb1dda, 0xf09efd19, 0xa45fe3d9, 0xf2c9f92c, 0xeb099d42, 0xa13459c2, 0x79263d92, 0xafec4f54, 0x99ef86de, 0x0010bb47 };
const u32 bern_num_data163[45] = { 0xc5b57253, 0xd2b22531, 0xf8dc8814, 0xe599e6f7, 0xf64a96f9, 0xb741806e, 0x301e8efc, 0x2963a41e, 0x6ccf75ad, 0x3ffc313e, 0x29f61bf0, 0x143a15f7, 0x2f6ed246, 0x468fd487, 0xddc13b73, 0xd5f79034, 0xd8b4445b, 0x3e0b93bb, 0x60119991, 0xd37dbddc, 0x7a48b6a0, 0x9a7b4e04, 0xe926beca, 0xd1619fd2, 0xa897243e, 0xa84836ce, 0x533658a7, 0x526f9720, 0x59fd29ec, 0x2da6c06b, 0x1fd9d4c2, 0xad64f7cb, 0xccad0aae, 0x975fd864, 0x2222d623, 0xf07ff324, 0x5910b54e, 0x08430b11, 0xdffd587f, 0xa7a6ecc9, 0x32fabe17, 0x3a2fb47c, 0x940c026f, 0xd9a4ee06, 0x0000011f };
const u32 bern_num_data164[46] = { 0x88660fdb, 0xec4caec6, 0xb95cc967, 0xa0dbd6db, 0x3d98b709, 0x5c8a8612, 0x08e90e41, 0x713cac29, 0xf36a2b89, 0xd9b522b4, 0x50b0d1a8, 0x82e44b25, 0x51574282, 0x0038abbc, 0x91cb42d0, 0x7b1b2e76, 0x1b44cadc, 0xc35cd462, 0x4e432d0d, 0x8347beda, 0x9c73787d, 0x3acfd614, 0x49f81583, 0x342e89f2, 0x55227615, 0x13ab3079, 0xa0c397c5, 0x6f6489f1, 0xc7025a1c, 0xfc0e92be, 0x0b46fc30, 0x7e668ed7, 0x805c01e8, 0x62c9a489, 0x9ffa9fd7, 0xd7c0da6a, 0xdd7a9709, 0x53396773, 0x3fb04ecb, 0x4de7ccd2, 0x8f7dd85b, 0x614e4097, 0xae63452a, 0xa4be9b36, 0xbe7526c2, 0x0000021c };
const u32 bern_num_data165[46] = { 0xf17de0df, 0xecfbe319, 0x2c92cd4e, 0x26211d7a, 0xe6722cc9, 0x6738df0f, 0x1cac9827, 0xaa56910d, 0x3e3fab1b, 0x65f53bfb, 0xba12919c, 0xa8848c9e, 0xbaa77377, 0x825a6003, 0x684c5b6b, 0x326220df, 0xde1e4f11, 0x0385004b, 0x34fa8046, 0xf189fe0a, 0x579e5121, 0xa5368714, 0x79940fa7, 0x79e67f18, 0x3fc7223e, 0x7d895aea, 0x2cc9a673, 0xb848e80e, 0xe4a2fcc2, 0x8eb46164, 0xe3f45b4e, 0x4174f28b, 0x89358657, 0x052e5d7c, 0x893dff5e, 0xb0af095d, 0xb2232a52, 0xf2bd8ce1, 0x215121f6, 0x002e3ffe, 0x6901ce41, 0x04187b7d, 0x9ff68b11, 0xf73a0466, 0x08441daf, 0x00000001 };
const u32 bern_num_data166[46] = { 0x89695787, 0x3b69ff7c, 0x2b7502d2, 0x525fd57a, 0xbb3b53af, 0x6db56896, 0xdb3c704b, 0x4eb1f092, 0xc822bbef, 0xacd67126, 0xbbbe43b1, 0x858edc56, 0x18d90586, 0x3883ec03, 0x18cc2fc1, 0x16bdb1b1, 0x66c6b09f, 0xbeac6804, 0xac2ba4e6, 0xe42adde8, 0xe59d592b, 0x851800d3, 0x3e814715, 0xa3839bb6, 0x18be9ae9, 0x37c18d7b, 0xb8b949e6, 0x4c5fed60, 0xedb9f930, 0x8f851905, 0x49c6b5de, 0x0f5f3129, 0x45a17103, 0xd760a7b4, 0x1cb26ea4, 0xd8f7117d, 0x29c7408c, 0x6c53a631, 0x4f811cbb, 0x9aba727d, 0x97afb02f, 0x64cc12ac, 0x40bdaee3, 0xd103668c, 0x7ba1edd9, 0x00000003 };
const u32 bern_num_data167[47] = { 0x6067d225, 0xedeb9d68, 0xc8881a01, 0xe61a9ea0, 0xcbb8847b, 0x9d4e6f8a, 0x3216dfd4, 0x146e4b08, 0x8e2b9387, 0x87846fbc, 0xb5a63058, 0xa76803cf, 0xb94136d9, 0x46906f8f, 0xba50a378, 0xc3d46464, 0x7c7b6cb2, 0xd528a418, 0x03950e2b, 0x0e70b158, 0x46c37472, 0xf994547c, 0x63194063, 0xf9444d81, 0xf5760969, 0xea0a8187, 0xb1334b22, 0xe8f0323a, 0x74542f60, 0x5d194384, 0xe98e0bdf, 0x5e7917b1, 0xbb85df18, 0x902ed9a0, 0x7ccec177, 0x5c5d094e, 0x0d1debc0, 0xb3662968, 0x5af6cefa, 0xc5947409, 0x574a25de, 0xc39948ec, 0x4451d453, 0x83ff17e1, 0x5c5c8aec, 0x8885127a, 0x000cf575 };
const u32 bern_num_data168[46] = { 0x3a5cf1df, 0x0a5534b7, 0x0c06a32a, 0xe48a5043, 0x474fb8a8, 0xd9400dfb, 0xeeb1d70f, 0x94daa94f, 0x17221191, 0x038bab32, 0xbf58d72d, 0x234f8abf, 0xb0d0606b, 0x9ad2bcd6, 0x49693e50, 0x703dc152, 0xe1a59576, 0x6f36e984, 0xaa01e92c, 0x20b12906, 0xd0ce0b19, 0x2dbb1af7, 0x7dcb265a, 0x1108d5c9, 0xfc1ca3ae, 0x29b00154, 0xce02cfca, 0x1e17dacf, 0x5133b525, 0xcfac5349, 0xc4d25fc8, 0xc4182021, 0x8bd39d96, 0xcfebfdb0, 0xee779f30, 0x90552a16, 0x0c7889ca, 0x76c34386, 0x0e70adbd, 0x3de87967, 0x29e1e3da, 0xb23e1159, 0xa07b6b31, 0x1906a0ef, 0xebb2d32a, 0x01b53271 };
const u32 bern_num_data169[47] = { 0x6ac3c993, 0xea099e94, 0x0e4c1ef5, 0x4b3770cf, 0xddba1522, 0xd192db0a, 0x7ebf42b8, 0x41273233, 0x795c20bd, 0x2c6e9979, 0x4a4eb28b, 0x230ff67b, 0x77525089, 0x0be9c331, 0xc41522fa, 0x78e32a76, 0x0cb9752a, 0x39a7e6d0, 0x25e41399, 0x804ab9a1, 0x67cdfbcd, 0x1f8f7ef6, 0x0fb91ea0, 0x5abf7359, 0xe4a7b151, 0x8046194b, 0x6c6d96d5, 0x673ba99f, 0xc1748e8a, 0x7dd85797, 0x97fe3f54, 0xb103a35b, 0xbf7d89aa, 0x61ffe9bb, 0xf3d621c6, 0x44f924fa, 0x3005cff6, 0x24e0c3c2, 0x511751aa, 0x9f41864b, 0xd6fe5141, 0x82f29dc1, 0xe542adc3, 0x12dd10bc, 0xf15fe778, 0x387066ff, 0x0000042f };
const u32 bern_num_data170[47] = { 0x685e1113, 0x2338d07c, 0x811347fe, 0xd67e6447, 0x0c2d1bde, 0x2300f709, 0xb0f78b20, 0xf2f7cd4e, 0xce7e3993, 0x6414186c, 0x5107c3c0, 0x3bb3b4f9, 0x43932bd7, 0x7f6ed9a9, 0x39489252, 0x4d2ec468, 0xa7fba432, 0x5a60c20d, 0x03d7ecb4, 0x136591cd, 0x4baed2d1, 0x1668e7e8, 0x50517a93, 0x03a8c91f, 0x9aeaba07, 0x58078e40, 0xe14feeab, 0x9f23ac56, 0x03595b5f, 0x97284280, 0x98c6af79, 0xa919e6fa, 0xa7217702, 0xa04d9ee3, 0x1516fc0d, 0xb2c9a119, 0x34e7d749, 0x8987c9b9, 0xd5c68c3d, 0x7e27104d, 0x3455de5a, 0x7fb776bd, 0x073a4295, 0xbc6714f7, 0xd3e50bc4, 0x9e620efa, 0x0074c38f };
const u32 bern_num_data171[48] = { 0xd708894d, 0x065f7c06, 0xc04eedfc, 0x1c877a0c, 0x3698b784, 0xa0c47ddd, 0x0c94e9fe, 0xf578c430, 0x26d8a416, 0xe2b40d97, 0x01ec44b7, 0x8052f2d2, 0xeb63464d, 0xfb6d874f, 0xad922910, 0x06339d53, 0x7c585fa1, 0xa734778b, 0x0c49d27b, 0xafc8c30f, 0xdc3dfeec, 0x124cb3f6, 0x2acf1ac4, 0x97255b6b, 0x6eb087ef, 0x8eb96314, 0xb7ef374c, 0x721a41a1, 0x265bc891, 0x6c67adfd, 0x39785ef0, 0x2c52d525, 0xfb87aef2, 0x7a741cf4, 0xb7b9aa10, 0x383e5dfa, 0xb7126c89, 0x903345a1, 0x852435d6, 0xe78719ed, 0x98cfe858, 0x49cd4f2b, 0x62b86ca3, 0xca4d7068, 0x79b6b333, 0x1f07b97f, 0xa1f6c068, 0x00000022 };
const u32 bern_num_data172[48] = { 0xffffba55, 0x75509b56, 0x1f6e1b99, 0x22e91e5d, 0x132d7471, 0x7424cff8, 0xd704a4c9, 0x5e0b5125, 0xb1627c88, 0xda015410, 0x1674cf21, 0x31698300, 0x6d95f341, 0xa2b32d2d, 0x0208ca68, 0xb9af1502, 0xc0cc0002, 0x88f2c095, 0xcd4378db, 0x417e7aae, 0x8262fda5, 0x1b7e257e, 0xbb4a1f69, 0x986db981, 0x3b0ae177, 0x9cff1397, 0xa7aaf6b8, 0x48231d6f, 0x5b42427b, 0xe4d60a0d, 0x2dad3d8f, 0x739eb1ac, 0xf1ec882e, 0x407764ac, 0x0bf3eeec, 0x8d9eff65, 0xe41e527e, 0xfc3093d4, 0x29ff6dec, 0x7070640b, 0xed84179b, 0xe609dcac, 0x0c72e852, 0x4c01ebfd, 0xaee4daff, 0xf7363f78, 0x459c98cc, 0x0000a418 };
const u32 bern_num_data173[49] = { 0x3d7ab5bd, 0x1a9adf9c, 0x8d0382dd, 0x95103a70, 0xb8187352, 0x3b6950b9, 0x2b20f95e, 0x8fcd7e36, 0x0e919fdf, 0x42a8d6b3, 0xdc85d6b0, 0xaf507805, 0x83cf84e6, 0xabe615df, 0x41164f3a, 0x7e8b16cf, 0xf52a4dbf, 0x47e012a4, 0x95e2d8af, 0xc1738097, 0xd1fd91bb, 0x8842a0e6, 0x60ec99c7, 0xb2d5713c, 0x7d776c4b, 0x7dd5d73c, 0xa0b3d31e, 0x62b6f8aa, 0xe40dfb9a, 0x7959bb63, 0x4de57aab, 0x89de8660, 0x413c901e, 0xd4bdd59c, 0x9c0fce9d, 0x0298c922, 0x497f4e34, 0x5eecf9ed, 0x896733a5, 0x5fd6baab, 0x5cde65b0, 0xb2284f58, 0xdae25191, 0xcb915bcf, 0x1c87ca59, 0xb0ea536f, 0xed51e8da, 0xc303b441, 0x00000327 };
const u32 bern_num_data174[49] = { 0x100f4bbb, 0x0b9f6bdf, 0x2357e0f4, 0x28851567, 0xcf879bdf, 0xfb15eaa9, 0x950fb899, 0x1a582ae8, 0xdc704f3f, 0x7f0d708f, 0x44f4aed5, 0x3233ae78, 0xe99964c4, 0x5a566ae2, 0xad6572b8, 0x2d951c5c, 0x5ebfd052, 0x153e2d91, 0x03667c4b, 0x5f5330c7, 0x83669dd4, 0x2cfb81f4, 0xd0cbce8c, 0x0eecbad4, 0x7f7c1afb, 0x66288fdc, 0xff6be949, 0xfbe2d353, 0x5014bdf2, 0x3a16a10a, 0xa972e1d7, 0x0a3b7a90, 0xa9f23b6e, 0x49020d2b, 0xbca68834, 0x6d2cc205, 0x583671dc, 0xe1ceb7fd, 0x3c95149c, 0xb370fba0, 0x49410b49, 0x148b54ba, 0x80d0a1d6, 0xcd2a9047, 0x2c8aac4d, 0xf977d6f0, 0xb30a12d2, 0x57d8d4a7, 0x000000d0 };
const u32 bern_num_data175[50] = { 0x0a834adf, 0x74b088b1, 0x4574718a, 0xb7b7a4bc, 0x90d46e1d, 0x58de6872, 0xe6c9f31b, 0x980dede6, 0x7977e6aa, 0x142a8e70, 0xf989a393, 0xa529e9ab, 0x2367cfad, 0x8dd6967c, 0xc9272e0d, 0x0d0208aa, 0xba25f719, 0x3c473240, 0x589fcd60, 0x6e8794c0, 0xd0fdbaaf, 0xbccd7641, 0x15b6edf7, 0x847cdcf5, 0x8e3828ce, 0x167ac634, 0xacd312bd, 0xa9989252, 0x1ec56967, 0x75034614, 0xd99ad799, 0x97063e14, 0xc4f2d8c7, 0xfbfd4fe3, 0xe186b4ca, 0x747665e0, 0x57554a91, 0x42f17dd6, 0x0eaa1e01, 0xc692424e, 0x219ffe92, 0xca92cfee, 0x4cec8296, 0x418b3fea, 0x11dc0e03, 0xa7e0e805, 0xa26e9b8f, 0xb2a1c655, 0xf065ba6a, 0x0000000b };
const u32 bern_num_data176[49] = { 0x0d7db5b9, 0x53078147, 0x5bc9e68c, 0xa33c6feb, 0x2c5409db, 0xc73573f4, 0x2715f0ac, 0x8f5239ab, 0x77ecfd63, 0x125e2ed2, 0x79040d07, 0x14b82f93, 0xf36e5869, 0x6178f2b5, 0x168da591, 0x60d97c27, 0x4d398abc, 0xf301e77b, 0x35d37feb, 0x81fc34d8, 0x6cc896ab, 0x13067e1e, 0x9bb32ecc, 0x8d0919ae, 0xf3b08bac, 0x64a84cba, 0x21af4202, 0x8b3d1b00, 0x7d208a37, 0xed7601ec, 0xc1d35445, 0xc83d3591, 0x9fafaf6f, 0xfa761f29, 0x7d911edb, 0x30d21770, 0xe8fd1155, 0x0760ab2d, 0x7ce4ff15, 0xca8416ce, 0x05688faa, 0xae1041ad, 0x816b8974, 0xac0dfa82, 0x6e074949, 0xe1e2cdab, 0x0c3c90bb, 0xb00dc8ef, 0x011a436e };
const u32 bern_num_data177[50] = { 0x9d04155b, 0x402a57ce, 0x337ecde0, 0x237131be, 0x040180f1, 0x706170ba, 0xd3ea8aa9, 0x27f077cf, 0x114bac0b, 0xc2958b78, 0x344593aa, 0xc3b27cd1, 0x3db92044, 0xd8f8657b, 0x0c6dee6e, 0x757d90ec, 0xf2db40de, 0x1a49eb87, 0x2fc81287, 0xf26c7e9e, 0x0ed1e97e, 0x8713e862, 0x4151c203, 0xdff1013b, 0x9935d3e0, 0x9e988e8e, 0xa1bbb47e, 0x3b6aeb32, 0x8a0ee2d2, 0x19d9b919, 0x84b56df6, 0x143b4fdb, 0x12685c96, 0x93dda59d, 0xd2e58ea9, 0x7b4d2f1e, 0x12c3e7ee, 0x8e421e75, 0xe3902ddf, 0x74c4c4c4, 0xb9945649, 0xa0b19a6b, 0x416cfd21, 0x6fe1b65e, 0x1acad344, 0x84ce9c97, 0x62dcbc47, 0x54097f8c, 0xdc9ce4a6, 0x000006e2 };
const u32 bern_num_data178[50] = { 0xe2ee9941, 0xcb4570ce, 0xa88eece2, 0x6539d98d, 0xac47f0c8, 0x3ec34bdc, 0xfbfad5c3, 0xf3ae2b22, 0xb43ab744, 0x12499c0c, 0x0fef11c4, 0xe5f931a0, 0x0d93a96f, 0x4e381f3a, 0x9fcdf886, 0xbda8ba25, 0x66ef66fc, 0x5066aa48, 0x995403ea, 0xa4f2eee3, 0x37eb60bf, 0x4359f030, 0x79561ffc, 0x70024e00, 0x89739171, 0xe18273ef, 0xb0f6e5f5, 0x75519cba, 0xcd22f643, 0x812c20be, 0xcf13cc19, 0xc0b644fa, 0xec13cbcd, 0x212fdb21, 0x4a1431f1, 0x97223315, 0x0ee009f0, 0xa0a44c3d, 0xd10c852a, 0x99f2e23a, 0x0f49564e, 0xff01723f, 0xaf87ebc6, 0xe7f74e8d, 0x270bd0a0, 0xd6a2980a, 0x9c57bd8e, 0xa0d2000e, 0x837e8a70, 0x0022ee22 };
const u32 bern_num_data179[52] = { 0x366fe799, 0xdef3f53b, 0x1f7ec981, 0xd88bb9dd, 0x46c9bc00, 0xfb0122f2, 0x2b597834, 0x760d1a4f, 0x1931c4e5, 0x22803e01, 0x20c538e0, 0x8192350f, 0x6f26e5c0, 0x65a77c96, 0x8b48122c, 0x1c19169d, 0x635bd882, 0x85c9cc64, 0x3b144bf0, 0x356d49b1, 0x7c99be6a, 0xb3e181e1, 0x0917bda7, 0x05be1772, 0x04eaecad, 0xdb7c9ce7, 0x40276fc2, 0x332451eb, 0x94d76e97, 0xc51d9810, 0xcb3c12ba, 0x25b44de3, 0xfcdee6a1, 0x944784b3, 0x3cc713ce, 0x8ffb984d, 0x72dc9a53, 0xfe6bb6bf, 0xab7bc630, 0xbd9cd318, 0xd9d36035, 0x510756db, 0xd3ff02fe, 0x2261461b, 0x20773862, 0x8349b689, 0x69bcd862, 0x7d6af9e7, 0x8a326f75, 0x739249d6, 0xe01f9c7a, 0x00000fee };
const u32 bern_num_data180[51] = { 0xb41a006f, 0xe2cc8d5f, 0x1c4f96d1, 0x29d97542, 0xb6428a4e, 0xb48f3f4c, 0x8d99fe4c, 0x66adf108, 0x97ea7961, 0xbda2072a, 0x2ebe6a3d, 0x23c12b59, 0xbc508d3d, 0x6ae76f77, 0xa21198ff, 0x7f9195eb, 0x30a74c31, 0xe4abaa85, 0xffa6f024, 0x97b445c2, 0x026a9c8d, 0x213ca2ad, 0xa74f5806, 0xbe58a6dc, 0x481dc55a, 0x4976cb5b, 0xa4fe50b1, 0x3e9dfde1, 0xa4036f7b, 0xf6b50fd7, 0xf6c6d4d5, 0xef656135, 0x4c06d210, 0x43e8c8cd, 0x400e214d, 0x3ed31c89, 0xb264a65d, 0xc2d94547, 0x35b7912e, 0x0611f985, 0x1e4ff704, 0x5011546b, 0x68662d73, 0xe42e2ff8, 0xa11f4f46, 0x1daa1f03, 0x432d3d22, 0x7250b23c, 0xdd78f3b1, 0x16b30332, 0x00000010 };
const u32 bern_num_data181[51] = { 0xb53c4949, 0x87b55487, 0xb9cb1d93, 0xc2ab4411, 0xc47b2d24, 0xc5fe740b, 0x31d408f9, 0x9262bfdd, 0x282615dc, 0x2bf7b090, 0x42e948ef, 0xffa87298, 0x7c868b8d, 0xd40cbd19, 0x15389d90, 0x9e7ce3e5, 0xed4f82ec, 0x4ee78a74, 0x89436a7b, 0x0ee1ce19, 0xb4f1c37c, 0x50b89e81, 0x688c4eb8, 0xc96ae4c9, 0x26f99a5c, 0x3d39f46e, 0x3b50a7c4, 0x922e02d3, 0xb9073f99, 0x8c464068, 0xe5af32e4, 0x7769e04d, 0x49612073, 0xffcb9e32, 0x5c2f515b, 0x5511616d, 0x7f53449d, 0x137ad5ef, 0xbe986619, 0x424373c1, 0x9b00e4a9, 0x82c3e942, 0x4ba940cc, 0x07810fcb, 0x5b45a39d, 0xf87146f7, 0x97f21102, 0xa7d03566, 0xab5d7b6a, 0xa3fa530a, 0x18aa674b };
const u32 bern_num_data182[52] = { 0xe9bc487f, 0x02100a2f, 0x049bc9c4, 0x5a059b68, 0x3b96c690, 0xff783933, 0x282463be, 0x831e66b2, 0xa3e6d74c, 0x7ba4291e, 0xa2ab0d43, 0x0ef941cb, 0x01364621, 0xcccca8f5, 0x91d958d2, 0x9da4ca0c, 0xe8149ad4, 0x84f92035, 0x0fedea46, 0x642b9bc1, 0x9a85bb03, 0x3f3bc5c5, 0x24d914e8, 0x4cf5fe3a, 0x00907efa, 0xca72904e, 0xb4378630, 0x7a7b354b, 0xa73bd448, 0x087fef3f, 0x97628767, 0xb42967f6, 0x984b0ecc, 0xfc77c23d, 0xdeda1faf, 0x37546e47, 0x70cfee63, 0xb900fa2f, 0xa720d556, 0x044cb478, 0xbc721362, 0x8fb7bcb2, 0x516bd8ad, 0x70b7bfaf, 0xd8bac1e5, 0x44987fae, 0x05cfac62, 0x86ad9b42, 0x61f0daa8, 0x5ff7bd0b, 0xfd73cf58, 0x0000006c };
const u32 bern_num_data183[52] = { 0x8f95174f, 0x1a21dcbb, 0x020b3036, 0x93d6262b, 0xcacea2e0, 0x42b3b212, 0xee16a67a, 0x0c6892b4, 0xde99c72d, 0xd0a10cdc, 0x1bfa6abd, 0x9df4962b, 0xb81f47b8, 0x4fb74e8c, 0x787b58b5, 0xadd10bad, 0x4ab945f3, 0xd1323504, 0x05d23d8b, 0x2bd3d587, 0x1bffcdbf, 0x69fe46bb, 0x2d36d896, 0x66820849, 0xa2651b46, 0x5254013e, 0x4aa19453, 0x93e83823, 0xe455d40e, 0x9415d27c, 0x1cbde715, 0x6f9c50cc, 0x6a65836f, 0x81a25df0, 0xef9d144d, 0xa3ffaade, 0x0ac21d8d, 0x6447267b, 0xc4056d3e, 0x1e08e0bd, 0xffdbf4ce, 0xb952b56a, 0x2b6e6de1, 0xd1c1748e, 0xd0d0fba3, 0xc4f8cb11, 0x2613a3bf, 0xa36b119d, 0x1254cc2c, 0x5cea36d3, 0xa3d24f53, 0x0008d8ec };
const u32 bern_num_data184[52] = { 0xc04760d5, 0x0da2f8a3, 0xa8a20569, 0x8c597dd9, 0x07cb4ad1, 0x6d654271, 0x7531366f, 0x5b6f3d74, 0x4da2ef9f, 0x18381147, 0xb8e563a3, 0x680562c1, 0xe05bca1b, 0xbb35e4e0, 0x8d456cc1, 0x09226478, 0x3a265cbe, 0xce580065, 0x0a7b1725, 0xec6a0de4, 0xff30b641, 0x1c2b72a1, 0xdb2df76e, 0xb4f07d2b, 0x5cc90a87, 0x4538d199, 0x58837f12, 0x24a0c717, 0xef353c88, 0x8d5952d2, 0xf78b7c74, 0x5dd77867, 0x915809bb, 0xa360be83, 0x28d488b8, 0xe0dde68e, 0xb4fa57a7, 0xadb17647, 0xf4ed967a, 0x9d3d4a53, 0x7e5a0175, 0x4b480111, 0x8a62cf82, 0x9e97824e, 0x6678a1c1, 0xcc0823fd, 0x6d5a47d1, 0x3fd2e44d, 0x26e6eb3b, 0xb1950568, 0x87c28cd5, 0x00543f68 };
const u32 bern_num_data185[53] = { 0xd26484ff, 0x77a46d41, 0x6d5366f6, 0x34cb5e0b, 0x01584348, 0x57035141, 0x7cd2f15a, 0xe7d73472, 0x496ff9c4, 0x1452fa1d, 0xd47ec9d3, 0xbdf64bfa, 0xf40dd381, 0x64b5deb5, 0xc5c75e17, 0x26ad7394, 0x52c78205, 0xa73d4193, 0x4e503343, 0xd689593d, 0x565a2cfc, 0x1569991e, 0x8c8912d4, 0x340ae18f, 0xe47952f1, 0xc68d39e3, 0x15f4f772, 0x16274bc3, 0x311543eb, 0xe2c30d71, 0xcf1bb2e4, 0x310dee8c, 0xff18fd4a, 0x850eaee9, 0xa2f3693c, 0x56df3d98, 0xc5633fac, 0x516de9df, 0xae2dfe6b, 0xf0d751a8, 0xe4a74364, 0xb8532aba, 0x783c87a6, 0x8e600999, 0x34c71eca, 0x1fbda7b4, 0x1945904b, 0x90b8c304, 0xddc2a788, 0x9229f136, 0xc12cdc10, 0xa0eb1e3f, 0x00010ed8 };
const u32 bern_num_data186[53] = { 0x1d9df7b1, 0x56cff37d, 0x6df63999, 0xd9d8bc74, 0x4f489bc6, 0x25630909, 0x0aa0b474, 0xe1791c5a, 0xadc80723, 0x0c8b7ddb, 0x90a88469, 0xa38f5dac, 0x65f33354, 0x0f00057c, 0x8e97abee, 0x391a5c6b, 0x24f7c1c3, 0x32014ab5, 0x61656eaf, 0x70b18ddf, 0xb5addf4f, 0xc23a748e, 0x91621d1f, 0xced7dac0, 0xc0792780, 0xa2d0f281, 0x9c7c2040, 0x4db74328, 0xe21ad5af, 0x8ad391da, 0x51d06f47, 0xc4d41b9a, 0x8d1129f2, 0xbe80084e, 0x9c0829c3, 0x77d1126b, 0xea0617e3, 0xcdbd4a09, 0x816dfedd, 0x22d171c4, 0x24d5be89, 0x2fe403fd, 0xbe65ff33, 0xd3ca7c6d, 0x1a467dea, 0x246240d1, 0x1ebb311d, 0x495badd3, 0xd3d68b03, 0x4c6fc65c, 0x15b82397, 0x0c24b2c7, 0x000081b4 };
const u32 bern_num_data187[53] = { 0xdabcb961, 0x4f6c66f4, 0x714bd445, 0xbb397112, 0x3734d5a9, 0xad1a286f, 0xdfd95a49, 0x0b507c32, 0x1a1c725b, 0xa6386043, 0x68b54cb3, 0x7820fe7c, 0xcb109131, 0x79b25f6a, 0xd6b7fd3f, 0x6137c22e, 0x4d492b35, 0x88275026, 0x2a69844e, 0x79f69d0a, 0x25598641, 0x4ad00c72, 0x94222e67, 0xcf8ae3ae, 0x9063b513, 0xe620d2a8, 0xd050632d, 0x14bf4bab, 0xc04eeb73, 0xeed7213b, 0xda3cbff8, 0xfd8f3beb, 0x07620769, 0xbd8e7f22, 0xc4d6097b, 0xaffb6cbd, 0x45dc0b64, 0xf4f33659, 0x76680f77, 0x85095815, 0x7df8f2ab, 0xd2761402, 0x02b779a5, 0x79ccdc58, 0x4b8b8bc6, 0xcf30d21a, 0x3ac27e26, 0x746e9faa, 0x48a89ccf, 0x241c9497, 0xe53fd80e, 0x3e61ce4e, 0x0189615d };
const u32 bern_num_data188[54] = { 0x09e30fbd, 0x62813cff, 0xc2ddee86, 0x272df1d5, 0xc08ebe07, 0xae3415b6, 0xcbca3d50, 0x77255e2e, 0x13dc0c37, 0x3ddfe7ee, 0xcda9720e, 0x531902d4, 0x665f2517, 0x52e4755a, 0x817e9d6d, 0xaabbea28, 0x016e798a, 0x75743d44, 0xbb13bb3e, 0x78f614ed, 0xdf81c905, 0x6131cddf, 0x2b1410fd, 0x28495e43, 0x24422e5b, 0x6b145919, 0x7c138e1e, 0x3348546e, 0x76c8eab8, 0x2f8d28c3, 0x51870fc3, 0x38f4722c, 0x40bf417e, 0x09a90ca2, 0xfeb5ed44, 0x513eebf1, 0x79448751, 0x2bf204c8, 0xc9ce2b6b, 0x70d5c915, 0x9eeb178a, 0xfcdbb26c, 0x0d47a800, 0xf3edfa93, 0x9eff1295, 0x1369a6e2, 0x969a85b0, 0xfd8339f9, 0x36699d9b, 0x2e2001cb, 0xdbc81c72, 0x0b5783e9, 0xda2d82ba, 0x471a011e };
const u32 bern_num_data189[54] = { 0x46c11fbd, 0x7c2a05ee, 0x151e55f4, 0x4fff4b8d, 0x90fe4009, 0x451c4322, 0x2b2dd7a5, 0x801278c2, 0xfb4e437d, 0xb7b3eb8e, 0xcf76aac4, 0xd21b9dde, 0x581c2430, 0x1d39f730, 0x6542bf53, 0x082adc31, 0x05efaf70, 0x80e4e23a, 0x5e84aa03, 0x497071e7, 0x864073b8, 0xd9cc3b48, 0x306c3ce2, 0x43c4431e, 0x3494d88e, 0xbbd8d95a, 0x173f2a7d, 0x80b19349, 0x26725daa, 0x2b84b58e, 0x6ccebda4, 0x24f2f3bf, 0xfdcb2f14, 0xaaf06947, 0xdf94ebf1, 0xf53772b7, 0x64c848d3, 0xe3cad45b, 0x816507a8, 0x474ffd41, 0xc024be72, 0x77f614ff, 0xae6ca159, 0x85a3dcf2, 0x483f224c, 0x2bae802c, 0xbf7b26d0, 0x205ec02f, 0x4ac27c58, 0x8330a4b8, 0xa34d8a8d, 0xef35d40e, 0xf67e6fb0, 0x09e60cff };
const u32 bern_num_data190[55] = { 0xc9d309d9, 0xcbe9df8b, 0xfe30c21b, 0xb5e2ed24, 0xd7f291c2, 0xecdf44b6, 0x73a47733, 0x5e7c3c68, 0x3571c486, 0x00c383ae, 0x67af805a, 0x7db4068b, 0xfe890375, 0x8b12fae1, 0x61eddb7a, 0x3f1d4283, 0x89068d4c, 0xc0ed0dd0, 0x8b637de0, 0xf17cf467, 0xf38e91fc, 0x8b607bf2, 0xb098d435, 0xe068b9b5, 0xa3215bd1, 0xb9582c34, 0x80078b35, 0x60533a42, 0x7f413896, 0x28812b8b, 0x864ed70b, 0xeb6db0a1, 0x7cc19ef8, 0x47563b41, 0xe7b728e4, 0x3b709ae1, 0x4adcb176, 0xeea2efaa, 0x9fd5ab4e, 0x998e7deb, 0x4a20a2d1, 0x37b38af1, 0x497d5336, 0x08dbef19, 0x2c164801, 0x2b1301e7, 0x33fcae2e, 0xaa923e9f, 0x14c5c890, 0x3c55f59b, 0x8b71f542, 0xd5a2566a, 0x67403a3c, 0x32798f59, 0x00000005 };
const u32 bern_num_data191[56] = { 0x2ccb8cbb, 0xd6dc3149, 0xdd9e1a8b, 0x0dbf4105, 0xae27099c, 0x5a491420, 0x2057cc0f, 0xc02407cd, 0x049fe1f7, 0x5d67a24b, 0xfd939474, 0xa3ca3378, 0xe56fda46, 0x69c78985, 0x39ee8afb, 0x1662dec5, 0x7f9d963c, 0xa0b32188, 0x3306e445, 0x65d66209, 0x0616f3a2, 0x52fee9ba, 0xb259d077, 0x6b43e0a2, 0x0b00568f, 0xeb755980, 0xc490e6ba, 0x25c5672b, 0xbf41bf34, 0x40c15447, 0x83928234, 0x5dcbab89, 0x1ec16179, 0x32ed4e3f, 0x09887e21, 0xd31e4bae, 0x4d945bc8, 0xc86dd761, 0xba681bfe, 0x5207a9e7, 0xd3848f1e, 0xbad448a9, 0x3a0466d4, 0x7591e7f7, 0xe3b0c44a, 0x4f212522, 0x3b96b01b, 0xc2c275eb, 0x4cb2ff92, 0xa1cc99c3, 0x17f6ce8e, 0xc6931f55, 0x0324f101, 0x8a7d014c, 0xb4529265, 0x00000001 };
const u32 bern_num_data192[55] = { 0xe33ed8ff, 0x15cfacf6, 0xcd892cfc, 0x38059c47, 0x4e988336, 0x6dbb1bce, 0x8c129355, 0x4b13dfa2, 0xa878fe6d, 0x7addfa89, 0x543006e7, 0x681c25cc, 0x2942a3ed, 0x3917f661, 0x93a7eaf2, 0xa616dec7, 0x92cd670b, 0x9cd54b6a, 0x8e26792e, 0x02d9dea0, 0x5889def0, 0xb37a3dff, 0x619b6871, 0x790d8f89, 0x17e8e121, 0x26fffde4, 0x95b9293d, 0x56e80dac, 0xff919685, 0xce900e7a, 0x3e0c4843, 0xf9346d3b, 0x18f0ad08, 0xf36e22b1, 0x02fe20ec, 0x73b6320b, 0x6813e6fe, 0x0f2579c5, 0xfa230fbc, 0x6ead4f9a, 0xc2832dd1, 0x46f6d22a, 0x4c618076, 0x1d942e5e, 0x1520bd20, 0xee16b1b9, 0x261b501b, 0x2a398c50, 0x7c4e1030, 0x5efcd1f5, 0x721b52c9, 0x2f146fd8, 0xa9b16e60, 0x9c2655df, 0x0002e756 };
const u32 bern_num_data193[56] = { 0x2df60c5d, 0x0ab195d0, 0x6d970325, 0xe67a362c, 0xe35a56e5, 0x33d3bcf5, 0x18647710, 0xbaa25045, 0x563c9f30, 0x5ae5a4a6, 0x79436f0e, 0x69b59e3a, 0x47284d61, 0x167ddea8, 0x068dc9c8, 0x4af3ebee, 0x178dd6cc, 0xa2841954, 0xea04661e, 0x8862bc39, 0xddffe529, 0x5b26d8d1, 0x37666b41, 0x5cf1024e, 0x3174e47d, 0x2a566088, 0xb18bd1dd, 0x1bfec913, 0xd64117ba, 0xefd933ac, 0x7651e755, 0x2c8d7549, 0x7b0d6922, 0x562e2ddf, 0x652cca00, 0x69d2461b, 0xcd014306, 0x05f2768a, 0x52f14674, 0xdfa2f766, 0x84e97445, 0x0a965f2f, 0x860cdf68, 0x61f78bc0, 0x71f0ed3f, 0x420c7bd2, 0x8d7292b4, 0xda95f9f2, 0x25fc7eaf, 0x8a9c5c99, 0x13932942, 0x1e41b998, 0xdcf4fbd2, 0xe8644ed7, 0xc51df291, 0x00000147 };
const u32 bern_num_data194[57] = { 0x401c8211, 0xea8d5f80, 0xac376be9, 0xf66ccf19, 0xea50450e, 0x4e09c89e, 0x33e316d6, 0x7d6b5949, 0x5bba9f2f, 0x4b490667, 0x631f19f6, 0xd1242d4a, 0xff5ea93d, 0x32cea46a, 0xecff44cd, 0xfceaa84d, 0x828b4ef2, 0x6d3e5767, 0x44fa6194, 0x95f5665b, 0x25bfc568, 0xfdc77caf, 0x02688604, 0x26211dd1, 0xf4a57ced, 0x73e2e426, 0xf0c2c2f3, 0xcd82026a, 0x69e1551a, 0x4ea11efd, 0xa7c88186, 0x6b4d6e83, 0x8d502944, 0xc24f9368, 0xfa2c8033, 0xb394dbf9, 0x004bf426, 0x84ca3e89, 0xb8f015a3, 0xa3e59ed7, 0xf52333e3, 0xc26de217, 0x994a3818, 0xab1ee988, 0x20c741e2, 0xb1422265, 0xb6ee32a5, 0x0f2ba262, 0x034f6f13, 0xe538e34e, 0x0fd42e39, 0x8661db81, 0xc4695ecc, 0x740bb239, 0x063103a5, 0xb988046e, 0x00000003 };
const u32 bern_num_data195[57] = { 0x1a2e18d1, 0x36a59569, 0x0372a1ec, 0x3e2d3b34, 0x5bf8771a, 0xa201ca5a, 0xa2b05574, 0x9555b882, 0x38dbe0b4, 0xaaebcac0, 0xcdc4e814, 0x6ad05c99, 0x8a9dc3e0, 0xe9369b18, 0xec79cbd3, 0xc47adbe1, 0xe159c890, 0x0ba9586d, 0xec519a1f, 0x6f4fc038, 0xff1ed085, 0x63901d00, 0x143b384e, 0x8f16df35, 0x4c8db78a, 0x515590c8, 0x7b3363aa, 0x5da78724, 0xa5c33068, 0x27a27b17, 0x57b2ad57, 0x875e63f9, 0xdb694727, 0x8d4a56d8, 0x27fe69d5, 0x7e7719df, 0x4b5fab3d, 0x26949ab6, 0x22e10f20, 0x232ebd30, 0x267d4a7f, 0x9b18eae0, 0xca55968a, 0xf26d4de1, 0xbcdf6e63, 0xd81f1ee8, 0x136e75ee, 0x5ae1bbfa, 0x412bbf2d, 0xdfede4ed, 0xdcfbc2d3, 0x54101b75, 0x431324dc, 0x53b9d7e5, 0xfbbdb096, 0xb8c40d9f, 0x00000010 };
const u32 bern_num_data196[57] = { 0xe7fe152f, 0x21821036, 0xf4e70cad, 0x22d0a014, 0x4b532c92, 0x4d8de9dc, 0x6262f554, 0xcdbb9d02, 0x66670d2a, 0x1ea824df, 0x11d2edbe, 0x03df22b5, 0xd85f2d56, 0x615d895d, 0xa9eb73e7, 0x39a5eb1c, 0x3e53b37f, 0xe1dd48b1, 0x06be5312, 0xa6066f8a, 0xe162ca00, 0x269f378b, 0x3c671937, 0xa24b8bfa, 0x1bcc0cb5, 0x525a7707, 0xdebf9ec9, 0x293f8fb9, 0x18c3f24d, 0xfa5b8afd, 0x654c8333, 0xdb444d36, 0xb10f069f, 0xa7c71233, 0x713009d9, 0xa009b32d, 0x2d83a0a2, 0xb54d3012, 0x9679f50f, 0x95fbc5c6, 0x4173d456, 0xbcb619f6, 0x8dec0320, 0x390f4da8, 0x06a8ea49, 0xa655649d, 0xbae211bc, 0x145aa80d, 0x6e23e4ae, 0x75d26ea8, 0xdf8063cf, 0x0bf91526, 0x1768027a, 0xd402560b, 0x4aa0eb14, 0x4bc830d6, 0x00000002 };
const u32 bern_num_data197[58] = { 0x5a6d80db, 0x932bfcc6, 0x333d1bc9, 0xa3cafaa5, 0xaca02a27, 0x8579fbe6, 0xc50ae0b3, 0x54f4f5a5, 0x51d70a60, 0x218b293b, 0xf38f666a, 0xf5e27579, 0x593d5b40, 0x9ba6156b, 0xe4bf0d65, 0x9b8f3ecf, 0x4b92d03b, 0x004da9ad, 0xd1e68ab6, 0x20645102, 0x2bffff44, 0xb91931fc, 0xa93f7f10, 0xb4d85930, 0x92620ffc, 0x064a77c4, 0xb9e1ac5f, 0x72dbbf3d, 0x65beca08, 0x336537f3, 0x6a5e2644, 0x36926e40, 0x4f16491a, 0x95569925, 0xc6488f8c, 0xccb4ab50, 0xe8f3d839, 0x0517cfdd, 0xe846e014, 0x40fcead9, 0x6c24ffbf, 0xe5c07526, 0xe6169609, 0xf17651b2, 0x6ed9165a, 0x88a638b8, 0xbc3db82e, 0x33c4e73b, 0x180650df, 0x95a42c02, 0x6fac1ded, 0x83f593c5, 0x795dc3b4, 0xf3ebd491, 0x37c9f653, 0x4f8480ed, 0xb7249e26, 0x04ea955b };
const u32 bern_num_data198[57] = { 0x59bd4907, 0xb593de2c, 0x446e8c6b, 0xc62d909c, 0x03f97147, 0x1f73c14b, 0xb595bbb2, 0x8387c3f9, 0x0abcf08b, 0x171eff8e, 0x4fde09b2, 0xafb2a1ef, 0xf8b0958b, 0x73f2257e, 0xe99d1ddd, 0xc23cf2fd, 0x07aceae5, 0x3dc6e238, 0x0f97eac2, 0x24d87708, 0x16276ee8, 0x0fed8c7a, 0x494ec860, 0x98beba74, 0x7aced20f, 0x71fa3fdd, 0x2aff63df, 0x8bc6de15, 0x1b6bca1a, 0xb27b0c2d, 0xdc670fff, 0x4ac403de, 0xb9fce738, 0x18262f39, 0x60827df8, 0x29b7e81d, 0x6d7adcc6, 0x8b2b10cb, 0x8eec0cc8, 0x989110d4, 0x539e4ffd, 0x5a0aae45, 0x2b41e21a, 0xa90f296b, 0x2de768e4, 0x3ee3e8e1, 0xd30ee39f, 0x6dcff04a, 0xef4a7e67, 0xe3327832, 0x91d2c095, 0xb0f3f49c, 0xa8d1623e, 0x72fbc772, 0x11ee3fee, 0x78de1488, 0x022b9339 };
const u32 bern_num_data199[59] = { 0xf2646a3f, 0xa62557b7, 0x78678067, 0xc5c3c97b, 0x9597dd0d, 0x7409de03, 0xd8e542f8, 0xcbe18a01, 0xa1e620e2, 0x2fb1566f, 0xe9b1b856, 0x73b01879, 0xee7e6e59, 0xb56fa235, 0xd48854a9, 0x0ea98b5e, 0x8d18c0e0, 0xe881853e, 0xdaecb12b, 0x6b421755, 0x580d9671, 0xdcf196cc, 0x8a289a09, 0xd507d34e, 0x8b25476b, 0xc698c6cc, 0x5e167e24, 0x71567f6b, 0xfe7044a5, 0xff578397, 0x118a989d, 0x391f75f0, 0xcaf16a13, 0xf3199f42, 0xcbe5237b, 0x285effa9, 0x24698319, 0x854c68c3, 0x3d0ebb42, 0xe6fdaa9e, 0xb7ed6e3f, 0x39bdb536, 0x388a8d74, 0x2cb651e2, 0x1af3aea9, 0x41706271, 0x2cadc717, 0x854520e6, 0xf66f0155, 0x8b80f822, 0x40a0ee55, 0x03865b7e, 0x12ead239, 0xa732f7c9, 0xb7c032e9, 0xb81d31a9, 0xfe39723e, 0x63978a53, 0x0000000c };
const u32 bern_num_data200[58] = { 0x14470f99, 0x1db641ae, 0x7d49777e, 0xea45ce07, 0x34324115, 0x114f6b53, 0x2c0eed79, 0x8d263b57, 0x2eaa4303, 0x737badaa, 0x09733317, 0x637cca7f, 0xf5fe98cc, 0x90fe0eee, 0x805b88c8, 0x72a338e8, 0xe307522f, 0x384c89d1, 0x85c6399d, 0x12201860, 0xe32ae4aa, 0x614b8b02, 0xe666733d, 0xcea6d4d8, 0x8b43cdb1, 0x31b5032d, 0x68917058, 0x37adc3cb, 0x6e26cef1, 0x0499df54, 0x10e36585, 0xdee4f5c3, 0x746f7d86, 0xa6965da5, 0x01cc30cf, 0x75b6c459, 0x29393475, 0x00c88fcb, 0x23354326, 0xc3b28143, 0xf17a69c4, 0x383e0f02, 0x80606051, 0x15adb780, 0x0739bb1c, 0xc6e36744, 0x188354f2, 0xc700ef5f, 0x67760fe0, 0xbddbb489, 0x45283420, 0x5e41881e, 0x3d959022, 0x982cef72, 0xa596648a, 0x9cfbd6dc, 0xd8c22318, 0x000ef286 };
const u32 bern_num_data201[58] = { 0x5be9c619, 0x22d475de, 0xd6fed492, 0x72169e47, 0xa108f6f4, 0x02218b5e, 0x1ba96ae3, 0xdc9ee4e5, 0x3a65c6e3, 0xa84f061b, 0xad9def64, 0xa506b55f, 0xb89cce7c, 0xbe644c0f, 0x6fe278dd, 0x12aecb82, 0xb90c62e5, 0x5180c55f, 0x0f3942e4, 0xf5bef54d, 0x756794bc, 0x93edfd32, 0xfeaebb85, 0x195de317, 0x572c0752, 0x339c4ed5, 0xdf221368, 0x17de0f5d, 0x029ad7a6, 0x77efe497, 0xd9199c67, 0x9eaa9e70, 0x13de2e06, 0xee7c1f0b, 0x9dd5d84a, 0xe9f3b593, 0x8f1dcd02, 0xa0a475eb, 0x49630968, 0x3cb7c982, 0xb3d78a04, 0xee1cdf67, 0x7e29acf3, 0xe16dfb1e, 0x054add99, 0x6986dade, 0x6d19150c, 0xa9146036, 0xc02fc34f, 0xa1c22d77, 0x4887874b, 0x709cc212, 0x3ff4edfc, 0xdeab7e9d, 0xe96bf96e, 0xf84a28e8, 0x850f96d4, 0xabff7e99 };
const u32 bern_num_data202[59] = { 0x143390ad, 0x573a1bdc, 0xaa508d34, 0x42b41443, 0x9204f413, 0xc3eb2cf0, 0xcf5696b6, 0xb623c0db, 0x105cef33, 0xb67f1751, 0x682bb64f, 0x9dfd0ab1, 0x0a7e7290, 0x94702a97, 0xf3d1e6fa, 0xaea29175, 0x41d10ca9, 0x884ff550, 0x7fcaa027, 0x82abb010, 0xcad8ddd3, 0xf48893a3, 0xe6326253, 0xe04815b7, 0x153b6f92, 0x84872e45, 0x0b3b1e0c, 0x95cdf39f, 0x34c2124f, 0x9483262f, 0x58a1020f, 0x9c137b05, 0x4d4148db, 0xd2759885, 0x50eb4c5e, 0x78a418df, 0x6dc0fed9, 0x7d832d33, 0x95d8d5cd, 0x4aa1849d, 0x52127309, 0xb460a3dd, 0xb047363a, 0x50bafda9, 0xc4f5241d, 0x95b949db, 0xf64598b9, 0xb2c6b79e, 0xb0fa75f3, 0x8aefed0c, 0xccfc58b1, 0xb3a98967, 0x07267e07, 0xced1143e, 0x8ebc896e, 0x78ed80f3, 0x9176ee00, 0xbddd25aa, 0x000080fc };
const u32 bern_num_data203[60] = { 0xda5ec51d, 0xdc7863d9, 0x32eb4329, 0xa75da7f9, 0x93361fd0, 0x629ff7e1, 0x05ec65b1, 0x818605a1, 0x726aabb2, 0x6993446d, 0xee57d2f4, 0xce389552, 0x7abfa665, 0xc9efab93, 0xf917bf3b, 0x0dfeff0f, 0xdddaf3d6, 0xee5528e5, 0x7def2fe3, 0x486c2911, 0x280063ce, 0x669023bd, 0x6f2e34fe, 0x7d43d554, 0x04a765c9, 0xcf753ac6, 0x67db1d7d, 0x64fba1da, 0xd6761f3d, 0x7ca4b55f, 0x5db633b7, 0x4f9d555f, 0x24cacf91, 0xf87c9888, 0x35e1b30a, 0x35d15ce5, 0xee1d84c4, 0x4537d7df, 0x701350db, 0x31181f7e, 0xa9fd9dd0, 0xab87284a, 0x6a3eef90, 0x61a829d0, 0xf6bdd272, 0x7e7c01e2, 0xa9c1a759, 0xec8adce6, 0x61ca8e77, 0x72482f9f, 0x01f24728, 0x658adf24, 0xc10fdb89, 0x3f56a58a, 0xe7897c88, 0x2bff3d81, 0x44f2dfaf, 0xe8af64dd, 0x5064d6cd, 0x0015f668 };
const u32 bern_num_data204[60] = { 0xaf6a28ff, 0x6cc50651, 0xb0fca4dc, 0x124418ff, 0x5c870538, 0xad9eb58d, 0xe3cf0a3a, 0xf42f045c, 0x1ee68f92, 0xd35790b5, 0xd201c208, 0x9b81681e, 0x7218947a, 0xef26b938, 0xd3c8fafd, 0xcbf7599c, 0xd651e395, 0xfa26eef3, 0xd6a7f90d, 0x4d88921a, 0xf5c65aa9, 0xb2a7c10c, 0xb71245ba, 0xeea1029b, 0x69fbd671, 0x6c4e0b52, 0x2eeda941, 0x9a5bb6a1, 0xa308ef68, 0xd7cea20f, 0xdcc62e3b, 0xeffe3347, 0x2b1984d4, 0x0378f7fc, 0x10f15b57, 0x73fd5cbd, 0xd003fb96, 0xc629926c, 0x567ccc1f, 0xa5b11dab, 0x02d71776, 0xef86929d, 0x198769de, 0x5f399efd, 0xdc845aec, 0x9db3a173, 0x0ce5a04d, 0xd86c5b78, 0x02d9fce2, 0xa2517d7f, 0x11270700, 0x9a2cc4be, 0x911b40e8, 0x0281a057, 0x642a8cce, 0xd961f48d, 0x6ef98c72, 0xb8926040, 0xa1ae970f, 0x0000084d };
const u32 bern_num_data205[60] = { 0xa013b0a9, 0x5409b9f1, 0xaae84158, 0x1e520acf, 0x1049bddb, 0x4adcb28b, 0xbe575da0, 0xa540aa54, 0x39d064e2, 0x3b8fccfb, 0x8fd6ab64, 0x56578f22, 0xc132b7c3, 0xcc593645, 0x49207588, 0x44111927, 0xd75e8e31, 0xac672608, 0x74811e6a, 0x9302c0be, 0x53e77272, 0xc9536322, 0x6d25db22, 0x18d4788c, 0xc0629ca1, 0x5b348963, 0x91a3df8a, 0x42b51f9e, 0x651fe87a, 0xccfa7d18, 0x2e1fa721, 0x702a5127, 0x3c8c1aae, 0xc5719133, 0x672c1b77, 0x2cc7d972, 0xa40cd8f1, 0x73bb8674, 0x4d86839a, 0xcd25dafa, 0x3845a6cb, 0xfbe80ccc, 0x59374375, 0x46c151d9, 0x299ea8bf, 0xbb4cbc66, 0x8b51941b, 0xe00d91cd, 0xc472dca4, 0x130e78d9, 0xdc27f060, 0x40372a52, 0x8ae00731, 0xdb9f5c70, 0x9448bd5e, 0xeec3d145, 0x9ea55ce3, 0xf022c9e3, 0x91cb739e, 0x0000c30a };
const u32 bern_num_data206[61] = { 0x68fbf90f, 0xdf30e525, 0x119ac6c1, 0xbe34fe1d, 0x48435130, 0x1234f12f, 0x09122c87, 0x1f4eb6f1, 0xd3e609f3, 0x346c18b4, 0xcfbd645c, 0xfd52419a, 0x039e033b, 0xf8266321, 0xba368da1, 0xb54fdecf, 0x426aba62, 0xd5a7dc31, 0x624369cc, 0x7655dab7, 0x787a3762, 0xc1b442a2, 0xb917b999, 0xc16b709a, 0xa3e88664, 0xc3fe8cd8, 0xc8553566, 0x93fa7a22, 0xeaf09284, 0xb71af1a8, 0x754b0589, 0xb993b6f9, 0x1f605cf2, 0xe7dbd6aa, 0xf46db062, 0x854ed50c, 0x3c95e908, 0xadc8c7ac, 0xa747774a, 0x04891ec5, 0x6180aeca, 0xc0211292, 0xbdb82197, 0x9729c901, 0x2241dea4, 0xbf1c8c8e, 0xd515f0a6, 0xd125a3dc, 0x94a7558a, 0x313aada1, 0x9ac31ee3, 0x513a7e0b, 0x3fc519b8, 0xd4a30cc6, 0xe6896d26, 0xeabc34be, 0xb44b14be, 0xd56e2a07, 0x2bd91425, 0xab30377b, 0x0000222d };
const u32 bern_num_data207[61] = { 0x7a626d75, 0x67c67846, 0xdfce1a3d, 0xf4893341, 0x0d3b3d8d, 0xc82c54d0, 0xa6ad35ee, 0x11e46c5c, 0xa5828dd3, 0x4e7b3c15, 0xb3c82880, 0x10a20460, 0x6fbbe43d, 0xb5ecbb6f, 0xf50de946, 0x765dbd32, 0x2ea8ec52, 0x10426a1c, 0xd81daa37, 0x1ddafd82, 0x049a7e24, 0x770bfbde, 0xe8200405, 0xa88569bb, 0x8bd49709, 0xea3d10ba, 0x85d963e1, 0xe98628cb, 0xbb40727e, 0x661664af, 0xfacd163b, 0xe6596748, 0x765e7d51, 0xfaa40868, 0xd7f4a83f, 0xdeed7cba, 0xc4b77daa, 0x506b8401, 0x5f1ec662, 0x195b6434, 0x4a1b9103, 0x208d4a3e, 0x984bf540, 0x9aa7c0e8, 0x0c9f5b2b, 0xcaa17bd6, 0x3b21dfae, 0x8e13526e, 0xf6a2673d, 0xa0aa8bb1, 0x3c1ab954, 0x0d35046a, 0x2ec753ed, 0xa0d077cc, 0x48066290, 0x2473cf54, 0x6c1aa93b, 0x550df3fd, 0xa240898f, 0xb31f999f, 0x000306ee };
const u32 bern_num_data208[61] = { 0x16986f1b, 0xe01e8e33, 0x386a0ac1, 0x50775965, 0x9713c601, 0x11f6e1bf, 0xe81450da, 0x4df22a4a, 0xf4e8a9f0, 0xc386b322, 0x415f0847, 0x18e63aa6, 0xabff0c70, 0x70f3189b, 0x1cacc5ce, 0xba23ef59, 0xf195899a, 0x32771061, 0x34ef6a99, 0xd284e68c, 0xe5ad9ae9, 0x5214e8c5, 0x41505abb, 0xe5e9bf47, 0x1d9e4dc6, 0xc5f1f877, 0x8bbdb73d, 0xd85beb3c, 0xe58f4068, 0x52b67bcd, 0x8cc4707b, 0xfcc2addf, 0xfb710bd3, 0x46066fcb, 0xbe92c3d3, 0x98ed53ce, 0x91005b1e, 0x1f203633, 0xcdcbea87, 0xc2ee17a3, 0x5961a044, 0x1cda6417, 0x66484efa, 0x3c749f0f, 0x5f705063, 0x975f3ab9, 0x01bc33be, 0xe9d839ca, 0xb7ec15ff, 0x0fa93986, 0x02636374, 0x657ffb44, 0xaae3374b, 0xc483a1e7, 0xf92d5fff, 0x2e2da3e2, 0x735588d7, 0x43be3497, 0x3c7c5433, 0xc922a0f8, 0x6fae9df9 };
const u32 bern_num_data209[63] = { 0x69541875, 0x912169e6, 0xb110942f, 0x3a86429f, 0x6490f152, 0x292cf2f2, 0x44fb6480, 0x2008c112, 0x46069077, 0x48a2fe5e, 0x5485c893, 0xc2ef059f, 0xa965a0cf, 0xe1d60f77, 0xf2968077, 0x466db383, 0x821f041b, 0x0048dc51, 0xbff99d4c, 0x0afedc32, 0x97a4b013, 0x149f4295, 0xcd5bd226, 0x09f1feb4, 0x687ed33b, 0xf41cda72, 0x2e0e5882, 0xd56b1504, 0x6b4def79, 0xdb9ce93f, 0x350a03f0, 0x1908ebf0, 0xc7ee37bf, 0x94f991c3, 0xb0f00913, 0x2824fb18, 0xa2d2f868, 0x66530e79, 0xa1a903e9, 0x82839815, 0x08fdc5f3, 0x82a54fdf, 0x08fb9023, 0xfe2e6f3f, 0x6776cafc, 0xa71a20ab, 0xa61ad157, 0x4b4012ca, 0x11de5e54, 0x3f43501d, 0x0d8c8454, 0x8c956a21, 0xd6271469, 0xec545cc7, 0x81c73646, 0xf018479f, 0xb7fdfd37, 0x013575af, 0xb78c9eb3, 0x8372597a, 0xecbff7f0, 0x1e3b410b, 0x00355d40 };
const u32 bern_num_data210[62] = { 0x5d288097, 0xcfa94d0a, 0x09c2eff9, 0x441eee71, 0xa1c7e781, 0xe65a1f16, 0xfe2d3571, 0xb8bbe5d6, 0x4dbab3a5, 0x2aff38fe, 0xa250ea25, 0xb4131dad, 0x900a2fb6, 0xddc63da8, 0x1cd80c9c, 0x9425d617, 0x5d18b498, 0x80a3f565, 0xadc34b61, 0xc751981a, 0xb46e48e0, 0xe078792e, 0x6fea4a25, 0xa19f440a, 0x4c11d236, 0x11ecb6cb, 0xb08045a5, 0xb7d81ce0, 0xdc0dd16f, 0x8af93996, 0x12927f95, 0xa4579e60, 0x0d507945, 0x5f1c42d8, 0x4fdb0318, 0xa1734872, 0x1446b9d4, 0xa5b727d0, 0xb4183502, 0x86f75c5a, 0xfa56e5c4, 0xe92a223a, 0xcbb4fc83, 0x9ae64b89, 0x99ec244b, 0xe21c1e62, 0x157989f9, 0x6d36817c, 0xd057d73f, 0x7c350f58, 0x87dec35b, 0xfc3b8725, 0xf5d98e54, 0x602e6628, 0xa9a00f31, 0x9eeb6219, 0x7796ced4, 0x5d067ee1, 0xaf86b75e, 0x7ee30a80, 0x1d0d8f9e, 0x0000038c };
const u32 bern_num_data211[62] = { 0x466bdcab, 0x50ff8964, 0x33c0f8bb, 0x54191116, 0x39e2469d, 0xa1388c53, 0xe982c47e, 0xc1301e0f, 0x67b043ce, 0x0ce07199, 0xda19c5eb, 0x934609a1, 0xa7b558c7, 0x0874f172, 0x1ca43d86, 0xc07f9dc6, 0x6f6cf89c, 0x33573db3, 0x45a469a7, 0xf8500022, 0x7353f274, 0xb294af53, 0x6c81af39, 0x0037356f, 0x27da4962, 0x227bac2d, 0x3e3b28c5, 0x599dd7b7, 0xb623f9d3, 0xfca53f30, 0x8b71b35b, 0x53d7bff8, 0xfacb8065, 0x41d04420, 0xae17cd96, 0xe45df0ed, 0x57ce47f9, 0xe1fc4925, 0xf8baa8ce, 0xb2cf5a1a, 0x48f5927a, 0x7d579a82, 0x58c149be, 0x4babc082, 0xf3c65c46, 0x246e15d3, 0xf0b3b24b, 0x460b426f, 0x9ac01cf0, 0xec1b8749, 0xb2ca3718, 0xd39d2d09, 0xd3f63506, 0x34afa5d6, 0xa403cdff, 0x08c6053c, 0x4761ff3e, 0xc719d85a, 0xed3ade20, 0x5f6f501c, 0x277ac132, 0x838f195a };
const u32 bern_num_data212[63] = { 0xe6ec8589, 0x629016ce, 0xb5b6c8ef, 0x488b685c, 0x4c9b3c73, 0x29c22c94, 0xccdc9d79, 0x876e97d9, 0x9eab3a4a, 0x54207356, 0xb2472982, 0xcb37b8e3, 0x9fe8830f, 0x6edfae51, 0x580ce4c5, 0xbb04db60, 0x32a3b4b4, 0x63d0b3de, 0x0e229a02, 0xe64690a5, 0x1e917409, 0x7db99185, 0x2a80050c, 0x7efe5970, 0xcda211cd, 0xf0da5eac, 0x65bbc7a4, 0xa74d246e, 0x6cc92953, 0x4f15dc0f, 0xfe9e0cc0, 0x936b0408, 0x27d329e9, 0x9bc67ee3, 0x09fa7a7f, 0xfadbbf12, 0x351cd94f, 0xf07c4c10, 0xbf392f1c, 0xaed3773a, 0xf15b81fd, 0x180904f7, 0x409dbdb0, 0x2a56ff43, 0x4a41540f, 0x739424fa, 0x71abb8a6, 0xa8a4ec6f, 0x6339cd47, 0xcaa1716b, 0x341079f8, 0x2a33e1f6, 0x21963c6a, 0x328ab608, 0x6c8e10ba, 0x02accd31, 0x3f0b53cf, 0xa7dfbe47, 0x40a11dc5, 0x6d62a1ae, 0xb1ec200f, 0xd61de938, 0x0000001e };
const u32 bern_num_data213[63] = { 0x5f11ffc9, 0x1f1077b4, 0x84102d61, 0xfbed16a8, 0x45891b73, 0xd70873f0, 0x1c95ef7c, 0xbb35c9df, 0x2adb793e, 0x144cac18, 0x626176cf, 0x0cfeadd3, 0x1e257e55, 0xbaa7926c, 0x6dbbf9c0, 0x20378307, 0x19b1bfe7, 0x28952375, 0x0a035361, 0xbc65c5a5, 0x3a5dabde, 0x9cb06478, 0xc22ad060, 0x85c5b2f5, 0xe62477ff, 0x960ab815, 0xb1d9b39a, 0x4507e89e, 0x2913b388, 0xb5e97ada, 0xfbfeca14, 0xbbfde432, 0x3eac94e1, 0xd50a9107, 0x4f50e7ce, 0x4813e6f1, 0x336cd8fd, 0x42f0bae4, 0xa5805134, 0xb4d51a46, 0x116572b6, 0xc0e09bb8, 0x894f7d58, 0x8abca8a8, 0xefcfdec0, 0x3e9406ba, 0x022a17b5, 0x7fc74fa0, 0x1a1b963b, 0x8868e197, 0x8bf2fd33, 0x31c73dd2, 0x25c27878, 0x847faae8, 0x7b1811ad, 0x186e2321, 0x7ff7d6d7, 0x68a96388, 0x752accff, 0x04d23cea, 0xa38a4523, 0x23961ff3, 0x00018e4c };
const u32 bern_num_data214[64] = { 0x2bd45a63, 0xda495950, 0x9857f721, 0x15ecc6ce, 0xdec0fc98, 0x25e02e2f, 0xce97e746, 0x696cee77, 0xab7a2b34, 0x65c6963e, 0x616fbbe9, 0xafe0c7b4, 0x3f47275e, 0xb8f8d782, 0xefd03830, 0xd6562446, 0x5729498b, 0x1011ced3, 0x38479862, 0xba47875d, 0x57576456, 0x5729feae, 0x4bb615e9, 0x2a691e4f, 0xf51b3a21, 0x626a23a8, 0xb394e778, 0x3a47f66a, 0x1fc88f9a, 0x7f5ba072, 0x1ea559a1, 0x6260938b, 0x95e1093a, 0x7ef6d0b5, 0x8bfb882d, 0x01a7de09, 0x494d9874, 0x3b38325e, 0xff3d4d4d, 0x8b24c8af, 0x5ee8441d, 0x8250b429, 0x0e55d664, 0xa875d697, 0x8670fc16, 0xcd733160, 0x29dd8b54, 0xe685c7a3, 0xa21d4cb7, 0x97127aef, 0x4940c6b0, 0x61b2453d, 0x04076188, 0x7ce0af59, 0x22ec856b, 0xab54074d, 0x2383bd5c, 0xef980661, 0xcc3d54ff, 0xfdee98a3, 0x8854cf94, 0x20aa4ccf, 0x2f582060, 0x00000069 };
const u32 bern_num_data215[65] = { 0x89055259, 0xcd23f8da, 0xb4fdfa9e, 0x89ff2971, 0xd2746126, 0x50bc01cf, 0x3cd79635, 0x61688873, 0x1b2d683a, 0xca00b314, 0x3847fcce, 0x541a8488, 0x4abcc1f2, 0xa84e22ac, 0x58d59e63, 0xcb8a3c05, 0x62634c7c, 0xb5ca252e, 0x5dd7b3d4, 0x0042cf5f, 0x9bf6f8f1, 0x45113eb9, 0x663ed67a, 0x5aa5c4b4, 0xf2b551f8, 0x3b52b8f6, 0xffa1a783, 0x1c5ce595, 0x3c05f2ff, 0xe3e35a2f, 0xd3e34b78, 0xdc20283e, 0xc15170c0, 0x6cecc1a6, 0x47b77534, 0x50ce6a3e, 0xbef2806c, 0x5745c29e, 0x307ee2ab, 0xcbfb71fb, 0xef7356e8, 0xb10938e7, 0x9af25f5c, 0x42c88ee1, 0x8d9068ea, 0xf1ca0a16, 0xf2f09c5e, 0x5dd5afc4, 0xd7b550c8, 0x96b151c8, 0x447522d3, 0xa4f0bb57, 0x5452c928, 0x6a4391a5, 0x8d0db075, 0xc97215eb, 0xa6855b72, 0xda9e237a, 0xf28cb6f1, 0xa04bee91, 0x2b0d5528, 0x9fb8bb74, 0x91a66a6b, 0xed51486c, 0x0006f6f1 };
const u32 bern_num_data216[64] = { 0xe551e81f, 0x4e561c46, 0x6b4ee5fd, 0x9042c6f9, 0x868cfaba, 0xa3822090, 0x7b8d2977, 0xf5fd8465, 0x1b8ada24, 0xf94e57bd, 0x57c45ffb, 0x5a7f3aca, 0xa4bb02dd, 0x91d6287f, 0xf2fe9fc4, 0xc8620423, 0xdc4c2cb9, 0x8724d81a, 0x4437e990, 0x9a4646bd, 0xd8a704d8, 0x17617cd6, 0xb7509476, 0xe9b2cc2b, 0xec925e9e, 0xbedbd12d, 0xb14d8287, 0xad34efe7, 0x9e7cd57d, 0xcec718a8, 0xcc2a6b0d, 0xd3b4923b, 0x56a53aaf, 0xa0b89ff4, 0xbe25fcd0, 0xced32bd9, 0x90f2e150, 0x8475c46b, 0x177d78d5, 0xbcede4b2, 0xc2562ae0, 0x50a90b37, 0x754d9d49, 0xfd6f8582, 0x251018f5, 0x9baa9b10, 0xcc9c001f, 0x139b1fb6, 0x08471987, 0x3bf916dd, 0x573364ec, 0x989d754a, 0x7fbe8733, 0xb4fbed02, 0x409a465f, 0x0c48aff2, 0x280fcd8e, 0xeca43c47, 0x703865e7, 0x6d800733, 0xbbc73e43, 0x3c0fc11d, 0x34e6e500, 0x000799a4 };
const u32 bern_num_data217[65] = { 0x5dff6459, 0x5e13a80a, 0x905b824c, 0x568510f9, 0xa0d70f26, 0xa7479c25, 0xc1f6f35e, 0x0c4f5789, 0x3d802698, 0x663eb173, 0x5b0f1a09, 0xc5b0534a, 0xb60f7de7, 0xacd6aea3, 0x1a10c1ff, 0xf7419cb3, 0x4eac74f4, 0x5888cb94, 0x5c914413, 0x3501efc9, 0x7e1f5c2e, 0xaef40bb9, 0x5e3026ad, 0x717bcb94, 0x63d58e61, 0xebbee164, 0xc1db6a43, 0xc1e783e6, 0x149a35ff, 0x6937cd1d, 0x63dde679, 0x9144dd3c, 0xfc3f4e27, 0x916e67d3, 0x3eaeddc3, 0x13b25217, 0x8ebdcc92, 0x94a64f76, 0x3883ffda, 0x88e82952, 0xfa57f192, 0xdd194e87, 0x605699fc, 0x5ac0fa8f, 0xfb63b4af, 0xd75688cd, 0x9df09f3d, 0x95de118a, 0xa6cd055a, 0x3bd42b9b, 0x0cd530ab, 0x080f8bd6, 0x5619128a, 0xafca6860, 0xddef343a, 0xa53fe1ee, 0xc954c354, 0x18ad0e73, 0xa983d777, 0xc05f1906, 0x6afb83d3, 0xa53eea7b, 0x109588fa, 0xc9215b4f, 0x00000002 };
const u32 bern_num_data218[65] = { 0xf4db30f7, 0xdc6666df, 0x586ea3d3, 0x699d1726, 0x23cd49d3, 0xceeae918, 0xbdf0e260, 0xd676b5eb, 0x954fd48e, 0x7fac4ba0, 0x5572a6b4, 0xfd5b1a5f, 0x4523d0e4, 0x4886feb7, 0x751270da, 0xe6cd5ffc, 0xd936cd3b, 0x4bbc76ca, 0xa17c906b, 0x4af87f58, 0xb27a8d20, 0x25016e6e, 0x18688a67, 0xa25adab8, 0xfc0c9328, 0x96a1db20, 0xa4363281, 0xd5367f8b, 0x016635f6, 0xf79050a6, 0xee2cc057, 0x5680ca3d, 0xbc5e6a9f, 0x3e12841a, 0xf2582b52, 0xbfb75607, 0x63c7ccfe, 0xcff02a6d, 0x27538ca6, 0xf54b6e71, 0xcbe90c5c, 0xcf727452, 0x26060cb8, 0x0a5afa9a, 0x99a87552, 0x5a702648, 0x3e6c1ec2, 0xa3ad7310, 0xf326e332, 0x49401694, 0x1f4dbd8c, 0x1950290e, 0x1bd2534f, 0xaa0bdba4, 0xcc9b0f2c, 0x2cf36639, 0x5cf9cdc1, 0x90aa950d, 0x8c16168a, 0x69909f11, 0x2fba198e, 0xef30303d, 0xc932ba5c, 0x2ae90189, 0x007ea8cd };
const u32 bern_num_data219[66] = { 0x8d9f249d, 0x7c77c7f6, 0xbf9e5807, 0xab6752cc, 0x649ad56e, 0xb921427b, 0x8a5620a5, 0xb5e99568, 0x860e8301, 0xc76b59b5, 0xc716a4b0, 0x51275379, 0x524a8a7a, 0x477f0af5, 0x64cdaa00, 0x96c05bc0, 0x86648b88, 0x9b118458, 0xe394a6d4, 0x85573b27, 0xe5bcb0c9, 0xeee57719, 0xfaeff51b, 0xb1686305, 0x2e6d75c8, 0x61e56898, 0x80250b88, 0xde2a0e17, 0x61da134c, 0x1e985e02, 0xbf022ac6, 0x4dcb28cd, 0x988a143a, 0xa8b14797, 0x306e8d2d, 0x78e11298, 0x5211a1ba, 0xd7c1352c, 0x5c334201, 0x54e00a0c, 0x1c7637a8, 0xadf661c4, 0x8c5cffcb, 0xcb59f946, 0xe70490e0, 0x402e1dfa, 0xaf06e543, 0x95236aad, 0x9801b0d0, 0xbf41f51d, 0x3bfe13c5, 0x7e4e7db0, 0xdedaadcc, 0x01a070e6, 0xfdc39722, 0x846cb38d, 0x3d20dd9b, 0x610f7b98, 0x76c3e2f0, 0x4c3294eb, 0xa491a501, 0x0d4c7e69, 0xc8a6e834, 0x5e0d413e, 0x32b0efef, 0x0000377c };
const u32 bern_num_data220[66] = { 0xa8c908b5, 0xde48653e, 0x504cec89, 0xb58221bf, 0x6ab602a3, 0x841dc316, 0xc0fa5151, 0xafd8b056, 0x97ecfb4d, 0xef6370ab, 0xcbcd3671, 0x211ff520, 0x08b84335, 0x43bb7a1e, 0x231f9410, 0xa9dac781, 0x1baaf916, 0xeb067256, 0x36ccbb91, 0xa45b566e, 0x93a6e360, 0x3a90b3fb, 0x594a6d66, 0x5926a314, 0xb6f9b826, 0x002a4add, 0x852c9ee7, 0x02121251, 0x0dea51c1, 0xb83ae9d2, 0x4186e4b4, 0xfab1dbc9, 0x90fa355c, 0x180f0f8b, 0x4bfbd08f, 0x0f940ba3, 0x95c8c093, 0xf09cd4f3, 0x9df67283, 0xd627859c, 0xc52a5315, 0x7cb7a3ce, 0x2d4840c0, 0x4028fd1c, 0x13fefbbd, 0xd0b1a72b, 0x3bf9d554, 0x2d9ae96d, 0xa7345648, 0x92e6764e, 0x03d3b0b5, 0x6daf259f, 0x00a0b96f, 0x27e2be4c, 0x7571b1ab, 0xf115320d, 0x3f907f9f, 0x75be9215, 0xe0816de8, 0xde94a4bd, 0x4d39b8fc, 0x6c3b8b44, 0xb7dcc159, 0x43a0c2ce, 0xa712fe90, 0x00001a4a };
const u32 bern_num_data221[67] = { 0xa2cf3651, 0x6af87638, 0xd8fcbbe9, 0xdad03d70, 0x2896a6e8, 0xbfe56763, 0xf04191e7, 0x4abe588c, 0x55a26a7d, 0x0800541a, 0xb1ff059d, 0xf44f7333, 0x50fe812c, 0xdc523015, 0x05d96e4b, 0xfc0405f2, 0xc9cfdbd4, 0xd3d11154, 0x38ad398d, 0x67ecdefb, 0xdc208703, 0xab0f6783, 0x5a5f41de, 0x5d8235b5, 0x6fe03e7e, 0xf4aa8822, 0x276b9111, 0x7e6c3628, 0x772c17ce, 0x0381d23e, 0x94756b04, 0xa4f4c8d1, 0xadec1649, 0x3568c301, 0x9c73c2f6, 0x2509f57b, 0x6605649e, 0x985f1147, 0x5fc1a10b, 0x74ec55cd, 0x884f3f38, 0x3960d7e7, 0x22fed5e5, 0x45f87757, 0x38d3f644, 0x59a8dc4e, 0x2ca23cd4, 0xce155ae2, 0x41a7be1c, 0xfb9521d5, 0x89545b70, 0xa9b2033d, 0x91d6e317, 0x0951dbed, 0xa102169b, 0xe1383242, 0xb5b33b3a, 0x2152f86d, 0x9218cc49, 0x55628e32, 0xe7a555c6, 0x4296b871, 0x36ebc045, 0xf2b0e3dc, 0xb3fe93e6, 0x745ada73, 0x0000010a };
const u32 bern_num_data222[66] = { 0xa584c227, 0xdbb8b062, 0x9b2913cd, 0x491daa02, 0x85d32cfa, 0x6d78da69, 0xfcbe693a, 0x1857bb03, 0x54ccb452, 0xe9c454ef, 0x6f9846a6, 0x0f6881cc, 0xf5d93893, 0x49f9f95c, 0x4a63f0ec, 0xf8bf984c, 0x82383c4f, 0x0a483c5d, 0x6f68a08f, 0x46740cb6, 0xaf5e0473, 0xc1361f4b, 0x34e3cf9b, 0x8553897e, 0xb615f8db, 0x2fdc36df, 0xcc6a2e18, 0x07a9f70f, 0x22c3db25, 0xc6536536, 0x1f05f764, 0x4d44596b, 0x84fba444, 0xca147ada, 0x7b61b079, 0xaa8821ac, 0x4f9404c1, 0xd2113de4, 0x04fbe2e4, 0xc5df2f11, 0xa9faf518, 0x5b878c0d, 0x34d4196f, 0x1972cb05, 0x4d50f85f, 0x352d3f35, 0xd06ab98f, 0x9336dcb9, 0x40cbf1c9, 0xa20ef764, 0xb330b25d, 0x657e79f3, 0x14b1cfe7, 0xe2fab91b, 0x83f38e05, 0xf66574d6, 0xf4871f02, 0xc288da01, 0x98294d46, 0xca6c7051, 0x1624153e, 0x98357212, 0xc64d60fa, 0x4a9f5595, 0x0f3593a2, 0x16aec881 };
const u32 bern_num_data223[68] = { 0xbcdc180d, 0xde0b5c18, 0x4cb4b21c, 0x70124703, 0xf993cc42, 0x85574cd7, 0xf13e8eb5, 0x2a09ff18, 0x34398d2c, 0x637d5d35, 0x6c444071, 0x9ebf3c5d, 0x8ab9b72a, 0xa694b01d, 0xdb48c0c4, 0x3ef8f9d7, 0x5e18eab8, 0x19d75099, 0x1fb000da, 0x1c602cb0, 0x603530b7, 0x448a69a4, 0x09f76c41, 0x63579219, 0xce0705c0, 0x37677b1d, 0xdaffd622, 0xa049e0d9, 0x0fb6c347, 0x49244ecc, 0x0ec32787, 0x3948af64, 0xe7eafd2c, 0xc2f998d1, 0x4b26b575, 0x3cc4110b, 0x1f25dc50, 0xaf4ddfd9, 0xe5c4054c, 0x7ef5d1c6, 0x49ff073e, 0x3f9eba16, 0x541054bd, 0xf10e77b1, 0x4bcf2817, 0x828c1cca, 0x72af0662, 0x02f87a60, 0xe25258e9, 0xfb2d2d7d, 0x0548ba1c, 0xae6467ed, 0x455264c3, 0x967d65e9, 0x8469f030, 0x73a3c619, 0x2f608880, 0x2d0365e5, 0x3d006f6e, 0xb7b1e6a2, 0x4b73e7d6, 0x84884c78, 0x3fa0c3ba, 0x6c97d479, 0xcfdd0f87, 0xae2761d8, 0x16738100, 0x0000000d };
const u32 bern_num_data224[68] = { 0xedd46651, 0x22e264ef, 0x1be070a5, 0x10de8cee, 0xca1dc1f4, 0xcf611754, 0xf9e134cb, 0x69d4305f, 0xfe292789, 0xe8b43d8e, 0x0e9f3d08, 0x7b291814, 0x98e0571b, 0xa42976d2, 0xb848ebf8, 0x58ef17e1, 0x75e80ed5, 0xd41259f8, 0xa6f620d5, 0xf8bf5e6e, 0xc5b11986, 0x3379c86c, 0xa2f4fd0c, 0x9d58db31, 0xe121ae4f, 0x4945dd2f, 0x1fbe0422, 0x38261d5b, 0xf746e7ee, 0x8a748beb, 0xbff08af8, 0x752caa63, 0x0a334520, 0xf6b10b00, 0xaeff7597, 0x350892f2, 0xeb34fd05, 0xf541af78, 0xd0de2158, 0x9a6e6927, 0x9da2262c, 0x3a2b4e7e, 0x60c9fede, 0xaa01fd66, 0x7c1ba27c, 0x515f556d, 0xd6eac06a, 0x76ae2025, 0x123f4050, 0x1ed94e0c, 0x472acc2e, 0x91f4f19e, 0x08771080, 0x9dee559e, 0x3df849f8, 0x34203791, 0x65eef42e, 0x53ec2d1a, 0x82c086c1, 0x3ad0f55b, 0x1c167130, 0x2ac89ffe, 0x1443ae29, 0x2d212e2e, 0x4975ef12, 0xb12e2e41, 0xc89b7ea6, 0x00000e53 };
const u32 bern_num_data225[68] = { 0x79b6004b, 0xbda53420, 0xdbadf9b8, 0x2d0791de, 0x4168ce25, 0xfb7e2223, 0x76d164b2, 0x39606232, 0x74263f41, 0x10ca9dab, 0x99a191cf, 0x6997068a, 0x5f070257, 0xa56c6462, 0x8e8b9f3f, 0xa2ecaab6, 0xd53034bb, 0x05e29e3b, 0x5036ebea, 0x327c9e07, 0x543e5b77, 0x8c337a7f, 0x16473384, 0xa51fbb64, 0xcb1b5c15, 0xf1f26795, 0x8932a0bf, 0x73917219, 0x5ee7727a, 0x7ba84201, 0x3f000c86, 0x79350f55, 0x347ab97a, 0x8d4d3750, 0xc5ed1e73, 0x20f57b4d, 0xe2dfdb1e, 0x1ded87f4, 0xfa7f4560, 0x4c62113d, 0x82f554a3, 0xacdc58e5, 0xb925ae62, 0xc02c69ba, 0x0acb7a09, 0x082f5238, 0x0a50b604, 0xcaf0a51e, 0xb96bb9f1, 0xa83da997, 0x196309c3, 0xa3980a0e, 0xcff50a09, 0xad494569, 0xe0450347, 0xf766709e, 0x49467bf5, 0x90208cd4, 0x5e46dd63, 0x6f9cf340, 0xf6454c98, 0x06a9e04c, 0xf265cf0b, 0x5e4263ea, 0x3e9736bd, 0x2aca3ec7, 0xdbf77ee3, 0x00000c42 };
const u32 bern_num_data226[68] = { 0x4727a157, 0x72ff58b9, 0xc8a8251a, 0x8282e657, 0x84989010, 0x7e0a99ec, 0x5b0a77c5, 0x75a6ab5f, 0x814428a5, 0x8ce4eee4, 0x48f674ad, 0xd2b97678, 0xfe42f989, 0xc77cd576, 0xeb3714ba, 0xc8fd8130, 0xd194024b, 0x7b012e39, 0x4e83872e, 0xb17c5623, 0x2ca7bc8c, 0x1a1a9606, 0xee4b5d5a, 0xc5eecacc, 0xba6b54ab, 0xeefe0e6b, 0x8ba43718, 0xd0fac08d, 0x3218406e, 0x634507cd, 0x8a982b11, 0x67efec42, 0x058cbdb3, 0xe62f57ca, 0x20054fc2, 0x960e151a, 0x12d0e57a, 0xa80883c2, 0x38ca7b7c, 0xfd45b10f, 0xbbf8de93, 0x9a167bcf, 0x4b0fd41c, 0x8aca030b, 0x31f09eef, 0x430ecaf9, 0xe08023e9, 0x46e0688a, 0xcd564ee6, 0xc5c21cd6, 0x3876fe0c, 0x14b70c62, 0x98939c9a, 0x8669f5eb, 0x9d74a68f, 0xada3523f, 0x5d95c94e, 0x4b4d5aff, 0x2cdfe910, 0xfc007e79, 0xe49b0a1b, 0x6b1c989c, 0xd07f96b3, 0x776faa96, 0x8373f635, 0x2ecc2a50, 0xe4544491, 0x00003846 };
const u32 bern_num_data227[69] = { 0x06a801df, 0x1f36b907, 0x4ed8f75a, 0x4f06b37c, 0x664a9796, 0x6bdae30d, 0x6161947d, 0xf06d2230, 0xf8984aba, 0x5dc4a2da, 0x146859e1, 0x780b6b71, 0xe567febd, 0xec77532c, 0x7469e854, 0xf61fa467, 0x648c8e65, 0x168dacb7, 0x545a477c, 0x8493841d, 0xfbc324e4, 0x27b15bd2, 0xe7937413, 0x036cbb1b, 0xd0e4e5c0, 0x920b12c5, 0xcbf321fc, 0x96046d45, 0x7bc8aba6, 0x238fb587, 0xd558d7b9, 0x9c12a4c8, 0xe3ce11e6, 0xe4e662e0, 0xad9bc84e, 0x3e741961, 0xbfcc05d8, 0xf3fdda48, 0x278eb6c7, 0xf270057e, 0xc9767443, 0x0f96272d, 0x88590b9f, 0xec03027e, 0x4acced5f, 0xa288d190, 0x4d82dd3a, 0x5f8279e0, 0x101d472c, 0x5ffc33e1, 0xdf1a0121, 0x95393f75, 0x01f714cf, 0xa4c3a651, 0x7bcc4f2d, 0x2447cfb2, 0x41427851, 0x8365691a, 0xe7db4e85, 0x078c1918, 0x3392ee42, 0x5a94aba2, 0x9e838527, 0xd862f79d, 0x38352ce1, 0xaa39341f, 0x0e8ad54f, 0xb159cbee, 0x000ccf10 };
const u32 bern_num_data228[69] = { 0x72651eaf, 0x0c197d75, 0x567669e7, 0xa20a6e09, 0x20af657c, 0x900aebb4, 0x2d98435d, 0x60326cd8, 0x73bc1d7a, 0xe8dcc084, 0xb44db158, 0x5385e805, 0xd68fff6f, 0x9eaa75ea, 0x8ad2212a, 0xd925b374, 0xf4f8dda3, 0xc4b9e154, 0x71a3a8e0, 0xa5d71695, 0x7dd25c57, 0xd4717aeb, 0x111ba125, 0x24b19f38, 0xae63d97d, 0x3d93b41a, 0x541d5cab, 0x9789ca59, 0xd13dcc15, 0x4091cb25, 0x29f30710, 0x09d75294, 0x4a280456, 0xa908cfe0, 0x0c876e3f, 0xe15c94b1, 0x4cf9701a, 0x089c22ee, 0xd8c92a78, 0x58a16f2a, 0x1eb84a9b, 0x040e71dc, 0xa694701e, 0x9307eca8, 0xa1e85345, 0x1cbe443c, 0xfe849bde, 0xbb292b61, 0x14723476, 0x6d316bd9, 0x040d6e2a, 0x0b61cb2b, 0xdeb8afb4, 0x01023838, 0xe516ca92, 0x54c40bc7, 0x8d79e0de, 0x39ea1f07, 0xe348ea38, 0x063f5ddf, 0x9bbe737a, 0x39bc5d78, 0xbe2f4681, 0x4d4b35eb, 0xa4f726c6, 0x79491f83, 0x4c662a63, 0x770868f6, 0x0000005d };
const u32 bern_num_data229[70] = { 0x59714109, 0x19924c62, 0x40793f8c, 0xc9dd516a, 0xfc1c8dc8, 0x05ddbf2a, 0xf645f7b2, 0xcbc2ad8b, 0xe572888d, 0xf49d08c4, 0xdc41286f, 0xc39c2051, 0x5eb326af, 0x34074ca0, 0xa0803929, 0xa508d379, 0x77921543, 0xf9fa1f37, 0x7c06d223, 0xf598860e, 0xbbf896d6, 0x5d31fc87, 0x62769f02, 0x7ce2fb4e, 0xbd565297, 0x9799f834, 0x9e411f35, 0x161cffd8, 0x2d325a88, 0x587948d3, 0xd5425c95, 0x7983ecf3, 0x56020bde, 0x508fce52, 0x63ab8a8d, 0xace01cbe, 0x1035ec9c, 0x714d29a1, 0x5318d429, 0x44f671b4, 0x90620306, 0xe2a06ff0, 0xe9e1f27e, 0x02949635, 0x522b3fb3, 0x9c72cbac, 0x98158743, 0x0d50aa9f, 0xc0e6ac4d, 0x93cfdb46, 0xe7eb49a1, 0xaee0470d, 0x3d16b425, 0x9056d447, 0xd0c96851, 0xbe0a0d52, 0xe16e09f1, 0x447e7f5d, 0xa90dc6a2, 0x58c7a873, 0xadd33da5, 0x0f4df6e8, 0xb63193ed, 0xd3af8d78, 0xaab1776c, 0x45d06f4c, 0x560ccde1, 0x208b9da9, 0xb1f54f3a, 0x0000008a };
const u32 bern_num_data230[70] = { 0x01a14909, 0x6ddab7d0, 0xf3f6d5e1, 0x5e97f289, 0xcda2a77f, 0x2d46e000, 0xeb905e91, 0xec4006e9, 0x8ed5407e, 0xf520d550, 0xa20d6e0b, 0x3c5e133c, 0x17f50c27, 0x20f36561, 0x2ce0f4e2, 0x74646f2b, 0xc2d932db, 0x7883ce77, 0x5f376627, 0x37183b26, 0x3f3c1d54, 0xeefe261b, 0xb4dd4c52, 0x0f77e9cb, 0xca2cedfc, 0x07234fe7, 0xa2f3b353, 0x425d65cf, 0x5094d770, 0xb8c816ee, 0xde057238, 0x0990c524, 0x27bbf0b7, 0x0fddf542, 0xf10625f1, 0xdfd51ffd, 0x1efdb342, 0xeded336a, 0xdd1c3dfb, 0x3551ea5b, 0x81124633, 0xf730a10c, 0x42616a06, 0xc27c3033, 0xbcde1389, 0x05de6a13, 0xcb7365cc, 0xf2942817, 0x78951c75, 0x43556713, 0x925d912f, 0xa7776b66, 0x2f84e143, 0xedeb81f6, 0xb717cb87, 0x23b5b915, 0x89fb03e5, 0x07b2805c, 0x6afd0a72, 0xc85d3524, 0xd2b7fb22, 0x65df1e49, 0x57d4a67c, 0x30318a42, 0x93b004bc, 0xd2d4d074, 0xf320d72a, 0x8b51809a, 0x14c3f458, 0x08099026 };
const u32 bern_num_data231[70] = { 0x9012c493, 0xa7f5c65f, 0xb2417136, 0xfefcf317, 0x577c91e5, 0xeb34708a, 0x372b7026, 0x9133e676, 0x8d3ed176, 0x08328a7d, 0x4cddd33a, 0xc61b9e76, 0xd781fc37, 0x3c20e39e, 0xf1db002e, 0x8531e976, 0x174559b1, 0x701e7cf2, 0xe4a0e636, 0xd5fe2676, 0xcc63e7d6, 0x39d9dda9, 0x5901ac9b, 0x86fdf353, 0x8fc49d1a, 0x78fad9f0, 0x2cd9d7d6, 0x7c73080c, 0xd56de6a7, 0xe9de524a, 0x203408c2, 0xb7fd2579, 0xf0af9359, 0xccc74e99, 0x41f46fb1, 0x29119f1d, 0x460af294, 0x91a7da6b, 0x2561aee8, 0x889835f0, 0x6c9ef6bf, 0x218d200f, 0x491fa19c, 0x4ac17011, 0xcf954f6d, 0x598ad674, 0xbf1897e2, 0xf35c7f95, 0x6eb15e6d, 0xdef31dcd, 0xa5cf3aa2, 0x15a1f241, 0x6c46044c, 0x749b0d0a, 0x8de77159, 0x36ea46b4, 0x76c01de0, 0x021cb95b, 0x0d886e93, 0x06e939b0, 0x0642d26c, 0xf36b7251, 0x06d48a5d, 0x4bfb59b2, 0x9293cfb6, 0x415ef524, 0xcac564e3, 0x50971765, 0x5011fa08, 0xedf94b86 };
const u32 bern_num_data232[71] = { 0x773b42cd, 0x22497d4c, 0x204fb25a, 0x595dcf19, 0xed7a84f5, 0xa7054b69, 0x65c52c91, 0x53a60c40, 0xaab00b4a, 0x694434fa, 0xc37459eb, 0xf39e4490, 0xb71efd34, 0x4ce13699, 0x505285c5, 0x1d67188a, 0x04c9d0ff, 0xc234899f, 0xeeecebde, 0x76e884d7, 0xf3f6c013, 0x8bdb12c5, 0x73e277bd, 0x934f5eff, 0xd80a73c1, 0x67731a1c, 0x26f2f7ea, 0x1eda89a6, 0xb3c40adc, 0xe30b0711, 0x96b0a770, 0xcb825ad7, 0x27b567c5, 0x3160a8e1, 0xa6a556f2, 0x1137bd9d, 0xb2ef5053, 0xd1171bef, 0xbadce400, 0x2740f4c2, 0x9f8bb43b, 0xee1a99d7, 0x917cb7df, 0xbb1b5e54, 0x7ed980bc, 0xc9b090c8, 0x8dfd1cb9, 0x446400ce, 0xe534dbbc, 0x4190568d, 0xffbec8ce, 0x25fd3721, 0x114e70b6, 0x2dec5e66, 0x40ad114f, 0xcec885c4, 0x86e11fa2, 0x846fa5f1, 0x0c6e5927, 0xcb03b143, 0xfb9c0f29, 0xce06306c, 0x61dee0f3, 0xec12495e, 0xc9b6dd0c, 0x1751e2aa, 0x692cdb4b, 0xadf48dfb, 0x3737a9fc, 0x0a088ef5, 0x00000002 };
const u32 bern_num_data233[72] = { 0x23aaaab3, 0x3cab139e, 0x2e4e0e8b, 0x641ae9e1, 0x42b95107, 0x605fe576, 0xdc233de5, 0x959c3a2f, 0x1dde0aff, 0x062028bd, 0x1b8c64e6, 0x4344b057, 0x3fcc4a43, 0x35d82611, 0x4eb6117a, 0x76a7c1af, 0x7e0bb6db, 0x94dfaa29, 0xf7578c40, 0x08fa673c, 0x00cb0d77, 0xe598ebd3, 0x0819fbba, 0xd6ee0865, 0x32e61f42, 0xb3295c61, 0x94b328d2, 0x141c3787, 0x1413c6f2, 0x34c782e8, 0x5cadc6a6, 0x3410eb3f, 0xd6dccf71, 0xb6153c80, 0x5db8d470, 0x2ef8f45d, 0x41ba49af, 0x3c7f4ea0, 0xfed60bfa, 0xc9e3dbed, 0xa1693851, 0x9ffb2757, 0x6522b038, 0xf7cddcdc, 0xd4775791, 0x4b2727a4, 0xa2729102, 0x531ae7a7, 0x358404b6, 0x0e5ed473, 0x0d18b0b3, 0xa16e30bd, 0x5eec4884, 0x9c32f258, 0xdc29bcf3, 0x9af98451, 0xd4d6ceb0, 0xe40aa205, 0xc4c580b2, 0x4be8b4b0, 0x6e1fa4d0, 0x3a9cf1c1, 0x81795ef6, 0x368f4fca, 0x1c1c0ac0, 0xf056b026, 0xf4063b83, 0xcdd400f0, 0xe5b67b31, 0x132e40ac, 0x7602660b, 0x0000049f };
const u32 bern_num_data234[71] = { 0x785a16dd, 0xcba1b23e, 0x5e3d8fe4, 0x3b5f7c72, 0x13c9e585, 0x8353a6ca, 0xc682b623, 0xcf79e2cb, 0xe4ace203, 0x53c7b403, 0xbb371e88, 0xd0c1ce5c, 0xaaf17dd8, 0x0a75e785, 0xf7624d6d, 0xd7062d16, 0xdbf38068, 0x7779fffa, 0x3aa6def0, 0x91588fb5, 0x1ff827ac, 0x52863290, 0xa08f8f33, 0xc7d0acbf, 0x5ad8f96a, 0x1371c897, 0xfd845efe, 0xb90ad589, 0x3b2325b0, 0x57059f1e, 0xe0aac692, 0x5bf7f32a, 0xdfae6308, 0xa6d51279, 0x708707a5, 0x446afcd5, 0x23ef063a, 0x820bba33, 0xd1d8d5f1, 0x21bd1d59, 0x149a4c1b, 0x10b5fe91, 0x34371a6a, 0xa7e4b655, 0xc2187cea, 0x5cf84505, 0xc5e9c6f1, 0xcb8d5dcd, 0x3fa15cf3, 0x07163f87, 0x7ab2ab05, 0xece9f63b, 0x121a652c, 0x5dcbcf1c, 0x7fc01d88, 0x632cd8e5, 0xfc815363, 0x0f19fd44, 0x6c5caf0b, 0x17de4846, 0x16ec3a09, 0x4071d719, 0x0bc84f05, 0x373c6c12, 0x81659864, 0xd9bde630, 0xe9d01198, 0x40cbd7a8, 0xcfecf24a, 0x29bacaa7, 0x0016a7bc };
const u32 bern_num_data235[71] = { 0x48254821, 0x31a656ec, 0x24729d8a, 0xdb092e4d, 0x132f1723, 0xfe09a41b, 0xfe2b7316, 0x84e73fbc, 0xd0b414f4, 0xc02e0425, 0xdc5c6c13, 0x345f44d5, 0x2a8b1ebf, 0x689d27f3, 0xef2701f0, 0x71fcbd45, 0xf006a253, 0xd4613a76, 0xc1a9c283, 0x06f4cc37, 0x8d71fc42, 0x8cb56dc5, 0x806fa0af, 0x7409108f, 0x5fcf5d6f, 0x48cf434f, 0xb220e95c, 0x8b1f84d1, 0x23ffd102, 0xb9ad4bd3, 0x2f316c1c, 0x4f61e739, 0xe929e683, 0xceec8ebb, 0x6b97fd8b, 0x013ebb3d, 0x43deb945, 0xeea85553, 0x323372f9, 0x14cf1208, 0x37d2c227, 0xf169be4a, 0x496804bf, 0x12fdecac, 0x1290d87e, 0x0d768231, 0x532216ed, 0x7e4026c2, 0x1ddd6698, 0x9f1c1496, 0xade7b4a5, 0x08d1a433, 0x8a4d3947, 0x80cfd726, 0xaeed3d19, 0x985ed716, 0x001462fa, 0xe02f345a, 0x41771c51, 0x85828025, 0xdcf5c74f, 0xded104a1, 0x4235018a, 0x52991f3c, 0xe1f807ab, 0x9c6fd3f3, 0xd10a180c, 0x46dc55a0, 0x705e7d0c, 0xb6527e49, 0xe2856869 };
const u32 bern_num_data236[72] = { 0xdf6c8369, 0x90bd36da, 0xd256fa01, 0x6cbe5faf, 0x2556c457, 0x8be8c38c, 0xc0e152b8, 0xa563ac47, 0xa13c4f6d, 0xa0938406, 0x7239d5dd, 0x7f8b7b7a, 0x2dd890c7, 0xa67dd8c5, 0xa4e684d8, 0x1650b8a2, 0x9bff5366, 0xe96196bb, 0x97f8a457, 0xeefded33, 0x71ed412e, 0xe41c2224, 0xf12b97ed, 0x8d25ed0c, 0xb56fe6bb, 0x10d56ee6, 0x068cf2e5, 0x6164bf61, 0x656ba3c7, 0xbdb4bd95, 0x5190e07c, 0xedce4339, 0x54dcd4aa, 0x980f527d, 0x2fe6c261, 0x9b61d25f, 0x9dc347e2, 0x2ee8fba3, 0x21a91663, 0x5051cc55, 0x0d43c820, 0x4285ee64, 0xb27df48d, 0x517dfc83, 0xc019db04, 0xd3457631, 0x40a7a389, 0x0f4323bb, 0x108fbbae, 0x43f0d86f, 0x3480776f, 0xe1f8d25e, 0x3ef11e6f, 0xd9730d1f, 0x8c6c67b4, 0x689319be, 0x0c7a89eb, 0x6d43b34b, 0x53079733, 0xbaf238b8, 0xf938c78b, 0x6a87e026, 0x2f371b98, 0x36c056d3, 0x7f2dfca7, 0xd2fef96a, 0x7d8e186f, 0x883adae2, 0xce45f11f, 0xb162a4ae, 0x33848853, 0x00001b7b };
const u32 bern_num_data237[73] = { 0xcbdd5d0b, 0x3adbf082, 0x5cf2c81a, 0x93647a3f, 0xef723ac2, 0x8a7a1166, 0x1910762a, 0x4cf04c59, 0xe0d32e8e, 0x62762914, 0x3e91a524, 0x0e056df1, 0x5708ad27, 0x9f538716, 0x42ced42b, 0xc7538401, 0x4277c1d5, 0xb952df87, 0x6041cd44, 0xadbed4a2, 0x49c3bc92, 0x490a3675, 0x572d16c6, 0xe651a213, 0x7f345c79, 0x5f9f5e59, 0xba2041ed, 0x86eb5040, 0xdd866f17, 0x39eeb486, 0x0dbf1bdc, 0x15c847b6, 0x58b6a37b, 0x5ea3c18c, 0x4c46f0a7, 0x2908e6aa, 0xa35f2b3f, 0x020c2f6c, 0x0fe5c249, 0x6bc890ad, 0x8e836470, 0x393fd1bb, 0xb216fed8, 0x5f7566be, 0xf86c8d67, 0xddfdd04a, 0x0586126a, 0x52a7eb92, 0x9c679ee6, 0x44efd5d3, 0xe61a4d4c, 0x69707f9f, 0xd2329adf, 0x0e5d08bd, 0x81a388f1, 0x0cc107e8, 0x4f1a2487, 0xadaaa813, 0x46462fc5, 0x58e8f143, 0xe7d06fa0, 0x5de4b0de, 0x4cab922c, 0x26d89c84, 0x2dc2f64a, 0x094dc66f, 0x3cf3a9fd, 0xf15fb62b, 0xf47498d0, 0xe83bfe2e, 0x4e80faa1, 0x718c19a9, 0x0000002e };
const u32 bern_num_data238[73] = { 0x151cd639, 0x9a3a7391, 0x40c84063, 0xfa91ba47, 0x5be52de4, 0x523fef06, 0xf989a67a, 0xf80384b6, 0x3676c922, 0x3bb3a9a1, 0x3d058158, 0x0699cb02, 0x2e3173f0, 0xe8719de8, 0x32f6dca4, 0xbd6eacea, 0x0aee4179, 0x2789155c, 0xccb289ee, 0xab04ca35, 0x00428825, 0x56001f13, 0x6190318b, 0x96c9f188, 0x8e29e1fa, 0x623e213c, 0xf1cb6b59, 0x6a8e3bd6, 0xcb2dde24, 0x5345d121, 0x23e1526f, 0x845e6c8e, 0xf59eac53, 0xf1ae4958, 0x6b2098a9, 0x45699ccf, 0xa6f19416, 0x97b08f42, 0xff1c95d7, 0x0810f56d, 0x4bffc4b9, 0xd3c44db8, 0x6790100b, 0x91310d19, 0x06edf3b5, 0x4eb57ac4, 0x317c099f, 0xd32cb780, 0xbdedcdb5, 0xdc7f50a5, 0x13a5fbd4, 0x4aa3c954, 0xe5f598cb, 0x521b5913, 0x372477a9, 0x8a80eded, 0x3d8a3766, 0x6e0d2fde, 0xc4dc3d94, 0x72da4fd5, 0x9ae6ec87, 0x5f652e28, 0x3435c73f, 0x7eb041a4, 0xe79b46f4, 0xb0617551, 0xfd553960, 0x57630a78, 0x4aee05bf, 0xa859c1ac, 0xe5f99d3d, 0x80bf490b, 0x00000e7b };
const u32 bern_num_data239[74] = { 0x6340a783, 0x2421bc3b, 0xe83f652a, 0xceb0dfe5, 0x4989ee64, 0x89b64fad, 0x73e98d0f, 0xd10c2dac, 0xd127df40, 0x2a619332, 0x3d86a922, 0x20acbdec, 0x208ce8b2, 0x23129f93, 0xb5d95ecc, 0x2ee68711, 0x7fdc9d00, 0xd9bc9acb, 0xcca56cc0, 0x5ee4032b, 0x16a2ebd1, 0xd23e796e, 0xaeaaab12, 0x2d632c43, 0x82d009e0, 0x0f128bd2, 0xfcf561a6, 0x355e283b, 0x0d32cf62, 0xdea4c553, 0xb7b38ef2, 0xfc7e1429, 0x0339cf4d, 0x0a34caa1, 0x8c0ece6f, 0xeb68a97b, 0x739c566c, 0x61c52a44, 0x3a96c44c, 0xcd5afdb2, 0xe26d9f50, 0x8500a39a, 0xf34088e1, 0x86670fbf, 0x732c0252, 0xd2701912, 0xddadf9cc, 0x998e081c, 0x8a92d779, 0xc63777f1, 0xddfa2f6c, 0x6835fa5f, 0x80d9e6a2, 0xcbe88279, 0xc5dc08d4, 0xf718884a, 0x216eb33a, 0x694c207c, 0xc75d06d6, 0xe9f16c86, 0xef5fc799, 0x0151bd1e, 0x480a6d23, 0xb47a5af1, 0x917eda07, 0x4a74b6fd, 0xc19e16d2, 0x137bac59, 0x58a7d697, 0x22f0fb5d, 0x0dea4c5b, 0x66e14ed9, 0x26947a6c, 0x6078c84e };
const u32 bern_num_data240[73] = { 0xd52a1f3f, 0xe16a1db0, 0x7d8125df, 0xda6f4080, 0x5748a2a4, 0x52f75452, 0x6f55d625, 0x99a8dd3f, 0xa065ba5d, 0x35225b8e, 0xb1dde85b, 0xdea1236a, 0x7fc8df5f, 0xcb8520db, 0x4b3ddef4, 0xb5279ab0, 0x51098152, 0xdb59eb51, 0xb6e820ff, 0x4ffcd525, 0x07c07739, 0x3efa6cb6, 0x36431b0e, 0x61fa41dc, 0x2290c61d, 0x1a341adf, 0xf51f488d, 0x0556dd56, 0xb381f988, 0xe9fade31, 0x9e5f495c, 0xc2fe1cdc, 0x291e871b, 0x99b8fdef, 0x28c8e40b, 0x8871da84, 0xafd4cb9e, 0x992861f9, 0xf568a954, 0x71aa6557, 0x26758c8d, 0x96e15bf9, 0x430fa245, 0x283f9b8b, 0x73c1d3ac, 0x81c51220, 0x55922a1a, 0x58c5662a, 0xae3511c0, 0x9140bc9b, 0xd3187ce5, 0x096cb850, 0x7410536b, 0x61b2aa5e, 0xfcd7c524, 0xba369249, 0xbb30abe1, 0x24bb1a7c, 0x04f47c3c, 0x86d27f44, 0x68ccf2ca, 0x41f500c7, 0x37310ba1, 0xcad401fd, 0xc4f48cd9, 0x20808f8f, 0x5519577e, 0xb8e9a5cc, 0x98a0df45, 0x489838f0, 0x0a53bb4c, 0xf3d520ac, 0x0fc76309 };
const u32 bern_num_data241[74] = { 0x4ba7739f, 0xdfbcd638, 0xe8f1a9d3, 0xed28feb6, 0x11fc8bdc, 0x0487c8da, 0xd15d391e, 0x0f046de0, 0xbb5197e7, 0xff97c56c, 0x4b23b525, 0xa19fff82, 0xc1e19ea8, 0xf30b6ad9, 0x9b093278, 0xfa60c0e4, 0xd583986d, 0xbaa151de, 0x277ea1fb, 0x2349fa00, 0x967834c1, 0x55cd2477, 0xb6d825b8, 0x2719b09c, 0xbbc01db7, 0x531dcd49, 0x583fadda, 0x780a4415, 0xfafe869a, 0x6282c456, 0x7413debe, 0x55640d3f, 0x855105b3, 0xe6d04901, 0x9ed4609a, 0xb02defa5, 0xa90426f5, 0x113b1122, 0x7b3a994f, 0x191a4941, 0xb38b1cc4, 0x93f54391, 0xb7dfa429, 0x3a535f12, 0x88a3f5dc, 0x7a584720, 0x175deef5, 0x29a07691, 0xe75a84a1, 0x13de0a98, 0x787da099, 0x89fc2706, 0x2e1d7dad, 0xd11d0d75, 0x95291258, 0xe96389c8, 0xb8bf0c6d, 0xf3160062, 0x20afcb3e, 0x45d8122b, 0x4be821c9, 0xbc95ea4f, 0xce9dfb20, 0xa6f17d69, 0xdcf429e0, 0x3329ce8f, 0x2ef7b3c0, 0x13fc8b9b, 0x4bad4b48, 0x62d26477, 0xf4636d4e, 0x6ccf495e, 0x9f993feb, 0x0000a3f4 };
const u32 bern_num_data242[75] = { 0x34ec6eef, 0xd88c53da, 0xfd01d87c, 0x8ab55a4f, 0xce72ce6a, 0x96f5be3d, 0x97eb55bf, 0xc04bf9aa, 0x36cad0af, 0x59753c5d, 0x1e58928b, 0xd42ddfef, 0x13979131, 0xe3ea2fd7, 0x82ab5ad2, 0x2c307b85, 0x3697e5e1, 0xb9be28a6, 0xe19a13a7, 0xa411a944, 0x2da8a9ee, 0xa9f5d23b, 0x9f1fd3d1, 0x0adcaa8a, 0xa7498477, 0x20ddc6b5, 0xf9f75450, 0x7ac70bd2, 0xa9ce0f8d, 0x51463ba5, 0xd2a81dfb, 0x0dd005ae, 0xf75fa499, 0xeee2edcd, 0xcee2e7e8, 0x96a053ff, 0x52189388, 0xbaf93265, 0x665e9982, 0xa251441a, 0x64e5e9ce, 0x2a9c9748, 0x01b1f192, 0x572379fc, 0x8c60ca4b, 0x88b86976, 0xa188bed2, 0xcb4eb91b, 0x15013db3, 0x5c32836d, 0x58ee29fc, 0x45b8e032, 0x3102d742, 0x27ba80cb, 0x443618b8, 0xe7beaae6, 0x47a2a272, 0xcdb15ece, 0xc68471e3, 0x60e7bd66, 0x5b108e70, 0xd37c1a09, 0xe5e1f990, 0xe9aa9af4, 0x6bba191d, 0xff71e6e0, 0x21fe5217, 0xf0af8751, 0xbf01968b, 0x22b4c712, 0x79968a63, 0xb188b392, 0xe7ad5df5, 0xab842324, 0x000014ec };
const u32 bern_num_data243[75] = { 0xdfdb1941, 0xe01d4646, 0x0fc54d00, 0xbafc2bce, 0x15888394, 0x7505f723, 0x91fd731b, 0x622ab42a, 0x4fc06071, 0x234fa882, 0x471b518b, 0xab1c4b3d, 0x9d5b5d44, 0x6a71d5fc, 0x315d933f, 0x3e319bd3, 0xa37d4ed7, 0x3777bd95, 0x6c25b6f3, 0x250a23b4, 0x3adc4169, 0xba8bc2fc, 0xd5c5d54a, 0x2f434d7c, 0x90b75cda, 0x48b64004, 0x62a7410b, 0xd8831173, 0x64bab24a, 0x596cf9bb, 0xd13f18fe, 0xc68c2125, 0xec7a4498, 0x86df5bac, 0x4b12b332, 0xa7f4530e, 0x05a0873e, 0xea02e413, 0x84b47726, 0xa2587421, 0xa149cb9b, 0x20ef7410, 0xc13dc192, 0x0e79472b, 0x0cd46c11, 0xc7dac7b3, 0x45d0f0d2, 0xd57aedc6, 0xb47edbb6, 0xb094702e, 0x7675efc1, 0x1e314192, 0x1c5a327b, 0x27ff0628, 0x847bfd24, 0x35de41a6, 0x322d1c03, 0xf8548b00, 0x588fa7e0, 0x18e4784c, 0xe51c8899, 0xb73a7a9b, 0x74b96d76, 0xc3f2054f, 0x10280fa7, 0x68099284, 0xe4e1a2b9, 0xf4b59a84, 0x21ea91a2, 0xcdd0da71, 0xae9fc4d9, 0x868061ce, 0xb486e3c5, 0x458a54df, 0x0000000f };
const u32 bern_num_data244[76] = { 0x668e3ba1, 0x71e87de1, 0x0f5cc8c0, 0xe034ba0b, 0x844ff3b9, 0xf865e889, 0x4e0a95c5, 0x994cd98a, 0xd9405b69, 0xa112f32d, 0x72e5e719, 0xf05f93f7, 0x18a7461a, 0xf815a898, 0xbb2f552d, 0x8f0afaa5, 0xa1760499, 0x2ccfb4cd, 0x90434e0f, 0xc5e694e6, 0x1d7d2373, 0x5d6b1b19, 0x4370dc9d, 0x82076304, 0x61c10cff, 0xbf2adaa9, 0x85b719c9, 0xceda0f82, 0xc1f2c8a0, 0x62a239ff, 0x9883f4f1, 0x65e75d2e, 0x7447d602, 0x80803e28, 0x300c64a4, 0xb67c5a67, 0x6a3ac815, 0x170626ee, 0x23612c97, 0x144cd237, 0x4d4b5671, 0x2486738c, 0xd0e309ce, 0x704c067a, 0x0d4720d8, 0xd2a787d3, 0x926b177a, 0x96c8932c, 0x492b3e51, 0x58eddb75, 0x2813c297, 0x4806f0aa, 0x27780d0b, 0xc97c8c35, 0x12e42f7b, 0x9b7ef558, 0xfad2f1c8, 0x12c78799, 0x3d45f0ef, 0xd2738f5d, 0x49cf915f, 0x0bfe2e4e, 0x6134d51d, 0x6f645e76, 0xcebb1bb4, 0x930480bf, 0x40381554, 0x518db9c3, 0xc88aa5b6, 0xb4676141, 0xb3da7fd8, 0xa5f51c82, 0xce2d43e1, 0x21ea1be5, 0xa7b6f8a3, 0x00000001 };
const u32 bern_num_data245[76] = { 0x10d555c9, 0x2be01af9, 0x4a431874, 0x10a5a74c, 0x9e651546, 0x5d41d5f0, 0x376fa1f6, 0x915b3f48, 0x1055bcf6, 0xb2cc1e11, 0xfd144f8b, 0xd1c35e13, 0x2b0b0347, 0xddd744ad, 0xa711efd6, 0x5d3de262, 0x810ae0fc, 0xce6749bd, 0xb92a5483, 0x73fcca5e, 0x17df3929, 0x6d55fbf0, 0x24521c2f, 0x259fbc48, 0x14bc180f, 0x8132bfe7, 0x1144cb6d, 0xc20077cb, 0x69b2a242, 0x6a889503, 0x757e560f, 0xe2e0d387, 0x7d3a8bfc, 0x713299d5, 0x271fe94f, 0x9dc761bd, 0x5b47eacf, 0x8111d19c, 0x30362715, 0x5c2a2c1a, 0xaf40470d, 0x7161fa55, 0x6d24eab3, 0xc81ccfd8, 0x509cdf1e, 0x1edb8200, 0x908838ab, 0xdd1e8079, 0x24a073e2, 0xcbfe8b3b, 0x5bdda092, 0xf6215756, 0x312da6ff, 0x34e8c083, 0x100f19e4, 0x067d455e, 0x82ba27ce, 0xcb341f9f, 0x851050e7, 0x88835653, 0xe8c6d883, 0xe9cb07b5, 0x32a7e079, 0x6ef1427b, 0x2b25d66f, 0xe158780f, 0xa41924b6, 0x6721a361, 0xf8e259ef, 0x8ab5d53b, 0x7f6c1fe1, 0xfc3e51be, 0x381532e0, 0x8f698794, 0x6b22d843, 0x000003e5 };
const u32 bern_num_data246[76] = { 0x7a126347, 0x3522e9af, 0xae12124f, 0x4629660e, 0x0b7b3763, 0x78be594b, 0xd4f8ba60, 0x1bb62c48, 0xf1589634, 0x10bc62a2, 0xc525d97c, 0xa14ed73d, 0x82cf02e8, 0xd84b3363, 0xce32d39e, 0x42bc13ca, 0x7a15bb3c, 0x66ac95d5, 0x398aefd7, 0xda8e42e8, 0xe471675f, 0x7b77b1bc, 0xbb976c43, 0x1d3ea6ac, 0x8604c7c4, 0xd4232245, 0x493e4414, 0x98879e50, 0x9f480922, 0x454b5af8, 0xe9866a43, 0x9671aa4f, 0x8ff39369, 0x935d95f4, 0xbd735013, 0x507607c8, 0xd14d6313, 0x56821a3b, 0xbb9c2492, 0xcf94389a, 0x3282bfeb, 0xcb107123, 0x36aa7ccd, 0x7c8791b2, 0x0df0232f, 0xb817053d, 0x9b3afe42, 0xb1c865af, 0xcef2c810, 0xd46a84b0, 0x87b38805, 0xce5102a9, 0x9d05088c, 0xc6ef1c4e, 0xaecbd391, 0x8ef5bff5, 0x8086e36d, 0x652178ee, 0x06989ec4, 0x2b468934, 0xf3c7aae2, 0xba8d8eaf, 0x198d0312, 0x64098918, 0xe2b25486, 0x109eeb66, 0x180c0c52, 0x1fb51644, 0xc589f0cc, 0x3e381854, 0xfde2e9d9, 0xf05e1d62, 0x1bf9e66d, 0xc421a7fd, 0xee2d2c48, 0x000000a2 };
const u32 bern_num_data247[76] = { 0xa8504be1, 0x8782effe, 0x6033fcfa, 0x735b1419, 0xfdd9cd5a, 0x941311f1, 0xa6966054, 0x325b13c1, 0x083673a0, 0x5f0c0406, 0x4a3665d0, 0x688156ad, 0xe7e12b1e, 0xc5569d90, 0xc1e0c720, 0x567f2b83, 0x0e06dfd8, 0x43ae2af2, 0x49b0fdb6, 0x187c4a83, 0x5b04b437, 0x4f6b5dfc, 0x74ef5576, 0x2f26d6aa, 0x667f2d1e, 0x22dc3b7f, 0xa669e31a, 0x34388e04, 0x54df5e2a, 0xc4162969, 0xdb3f4f8f, 0x99999eb5, 0x5c8c68ba, 0x1ccfc4b9, 0x2379a06a, 0xbdbd90d4, 0x6e8e5946, 0x54173603, 0xee8bb012, 0x534fb00c, 0x9a924d75, 0xbead1b19, 0xd94a2f44, 0xe49cd56d, 0x757ba92f, 0x517cc4ea, 0xd059f36e, 0x4adea7c8, 0x6ed4892d, 0xc80cf480, 0x6ae82f44, 0x5419cb2b, 0xc3941951, 0xc8a69648, 0xcbfae104, 0x35fadf8e, 0x2c6de164, 0xeefa5fea, 0x33e19edd, 0x8bcae3dd, 0x912efd1d, 0x926e8e1c, 0x4b4c2306, 0x1de5a5f2, 0xa0f06004, 0xde8d84ee, 0x32230f9c, 0xb4a387f2, 0x2cc94f09, 0x88dcf14f, 0x41d312a4, 0xdc30fb33, 0x544b794c, 0xad17e926, 0x6d6d533c, 0x0522386a };
const u32 bern_num_data248[77] = { 0x4c4fe23d, 0x39455dc2, 0xa0f6647c, 0x916862a2, 0x76278fde, 0xf1dcce3a, 0x8a6e6473, 0xb5c1eb30, 0x5a3d505f, 0xfc96bdef, 0x1c835864, 0xfff69b8d, 0xcdadce78, 0xcdf38ce2, 0xbcb648b6, 0x7b0c2877, 0x8a18d00c, 0xac646670, 0x75a2189b, 0x5043f905, 0x2e95d61f, 0x5ed1e5cd, 0xd31e5bb6, 0x07884341, 0x3c4cddea, 0x2d164eef, 0x05df9626, 0x40c8584e, 0x1f761d8e, 0x80862035, 0xd8be57a7, 0xbadce11d, 0xae502571, 0xc587e61c, 0x117ef4ef, 0x9e0b7448, 0x1edb52a3, 0x6ae06b61, 0x584f1d35, 0x1d370dd2, 0x5d638058, 0xab1e9ed0, 0x20849df2, 0x4ef71d71, 0x78b2a0f4, 0x6f33635b, 0x547976e0, 0x4069cf0f, 0x0ad4e22d, 0x635cae52, 0xce79c301, 0xa1732f61, 0x2e5d7056, 0xa214ecf8, 0xf39f0f45, 0x625b3ff8, 0x90b77cbe, 0x6dee8f97, 0x50264a7c, 0xe455aa7b, 0xbf51461f, 0xb43223ce, 0x34b8c5cf, 0xba74faf6, 0xbbbb9f81, 0x2084cd51, 0xca34370b, 0x9c8cd6c0, 0x5276f373, 0xb26ecc5f, 0x192c9f80, 0x3c8392ee, 0x299526aa, 0x397d08cb, 0xed920296, 0x8166e8ab, 0x000d2a50 };
const u32 bern_num_data249[78] = { 0x86d89a45, 0x44bbd9e0, 0xdce5cd1e, 0x5a937f41, 0x5b31e949, 0xde0b69e5, 0x03236634, 0x33edf1af, 0xd021a622, 0xa020905b, 0x05831c92, 0xd0cb8e15, 0x986bc5c9, 0xaf21abc9, 0x15518763, 0x409b99b1, 0x9ea2fa78, 0xf6765a4d, 0xab556ee3, 0xeed06168, 0x8906f3ee, 0x2536f939, 0xd768e7c7, 0xc2e5da72, 0xfa128462, 0xfe4220cc, 0x641292a1, 0x13fc9b8c, 0x39e59c5e, 0xfddc2a8e, 0x71b8df59, 0x80c097df, 0xab1ce506, 0x1a89e393, 0xb908eb1c, 0x83a49464, 0x6aeed41d, 0x6927dab0, 0x8ebf3d8c, 0x230eafe7, 0x556cc6a7, 0xb908f437, 0x869f171f, 0x71ca8575, 0x95f00add, 0x55460b37, 0x8307db78, 0x12a8e23c, 0x27075f69, 0xb5ce54e6, 0x5ba0a545, 0x882bfaf2, 0xe4d879d3, 0x63ccf2ed, 0x39dabc39, 0x3dd0930e, 0x0c04bad2, 0xe5781941, 0x65a73220, 0x44d59800, 0x8a4e51c1, 0x5bd4cf98, 0x4fc7e0e2, 0x3831800f, 0x3a3c440f, 0x9af412fc, 0x217eec09, 0x2519692a, 0x34c05d72, 0x6eba1cba, 0xc3230d22, 0xe0b8866b, 0x5d2ecee6, 0xbdbb4d6e, 0xc4f48e0e, 0x3b702330, 0x08dcbe81, 0x00000003 };
const u32 bern_num_data250[78] = { 0x7436dbd1, 0xbd7d9f4a, 0xf3c1749e, 0xd9273ff3, 0xb537e698, 0xd7420e15, 0x5e02aac1, 0x7c426ab0, 0xd096508e, 0x255b2757, 0xc2aa7ed9, 0x0f6b9749, 0x56382f24, 0xfd7222a0, 0xfd8fafcd, 0xb0178ddc, 0xe3b36194, 0x08bf891c, 0x4fbb7d38, 0x5a34a5cc, 0xd44ea4a8, 0x524f105b, 0xd3566cac, 0xb64bbbb6, 0x1d276afe, 0x699e7faf, 0x268622fd, 0x56778957, 0x1f866e0b, 0xaa4e2402, 0xa069f21c, 0x8ec2761e, 0xb97276f4, 0xe65795eb, 0x929bd916, 0x697c1a97, 0x683e1b18, 0xf3356016, 0xd6c561ee, 0xf8109fc5, 0xa20fa61c, 0xb0418bbc, 0x196bbc69, 0x8754c2b2, 0x873ddea1, 0x69061377, 0x49d4d2a4, 0x3f26fce4, 0xd67d38e4, 0xaad542b8, 0xd50e97f3, 0xd53384ae, 0x05081826, 0x7583aa2b, 0x039b0759, 0x4fc40963, 0x4d3b1136, 0x83defb7c, 0x32b2c77e, 0x40675621, 0xf343521d, 0xe6470d27, 0xcc48a7c7, 0x6ba0c393, 0x2f82f8f0, 0xb1f362bf, 0x11e1af2c, 0x30fc9d22, 0xf448eaa4, 0xfeeb2080, 0x16d259f4, 0x5ce64727, 0x99e14c63, 0x7e97b344, 0x5dc9763a, 0x86100cef, 0xf966d57b, 0x00000006 };
const u32 bern_num_data251[79] = { 0xbf91774d, 0x946cac4b, 0x6703e1bb, 0xa29f5a48, 0xa3623a3f, 0x1b8105d3, 0x9b7cc7ac, 0xaf4244db, 0x6d5168a5, 0x0dc42ad7, 0x1f973fb4, 0x24deff54, 0xcab3a723, 0xf1f4629f, 0xd94e33d4, 0x558d6709, 0x3ae7059f, 0xf2ee894a, 0xb709107f, 0x384d602d, 0xdc918539, 0xba0f5d78, 0xbfe08176, 0xc0f01147, 0x2829e9d1, 0x04654915, 0xaa64c4b2, 0x0f3f1f8c, 0x5bdba88c, 0xcf1c9e4d, 0x80852736, 0xc7a54b95, 0x99506242, 0x5cc88393, 0x85cf4193, 0x891c552e, 0xee38ee89, 0x1971a868, 0xe7aee447, 0x607f5122, 0x61b8f124, 0x9351a324, 0x5424764d, 0x38250dd8, 0x8e385a78, 0x8b3bc76f, 0xf00f2081, 0xe9d3dd9d, 0x50a6cf48, 0x43a90344, 0x8a2aadd8, 0x5e6f2bc7, 0x8ba979a7, 0x39986f4e, 0x5bf504de, 0x9160e0a6, 0x20e81db0, 0xa79707c0, 0xcd7fd644, 0x89761d10, 0xfb25378d, 0x27043a71, 0x3e7fd3d9, 0xa751b935, 0x9f7f1e3e, 0xf7eed542, 0x835c1202, 0x181ccad8, 0xb583af7a, 0x72ac5044, 0x167da00e, 0x06f75c76, 0xa303426a, 0x0208834a, 0x18242f91, 0x26b9daaf, 0x11e4fee3, 0x9f2c0f07, 0x00012b73 };
const u32 bern_num_data252[78] = { 0x5f15cb17, 0x92bcfdd9, 0xd8ab6663, 0x4545c070, 0x652e9c9a, 0x84a42ede, 0xd2ee7b0e, 0x4db22d3e, 0xe9eff080, 0xa477800d, 0xacd65884, 0x32b56a72, 0xc19d13a0, 0xb59fc44c, 0xa4905716, 0xeb08fdd4, 0xe2d161cc, 0xedf922bf, 0x543d80c0, 0x8080a405, 0x3e41470e, 0x1b159f3d, 0x7f13d9ad, 0xac6924dd, 0xa86f878c, 0xe2ec2a07, 0x21beeeef, 0x0edce76d, 0x3d46e8a1, 0xddfa76a0, 0x31f1efe0, 0x117f3f3c, 0xb38ff4d3, 0x7dae3ed8, 0xcfdcd44d, 0x36505237, 0xf81b190d, 0xd2e0e108, 0xcd2a8ec0, 0xe5ab21e3, 0xf578b9a2, 0xaa9b56e1, 0x5c74176e, 0x8d433700, 0x12eb62a2, 0xd36021c2, 0xfe4a42e1, 0x78c0701d, 0x1fffcc79, 0x51d66a67, 0x26e74a1b, 0x98699b17, 0x2bc7d6c2, 0x749c3143, 0xfedde79f, 0xfed499ba, 0xb29a9604, 0x9011ece8, 0x45b33b6b, 0x1ff0b7ae, 0xfd9f6f43, 0x3f1cb362, 0x9f96f7c1, 0xfbfe0020, 0xbef41028, 0x742fc4b3, 0x1d2db044, 0x92293989, 0x367446c4, 0x2520f2e3, 0xe477dcf5, 0x80f46e0e, 0x65c7969c, 0xf3a54598, 0xb07a8dc9, 0x51a6740d, 0x0760c8be, 0x2521ee91 };
const u32 bern_num_data253[79] = { 0x456797c5, 0x0ed19893, 0x9ebdc476, 0xc2112c3e, 0xc18a9040, 0xcc03a94d, 0x944ad46e, 0x65d0ab26, 0x4910a005, 0xa24dc509, 0xece7050d, 0xfe8d9a5b, 0xff2f5d81, 0x72ef2db7, 0xef90ff44, 0x8e070b03, 0xf99af8ee, 0x3d54720e, 0xb0977689, 0x1a714d81, 0xa1fceb7e, 0x89898dfb, 0xc04e3733, 0x27908eaa, 0x49adf302, 0x406f4ba4, 0x6ade109a, 0xeb2969ef, 0x5578c0f4, 0xce2077f8, 0x56a3fe30, 0x0ad105af, 0x35dab2c0, 0xa5d49dfa, 0xa2d68c82, 0xc51fbb61, 0xa3797a2f, 0xf44e37ba, 0x2893640c, 0x8f38c881, 0xbccdcb98, 0xcc50e4b9, 0x2c991a99, 0x2a7cf358, 0x10015dc9, 0xd69a9701, 0x76ab9e23, 0xf7944909, 0x8842add0, 0xd1e53679, 0x50f8778f, 0xf70892f5, 0x9351ce9d, 0x754d026c, 0x166fd067, 0x2e3a0a6c, 0x0f73eb07, 0x4f4486a8, 0x727a7f37, 0xe0f68444, 0x97e9e3ed, 0x071c45e4, 0xdc9c5b3b, 0x391b1d2a, 0x7102aad0, 0xb39a68d8, 0x74623817, 0x8c335cd5, 0x81db4546, 0xcc8e5f2f, 0x0fc9e65c, 0x9352d0eb, 0xb256e2e4, 0x95b28d46, 0x01caca29, 0xb8a6932b, 0xfaf97183, 0xdd576c3f, 0x000008b3 };
const u32 bern_num_data254[79] = { 0x90e400e3, 0x813deee7, 0x93756cd5, 0xb99111d4, 0xf0a1a1a3, 0x20a5319b, 0x12a8bd1c, 0x42731499, 0xc6b07972, 0x63e3213f, 0x2510d127, 0xac44782a, 0x726d57fc, 0xf7eba349, 0x062fa2e2, 0xbfbf0e46, 0x836cc706, 0x92b64b64, 0x217b3967, 0x8bd9f781, 0x4f75c16f, 0xc3129f1f, 0x2c5f2529, 0x62a896ee, 0x602419e7, 0xa8f06cb2, 0x4b7aaff7, 0x92624e57, 0xf11bca7d, 0xc4763e3a, 0x1c865db4, 0xdae655f1, 0x1b491ea3, 0x676f4c6f, 0x2e98476b, 0xa3b2bc87, 0x9d9d95b5, 0xe80d4dd7, 0x7de77af1, 0x37074941, 0xd0db4930, 0x6559a952, 0x4077a0d5, 0x7bc6091a, 0x4f26f815, 0xa302fc2c, 0x6ccf72e5, 0x4dd7d5d1, 0xfdb9d89d, 0x74a99214, 0x42a3ec0c, 0xa1488c72, 0x7e522da6, 0x7cf14529, 0xf42de066, 0xef8026ff, 0xcd503fb6, 0xbb071de6, 0xbe619ceb, 0xa828d545, 0xe08d1765, 0x8b7def31, 0x005f2623, 0x86fe5ae1, 0x149c8fbb, 0x273042e3, 0xa123a6e8, 0xa3cc87bc, 0xe6b85de6, 0x11feca25, 0x1ba76a8c, 0xa6126462, 0x9c4ee693, 0x4516268c, 0x6e801083, 0xccaa3ca5, 0x023f665a, 0x7b0ec4a6, 0x545a4a6c };
const u32 bern_num_data255[80] = { 0x333d6401, 0x8f9f8dff, 0x7a30cd91, 0xc777e092, 0x60c61eee, 0x28dddd28, 0x4a7e4304, 0x2c7565db, 0x988f5b62, 0x92457ba4, 0x06df5183, 0x6c95df4a, 0x985b96db, 0xf30d4198, 0xc45350f5, 0xb4df38ef, 0x2e9cc867, 0xc37017c9, 0xac8b27cd, 0xb36b7675, 0x89a01c37, 0x49f46b0c, 0xc2f2f4d4, 0x231fba1c, 0xf75f87e3, 0x01636f90, 0xf422aa85, 0x9aaa5f6b, 0x2ec7ae3a, 0xa710755a, 0xafed368c, 0xdb519d9d, 0x26c80116, 0x8ce29ff9, 0x67706353, 0xe17e9d61, 0xa1afecb8, 0x6ad68c62, 0xa6d3f38d, 0x2423e039, 0x439471bd, 0x413a6ab2, 0xaba3b304, 0xaf366619, 0x6349d14c, 0x04f0920e, 0xae599d12, 0xbccb8e02, 0xaba894d9, 0xea802153, 0xb39ea04b, 0x9a8a37ae, 0xe0e68f48, 0x9efe5a3a, 0xb781b5d1, 0x5cbd14f2, 0x5eae3532, 0xa44fc842, 0xf78af1b1, 0x4a9f3076, 0xde85e7bc, 0x1a7b48a1, 0xcafd348a, 0x6ab8e96d, 0x3f66ac54, 0xd08d7daa, 0xadec517b, 0x45184c00, 0x8e01fd85, 0xbd671b04, 0x7367d856, 0x5c859f35, 0x07e53aa4, 0x6194e866, 0xb97786ac, 0x4627c3bf, 0x284dd209, 0xdbb2d45c, 0x05cfa3dc, 0x000000c2 };
const u32 bern_num_data256[80] = { 0xe547cbff, 0xd7649d72, 0x71d947b1, 0xbf1adb4a, 0x626d6c98, 0xd4341ce0, 0xc8142861, 0xec0b58b8, 0x8a2597fb, 0x645fa936, 0xbc59df6b, 0xd7c12c8e, 0xb8dabe8f, 0x5b5617b6, 0x27c59614, 0x2d0744bf, 0xb7ed1d4c, 0xf724b50b, 0xc5c3ea38, 0x9fdfd2ce, 0x02b5285f, 0x2f2e5b6a, 0x0c148a80, 0x596e0bde, 0x2f1107b0, 0x305d1a3c, 0x1f9d577a, 0x1cb4ef47, 0x1b824ee7, 0x1732aa04, 0x6ef27d6d, 0xba06b05f, 0xc6d503d6, 0xa4de4d06, 0xbcaad4c7, 0xa070c220, 0xba958a37, 0xf7bf04db, 0x806aa86f, 0x331cd8cc, 0xca829b87, 0x6428f8c7, 0x18b5d7a8, 0x1cf745ee, 0xb5452e62, 0x2dc17639, 0x2f3b104a, 0xbd8c30a1, 0xae99a8c8, 0x16a244d9, 0xb4fbbebf, 0xa79cf34e, 0x5b50d8db, 0x00424743, 0x9359f6cf, 0xc0eae691, 0xcae8bcfe, 0x828c6b98, 0x7d3b37c9, 0xaf218054, 0x4e140cfb, 0xe203105e, 0x9fef0bff, 0x84e2320c, 0x453573cd, 0x8aa143d7, 0xc4e5c40e, 0xc3c8d63f, 0x8427798b, 0x1692784f, 0xc10eb98c, 0xd38a65e1, 0xd5c830c8, 0x7564baa1, 0xcdd8cd35, 0xb74aa9b1, 0x59818640, 0x1136e24c, 0x529f70b9, 0x0000003b };
const u32 bern_num_data257[81] = { 0x14206d87, 0xf9f62850, 0x4ba943b7, 0x752f7412, 0xd3f3c6e7, 0x22a9dc60, 0xd3969334, 0x27cfcae4, 0x76fc26b2, 0x25b4f100, 0x7eee8ee2, 0x36ed6a1c, 0x98bd4ac8, 0xbbd1a93f, 0xc602e09c, 0x36b3ac97, 0x6569f3e6, 0x52f744ed, 0xecba6dea, 0xad96ff65, 0x0e0c6c21, 0xd75015ad, 0x1e25b9e2, 0x5bf71852, 0xc00eeace, 0x61ea3e11, 0xf0f33930, 0x4484cec1, 0x8a91e6b6, 0x0aab9b05, 0x7e0ce215, 0xf246c6b9, 0x5e2b5a6c, 0xb34dd1d3, 0xe3cbee13, 0xd64fe556, 0x3d3cd2ef, 0xc1391ca3, 0x3e7cb38e, 0xccefdf73, 0x094a2aac, 0x69894f5f, 0xa207b7d2, 0xa40f7e36, 0xecf21e84, 0x885e3369, 0x1c964075, 0x3fa7101b, 0x7682b2f6, 0x1ebddfcd, 0xdad337d1, 0xf98d0140, 0xe79ea5f0, 0xaabcc0cd, 0xa25f0e09, 0xdfe4fcb2, 0x5428a16b, 0xfc917275, 0xadf7a078, 0xc9ffe00d, 0x9010286c, 0x03f81480, 0x01f3584b, 0x8a97830a, 0x86a81527, 0xd0a5e627, 0xb06736c7, 0x8277a46d, 0xa5215b52, 0x1c12de7f, 0x576e6720, 0xa34b33e3, 0xf1b8fbe4, 0x465ac5e1, 0x02b52e26, 0x2e8d705d, 0x446f720b, 0xef9d15b0, 0xe62476cc, 0x51829607, 0x00000007 };
const u32 bern_num_data258[80] = { 0x38a0c2d7, 0xd9ede163, 0xc44720db, 0x7e7d6ad8, 0x7a30fed3, 0xea7190bb, 0x38d6ce65, 0xb59659c7, 0x7240f4dc, 0x2d10e4dd, 0x2544695d, 0xc8701803, 0x3dcb7e41, 0x1fa91ee6, 0x8361a5df, 0x0693e326, 0xeda67d8c, 0xa9afe940, 0x214a258c, 0xc2a040fc, 0x6b584b2f, 0xfdcc7a59, 0x81b4fa07, 0xffca1fc3, 0x322b62bb, 0xc1e267ae, 0x75dd3730, 0x1ec19e04, 0xbbb90b6f, 0xafb355b0, 0x3f82e661, 0x2b25a33c, 0x21e6f175, 0x957be255, 0x6c786c4e, 0xd9ac4732, 0x7a00c8c4, 0x321231cc, 0x306df880, 0xbbb825e3, 0x1873d638, 0x494b7a5d, 0x37468845, 0x7609116f, 0x44f231e2, 0x3a410b83, 0xb982b3dd, 0xaa9e57bc, 0x6c68713d, 0x6cd40f5c, 0xe9fb2c2b, 0x7e6dd07a, 0xef0348de, 0x6999fa60, 0x57a6fd4b, 0x74a546a8, 0xea557b02, 0x74e93ded, 0xe96a3ce6, 0x534f73e0, 0x518198ac, 0x769beefe, 0xe347c287, 0x67f6180b, 0x7ad962ea, 0x570de1fa, 0x6b32603e, 0x57bb6fe8, 0x05be3a70, 0xfc3052cf, 0x7164a58e, 0xdfbeecd2, 0x30b316bf, 0x60151c44, 0xd121e22f, 0x5e7b0cc6, 0x2f2f9430, 0xe1b75033, 0x9bc1f365, 0xa1753434 };
const u32 bern_num_data259[82] = { 0xb6be3005, 0x0717ddbb, 0x0da69a73, 0x614c2318, 0x909f38e2, 0x77a6ce25, 0x5fde263c, 0x6ee63ad0, 0x31f96d94, 0x86deaa19, 0x8ea6ae49, 0x7a0e832b, 0x0724dad2, 0x74bb7c9c, 0x3c9e2e92, 0xf2abcd72, 0x68e913e3, 0xe650387e, 0x40fae0af, 0xab362dda, 0xed447087, 0x662e9388, 0x0bd4563e, 0x0aafd390, 0x60eba5a0, 0x173b11e5, 0x1496e442, 0x77038156, 0xd3e3dd01, 0x8bcd52c7, 0xc82190d3, 0x3a848904, 0x5add09b6, 0x5a435f1b, 0x17231556, 0xd3644328, 0xc0789976, 0x48a75449, 0xafcc5d5e, 0x3bc72832, 0xc5d90d45, 0x44b94084, 0x76c3165b, 0x0ea0429a, 0x2cf1047b, 0x70e1a8f1, 0xdd9cf140, 0xb6585132, 0x09e55721, 0x0f18d8f7, 0x48c37277, 0xe44ac26c, 0xe7c2af5d, 0xcd997ad3, 0x23cb5851, 0x12abe42c, 0x5cb56282, 0xfe6b45b5, 0x8a11ea7f, 0x0e9e5b64, 0x87ce194d, 0x771eb0a5, 0x5aca2d1f, 0xcb5e0df8, 0x0ef74fa4, 0xe7bdd47c, 0x0a8d22f1, 0xd7f846e8, 0x5f1fc152, 0x3a5d2306, 0xfe347097, 0x78a66e9b, 0xb5a8e0c2, 0x73623a47, 0x72caeee2, 0x0d8490ce, 0x6770a7ec, 0x844da313, 0x5e6899ed, 0xded3d040, 0x7316b0ff, 0x00001ffc };
const u32 bern_num_data260[82] = { 0x7976c143, 0x45dd9cc2, 0x8d7f803c, 0x79a611eb, 0xf0f3e46a, 0x7f2fa5e5, 0xf4c5f52f, 0x54a892cf, 0x5e1a14fc, 0x9972cfc0, 0xe8665d10, 0xe9c138dd, 0xfceb57bf, 0x58303cc9, 0xb0aa9fcc, 0x7120d6ef, 0xb5282cfe, 0x023adfe0, 0x848a4701, 0x1a0fa31a, 0x6d01d020, 0x2f58090b, 0x295bf66c, 0x7990575c, 0xa7116363, 0xab2daedb, 0x535ba6cd, 0xc5bc974d, 0x70c52a95, 0x2605ceab, 0x66903e5a, 0x1dfdacf2, 0xc747d506, 0x0c4e83ca, 0x6ff2022a, 0x2af62898, 0x837a1151, 0x71823fc4, 0x577d306a, 0x9dcae7ed, 0x62352f92, 0x0a416d32, 0xa90a675c, 0x9b504f71, 0x658581cf, 0x1cc7fcdc, 0xc28c65f0, 0x2b483b53, 0xfcfc8d34, 0x5f3fe674, 0xdc85816f, 0x4ac9d21b, 0x6e7d36d1, 0x79beaf77, 0xc8af66c4, 0xd72d8873, 0x244b5c47, 0x6f1119de, 0xe5c8091a, 0x9b8a1ce2, 0x9c237f39, 0x5694dd58, 0xef566b61, 0xf15d7ed1, 0x95066b8d, 0xa01ef3e0, 0x5161226d, 0x6bf86400, 0x98f38af7, 0xedf469fe, 0xf99efe6e, 0x32aecb64, 0x52b94bc3, 0x4dfcd41e, 0xa98ad2df, 0x0c80fcc9, 0x76f2ce46, 0xc067336c, 0xadbc8e8f, 0x5be5849b, 0xc374e661, 0x00006edc };
const u32 bern_num_data261[82] = { 0xeb64eabf, 0xad12d460, 0x58b2077e, 0xd1ca2df2, 0x230beee2, 0xf85483af, 0x5d8ecbb6, 0x74b300fe, 0x26da4a32, 0x1655a9da, 0x71c244b8, 0x9c1e666d, 0x8c622502, 0xb98d14c1, 0x8df2e4b6, 0xf8419bd3, 0x0fd017a3, 0x195e4a19, 0x2ce013dc, 0xf97e169c, 0x52a87098, 0x195a5fd3, 0xf0ece2a2, 0x2530d81a, 0x1e0f6373, 0xdb3b78e0, 0xb04a852d, 0xa10b0f7f, 0xf42462c2, 0x0da250d4, 0x3fe4229b, 0xcaf718f2, 0x9debf974, 0xf3d23633, 0x05c4ac56, 0x6606872c, 0xeb0a8bc7, 0x79792f60, 0x6a807115, 0x83884a5a, 0x4bf860a4, 0xd4dfb77e, 0xccd08440, 0x6d903952, 0x441c133e, 0x2e385845, 0x5941f59e, 0x63bd12af, 0x5ace8969, 0x6a8ead19, 0xfb42fc2e, 0x55da9c19, 0xd784d144, 0x27209a01, 0x3365e72b, 0x560d9bdd, 0x6d22d18c, 0x79e12b1c, 0x2f84e92e, 0x42954194, 0x851e677e, 0xbe6721b2, 0x7217178d, 0xaed998b9, 0xb5e7d523, 0x67d69700, 0x16ebdd5b, 0x582bb492, 0xacbe46c4, 0x07042522, 0xf3d2be7f, 0x45b41d58, 0xd6308b65, 0x1e217fe6, 0x0855239f, 0x6cbc49c5, 0x139d914e, 0x7ca931c7, 0x4960d72b, 0x82a66c60, 0x5fcc76f3, 0x0000f697 };
const u32 bern_num_data262[82] = { 0x9a70ac07, 0x8a5363e1, 0x74c22cac, 0xccac5428, 0x782c1402, 0xf90ee505, 0xfbba6508, 0x32f9abc3, 0xc76748d6, 0x8b19dd11, 0xb8a9c048, 0xf0807d62, 0x78c198bb, 0x487a59b5, 0xc871a348, 0x08aa1143, 0xdca9136b, 0xd6501924, 0x801cd424, 0xdd36f749, 0x57615e60, 0xa104c27c, 0xabceaa83, 0x29208dbf, 0x26745b2a, 0xc9b328f1, 0xfc62cb78, 0x75ed42b7, 0xd409d9e6, 0xc483734d, 0xd88a95ad, 0x882834f9, 0xff18946d, 0x9c0351ed, 0x0a5865db, 0x001c6cb9, 0x3fe1134a, 0x319b36bc, 0x6822bfd1, 0xe0fdee2a, 0x309ba5d7, 0x7701247c, 0xa7214c07, 0xf7358493, 0x0fb3ebfb, 0x9f19d3ca, 0x29a580af, 0xb7d2542d, 0x9c9b6fb2, 0x076cc41c, 0x871a1060, 0xdaf886a4, 0x9faf64b3, 0xa16f7bcd, 0x311f1180, 0x21fa50df, 0xd0581d7e, 0xa0056fd9, 0x76504248, 0x27327918, 0xaef3f93c, 0xf8fa119b, 0x73933344, 0x564dfc49, 0x33ee983f, 0x90319786, 0xc3f79123, 0xba71b865, 0xce69e6f2, 0xf9e14b1a, 0x0800e21b, 0x754ac652, 0x03160b01, 0x63ab0360, 0x5ea5b01e, 0x98c82a9c, 0xe41a0978, 0x65824e22, 0x172f8d87, 0xf6d79774, 0x5d4db238, 0x00051fb5 };
const u32 bern_num_data263[83] = { 0x3680e40f, 0x586447cc, 0xd368d340, 0xaaf87675, 0xf316bd33, 0x9ce7ef53, 0xf3c560ca, 0x0c8d5b43, 0x3c4d099b, 0xbefdf153, 0x87b5da7b, 0x8b0dcb47, 0x722f0e4c, 0x2b194b9e, 0xb7ae0c79, 0x7712947b, 0x0f4f9d6c, 0x60a0dcd9, 0xf28fdd93, 0xd1e761fa, 0x04621b1b, 0xd0289383, 0x8bd0a88e, 0x84537c5a, 0x49dfb898, 0xc86bf745, 0x8d1f88fe, 0x113cc23b, 0x659650a6, 0xceed7bba, 0xd4a953a7, 0xff989407, 0xa84a6e22, 0xe09b6b39, 0x9b7bd9cf, 0x28202732, 0xb7107f2f, 0x797c5d80, 0x79b08432, 0xa7849ef4, 0x6846e7d3, 0x5c33d73e, 0x795a59f0, 0xebe3124a, 0x9e5c5d5f, 0x751081f2, 0xd32613fa, 0x339de60f, 0x5ced363d, 0xca0d4ee3, 0xc6a2e9a8, 0x8492248d, 0x247204ea, 0xa3dfc947, 0xfe895525, 0x9d71716e, 0x49d9e738, 0xeeab1c85, 0xabd64571, 0x6639f3cf, 0x0b9f9e4c, 0xf755f493, 0xfc6bfe64, 0xb6b40fb9, 0xca934f6a, 0x4f7345fc, 0xfff19f0c, 0x72662e8b, 0xab05c8cd, 0xc74e3d63, 0x07cbd782, 0xbb9e6f73, 0x9faad2dd, 0x208a6abe, 0xca9c50cd, 0x5fe35cb1, 0xbe1e462b, 0xfd1ea5aa, 0x34b5011e, 0x026bcbdb, 0xf3ed428d, 0xf351994d, 0x22d836b0 };
const u32 bern_num_data264[83] = { 0x0d2802c7, 0x77609172, 0xb6ad7cf6, 0xc5cb9019, 0xa07d578a, 0xd6e9c4ba, 0x9186ce50, 0x72d95107, 0xf5013f6d, 0xec1fbee2, 0x79a0a931, 0x53150613, 0xf0600651, 0x1358ff9b, 0xa0492bb5, 0x555239e3, 0x1a3b6990, 0x02da5355, 0xb8d80306, 0xc6d31d62, 0xaec9dfe2, 0x0dcd60ee, 0xa87d7e8f, 0x091f8389, 0x309764ab, 0xb941aab5, 0x774c35b0, 0x4091bceb, 0x43bc3a9f, 0x0e5f7be2, 0xa787466e, 0x68c25dad, 0xf543dd15, 0x7472bcf2, 0xf0ed2edf, 0xfc2e1892, 0x71f75bbf, 0xef08b319, 0xe64b3c9b, 0x6e4b4e36, 0x4442d42a, 0x00e7a020, 0xdaaf4aac, 0xa9cee026, 0xb9036c6f, 0xe286a0e0, 0x3cfa199e, 0x6c7801a0, 0xa83f04e2, 0x5af2912e, 0x949a003e, 0x275524b9, 0x3b58244b, 0x34151802, 0x48654c9c, 0x57407fd7, 0x4da76159, 0xc6a51d39, 0x9e6cf29a, 0x3ba92ebc, 0x3b978c48, 0x4ec12bc3, 0xcc50f4d1, 0x6314c886, 0xd1e47a5a, 0x3298da50, 0x714ce725, 0x2d281ed8, 0x254b38d4, 0x532348d3, 0x2a6ae5ce, 0x013cace5, 0xf84235f5, 0xaab2c9a9, 0x75933176, 0x303cabd7, 0x3f5fb611, 0xcffb99e7, 0x6439adbe, 0xadc64669, 0xe6f06b4d, 0xaa739217, 0x00464949 };
const u32 bern_num_data265[83] = { 0xb60165d5, 0xb9866c74, 0x134120e2, 0xfc2e1b20, 0x8d841b7e, 0x2353ac8b, 0x8b67e724, 0x88c62770, 0xb581967e, 0xef6e1ece, 0x64a90523, 0x4ee1c464, 0xa1fba908, 0x464fc7ee, 0xe6af6721, 0xbc496b79, 0x89e31a05, 0x45e92d86, 0x91a7dc86, 0xd70722c0, 0x1174e9e4, 0xbcc730b8, 0x77526bc2, 0x2a8303a9, 0x586de64d, 0xbd476785, 0xf746cb18, 0x2c6034eb, 0xb04446a2, 0xca130d13, 0x0662aa07, 0x73aebe9f, 0x02f71835, 0x88d17226, 0xc3bac085, 0x019896e0, 0x668e57c8, 0x54f4188f, 0x741360de, 0xd93a22d5, 0x41ec109f, 0x9a1b3c89, 0xce2c5973, 0x8dda01c4, 0x3d17211c, 0x18e71228, 0xaf7b8d02, 0x3d6fbca1, 0x47a22b9e, 0x5562323e, 0xecc45590, 0x6e1e1002, 0xcff8be80, 0x8620af6a, 0x0a8de4d4, 0xc6f2d205, 0xf1b11b14, 0xa7ea55f3, 0xd9bcdf67, 0x3873ff4c, 0xcb8243dc, 0x2effe34d, 0x5d1ddc92, 0xe0fa2411, 0xcf6d6d6f, 0x6526581d, 0x4b83cf28, 0x02271a65, 0x54151249, 0x3184607c, 0x7efd2cd2, 0x23e6d78a, 0xddce85bb, 0xd6fe6d1d, 0x2909a23e, 0x67e6dae8, 0x409e242b, 0xd5276c05, 0x370f47b0, 0x3605a7bc, 0x65e5e81d, 0xd1e73fd5, 0xf2079657 };
const u32 bern_num_data266[84] = { 0xe0a8b833, 0x9e090dc3, 0x64e9c9ea, 0x6db6aa8a, 0xe1676214, 0xd2e28592, 0x33b0f96c, 0xe13a9b4c, 0x5b06b700, 0x0a726f4a, 0xbda203b0, 0x27e8cd99, 0x077e035c, 0x0eff7046, 0x7cf37ea6, 0xee041c10, 0xc19dabf9, 0x11fda987, 0xe297ce87, 0x58b2d21f, 0x3d025b66, 0xb7a8ed06, 0xfa902c84, 0xb25d7c82, 0x4bbd009a, 0xfe7dad31, 0x2d1bef9b, 0xaf363663, 0x27b3c2a1, 0x4a36c5f1, 0xcabafd27, 0x35aa725b, 0x58fb4714, 0xa24d9653, 0xe48f9826, 0x0bd06887, 0xa2e33ce5, 0x963a08c3, 0xfd941211, 0x2ac3fb33, 0x83361972, 0x15b8d962, 0xfebb39b4, 0x5f924163, 0xad204711, 0x282a45fe, 0x54041c1a, 0x349f4a4b, 0x59275ef0, 0x7d5cc815, 0xdf191eac, 0x069cd602, 0x97080940, 0xabc8d732, 0x1a7b7119, 0x0b2451f9, 0xe88428c0, 0x264be722, 0xbb52b65c, 0xec996cf5, 0x4918b17c, 0x39b6a1d0, 0x302488e6, 0xfc92e70d, 0xd5ba1b4b, 0x96fd4182, 0x40cdfdd6, 0x91b5bc65, 0xe0d7651e, 0xf4baecca, 0xb41c742a, 0xe2e6e1a4, 0xa732adde, 0x0d822e0b, 0x1138caa8, 0x1d5f3cc4, 0x60fcb76b, 0xb75e6aab, 0x1d961e69, 0x176c7108, 0xa5f26e16, 0x5ac5060a, 0xb0aef3ed, 0x0000e614 };
const u32 bern_num_data267[84] = { 0xa10f552d, 0xebe591b5, 0x17770aba, 0x5b0efe7e, 0x9e9a1d22, 0x8e315e6f, 0xbb6b80f3, 0xe95af720, 0xe5fd7482, 0xcbfbd2c7, 0xd6e742b9, 0xa0c74f2c, 0x32665a22, 0x779752e4, 0xbb5c3572, 0xc0be936f, 0xedc9b5d9, 0x817ba185, 0xbaac826c, 0x5240970a, 0xa7fa49c5, 0x5013ed6e, 0xd3e942cd, 0x754ca4e0, 0x3ecf6baf, 0xa4311c44, 0x3c613239, 0x4b8e3f76, 0x9459fdb1, 0x9f2fa4b7, 0x921d917c, 0x1dd816ba, 0xf7badfa9, 0xeefe6f21, 0x1bf7883c, 0x49607b5d, 0x1e97d0fe, 0xf9ca1f45, 0xe479491a, 0x92a48ddb, 0x52cfde7b, 0x3e9184f8, 0x56562f66, 0x44f9fcac, 0xe97668e6, 0x4ac34664, 0x053e97bb, 0xfda89d12, 0x2b6e53de, 0x39000139, 0x08bc1505, 0x565aa8a7, 0x45b69ece, 0x4a39ab30, 0xac2f330e, 0x175bfa26, 0x131e1503, 0x452b9409, 0x56cd1971, 0x84602436, 0x7eb7f270, 0x36c851e5, 0xc1867fb5, 0x6a03cc63, 0x3ee904ac, 0x9dd6d0c8, 0xe44f3758, 0xb11b4e63, 0xe6e04f92, 0x703169ab, 0xae02098f, 0x767c89b8, 0xf0382d58, 0x3901f916, 0x0f458123, 0xeed9bdc4, 0x686526d2, 0x7e3bf6d9, 0x846a8876, 0x38f9b92f, 0xe3ced708, 0x6ef40f08, 0xd72bc4cf, 0x1b5f9e8b };
const u32 bern_num_data268[84] = { 0xc395ce8f, 0x33b0ec4d, 0xd7733ad0, 0x195b7a6b, 0x95dcde3d, 0xc00c07b1, 0xbcead304, 0xb78bca9d, 0x65e1da47, 0xbc3205aa, 0xf771a0df, 0x3e9983aa, 0x1b11ae4e, 0x6cff4007, 0x49a63664, 0x8b215099, 0x008bb661, 0xd7cbe458, 0xeab2680f, 0xed00fde8, 0x89aa5f65, 0x33387092, 0xdb3bbac5, 0x325b8ab2, 0x642f14aa, 0xa43ff839, 0x9c73969f, 0x33af7f94, 0xf2053746, 0xe1866ccd, 0x0fa6c657, 0x47afda81, 0x7db43169, 0x4c8f0552, 0x3921d0f6, 0x3ffe4751, 0xb433b32f, 0x32c97c49, 0xc90e7bfe, 0x8faac364, 0x3c2a8439, 0xf517c5a4, 0x40c471e4, 0x1a9436fd, 0x2407058c, 0xb2e677af, 0x36b41478, 0x304fb279, 0xec65e487, 0x47b3f493, 0xeefc4270, 0xd30dd7be, 0x9d331b30, 0x17b344ad, 0x481cbb73, 0x1b1acc88, 0x97188fe7, 0x530a56fd, 0x852b6f27, 0x24dea7a3, 0xf9c8dba5, 0x151e5258, 0xba905f12, 0x30751c65, 0xb55a6bc7, 0xdec933f7, 0x95909705, 0x89802784, 0x8a201339, 0x2594d828, 0xf3fe5a4a, 0x2ec561eb, 0x57827b42, 0x1badf392, 0x4bff38d9, 0x9d8398eb, 0x1d128def, 0x79c15e9e, 0x64832dcf, 0x599a5ea0, 0x90ae1fc3, 0x7fbfa453, 0xa9ee9a4a, 0x94f016d9 };
const u32 bern_num_data269[87] = { 0x40e1ada7, 0x9c6bf49e, 0xae91d520, 0x9b788ae3, 0x48e79cb8, 0xe646c44a, 0xcac6ecd2, 0xe4f1a506, 0xdcb6dc4a, 0x09ad6181, 0x6c5a026f, 0x89bc6528, 0xdbd8fc84, 0xafff1ddf, 0xd1b50c24, 0x7b0ce010, 0xc41000a7, 0x120ad3ab, 0xe9c1e23b, 0xd967e1f5, 0xd288be8e, 0x22c33287, 0xb3c994ef, 0x813b2b6a, 0xfc31397e, 0xe93922ef, 0xe4ac7610, 0x78a11d58, 0x9d47ec4b, 0xc417556b, 0xb78893e5, 0x4b543ffc, 0xb2f979dc, 0x0e6f26b2, 0x0c4edbda, 0xe6f6f575, 0x191cfa02, 0x10cc5bea, 0x94e71718, 0xad4c5d67, 0xf40aad2a, 0xf95c07e7, 0x8f89cdd8, 0x2fb0d4cf, 0x93341abc, 0x8e0cc2ad, 0x343be83e, 0x0fe8a73f, 0x12df627f, 0xe8863361, 0x82d8e7e4, 0x105343b0, 0x9a1e582b, 0xecef1c19, 0xbda7a1d6, 0x14c924c7, 0xd6706c44, 0x2089503c, 0xf535335a, 0xd2cc16dc, 0x0c883f83, 0x55551c04, 0x0f9c5b49, 0x6d39d44c, 0x3cae69ab, 0x4d676428, 0xd08b0964, 0xc770f4ce, 0xfa9f3268, 0x6082831f, 0xf3285f46, 0x00090880, 0xbf4d17a3, 0x0bd92b38, 0x10a9f62a, 0xf4ea6a9b, 0x848c6ddb, 0x702b400b, 0x6c653090, 0x5330ad1c, 0x3bdd4489, 0x75050383, 0xb10d3d3e, 0x7442d070, 0x17d20393, 0xf9effc3f, 0x0000117a };
const u32 bern_num_data270[85] = { 0x2cda2c67, 0x18cdbbac, 0xa346b9b3, 0x6122043f, 0x846239b8, 0x20aab49b, 0x2d2ebdbf, 0x82a1c926, 0xfdbd3961, 0xd8b113b7, 0x50042a47, 0x75919ad5, 0x6ab9ab22, 0xdbe4ba5c, 0x6306bad0, 0x7cfbc642, 0xeec6aeb0, 0xf2e9a0f7, 0xb6a2494d, 0xe3181a7b, 0x2e39639a, 0x8a3475c2, 0x98a1dfe4, 0x27c7ff84, 0x1cb6364e, 0xc591fbb8, 0xed76b400, 0x14e33167, 0x9c089cfc, 0xe165faf2, 0x565b9fdc, 0x34e45bfd, 0x6604903d, 0x28464375, 0xc80139d2, 0x71766991, 0x7626620f, 0xb95d8918, 0x9cc1f878, 0x186aa7ee, 0xe78d5858, 0x3ec3136e, 0xf41766a0, 0xd61e02f4, 0x2247d376, 0xd567a9c7, 0x949c5521, 0x94d8ca7c, 0x599b67da, 0xc407e5a9, 0x898c2d13, 0x938b93e2, 0xf0df80bc, 0xa1af0c65, 0xb9ca8df9, 0x8d590279, 0x4049be61, 0xc470cbc3, 0x54d9280f, 0xa9ab94c2, 0xbdc3f4f3, 0xd0c5b9ee, 0x8cc9dcf7, 0xa6a962cf, 0x6c20841b, 0xee020f34, 0xae061665, 0x31ca890a, 0x9e345713, 0x936bbd58, 0x42d4e229, 0x043fad9d, 0xfbd6de80, 0xfa21450f, 0x24bb0517, 0xf92db548, 0x766974fd, 0xd60d1189, 0xec8a6312, 0x745891d7, 0x1b15b64d, 0xf3f127a0, 0x81bf3dcc, 0x46a2e04d, 0x01e61f17 };
const u32 bern_num_data271[86] = { 0xb0cc63c9, 0xfde8e949, 0xec35f09b, 0xe9034bd6, 0xe9325372, 0x2eb60834, 0x30b40e50, 0x1cd2804b, 0xe396bcab, 0x4f6832a8, 0xa543f524, 0x3e855769, 0x6837a3c2, 0x520c6f5c, 0x3040385e, 0x0b1a5d94, 0x1b1259ac, 0x468cf147, 0xbd796aa4, 0xadd0aa6e, 0x9f172386, 0xf18dc6f9, 0x15f004f7, 0x71c70ca4, 0xf1a4f17a, 0x60106ac6, 0xd97aed8c, 0xff4bc592, 0x6638fd81, 0xcedafd59, 0x904f2700, 0xf81ce745, 0x8033c959, 0x7be057da, 0x02b2c32f, 0x3cd20120, 0xd3a331d1, 0x41543f01, 0x40486b5e, 0x4272547f, 0x6eeb2608, 0x7336f372, 0x97a444e9, 0x62b70d49, 0xfc101cc0, 0x8a352bf3, 0x5f39631f, 0x0abf397d, 0x56bf629f, 0x38360b6d, 0x4ad63adf, 0x1faf429a, 0xc0668124, 0x0fe86abc, 0xed951f64, 0xf2ea5730, 0xf3de9bc7, 0x2baea1b8, 0xa2828e38, 0xcf7406bb, 0x310c84b2, 0x5a4768b1, 0xc95535f0, 0x5d43d8a4, 0xcef21bb9, 0x2f81c126, 0x846e2f2b, 0xf394a386, 0xa17ee44a, 0x2077cacb, 0x1ed39f2b, 0xf9cf97eb, 0x1cffe858, 0xaf1a1833, 0x8eab4fed, 0xd52a00f8, 0xd3806324, 0x6ce72654, 0x1c8e14b8, 0x8c975a42, 0xe556de9c, 0xdd0eb835, 0xacec2151, 0x41ca2a9b, 0xaa4fd98a, 0x0009dca9 };
const u32 bern_num_data272[87] = { 0x72c225b7, 0x41a60bdd, 0xbd8b2f88, 0xabb860b9, 0x200e9e74, 0x65946566, 0x0c443cf8, 0xca02e1d7, 0xb6d9a1ac, 0x0ced57fd, 0x420de46d, 0x4724d349, 0xdb38cbed, 0x3e6583c9, 0x0034da26, 0xdcd88e9f, 0x3763d144, 0x282558de, 0xb44f6975, 0x59b0fe34, 0xaa659fe8, 0x86c7b18b, 0xb58464c5, 0x49260362, 0x71f3fc6a, 0x157d1cb3, 0x327d6699, 0xcdbd3917, 0xe6d96189, 0x742d6c9d, 0x5af38285, 0x06781bf0, 0x407a8bf3, 0xb6e44c05, 0x8c79f783, 0xf11893f4, 0x25b6088d, 0xf5610e9b, 0x0eb3b3e0, 0xc70444cc, 0xee94d025, 0x19eff27c, 0x07e97a90, 0x316fb8d7, 0xc16d54a7, 0x79cd8435, 0x0b8356b1, 0xdd4cda58, 0x865ca5f1, 0x0add5a87, 0x62195558, 0xd1221a54, 0xc6b8ba4d, 0x01b977f7, 0x4738687a, 0x2ac1d881, 0x0b3138a1, 0x822fa100, 0xde65b3ac, 0xd27740ce, 0x222deb71, 0x848ae944, 0xedd8475c, 0x76478c10, 0x4998097f, 0x6684efe2, 0x0c57936f, 0x3a04e46c, 0x665b97b0, 0x83116a09, 0x5dcdaeb5, 0x272e8bea, 0x474f97b6, 0x9e55575f, 0x3400fc7f, 0x48af3198, 0xae5487ef, 0xc826263e, 0xd6b93efe, 0x66812d00, 0x91325b79, 0xeae40162, 0x46d27813, 0xdd71917c, 0xd933bd0a, 0xef56c6eb, 0x000004f2 };
const u32 bern_num_data273[87] = { 0x35b91239, 0x1ceb17ed, 0xc6c3cd48, 0x81e9a92c, 0xf4c91a88, 0x4f143041, 0x3773dfe2, 0x12d8db39, 0x07dc476e, 0xf95cddb8, 0x76e87225, 0x302c43be, 0xd110a8cf, 0xb72a135e, 0x79da4d9a, 0xabb4f9b3, 0xe9ad9295, 0x130e3908, 0x44ec11d1, 0xa643a519, 0xecd9d20c, 0x0a645232, 0x9b59843d, 0x9a1ecf9b, 0xfaa3e5d2, 0x9a5ce16d, 0xdb238fb2, 0xdecd9e47, 0x1c3ced6d, 0xa9ac6991, 0x8921ea24, 0x163c9eda, 0x9948a9b7, 0x0a41de7f, 0xfed41ed2, 0x20b5b7f3, 0x167075e8, 0x314cc340, 0x19bbf6aa, 0x2453ebff, 0x2f4dffad, 0xddd05810, 0xc80781e3, 0x52be720b, 0x17342202, 0xb0168fde, 0xf4132474, 0xa61689b7, 0xf50a9e37, 0xe3ebc800, 0x6da88c88, 0x8cb31ea7, 0x6ebc1503, 0xa4cf7ae9, 0x4ebc776c, 0xbc30276e, 0x05369a18, 0x081c6b66, 0xb80323a8, 0x625c465c, 0x0c4479e8, 0xf4c00693, 0x55a53efa, 0xc247471c, 0x5bf90fe2, 0x366141a8, 0x0eee034f, 0x5c14280e, 0x935f879e, 0x014b869e, 0x403a9308, 0x1a814a25, 0xb811349f, 0xe61e726c, 0xa808f236, 0xe11ca0a9, 0xd276e302, 0xcb4dcf11, 0x814525ef, 0xb73a9bea, 0xb76e9231, 0x0d164e91, 0xb5a11232, 0xef6242f7, 0xc5d887c1, 0xb2a78e44, 0x00000003 };
const u32 bern_num_data274[87] = { 0x25334c3b, 0xea11136e, 0xfc1cc6fb, 0xdb7c3f2b, 0xe715e514, 0xd19c9394, 0x57111509, 0x0b3b7018, 0x2262b7cb, 0x337d7f30, 0x33fe76d9, 0x8d61cbae, 0x92f1db26, 0x5907993d, 0x34ff0847, 0x16374278, 0x8a768356, 0xd771dbf0, 0x7c3b7424, 0xa305f5f3, 0x49dc9d22, 0xcfa2ea4c, 0x9ee8960c, 0xae38c29b, 0xe9afeb67, 0xd2d884d3, 0xf1d8b6a3, 0x267dcf56, 0xb41020a0, 0xa75f49b6, 0x3fb29c0c, 0x0c6faccc, 0xbd8b8a2d, 0xebcc6c97, 0x62a8898d, 0xa5be16b7, 0x5414e322, 0xdec9e61d, 0x20686b34, 0x54ad9832, 0xe914de4c, 0xc7f62551, 0xd60796a7, 0x74bee5cc, 0x08988aa2, 0x1fca875e, 0x74c65c68, 0x1de60013, 0x2bc541fa, 0x14721237, 0xce8ebb50, 0x906adfb0, 0x670066ab, 0xd69d5c25, 0x771c233d, 0xe271a35d, 0xff71ac7a, 0x4357da1d, 0xd8207641, 0x6f44b794, 0xad48639c, 0x7298f562, 0x9b27bb43, 0x26215b3b, 0x763155cd, 0xf7b0f086, 0x96f6902d, 0x60583aeb, 0xa0887c21, 0x639ff9fe, 0x4d88782b, 0x972e5b41, 0x918ad68a, 0x1fc5b695, 0xbd1fe1dc, 0xe8d3917e, 0xff2856d7, 0x56c7e40f, 0x8c2c6f29, 0x7e084ce6, 0x2aac8778, 0x16564e91, 0x8435bb7c, 0x1fefe866, 0x108eca92, 0x4f7d766d, 0x0015d654 };
const u32 bern_num_data275[88] = { 0x42ce9c13, 0xd4eb245c, 0xeddbbfb2, 0x18d390f0, 0x93f30255, 0x2ec48ef4, 0x3d38e929, 0xb52ed8c7, 0xf78f7e67, 0xb0ad9587, 0xdd64707a, 0x6d077720, 0xb63cc0ae, 0xd5f9c2e2, 0x4ff26e05, 0x9e1529f1, 0xeadb0e8d, 0xf6ac86e3, 0x1547e65b, 0xabb6194e, 0xba069070, 0x2d6e427a, 0xaae0105e, 0x040da912, 0x1f02f78a, 0x15685894, 0x6c74a19a, 0x27e1891c, 0xbba0fa5c, 0x4e2ba3ac, 0xc80d2277, 0x5df965e2, 0x4e30ec42, 0x64b5fe42, 0x6cc7cf25, 0xfdff4aa6, 0xa4a2a494, 0x22821c06, 0x43a43f3b, 0xcca6fc61, 0x5fad12a5, 0xf16c36a5, 0x0c95a1c1, 0xd18099e2, 0x7d274e68, 0xa1efc282, 0x8cea28fa, 0xab2020d1, 0x5fac16f3, 0x53759002, 0xd490db0a, 0x6c670a48, 0x21753009, 0x4eee1f2a, 0x3ebacce4, 0x316c71bd, 0x680809a7, 0xd02ae435, 0xadfce17b, 0xdb798948, 0xf4156174, 0x266165ed, 0x1e7b2bb8, 0xdb1faf65, 0x639255e8, 0x835f1e20, 0x8369017a, 0x58ae2d87, 0x1ff76914, 0xfd86a2b6, 0x7fde1a33, 0x4079931e, 0x940f8c4d, 0x5fe782f7, 0x53eefd5a, 0x5e8f01ae, 0x420fabda, 0x94776c06, 0xb81da9f0, 0x222ec173, 0xd7478409, 0xce514ee4, 0xc2fa4b4b, 0xfe728f82, 0x3bb86adf, 0x4cf41b12, 0xf0c6eae9, 0x007f7b9c };
const u32 bern_num_data276[88] = { 0x86acdcef, 0x83ace471, 0xbf4f31c2, 0x44725f50, 0x501852f8, 0xd8180390, 0xcc276a8d, 0x03c1ed19, 0x7828624d, 0x0d5a5f89, 0x4b5c3d63, 0x00a8e6da, 0x6985ad94, 0xe9dc2707, 0x2f1c4f0f, 0xdf5d04a0, 0xa1799e06, 0xc2aae995, 0x9087149c, 0x34bd46a6, 0xe75ba133, 0x6623d39d, 0xce4b6eb5, 0x947f6ffa, 0x2091d605, 0x81869d74, 0xcdb758f1, 0x53e2b750, 0x725633ab, 0x9c98dc85, 0x4391fe16, 0xb746f96a, 0xd2fe4180, 0xc65122ed, 0x011a5f12, 0x0d4c0425, 0xc08cf1ef, 0x5d40f034, 0xd5d72b27, 0x12287df9, 0x96adaebf, 0x0ac7214d, 0xf5327500, 0xa415f24a, 0x448d00b9, 0x8176af53, 0xf9f2f18a, 0x664e803c, 0x6a17a596, 0x3c74dfc2, 0x05e25972, 0x05e0aebc, 0xc33af264, 0x8747d7d3, 0x4b5759e8, 0x297ce14d, 0x61762cb0, 0xe420032a, 0x9290a832, 0x857b4eee, 0x20886336, 0x2d52e532, 0x3baf355a, 0x269cccc5, 0x1be000c2, 0xe7528bf0, 0xee37a9c3, 0x7b84ea13, 0x4ad8b0e7, 0x8d282c01, 0xc8fc44ff, 0xd24757de, 0x3fec1a8b, 0xcdde3737, 0x63ef9936, 0xe9716d4b, 0xb6a38c51, 0xc55ecf01, 0x4b33d893, 0x52994a9f, 0x6d6a4d0c, 0xe38367df, 0x653afb77, 0xcd3f889d, 0x34bf7a8f, 0x06356366, 0xbdcbb8d2, 0x0000004e };
const u32 bern_num_data277[88] = { 0xb5282d55, 0xdc8d37fc, 0xbffbfb63, 0xd3931bb0, 0x6c5d0ed3, 0x838bf7d7, 0xbda06927, 0xf635c3c8, 0xf3778a48, 0x0fcc8eba, 0x2dc55a59, 0xc1e4665b, 0x3a12e1b1, 0x1ff58cc8, 0xf1a798c0, 0x4d9eb0ec, 0x6ea80909, 0xbcc915e8, 0x2687c478, 0x6b1b8722, 0xc0429ae6, 0x5470d21d, 0x9febf43f, 0x4629362f, 0x8d1da1e1, 0x38121077, 0x000dfd89, 0x3a8d21ec, 0x9d2d5e4a, 0xb841851d, 0xf91f45a7, 0x4ddb2ebe, 0xfe89db53, 0xb78ca046, 0xaf6eae29, 0x6e63dfef, 0x41d93861, 0xd23cd894, 0x9b6708e5, 0x0e194654, 0x3fe55d73, 0x84f20f76, 0xcf7b03fa, 0xf80f5e13, 0x03c5397c, 0x31d2cf20, 0xfdc90b4a, 0x9b0f14ce, 0xf4ddf7ca, 0xc0589984, 0x035f8fd8, 0x4780f6bf, 0xe8769cf0, 0x6944e8c4, 0x12f5392f, 0x5b8ead18, 0x5661c53a, 0x94f56ada, 0x135188d8, 0xfd8929ea, 0x5f61ed0b, 0x2353af47, 0x2f6d0523, 0xc48bc11b, 0xd9415f01, 0x66e32534, 0x49b425d8, 0xcf223bee, 0xbd02d558, 0x6b3f912e, 0x132cf06c, 0x6703c23e, 0xa6ffe70b, 0x72977e44, 0x20fc4101, 0x3e95f671, 0xeec68358, 0xecadda3c, 0xc953ec06, 0xba26b0af, 0xb6dd63b5, 0xec6c7a16, 0xe51cab3b, 0x26c4debc, 0x409afe9f, 0xf9da6094, 0x83377279, 0x662b1991 };
const u32 bern_num_data278[89] = { 0x0fef4b63, 0xeeea6ca7, 0xe44b25b0, 0xcc69f2ea, 0x3515254a, 0x213ffbc6, 0xed3b49c4, 0x86866708, 0x6576bf2c, 0xe23a77af, 0xa3dbbf9f, 0x05744513, 0x365f26e5, 0xe291d507, 0xeb63d964, 0x1dc491f7, 0x1cc1021d, 0x6417642b, 0x5496c419, 0x2f43273b, 0x7d0415c2, 0x01921ed4, 0x7b878ec2, 0xaa486a73, 0x420788a7, 0xaec0c777, 0xe2e513e0, 0x14c28553, 0xd73f85d5, 0xf4e0d4e1, 0x6a0753a8, 0xaebd09c9, 0xed7630c7, 0x0eb7d043, 0x033674ec, 0x8ebfb502, 0xe9125def, 0x2fa79186, 0x108a33ee, 0x0e53e83a, 0xe1329cff, 0xb08e580f, 0x4f34ad5f, 0xc9b0853e, 0x78212526, 0x60190ba5, 0x52a00ef8, 0x1f833556, 0x3aa3f5b9, 0xa030fc72, 0x96aef523, 0x22aabe77, 0xf7c88842, 0xf49e53f1, 0x6927fb88, 0x83998870, 0xd1cd76f4, 0x34984879, 0xdfd616c7, 0x87a42b0e, 0xa10f8f0a, 0x4e00adfe, 0xb7a542e3, 0x6c7a372b, 0x7504ed44, 0xc9c7b386, 0xebe2ee5a, 0x009c032e, 0x5ccd2394, 0x8210fe49, 0x4615256a, 0x171b65e6, 0x787b0fc8, 0x051824cd, 0x5ae8cff9, 0xc7e9960a, 0x2a0de9cc, 0x4f37115b, 0x264e9a88, 0x55cf4d64, 0x9e28560b, 0xeb206f31, 0x0a465cf5, 0x9c30325b, 0x231d7f7d, 0xec2882fa, 0xe371db51, 0x0c7eb5e5, 0x00000096 };
const u32 bern_num_data279[90] = { 0x0a0fa1c9, 0x8f40fe0d, 0xac7bc6b9, 0x4e410f08, 0x09781ac4, 0x5e105718, 0x652d2423, 0x24b2ec0a, 0xe0ca30aa, 0x81318cba, 0xb02f211c, 0x74ebbd3f, 0xc60a824a, 0x0c0954a7, 0x9e4c8984, 0x8ac18fbd, 0xed841d90, 0xd359a041, 0x5df12d53, 0xcf2554cc, 0x96ffedac, 0x355f9fcd, 0xb73983cd, 0xec21cb93, 0x830ba1b8, 0xe9b03f0b, 0xca0ab871, 0xe89ec501, 0x2ae4db8d, 0xd27997d2, 0x6c1f9d3d, 0x7b61a8e5, 0x7664f0d1, 0x65a15cd4, 0x26a856cd, 0x155253e9, 0x89e95a9f, 0xd6242c00, 0x0e6462c1, 0xb7d504db, 0x3480ae2f, 0x14473e35, 0xfdad2d56, 0xa98ed1ca, 0x52fc95da, 0x900912b8, 0x91eb780c, 0xaaa9a140, 0x725a968f, 0x315a5072, 0x8d4b3d43, 0xb7681ed2, 0x9e864c21, 0x54b1f7a9, 0x3dda0715, 0x7981b446, 0x044b0e23, 0x7524cd6b, 0x976d618e, 0x430f9c78, 0x82aba187, 0xee207922, 0xe2646dfc, 0x06e307e7, 0x48a82132, 0x71bd6c5b, 0xff5bebf2, 0x70ca7146, 0x26d71616, 0xe9879aee, 0xfdcb0dd5, 0x9f435274, 0xcc9e1380, 0x9f71ac09, 0x9cf96cd0, 0x81d42be2, 0xeeb2da59, 0x2e1f40d5, 0x48432186, 0x814e361a, 0x539f116b, 0x99d9a627, 0x4725a06e, 0x34ba3bdc, 0x6d6de695, 0x914cdd21, 0x2a5279ff, 0x2303897a, 0x331d9865, 0x004fa7e7 };
const u32 bern_num_data280[90] = { 0x633d252d, 0x4ad59fe7, 0xebad991c, 0x593458bc, 0xa4d5b656, 0xe3f92939, 0xec9f6827, 0xf6cd9c7b, 0xa7b0e67e, 0xe5950029, 0x3d722803, 0x6d44bc72, 0x291cb593, 0x8106f983, 0xf1d70565, 0xe00f750c, 0x05b5ff47, 0xa7e4a5cc, 0x2fe80fe9, 0x08495b53, 0x499b6360, 0x3002822e, 0xdf7fbe29, 0x563702d0, 0xcd2a28e1, 0x3174c1b4, 0x154fb9d8, 0xaee60c3e, 0xe76e0bd7, 0x5b2ab9eb, 0x40b1ee4a, 0xe345cf81, 0xf33415e9, 0xb9449559, 0x9d3064de, 0x0a24c1e9, 0x329adbd2, 0x382bdb89, 0x314ad5a4, 0x1be765cc, 0x98f6ff75, 0xa5a351ab, 0x2b1c8643, 0x718eb3b3, 0x7a04f1f7, 0xea2dd832, 0xdb28aefb, 0x17efad58, 0x70261107, 0x790ec7f2, 0x692f53ba, 0xefc06639, 0x85182efa, 0xc6771494, 0x107e0a99, 0x70560e0f, 0x78f7410e, 0xb5cec683, 0x83c7a138, 0xd4a24eac, 0x381eea68, 0x50b508bc, 0x7f49273c, 0xabff71d5, 0xd4ebab7b, 0x98dfc33a, 0x7952853e, 0xb8c6de11, 0x7868827f, 0xa986e533, 0x2c0c092f, 0x6e867e6e, 0x2be6fefb, 0x40952cab, 0x30a81521, 0x553460b9, 0x1fb095a1, 0x523d230f, 0xba2d66ce, 0x07419417, 0x47d32740, 0xabb98bbc, 0x47ea9252, 0xb2c10ec9, 0xcca8d7fe, 0x633b2c42, 0x8462cf5b, 0xa727e7df, 0x5d72560d, 0x00000009 };
const u32 bern_num_data281[90] = { 0x72b8ce31, 0x0767f930, 0x5134655e, 0x91d64e37, 0x7892fb7d, 0xb66650e9, 0xd0e2393b, 0x0fa9b1b8, 0x267aca11, 0x38f4eac8, 0xcc09d05b, 0x0289ce68, 0x2a602283, 0x34c7b671, 0xb2c034f9, 0xc8945760, 0x45844f4b, 0xcea0eaa4, 0xada57f75, 0x2be808e2, 0x196622ec, 0xf88399e2, 0xaa0644cf, 0x4c262b57, 0x785a16ca, 0x77dc2edc, 0x4d044e5a, 0xd5807c56, 0x93aa567e, 0x7943f642, 0x695ca784, 0x8bf7cea3, 0xe5501c5e, 0x72f04ec3, 0x0f8d2e4d, 0x45b59ed1, 0x398a6803, 0x44576910, 0xa85bc82f, 0xbf5cb44d, 0x1c97e15f, 0x9cd25b73, 0x4bd3f3d4, 0x992379b1, 0xb845ab54, 0x45f46c91, 0x87825289, 0x76aab161, 0x6d5295be, 0xc9d9a2fb, 0xe0222eaf, 0xe1a65b15, 0xa95203a1, 0x2b52dadb, 0xe5ae2d90, 0xf8e01256, 0xeb5fc1bd, 0x57675f9a, 0xfe77b3c0, 0x8141d653, 0x63775b2e, 0x10e20f9b, 0xce6d6895, 0x2f180305, 0x5340cce1, 0xbdd173cb, 0xa60ce15b, 0x51583adb, 0x4f48fe57, 0xc133c13f, 0x66b93152, 0x8ec095e0, 0xe950b7a4, 0xac52ba4c, 0x39b1c7e0, 0x939e4c7b, 0xa6c35453, 0x2346c180, 0xe0f188bf, 0x69c0d7de, 0xd51341f0, 0x51b8605f, 0x9b4790cc, 0xfc567931, 0xba9fccf3, 0x54e4e246, 0x9787ee89, 0x910e6da4, 0x9be958d3, 0x0106df87 };
const u32 bern_num_data282[90] = { 0xcac91ff7, 0x6b318eae, 0x0aa96dad, 0x6037935b, 0x9960a94e, 0x8109d765, 0xd4d23cbc, 0x1f4d46a8, 0x0c33a77d, 0xe9c7414b, 0xf655c16d, 0xd1c27bbf, 0xec55dc6b, 0x4767389d, 0xadc9c265, 0xe0065597, 0x2cbcf375, 0x4324a75f, 0x9c10c9e6, 0xd0ddf62b, 0x8f2773d8, 0x51e65621, 0x1188755d, 0x4b17e315, 0x053ad4c6, 0x79965069, 0x07036f7c, 0x1bf5fab0, 0x88d5ec2e, 0x0b8b724d, 0x8910a6e7, 0xe8787865, 0x2bb22bae, 0xcb87f54b, 0x51204b01, 0xfdd81e41, 0x0bdb1778, 0x0cd9c7ce, 0x002be9bd, 0xecf3deb3, 0x0f5fe579, 0x96401e0c, 0x864bed74, 0xebda5d5c, 0x780e4f57, 0x37c991ed, 0x7921a68d, 0x5d6e7aa5, 0x0191a7b4, 0xe29929f4, 0xf3a07b67, 0xe192f9a4, 0x94a35503, 0xa7f51565, 0xce878ad9, 0x31357b7b, 0x196806ff, 0xadcdea89, 0x5a16ab42, 0xe3c1fd54, 0xe166c85a, 0xb2dd5be7, 0x1578d967, 0xd285dc31, 0xc55d2c69, 0xeb69c075, 0xd93dd893, 0xbe51893f, 0xc8ad8dc4, 0x5a860c91, 0xef41626e, 0xc62702d4, 0x86f870d4, 0x82b19f92, 0xb8597293, 0x07906851, 0xa11c17c0, 0x82a38406, 0x9c57a397, 0xfbf14bcd, 0x3e4ee3d3, 0xdc48de61, 0xe750c9c8, 0x91c623fe, 0x33c54919, 0x2221d34b, 0xcb8b326a, 0x66cbdc25, 0xeeb9b9c3, 0x00108970 };
const u32 bern_num_data283[91] = { 0x436e7a19, 0x547f19c4, 0x913819d1, 0xe42be062, 0xd4886902, 0x3e248fdc, 0x207abb00, 0x13294beb, 0xa70ad385, 0xaf0b77cd, 0xdf402442, 0x57583bb8, 0xced997e3, 0x9909bd20, 0x45271e89, 0x5ab3b65a, 0x0f8e6e7c, 0x1933f9f4, 0x3595f725, 0x607718b0, 0xd7ba237a, 0xc48ad388, 0x3ce05b2f, 0xb7bb0696, 0x9d4ec0df, 0xb85e78c6, 0x8913454a, 0x13792761, 0xe440d2ac, 0x6cc5487c, 0x07a9a4c7, 0x8f022aa2, 0x9e263f60, 0x19a0bdc9, 0xd2a7e67a, 0x5b3ccf20, 0x6e5ea1d0, 0x404ec92c, 0x0ccd2138, 0x91be8fe3, 0xbf7f8699, 0xdd9bf4e2, 0x635d7eb6, 0x032ab211, 0x51f2119d, 0x99223f1d, 0xb60c9a20, 0x50cbf853, 0x931e55a9, 0x4829b82f, 0x39ce93d8, 0xed52a015, 0xb26836dc, 0xfc572482, 0x697a3d20, 0x3d2374bb, 0x4e016b59, 0x7573be49, 0x3f0e4ab6, 0xa0a4ec86, 0xcc469448, 0x021446c7, 0x69d196ac, 0xecb5e461, 0xea2383a4, 0xc0dc2a02, 0x3d536882, 0x2e0d90ec, 0x779e1074, 0xaa0397f4, 0x7abbcd7e, 0xe363ab7e, 0xeeda4834, 0x95811fa9, 0x3b5a1a9d, 0x80182970, 0x1cfb703a, 0x3aaaa6d0, 0x17c2b6ab, 0x2db996f2, 0xe0a14f34, 0xc69851af, 0x71d97de5, 0x776e4e4d, 0x120898bc, 0x90efb99b, 0x9d03dcde, 0x8614efca, 0x4907ab07, 0x5b723300, 0x000016e0 };
const u32 bern_num_data284[92] = { 0x300fb211, 0x6797e8c3, 0x9707485a, 0xd53322b9, 0xd2210e4d, 0x5571d485, 0x88817a92, 0x4b6d8cff, 0xca90f7ae, 0x02209a86, 0x718b5b88, 0x8869d48a, 0x1d52d739, 0x5b79ffaf, 0x11690424, 0xc8d4344c, 0xa0a87712, 0x2c8704cd, 0xad49e384, 0x22d05f3e, 0x319f8d89, 0x6d5fe9a7, 0x86c09ae3, 0xa730d6fa, 0xab6bede3, 0x7e7e3a06, 0xd9ee0b81, 0x890b2397, 0xbdee4f85, 0x2704533c, 0x23ac2fcd, 0xf23d9899, 0xf9ff7057, 0x0cc968b0, 0x773961f4, 0x030d14a1, 0xfce8d5ab, 0x2cf15d30, 0x47b8060d, 0x950c2a78, 0xb63a05bb, 0x39a85efa, 0x1f18e2e6, 0x11ed7a9a, 0x782f9179, 0x3e323c85, 0x02208341, 0x740d738f, 0x55b30c0a, 0x69d84233, 0x27c3c27f, 0x2f83e939, 0x1738e089, 0xe420d10e, 0x5bcc0512, 0x1ef4a4cf, 0x938756ad, 0xcd4b42cf, 0xe09d140e, 0x41b278ee, 0xc13b00d9, 0xbca982f4, 0x698960d7, 0x05c5b304, 0xd23c5376, 0x9eb34346, 0xaa8372d8, 0x49373166, 0x1a8a880b, 0xac3c1b58, 0xbda616cd, 0xc2dc1cb4, 0xead8931e, 0x3befccd9, 0x1e16f924, 0xa644d3aa, 0x9efa9157, 0xa23042e5, 0x09c307f9, 0xc871bbf8, 0xc090e166, 0xd1592f9f, 0x4616b126, 0x411c77f4, 0x11fe2587, 0x1bd3bf93, 0x830b80d7, 0x8ee5cfaa, 0xdff0b32f, 0xc82ca346, 0x068ce704, 0x00000401 };
const u32 bern_num_data285[92] = { 0x0f47b27b, 0x41764db1, 0xeddf95ce, 0x6a318015, 0x89c6fcec, 0x91f76e9d, 0x841bce05, 0x282a70cf, 0x2c1699a7, 0xef282aec, 0x113d112e, 0x34d9d521, 0xde331d81, 0x3243f853, 0xf7de472a, 0x8f4fa266, 0xb900166b, 0x3f6480e8, 0x4b986cae, 0x2c20d0fa, 0x597bbffa, 0xe5b48388, 0x8e052420, 0xbe5c4552, 0x23917d4f, 0x45d67819, 0x9c228661, 0x3593275b, 0x2f5a04e9, 0xdf9f63fd, 0x4805797c, 0x7ae46496, 0x9e3e1528, 0xfdc2c1f5, 0x14a4d767, 0x1c8bd4d1, 0xcf835d51, 0xc56f7e94, 0x25ef9a64, 0x8ee48da5, 0x71dfc142, 0x2b5eec81, 0x984ae42c, 0x83c4155e, 0x983506a7, 0x633073ae, 0xc22f0570, 0x56808340, 0xdd2bf70c, 0x66bd09e6, 0x9f8a7708, 0x1aab638c, 0xd9aad355, 0xb9d21553, 0x89ae0c22, 0x487878d4, 0xe29a48a4, 0xae7c329b, 0x85dbc20a, 0xd1aac25d, 0x0caf4cd0, 0x4ef222d9, 0x849c4ba9, 0x13262b1e, 0x8dd8961d, 0x02ec0652, 0x94a9dcd0, 0x5562bf87, 0xa25d168c, 0xa0674a6b, 0xabc9b679, 0x505d132f, 0x9039649b, 0x9b79c601, 0x579aa063, 0x8a5945fc, 0x557e68a0, 0x0d1813c3, 0xfc8d5e5e, 0xefc031de, 0x2f3251bd, 0x0927b5e8, 0x4fd62bf1, 0xa8c169a0, 0x789ec1b2, 0x0baada4f, 0x8220b269, 0x925c85cc, 0x49110013, 0xbbb09ca3, 0x8b84287d, 0x000000c6 };
const u32 bern_num_data286[92] = { 0xb4e14ba5, 0x454b08c8, 0xff87a4c7, 0x137d0c3e, 0xd8a3fba1, 0x1e7c92f6, 0xc9227a58, 0x141d6db4, 0xdeb7272d, 0x31b6644a, 0xe54e43e1, 0x1de8be2e, 0x1019e48f, 0x34eff02f, 0x5a3aacd8, 0xa34d2757, 0x4c3e7b4c, 0x08f8faa8, 0x7c899d48, 0x095c9e66, 0xe563815a, 0x3da70b46, 0xfbe0d74a, 0x2b741a8c, 0xd01200bc, 0x0357463d, 0x0b1c679c, 0xd445ba12, 0xcf952930, 0xcca535a6, 0x69c13670, 0x7e893002, 0x9bf31f84, 0x73a60631, 0x0db888e2, 0x61f0177a, 0x595fee94, 0x54d3508a, 0xdd7aa374, 0x6734ed4b, 0x805d57ff, 0xcfd181da, 0xcedbd2d3, 0xbe582657, 0x6af932ca, 0xc8c6e37f, 0x28cd0d08, 0xc025c297, 0xdad0153e, 0xf7070f93, 0x0a1ca34d, 0x14bc5683, 0x3d84e406, 0xd71099dc, 0xe2974d72, 0x01a31819, 0x9f48366a, 0x497c298b, 0xfbc45c13, 0x385a62a1, 0xb0e9a092, 0x7b91ee40, 0xe4ab2b6c, 0x868635b8, 0x79e23bb3, 0x588ffa5b, 0xa4bf217e, 0x6c7a02f4, 0xe3bc4ffa, 0x0b5e77d4, 0xf6f17fbd, 0x5d9b922c, 0x7f810448, 0xb4603d6e, 0x5217e91e, 0xac8f9498, 0x1871060c, 0xb37a0984, 0x7d530ddc, 0x73d4a85f, 0x9fc4a532, 0x5db10a14, 0x296fecce, 0xb3f75a25, 0x910f7297, 0xaa54e309, 0xb8698823, 0xafe7bbd7, 0x4d6566c0, 0x4c66fb08, 0x46252875, 0x000057fd };
const u32 bern_num_data287[94] = { 0x398d2fad, 0x8308f860, 0xed3bf4e8, 0x0b07a778, 0x8cd8cdef, 0x498681df, 0x19a84d71, 0x73c41896, 0xbf0021e3, 0x55f2c85e, 0xd3ce5b25, 0x25abf5e4, 0x658e4dae, 0x6a7eda5a, 0x0410b310, 0x6f7d5aa8, 0xf9b11961, 0x0ca0364f, 0x34e4fba9, 0xa51382ec, 0x4d999051, 0x720d0841, 0x5612142a, 0xc16c9898, 0x513ae604, 0x49fcc6c2, 0xd55d687b, 0x39940fc3, 0x55822081, 0xf36dd6c3, 0xdce8ae64, 0x01ff0221, 0xff12319d, 0xb17a1b30, 0x95c949c9, 0x4f6b39d2, 0xb26eaa34, 0xaf27dcbc, 0xf03493ca, 0x6c20f03c, 0xb59b9940, 0x228f6306, 0xd6c3fc5f, 0x8fb0d31e, 0x02208abe, 0xba03038c, 0x4df8d588, 0x88f84580, 0xf26beae7, 0xb7182f23, 0x044380bb, 0xef27d239, 0x699ce88f, 0x8a426ece, 0x875563d5, 0xdb940ba5, 0x19793251, 0xd2ee9475, 0xb52d7d9b, 0xc3a960ff, 0xbb4cf664, 0x55b59981, 0x0c564c42, 0x83356f8d, 0x8880f864, 0x71544387, 0x71637bfe, 0x71f942a9, 0xc66f4bc3, 0xf3af0f20, 0x0d2d04c5, 0x869049ed, 0x3e3d4920, 0x2145fa11, 0x7d935afc, 0x7ed24279, 0x40544997, 0xc100a0f5, 0x4fd6cd6f, 0xf3434893, 0xcc8f11b5, 0xdcbf7e1f, 0x23b1a8eb, 0x6448c6f3, 0x30d4f5fe, 0x5fab364e, 0x82020259, 0xbea85d64, 0xa1382d7c, 0x814c0e42, 0xce48ca64, 0xa3b18d7f, 0x3b6e2899, 0x00000211 };
const u32 bern_num_data288[93] = { 0x9bfa057f, 0x47a401aa, 0xdb9f74ac, 0x5d5f6d8e, 0xee6719f4, 0x795b0542, 0xcca1cad5, 0xe4fc8d2d, 0xbeff74a7, 0x2b2b6671, 0xfde42e0e, 0x609432ac, 0x304ad264, 0x88de2338, 0x181d8e41, 0x89f29dc0, 0x41cd7a8c, 0x9c664a9f, 0xf0495b7b, 0xcfbb6fdc, 0xfc7057c5, 0x77415c3d, 0x10bcd3ae, 0xf5ab34f1, 0x5eca4ed4, 0xa1c41df6, 0x5e6f0524, 0xc587aaad, 0x9d7b02b8, 0xd3f4fcf9, 0xf9ffa39a, 0x61a2999e, 0x062a4425, 0x7f70e734, 0xd57d29a2, 0x0359d039, 0x6add32f3, 0x4a936067, 0xefaa5206, 0x9cddfd9f, 0xdc34928f, 0xdd16bb60, 0xda0b60d2, 0xcec906d4, 0xef7d67c1, 0x99ab8a3c, 0xb952effd, 0xcdcdc90a, 0x2c689de7, 0x97da7b83, 0x363711bd, 0xe24821c6, 0xd8f77b79, 0xb62dd66f, 0x21ccc6c3, 0x993c2e3a, 0x80cf2aec, 0x21606811, 0x1e07a8f9, 0x09520509, 0x1e063b1f, 0x98f3e510, 0xb78d0098, 0xdb7adec1, 0x862a681c, 0x9100a13d, 0x29b6e513, 0x29f3a0af, 0x117d6eea, 0x3c396d94, 0xe11aaf03, 0xf4b60257, 0xca40eaf0, 0x1c108ce9, 0xd30a01c0, 0xa15a1114, 0x0eb1d65a, 0x68f66078, 0x860fc8de, 0xd4035017, 0xbfcbfe5e, 0xfa66b4b1, 0xeb7507ea, 0x00ba8eb9, 0x38ee7e3b, 0xc24b4a14, 0x95a06534, 0x7527dd83, 0x68e5a35c, 0x3fb2df35, 0x72f8047d, 0x7a6d7190, 0x00000004 };
const u32 bern_num_data289[93] = { 0x105852c1, 0x0549b25d, 0x04e3c37a, 0x6625de51, 0x9538b4fb, 0x3bd395f0, 0x895b4f97, 0x786bd617, 0x4b7311e9, 0xa89b05bf, 0x45747911, 0x66d915f6, 0x5aee2729, 0xade3dea0, 0xc571eed0, 0xb4f6fbbf, 0xca2b6f88, 0xac88c339, 0x349ae91f, 0x30a18c05, 0x3148b41b, 0x81abf9dd, 0x9c48cf00, 0x72fa9004, 0xa02e36b0, 0x558f3443, 0x99f6f399, 0x44a19dae, 0x84b10d3c, 0xba21a9a0, 0x4093e8e7, 0x205bf3e9, 0x7e930bf0, 0xdb651a76, 0xabe7da45, 0x25425800, 0x0a63510b, 0x018c8feb, 0xa638ff7c, 0x11c9508c, 0x0a864563, 0x68d17877, 0x154d550b, 0x07ea0459, 0x5fe106d8, 0x0f80536a, 0x78bf851a, 0x5a6f8072, 0x6242c18b, 0xacb89023, 0xa547c2a7, 0xac86d22f, 0xf3d72794, 0xf428584b, 0x46600c0d, 0x8fcd660f, 0x21eed9f9, 0x98a01ab2, 0xf6bb204b, 0xf26a72c8, 0xa4c32d52, 0x81cfc9df, 0x4c9c0e83, 0x3731f9ad, 0x13973026, 0x3c634c07, 0x3853bd4e, 0x3ae987a1, 0xf7844434, 0x49754af9, 0x0b5671a9, 0x4908c0a0, 0xb7d43eb3, 0xb353fce1, 0x70a7143e, 0x366bfe02, 0x5238fc32, 0x4b8071e2, 0x908ea5e9, 0x2d4b69e1, 0x1ffaa12f, 0x7dc114b1, 0x9b54bf5e, 0xf4eeab16, 0x1092c0bb, 0x00a3cbc1, 0xc5c235f2, 0x767a82dc, 0xcdfe5315, 0x2f8eeb69, 0x730122e0, 0x77ea90b8, 0x075e33bd };
const u32 bern_num_data290[93] = { 0x855abe61, 0x16336ca6, 0x3e2f34c5, 0x89065a39, 0x7d7b9486, 0xd16ca4d5, 0xf0cb1209, 0x820311bf, 0xe7aa5f7a, 0xc84afd02, 0x5bbc1c90, 0xdfa4a11e, 0x0028fe14, 0x40fc39df, 0x4c32c25f, 0xe985eae2, 0xb882052e, 0xce732926, 0xeed4eada, 0x19abff5f, 0xb87ef834, 0xa69a7797, 0x2fad6004, 0xa99f87ad, 0x43e45ff1, 0x92c50765, 0x1cbe6cc7, 0x4fe56980, 0xdfaa6359, 0xb2f23d4e, 0x4a3922bd, 0x7d1f7999, 0x41fa5bae, 0x701c2f23, 0x6e2ce6d6, 0xfa15055f, 0x13f990a4, 0xb4b39e4a, 0x881cf160, 0x914a96a5, 0x2a39595b, 0x91d4e60d, 0xbc6c9f04, 0x08b208e4, 0x035e711f, 0xedc6e7c1, 0xb2544adb, 0x2dc00877, 0xb5f45a08, 0x7f7ade63, 0x5e8e6335, 0x202da3f2, 0x9a3a2956, 0x560cf8a4, 0xb8c94265, 0x0a0fc162, 0x83e2a82e, 0xd36d52a0, 0x95088f52, 0xdf4f9790, 0x823b41e2, 0x89557702, 0x11a95fc7, 0x6bf26328, 0xf187222e, 0xed5b92a9, 0xb4c83a01, 0x031cbfac, 0x438b063f, 0xa5e16bc0, 0x739c6dff, 0x3c4a735c, 0xd1c6e5d7, 0xcd680cce, 0xac97736a, 0x401836ec, 0x1a7c4021, 0x1785d258, 0x1e39eb3e, 0x996b09ae, 0x6051fbeb, 0x0bf6f777, 0xebc19276, 0x8a9d18c3, 0xe24030c9, 0x771f5e7c, 0x147f563f, 0xde2b2ddb, 0xc4d18d2a, 0xb13f597e, 0x8cc14c08, 0x7dda571a, 0x8822a7b1 };
const u32 bern_num_data291[94] = { 0x0598b925, 0x80f4cec8, 0x24c997c8, 0x19c529c2, 0x30c580b8, 0xf14df43c, 0xbcf0058c, 0xc922cd0c, 0x3af1f101, 0x54c73630, 0x50515fdc, 0x9ab16989, 0x60129986, 0xb2de6a0f, 0xb65a03a2, 0x934b8827, 0xee637c8c, 0xc1928e73, 0xbcb3bfbe, 0x4bcf84f1, 0xd2aae69b, 0x96a12c50, 0x36de47c0, 0xf2687f17, 0x73b184df, 0x26b990f4, 0xe0364b26, 0xe753561d, 0xb1587d04, 0xff80d8be, 0x4ffe04fe, 0xf7b3aa57, 0x0c0ed362, 0x39f7287c, 0xc5b2a2be, 0xb79e96cb, 0xeca49b3c, 0x104b1381, 0xe3796d7a, 0x73a79d20, 0x2bbb174c, 0x7249fa88, 0x822e6909, 0xa5261f62, 0x1bdcc86d, 0x6d76ee45, 0x490a2cc7, 0xbff5e92f, 0x961b9d91, 0x2b06e4f5, 0xd4fd4c09, 0xf3872b47, 0xe5e202a8, 0x1164f8c4, 0x365eb909, 0xefa0ace7, 0x75a7a450, 0x69897ca5, 0xf26c45b1, 0x599fe935, 0xd173929e, 0x88a31745, 0x35b5c181, 0x3f53a39f, 0xa3b44d93, 0x6ec1ccd1, 0x2e1072f2, 0x767124e7, 0xcdfec039, 0x1c9ca07b, 0x18dd1856, 0xcb23be17, 0x1136936b, 0xb7114331, 0xaf92c195, 0xbd7d65ce, 0xba9ecb85, 0x922b2ddd, 0x560e13ce, 0x4341e6fe, 0x9c306bd0, 0x611587fa, 0x17c44125, 0x094852bd, 0x695cf0c7, 0x63b0f419, 0x1f1ed996, 0xba2381d0, 0x74d6660f, 0x3d22fad9, 0xd70bd25e, 0xee18e191, 0x75335afb, 0x000ea551 };
const u32 bern_num_data292[94] = { 0xbd116c45, 0x82ce9b5c, 0x9922b951, 0xcfd726a3, 0xc73d285e, 0x4a49c77e, 0xb4197ff2, 0x4a566c1a, 0x893bb10e, 0xde61afb2, 0x9f74b381, 0xd6ee60d8, 0x13e1669e, 0xb44c742e, 0xe5c92b0f, 0xb3792bdd, 0xf971f01b, 0xc91b6ad1, 0x5ff217fe, 0x92d2157d, 0x2a2df3c3, 0x4e1c56a4, 0x70357b7a, 0xff595e3c, 0x0867b2dd, 0xc71c5e2c, 0xf8e88adb, 0x1cf62f23, 0x6c67765e, 0xca96889d, 0x053f3459, 0x3c7b6cd3, 0x6f466559, 0x64080c5b, 0x27235bbb, 0x24ee0b1e, 0x72d236f3, 0xf5948d94, 0x9a8a2989, 0x77246d09, 0x76d60382, 0xc036e2f4, 0x07e1ead3, 0xcba520ab, 0x04405366, 0x0cdac51a, 0x488a2ab5, 0xb4bc1eb3, 0x7ac6e910, 0xf0f97470, 0x929b4e5d, 0x15c72469, 0x7e29f79c, 0xb6308e10, 0x70908e7a, 0xecd17951, 0x00178578, 0xf748d665, 0x3783c853, 0x086b2254, 0x6ac426c0, 0x28ce594e, 0x89757063, 0xbdc16ddd, 0x8ddae2a7, 0x48a3d05d, 0x386b7ebd, 0x28199ed3, 0xd0b05cbb, 0xc8114aec, 0xc4091424, 0xc136f838, 0x3459e23c, 0xb55887f1, 0x51d3fa61, 0x756af47f, 0x29faf75f, 0xd5f57152, 0x1b1d4a7e, 0xfc074c2c, 0x5e95968c, 0x3a8514c6, 0xb1e6682d, 0x7b127d6a, 0x18236ebb, 0xfa957ca7, 0x00a27d29, 0x04114079, 0x5a358daa, 0xeedb0ba0, 0xf725d553, 0x13eb539c, 0x5ae1746c, 0xc70d513a };
const u32 bern_num_data293[95] = { 0x48a243e1, 0x37312e81, 0xd8e78596, 0x63d8c866, 0x0f6958a2, 0xe31cab9a, 0x413fcc4b, 0x6e31b5c5, 0x07e8074d, 0x4e0a6a63, 0x0c247b74, 0xe4518de2, 0x2caa7f61, 0x6632a296, 0x75ef96bf, 0xbb95dacb, 0xca1ba26d, 0x66683a55, 0x1111cce2, 0xa1651074, 0x874c266c, 0xef817638, 0xf7cc9c1f, 0x7a833693, 0xe9d122ba, 0x2b787ac1, 0xc68c72d2, 0xf695a5b0, 0xe69ccbb1, 0x8b0588c4, 0xd832cb88, 0x4d5f0754, 0xf1a7e161, 0x557e8806, 0x23d5a9b0, 0x831f1ed4, 0xc7be18b6, 0xf319286f, 0xcfcf2529, 0x3d186e74, 0x689cff17, 0x2ec9fc69, 0xf2a29059, 0xef4765d7, 0x5216da08, 0xc32bc5cc, 0x82534641, 0x797a4c2e, 0x8baeef4c, 0xb96bc5a2, 0xf886bec3, 0xf83b4df5, 0x76bc5972, 0x0aa4b086, 0x7ac91fcf, 0xc0934c5d, 0xe2315784, 0x232a39ff, 0xa799605e, 0x7505a7d8, 0x44759b7b, 0x8d863ac8, 0x6b06e16f, 0xe2f6aa77, 0x995fcf78, 0x565ee2ef, 0xe77de87c, 0x01bfce87, 0x48267c60, 0xd3d8e6bf, 0xc4cecc76, 0xd1ae3286, 0xb0565de1, 0x567478ae, 0xc27906d0, 0xad0f8314, 0x30ec5c48, 0x917058ad, 0x95375461, 0xed34fe0d, 0x4ac15881, 0xcd4a0828, 0x4f6cc7a0, 0x86e87ed9, 0xea1668b1, 0x81ecfd91, 0xa1906785, 0xfbbc1e91, 0x95e986c5, 0xcb8a9d03, 0x2ce8b8c2, 0xbb17c8c9, 0xea5f3cf0, 0x33341761, 0x4d27e05f };
const u32 bern_num_data294[95] = { 0x30f144cd, 0xa8e5d506, 0x1919f79a, 0xd364c420, 0x789c10eb, 0x0cb04ba4, 0x1a276605, 0xe9cd990b, 0xf8a26786, 0x4f2f9fbb, 0xe58ab079, 0x555c6bf6, 0x439516da, 0x85b2ec1e, 0x09c4f752, 0x08ed9919, 0x43c3d9c0, 0xd847f375, 0x50319cba, 0x0a164e59, 0x1600525b, 0x8af4e997, 0x0dbd90a6, 0x23794cc9, 0xaa1f733a, 0xbb5e97b5, 0x8482ddb9, 0xc694ac61, 0x112e7419, 0x3aed4e69, 0x9b445746, 0xde58f192, 0x3071ab65, 0xed89c475, 0xccfa47e8, 0xcfeb86fd, 0xe8dee3f8, 0x744a0022, 0xba720647, 0xfefc5608, 0x76898bb8, 0x4c65f8a0, 0x942ca287, 0xc305dbda, 0x28cec164, 0x1df3240f, 0x086d2104, 0x3a5991b4, 0xadffdb6d, 0xb2eb3eb3, 0xd8d2e8f0, 0xbb029b8c, 0x144d2f3b, 0x9e2762d3, 0x111425cc, 0x68382b86, 0x568ba3b3, 0x466d143b, 0x2902044e, 0x98ac6830, 0xfeba1b4f, 0xed98b4b8, 0xf3e6c976, 0x16ef8096, 0x236f25bf, 0x85021ed4, 0x2b91ca60, 0xd38a573c, 0xc54b25e4, 0xc8314e0a, 0x9485cb82, 0x92377cf6, 0x0e60f991, 0x3d380e18, 0x42be0968, 0xfc18fafd, 0xfaf05e38, 0x7ec07d76, 0x479c2c0b, 0x3b333976, 0x3fd6bcf2, 0x2900526d, 0xe5bb807f, 0x50af2233, 0x6ac0cb21, 0x201f75ff, 0x885244de, 0x697d91ac, 0xd1816813, 0x23c4e10c, 0x1eb62394, 0x19ce6234, 0xcc2ab354, 0x798c28db, 0x00111c4e };
const u32 bern_num_data295[96] = { 0x81322645, 0xd2e82513, 0x3fe809db, 0xa36a3018, 0xeed8080f, 0xea121e17, 0xa61879da, 0x53b52992, 0x5a347eca, 0x182919ad, 0xc761fda7, 0xf9ddbf86, 0xc7801729, 0xb8c57062, 0xc49bcc6c, 0xe2bd3996, 0x48b836a6, 0xb7a9a661, 0xaa16b5c0, 0x33024466, 0x04460694, 0x264f5ebd, 0x6eae1c58, 0xec146a0a, 0xbfe5df09, 0x92533e8d, 0x75862577, 0x05dfc89f, 0x92a78fa7, 0xf32565ae, 0x25e526ac, 0xd73daa7c, 0x406d472f, 0xd8423ea0, 0x5c911ded, 0x048bdceb, 0x33c7984b, 0xd1dc20ff, 0x1c160ea9, 0xfae2a123, 0xf0ee823e, 0x87f658b5, 0xe5b08dff, 0x0551d8d1, 0x86c2e6df, 0x88a287e8, 0xf7877fac, 0x385e3cb2, 0x4c396af1, 0xd158b358, 0x0439daf3, 0xfcb6fa20, 0x5433f150, 0x03489aeb, 0x7c051ca2, 0x30720a29, 0x78e5b3e2, 0x2ed074a0, 0x588f19e1, 0xd6de2186, 0x90c118ae, 0x7275bf15, 0x9dd54e2d, 0x328add7f, 0x08f535e0, 0xe414d918, 0x19922e66, 0x38dc6e2e, 0xb79c7535, 0x99a07299, 0x5f9bc733, 0x1d6782e9, 0x5ebafc6f, 0xd0a3c604, 0x14557e65, 0x56116dab, 0xe5dafe4b, 0xd25745be, 0xe463a325, 0xd41b06f2, 0xabe936d9, 0xa4ef1bb4, 0xf8891f01, 0xe5eae7f4, 0x7e4f0bf5, 0xf21f546a, 0x6884ceeb, 0xd60d30e3, 0x50379367, 0x10d141e9, 0x7fed6eac, 0x99bc21a0, 0x9a8bbdb6, 0xfdc4ae32, 0xea6c6ffe, 0x00181b14 };
const u32 bern_num_data296[97] = { 0xbc6bf331, 0x1e57c0b0, 0xf159c11d, 0x04ad3dae, 0x0e69881b, 0x1fd21933, 0x2d1cceb9, 0xe07d0d85, 0x10efb5b0, 0x8e2a5295, 0x73b65ed8, 0xac98bf2f, 0xb769f582, 0x6bd1c925, 0xa3d69f21, 0xddb453e6, 0x441570bd, 0x2b502020, 0x60471244, 0x6e5ddc65, 0xcf7e2cff, 0x13a51091, 0xa9044ee7, 0x9a5748e7, 0x919c936e, 0x309b37ae, 0x20c8b1f9, 0x0faa69f9, 0xe0b3d066, 0x4c30fb0c, 0x8592ee6c, 0xbcc56e3a, 0x236b95aa, 0xca9bc94d, 0x9ab2f8ac, 0x3657666e, 0x6ab1d597, 0x9b57c9b6, 0x755589ae, 0x5b1a3864, 0xb2ff50b7, 0x02df86aa, 0x6b9337ac, 0x20d4c1a3, 0x4f8ce5df, 0x73c0a0e8, 0x09113b2d, 0x7046797b, 0x3ff8e0ef, 0x64e45ff7, 0x5e226417, 0xdd90b559, 0xfd61a309, 0xf92dd7c2, 0x4331a2a3, 0x1f933bf8, 0xa4d357ba, 0xec5da4c3, 0x990b6fac, 0xc6068fc4, 0x731974c6, 0x405a079c, 0x60f6d2b6, 0x6df84733, 0xcd20bdd1, 0xdbd74bf9, 0x27d43882, 0xbde1c17e, 0x4e7d5a7f, 0x6c3d2dc6, 0x0395a3ec, 0x6e248722, 0x64b3bc55, 0x2da44b44, 0x6967a6d3, 0xcd3250f4, 0xc18be8e7, 0x2ce8f529, 0x5fd74979, 0xfc0508b7, 0x3bdc0da8, 0x4a14c35a, 0x7831d7c0, 0x32e9189a, 0x7f869516, 0xe9ff0054, 0x0ca72735, 0xa9f36f3c, 0x01eebb4b, 0x9cc7c230, 0x27da2556, 0xa47e63e9, 0xf58a3c74, 0x54e062ff, 0xa6c7ad84, 0xd293ca43, 0x00000011 };
const u32 bern_num_data297[96] = { 0x2c519b99, 0x48b53a73, 0x97a8f148, 0x55535120, 0x8ea7bc7f, 0x2a8ef8ed, 0x522f85ff, 0x8e88c921, 0xb6f663d7, 0xb920c333, 0x1f80c9de, 0x6fbc97cf, 0xfa2e9c44, 0x1300b594, 0xe42acd0f, 0x4c693549, 0x43aa668d, 0x578e1cdb, 0x3c7e4042, 0xf3939a10, 0x47b3c0c3, 0x225fb4e9, 0x0463015a, 0x74cf2230, 0xa341d72b, 0xe9a25c06, 0xefe62371, 0x211d2a0b, 0x1eed900d, 0x633557f8, 0x7b328730, 0x1461b678, 0x700dbf2f, 0x71847ef5, 0x79b39f9f, 0x315873b6, 0x9eb2e4ea, 0x5c0908f1, 0x2dd4811e, 0x3b4442ee, 0x75bffd1b, 0xd99d57aa, 0xeaa73621, 0x86021329, 0xcff8629c, 0xc13fa968, 0x30fb3ef8, 0x1ff33c49, 0xdc286e25, 0xac18b20c, 0x53fb2b3f, 0xbfe6c178, 0x219c2762, 0x536b065e, 0x419b157a, 0x81c80174, 0x044c2fb1, 0x2de9ec9f, 0x8da01937, 0x427caf4c, 0x375e5c3f, 0xe5928507, 0xe100a026, 0x846c3607, 0xb4b5a6ec, 0x8407f060, 0x67b4d7df, 0xb96f535f, 0x158ccf43, 0x433e00e4, 0xf9e73e05, 0xa87e2b48, 0x0c7f60cb, 0xef23fd5a, 0x00d9fbf5, 0xd19070e4, 0xba818e7d, 0xa6bf8c22, 0x689bcd48, 0xd0ff615f, 0xb01631d4, 0xbc95448f, 0xfde948f2, 0xdc0c0b43, 0xc2b62888, 0xa228207e, 0x2e7fef8b, 0x95052486, 0x5bb0b8e9, 0xa95c91b1, 0x737e4ef7, 0x3e70e81c, 0xf4d22f9b, 0xe879651a, 0x843e9208, 0x05063923 };
const u32 bern_num_data298[97] = { 0x501eacff, 0xdc98b509, 0x31d4b3c6, 0x7bfe6992, 0x0fefcde0, 0xdc1f4abf, 0x41e5ec9d, 0xadf493a7, 0x6687f848, 0xa7cee0a1, 0x3a891441, 0x49804c11, 0x29ed48c0, 0xf25f9a5c, 0xa55e5527, 0x305f467b, 0x39e2e0a5, 0x5bea4d8b, 0xf67d1cee, 0x4e940fca, 0x55a91a4b, 0xf4a64df7, 0x3fae5b45, 0x5b6a458a, 0x941f6035, 0xa7bff45d, 0x2cfca0fe, 0x7cfbe956, 0x57fd5496, 0xd0843fca, 0x96b53d38, 0x3b5fe199, 0x49a09933, 0x0cc33560, 0xef043388, 0xb74d13ee, 0xcda15793, 0x5cce5af7, 0x280a7cc4, 0x34defb3c, 0xe2dd696a, 0x64d593a6, 0x4d0b8a9d, 0x9be6dab4, 0xd4e63bed, 0x0ace634f, 0x704eae9c, 0x8a612ef5, 0x99e67700, 0x0654afd4, 0x506d4826, 0x7513ad23, 0x92a47f97, 0x3d85238f, 0x298f1131, 0x099526db, 0x94788416, 0x600e998b, 0x4a3c8ace, 0x2103e89b, 0x85b5aa5f, 0xe1c707f4, 0xacca7b72, 0x767e730f, 0x44022a5f, 0x132bb5c2, 0x72fc2e0f, 0x6d0aeb55, 0x037fa24b, 0xfea2c171, 0xa3e1c66b, 0x9a43f07e, 0xee9e07f5, 0xb42f32d5, 0xc3d314ec, 0xb0ee75d9, 0x7255dc53, 0x3453882b, 0xccca3b1b, 0x55773f01, 0xbccc90de, 0x94a8b15f, 0x8e46ef04, 0xf3108a21, 0x09be3658, 0xcd8ec49b, 0xfb7e5525, 0xd774a5fd, 0x6484778e, 0xf416d3ae, 0x3d430f7c, 0x28ab9e2f, 0xcd13de29, 0xe9042064, 0x93d145f5, 0x40a3b8b8, 0x000f3f9d };
const u32 bern_num_data299[99] = { 0xd72197e1, 0xa71478f8, 0xcd32a144, 0x18668b98, 0xb5b53de3, 0x0e9f42cc, 0x14bc6e8c, 0xf2f641c8, 0x5df795c5, 0x6c66b375, 0x08b1de07, 0x2d7bd7d5, 0x8a7def00, 0x19442462, 0xe1e8daa3, 0xb5e8f5d7, 0x700e3932, 0x74fe6a0d, 0xbc220677, 0xd3ffc608, 0x0b17d6b8, 0x2d6d4366, 0xc5d67220, 0xc0b673b2, 0xdf4e50ed, 0xde1d7c53, 0x6c1dcd5b, 0x1ed5e0fe, 0x645c57f7, 0x207a6735, 0x2158aac4, 0x02c2255e, 0x19302042, 0x4e3dfcf9, 0xfaa4410e, 0x8b1ba62b, 0x4b17bc75, 0x10116dba, 0xfc89b998, 0xf5f04396, 0x62361472, 0x6cb8fdd5, 0x0d8b8ccf, 0x6f99bfbb, 0x60c5e7e4, 0xdd5a5a3c, 0xdb956d75, 0x389ceb85, 0x1cc0506f, 0x7e5d3629, 0x4bd46858, 0x353fde22, 0xb205427e, 0x9c76129d, 0x48ccc56d, 0x4a9e1f81, 0x00ffa0e9, 0x8cf4c0f0, 0x99dc7a82, 0x816be778, 0x8e9af8f3, 0x94365812, 0x19e8f162, 0x21756724, 0xd6ee69ac, 0xf5621c3d, 0x20643cd1, 0xce35e084, 0x4d3ad246, 0x59ad6061, 0x052a71f9, 0xbcf0ab1f, 0xf9be03cf, 0x471cb4f2, 0xb6fc2805, 0x160fac2b, 0x4aaa4e23, 0xea4d0b63, 0x0deee125, 0x22375683, 0x50933d88, 0xe48a8e43, 0x811c1337, 0xff36b08f, 0x7e6816ac, 0x29535dfa, 0x422522b5, 0xdb0a6588, 0x62443750, 0xb1d683e0, 0x96c9d269, 0xd11b02e5, 0xbc7f42c7, 0x795dfe31, 0x6e73afca, 0x2807e09c, 0xc71ec867, 0x4e73f604, 0x0000003e };
const u32 bern_num_data300[97] = { 0x9e91780f, 0x08437695, 0x786416c9, 0x01f6458b, 0xfffbfd3f, 0x0729e042, 0xe0447608, 0x61f77df2, 0x98c9dcf7, 0x33d7cd24, 0xeb41cb55, 0xb2638bc8, 0x71e0a875, 0x091c3f94, 0x6bf2024a, 0xa6419d65, 0x4504b1b7, 0x6528b837, 0xed00debc, 0xc6c46699, 0x40cd6be5, 0xd4097622, 0xd5edbd52, 0xef3d378f, 0x8b9507fb, 0xe07df6e5, 0xecf9eefe, 0x73ab58d1, 0x853b71d0, 0x3d2f28f8, 0xf517a96e, 0xe6dfe2ae, 0x4728d316, 0x6def62df, 0xfa38e215, 0x83b633f7, 0x154e50fb, 0xfb7e2108, 0xfa202288, 0x544b74d7, 0x2f8c8763, 0xe879e841, 0xa1baa717, 0x9f471453, 0xc3e823bb, 0x3714437f, 0xafefbab3, 0x66a285c3, 0xd64d5f2b, 0x5585c3ef, 0xab2a8ca0, 0xfa980e6a, 0xcd4569fb, 0x6ce461f8, 0x09b31562, 0xb9b67104, 0xea5a6dee, 0x47120cfd, 0x0d44a95d, 0xd08ba204, 0x8dcaa4cc, 0xfad89a98, 0xb199e219, 0x0715f4ac, 0x1912c917, 0xb9ee0bb2, 0x4ff8c7f8, 0x39ba520b, 0xec1358ca, 0x59eebb0a, 0x986c6611, 0x3e897ad5, 0x4388c5f1, 0x651ad0f2, 0x077f2d77, 0xf4aa417c, 0x22f976d2, 0x5f902205, 0x0f4a5515, 0x630d76e6, 0xbfa5b215, 0x3b686f1e, 0x3741bfb5, 0x94351133, 0x4ca30c8b, 0x9fb429ab, 0x0feca251, 0xa4fd42fe, 0xa34bd8ed, 0x3ef19e65, 0x937bc931, 0x627980a5, 0x4053e504, 0xe1732bd5, 0xdf0e42da, 0x9a6d2a44, 0xb084e791 };
const u32 bern_num_data301[98] = { 0x38755629, 0x9a9a0829, 0x311fbaeb, 0x0cd84214, 0x808f450d, 0xe1598479, 0xb1212e5d, 0x7d1e4f75, 0x6bfc5271, 0x8b9848dd, 0xbb17727e, 0x91cc1712, 0x9f7e44a8, 0xb7bd3cab, 0x31874e79, 0x13a0f996, 0xc0f1399c, 0x6a235b82, 0xb46237be, 0x55746682, 0x4e27bb0e, 0x7a267d6e, 0x50e290dc, 0x836e1b15, 0xa08784fa, 0x5d3ff9e9, 0xccc7431e, 0x61e451b2, 0xdca1ed12, 0x325e7417, 0x5cfe0bf1, 0x13943709, 0xd7be11aa, 0x76193245, 0xb9635a03, 0x3fc87bc8, 0x2233045a, 0x917835f6, 0x787bd846, 0x4fe61cb9, 0x12bdea0e, 0x959171b7, 0x2c28e87e, 0xdf15fe43, 0x230ab4c8, 0x61612895, 0xced5c9ad, 0xc55b28fa, 0xcddd13ef, 0x48fc192c, 0xd2bcef1b, 0x9e995b6f, 0xf89aaccc, 0xc0c2ab39, 0xc46f3708, 0xad4cde17, 0x3dfb39b8, 0x616b0b8a, 0x9a4dbbd5, 0x1ba10a4c, 0x95b1bfdc, 0x941c1dd6, 0x8c364480, 0xbb9f826b, 0x8565ecea, 0x7c8425a2, 0xcd252667, 0x1aa79c94, 0xa648a31b, 0x7bfd048a, 0xcd1a14f9, 0x3dd1820f, 0xa590f6de, 0xf6479956, 0xb8170390, 0xfc363b8d, 0x6f344254, 0xebb707dd, 0x0cda384c, 0xf051a119, 0x7ae0033e, 0x5d10c265, 0x327f5fab, 0x857d38ca, 0x60a012f0, 0xd7b3d86b, 0x3c9b3765, 0x7fc21aa2, 0xaf2f3acb, 0x96d1555e, 0xc157c65e, 0x030cefa1, 0xbb22b495, 0x80c3c696, 0xcfbf8433, 0x1a78a844, 0x89bdd91d, 0x00007c3e };
const u32 bern_num_data302[99] = { 0xe1f86f0f, 0x63c33c62, 0x3eebcb1a, 0x6b44774d, 0x704cbd11, 0xba1b7c20, 0xc92f3b3b, 0xeba56cd9, 0x83cebf43, 0x73ba7cb3, 0x7e83ddeb, 0x6826758d, 0x5bc3967b, 0x05e86ffd, 0x9d174803, 0xa89b421b, 0x5dcd0f42, 0x4cb8f199, 0x92394366, 0xc16d100a, 0x26e7270e, 0xacbc1fe3, 0xa34e87dc, 0x6e35e7bd, 0x05e42499, 0x3af0730d, 0x31c81fa5, 0x314af607, 0x879e61cf, 0x13b89673, 0xaf858f96, 0x88d0ce3a, 0x5d175933, 0x7ab0eca6, 0x8c77eb11, 0x81a3e2f8, 0x39fe8588, 0xe07367e1, 0x3fcc0143, 0x19f27bb9, 0xc5b50b34, 0x45a55037, 0x1e12471e, 0x701e437a, 0xe336e656, 0xb9034616, 0x6754899f, 0x3591b7d1, 0xa62f5cab, 0xbf788bb3, 0x2acf7e00, 0x1e761a58, 0xd52a06ae, 0xfdb46ed6, 0x8f9be0ae, 0xdb02dd5b, 0x5e37f122, 0x8e29848f, 0x7ab485fa, 0x6283ccfe, 0x2589f820, 0x74670554, 0xb492ab6d, 0x5384264b, 0xebf995d3, 0x4928ac24, 0x47ec99ea, 0x9ad7cad5, 0xbcd1de19, 0x03c29151, 0x9b9327fe, 0x6f59cafb, 0x71143a4f, 0x06654c64, 0x461e7e58, 0xc156e10a, 0xd955d6ea, 0x1341eecf, 0xfedec71a, 0xd248918a, 0x10a9308f, 0xd1240b3b, 0x1ee42e72, 0x3b684740, 0x05c9d628, 0x0a0b4c31, 0x5992fdb1, 0xe2b4db6a, 0xc7116913, 0x21d29fcb, 0xcaee3640, 0x74ce208d, 0xfb04b9ef, 0xba00e083, 0x59ab31e1, 0x377e9a09, 0x87296687, 0x71b81155, 0x0000003a };
const u32 bern_num_data303[99] = { 0x25b0c5c1, 0x758bf103, 0x57418748, 0x2441038e, 0x7706eded, 0x8def74d2, 0x97dde2e1, 0x8b79b811, 0x18c5327c, 0x45a2ae1f, 0x841ba1bb, 0xfb41b83a, 0xb27e3861, 0xa12ea286, 0xa37dab1b, 0x9a503362, 0x7c46ff74, 0x5ca364e9, 0xffc07818, 0x7ede1db0, 0x7f0acfe3, 0xc4231dc6, 0x13ae04a6, 0x09ffe112, 0xdc69b38d, 0x9643ddee, 0x89622fe7, 0xd481ce66, 0xc8adf99e, 0xc84b413e, 0xb8eb855c, 0x4d928048, 0x9c6ddbcb, 0xd7040989, 0xd1816b48, 0xa1b42551, 0xda97dc1e, 0xc22f8e1b, 0x0593a99c, 0x9026e710, 0xdd7af277, 0xd0a95b7b, 0x32f2544d, 0x2a8d73bc, 0x3bb69771, 0x218d846c, 0x50aff0b0, 0x0b9eff7c, 0xf7455534, 0xe8c425c1, 0x26d12f58, 0xe6fbc3ad, 0xf814c790, 0xfb374387, 0xbd17b0d8, 0xe6f11676, 0x58e13ca2, 0x8f884a29, 0x6ad599be, 0xcf6dcfee, 0x0b3422b6, 0x515dec93, 0x1f7f7250, 0x490f3a21, 0xe0a76932, 0xf9bf98b7, 0xbc29c8d3, 0x87d9d82e, 0xa12812ca, 0xa38d6cc4, 0xe9c6665b, 0x1d49c4b5, 0x521de9b2, 0x37233124, 0x519c23a5, 0xd2f36b44, 0x8d72c320, 0x081df81a, 0xbfa323c9, 0x6b0c04ba, 0x3b8b5102, 0xda54c701, 0xeeebb9fc, 0x9e5f165a, 0x1c791f37, 0x442c3113, 0x70fbfcc1, 0xf7fe3840, 0x97d7e8ca, 0xb889f665, 0xca946058, 0x84b7988e, 0x420dd5f2, 0x1c5b989d, 0x191aa786, 0x165c49e3, 0xfb211793, 0xa66a7e95, 0x00002ab1 };
const u32 bern_num_data304[99] = { 0x8d6048b5, 0x3518b9cd, 0x7821f438, 0xe7f216a4, 0x1288e1d1, 0x449a8561, 0xc14debb0, 0xa865d1f8, 0xc2a7aa98, 0xf06c20e1, 0xcecdb109, 0x04c7fc86, 0xac1b9d68, 0xeb25dd20, 0xa4ddc262, 0x335de51c, 0x0442ad13, 0x37d4cff2, 0x7bde0355, 0x4485ac40, 0x24b275bc, 0xc8ce35e9, 0x9e90d710, 0x91ec677f, 0x260e0c7d, 0xf7894195, 0xbd82dc0c, 0xead39656, 0xb2702609, 0xfef3151e, 0xe389011b, 0xdd3c4dd2, 0xcff0d09d, 0x21dd0be8, 0x7e86edba, 0xe70cc433, 0xca43dba2, 0x0cee175c, 0x7e2ba97f, 0x257b43a7, 0x5f97db92, 0x242c821c, 0x4b034149, 0x5895f017, 0x9402605c, 0x1499a60b, 0x371f269b, 0xed52b3a8, 0x45b50d73, 0xea2570aa, 0xfec0f347, 0x89c02d1e, 0x96be50f8, 0x9c89f4a6, 0xabfb2c73, 0x86233b6d, 0x3563466f, 0x236bcc9d, 0x2642202a, 0xca028839, 0x4af5e997, 0x9a6cf775, 0x98afa867, 0x7eb763f1, 0x3ca67bcb, 0x3203a5d4, 0x5119cf85, 0xe364d0e7, 0x4d3b34f8, 0x67c06056, 0xd853e0e2, 0xe951440f, 0x0811df10, 0x0db1dbbc, 0xced36dd8, 0x95a15286, 0x9381b72a, 0x1d6ee74c, 0xa7f897e5, 0x9c451c1f, 0x1b34444c, 0x44e3bae8, 0x8ab4579c, 0x8f201ec8, 0xf209fe4d, 0xc40a3eea, 0x34ec957b, 0x4b6d1f59, 0xcc15cdb9, 0x168a2377, 0xf622d5ab, 0xa1be42f4, 0x9f71c0d4, 0xa5844307, 0x9c3c4d50, 0xebc67601, 0x2a0dc9a1, 0xacc61d43, 0x00cb16e9 };
const u32 bern_num_data305[101] = { 0x3c5aa815, 0x02d6d98f, 0xc6540fb4, 0x2df28acb, 0x0c21d804, 0x0880f503, 0xc18499d3, 0xa6df0af8, 0x5b203f9e, 0x05d16117, 0x0eaed97a, 0x195fbd96, 0x2266f46d, 0x6db8800a, 0x160cdd91, 0xe341d5e6, 0xb7e79c35, 0x195c6ad2, 0xf6fe409c, 0xc0714307, 0x4685d00c, 0x929034c7, 0x675656ae, 0x3f668c3e, 0x23373b6a, 0x3f705750, 0x3fd815e5, 0x72f1e720, 0x1227da0e, 0x9c7e52d5, 0x978d05a5, 0x5b32c7a7, 0x663b11a8, 0xd21276de, 0x56ba26d3, 0x0d0143fc, 0xdfa16a1b, 0x79d3e6db, 0x38b800ef, 0xf91ac8bc, 0xadc6af33, 0x4a9885db, 0xe52b7fb7, 0x094d4122, 0x4ebd56df, 0x8cff007f, 0xa23878fc, 0x0e7fb897, 0xbc7d2fac, 0x845971eb, 0x1fa64e51, 0xa75a9052, 0xc24ca04e, 0x26780b34, 0x10d74aee, 0xbd26609f, 0x9a455fac, 0xfe7984c0, 0xfee08448, 0xf8873688, 0x7c439f5c, 0x4bd63661, 0x78b01523, 0xb70f83c9, 0x56c12b78, 0x11aa3ea6, 0x524a4796, 0xeefc5e87, 0x40a56ba8, 0xeaf1458c, 0xb32d1dfa, 0x8a260b35, 0x07c6eae7, 0xb7a03bd7, 0xed466f1e, 0x82baf81b, 0xb0063dc2, 0x9dd1d8f5, 0xa3837468, 0xd5f0b90b, 0xe8535b23, 0xaaeec971, 0x557229b6, 0x6c4eb756, 0x92712071, 0x051014d4, 0x105b6520, 0x650acb21, 0x453def51, 0x936b8408, 0xfc55777f, 0x6f3a0a76, 0x736d54c1, 0x7887f537, 0x6ae98e53, 0xc24798c9, 0x66833781, 0xb82d5e05, 0x8f8c86c5, 0x0a05827e, 0x00000f0c };
const u32 bern_num_data306[100] = { 0x25a9a517, 0xb9599ebd, 0xf5d07d22, 0xb7ee4a7a, 0xe7e32615, 0x3ec76522, 0xf63ca6a2, 0x001bf90e, 0xc75b50b6, 0x74c7fb97, 0xe1fe2a53, 0x91cf2034, 0x280c4fed, 0xb9318f68, 0x76d24c53, 0x2bf4cdba, 0x6e448373, 0xeecbda31, 0xa2ec31a3, 0x2b45585d, 0x444ae12b, 0x290488df, 0xa1411e8e, 0x0375a786, 0x73c74f56, 0xce9dfe53, 0x4594f859, 0x8b3b6b80, 0xf53f3b65, 0x7a58e464, 0x5520d99e, 0xb16ee5bb, 0xbec7f2f2, 0x41fdd2f3, 0xad415fdf, 0xbfd4b4c9, 0x1504e64f, 0x49ee20d4, 0xa8a26c5a, 0x28dd106c, 0x0072dd05, 0x88edf802, 0x5f384100, 0x15ca4726, 0xc75acd9a, 0x2235794b, 0x812062bd, 0xd01e7149, 0xbcaada31, 0xe2398167, 0x3d46ddaf, 0xb7868e90, 0x06c7eee0, 0xa5de6050, 0x65fb403f, 0x71484a52, 0x2b132f17, 0x1e9394f4, 0xd370cae9, 0xdf22a7ce, 0xbfadc4f1, 0xca7c9cfe, 0xa5dd5db5, 0xb7751ba4, 0xb6f7f107, 0x33994590, 0x870e2bf2, 0xc857769d, 0x4bb99470, 0xd32130f2, 0x94b1f011, 0x4b1b18a3, 0x9c3ccb35, 0x3efca0c4, 0x17dfee86, 0xb34daea7, 0x17342483, 0xc38c4d0e, 0x6e1eff52, 0x12aaa474, 0x6d4062a5, 0x92fd226d, 0xaebc1710, 0xc235aa60, 0x62a8b087, 0xb0020c60, 0x08e5e06e, 0x16475402, 0x5d600f42, 0x4b207401, 0xabfb7ea7, 0x0a868f66, 0x167cc362, 0x0bc23d47, 0x01df2a9a, 0x749323f0, 0xb45bd3f7, 0xfa689382, 0xfc624119, 0x0000635f };
const u32 bern_num_data307[101] = { 0xc6751edb, 0x4d03bdac, 0x293565a7, 0x47936bda, 0x1b815b5a, 0xf1bf97f7, 0x8ff7458a, 0x9c01cbd2, 0x572056ba, 0xe3224d74, 0xf75ac620, 0x412364af, 0xe152ba67, 0x0b270fd0, 0x99478975, 0xf57cd848, 0x8143bd8a, 0x9a4f1bc4, 0x6c28c0b6, 0x168cab7c, 0x715f865a, 0x26ed79ff, 0x8e514145, 0x85bf678a, 0x34d5dc2e, 0x170651d3, 0x0fdd9ff7, 0x5bf3abee, 0x2a97a942, 0x6a2037f3, 0xfbc9b99c, 0x0be8c5be, 0xf0e67145, 0x41d12ed4, 0xd7a57513, 0x2a4bdae3, 0xcf16ba7a, 0x8a81110a, 0xc1c9539f, 0x100a8741, 0x9370a7c4, 0x5366b46c, 0x015f4c66, 0x3755755c, 0x6bf9d9b7, 0x7a41ebe2, 0x9e1a2771, 0x75cebc92, 0xdda1b3d9, 0x5263df1f, 0x56a0bd63, 0xb9f4caea, 0x78470835, 0xe1ec1652, 0x97062d80, 0xe984f658, 0x81d7aeff, 0xe448e354, 0xf73df7f1, 0xa86b3934, 0x4c480060, 0x4dcdf5c9, 0x9d46164f, 0x3cc10464, 0x8238c74f, 0x4667e3cf, 0xcaa196c4, 0x75e113df, 0xad40b7f2, 0x2964541e, 0xad14f6da, 0x59917a6d, 0xb4a0b87a, 0xbd1c2987, 0xe579b906, 0x83e4f7f1, 0xb675ef2a, 0x192be73b, 0xabe25eab, 0x80e37ae7, 0xb4fb1456, 0xa85721a5, 0x595cabb4, 0x71fb2880, 0xa77a6311, 0x193ff646, 0xb0a19d44, 0x77b74fd8, 0xba46a569, 0xd9a4c9cc, 0xe40b3259, 0xf98a0d80, 0x4fb765cb, 0xf840ca6a, 0x1f60a96f, 0x1a604fd8, 0xcaf37041, 0xa0b7ca1d, 0x62fbc00d, 0xd37d98e4, 0x009ed591 };
const u32 bern_num_data308[101] = { 0xfdfa84c3, 0xc9dd7e85, 0x2f6318ec, 0x4f7b5bb5, 0x45776484, 0xa5f648e9, 0x1e4020c3, 0xf350a693, 0xfa5e76e6, 0xcf37b44e, 0xbf9c86e2, 0xd7afa416, 0x9df8365d, 0x11f5612f, 0x20c57594, 0x309ed11b, 0x663b2a63, 0xa156b245, 0xec731973, 0xc8084226, 0xba62d387, 0x32440dff, 0x22ab03e5, 0xea40ae60, 0x2f737e35, 0xca715465, 0xd990f98c, 0xc1fa5246, 0xe8e7e6e1, 0x6a18f4d2, 0x89b16a2d, 0x4dbcfcef, 0x54b17123, 0xc0daa5ee, 0xf4f3160e, 0xf0302c75, 0xab2a9e6a, 0xde810250, 0xec9d2268, 0x09cfa239, 0x833ab8c4, 0xadbe27c8, 0xf45f37a0, 0x90d05f23, 0x23680bf1, 0x93c698e7, 0xaa035368, 0x821fbc60, 0x4942effb, 0xe4c4f4b5, 0xe54c719e, 0x52e076b8, 0x62f270cc, 0xfebbd5b1, 0xcce4b045, 0xd82f4180, 0xfd69956d, 0x2c290428, 0x77f17ea1, 0x834f3413, 0x7b65068a, 0x0a39c87e, 0xbf67d808, 0xd23cd1da, 0x51157d00, 0xf56b058c, 0xf2cccee6, 0x1037c9ff, 0x29f7a6d8, 0x437b4a94, 0xbf920063, 0x03d3c272, 0x5058fbdb, 0xde6b98da, 0xc2d87a10, 0x48b9a3fc, 0x8431e10b, 0x591b63d8, 0x4d00e137, 0xa657b720, 0x2d1fae49, 0xdd1db0d2, 0x67698772, 0x5ba83b91, 0xe218c7ac, 0x9e195018, 0x74f9f68c, 0xe13d7717, 0xa09ae3df, 0x4b91ea9f, 0x2cf1ecc4, 0x89ecf81a, 0x2adce6d8, 0xff50350d, 0x9b0cbc3c, 0xfd568d4b, 0x16ca095c, 0xddda2202, 0x12125fba, 0xb76fb48d, 0x00244c23 };
const u32 bern_num_data309[102] = { 0x317ce085, 0xe2671182, 0xbe0b1307, 0x9eca0eec, 0x8ef5669e, 0x07460886, 0x0e750a43, 0xdc63b22b, 0x8b825a2e, 0xab1d1a3d, 0xb98c82f6, 0xd2702760, 0x73765864, 0x6106bd04, 0x300bc01d, 0x60d325ee, 0x3ef4956e, 0x990c523b, 0x28e8543e, 0x4618063b, 0x2a854490, 0x930adb5c, 0xdd9bb0b5, 0x755f0e81, 0x6c4b4c7b, 0x87c49182, 0xaedc7902, 0x5ae4af1d, 0x3bc522ac, 0x58649cf2, 0x36bdc265, 0xf83436a2, 0xa68ef6b7, 0x37dc9ce0, 0x71688ee9, 0x5bd72987, 0x5eff58ab, 0x05dc40c4, 0xe5c194c9, 0xb59e7d2a, 0x07a4e8c8, 0x6baa87f6, 0xc9f6023b, 0x7df666c9, 0xac450444, 0xe04bf464, 0x291fcba3, 0xde25a5d8, 0x5b50bf4e, 0xd98c7580, 0xe0a0ee07, 0x8a64c4ce, 0x8602cbd6, 0x796ddd16, 0x82b70390, 0x94dfb71c, 0x519ed7b4, 0xa5603e5a, 0x911b69bb, 0x6177c758, 0x05f3582d, 0x60e6fcf5, 0x5340f0f3, 0x4c1c8d42, 0x65edd44d, 0xfd7d134a, 0x67f74ebf, 0xc27f4a69, 0xff191677, 0xa12a9863, 0x4b4be133, 0xee487915, 0x35f8feed, 0x4d2f952b, 0x1fa7f162, 0x03541733, 0x8e00d0e9, 0xf7c2fd3f, 0x9222195c, 0x96391800, 0xe29f90fb, 0x42a3b146, 0xd471b82b, 0x3e3c9abc, 0x10e49e3d, 0xe8063333, 0xf6aefdb0, 0xb1c2e59f, 0x6eadc4eb, 0xea443ab6, 0x264ed2e8, 0xac578985, 0xf9506133, 0x05e3ffff, 0x4bfdf75f, 0x65f01be1, 0xd427388a, 0xa896bf38, 0xca90408c, 0xdb7acfc2, 0x412d158f, 0x00000015 };
const u32 bern_num_data310[102] = { 0xd4914647, 0xc308ae67, 0xbca06e45, 0x16780012, 0x8ed8647a, 0x1f0aa763, 0x4041212a, 0x69ad9f94, 0x1634d5d0, 0xcff7fe9e, 0x9b468e05, 0xb3e76c2e, 0x6c4e3eea, 0x81e4be2f, 0xa23d723e, 0xaa4157b5, 0x9f8b2a26, 0x45e5fd73, 0xb1def2f8, 0x42f00685, 0x7708c600, 0xa9c92bda, 0xbfa43de1, 0x49e4982e, 0x3ea9c441, 0xbb7e291a, 0x66efa828, 0xce5393af, 0xff689fd9, 0x6e0874d8, 0xbb01b5c0, 0xf02be05c, 0xbdc6dfa9, 0x99cbd1f9, 0x9f0d012c, 0xbf27c777, 0x0de47a5e, 0xe2e396ca, 0xf4b02bab, 0x82d185ef, 0x87ab9e11, 0x3b88bea7, 0x657f64bd, 0x415d2fcf, 0x0b382926, 0xead06afd, 0x22dbbb85, 0xf5fe1d36, 0x78adfffc, 0x9d4a1a44, 0xc15aae06, 0x85146feb, 0x3b1be9c2, 0x4fb2d621, 0xf26a738d, 0x2ed6b7d2, 0xd11af9f4, 0x46a797c1, 0xfaf21c3c, 0xf944cb46, 0x6ceaaa7e, 0xca781531, 0xb34c9c10, 0xff98eb85, 0xf957578a, 0xd1ffcc21, 0x5e7bd447, 0xabe2e193, 0xbbaa1c09, 0x287415b6, 0x84519457, 0x0fa8286f, 0xbba99e30, 0xe08a916e, 0x0605fc1a, 0x98ab2628, 0x007db82d, 0xac48c591, 0xabbc3216, 0x7fef38b3, 0xe5da98e8, 0x9e99ad9a, 0x6ed0a5e9, 0x2c6321a4, 0x17dd0861, 0x43feff2c, 0x732a9811, 0xac331228, 0x8c3ce782, 0xfc5bdfd1, 0xac234001, 0x2ad02891, 0xceca168b, 0x14668700, 0xe35b6024, 0xe9060285, 0x66593527, 0x18b6d5f6, 0x4ca43090, 0xad95c4b0, 0x28600ffa, 0x0000000c };
const u32 bern_num_data311[103] = { 0x3211c78d, 0x1b7cec2e, 0x1384204a, 0xd4f02a1f, 0x60a336a3, 0xbaba44ec, 0x92773ac7, 0x1fb352a9, 0x4ca3c9da, 0xe11bc049, 0x8f6aed33, 0x0e14cb5a, 0xf57cfe6f, 0x3f831fff, 0x255d9d67, 0x5a8dde65, 0x54433875, 0x313d662a, 0x97ff0efe, 0x05764e4c, 0xe5e7411b, 0xb988161e, 0xdf7f5c17, 0xdcff0bee, 0xea748402, 0x2c3638ec, 0x113ca751, 0xef9251ae, 0x4d0e69d1, 0xafd4b6bf, 0x2faba0d0, 0x4a570ffe, 0x18585c1d, 0x7ba2d6b8, 0x6e64ba27, 0xa0f1a3cf, 0x6ba6b4d0, 0x0f5edfec, 0x05ab9f5e, 0x9ea1db17, 0x4870b8e6, 0x04288f65, 0x666855b3, 0x2262a8c0, 0xed1baed8, 0x3c89e874, 0x8aeaa6cb, 0x0bf89c69, 0x4361cfbd, 0xd84ffaea, 0x471a24de, 0x95f38d62, 0x7a3abafd, 0xde10cd18, 0x4f692b1c, 0xba62e69e, 0xadee5e92, 0x48a457e9, 0x9afb3508, 0x4dcc688d, 0x3c7cdd18, 0x7206f4b9, 0x10fab871, 0xf8eb33e0, 0x1fdeda30, 0x54e3433b, 0xbf57f1bb, 0xa04fd58b, 0x8f91511c, 0x16396591, 0xc3571949, 0x60a35f41, 0x42e0017c, 0x4d39a70a, 0x17398037, 0x21bfe2c6, 0xc01ee9b5, 0x383a9043, 0xd8ef8585, 0xd8788e83, 0x6b262e4c, 0x44db2b7b, 0xdab18e29, 0x10a8fbfa, 0xa430ba2a, 0x715cd7de, 0x04ab55ae, 0x99ae141b, 0xa2fef071, 0x9769f0f2, 0x90bd5ee6, 0x9ffc1b4a, 0x13c29f70, 0x3eafcc47, 0x91f8f8b8, 0x74e0a3cc, 0xd164956e, 0xc9a52b5f, 0xb22ac1d0, 0x2c615f37, 0xee1b0c40, 0x321b33a0, 0x02a4e988 };
const u32 bern_num_data312[102] = { 0xa799b49f, 0xe7edc25f, 0x2e463c78, 0xd893e714, 0x92562865, 0x484be185, 0x6dba5bb1, 0x4ca6a7c0, 0x51c19bf5, 0x759b42d7, 0x3fb5ef6b, 0x234470a8, 0x4c56bd21, 0xb7bbd87b, 0x82960a4b, 0x75b13711, 0xfb4a53f3, 0x6a22c708, 0x0c9abc50, 0xf22a2108, 0x14ccd4f4, 0x5f32e47c, 0xb22138b8, 0x7c7ded1b, 0x39da5cb7, 0xe8179c51, 0x7f39f0b7, 0xe090de6b, 0x423970f4, 0xa9c8b698, 0x8864cdd6, 0xa4fc073a, 0x857dbf9c, 0x9803d7fa, 0x36d195b1, 0x2129f624, 0x352bd362, 0x7275da94, 0xf177f1dc, 0x4430e7c2, 0x026c24f8, 0x38dbdf1b, 0x82b26f40, 0x8ca96766, 0xd37935af, 0xbeb5952a, 0x9e928fe4, 0x4b351dda, 0xbe108f5b, 0x4ebf9c0e, 0xc4f4a8a0, 0xd86ac358, 0xe1b4d9a7, 0x650a943c, 0x37771d12, 0xc994cdcc, 0x2ec9a57a, 0x32bb9e73, 0xd74b71f5, 0xd0b5142a, 0xfd8ade3d, 0xb99e18d8, 0x0040c807, 0x1f0bba96, 0x9c5f5c77, 0x3545161d, 0x0ccfd42a, 0x58bfea8e, 0x3387e86a, 0x9ece3454, 0xe5407e63, 0xbd6e5fbb, 0x5062200e, 0xfc3fe0c0, 0x1bcad35c, 0x3e246e12, 0xa753c618, 0x948742a4, 0x9c162aad, 0xa8302b8c, 0x76e4b5b1, 0xfd4de10a, 0x542dfff3, 0x4c8159c7, 0x1a859b35, 0x47a5febb, 0x13c341af, 0x3ee6bf75, 0x1116b7e2, 0x0a8d0237, 0x55b9afac, 0xfde5ea02, 0x5ac2c806, 0x34095866, 0x088cda7a, 0x4852e24c, 0xa2ff436c, 0x379f7e8d, 0xb4ee7955, 0xb29bdb7a, 0x76061a57, 0x46b835aa };
const u32 bern_num_data313[103] = { 0x0dd679d9, 0xb53e28a6, 0xcdd58f13, 0x6bab7b6f, 0xd1973050, 0x0b870626, 0x5e466de0, 0x1a9d73c0, 0x4f106373, 0x703ff2a1, 0xc4cae7d9, 0xed156def, 0xd6a56090, 0xcc703a91, 0x1654b197, 0xb0bf7263, 0x36ba8f21, 0x3851740b, 0xa7cd1df9, 0x5de59a1b, 0xd3c24802, 0xcffef945, 0xcfa4baa6, 0x774513bc, 0x556e6265, 0x0433d138, 0x41f9d83f, 0x9ae22468, 0x50a88f5a, 0x8b0d6793, 0x94442942, 0xa09d51b2, 0x3d48433c, 0xaa231035, 0xb34a5f74, 0xd9e316a6, 0x5c1b9fbf, 0xa3442a9d, 0x255f257b, 0x951117b1, 0x71260f4f, 0xec8f8f4d, 0x3fdcda22, 0x9f1b188d, 0x1ac25192, 0x0eb1177f, 0x22498e09, 0xeceb40ef, 0xae744cbf, 0x118d30ce, 0x95ca022d, 0x32a5d1b3, 0xbbada10a, 0xc5f5a04f, 0xd707708f, 0xfe44965f, 0x215e4f54, 0x8da833b5, 0xcc9d0ca8, 0x79012cb4, 0xf819225e, 0xdb1f5d71, 0xc10f4332, 0xbf886bf7, 0x07d00498, 0x6b874c67, 0x36a0a12f, 0x742bb062, 0xb74ead8f, 0x562b0a10, 0x35a6d310, 0xd0991687, 0xc2b762cf, 0xd030b13f, 0x7e29bdfc, 0xe8fc8c9d, 0x56808b2c, 0xfa38d4ef, 0xb0c89108, 0x17efd3ca, 0xd85fb58a, 0xff9f7e4a, 0xac134b7d, 0x6fca2b94, 0xeb194151, 0x1beb6de2, 0xa0fd5269, 0xca724d40, 0x7df62108, 0xc6123a7d, 0xa0fc74e8, 0x541d3f3e, 0x18ab3ae9, 0xa1003684, 0x4ebf402b, 0x8a8dccb8, 0x9b713cb5, 0x8dc58734, 0x37f0a380, 0xcf5d65b6, 0x0603b2ae, 0x71571ffe, 0x000035d0 };
const u32 bern_num_data314[105] = { 0xbc8297e1, 0x8215bce0, 0x8b127a25, 0x0782e8c1, 0x57aac4e2, 0x1f118860, 0x5ac27672, 0xbb499df2, 0xe2454987, 0x6dae5f12, 0xea5e7495, 0xf2bf3a87, 0x0708db09, 0xe0a9a422, 0x1667df4b, 0x915e743b, 0x032482e0, 0x3b703cdb, 0xffc37ac5, 0xe1db265e, 0x66dd6dfc, 0x11d702d0, 0xca709834, 0x530bba29, 0xd25a9ed3, 0x75177a43, 0x50089a01, 0xad87d8a1, 0xb4f364f5, 0x8cd7c963, 0x5793aa07, 0x90fc406c, 0x8f19564e, 0x751ed0ab, 0xa98969b9, 0x1dd7e6b9, 0xf3cff165, 0xda864d8b, 0x9a0710d4, 0x890b99b4, 0x4e1f6cf2, 0xce3fb54c, 0x8ba4a3bf, 0xdd00818c, 0xbc2b1e73, 0xc92877d8, 0x1dad64da, 0xcc80a9d1, 0x36f71a01, 0x8fb1437e, 0xaa331786, 0x4ae56483, 0x3d1a248b, 0x81267c90, 0x56a73d00, 0x4884b614, 0x5aa4cf61, 0x8eb900e3, 0xbfa037f8, 0x6e9f1efc, 0x7241dafb, 0xc31bfe76, 0x4d3f08bf, 0x5e0db76d, 0xb263e547, 0x55ca2069, 0xe40ae56c, 0xae13020d, 0x67f4dae6, 0x9cd550a3, 0x67eb20e7, 0x07be1080, 0xacf8bd71, 0xc1f35d54, 0x24009a47, 0x899a114b, 0xf249d828, 0x350cd445, 0x8e5a4234, 0x72e810d8, 0xf7e20e6f, 0x91620150, 0x45a6253c, 0xa99ac7e9, 0xefc01a61, 0x9f242f8c, 0xb7bc40ca, 0xf0c39fd9, 0x8be3abff, 0x4e3e6d1d, 0xc80a20ec, 0x9f9f0c07, 0x47b3cf4b, 0x2c726116, 0xdddb4156, 0x745931fc, 0xf1c6c9d0, 0xc08a391e, 0xb161f2c0, 0x9166cfc7, 0xbc918033, 0xf9a72f72, 0xa8723830, 0x29848540, 0x00000db6 };
const u32 bern_num_data315[104] = { 0xcc8b171d, 0xae19aa24, 0x55dce3ba, 0x747d2faa, 0x78a8e833, 0x706f568e, 0xfbaabc49, 0xfbf492b4, 0xbb7d65cf, 0x2ec6b641, 0xa5dcd163, 0x21caa2db, 0xfc2f76cf, 0x9d797888, 0x7e644674, 0x4932c341, 0xb47e1571, 0x67b1dca3, 0xb6ae7e30, 0x3e6aba3e, 0xec708a2d, 0x794eb745, 0xc10a8cc5, 0x923e0111, 0xbd935b92, 0x31f8ea82, 0xb4f7bf18, 0x41184344, 0x2d863a49, 0x60b8a97a, 0xff414f0c, 0xa0c7e1be, 0xfd72e977, 0x0891d3fb, 0xe57caa6f, 0x62522d42, 0x875abe3e, 0xc348f210, 0xb52b8bd4, 0x25757192, 0xf664f8f5, 0xa7a81aba, 0x2a3e8813, 0xcd28c9d8, 0x65aad91a, 0xa0697e72, 0x1b237b89, 0x94cdef6a, 0x3ab32015, 0xea389b06, 0x31d6ed58, 0x1daa8d24, 0x0c5fe118, 0x2d3fbbe6, 0x5fbee0f3, 0x374c7931, 0x8ab62362, 0x941f5593, 0xd3cc3495, 0x2f16de96, 0xd02dcc87, 0x4f80f519, 0x86b5ac82, 0x0734c1af, 0xae054d86, 0xd95ab3df, 0x09cad1ce, 0x72599d56, 0xe7c59aa6, 0xc691f3be, 0x7e070f18, 0xae161a7a, 0x0162a25e, 0x267a2ecb, 0x1b516777, 0x12df3702, 0x52e351ad, 0x8b012842, 0xdebd405c, 0xb2b4b0a2, 0xb2b51af5, 0x2c91e0dd, 0xd711ca5e, 0xb055d13d, 0x431f65b4, 0x95ea8aba, 0xd73bff98, 0x87323f96, 0x5291ba25, 0x7ed6b2a4, 0x05db794c, 0x8df568db, 0xa900e2ad, 0x0fb6cd60, 0xbb89abe1, 0x254466e0, 0x146c7bdb, 0xc3965d36, 0xa3e5d619, 0x348a4c17, 0x7e975079, 0xfb861c10, 0x0c0e7121, 0x000192bb };
const u32 bern_num_data316[104] = { 0xa3c6bccf, 0x50e476d4, 0xb9055b27, 0x8c50a7e3, 0x9a529ce8, 0x9eff3eb0, 0xa0dc7d6c, 0x1c7fa7e8, 0x1ada4b1f, 0xf1d938f9, 0xa948a8a8, 0xb88a1eee, 0x76853e11, 0x5879c1bf, 0x140bf51b, 0x653c036a, 0x9b9aefee, 0x01eb6fd0, 0xd34b01e6, 0x78d57f3c, 0xb2969646, 0x3921aa55, 0x2d54f108, 0xe632ac69, 0x81836fcd, 0xb356e3ae, 0x638e2885, 0x81603e1a, 0xe283ee61, 0xf4f20feb, 0x1def8eff, 0x94c23301, 0xcdc0d9e2, 0xc4a16dca, 0x2a4563da, 0xfd2a7c10, 0xd3cb0599, 0x946b8cce, 0xa96d2cd8, 0x80a72764, 0x443f5862, 0xcd89c3c6, 0x36f4ba3e, 0xa3002725, 0x8c96fdae, 0x66894d9c, 0xabb929e6, 0x3b464d33, 0xe52c1e9b, 0x4476ec92, 0xbae65371, 0x43b0d9db, 0x93955eb9, 0x60c285a5, 0xac2024d4, 0xb9dd2ad9, 0x3ad91ebe, 0x2798215c, 0x3adcd394, 0xd5c4c81b, 0x1b9760d6, 0xa33d8826, 0x4e9fd281, 0x32556405, 0xab068045, 0xfb33ae23, 0x9da303a1, 0x6dfb81a2, 0xa0f12089, 0x86cee014, 0x9627aec1, 0x57cf96c1, 0xd25a2d67, 0xf32563f8, 0x6ee2cb35, 0xdf4a8e54, 0x5ebf759c, 0x11c7ef48, 0xda7c9fca, 0x2c5b6b2f, 0xf74f8fc1, 0x784b16bf, 0xf6ce88cd, 0x95d1b2fc, 0xb1f622c8, 0x791c679e, 0x7d085341, 0x2585eac3, 0x7887c083, 0x080b9ae6, 0x74850da8, 0x7c5fa762, 0xc27dc357, 0xf36d2639, 0x009980b9, 0x4137a2e5, 0xc1ed16f9, 0x2d62cbb9, 0x767b6ba7, 0x1b3f720f, 0x96744a7b, 0x6ea007d0, 0x3c9b38f4, 0x000a16f7 };
const u32 bern_num_data317[105] = { 0x1f5625b1, 0x66600116, 0xae6d9e2c, 0xaf072d6b, 0x409eb722, 0x345be464, 0xf81fccf4, 0x0452e5ee, 0x41684e26, 0xc7e501f0, 0x70812864, 0xf9f7c01f, 0x8ee23eca, 0x218094f3, 0xd0189360, 0x98dc8b44, 0x91614665, 0x03e03780, 0x7c8294ff, 0xe459cf6c, 0xdca908f3, 0x0fd262a2, 0x00809ee5, 0x6564b078, 0x41523fcc, 0xaf35abb9, 0xe1e3c36f, 0xede1950f, 0xbea084af, 0x3d6457f5, 0xbb6b1319, 0x404c8c90, 0xd60bf0e8, 0xd6b31fc0, 0xe321461a, 0x137806a1, 0x684b79e3, 0xccc2e9c9, 0xbf288a09, 0x38a39047, 0xd4acdf65, 0x24e86f00, 0x3ab1523c, 0x8a9c5200, 0x34d82875, 0xf2a6eb12, 0xc0b51739, 0xe608b8c6, 0xa029f1e7, 0xe0265ada, 0xdcd765fc, 0xb2a280af, 0x44ccf0c4, 0x73ae2403, 0x5765825b, 0x5046f1fc, 0x394f3e60, 0x42fa1bba, 0x85b08958, 0xaac2e00e, 0xbd97bc27, 0x9747aca2, 0xa9752b03, 0x80feb195, 0x6244d06d, 0x3e7648f5, 0x602b165f, 0xa359a036, 0x6a6a68fb, 0xac9c46c4, 0x0da735a2, 0x8502fa81, 0x2c298c27, 0xe3a06f47, 0x1a81a8dd, 0x4ad54fe7, 0xbdb2f3bc, 0x595948b1, 0x0a5a16fc, 0xbe49e3b8, 0x69b165a4, 0x9ce3f4ce, 0x87738140, 0x27b2cb9d, 0x9746cfd3, 0x14c8788e, 0x1c8f55bd, 0x8b53b8ea, 0x7f99c017, 0x478921cb, 0xf85b67de, 0x39f98098, 0x8ee36cea, 0x7f067f37, 0x2cebf40c, 0x9a43632f, 0xa6fb8aa5, 0x228698eb, 0xbe74c320, 0x5ca45ce1, 0xfaf2f79a, 0x0795a3cf, 0xc316689f, 0xfc688faa, 0x00012b84 };
const u32 bern_num_data318[105] = { 0xce69b33b, 0xdb0adf94, 0x60b35f9a, 0x20ba0a5a, 0x738eea34, 0x101edcd9, 0x22a2ef4c, 0x74f6b831, 0x15330447, 0xf357d5ea, 0x0bfdb16e, 0xf59f1d83, 0x3afd6b0b, 0xfef51791, 0xc0459b09, 0x7ade208b, 0xcae47a55, 0x7011dee8, 0xb4694b3f, 0xd80e8579, 0x686671fc, 0x68da2c32, 0x2ec03aec, 0x0d9c38ac, 0x3f8ffe7c, 0x60a282de, 0x2ff159e5, 0x354c6ac1, 0xde703bb1, 0x5762d72b, 0x77657c4b, 0xdff4bc5a, 0xa3f3b7c6, 0x86c656e4, 0x2d0fadad, 0xd7fad3a6, 0xda81c335, 0xd84f6838, 0x8fadda85, 0xa7fd9fa2, 0xd8f398dc, 0x258600da, 0x4055ed7a, 0x2493912c, 0x47eef9ba, 0x77fe7851, 0xad4806e9, 0x568540e2, 0x8690ea81, 0xd29bb636, 0x3f82d0aa, 0x2bdd8f0b, 0x80ebbc7d, 0x81f04cbd, 0x022e859f, 0x3a180951, 0x51193bca, 0xb46dd781, 0xfd85c8ef, 0x9929aaf2, 0xf440ed0a, 0x1df92be5, 0x21002bdf, 0xb3dbea5a, 0x9bd43072, 0x41c67947, 0x7e636ce6, 0x8fed01d3, 0xd6517230, 0x93b6225b, 0x65a6e758, 0x33cbd481, 0x84ca6d0a, 0xbf666437, 0xd0a89e62, 0x7b475752, 0x1b6405df, 0x9287dd7d, 0xd66aed4d, 0x55201916, 0xac49b445, 0xe4b9c35e, 0xd4fb8102, 0xeba6c2da, 0xe106d06a, 0xf9e81ecb, 0x7180ead2, 0x065d6d07, 0xccea7fe0, 0x9639e8a3, 0xf7c8dd00, 0xd2765575, 0xc1fa67cb, 0xe9db1d87, 0x0fd5499f, 0x17f1d7d2, 0xe2c5af58, 0x3581787f, 0xa554433b, 0x34634991, 0xe9300045, 0x71107641, 0x95b8dc9f, 0x0bad44c5, 0x014fb6ec };
const u32 bern_num_data319[106] = { 0x40f35d43, 0x9e3b93ff, 0xec081753, 0xcebdccd3, 0xd56e8579, 0xbd6f733a, 0x6c1369b7, 0xc9c003a7, 0xb204267a, 0x9b7ce76e, 0x30f6e9dd, 0x9389b909, 0x7efb2e8e, 0x4e8fe473, 0xca80b932, 0x0a57265f, 0x49880d69, 0x4ba8946c, 0xa62dca90, 0xbe21c94e, 0xdcbfe999, 0xed4a1be4, 0xc4a8f085, 0x38dd17aa, 0x1716857c, 0xf63982a6, 0x57ed9240, 0xbc382f72, 0x43400451, 0xb04cf39e, 0x6d03d133, 0x8706bc4f, 0xe669d0e9, 0xd3cc0fc8, 0xa8a09dc8, 0x437b861e, 0x792942aa, 0x73b1064b, 0x729e9bea, 0x4cec9492, 0x7e0b38bc, 0x957fa012, 0xe150b95c, 0xd80e418e, 0xa94cc5e9, 0xee5db2cb, 0xc3b8fe7f, 0x1b8878ad, 0x31c578bc, 0xb3beea91, 0x6d20e4ef, 0x42004f84, 0x453d95ee, 0x6dd79065, 0xa33c6eed, 0xe373ee53, 0x594cb81b, 0xb02a2f06, 0xd5fecd41, 0x3245ad71, 0xc5a08041, 0x9243681c, 0xcccb7f00, 0xb7b66c0b, 0xc5d42ee3, 0xc988bbc3, 0x5db8ef8e, 0x1ea68613, 0xa8ac1e70, 0x48ecc889, 0xdabe7bee, 0xe451c10a, 0x97108135, 0xdd76e9ac, 0xba7ec77b, 0xf837cb87, 0xd0630d53, 0x0d2add7c, 0x1967eba9, 0xdda0c929, 0x50f9bba7, 0x038f0443, 0x3b8aa106, 0x4974f1b6, 0xb6c63110, 0xafb3e81a, 0xf6a2d0bd, 0x9e416268, 0x87c4dec0, 0x58508739, 0x253abbbd, 0xa797efe8, 0x54ed48e7, 0x54fca509, 0x2b6b402a, 0x4540d746, 0xc68ee089, 0x0bcebdf0, 0x7ea88456, 0x95dc9388, 0x80d30a67, 0x73544be1, 0x210fb075, 0x32ace522, 0xfb4bdd5c, 0x000ea992 };
const u32 bern_num_data320[106] = { 0xb7b0196b, 0x7ad3401a, 0xd174dce9, 0xec5f454d, 0x8a1dd14b, 0x38fa9f65, 0x0d4a8fe9, 0x88cd52df, 0x9eb142e6, 0x8e485c13, 0xe9a31a18, 0x3e98bcef, 0x8a2112d7, 0x540ede4b, 0x82d3192f, 0x3528b98a, 0xfeb1dd5b, 0xdf4c88bc, 0x68a1b49f, 0x956a533f, 0xbfc91a10, 0xc461aca4, 0x878e9bd4, 0x31688ab3, 0x4fcea055, 0xd36f91a7, 0x091165b0, 0x910817a5, 0x3463df81, 0x7abacecf, 0x565962a3, 0x9f0064ce, 0x5e372f31, 0xd027b98a, 0xe3ffeee7, 0xdb88314e, 0xf2f3f095, 0x2f7f8212, 0x788a4c21, 0xc3e95cac, 0x6a518b9c, 0x1282c40c, 0x5660462f, 0x8ca0ef9c, 0xfe2ee786, 0x08b89003, 0xaac07ae0, 0x2c8a03e6, 0x1363fc60, 0x2130e2a9, 0xc0c792bd, 0x4adca14b, 0x2a8fea4b, 0x4c7f9c34, 0x41b89a7c, 0x01461d78, 0xb79d9521, 0xd2252b1d, 0x34e87bc6, 0xd7a3abcf, 0xb2eb0cad, 0xb9be120c, 0xf7cc3652, 0xee99a130, 0x074666b1, 0x96a064ac, 0xdd31831f, 0xcf3c7ebd, 0x529f33bd, 0xf21a525d, 0xf822edb4, 0x4a845df3, 0xe90424bc, 0x18ed6eed, 0x57c44c76, 0xb3c18861, 0xffdff210, 0x87b8b3ad, 0x39b03df0, 0x178ff9df, 0x1de26e0f, 0xdf822fef, 0xf5f2657b, 0xe67ff5d4, 0xfba4ce18, 0xf9ce6242, 0x18fa5ddb, 0x310971e2, 0x13715029, 0x6c7d08b1, 0xea6279ca, 0xa9b52bb6, 0x130f963f, 0x5db9751b, 0x0579989e, 0x3bf1677b, 0xa4a3ba92, 0x26df1f22, 0xd8a51d44, 0xa7e53af5, 0xc2ddf208, 0xbfd62c86, 0xe9981170, 0x65475c11, 0xec8f4ea2, 0x001bfef0 };
const u32 bern_num_data321[107] = { 0xae3d81bb, 0x12d03473, 0x0fd4aba7, 0xabe879e2, 0xeb3916a0, 0xf3747ccb, 0xec7e4bb0, 0xfe8b2e05, 0x32c22dcd, 0x49fd748b, 0x7db5cd6f, 0xbb88f075, 0x188f2e63, 0x30bbcd94, 0xeead4bea, 0xaacc5c7b, 0x02c8aff9, 0xd9d9cd9b, 0xc2251e3e, 0x25b9beba, 0x4763b2df, 0xfb595ce2, 0x2549c499, 0x6835142a, 0xd40bc243, 0x5d035642, 0xb87e0d6c, 0xeaa06572, 0x64054796, 0xbbb86c74, 0x2e8a6462, 0x9cca2162, 0x4ed6739c, 0x1091774d, 0xd9a8ad75, 0xd2d5bd3a, 0x428123b8, 0x9f8f93cd, 0x9316cfdd, 0xad6debe9, 0x0d922324, 0xd9da4782, 0xc7e0db63, 0x053b392e, 0xf3c5eea8, 0x39838ce0, 0x84e2d231, 0x425912fc, 0x4d8ea36a, 0xa318cfc8, 0xa8a96f1b, 0xf96061fa, 0x4ec61adf, 0x66a46a4c, 0xc070dcc5, 0x05a61659, 0x69e0ab24, 0x817513d8, 0x1d11753e, 0xa6080da6, 0x78aaa172, 0xe09b85b6, 0xcb75009b, 0xe5645de2, 0x6b3f9986, 0x1f1c35cc, 0xd58f7398, 0xff2a2cee, 0xdf5f98ed, 0xfefc9803, 0x981238b1, 0x886239a0, 0xea490923, 0xe56a661f, 0xe40ef458, 0xa3c81ae4, 0x9d9b4bd5, 0x2d0d0480, 0x4383a921, 0x10b38581, 0x2321aabe, 0x50292e34, 0xe53c1ef1, 0x0b10dc68, 0xf98d2e79, 0x58b62448, 0xa0d6d5d0, 0x12f293cf, 0xe631a5f7, 0x1c60acb0, 0xc586f665, 0xe1ab8cc8, 0x61456277, 0x9ec008ea, 0xa850b9f9, 0xc9ef8f7a, 0xb1c0fa4b, 0xe09b7ead, 0x00524cc3, 0x383fcd96, 0x0c1926c1, 0x114f2f33, 0xc07d59ee, 0x7b9ace04, 0xac84d0ac, 0xc8cacc96, 0x00000006 };
const u32 bern_num_data322[107] = { 0x4a444261, 0xf36bc93d, 0x100a9557, 0xdbe76f07, 0x75dbe142, 0x95eda482, 0xc51c6654, 0xd3219364, 0x1ea421e1, 0x7cf5e67a, 0x89f97a99, 0xd1956fca, 0x841e0fdc, 0x9dc4de4f, 0x159aa9ff, 0xbf418e71, 0x004f0674, 0xfb9e70ad, 0xa0c862c5, 0x6a04d4f0, 0x0c5759f6, 0xab899e7f, 0x57eae105, 0x80b0e22b, 0xcf8beaf4, 0x297f1036, 0x754bd9b4, 0x4d377e7d, 0x0f67f81a, 0xa7fa4976, 0xae0c20f0, 0x0f587917, 0xea80839c, 0x415741c0, 0xe68cbb4e, 0x75421b3e, 0x3e12c977, 0x0db400dd, 0xc9b11ffb, 0x6ce22521, 0x10444859, 0xa07038eb, 0x958de276, 0x720fcc34, 0xdc3ce079, 0x736f07e2, 0x3e1a0029, 0xe4451d73, 0xb14be372, 0x284a3ed2, 0xab269a91, 0xc1c5770c, 0x51927d41, 0x7936858d, 0x914a9498, 0x2875cefa, 0xf112d869, 0x01835071, 0x475c79bb, 0x03a697eb, 0x97c16309, 0x74d87423, 0x0aebe02c, 0x09ce1b72, 0x28248acd, 0xc123ec04, 0x5a1d7755, 0x7ffd4fcb, 0x5cb5c092, 0xf7f1664b, 0xfb475624, 0xa9ed9c9f, 0x19c5a1fb, 0x2f9aca6d, 0xd8fee6c1, 0xdec97dc6, 0x17569562, 0x20be1134, 0x9b8a1d78, 0x4d1a6a97, 0x1384c2a4, 0x1bd015a8, 0x8ee48f95, 0xb7c7c870, 0x9a53e2bf, 0x20d83f19, 0x2c7cf2bb, 0x318f13fd, 0xe33bc856, 0x7bde0a79, 0x67b7343c, 0x869a4976, 0xfe3393bc, 0xe6b375ef, 0x94410417, 0xdd19f361, 0x6f5063d7, 0xecfda4a6, 0xf968d2bf, 0x1abd7399, 0x087c6c9e, 0xa45c0432, 0x4df469fa, 0x312c08ef, 0xc56da95c, 0xf6922862, 0x00001a8d };
const u32 bern_num_data323[108] = { 0xf5e6af7b, 0xb9deb0a3, 0x4ed3fa54, 0xc3541600, 0x2361a84a, 0xcff340c2, 0xb4422905, 0xb4930e23, 0xcc47bc5e, 0xdebcd0e9, 0x47fda813, 0x653eeded, 0x8c929f45, 0x9e03611b, 0x97ff1bed, 0xb248f4cc, 0x524a019b, 0xeda479c3, 0x09004350, 0x1b7c3bd6, 0x790afed1, 0xd73e0461, 0x8c0bc4e1, 0xe57dd7aa, 0xe63b2c41, 0x8585e4f5, 0xa67f221a, 0x9b74043d, 0xcdbe76d5, 0xdbba8fd4, 0x991e0a8c, 0x25c10152, 0xb85499ed, 0xbfbb0a69, 0xbe409794, 0x2a58c2d6, 0xa21719cf, 0xa871c516, 0x2462e3f3, 0x732aa8db, 0x0132c3a9, 0x50899561, 0x0f05cad9, 0x8b30fb7e, 0x86caf459, 0x8688f1ae, 0x3285fde3, 0x52facea7, 0xa1315c5a, 0x61f9c261, 0xef2e0e48, 0x59e1da0f, 0x8b3f444d, 0x2c795c9a, 0x7beea66c, 0x85658ca7, 0xb4b1894b, 0x3c6a0bcf, 0xb37b8e84, 0x1e9f6099, 0xfcb054f7, 0xcf2b56cc, 0x0d608286, 0x83487f4b, 0x3b30ac86, 0x36353413, 0x35732e26, 0xc7cb0df4, 0x97bf1625, 0xfedcc1e2, 0x3e501013, 0x06f0af09, 0x7b9c472e, 0x9341ed23, 0xfca61473, 0x1ef0cf2c, 0x77537ea3, 0x167a539d, 0x53b13123, 0xb32a1439, 0x1ca04750, 0x3afc894a, 0x9ab1dc26, 0x07dac2a6, 0xc2891cf5, 0x2122c4cc, 0x8e74c798, 0x86d5acb6, 0xc486db2e, 0xb04be8fe, 0x280f6919, 0x913adae7, 0xfca4676c, 0x29a3f899, 0x44c0a548, 0x19dd0bd7, 0xf2182564, 0x609445cf, 0x30e96e7b, 0xf83f76ec, 0x23fe3fb7, 0xc221eb17, 0x873b28f4, 0xd5be4230, 0x50880171, 0xe3f61dd7, 0x0cefdd5e, 0x00a47589 };
const u32 bern_num_data324[108] = { 0x7e7e238f, 0x209692aa, 0xeb01c43a, 0xf1d5027a, 0x4636b888, 0xdc78c90a, 0xf567fbb2, 0xbc8b3276, 0x11a8b0a6, 0x1b8c6831, 0x39de0e56, 0xf332f86c, 0xa70b953e, 0x258eaa8d, 0x049d4174, 0xf3771c4d, 0x41188040, 0x540c50b7, 0xfa79a6d8, 0x52c0cc29, 0xd04b5c2b, 0x9cd8006e, 0xc72b1da4, 0x6a1dbd12, 0x6d88c715, 0x0fe85b70, 0x75aae88d, 0x5672e7de, 0x6267b2d7, 0xbaaa154f, 0xb503fdea, 0xc78bb501, 0xc3ccb88e, 0x0019cd13, 0x4e250cd4, 0x60777b0f, 0xd85fc2d6, 0x5d1e44d3, 0x0756ea53, 0x8b44d580, 0x6ae4bf1e, 0x9c5453dd, 0x78a06b9b, 0xd6b9789e, 0x68521a7c, 0x186593dd, 0x8a63bbf8, 0xcf607949, 0x197da1fd, 0x99f16b73, 0x574dc1b0, 0x8e90cb4a, 0x377b037c, 0xe3883b9e, 0x8e9cdae8, 0x51a4b215, 0x382d42ed, 0xac26bb24, 0x4d1f63d6, 0x5e50e4e0, 0x71ebf9e3, 0x808c229c, 0x2cde520e, 0x645865b4, 0xea9654d1, 0x3d86673b, 0x751d37e8, 0x86c33625, 0xa3aa5f17, 0x45ca2457, 0x1fbe9236, 0x16b567db, 0xe6510162, 0xed507755, 0x64ef8dcd, 0x7c6ce722, 0xd0076b34, 0xb11b6539, 0x7c9a131a, 0x25396c6a, 0xfce2b3cc, 0x492f7271, 0xc4208004, 0xe70fc8d2, 0xa2009f92, 0x8fb4b885, 0xd5509f61, 0xeef806ef, 0xc6cd9d40, 0xab03c953, 0xa5cb3412, 0xf24e7a9f, 0x3d3a8cfa, 0x36117fa1, 0x7fd8f5ff, 0xa1b75888, 0x6893cb53, 0x6cf28693, 0x1a5b67d1, 0x344c88e2, 0xa56cd2b7, 0x7a650996, 0x937f88f3, 0x1c226f81, 0x24722f8f, 0x4dbee06f, 0x089c8d13, 0x00000190 };
const u32 bern_num_data325[108] = { 0x52086c75, 0x9909c3fa, 0x17870564, 0xc07a84d7, 0xb554dd4f, 0x92745b34, 0x3c5f9096, 0xbee526f1, 0x551c2e7c, 0x91dfb7b3, 0xf932c916, 0x226b64cb, 0xbba7e51a, 0xa6a52b3f, 0x02bd264e, 0x9b9b0995, 0xa3445d33, 0x455f1499, 0xb8760d8f, 0x590a5d96, 0xb4b484f4, 0x9d815140, 0x2198cb92, 0xbe530dae, 0x9219978e, 0xfebb4252, 0xc471a26a, 0xa1083724, 0x80198440, 0x14b54c83, 0x1783b43a, 0xbf9c794b, 0x4f11968e, 0x7f178cde, 0x2a5883ed, 0x1c6d4a20, 0x037a411a, 0xa0008b92, 0x86de16ba, 0x46ffa37f, 0x033ba918, 0xc72d0156, 0xf6cdabfb, 0x3bff737f, 0xa4ff1a5f, 0x6ba7700e, 0xe3b495d2, 0x9ab12a44, 0x37a57dd3, 0x34d4add6, 0xb9a3493e, 0x46a21f4e, 0x9e06190c, 0x823f1e03, 0x3abcb187, 0x3b466d14, 0x98ad752c, 0x966baeec, 0xd9ead6e0, 0x990d8b45, 0x115fb331, 0xaebc1344, 0x82711cb7, 0x4fc66af3, 0x1703314b, 0xf2e914b7, 0xdc7f7ac6, 0xb3cae83d, 0xfcfc8017, 0x8b2cb58c, 0x5366cf52, 0x674a2060, 0x51e5e9a6, 0x0ce6bf72, 0xbb1ddbfe, 0xf852065b, 0x40716f24, 0x8fbf965a, 0x982b6ac6, 0x11d17910, 0x4b03a98e, 0x37ead023, 0x75968056, 0x8b5f8ac4, 0x3881b909, 0xf25ec654, 0xec0d30b4, 0xf18f1e74, 0x87737755, 0x2ef1050b, 0xe85c7ea2, 0x614ee9d9, 0xa0e9041a, 0x273d7134, 0x23d6c83b, 0x6d585941, 0x7c889df0, 0x92396c67, 0x9d76b808, 0x2b35a6a8, 0x72a9030e, 0xdbe48450, 0xe88fcb3b, 0xb37559e3, 0xef5b5442, 0x2d5bd5e8, 0x11864ff6, 0x0094b2a5 };
const u32 bern_num_data326[108] = { 0x05126931, 0x28165254, 0xa195af26, 0x0e3a25e3, 0x66d5da96, 0x427af579, 0x39ef7bc3, 0xda0cf011, 0x3ad13b9a, 0x5d2888d0, 0x6e582829, 0x3b77d867, 0x7f6a4bb6, 0xf49f55dd, 0x27406ecf, 0xbf150db8, 0xb84cc133, 0x52767025, 0x0e356670, 0x042c9447, 0xb8eb81a3, 0x1ec3c5ab, 0x369ed941, 0x8b5c42ef, 0xc8264020, 0x3454815b, 0x9a775e44, 0xa6eceb48, 0x9800b84e, 0xc2a4062e, 0x432db79c, 0x659c7a23, 0x87317efd, 0x3e6be120, 0x269e118a, 0x246931dc, 0x544dd51a, 0x2709bb42, 0x269b5bef, 0x01d1dbc9, 0xb2a7451e, 0xb0a58a99, 0xb253f15a, 0xed2cfada, 0xe4775625, 0xcbe8ac9d, 0xde159332, 0x51fd77fa, 0x9c9cba8a, 0x14b01ee8, 0x56c7abf4, 0x5d3a8fd6, 0x05179c14, 0x2b552b32, 0x78835b12, 0x0863efad, 0xd5282128, 0x97084a06, 0xb5c78bce, 0x61ac5872, 0xa55d1349, 0xe74847db, 0x0db596cd, 0x2a484b12, 0x75d7ad87, 0x4dc791c1, 0xf1f114b5, 0xa06ecf1b, 0xfc5890be, 0x1f906180, 0xc973d28a, 0xc0fb04a1, 0x0efb1c9d, 0xab1b3e76, 0xb178fa62, 0x1b47d044, 0xa1a20593, 0x3000fdab, 0x9d9cecc4, 0x82893e27, 0xbaaac823, 0x12ce10a0, 0xd61eb7fd, 0x8d73808e, 0xe36b47fa, 0x57304f4f, 0x30086c62, 0x2d703686, 0xd6f7dd47, 0xef0afb6e, 0x09604ff9, 0xecfcab48, 0x897b35db, 0x75ff383c, 0xb47a470c, 0x5713fa55, 0x9249ead8, 0x8cc613ba, 0x344d0903, 0x009f2821, 0x9a42a6cd, 0x44226047, 0x7bb84643, 0x4e74c531, 0xc2a94246, 0x091e4927, 0xda99b5d8, 0x0d78a992 };
const u32 bern_num_data327[109] = { 0x28e25bb3, 0xc70329e1, 0xde0b3f47, 0x0d1440ef, 0x2815c12d, 0xd4028fc8, 0xf39b713a, 0x35d825a6, 0xe9b38dcc, 0xb9a8cdb8, 0x54d25bf0, 0x4e4792ef, 0xb8247174, 0x6cbf9b4d, 0x723d599d, 0xfbddcb99, 0x2040ce4f, 0xfdf52e01, 0x0686f300, 0x5311b87f, 0x2a7c28e0, 0x7b039638, 0x6b3b327d, 0x64783bc6, 0x32713a75, 0xba89094e, 0x777b14b2, 0xaafdfb1b, 0x9a188b6c, 0x3ed90382, 0xa2190a3f, 0x20f0a0b8, 0xb9ef753f, 0xedc38e72, 0xf0366b35, 0x4dc28c54, 0xaf106cdc, 0x3f8de0be, 0x54a3366d, 0x69ba4a0a, 0xaf3389ee, 0x7f4410a5, 0xe7917c10, 0xd0d99f3c, 0x60e497e8, 0xf5895f16, 0x83496cc8, 0x84249c44, 0x8e8a886f, 0x0dd0e05a, 0x2b5879aa, 0x0ce91b4e, 0x5b7dc743, 0xa644d19a, 0x574974c7, 0x894a8356, 0xa6a602a9, 0xe49b4c78, 0xf919cf5f, 0x9037f9a2, 0xfe4b3d26, 0x00a71fa3, 0x440d958c, 0x100add7e, 0xcf7453e1, 0x72306bd7, 0x2992977b, 0xd863d3b7, 0xe9bd589b, 0xd7f707ae, 0x4b30eb52, 0x213ff118, 0xe933a7e4, 0x426619a2, 0xce327874, 0x3312a41d, 0x269ee08a, 0x36677333, 0x6e79117a, 0x99bbc2e8, 0x480a1cec, 0x9c7e53e4, 0x863e5d2b, 0x7d5a797d, 0xbfb6912e, 0x47bdaa50, 0x208af518, 0x1f189251, 0x86f63ff8, 0x15f5ad99, 0xbc3fc017, 0xa0e5ae1b, 0xa953b840, 0x35744920, 0x70b331d6, 0x0ebe9e27, 0x11e39608, 0xa3459bfb, 0x43398aae, 0x71f0d2b4, 0x39574998, 0xed4d402b, 0x39effb14, 0x22fa6d66, 0x4671d8e2, 0x3944c00c, 0x4f35a597, 0x4a584c13, 0x0008ced6 };
const u32 bern_num_data328[109] = { 0xb0af978d, 0x8928458a, 0x36970b1c, 0xdefaac99, 0x908e89d4, 0xafdd902a, 0xbfa33486, 0x243e7bc1, 0xc4c5b726, 0xcd1265d4, 0x9267afdb, 0xa7968e5d, 0xafada10c, 0x063b254a, 0x2477808d, 0x44a63752, 0xa4e09646, 0xc5120e46, 0xae2d5db7, 0xabc67825, 0x03dd4cbe, 0x3677387a, 0x494205b6, 0x746f0cc7, 0x18a0ebe2, 0x9be8b749, 0x47601c2d, 0x8b9fb0b6, 0xda043163, 0x374df28a, 0xeaef4edf, 0x605094f8, 0x695fe54d, 0x730559f9, 0xd5d2524d, 0x1565b056, 0x7f5e4aaa, 0x0346e034, 0x666e7e6d, 0x346563c9, 0xeb1f98c8, 0x3b58a165, 0x08acd3ee, 0x68b18c29, 0xcd0c26c4, 0x33012cdd, 0x59ccbc9b, 0xfe749266, 0x229541b2, 0xb02f6e97, 0x060e8caa, 0x5ba2424b, 0x20f185c1, 0xf70a2d30, 0x80978772, 0xe7061503, 0x379a3aa8, 0xb9845a67, 0xdfc1c9b0, 0x811307c3, 0x2fe5aee5, 0x8543d895, 0x0b761404, 0x0c48ad3f, 0x27fab9c4, 0x59bc8c7c, 0x1e946ea7, 0xbb7c602b, 0xf6142fee, 0xbc240914, 0xabb94e6a, 0x8fb99b49, 0x80648547, 0x5d5d7bdd, 0xfbbd0cd4, 0x825d4cb1, 0xf19c94e7, 0x2edc7a57, 0xe218e7d7, 0x78cd0b56, 0xd369346c, 0x4beafd98, 0xf4d9ab56, 0xc4f2fd5e, 0xe66c8f3e, 0x82a8b9fa, 0x00ee3c8f, 0xd96eeee2, 0x4e347187, 0x98a84afe, 0x64fa12e0, 0xbc1df33f, 0x66d5b55c, 0x091a2f5f, 0x456ebc9e, 0x0ea8f7ea, 0x6db006d1, 0x61e78b9f, 0x0483c07e, 0x057c3ca3, 0x0a52a110, 0x56e3062f, 0xea98de9a, 0xc3dae294, 0xaf59fed4, 0x0fc254fe, 0x0a77f372, 0x74390c68, 0x23316271 };
const u32 bern_num_data329[111] = { 0x6378cfa9, 0x914cd41f, 0x6708299e, 0x5822bc78, 0x177d836c, 0x0f0b2d1f, 0xf21cb196, 0xafba1717, 0xb218ec6d, 0x7b1d2e78, 0x481f8e5b, 0x2f459016, 0x668e351d, 0xf4e63a6b, 0xe6dc5735, 0x885322e8, 0x3bda9f10, 0x4bed1cfc, 0xd4893347, 0xf64d2d2e, 0x89a78ec1, 0x6f61358e, 0xb356bf50, 0x485c97fe, 0x0ad35c25, 0x13e22d8f, 0x55b759c7, 0x7ad1bf0a, 0x1b78084f, 0x61045ceb, 0x5abb2240, 0x5589b9ee, 0x56ff56b8, 0xf49f887a, 0xa5699e8f, 0x7e911f35, 0xaef4e322, 0xf09a7c50, 0x1e0fea53, 0x6f259bb7, 0x5c8f2ea3, 0xd2aa279f, 0x79bcae11, 0x723a200a, 0xd039c237, 0x1061a95e, 0x0d506ab7, 0x5c6cb05f, 0x7ebce51c, 0xd69bf3a8, 0xc86a5c54, 0xe1821ea5, 0xd4b887dd, 0x80a64dba, 0xa1fc67dc, 0x06d8b54b, 0x9e138463, 0xc1fc7093, 0x8191a160, 0xdaeb944a, 0xdc00e5a1, 0xf7430508, 0x3b62d808, 0x7aae7d2d, 0x4917c71b, 0xd94fcf4c, 0xf4ecd9f4, 0xefe941fa, 0x64c461b2, 0x46f750b2, 0x31da324b, 0xae17ec61, 0x091311da, 0x84b258e8, 0x090a3e61, 0xa55c8933, 0xd3061442, 0x5c99976e, 0xec9463ba, 0xbae028ce, 0xa8288b0f, 0xbaf32d72, 0x43cbb2dd, 0x3724be12, 0x8cddc1e6, 0xea29243c, 0xb5fa856e, 0xe079b64b, 0x1abdbd53, 0xd7b8e00b, 0xad54e888, 0xc62f34b0, 0xa09fbd2c, 0x54526f37, 0xa7aaa757, 0x45f25cdd, 0xbd993d90, 0x0bde0d15, 0x896aa439, 0xa134885c, 0x8ba75c17, 0xe66a155a, 0xda3cc552, 0x0778880c, 0x0122d9be, 0xa977ffd5, 0x58a725cf, 0xba5e8d18, 0x1c2894c3, 0xa3d62219, 0x001a0e05 };
const u32 bern_num_data330[110] = { 0x04765237, 0x2c849470, 0x60c55bbe, 0x543d9c49, 0x8b428b75, 0xccd65de8, 0xa90f2a8f, 0xb8689c93, 0x949cc53c, 0xb5364919, 0x26391ff6, 0x37dba9b0, 0x6a7f53a7, 0xb2d35d71, 0xc279e08b, 0x48c3b921, 0xac4a1c18, 0xed04b0c1, 0x95520f29, 0xf6e7b1a9, 0xdb2beb2c, 0x4a6dcd4c, 0xbbdc02a2, 0xbe9f5f0d, 0x618295c5, 0x7c93a4a9, 0xd6b120a0, 0xfe98bb94, 0x738c75e6, 0xa5ef69ed, 0x24c38b9b, 0x0f3ade1c, 0xe59e0f29, 0x699542ad, 0x10c62885, 0xe4b5acb9, 0xaaa5827b, 0x6aa344b1, 0xc224f1a0, 0x2c299abd, 0xd3019485, 0x86750930, 0x3cb9a3a9, 0xc358115c, 0x99aab953, 0xa5eb743a, 0x761c2544, 0x04d8987b, 0x0eb1758a, 0xec688823, 0xdda7662e, 0x1f99e44e, 0xb8138e5e, 0x82afad90, 0x547abd65, 0xa35f4723, 0x68d425dd, 0x34163f5c, 0x2e8a578d, 0x44bf7e30, 0x35006d77, 0x8d52a1f4, 0xa3c07787, 0xff67cdd9, 0xbb273ecb, 0x0ae06973, 0x333f5c28, 0xf1a011e2, 0xb8d1496f, 0xb8b8fb8d, 0x643b815f, 0xb464b47d, 0x3969c7a0, 0x4c106bc0, 0xbcdb0c32, 0x5dc7a235, 0x296a6347, 0xb6b717f0, 0x9c3fe666, 0xf954a588, 0x95c9bc12, 0x925680a1, 0x038a4388, 0x477c9451, 0x6bec0465, 0x144fe0b8, 0xcdd634d1, 0x79d1223d, 0xd8af0cb4, 0x6271dd08, 0x14142286, 0x5ee99c70, 0x70e2bf34, 0xd229a680, 0xa7c5aba3, 0xed19daf3, 0x29a83bd9, 0x5f13bbb0, 0xac71b1bf, 0x1bac2cdc, 0x07131bcb, 0x10654edf, 0x9f89f013, 0xa6f6073b, 0x0ac251b7, 0x0f657dfc, 0x466bf8d2, 0xc3b371f9, 0x1d6ea1a7, 0x00006382 };
const u32 bern_num_data331[111] = { 0x92a4ac07, 0x94843e4a, 0x71f06105, 0x1d3f3115, 0xd86a4127, 0xf3069575, 0x6310d998, 0x9ebc9dab, 0xf8f387e9, 0x5d23fde0, 0xa2b006fe, 0x8a39be32, 0xe59378ac, 0xa73b1970, 0x26c78dba, 0xa4158312, 0xe012fa46, 0xe6185473, 0x288091b5, 0xd5930f66, 0x8db80421, 0x2ea61a36, 0x6d3af9f4, 0x6a5f1e94, 0x7f0fe226, 0x6ac56410, 0xb72fb6f5, 0xd5e9c0a4, 0xfe7b2d9f, 0x42ada775, 0xcfb55a61, 0xe2b53a1e, 0x34e660c1, 0x7e1ea685, 0x67ed532c, 0xb94ba16d, 0x89da2906, 0xa08df870, 0xb7609d86, 0x65265bb9, 0xed4e9137, 0x09f70140, 0x3d523701, 0x3a8ae6d3, 0xe7b9aa5f, 0xf7249f3b, 0xb7487fc3, 0x158cd2c1, 0xebfa90d6, 0x3b1d1afb, 0x67ccdfc4, 0x5d5869c1, 0x80823ef9, 0x5d7a3755, 0x12da1997, 0x7eaa9ee5, 0x756ea09f, 0x6d90c561, 0x94f05756, 0x3099b226, 0xf032cfb4, 0x9fa4304b, 0x54af7ae0, 0x773a1ab9, 0xb0f4d89a, 0xa388ae77, 0xaec805a1, 0xb03d93e6, 0xe5baa350, 0xe05d1e52, 0xa946267a, 0x89718bfe, 0x01a16e9f, 0xfc5e4f30, 0x66a45c8c, 0x342906dc, 0x13790641, 0x13811925, 0x54d1b42c, 0x17c90995, 0x6f1a7c76, 0xfdce1377, 0x94a6b984, 0x477a136f, 0xb7fe29c3, 0x34b1f902, 0x35f3fb69, 0xe8a90f12, 0xeae36f26, 0x0f63d055, 0xe426d2a3, 0xd82824ef, 0x2a0774bb, 0xd4c1117e, 0x96ff297c, 0xebb778c9, 0x4e4aa7bb, 0xe5c29e39, 0x31d46eb9, 0xe16783ef, 0xaf363d3e, 0x62bd777d, 0xa5e7de63, 0xd5add99d, 0x7446ff9a, 0x91f3059c, 0x6a86e8f8, 0xaaa99a6f, 0x0d22f485, 0x39fc7b46, 0x00000037 };
const u32 bern_num_data332[111] = { 0xa3467255, 0xaeaa9e0c, 0xb7f1f39a, 0xd9c4414a, 0x8e843caa, 0x4c500617, 0x9825b6dc, 0xfc7f221b, 0x44d470fc, 0x4fc489cf, 0x60770506, 0xca1210d6, 0x042523de, 0x00680408, 0x2274c29a, 0x3100073b, 0xbaad2625, 0x0172564a, 0xd7bb6699, 0x1b275a4a, 0x6ebf5ae8, 0xbfc83307, 0x2ce0a6ba, 0xfafac464, 0x50d5e4bf, 0x809c497a, 0x7c3785d7, 0x3d2f6a8a, 0xb109373c, 0x8fd73f80, 0xd5132dae, 0x7c0f4b5b, 0xbf6498af, 0x8eb017db, 0x59adde49, 0x3e55021e, 0xfe87983b, 0x40c33678, 0xe963e779, 0x3ed01cd3, 0xbe62eee7, 0x7410304b, 0xe99b6777, 0x0501f6fb, 0x254b3c9b, 0x70b8bc37, 0x0187ec9d, 0xdf6b9137, 0xe2a13732, 0x15d917a6, 0xe7e36132, 0x9201c8ab, 0x495c7252, 0x7a2df164, 0x7d8957a9, 0xb6de0674, 0x7a860f85, 0x6410c139, 0x5d33fd32, 0x02fa1f6f, 0xed00b07c, 0x2a59dc51, 0x691b63a3, 0x559315d3, 0x6be65da6, 0x9396b4f4, 0x86f75c0b, 0xef1166be, 0xfacf56ca, 0x23ab7b19, 0xdae69799, 0x98ac4808, 0xb544a53d, 0x8439333b, 0xf7f39a42, 0xbcb8229c, 0xa5f1a04c, 0x44e99568, 0xeea2dbb2, 0xcb9e91ef, 0x03645770, 0xd030039a, 0x7c75d868, 0x6eaab1da, 0xe238502c, 0x6af92118, 0xeb346f1a, 0x7b9b19a2, 0xba8eda6a, 0x39311dec, 0x10a54683, 0xb4b32c34, 0xa7d19c41, 0x21ba8037, 0xed6d37a7, 0xfc391eb6, 0x84a1271c, 0xdc5c7828, 0xbfd87450, 0x6369dc48, 0x32a0a8f2, 0x5bfeb369, 0xc58fabec, 0x50bd9333, 0x354ae8a0, 0x50ebf9e3, 0x1d9db7a9, 0xc6d82364, 0x1256ab5a, 0xddc05835, 0x014fcb70 };
const u32 bern_num_data333[111] = { 0x5294e2a9, 0x7475e735, 0x6e312f60, 0xbb4e3082, 0x516ab8e0, 0xf66c2387, 0xca58e202, 0xe6d5f767, 0x4b5629a5, 0xa00daba3, 0xdb7ab19f, 0x479d770b, 0x61f76b27, 0x674f43e3, 0x5b474792, 0x2296d12d, 0x94745dd4, 0x233dcd51, 0x65f13ae2, 0xb2f1442d, 0x3aa49f32, 0x1bbf573d, 0xa55ada98, 0x067257fc, 0xe6415a21, 0xd6860c2a, 0xfc181555, 0xa08ae6aa, 0x694c93ef, 0xff12018e, 0x2d8647d3, 0x263d8b1d, 0x516efe71, 0x5dc5d7ad, 0x3d388c0c, 0x433fdc22, 0x04d0a452, 0xd011b020, 0xfa89a6f7, 0xe6b8a2d8, 0x2e59ab6c, 0x9b57b8fc, 0x827ee2b4, 0x198947bc, 0x53fe6676, 0xfb70b5a3, 0xae0d4f7c, 0xa20d8550, 0x1f6446ae, 0xe0c5274c, 0xdbed0c0f, 0xa76433f8, 0xd9cf9d66, 0x93c67116, 0x6a9be06d, 0x21f56b87, 0xe07f09c0, 0xdff57d6f, 0xbf0800ba, 0x0b352389, 0x90bfa582, 0x9adf97e3, 0x5d6df043, 0x76b17efe, 0x932ea729, 0x7d1e54ce, 0xbef39a0d, 0xcaa0fb6c, 0x518a7056, 0xdc4c2536, 0xa97ac89e, 0x1ad0a172, 0xe3fb6904, 0x34ceda92, 0x05558099, 0xbcef0b84, 0x6b2f3fc0, 0xc2be9e01, 0xe62a6f1e, 0xbfd81c29, 0x09b5400d, 0x13534f5e, 0xcb355708, 0xf2ebabc1, 0x947bf654, 0xbf0523c7, 0xd3eb889d, 0x23bfd0ce, 0xd11469b7, 0x0f598b62, 0x4c2aca2e, 0xf05bce4e, 0xcf620dbd, 0x29d63d54, 0x78aeee3e, 0xfaeb8aaa, 0xd26f23df, 0x7337f226, 0x72986118, 0xddbefeea, 0x605ae00f, 0x79350d8c, 0xc22c53f2, 0xd9798b47, 0x44c3eedd, 0xcb85a518, 0x470d787b, 0x1393eec6, 0xe84e9be8, 0xe95040f4, 0x027ee544 };
const u32 bern_num_data334[112] = { 0xb9a2e96d, 0xc516d90d, 0x35b6169a, 0xb09ff37a, 0xa9532e76, 0x2d366cbd, 0x8d876aa6, 0x649b932d, 0x44d30894, 0x66a32ee4, 0x8974eab6, 0x6a9b1778, 0x13799c5c, 0xc3d67057, 0x41a7d538, 0x91ef5dd2, 0xb3214d1e, 0x8be0938d, 0x6e9d333b, 0x88e4ef56, 0x30281aab, 0xf9f8829c, 0xff3a1039, 0x66869dfc, 0xbcfbe960, 0x83d62a8f, 0x1c20d292, 0x66fcc762, 0xe27cb1aa, 0xe27ea3e4, 0x48280b5c, 0x58beed24, 0x11533a0e, 0xfc3960fb, 0x02d10af3, 0x20012c05, 0xeee40af9, 0x11a0bd07, 0x50df2f87, 0xc0c0a4cd, 0x7d2f7ed9, 0xe66ee1e8, 0xb7df32b0, 0x0f87cb29, 0x395f7ca7, 0xe97c89f0, 0x81603a4b, 0xa7566237, 0xd3c6b6a2, 0x7744918e, 0x5301e71a, 0xda828869, 0x13d24aa4, 0xf5653ccc, 0x98f37bbe, 0x44c24bb5, 0xb1dfc0f2, 0x9597a17f, 0x61e48e8d, 0xb8e53551, 0x5e137de6, 0x94f13028, 0x0bb82739, 0x2b5a60f5, 0x88e46c08, 0xa2ae286b, 0x39ec16f6, 0x7a30ae84, 0x6aefd17f, 0x57a99788, 0xd487a59d, 0x947cd323, 0x1d158cf8, 0x1d2b5ca4, 0x1ced2536, 0xdc4e5f12, 0x1f57ece4, 0xe12fc860, 0xd7b4816b, 0xa88bac3e, 0x985ad051, 0x438b3dd9, 0x65614de9, 0xd28409b8, 0x3361dc35, 0x9983760d, 0xbb8db10b, 0x9f5d93c6, 0xcf4f21b7, 0x9c4581d5, 0xfd557f01, 0xdc47b7ca, 0x9f5c5279, 0xa58aac4d, 0x07335884, 0x39a6e765, 0x5be70b08, 0x2cc10713, 0xc823b765, 0x632ba834, 0xcb84997e, 0x80194aed, 0x49a5b442, 0xaa012e08, 0xe996ec9e, 0x0337101f, 0x65a69bc0, 0x2a9da119, 0x03d0a79a, 0x7d7cdc6d, 0x8221cf89, 0x000000f3 };
const u32 bern_num_data335[114] = { 0xbdc0e945, 0x7505c21f, 0xfce3e219, 0x4a33ad34, 0x489c96d9, 0x53ec95b3, 0x6b58aedf, 0x44c8601d, 0x79a4705d, 0x45256dcb, 0xfc7a513b, 0x9cc2fb0d, 0x1b4b5557, 0x67f777e9, 0x5eea39c4, 0x8ed71cc6, 0x7e43621b, 0x646d5778, 0x431d11e3, 0x0ea4e1e3, 0x4bfbb1ff, 0x684d822b, 0xcfcfb6f2, 0xe8f0f623, 0x1c4f13ed, 0xab8151da, 0x0272e1a9, 0x010d6e45, 0x52c980b0, 0xa41236fe, 0x66816859, 0x438daf00, 0xc1f31d14, 0x8a329c08, 0xfe328637, 0x7b19b35a, 0x1a751fd5, 0x2bbf8324, 0x6a04186d, 0x7cbc49bd, 0x8e81b518, 0xb16e73ea, 0xd4b9ddfb, 0x16f7a355, 0xfb8082be, 0x0245b3bd, 0xb65dc942, 0x2335bf58, 0xdaa4e930, 0x93747806, 0x785cc1f7, 0x70b125e4, 0xafa16ec9, 0x097b60d5, 0xfed635cf, 0x5c593754, 0x060cdae0, 0x84121dcd, 0x2f9c2156, 0x6bd20596, 0x75f21ae3, 0xde72470c, 0x5a693147, 0x609eb12c, 0x5c508fb2, 0xc3932fca, 0x566fcf81, 0x8dea3cb5, 0x4d577011, 0x36137273, 0xcf3fb18c, 0x61ec779a, 0x03238161, 0x16e89d80, 0x8e192427, 0x150c8b51, 0xf5268b90, 0x672de6a4, 0x0e072841, 0x9530ba24, 0x0895cee3, 0xa190de6b, 0xd85814bf, 0xe0a1cefc, 0x2e1b632a, 0xa5e63bc0, 0xff71d57a, 0xcb5db1f5, 0x51a397e9, 0x3f98c129, 0xab880604, 0x1c61de56, 0x4e026b02, 0x8e19efac, 0x8709331f, 0xaf35bcfd, 0x3802abd0, 0xc03d7081, 0x98874253, 0x23b46c9f, 0xdbc30c6a, 0x0906b5f0, 0xd878f5a8, 0x0afa80dc, 0xc655e1ae, 0x9e3e861f, 0x366a92e3, 0x3297e333, 0x1aa18c66, 0x3033c894, 0x743137d7, 0x8e52f7e5, 0xaa9ce662, 0x00000148 };
const u32 bern_num_data336[112] = { 0x8a4e8bbf, 0xd47cb8c6, 0xf0326fa8, 0x6fdfe8c2, 0x98a6a004, 0x4024546d, 0x582d8ed1, 0xd2918460, 0xb13353ff, 0x8e5fcb5b, 0x486bea68, 0xa054117d, 0x399ba99b, 0x38d32be3, 0x57715991, 0x35928b35, 0xce8bd3da, 0x05b97eba, 0x9e23e319, 0x41ed931b, 0xa5f5b1a6, 0x223342be, 0xdc397bb0, 0x7ad70977, 0xed272d1f, 0x8122de72, 0xf564e467, 0x8526ba72, 0xd3177b3d, 0x01ee479d, 0x0e77c436, 0x1a3042bf, 0x6f525635, 0x092835ba, 0x439f71c5, 0x15a43d7e, 0x5314b192, 0x51ca630c, 0xa97df395, 0xab56fa78, 0x8df98564, 0x34c98bb8, 0x175f621b, 0x6480b167, 0xc269deae, 0x429da75e, 0x5e3dba9b, 0x4f09336b, 0xeb7e45dc, 0x23695bd4, 0xe160305d, 0x60066f6e, 0x0eefd9fb, 0x6b5a5cf7, 0x15d6e92f, 0x8e06ffc3, 0xad2bc458, 0x0943af1c, 0xdc003ade, 0x034e0376, 0xf4f74271, 0x61923177, 0x2e1ed10d, 0x1ec611b7, 0x51e16c4c, 0xd8c420a9, 0x097432fe, 0x95d15f5f, 0x9ac317aa, 0xd1856bfd, 0xc7e87f7a, 0x22a769d4, 0xcee28c59, 0xbc2e99bb, 0x899f4ee6, 0xdf7db870, 0x66b43343, 0x1a9f1ad5, 0xa00463a8, 0x97998432, 0x1e25d0c5, 0x0c526b01, 0x78c71d56, 0xc26e8f2f, 0x538f1a78, 0xd05d9084, 0x3e273e4d, 0x7177ca19, 0x8d3d67b7, 0x6766648b, 0xb298e13e, 0x79f3f53c, 0x96350ec9, 0xb9e1bec3, 0xc34e6d8d, 0xa73d87fa, 0x87e893bc, 0x8b300561, 0x73423cda, 0xc00794a1, 0x81430ae8, 0xc1a61295, 0xcb36937c, 0x56e17929, 0xce08233c, 0xaf35e1c4, 0xf24d11d3, 0x6be8e108, 0xb21fe651, 0x1bd8d6b4, 0x3f3bcae7, 0xad290e5e };
const u32 bern_num_data337[113] = { 0x38357821, 0xaa4cb8e8, 0xdb1e1d6b, 0xbce6beaf, 0xa8d484db, 0xc5ea32d6, 0xab74a3ab, 0xbbdaf6bc, 0x1526dff1, 0x0eb1c67a, 0x4fb6b37f, 0x36194075, 0x65dd67f8, 0xb2d17c23, 0x6a75aae1, 0xbb686635, 0x0991c021, 0xfb00fd07, 0x783c70a5, 0x90db251e, 0x181391c9, 0xf295e939, 0x77fd9919, 0xf6e0d2be, 0x7c37b660, 0x5b89b111, 0x51f7a48b, 0xa64388c8, 0x5d206224, 0x558e6793, 0x242feb0f, 0xf1403a14, 0x9ed2972e, 0xc9b5c851, 0xc89e3c70, 0xa25c8609, 0x6b646c94, 0x8d63b0e9, 0x63123d4f, 0x94f48b84, 0x47c9ee59, 0x6cf05a37, 0xb657c093, 0x1b0e47b1, 0xb5abc620, 0x91a775ad, 0x9ca8af78, 0x13e832f3, 0x7a2e77c9, 0x0179be3a, 0x32d8c92e, 0xe6d5f888, 0xbff42807, 0x56ca6793, 0x0aaf8630, 0x450804cb, 0xb16ab54a, 0x658c702f, 0x088379ae, 0xaa1e7ec5, 0x9ad7ca86, 0xef6d54ae, 0x86ecb67d, 0xc8810f0c, 0x4f36ba47, 0x7c02cd92, 0xce28a5e8, 0x97444997, 0xe8e90e37, 0x2129ffc1, 0x6b5afedd, 0xb250543b, 0xe715e231, 0x8786cd11, 0xec5aab1b, 0x78000ad6, 0x0bb74976, 0xf1163a98, 0xfbb75028, 0x09d72011, 0xd136c823, 0x395315bf, 0x1c9b9aba, 0x5e878fe2, 0x79a5e356, 0xd0634377, 0x79da4e7d, 0x6c3cdfb8, 0x4d7c3ceb, 0xd2b468a9, 0xa98ebe68, 0x4674f570, 0xac60a579, 0xcbb6b08a, 0x2c199cd6, 0xc7de4fb0, 0xbe7571fb, 0x8a2bdc21, 0xd5f0ebc8, 0x682644b5, 0x8ae4b74f, 0xa3ab9c34, 0x67590ed1, 0xd53904ee, 0xc25da610, 0x948b7957, 0x83d8c87e, 0xfeddace7, 0x4950c0d3, 0x5b58c6d8, 0x96b288d5, 0xa28c2e03, 0x5399fa2b };
const u32 bern_num_data338[114] = { 0x425be743, 0x68fa851a, 0xc54f9ac8, 0xd14bd376, 0xe4dbc0bc, 0xd05fc8e7, 0x853d8391, 0x1d0cbff3, 0x7bbe6ada, 0xc2d69077, 0xc06efeeb, 0x159b3bf6, 0x5da584b5, 0x40611edd, 0xe240b902, 0xec1e84e1, 0xe66ae49a, 0x9bf3cd2d, 0x23264944, 0xd76830f5, 0xafece1b5, 0x48a3e593, 0x9f010a9c, 0x2dab14a5, 0x61db450b, 0x4a5b5978, 0xa251b91a, 0x80b2f7b2, 0xfb04bfc7, 0x8fcd2ff0, 0x589f1518, 0xc6ac55d8, 0x80da9a5d, 0x330170da, 0xbcc825a6, 0x293ce4ae, 0x6ef443f3, 0x11d25298, 0xadaa611c, 0x6e2f21b7, 0xd9d67d87, 0xa754f4d3, 0xcb854cbf, 0x72fd628f, 0x59270ca1, 0xea358858, 0xed3b3bd1, 0x1c3b1afc, 0x40c66ecb, 0xf28b1587, 0x336752df, 0xd43418ec, 0xeee7b4db, 0xf38e5444, 0x5e4fefb8, 0x4687130d, 0xee09ea6c, 0x1882c832, 0x6876fc89, 0x04f0a2f6, 0xfc3435b9, 0x116a3b15, 0x8bb0de1e, 0x2f3692ec, 0x0d933d38, 0x671ebbb6, 0x25b73859, 0xc20c0404, 0xd65dfd06, 0x2014d404, 0x26a12c26, 0xa3248b33, 0xa9207220, 0x6b874356, 0xd629ad67, 0xcb1845a0, 0xe1aad886, 0xff80dcfa, 0x240cf3a8, 0x07645894, 0xb083f684, 0x07c853a0, 0x9be40873, 0xa8aea358, 0x2fed333c, 0xdd99596d, 0xa37a35ad, 0xb5b9ad48, 0x63ab73ed, 0xfc2b06b7, 0x4c6cc7bf, 0x1620fc91, 0x1a87eab0, 0x6357985a, 0xec071fba, 0xd80b5011, 0xe28fbe59, 0x237f4374, 0x94a5e9bb, 0x76312570, 0x34e15660, 0xf7adb128, 0xfcec0bfd, 0xcb66d8a6, 0xf861d385, 0x211256bc, 0x98f4fbf8, 0x8e7e1eac, 0x3f8812f3, 0x170486f7, 0x1e3afad8, 0x2adc5fd7, 0xa12eb667, 0x00000021 };
const u32 bern_num_data339[114] = { 0xe8ede79b, 0xdf08eb54, 0x590d2325, 0x0b1d2840, 0x27cc47c0, 0xcac873f6, 0xc5ab830e, 0x15d261d8, 0xfc06697d, 0x2d7ba5f2, 0x8e9ec0ba, 0x2a9653f6, 0x5ccea8ed, 0xf8d7ced2, 0x70a03f84, 0x31b1d6c3, 0x1e37216e, 0xa5debb9d, 0x23c1d429, 0x18b47e01, 0xf4c58589, 0x4c841c6c, 0xeb9998b5, 0x24d9fc84, 0x7d2a60a4, 0x96f5bba6, 0x4db6a555, 0x953d3285, 0x9623a994, 0xed7dea76, 0x718378c9, 0x394b613e, 0x245f0dc3, 0x89f2fb9a, 0x2b8e5ac3, 0xe4f6babd, 0xc8753811, 0x3b5552e0, 0x1d8b36ee, 0xdd35e61a, 0x238b0274, 0xeb0bf1b8, 0x562d3d02, 0x2537addd, 0xed5de9d0, 0x01fcdc52, 0x393d8456, 0x19a9e4be, 0x28d92079, 0x124dc676, 0x7c6519d4, 0x88bc3150, 0xdc1a75b9, 0xc8009534, 0xdb4b57e1, 0x609dd335, 0xba3b3f78, 0xe4fc306b, 0x61ae8786, 0xb4196893, 0xdc29f1d6, 0x1f641196, 0xef7ea9d3, 0x0be91f6a, 0x6021ff97, 0x2028bfec, 0x68c8ffd6, 0xd990e27d, 0xc00ca7f0, 0xd3694053, 0xc8e135b0, 0x4f2d644c, 0xb40c8d4b, 0xbc245d57, 0x05a1dbb0, 0x3507d51b, 0x83694d3c, 0xd11280ac, 0x9f6c4293, 0xeceafb37, 0x3cc64cdc, 0x4d1a58d3, 0x797e48b4, 0x2c1637f7, 0x7297765c, 0xc41c3253, 0x8e7d1c21, 0x90d6b5d0, 0x101bfd8e, 0x449e137e, 0xb50ef35b, 0x784a5849, 0xaf00bfa2, 0xc67b13ed, 0xf84e24fd, 0x815b702c, 0x660374fe, 0x34130d80, 0x5d488990, 0xf1112983, 0x848bd759, 0x6cb3d7ff, 0xb3ce9027, 0x7676d8d2, 0x30207961, 0x45c60874, 0xafbbc057, 0xb10b6473, 0x0a6c3392, 0xcbb3a37f, 0x6feaa70a, 0x84204435, 0xa0bba1bb, 0x048ed223 };
const u32 bern_num_data340[115] = { 0x41501cd3, 0xb42b7915, 0x134e3a5f, 0x7476185d, 0xd3f190b4, 0x7b7012b2, 0xfe9aff71, 0x4628e815, 0xc7addab7, 0xd1e7584b, 0xd39b8d47, 0xe8997687, 0xfdcb3c16, 0xe06d1ba7, 0x7f79ae63, 0x5109aa8d, 0x080e8f5c, 0x102ae115, 0xe1a44d1f, 0x68c925e9, 0xbccb3ee1, 0x24ffd42e, 0xb548709a, 0x1382ccbb, 0xea0c5222, 0x2812b9fd, 0xe2a44301, 0x8270ac3b, 0xde8def38, 0x94d294c0, 0x71cc49e8, 0xffc49216, 0x688725f8, 0x1b1c57f0, 0xd01effaf, 0xe268e223, 0xd58c4610, 0x6f609ad5, 0xab3c9155, 0xf58d04b2, 0x03ca81ab, 0x1c6ab83e, 0x1f5ede9b, 0x09583755, 0xda28d7b0, 0xf34680c2, 0xdbaafffc, 0x1fdcb6b4, 0x10cde432, 0x1fe63127, 0x508a257e, 0xfe5fbaba, 0x3e4512c8, 0x420c4224, 0xdf879f92, 0xacef2366, 0x3315f0bf, 0x1c2bd51f, 0xf9e1b6c1, 0x297acc26, 0xa4fc8c15, 0x82125b62, 0x4b8ce8e8, 0xb24c2782, 0x0bbc4863, 0xfc527972, 0xcba0d662, 0x2f3481f6, 0x12b30f56, 0x1a1feaef, 0xa4637cb8, 0xc0d21cab, 0x1afd6eef, 0x5fe722f5, 0xbe180bdb, 0x8824d508, 0x916bcac9, 0xd9aab32a, 0xdc1f9c6f, 0xfca44fd6, 0xb4617768, 0xdf3f0d0d, 0xa1a741f4, 0x75d6cde4, 0xb428da14, 0x9e3256ab, 0xada66bf8, 0x4eca8836, 0xa5bed682, 0xfd6139be, 0xb8ab38df, 0xd0a4ed4e, 0xc9101584, 0xa62b0f79, 0x2b456b90, 0x7b8393c7, 0x5484731a, 0xfd4a53dc, 0xabb59ab7, 0xc9c2909e, 0x87f52480, 0x8671f054, 0x41c1da87, 0x614b7785, 0x6808a61f, 0xf7fb1d87, 0xad21f864, 0xcedf1fc3, 0x0b08f631, 0x585a2e21, 0x3b54345e, 0xd364a3aa, 0x0d6baf27, 0xa6931ce3, 0x0000000a };
const u32 bern_num_data341[115] = { 0x2ab44461, 0xf6bbdf21, 0x69b62962, 0x72314bf6, 0xb935bbfa, 0xf55aec35, 0x682815fe, 0x04a7ad6d, 0xfbfff29a, 0xef5cabaf, 0x2b7dc193, 0x7e2a6596, 0x818580ff, 0xa6a292be, 0x9938b121, 0x698c5996, 0xad8eb28c, 0xc2b61659, 0xddb939d7, 0xbbf9d41a, 0xa1ec1897, 0xa9a71945, 0x42a9233d, 0x817dd9f7, 0x578709a6, 0xc1fba084, 0x66e7f023, 0x7e7f57e7, 0x3b5df017, 0xc3e4d8d2, 0x0adc998d, 0x1492a28c, 0x2e6adf1e, 0xa179e501, 0x64d11cb3, 0x8695206a, 0x0e4464be, 0x6d849f72, 0x480f5d83, 0x50348548, 0x4364c9d0, 0xa52cf194, 0x4696fa9e, 0x30e21797, 0x2081d2f4, 0xf60a5464, 0x324eed7a, 0x18d222c9, 0x35e98c04, 0x63db4ddd, 0x3b5b82e3, 0x3cc5292b, 0x322b0416, 0x0bb10d89, 0x8c0c545b, 0xd97665fc, 0x43654ad7, 0x4bd6f38e, 0x44185402, 0xd3a8bcc4, 0xb7d98698, 0xac34aaff, 0xc05eb67f, 0x8193eaac, 0xdeb69cfd, 0x111e95a3, 0x698eb466, 0x73458b7a, 0x8c89ba18, 0x1f3dc184, 0xc7fc21de, 0xc62e2566, 0x8d6ff4b1, 0x7cd846ae, 0xdb64c6fa, 0x046d9781, 0x1c913b47, 0x4237632a, 0x8083ebcc, 0x5836c057, 0x574eaf75, 0x66b56065, 0xe5d83513, 0xcbe90ca9, 0x2c25a75f, 0x63674dbf, 0x064f995b, 0x8c786059, 0x905748f4, 0xfb11e4e4, 0x3b7c12e3, 0xc466c072, 0xc139de5b, 0x770aaf75, 0x0e0a1514, 0xe6071960, 0x8a216c78, 0x9ffd6b19, 0xca3cbc8b, 0x3ac13051, 0x20501821, 0x99d0ff31, 0x53f373f9, 0xa48df27f, 0xacb4b9a6, 0x877795af, 0x15cb1a2e, 0xf86049f6, 0xaa793a1e, 0x275a750a, 0x5952a806, 0x4a4d244b, 0x55dc7269, 0xbe6ad495, 0x23076f53 };
const u32 bern_num_data342[115] = { 0x439677c7, 0x2f3eea00, 0x2241489f, 0x4faf9c4b, 0xb4386807, 0x249e1f84, 0x3e311b4b, 0x720e4e3d, 0xbbf6eccc, 0x8fb7de29, 0x99dcd07e, 0x1309cd78, 0x28df12ae, 0x2a279b73, 0x2cf044d9, 0x49ea103f, 0xe3e14fd9, 0x0457bef7, 0x0fa3f041, 0xa372ebe0, 0x8346e4ab, 0x6bc65d6b, 0xdff80948, 0xf8132b07, 0xa00bd3fa, 0xef1946e5, 0x32d063b2, 0x264d3327, 0xe462d86b, 0xf379455f, 0x6692c9c2, 0x915c1c79, 0x426c7380, 0x7d563dcb, 0x6f85d958, 0x93e833c5, 0x55eafe3d, 0x55882928, 0x083ddcac, 0x43dd9691, 0xc51b2bce, 0xf92a3dd4, 0x01566d3a, 0x6fd80ee9, 0x7781cf3f, 0x2c88172d, 0x3b39d43d, 0xa688fda7, 0xd88941da, 0xecfaf415, 0x137e07b1, 0x62c8b808, 0x1cd6214b, 0x0ef7789f, 0xcb0d1959, 0xe8c71667, 0xa8d7ae50, 0x4eb27a08, 0x8b2d9a51, 0xd6c38633, 0x87d5c84c, 0x5a0be61a, 0xd1891d1e, 0x1d882ca8, 0x14e49650, 0x7d821265, 0x04daadeb, 0x0dc15417, 0xf9bba49d, 0xfe4793f5, 0x73615fc6, 0xe3b8d49d, 0x0b20b9db, 0xdf662628, 0xe367aefa, 0x8fb3b1c1, 0xa9ed23b1, 0x33a15346, 0x69f736bc, 0x5165adc9, 0xecc3d4a6, 0x2f0635a4, 0xbb41203a, 0xb0097819, 0x9f2c2f78, 0x301f3715, 0xb13ee3d6, 0x7d36b81a, 0xb252871e, 0xc61182dd, 0x1fcd5a4d, 0x01701847, 0x332ea2f1, 0x26664657, 0xcfd34510, 0xe03e113f, 0x61be2a92, 0x13135fe0, 0xa8577572, 0x70942947, 0x22cbbeda, 0x10e937a5, 0x77ed4f9a, 0x85f88166, 0x8604ebbb, 0x82a3c33e, 0x8fec9b07, 0xe4be833e, 0x04a63a47, 0x264a7b94, 0xeca8400a, 0x75a7da66, 0x2b234b7b, 0x7554dc8b, 0x0001750b };
const u32 bern_num_data343[116] = { 0x3176fe8d, 0x6e8b67de, 0x25260a29, 0x3edfcef2, 0x5df992bc, 0xa21ba660, 0x941fec19, 0x4a4d8a01, 0x7618fa9a, 0x1fbad129, 0x16f31395, 0x99707eb9, 0xb4748a13, 0x647d8c05, 0x4750de85, 0xfc377567, 0x1470546b, 0xc4c0be99, 0x6ecec359, 0x3ffcd533, 0x25c24b93, 0xce589379, 0x1722a7a2, 0x8dfe41c3, 0x485e025c, 0xac0aa988, 0x06df21fb, 0x178bd9ae, 0x51d7c8a2, 0xc02f71a1, 0x50e4378b, 0x11a67899, 0x53dfebcf, 0x5ca73dae, 0x2ba6c3d5, 0xab31beb8, 0x9e6c26b7, 0x4127b7c5, 0xd058f1d3, 0xd13c8304, 0x0879bdf8, 0x5c9d1b64, 0xc1199a64, 0xaea548f7, 0x09b8a3d4, 0xde16e76d, 0x3c02787a, 0x17cc1629, 0x16aa8968, 0x8c25c0ea, 0x94cf8352, 0xf2a6b25f, 0xad6037db, 0xbe9d032b, 0xf53afe5c, 0x4a8fe8eb, 0xa0dd1bbc, 0x0f475451, 0x0802a230, 0xa685546c, 0xff2d05d7, 0x8a5b386f, 0x6d30a895, 0xdd8e1ce8, 0x6c235a2d, 0x08a098a8, 0x264eb9a6, 0xcda79515, 0x53d4a407, 0x6a6d239a, 0xba2cfd8a, 0x67c2d5c9, 0x08a23983, 0xea907156, 0x4c35df7a, 0xf8b54dcb, 0x2b22b9ac, 0xdc3d747a, 0x2f767a90, 0xf5f6eae3, 0xe1dad684, 0x8f548d2f, 0x42a1e1c2, 0x6f02a868, 0x06b7274b, 0x5374d082, 0xfc955fc3, 0x9a167f06, 0xbb0aa6d7, 0x40bc056a, 0xd86c5e41, 0xe8eb2674, 0xf4fdbac6, 0x6dcd20df, 0xea403bc4, 0xb4e612f8, 0xca3050a5, 0xf22de93a, 0xd58caca2, 0xdc9997ed, 0x69c623c3, 0x2ea8e8da, 0x37242e7a, 0x1888662c, 0xf7384da9, 0xd447c77b, 0x2062ee24, 0x7796a3de, 0x5aaf01ee, 0x76162164, 0x648323d5, 0x7b79943a, 0xa97061b1, 0x465f97de, 0xa31cf76e, 0x00000f4a };
const u32 bern_num_data344[117] = { 0xf1020ef3, 0x1a47a3f1, 0x6db241ec, 0xfad359d9, 0x3b97a6c4, 0x9f29fd17, 0x9c333b95, 0x2ad75b1c, 0x90ccb29f, 0xeb43da79, 0xad85e629, 0xf8602a90, 0x8194fc7e, 0xa392dd5d, 0xdad5c22f, 0x95cb1969, 0x09426498, 0xe217d6aa, 0x0595aff4, 0x7fc31295, 0xe6c79d8f, 0xd1747663, 0xf0ce1428, 0xe06756c8, 0x761aa6bd, 0xd5138e43, 0x11bfa9cb, 0xc66428c3, 0x04357ecc, 0x949f0e2d, 0x409cab24, 0xd2b6e7c9, 0x363ee58d, 0xc2111dec, 0xe9fbe13f, 0xe42bfa2c, 0x5b16de9c, 0x0e08f374, 0xe757ee1a, 0xcd4c8cf4, 0x7ee79c82, 0x75fa3c97, 0x11b3c0d0, 0x316ac738, 0xd710686f, 0x29d4d5db, 0x496a3ff7, 0xe4bd2566, 0x1d2af9ec, 0xa4b1f904, 0x457c1eb3, 0x3ac4003f, 0xabbc6843, 0xe921da4f, 0x2a67c15e, 0x0a9ccbf8, 0x58d4cac8, 0x6df58c90, 0x4dd4ba50, 0xf9338745, 0xa00b8dea, 0x14c58fd5, 0x1714a6bd, 0x2a0ac1d0, 0xb1de6baf, 0x9b3db923, 0x7a28b6f8, 0x230a707a, 0xf330ab7f, 0x43a5eafe, 0x2daac137, 0x69885776, 0xa547563d, 0xa9905026, 0x03d65563, 0x6ea11300, 0x28146620, 0x48827985, 0x264b66dc, 0xb18ce8db, 0x205b6a5a, 0xac5a7c5d, 0xff54d733, 0x7d77b9b1, 0x39b40a06, 0x2a876b2b, 0x26e1342b, 0x002b140d, 0x0a13e452, 0xc5213c1a, 0x8ab7ecd2, 0xc06d1ea9, 0xc7072f4e, 0x8ad40bac, 0x02511829, 0x96a4b4f6, 0x3ffc5f20, 0x6c0de560, 0xebe58de4, 0x9d827adb, 0x3245f437, 0xc27d8e09, 0x890f5cd7, 0xe31c22bd, 0xd4f809d0, 0xceb0efcd, 0x9fce3d98, 0x6879de4e, 0xff547095, 0x7fd20970, 0x084bd66e, 0x75001719, 0x7ba6b548, 0x34b2e8eb, 0xffc78e75, 0x0136e3cf, 0x00001f6b };
const u32 bern_num_data345[117] = { 0x801f8aa3, 0x4633a30e, 0x7b340f1c, 0x7dd485e8, 0xa9fe8e63, 0xff84c323, 0x6767b233, 0xde8d6d02, 0xf8e7439b, 0x8f82b069, 0x14657358, 0xf04f0daf, 0x4af4caa4, 0x8ef63f44, 0xb9e2d3cf, 0x0851d850, 0x7d8fbc05, 0x434789fd, 0x948399ae, 0x6bb72e7d, 0x71b25949, 0x59b6bdb4, 0x341206ea, 0xf85925f4, 0xee7682ce, 0xc283f390, 0x9e99c07b, 0x373e5555, 0x139d3d4e, 0xaeac6c8d, 0xd0ceb1ce, 0x9cd01f2e, 0x45effa5e, 0xa102086d, 0x96fcfbbe, 0x2e88b66a, 0x5c367088, 0x03284afc, 0x419b4389, 0xb5963b0b, 0x2b1a4db9, 0xdf1602f9, 0x905e4d57, 0x318d8a5d, 0x0b3c2230, 0xe5867950, 0x55a3eb5d, 0x0139da9e, 0xb3c512f4, 0x02be07bb, 0x38b92648, 0x41545d5f, 0x9ef2b594, 0xfcf9570f, 0x3e6fae9e, 0x525fa9f0, 0x247da6a7, 0x748a6bc9, 0x3b3e5a7c, 0x30add40f, 0x4a782a1b, 0x57783ae3, 0xd30d44cb, 0x7eaee3fd, 0x4727b1b8, 0xcf8fcd08, 0x5684a4de, 0xdd55b737, 0xc4204148, 0x3457064b, 0x4f8d04e2, 0xdd9298b0, 0xc37e8a9c, 0xe8eca68c, 0x69fbaaac, 0xcea38c10, 0xcddbae50, 0x2794e191, 0x6cfbbcdd, 0x8be05c71, 0x08ca6b3e, 0x02621a7c, 0x277f83ec, 0xa6f3ee70, 0x175cfd10, 0x7bb74812, 0xf0b31e87, 0x49a4dfab, 0xf2adb504, 0x19519687, 0xec779633, 0x775cdb54, 0x96f081e5, 0xaf831bb3, 0x2f99499b, 0x2258966a, 0x769e81cc, 0xa4dad18f, 0x0cbed0b1, 0x98ea0918, 0x51bb93f0, 0xfe936864, 0x3979d083, 0xe4d800bc, 0x7b0f6240, 0x7e471e1f, 0x84d8b485, 0x0ee58de9, 0x0b820437, 0xbeccc9fa, 0x53e9691e, 0x54bc964c, 0xef29af71, 0x1f3fcfea, 0x964c1b96, 0xaf7ea04d, 0x0000000f };
const u32 bern_num_data346[117] = { 0xe04ca2f7, 0x9b5f0ab6, 0x9c60359f, 0x076438da, 0x704d7945, 0x4457f6fb, 0x547c1c94, 0x721dcd9c, 0x241e9931, 0xe27d0dbc, 0x38b46231, 0x565e8f09, 0x1a935ef4, 0xad58e9bf, 0xb5f07e09, 0x677a56e4, 0x2bfcb066, 0x36c33d33, 0x77d994b8, 0xe56af3d7, 0x343caad1, 0x41c06017, 0x093f4d57, 0x88e92e26, 0x70294786, 0xc6658173, 0xd0d6e3ef, 0xd22d9df4, 0xdc71f3de, 0x8c1d2428, 0x00d7910c, 0xfa71c3a5, 0xa71f8315, 0xf51041b5, 0x12c2ccc6, 0xcc1fd268, 0xaf782a52, 0xc49be4fc, 0x3a46e0ce, 0xa3e675fb, 0x8d0595d7, 0x78c37ec1, 0x01c9ea95, 0x33b4c190, 0x8b73ad72, 0x31521ab8, 0xd12b005d, 0x1dc32029, 0x2762e8b1, 0x0c43642b, 0x8af4e6b5, 0xd4c63a7d, 0x82a0c6df, 0x20b722a6, 0x8dbc689e, 0x3ed4c46e, 0x9afcbe69, 0xba6bc52f, 0xbfc878df, 0x45c389f8, 0x03d2cc98, 0x389a7551, 0x7f893724, 0x7dfa70c1, 0x62830e4a, 0xfbcaa26f, 0xe80fad0f, 0xf9f80854, 0x77a9f355, 0x15abda0e, 0xcf07492f, 0x21b7c164, 0xce2abbcf, 0xf982a340, 0x4f19d71d, 0xdc2ac0d7, 0xde2b3e37, 0xecc152d7, 0x2fd6d93b, 0xb7b04c9e, 0xaf2ffb7d, 0x057060b0, 0x6fffba87, 0xa011bf9d, 0x7d45258d, 0x20b15cfe, 0x19659786, 0xdfc06c1c, 0xaea62562, 0xf8d7a77a, 0x1823773f, 0xcfccc371, 0x3540819c, 0x65d0fe89, 0x57c8e66a, 0xc67f1358, 0xbdcb94ef, 0x76eb081b, 0x6024c9b2, 0x362cad41, 0x52660e75, 0x6ae68cc5, 0x507b1730, 0x1fa7d269, 0x2d1e6b18, 0xaea3fb44, 0x351a8a48, 0x1310184a, 0x972f9347, 0x480eac56, 0xec668075, 0x7f4ed90e, 0x69f1a629, 0x2bf7a5c2, 0xb0860092, 0x230750a1, 0x0000006e };
const u32 bern_num_data347[118] = { 0x505009dd, 0x564b08a9, 0xc695e102, 0x25500f4d, 0x7fcf3691, 0xec282239, 0x0b07d977, 0x5c3ec61a, 0xb6974e16, 0xe2988bcb, 0xa01ef9ec, 0x80285ff6, 0xc9a0d148, 0x55bff049, 0x5f420ace, 0xd5849c8c, 0xf982e37a, 0x1c36a1d6, 0x22e234a2, 0x70ec5de2, 0x165460df, 0x792cc78c, 0x554358e4, 0xc8ca2adf, 0x178c4fd1, 0x1077f2e4, 0x221ff711, 0x491ddf5a, 0xc29c0ff3, 0xa3e22392, 0xfc85508b, 0x50607139, 0x8c012830, 0xabb6032f, 0x4097523f, 0x7eb419bd, 0x21897895, 0x7434fa02, 0x689005b4, 0xf1c83090, 0x1f7c677c, 0x212cc26e, 0xd6ee18f1, 0xdee193f4, 0x758d61cf, 0x925b44fd, 0xa1c646d2, 0x5bee94f9, 0x78bada8a, 0x5bb21054, 0x199ad49e, 0x33d01f27, 0xb1604549, 0xa38808ff, 0x8d8f9649, 0xba563857, 0xea4e54e3, 0x389ea360, 0x5e38a1fc, 0xf6137b8a, 0x4332dce1, 0x4185e211, 0x946b64e4, 0x4ee61a53, 0xe3c7eac2, 0x8bd29972, 0x3b30961b, 0x1be56d59, 0x91187824, 0xcfa8d343, 0x97da9576, 0x86c1015e, 0x83a6de6c, 0x1ee1cc9c, 0x95a3bd8d, 0x3aa11746, 0x428dbdbe, 0x66b60b57, 0x12e6174f, 0x22b0788d, 0x9f86d4e2, 0xdcfe1b1c, 0xaa3197a8, 0x9aecd613, 0x5bf5afee, 0xe3a22521, 0xea93898a, 0x98018130, 0xb9c9fe9f, 0x7c73596e, 0xac08f54b, 0xccb24332, 0xb23af264, 0x035a3562, 0xaade7459, 0xee7bf13c, 0x08ac3f9a, 0xa40c9ca9, 0x2afed9a3, 0xa5075081, 0x298d4477, 0xd3440664, 0x760e8508, 0x6f042d75, 0x702b97fd, 0x18353854, 0xdabf5bcb, 0xf41a76f8, 0xcaa6e84c, 0x92647e27, 0x9c564999, 0x464fa437, 0xc05626e9, 0x7f28b97f, 0xf7691d58, 0x960cb1a2, 0xbe7af7b4, 0x000a773d };
const u32 bern_num_data348[118] = { 0xe100264f, 0x0faa1517, 0x2d600948, 0x494a3e76, 0x8411fb94, 0xd3d7bc6b, 0x40302e10, 0xf328b18f, 0xc1f05e45, 0x3a4463aa, 0x52655925, 0x42332ad4, 0xa24f62df, 0x8a912bda, 0xe1c05d32, 0x28d8d5f5, 0x074422f2, 0x0724ac79, 0xecd948d5, 0x545e0c14, 0xbd73ee9f, 0x83dd43c0, 0xa0b20230, 0xf0a34f66, 0x8fa48d0d, 0xca86d2b2, 0x985cbc8a, 0xca05b379, 0xa26fac98, 0x3fcc9008, 0xc8229d30, 0xa54a2051, 0xb83d0df0, 0xda533fa8, 0x7a4c14a3, 0x71f11cb8, 0xc123b49a, 0x646d64f1, 0x92e61a40, 0x51cf3503, 0x4b00e4ad, 0x6491c7d7, 0x85a6e72f, 0x3d01cda0, 0xcb684e56, 0x46f2a621, 0x8372defc, 0x4053e480, 0x9c161c4b, 0xee78724e, 0xdd4b0280, 0x855720fe, 0xbc444c4d, 0x563af2d5, 0x8249f2e4, 0x525eb89a, 0x809ddd34, 0x968df041, 0x9d359268, 0x21a56869, 0x7345843d, 0xd3ac4753, 0x4843657d, 0xb2386957, 0x9d827576, 0xc506acf6, 0x7712f566, 0xf1433d3a, 0x485f560b, 0x1a511ea6, 0x0b8d8cd7, 0xe6efb6e8, 0x16a87f29, 0xef7a8314, 0x82996df2, 0xf9f9c233, 0x74d78f6c, 0xea28ac78, 0xfe5d1924, 0xf1df36e8, 0x6d121ec6, 0xaf2fda23, 0x51fa7a4b, 0x02b3313c, 0x374367de, 0x3eb2ae21, 0x660fa077, 0x341edbe0, 0x8effef1b, 0xf445ec07, 0xf06ba023, 0x4d0c8973, 0x79e9b730, 0x22c6d2ff, 0x454784c3, 0xa25e5c41, 0x1733a872, 0xcdb5c98f, 0xe901deaf, 0xaa77a0b6, 0xbda413cc, 0xd0642625, 0xfec66481, 0x255f9458, 0xdbf218d0, 0x6619acdb, 0xbd02f7d8, 0x24c95944, 0xd44ceef2, 0xe5883a9b, 0x8e3cc445, 0x76378619, 0x440066cb, 0x9f90be87, 0x212df3b6, 0x081f3da0, 0xdf3b7899, 0x00000003 };
const u32 bern_num_data349[119] = { 0xc3abc4b1, 0x4220d48f, 0x4f4f45b6, 0x38f3dd01, 0x5e780cbb, 0xc3a93be7, 0xc254299c, 0x633ed891, 0xab4b88d9, 0x9276fd40, 0xdd29cff2, 0x747fa426, 0x827e33be, 0x569f1828, 0xbf78b460, 0x76f03ba2, 0x2f1a9083, 0x09858566, 0x6fafba6c, 0x76ee8213, 0x6d814b19, 0x6b0c94a3, 0x7216c206, 0x72885352, 0xda47f27f, 0x828020f2, 0x447dbea8, 0x671b707c, 0x4b5c82c5, 0x0f89ef1f, 0x724e43f2, 0x32f3703a, 0x83fa5c85, 0x190d4c81, 0x1b8a3eaa, 0xd56a3321, 0x1bc42137, 0xb3e8f7d5, 0x4d8ab12e, 0x5239f211, 0xc52b954d, 0xb268335a, 0xa52e9f91, 0x08d20151, 0x6f2256fe, 0xf6ab2dc7, 0xe1b9ed5b, 0xb7a48c5a, 0x7400d583, 0x873cf8d9, 0x4831a392, 0x911ff0c0, 0xc10bc559, 0xaf180607, 0x03e5f8e4, 0x3253e0d3, 0x70555545, 0xe9f8ab6e, 0xa0695640, 0x38e5f5ae, 0x424956f5, 0x89259033, 0x58c982a1, 0x41fcda3b, 0x41bfec7a, 0x8a9e348a, 0x7241f7b7, 0xa4bea2bc, 0x82e2079b, 0x40c1b768, 0xaa2f0294, 0xaa413eb1, 0x24cc1f7d, 0x8fd172cd, 0xa8c769e6, 0x7b0c2b06, 0x2bf601bb, 0x9766a161, 0x3051f18d, 0x6f8fd718, 0xb5eda102, 0x7b14d775, 0x71eebd0a, 0x8131d411, 0x57ac42c6, 0x5d5130fe, 0x82d5e8c4, 0x57f5d79f, 0x5e8376fd, 0xab71859c, 0x99fa2c03, 0x007ef945, 0x238b60b1, 0x22f02416, 0xc803a712, 0x59259125, 0x614d21d3, 0xfe742f7d, 0x6668ab0c, 0x619c67cd, 0xc2eb0a6c, 0xb22ac38a, 0x8f3f8589, 0x5a9d1db8, 0x63ff2293, 0x32e5d958, 0xb10b5f1f, 0xccc4f780, 0xda73610c, 0xb72fae73, 0x8f40e4ad, 0xb5f4b52b, 0xcb422ef0, 0xb2847751, 0x17165371, 0x0038ea97, 0x724b1e79, 0xef8a5f2d, 0x00015df3 };
const u32 bern_num_data350[119] = { 0xb68998ad, 0xac6995cb, 0xb6e989cf, 0x824d123f, 0x070f8a1e, 0xd56248c0, 0x2fb30762, 0xa9dab6de, 0xe16c9d76, 0xbb20511a, 0xf5f32c23, 0x9c770745, 0xf69961fd, 0xd46d299f, 0x2d881e4b, 0xdb37c3b5, 0xdbdd7580, 0xfbf843a5, 0x826fbf21, 0x5bf59915, 0xc45b3012, 0xf3832c6b, 0x90acb7f1, 0x591e2ab0, 0xa0fefe24, 0xd070b79a, 0xd4498fad, 0x2a134c39, 0x93447126, 0x4fcba30f, 0xfabfab92, 0xade63af9, 0xcd003e11, 0x3e09fbca, 0x6aff0051, 0x2ecfd926, 0x1e7bc79d, 0xc87fd86a, 0x1fd1b8c1, 0x3f004d7d, 0xba94f226, 0x17d87e47, 0x3de880f4, 0xae12fbad, 0xbcaedaf4, 0x7af2defc, 0xa2098543, 0x2846f4b0, 0x0016d853, 0xf00fafda, 0x8e27ca7d, 0xc5e65dbb, 0x89ead337, 0x2aa9cbac, 0x999f452a, 0x2ad58756, 0xfe22740f, 0x58814adb, 0x3077556e, 0x20bef3e7, 0x2ff7710f, 0xb59fd841, 0x6d84fffd, 0x458e5867, 0xf40c8ec3, 0x5fbca133, 0x2240a485, 0xc544c6c4, 0xa9940cc8, 0x202060c3, 0x13479885, 0xfc992816, 0xeeadbad4, 0x0d633b2e, 0x49f1cd2a, 0x0a2f3b98, 0xdcc41118, 0x05c47864, 0xe63a5704, 0xfe21fa88, 0x0968d463, 0xead7eba6, 0x5e74ee6d, 0x430363a5, 0xbfeeeb8c, 0x9437d4f4, 0xc48dcdee, 0xd0636def, 0x7a23e27c, 0x34c960fe, 0xaeeba835, 0x60206b65, 0x552045dc, 0x4fd1d2bd, 0xdce4aae2, 0x773269c8, 0x4a96171e, 0xdb5786b7, 0xaaba89f2, 0xf90ba4c7, 0xb1e1bfde, 0x3592927f, 0xb8cfbe24, 0xb7dcd888, 0x9f972e9c, 0x295a8f49, 0xb8a1072d, 0xff89da50, 0x26621815, 0xecc17c51, 0xbcb01522, 0xf3d49a31, 0x0637abca, 0xde9a3f55, 0x3c4cdaf5, 0xc62357d8, 0xd3590b61, 0x68471685, 0x000005b7 };
const u32 bern_num_data351[120] = { 0x50fb4e1f, 0x403ad5ea, 0xbbe18718, 0x3498511b, 0x1c75bf44, 0xbbf5c709, 0x4162178d, 0x0183ddc6, 0x073f24d7, 0x170abff3, 0x0e972433, 0xa24af43f, 0x6300faf7, 0xdb8ba43e, 0x0ff7775f, 0x5fdcf7f4, 0x55d59dcf, 0x610246d9, 0x3233d5c0, 0xb0810960, 0x02c41a6c, 0xdb7ea253, 0x89a37c8b, 0xf7fc49c4, 0xa1a6494b, 0xd2a637db, 0x70d67ba2, 0x8ad46d00, 0xc5592bf9, 0x4a2c8f08, 0x8b396907, 0x5bcc18d1, 0x8239141c, 0x304c309a, 0xdec1f6cd, 0xae258f94, 0x3d7abccf, 0xe592c0b3, 0xf0692df4, 0x9760f70f, 0xe3989893, 0x56f6905e, 0x7e494f89, 0x2147220b, 0x7c5f8c2a, 0x3043c771, 0x0956e41b, 0x343482a2, 0xd841efe5, 0x588e8551, 0x830e4c49, 0xfbc91fd3, 0x2a51cfad, 0x23889c2b, 0x0183fd93, 0xd13c439d, 0xb0c6ee98, 0x4b6e2592, 0x8bab2da3, 0xcad61b9e, 0x6b89ba15, 0x8561d880, 0xfe4c57d1, 0x79351402, 0xe78c7578, 0xd2ce9078, 0x4fdf940b, 0x1f1afeef, 0xc6931036, 0x9857352b, 0xd35f3241, 0xea30f69c, 0x362f05b9, 0x786b4315, 0x5148744f, 0xef91baae, 0x6eded58a, 0x718825f8, 0x47b026b8, 0x1c17a964, 0x3a91221d, 0x98000db1, 0x96d11b14, 0xb328f90a, 0x3254d4a4, 0xb39b9bc6, 0x61fc0989, 0xbe165e83, 0xb99fbb3b, 0xff2e3432, 0xe5e43b3e, 0x819587e5, 0x20d0e2e8, 0x6cdc517f, 0xfdd16735, 0x339a2867, 0x5686110b, 0x94332450, 0x4cf79572, 0xb5ed2d1f, 0x1d8b79e3, 0xa83e4827, 0x03969bce, 0x518ca199, 0xcf59c362, 0x36569d25, 0x19eb855e, 0xc6b09fd7, 0x4a438ab2, 0x1850b124, 0x87d5579a, 0x5cdddccd, 0x2a81f147, 0xa35990bc, 0x1d02fb3a, 0x53c67cce, 0xcab08436, 0xed9ac9fe, 0xf823ffb3, 0x00000018 };
const u32 bern_num_data352[119] = { 0x9fb9f87f, 0xb19b4459, 0x23cf30c8, 0x9694434d, 0x47861e34, 0xcc36eb62, 0xdcf763a9, 0x763af5ce, 0x40e04232, 0xf91b1f19, 0x5948ae1a, 0xf4b1f3e5, 0xd1f77150, 0xad2f5379, 0xa5186d78, 0x52f5d8f1, 0x230ba592, 0xc5de84b0, 0xe4a6bb8b, 0x2d1800c7, 0x78f859cd, 0x1c88a428, 0x04052464, 0xb5e0c577, 0xf7b541c2, 0x1cf4866f, 0xc5eee9da, 0x9939013b, 0x8d9e21ea, 0xfb76e9ca, 0x92959dff, 0xcde8b631, 0x0082d326, 0xd53874d2, 0x84e792c4, 0x3b2a197b, 0x1577287c, 0x96ee4fb3, 0x32b0b730, 0x9526ea3b, 0x2d16d59c, 0x411ce1f6, 0x6b2a0fd6, 0xe6359680, 0xaebd9c48, 0x1615e33f, 0x29969114, 0x600701f6, 0x6eeba3a0, 0xd31b0927, 0xb4a929e9, 0x82561a85, 0xe96d0a10, 0xa1f269bd, 0x1995fe5c, 0xfd7ff74a, 0x19c1325c, 0xbd294904, 0xf938b31b, 0xc6b24ff0, 0x62d8e096, 0x1bbbf27f, 0x761264f1, 0x9a36a541, 0xfd329aea, 0x53e4be98, 0x6ff343ee, 0x56747d2f, 0x1239b031, 0x65e8c704, 0xe83b2d43, 0x6d0b63b8, 0x94af5136, 0xdc7780f9, 0x88f45c05, 0x3fdf832c, 0xf32b3b15, 0x013716be, 0x1ac98646, 0xb1e357f3, 0x256483f6, 0x676e934f, 0x011941ab, 0x147a83ae, 0x84f591ea, 0xa3495c4a, 0x431aa68e, 0x828d95c3, 0xb408388a, 0xdd54858a, 0xa0cd550e, 0x6a5a5c67, 0x6be619c9, 0xe6319a3c, 0xaffa5abf, 0xe115b40f, 0xd8bb01ce, 0xeccbcdaf, 0x41a0764b, 0xfdb9207d, 0x5987a817, 0x19976aeb, 0xbfc32f08, 0x836dd735, 0x7e5a84cd, 0xf6ce41d0, 0x7fd893d7, 0xf36af492, 0x0f62a76f, 0x6ed2c289, 0x0925f4a9, 0x7fd0dadc, 0x2f38b9e9, 0x737f92e3, 0x1e3061f4, 0x995ea4ed, 0x421f74d6, 0x1c0c2a9b, 0x014fe62e };
const u32 bern_num_data353[120] = { 0x0642ce4f, 0x48a4bc5d, 0xc944906e, 0xadb16eb0, 0x554d899f, 0x7675586e, 0xa3979664, 0x176b9cd5, 0x1a8b3d05, 0x5d8ca01f, 0x440b881f, 0x1cbdf20e, 0x59db816d, 0x2104755f, 0xf5f6d5e5, 0x92c53ef2, 0xaad7446d, 0x531e2e64, 0xa3d4b2d8, 0xb9b22ac7, 0xd429f8e2, 0x5f40e141, 0xa35b0646, 0xcac1d110, 0xd0bd2863, 0x67ad0572, 0xa8f4b24a, 0xe35a404f, 0x54403734, 0x4e558a91, 0x98f56347, 0xb8ad5ccc, 0x185a2bd5, 0x3b8d88e9, 0xeff91428, 0x9c4ae5e7, 0xf7156020, 0x6b081d57, 0x3ca8b171, 0x955ae854, 0x51a4d3d4, 0xd718c4fc, 0x012da012, 0x1eba140a, 0x7d78ce81, 0x45ba8d71, 0xa4dab9f1, 0xad73ba8e, 0x3f68b4ea, 0xf8186d37, 0x4a2a0900, 0xc2829059, 0xee958086, 0x2c23db6a, 0x6a3ddda0, 0xb531293d, 0x155df6fc, 0xb4e414f0, 0x2f74824c, 0xa4df58c8, 0x288725d8, 0xe8ce4050, 0x0d14d1a0, 0xa4918863, 0x94f3769f, 0x05c4561d, 0x48686fa9, 0x293722c9, 0x91f14242, 0x73ef9aaf, 0xe762014e, 0x81d3de3e, 0x80030d8b, 0x1b0b9222, 0x542df79e, 0x309330e1, 0xebb65d79, 0x694f912e, 0x316ae731, 0xa8f20c93, 0xd143534c, 0x6969991f, 0xd0060704, 0xdf60ee7e, 0xb6cd1538, 0xef5f3e53, 0x4d755607, 0xd135c084, 0x5137f9c2, 0x54985494, 0xb7bcbd03, 0x4b841a07, 0x22abc56d, 0x68c60c4e, 0x85fe17f4, 0x877b3f3e, 0x356ce692, 0xb610d1bc, 0x9543d477, 0xab3cf0e5, 0x4d48892d, 0x5b604f8e, 0x8b9ba959, 0x7a722f18, 0x17323e51, 0x56d83ad5, 0x26ac1576, 0x0eb2a2a7, 0x750fe7fa, 0x8fe2de6f, 0x69a734de, 0x06a1d580, 0x70a05c4e, 0x99854182, 0xf59e49ab, 0x5bf82693, 0x1891ee77, 0x1db74bf5, 0x9e41c9b9, 0x013fe3a3 };
const u32 bern_num_data354[120] = { 0x76c2b0bd, 0x68dad2c7, 0x52ee5d15, 0x6f6b4233, 0xa7732e00, 0xe37820d9, 0x3cd39bc5, 0x5e39b3f6, 0x0d7f842b, 0xbc7080fa, 0x60536818, 0xae341e7b, 0xe3e4b941, 0xae0620d2, 0x944db40d, 0x4fcf0313, 0xdc3dbf4f, 0xe982c203, 0xda2fdeeb, 0x67562305, 0xc07b101e, 0x9e6e45dd, 0x98f8af66, 0x535132a5, 0xd18df924, 0x5373ad6b, 0x63dce8ad, 0xe17dbaf1, 0x06419449, 0xb50b95cf, 0x80ccc5a5, 0x69f5b043, 0x244efff0, 0xaad54905, 0x0504ebb2, 0x417911dd, 0x450d454b, 0xc5867b03, 0x9f6a48ef, 0x1aeb7796, 0x85837002, 0x05399293, 0x940ee7eb, 0x8cf4d2a5, 0x479b9385, 0xef23e61c, 0xbe187a7f, 0xd27ae869, 0xdd7a4981, 0xcc936355, 0x867fc354, 0xa69ab27d, 0xd2d95a53, 0x2d4b2dde, 0x117f054b, 0xbbff8f75, 0xca95e62a, 0x3c9ed81c, 0x3b400562, 0x9d3231e7, 0xa35e68e5, 0x109f844d, 0xf48e36f3, 0xdbf73e2f, 0xbe667119, 0x8482abba, 0xc1aa5295, 0x44987c64, 0x686c8bf9, 0xb9b7367b, 0xdae878d0, 0x04568586, 0x5e9f2089, 0xeb9aecdc, 0xb128d19c, 0x5edf2650, 0x06e78f4e, 0xca57043a, 0xed0be70f, 0x5a0d497c, 0x949c641a, 0x79208bba, 0x9c6bab8d, 0x830ebcf4, 0x45ed2857, 0x6a10205c, 0xcb6cc0f6, 0x75341875, 0xf8f3ae6f, 0x30409605, 0x4a01cb15, 0x1ea8235a, 0xdbba6b10, 0x551b9dda, 0xcebfd506, 0x3f3e7e22, 0xabf03831, 0xafeedb3e, 0x16ed06eb, 0xb27423af, 0x21e1f490, 0x48f2b4c9, 0xcb6c81ef, 0x74aeecf1, 0x85f9adb3, 0xe2bb98d7, 0xf38890b7, 0x47ea074f, 0x61db0dc3, 0x3ef42a29, 0x1222fd7a, 0x0b7e38c4, 0x508e965d, 0x29f94159, 0x1446e8f5, 0xbaa6e0ac, 0xeaea2659, 0x55a6140d, 0xdc405f92, 0x008b15b1 };
const u32 bern_num_data355[121] = { 0x465173b3, 0x198dbad8, 0x9477c602, 0xf615ccdb, 0xe0253a24, 0x952e472b, 0xdb53d1d9, 0x2b9291f7, 0x0948e039, 0xea2ce158, 0x83aab497, 0x8e5dda7c, 0xbd97722c, 0xf076c8ff, 0x794c0e0f, 0x0069cd2d, 0xfa4e3c53, 0x3f953d99, 0x79a2d8fa, 0xe58ba813, 0xac1d165c, 0xd9c035eb, 0x22cf33d8, 0xcd159488, 0x6ac28a88, 0x5f8dfe71, 0x3228cd1c, 0x29e3e417, 0x835a28a4, 0xe3a1f780, 0xbdfe84fd, 0x34b67477, 0x4c33a93f, 0x775b838c, 0x323b8a2f, 0xbf9f5c24, 0x9daba734, 0xde12006d, 0x0e7fbc36, 0x61f129e9, 0x69b642b0, 0x6f367c75, 0x6be487e5, 0x0215719d, 0xdd5ac687, 0xf032e7de, 0x390e5a9b, 0x80cd3ad2, 0x80de2867, 0x98dd23b2, 0xa976bb07, 0x22d0d29f, 0x935304f3, 0x549f5043, 0xcf2112f1, 0x4b91646c, 0x680fe474, 0xc4aacec8, 0xb3701776, 0xee22fb52, 0xce740fab, 0x0ea53774, 0x6fa3fb94, 0xcf698654, 0x43da89e8, 0xcc395ae2, 0x65e7ad3e, 0xba0c2bc6, 0x50a26cea, 0x9df61819, 0x591bd521, 0xeb4d3947, 0xd27f7c7e, 0x14d9b2e0, 0x5f98d639, 0x2f0caf67, 0x718a2464, 0x8e0ec971, 0x0f43ebf0, 0xc7d9279f, 0x107acae9, 0x7baba29b, 0x5b94f8a4, 0xa781fc69, 0xdbef9a9e, 0xabb2e8ea, 0xd633a62a, 0xf9de812f, 0xea065034, 0x8657a17e, 0x4cda9571, 0x7811a024, 0x83212892, 0xdc929ae0, 0x03c85336, 0xa9f51012, 0x64a31d53, 0xbe267e0e, 0x68038918, 0x8d720c10, 0xebb87803, 0x900e6e57, 0xdf3d7a3f, 0x69699972, 0xddb2d2fb, 0x07b365ad, 0xa683c015, 0x78df63bc, 0x7ed98a59, 0x330bcf67, 0x0fa59bec, 0x13072b62, 0xbc3bd355, 0x2bc5ed35, 0x4a671bf3, 0x2164d55f, 0xfc2ebcf7, 0x2eff5395, 0x85e1ebdf, 0x37062cdf, 0x000008a6 };
const u32 bern_num_data356[122] = { 0xccb2283b, 0x3606bc7c, 0x04059f48, 0xc1d40f33, 0x09608215, 0xf5e9da9a, 0x6004c1a6, 0x75bb689e, 0x0e3d78e8, 0xcdadbb78, 0x3d027d47, 0xcfe906b1, 0x3f3c962c, 0xfa9b9301, 0xd36e9973, 0x9426fc4e, 0x2b4da917, 0x4415378f, 0x0a511343, 0xff16b2d1, 0xf1965112, 0x3778f0cb, 0xd90f3544, 0xf2bfa763, 0xd62ebdad, 0x9f9543c3, 0xd01f4ba8, 0x0ee3d159, 0xb9f0f9a5, 0x1fb6529b, 0x18bbebf0, 0x168679d2, 0x270da974, 0xba970558, 0xb2d785ae, 0x2d606e53, 0xb634e1d8, 0x60623575, 0x8d206a7d, 0xcbcd6893, 0x0ec1b35d, 0xbd6dcb08, 0x4df013e4, 0x8097dcd6, 0x8a397308, 0x8e7f3e13, 0xdea35592, 0x117cdb24, 0xc7e873aa, 0x6864c931, 0x635b54de, 0x9ed912f6, 0xf806b3b7, 0x882b75f3, 0xb2e4a980, 0xd14eda6e, 0x004dfa4e, 0x5388c9b9, 0x2e4b1691, 0xa909f662, 0x6335a26a, 0x3a1ece8b, 0xf04189b9, 0x5d3d9375, 0x2f03f96a, 0xd4b7f30b, 0xa02b007a, 0x559aea12, 0x6b1a2864, 0xbeae8a60, 0x15ba20de, 0x44568b1a, 0x43f9f5fc, 0x83a0da44, 0x73a073bc, 0xd9543c5f, 0x8e869800, 0x11dc78bb, 0x7a33cb8c, 0xcdd9ed75, 0x5442fb76, 0x028fcb87, 0xbdc353f9, 0x648fa4cf, 0x8092359d, 0xccf3d39b, 0x11cda137, 0x4977a898, 0x8a835c67, 0xa00aeecf, 0x65032984, 0xb69ca045, 0x2a73d466, 0x0224fb0d, 0xaae3fc34, 0x26755ac0, 0x9d716336, 0x784d9c56, 0xf092d654, 0x01130344, 0x2e7b63d2, 0x3dc18235, 0x16359d83, 0x8b38e960, 0x60eb71fc, 0x3672d808, 0xc1dd6a40, 0xdbb6d37e, 0xec3656de, 0x063ce8c8, 0x283a27e6, 0xc86caac7, 0xdcf25a71, 0x3a713140, 0x87e5bb29, 0x9459be8f, 0xc037554e, 0x159bf447, 0xb798d714, 0x56281781, 0x09da71aa, 0x00000037 };
const u32 bern_num_data357[122] = { 0x53e0949f, 0x82189e39, 0x793492bc, 0x9893476b, 0x41ef9af3, 0xa9f7a245, 0x2ef54f6a, 0x8069b543, 0x3273c301, 0x4f266eb5, 0xd7e93fee, 0x780e3f8f, 0x7bd957dc, 0xded0c8f9, 0xb31d8cbd, 0x0311a14a, 0xd7695510, 0x2b0d1a60, 0x4cd0bc12, 0x94ba14ce, 0x6b3a3455, 0x6d8e5667, 0x5b1db713, 0x70d14310, 0x7eafd252, 0x1f16ec62, 0xd7cf9d90, 0x2679822f, 0xaf476ac2, 0x132a5f80, 0x80052b32, 0x5f7d2026, 0xa2697418, 0x8814defe, 0xb9220296, 0x78c2078d, 0xbc2f2608, 0x67189126, 0x6d6e0964, 0xe220283e, 0x75258be9, 0x5eb8231e, 0x543edf2b, 0x8ceb3619, 0xa8f46cd9, 0x8c5dd897, 0x62f0bcd6, 0xfccb5849, 0x123f7c04, 0x4c3faf28, 0xfa0de6da, 0xd48fc34d, 0x561fc40e, 0x31ec6100, 0x8ca1f32b, 0x693cffa2, 0xeec83bf4, 0x6a5e5bc8, 0xe40b1c8e, 0xf39f8d39, 0x52cd71f8, 0x3e4f4caf, 0xc0b9a7c7, 0x9949e17b, 0x957ade5c, 0x4e213e8b, 0x2bf40ce0, 0x037b9e64, 0xe1517c4c, 0xb4aa6a62, 0x0d7a777f, 0x7132d225, 0x406ab18f, 0x0232bfa6, 0x61ba33f1, 0xf518e1ce, 0xd7cec549, 0xbcfd4285, 0x0e9e8c9e, 0x966f6be1, 0x7c10e360, 0x432d5ae4, 0x03cbef36, 0x19efe801, 0x9a5aed94, 0xe362ba37, 0xb271a417, 0x08073add, 0x6deed48b, 0xf127fa93, 0x5c089f3e, 0xb582048b, 0xabade9f8, 0xa39bdb52, 0x99f071ea, 0x5656acf8, 0x848a3315, 0x25f6db57, 0x591d5fb6, 0xfcf1f058, 0x83ac5284, 0xf6eaf017, 0x1f47e754, 0x778003c2, 0x01c66b45, 0xd6e76620, 0xc8e6362d, 0x7d93c11b, 0xd5ec53c1, 0x660392df, 0x12a404d0, 0x205d2cac, 0xc879b4fb, 0x1a8f504e, 0x801a6bce, 0xa40313bf, 0xcda57866, 0xa316decf, 0xddfa6108, 0x1f89e887, 0xe5c14a71, 0x000000ac };
const u32 bern_num_data358[122] = { 0xedeefb29, 0xa4b4804a, 0xa69560b9, 0x635c44c3, 0x09a2cc45, 0xf24d9ccf, 0x9b3c80d7, 0xfe6ad446, 0x4f39f505, 0xe6a29456, 0x5e404d28, 0x2df81281, 0x112c7e5c, 0x1fb9132c, 0x5257b226, 0xd17c2fbc, 0x19db1969, 0x9a2eebc5, 0x4a8e54b6, 0xc6aa4e8b, 0xdb3ef3b0, 0x5b011c0f, 0xedb89c7e, 0x1f8ab23a, 0x22650397, 0xce6ffd73, 0x3f156d34, 0x23f19449, 0x3f11b432, 0x3aed94e9, 0xf11e4671, 0x77e5bacf, 0xf1659bf2, 0x6d2e7b0b, 0xc5d33da2, 0x567351e1, 0xbd96451e, 0x1c937244, 0x34253de7, 0x49b403b1, 0x4485868e, 0x3f21a272, 0xf13fdc20, 0x0aa6f455, 0x517d30e7, 0x0b06bd40, 0x22009cac, 0x03180ff7, 0x0c6ea407, 0x6d872c16, 0x970d1938, 0xee058c9b, 0x751fd7b6, 0xc8d323c0, 0x8821e894, 0xa5700e54, 0x0beaeb46, 0xb7a0da28, 0xeca5b2ba, 0xccbf5cbd, 0x542ac82a, 0x5abcd086, 0xb23c6db0, 0x3dc02da9, 0x6c7ab5fd, 0x5de0bb09, 0xa1e5eacf, 0xc8f65468, 0xfdc90e47, 0x640b4b86, 0xa1af35fc, 0x3b8dcb01, 0x9534e750, 0x69a17a31, 0x7e10cdc2, 0x6daa6c35, 0x5b925df2, 0xb33d9cdd, 0xa70f1291, 0x9e748281, 0x3c79e4f0, 0x0a529238, 0x85fa4e4b, 0x67f9d47c, 0xa586ec59, 0x2ade20db, 0x00d51ab7, 0xc944cc6f, 0xfd1e3fdb, 0x68a648e0, 0xc88a6fb9, 0xae747aeb, 0xa8c19dee, 0x29801fdb, 0xa476d08e, 0xf59d973e, 0x1ab904a9, 0xf83e1c04, 0xd3edff94, 0xb823b19b, 0xea3fedb9, 0xce9f4cd8, 0xb79c0299, 0x486581f9, 0x91cd05db, 0x041ccfc9, 0x1b0f55cf, 0x24340293, 0xebb5ed63, 0x3ff6dbba, 0x6f74fcf3, 0x580fe1d2, 0x18871789, 0x5d6e5790, 0xd4994703, 0x97eefba4, 0x65a873ea, 0x21f624ce, 0x78f99497, 0x07ed0b9a, 0x5609a5cc, 0x000dc7be };
const u32 bern_num_data359[124] = { 0xca90d169, 0xd31d6c1f, 0x9db0edc4, 0xfdf9ba7c, 0x2655e447, 0xa717fedb, 0xcfdd3246, 0x5edd5bfa, 0xa33ecaed, 0x24e627a0, 0x4601078a, 0x597ebdb3, 0x44c7acc8, 0x7819ec94, 0x1f3faef0, 0xcd667a3d, 0xa60cbc6d, 0x381b8e09, 0xa9963da6, 0xfd1e208c, 0x8c433536, 0x21d52d97, 0x3f985ffa, 0x58d5ba74, 0xbe96d217, 0x7e122cc8, 0xe863575a, 0xbc04ca02, 0x7f3bff57, 0x398b5870, 0xf49e3324, 0xe2669b60, 0x9d0bb7aa, 0xa5d0b4e7, 0x07692bef, 0x73849fda, 0x9784fbf7, 0xe05c8c7b, 0x276a1c27, 0x45a444a5, 0x0dce99ba, 0x187e7d41, 0x53453dbe, 0xaa3ad355, 0x32fda0e9, 0x88288860, 0x0b64e394, 0x5ba512ee, 0x6084b912, 0x8bfb368a, 0xc2719507, 0xc18d8e16, 0x7c5c5757, 0xf915e161, 0x3639418a, 0x2572614e, 0xdf0d964e, 0x54e1d051, 0x7d20fa9a, 0x9fee8b49, 0xc9d83eb1, 0xbf033415, 0xcb3092f7, 0xd1732ffc, 0x2f7b4e55, 0x3f1fb7c4, 0x523989a9, 0xadc9581e, 0x5db9c3dd, 0x5b908842, 0x88cf7bc2, 0xf6f92a7d, 0x82377021, 0xbe0ce4c2, 0x1475e12a, 0xf8761bd2, 0x35275ae5, 0xe0f6cf86, 0xdf2508e8, 0x75a8435e, 0x29b2b1b6, 0x51618451, 0x25e945cf, 0x429590f1, 0x067d1b19, 0x4ad1fd08, 0xc209c134, 0x85b566e0, 0xc7f0e4ca, 0x658fd597, 0x8df66602, 0x7f7e891f, 0x42afcba0, 0x5a4020f1, 0x5a91e241, 0x9a5bf874, 0x50cd1ac1, 0x8f41a777, 0x743eb07f, 0x424d7746, 0xd23a07df, 0x07db34de, 0x3769ec16, 0x7905098c, 0x2a26e35c, 0x0be9e088, 0xfd09f219, 0x8fd765a3, 0xcbc218c9, 0xaa9ecd47, 0x331b782c, 0x80a6a4e9, 0x152f7836, 0xc54c3aa8, 0xb47acc90, 0x355ea830, 0xebb4dfee, 0xc5116643, 0x3f8b4449, 0x2cfdeb14, 0x7e38e4ff, 0xbbb2e5b1, 0x252c82a5, 0x00c93156 };
const u32 bern_num_data360[123] = { 0x642c8adf, 0xbf9d25e3, 0x7f143a1b, 0x2846955d, 0x04f08f55, 0x3d8f9f33, 0x2e165331, 0x3bbda8e8, 0xe8bca76b, 0xd4d9614b, 0x7e4338c6, 0x41e08e16, 0x37ca170a, 0xd04d662f, 0x1df0521c, 0xd6456c48, 0x2e5e2904, 0x9880dd27, 0xa2de4ab4, 0xa892f376, 0xf05e868e, 0xeee4a455, 0xc11e41b5, 0x0b0f5c44, 0x6adb0fbf, 0x12714c32, 0x4c025bf7, 0x309fc736, 0x04c4b429, 0x11e9dbd2, 0x849ce22d, 0x8ba19050, 0xa4559dbb, 0xc5ff311e, 0x20bd948b, 0x685a95f4, 0x3a000e0d, 0x67785bfe, 0xa66a55df, 0x9b8975e6, 0xc65b3c0b, 0x5151f8b9, 0x999950b2, 0xd78e9a95, 0x00e22f76, 0x754d6ae6, 0x0736c9da, 0x24d9ffe7, 0x9a7ffac9, 0x3de9b9f7, 0x25d5b6ba, 0x9c2d745c, 0x01e4ef38, 0xfc7547b3, 0xd100668c, 0x74e3d33c, 0xd79dc726, 0xbbbe1d79, 0xc52d124e, 0x3f944c0d, 0x8e621278, 0xeb486f3f, 0xecdce00f, 0x231e0153, 0x8d1b77f0, 0x0b95973d, 0x96a0667f, 0xc08eaa59, 0xc298b935, 0x4be7de12, 0x3de97757, 0x9b309372, 0x53f75088, 0xc3014ff3, 0x4640fe25, 0x66927281, 0xb1ed8b31, 0x5156d07b, 0x5ecc850c, 0x3bd17bf1, 0x8ed06e91, 0x3a64a5c5, 0xf272b215, 0x50148118, 0x12f5e402, 0x3d197b34, 0x291d5d4c, 0x023a449d, 0xf550c81b, 0xe02955a0, 0x24821f66, 0x3c708cde, 0xd4ee33bd, 0xf5e8984f, 0xa1ef5ccd, 0x9e3de69e, 0x617b5d4e, 0x7ed5e488, 0x6ff715a7, 0x906241f3, 0x9c1bc89b, 0x015d4c49, 0x816a382c, 0x566b81b3, 0xaa1764e0, 0xc1fbc55c, 0x7195993f, 0xccf66072, 0xeedb9f8e, 0xe6a9f32b, 0x01f7dd88, 0x848b1140, 0x53ef434b, 0x1f89b8b6, 0x53b41fc6, 0xed9d0d10, 0x89a44eef, 0x8b8d678d, 0xe5960c62, 0x00856d77, 0x562b8a59, 0x9103d13b, 0x00000032 };
const u32 bern_num_data361[123] = { 0x3ff45499, 0x381c163d, 0xe1976811, 0xb9329c46, 0x2c42cfae, 0x79c8fcce, 0x5ad45845, 0x7e22ac0a, 0xf4cdf9a8, 0xbe32d36a, 0x3b1c8186, 0xb0fa31de, 0x4a88f202, 0x5bde7bff, 0x133f9605, 0x895fc751, 0x6b4cc7ac, 0x0f577f2e, 0x33f9caa6, 0x437e1a2f, 0xb3e26653, 0x8fadb694, 0xb2e7ec1e, 0xa74ce3d5, 0x44a1abfa, 0x3df1360f, 0x6cd6ecca, 0x08c5f5b9, 0xb0ed1e85, 0x48aac6be, 0xd76a2d10, 0x668da893, 0xc4120043, 0xfe7de7ba, 0xe44685a0, 0xf5062d69, 0x7b4c2973, 0x2a79f0d9, 0x87d11686, 0x87a063b2, 0xccd2ceaa, 0x2e562070, 0xba3b3678, 0x1a2d5f1e, 0xf878dd13, 0x82e8e3dd, 0x96140e13, 0x77827cd5, 0x28968656, 0x1240c801, 0xdf3dd776, 0x693cd791, 0xf7fdb926, 0xdb8e3e2a, 0x8dd42679, 0x990a7124, 0x8e455a0b, 0x0050e4b6, 0x9c47d224, 0x17610183, 0x82e4a4b7, 0xc7f2119f, 0x3782f78e, 0x7401613d, 0x9a9cd2b1, 0xb31069ab, 0x689df4d7, 0x6cee3a04, 0x28fe95ed, 0xa6dddb9c, 0xb5fb6331, 0xea878d70, 0x78b840ee, 0xa421ddbf, 0x443d8a14, 0x716f2fd3, 0x31961514, 0x13849ce9, 0xc40b2175, 0xf340edb1, 0xc8c3bc75, 0x7ee2b704, 0xd34e323d, 0xc2b944aa, 0x2fe62695, 0x7798a727, 0x83f68451, 0xd06fead2, 0x0ae9bcf1, 0xbcaf75b9, 0x923c0495, 0x31c837e9, 0xe33ef7ad, 0x4798647c, 0x5dd2681d, 0x5a0afb43, 0x7cc91436, 0x5c5871b9, 0xecec8c0e, 0x27edbe74, 0x60c39b56, 0x766856cb, 0xde5c8424, 0x012824d5, 0x42cb1234, 0x773f264a, 0xc3049fce, 0x5613a579, 0xa7bafd03, 0x86880887, 0x25e0a934, 0x3c298911, 0xca96de8a, 0xaaa25942, 0x2dba918e, 0xd0c5b61a, 0xbc02a579, 0x0b22085c, 0x42a19b73, 0x4f33cfb3, 0x82268a5c, 0xd3c5e58d, 0x00332720 };
const u32 bern_num_data362[124] = { 0xe58d1633, 0xe413f107, 0xdb69991f, 0x58391113, 0x777724c5, 0x56ed5baf, 0xf347d60e, 0xff627ff9, 0x7096b5f4, 0xe7eaae21, 0xcc12b85e, 0x97ea2297, 0x08aeda14, 0x7ce8c334, 0xa95520ca, 0x891a8744, 0xdc25a855, 0x00415f5a, 0xc6769a38, 0x70e4d6e1, 0x06389427, 0xc2787d94, 0x27dbae92, 0xdcda5fd7, 0x1e236b0d, 0x92a5fc2a, 0x4551afeb, 0xfab1a4f3, 0x566815eb, 0x31550ef6, 0x87d7b320, 0xb324363e, 0x284de033, 0x79dc9feb, 0xf13ea15f, 0xf2f82db3, 0xfa71a6a2, 0x89136644, 0xaceab2c0, 0x4c5ea0a4, 0x023049a0, 0xdc4c8e4d, 0x05f0a0f0, 0xb9cc38f9, 0xe9683e2d, 0x70466a81, 0xda184ed3, 0xbd777cab, 0x9773762f, 0x11fc5e5c, 0x7c9d2a62, 0xe080fca8, 0xf0ee0ed2, 0x1b1c8448, 0xca44d953, 0x5c46fadd, 0x88754de2, 0xf678f8a8, 0x277b9c80, 0xd8b7307f, 0xcae3a4d2, 0x5ba67c03, 0xadb39928, 0x35b1dd9c, 0x0287751a, 0x1101799f, 0x4f92829d, 0x35622ff1, 0x537864eb, 0x0c8dbed3, 0x09d7f21c, 0xad3b2a5e, 0x31a83587, 0x6973e091, 0xd8112dbe, 0x6b137c0e, 0xf4bfe851, 0x30b617c5, 0xa3a5887b, 0x6f9c6351, 0xb8dd0e94, 0x5f2928cf, 0x3edab78f, 0x83f38d22, 0x37d46ec1, 0xd150adb2, 0xf777a01e, 0x73f6e9f9, 0xbf838e3f, 0xe5565422, 0x089cdbf1, 0x211ac6be, 0x91e1874b, 0x036bf29f, 0x74e4d8a8, 0x1488b169, 0xfb1c6ed0, 0xc81633d5, 0x66abd7bd, 0xf0a93530, 0x5a11a906, 0x8e61e298, 0x40171b2c, 0x1d204290, 0x09de21db, 0x4699d307, 0xb4256184, 0x162d3456, 0xea4026b3, 0x317c2b18, 0x93fe6436, 0xc355c571, 0xea737e4e, 0xe969c17d, 0x7ca12b4d, 0x613724f4, 0xa4777139, 0xb1d465a3, 0x15fbf685, 0xb5b82db5, 0xad390043, 0xc2c467b2, 0x072da144, 0x00f90d4b };
const u32 bern_num_data363[124] = { 0x80e36021, 0x6485cc07, 0xfa3b6448, 0x1790e185, 0xbe220d46, 0xc7ac962a, 0xf7b181e1, 0xac78b8c8, 0x515707db, 0x46bb9af8, 0xf1e37871, 0xa59fda6e, 0x4f2d0e18, 0xd3c3ad05, 0x1ddba3e4, 0x1dbfb30e, 0x75d4fc5b, 0x4928b512, 0x86f49afd, 0x49bb1cc1, 0x259b0fe1, 0x6f5b95ab, 0xd447194d, 0xf2a18cee, 0xa4bb2bdd, 0xbc145e0d, 0x052148d1, 0x1b8c72ee, 0x333c8dc5, 0x41912780, 0x622f5192, 0xea38443b, 0x5feda17d, 0x4e50b6a5, 0x2ac78732, 0x7052f109, 0x3521f4e9, 0xcb113f76, 0xa6bc5ec7, 0xa7610213, 0x3a464baf, 0xe964a00f, 0x222e782c, 0x6a589b35, 0x49c6cdff, 0x552b5967, 0x135f3413, 0x0cfeaec4, 0xbfcc91c8, 0xeaa95d86, 0xf2d725fd, 0x00d782fa, 0x72f5e258, 0x4cceceb8, 0xb650340e, 0x21c0d2b5, 0xe370e453, 0x5cfa0087, 0xb137c7d1, 0x05c720b3, 0x5d7d0da7, 0xfd470852, 0x54a42df3, 0xa2d6d19a, 0x2ae62bec, 0x01a288b3, 0xaeb697ea, 0xa873cfa8, 0x8da698a4, 0xe7df01f6, 0xfbed8c87, 0xc82f6efe, 0xc0fcc9ae, 0x6aeca8df, 0x16ec04e4, 0xad681a19, 0xe47af416, 0x06a84375, 0x3da7f5a7, 0xcade0cdf, 0x7057e2b6, 0xa70e37d7, 0x0806f268, 0x40533d3c, 0xf3a4fcb7, 0xf4d111a7, 0x42b9bb37, 0xc0a6ef45, 0xbed48e76, 0x6d598f2b, 0x16d448a6, 0xa291b930, 0x73d36c18, 0x60bd434f, 0xbff2d1fb, 0xc77c0fae, 0x33492f5a, 0x9fb4b972, 0xd12427a0, 0x10d4b089, 0xa1d7c53e, 0x3a1c1874, 0xd28d6fed, 0x4969ccdb, 0x65a9162b, 0x475ffe63, 0x523c4d43, 0x8cfb1182, 0xd295b31a, 0x2a0b1788, 0x56d819d8, 0xd7caa7b0, 0xd500b318, 0x26cdcc43, 0xc199384f, 0x819f6e7b, 0xefaa2d19, 0xf4292c32, 0x0187e4cb, 0xd007a93a, 0x2a7bf9d2, 0x18c22700, 0x3a32ef0c, 0x0cc7ef80 };
const u32 bern_num_data364[124] = { 0x606f39a5, 0xd61b1542, 0xcf1229ee, 0xc5330af6, 0xb7b25c36, 0xa776285a, 0xb0baf4a6, 0x8a2a62bb, 0x86ec0727, 0x6263d0cf, 0xdc85b18b, 0x8a1bc7c2, 0x1ad5ee3d, 0x622ddc69, 0xf7077c71, 0xb335f001, 0x032d9705, 0xe93499fa, 0xe14dcd9e, 0x438419f4, 0x5b18526a, 0x6d0920dc, 0xb65b5105, 0x447317ae, 0xfcac8b58, 0xb3989773, 0x3cf45c8e, 0x29fa9aa1, 0x7d2a9503, 0xfffca96c, 0x43f9ce13, 0x720b3ab2, 0xb0b6d10c, 0xd1ec70bf, 0xd4c6c6b8, 0x5d50559d, 0xb38994a2, 0x1c0b54b1, 0x012328a0, 0x9f8c6465, 0xf316bdb1, 0xdd9900e3, 0x7c7666c1, 0x249b7ca1, 0x29ca5f4c, 0x7587e7b5, 0xae4fcf08, 0xb95e03ff, 0x803ddb9b, 0xacaba71e, 0xd176d18d, 0x210a8762, 0xf125b0ac, 0xa780d33e, 0x2d2d56c6, 0x8389e158, 0xa06c6548, 0xcd74b79a, 0x50cd6217, 0x11cdcf1f, 0xf363f793, 0x1191152a, 0x62367e81, 0x300a3e8d, 0xfb7a9e79, 0x05571478, 0x4a860715, 0xe3c999a7, 0x9cdc4b06, 0x3d99ee24, 0x6806b78e, 0xaa57ed5a, 0x96a08b0d, 0x100ad47e, 0x4edc1695, 0xe8fb16b3, 0xb289741b, 0xefe7bdf9, 0x18e72024, 0xdf09d782, 0xea17ab81, 0x23669132, 0x357957c4, 0x8705b308, 0x39927ea8, 0x0005e00c, 0x6cd4a584, 0x0976b0b8, 0x545031ac, 0xd7a4c0c9, 0x9c8597b9, 0xc62b0319, 0xf30c4916, 0xa907d69b, 0x0ac2095d, 0x27038b5d, 0x156b4b0c, 0x254fa504, 0x5493889b, 0xa10ef4a5, 0x53fbd9ff, 0x23c7703a, 0xc0cbc675, 0x2519c2e7, 0xe1521a19, 0x2a9b7d4d, 0xc9d3c52b, 0x1b60fdf4, 0x1be8ebfa, 0xa0c9d9d4, 0x01883590, 0xf1e1b25a, 0xbbd62c95, 0xa5abacf4, 0x137cbcc5, 0x00b3b0a3, 0xa6ee26da, 0x09fb79b9, 0x72786d7f, 0x1407d959, 0x2d766d73, 0x7f8a8280, 0x4399dfec, 0xf69b3931 };
const u32 bern_num_data365[126] = { 0x066de029, 0x22b5e9d4, 0xcb492ad3, 0xa5fc8a54, 0x31549f1b, 0x6733d8d6, 0xe8aeba52, 0x95b1cfb0, 0xced5440d, 0xf6c6bc37, 0x3efbc78d, 0x92ce9270, 0x7aecaf35, 0x7868daa6, 0x125e0255, 0x3b706079, 0x12b5e7fb, 0x803fd170, 0x0fb0e558, 0xb9c732bf, 0xe102dbf3, 0xd38e4b45, 0xfd0a62a4, 0x8880b30e, 0x4e8823e0, 0xc5052029, 0x1d789298, 0x3c04a64d, 0xded6a6c7, 0xfcd7bc3e, 0x5b3f1089, 0x38ffcd6e, 0x1165bb4a, 0xd852bd8a, 0x93045b58, 0x98cb9200, 0x1fc5f1a2, 0x7f5b8c71, 0x0750936b, 0xde106c08, 0x83aa58f8, 0xda7e164f, 0xda4ddb17, 0xca9229c4, 0x8fb6c509, 0x3b1d1f77, 0x24b6d832, 0x2d17ae1d, 0x1eb37de6, 0x8deac8ec, 0x8b6e4224, 0x3a18316d, 0xe47ea904, 0xdeb36c6d, 0xc3a5aefe, 0xf4d157c8, 0x51918be6, 0x43ba1fe3, 0xf170f8c7, 0x3e7d91fe, 0x6baafeb2, 0xc1e57d81, 0xcf9eff60, 0x5444f69f, 0x452e3912, 0xc454c6f3, 0x80ff3eb6, 0xcf1e9364, 0x1be81454, 0x2163c2dd, 0x851eaad6, 0xbbad852d, 0xad46c5ad, 0x33877685, 0x10c55f5f, 0xbb992986, 0x732dfbda, 0x62e3f52a, 0x96f7c6f3, 0x24deedd7, 0x211c6e3b, 0x75cf2363, 0x47c1628c, 0x4c90ccaf, 0x737f8a95, 0x9c36be53, 0x0ff6fb73, 0x364e9ac5, 0x6654e64c, 0x235c6072, 0x241ec56e, 0xdd1e5028, 0xd5e152bb, 0x5a1a0b94, 0x9ae8a05f, 0xd01d3820, 0x46a23999, 0xf12f4ab7, 0x51f11981, 0x4fa880fa, 0x614462c5, 0x7e77310e, 0xfe1dafe9, 0x97f4f6d4, 0xf1fe47d4, 0xa7b64634, 0x1b4697fa, 0x621ce911, 0x4840998a, 0x1d45d901, 0x30dff6af, 0x0ca3f78f, 0xa6301dcd, 0xaf751cbc, 0x2793afe8, 0xc480b4b7, 0x463e2d5c, 0xb2159e7d, 0x1afe35b7, 0x5e183c20, 0x7a19bd44, 0x04c249f1, 0xe75f585d, 0xad960abd, 0xd3ae1d51, 0x00000021 };
const u32 bern_num_data366[125] = { 0xf3cee0e7, 0xcbfbb150, 0xa99e7857, 0x5554c427, 0x808af6a6, 0x297af2aa, 0xa0210537, 0xe828309a, 0x5f72eea1, 0x854410a8, 0x00667fd5, 0xa441fc2a, 0x7c736e45, 0x0267bfd1, 0xa719b1c6, 0xb4f27cd9, 0xc7cf820e, 0x0432ff7e, 0x3cdbfa68, 0xe6f7d2dc, 0xb0885d1a, 0x090ce3f9, 0xa1d3160c, 0xf0302a1b, 0x966cb128, 0x5d1cf104, 0xbd56bf4f, 0xa730bb24, 0x9f1c079e, 0x3e34614b, 0x410feb6e, 0xc7bf3c1e, 0x668074d6, 0x1aa8d162, 0xbca3c786, 0x0232da6c, 0xf39a7a11, 0x07f0d0fd, 0xd9044495, 0x5154655f, 0x8cc652d4, 0xa0d6e73e, 0x763fc161, 0x8fcee087, 0xa5b47bff, 0xb42d01df, 0x36dc93a6, 0x693dc9cd, 0xada5a5d6, 0x8e96a6f2, 0xec28756a, 0x256475b7, 0xacec2a3e, 0xd8cd1114, 0x1d96817d, 0xa9067390, 0xf0c753e4, 0xace6fb28, 0x0254489d, 0xf53d491e, 0xd615ad64, 0xecffc972, 0x8f02e383, 0x1ddaf674, 0x2ae927da, 0x324a38c9, 0x41d339fa, 0x15e2b0b9, 0x658477e9, 0xdbc76422, 0x75c37210, 0xf5d05c1e, 0xf180219e, 0x19212a7e, 0x73d04ef1, 0x938bcf36, 0x923aae9e, 0x2594808b, 0xec3e3644, 0x70ba7e5d, 0x59eba8b4, 0x6784d5d2, 0x44f95564, 0x7ed095e5, 0xff636014, 0x40b399e8, 0x0b9d4b45, 0xe9741c81, 0x763e87fd, 0xca156888, 0x2dd17daa, 0xe6270c2c, 0x5ceaab1e, 0x200e27a4, 0x41a58538, 0xf2722104, 0x02e22efb, 0x822c8b28, 0x6f2447ed, 0xa59ed6ad, 0x2738b92b, 0x30e143f5, 0x0a49fe2c, 0xb07c3f1c, 0xe2fc5fd7, 0xb3d2ec7f, 0x4595ceb8, 0x9d6a4a3b, 0x3c7312a7, 0xa4b9968d, 0x93cec46d, 0xf259623d, 0x5aafd50c, 0x163cb535, 0x1113c740, 0x88c1d595, 0x6995428e, 0xf7853322, 0xe942c8ac, 0x7556a1b2, 0x4d1bcf06, 0x056bfbfc, 0x27f77200, 0xc0b84286, 0x00f6d4e0 };
const u32 bern_num_data367[126] = { 0x23e0e56f, 0x220105cc, 0x8fd50c5f, 0x43bd492c, 0x89257caf, 0xf466135d, 0x57f36434, 0xf56a0459, 0x06307b9e, 0x78ac8d43, 0x840c5937, 0x7b78aab0, 0x9c091519, 0x00472ece, 0x39bead45, 0x24503e24, 0x9851afd9, 0x253ac390, 0xf0614043, 0xb2d6ce4d, 0xab762256, 0xf6e1890f, 0xe327a1b6, 0x4350e5a4, 0xd4e7d890, 0x097c6812, 0xa6765468, 0x97a1dfab, 0x240660b7, 0x7fb29406, 0x187a4586, 0xae7fc786, 0x496a5b98, 0x3b18fbac, 0x07a97efe, 0xcb2d0883, 0x1c71abf7, 0x36c87569, 0x1bbe51dd, 0x66df3cc8, 0x44559db8, 0x16c693d6, 0x743066f8, 0x05a88456, 0x07a2f843, 0x67c693f2, 0x8836c8f1, 0x1a1d85e7, 0x32b65edd, 0x1742f47f, 0x8e5cbd91, 0x06aa66cf, 0x26b64c84, 0x0c3e672f, 0xc67c8aae, 0x40f02667, 0xc2fe0444, 0xecf3f56e, 0x28e3a4d2, 0x2b09f7aa, 0x625ea193, 0x7a6c9890, 0xa29760d7, 0x856ffb9a, 0xeab9131a, 0xce4a5227, 0x71eeebdc, 0x9317389b, 0xd7e4d874, 0xe26be1f0, 0xe77be93b, 0x2bddab7a, 0x7bd70afd, 0x04c5f1fd, 0x2841a11c, 0x9996be21, 0x33ea7860, 0xee4d21fa, 0x78270a89, 0x5655e1f4, 0xdc3b8a94, 0xca88c332, 0x70178777, 0x4f4ea541, 0xd052f4b1, 0x09fb285f, 0x848fc169, 0xb8841472, 0xdb79053a, 0x714601cc, 0x3f25a075, 0x4130b9b0, 0xe4b3a508, 0x887682b8, 0x555b0d92, 0xfffb9038, 0x73ad8ed1, 0xdca55ca7, 0xfb07ff41, 0xc8a3bf31, 0x8a130e99, 0x48a831fd, 0x83ce1d59, 0xf29ddeff, 0x6ae6e21b, 0x01b46a5a, 0x9ebce2c4, 0xa15b6029, 0x4057cf1f, 0x31cfcb94, 0x367bfc55, 0x4ffdbcc5, 0x1c9afc80, 0xa1606261, 0xab3ce597, 0xb562131e, 0xff5bbbb7, 0x7bc92997, 0x42c85acc, 0x6e9f9dee, 0x9eaf53b7, 0x70bc2133, 0x83e82725, 0x5aab6936, 0x4c04a812, 0x00032562 };
const u32 bern_num_data368[127] = { 0x47bf95c3, 0x4404e6f1, 0x500b93cd, 0x6ce5ba46, 0xb5ca4848, 0xe73bacc1, 0xf8de9df5, 0x81d3f461, 0xb60495ac, 0x5a8e93ea, 0x4eeb1f99, 0x7357d2fe, 0x014602db, 0xcb856aa4, 0x226c55b7, 0x5d1ba2be, 0xc1b0cbe8, 0xdc4986c3, 0xfa7e350a, 0x06ce43ec, 0x3935e2c8, 0x5298fc52, 0xddf586f7, 0xe5de9728, 0x9100c141, 0xfc86ac3a, 0x9eafd5d8, 0x25f6fc00, 0xc89eccc2, 0x0aa37a2d, 0x2dc244c2, 0xe601151b, 0x554708e4, 0xf71dd918, 0xb7295826, 0x130dc697, 0xfb2486a7, 0x1e1d2448, 0x839351dc, 0x7d191c8c, 0xe7c65843, 0x053445c1, 0x9b04696b, 0xc95c71dc, 0x9dcbf3ab, 0xf72898b8, 0x2abfa243, 0xc8e06b49, 0x54903c60, 0xedcc4982, 0xe39c6f16, 0xe227dcdb, 0x50f9aa0c, 0x162d5874, 0xe3f534fe, 0x5bcc34a2, 0x4c9c378a, 0xcd47f9f4, 0xa69d9125, 0x3fd91f3d, 0xaa0ed72f, 0x47fe3ab1, 0xecc6adbc, 0xef93144e, 0xb77feaf8, 0x0706fac4, 0x97481cf7, 0xce722910, 0x99ec3cfb, 0xde363601, 0xd84bdc04, 0x4be23064, 0x52568e7e, 0x6f661abf, 0x999f7cb0, 0x1730783a, 0xed25e7a9, 0xa1276eb1, 0xa14a3512, 0x8f9a1a74, 0x8ecd7cbc, 0x1c2ae01c, 0xed1e19b9, 0xef4d8a01, 0xa83fd0d7, 0x54477529, 0xc657cd13, 0x97351a3f, 0xef5eb6ba, 0x211e4b73, 0xbc6915b5, 0x539599e0, 0xeed707d1, 0xbf85af78, 0x31abde0a, 0xeb96cfea, 0x63e0409f, 0x9d970885, 0x01a81e90, 0x04c91c30, 0x9020a5fb, 0xd985ff6c, 0xf8ca1b3a, 0xf04abc86, 0x60d54d14, 0x9f3eeb62, 0xbf2a3618, 0x3c6f0276, 0x126b5f69, 0xb23ff052, 0x212d2d37, 0xc510f371, 0x10072497, 0xa457849f, 0x1cb16f4a, 0x9b156963, 0xe8d9a610, 0x24185158, 0x8acf7205, 0xd4879729, 0x2e8d510b, 0xe238e1a2, 0x48a29578, 0xf163f97e, 0xe26515ee, 0x87f5cf16, 0x00000546 };
const u32 bern_num_data369[127] = { 0xcceff16f, 0x7e644c55, 0xce89edfc, 0xce0e68f4, 0xdd2031c0, 0xfe4ccf6e, 0xbcfd10c9, 0xe821f55c, 0x54351037, 0x48b4ce92, 0x1acbc676, 0x4d2d10d2, 0xdb84788a, 0x6b3aca14, 0xc33f65bd, 0xb43f9931, 0xdfb914f3, 0xdf6a0432, 0xfa4b35e8, 0xdcdd7ddf, 0xd336c194, 0x435b56d9, 0xfc06954d, 0xb6c51302, 0x60646212, 0x7e9c0c11, 0x665cc6d4, 0xb041fbaa, 0xacee79b5, 0x377f3ea7, 0x6345cc86, 0x4982e665, 0x9bddbd17, 0xba6de4a7, 0x06bb5424, 0xc80ac31c, 0xe156be35, 0x6740454e, 0x7f749949, 0x92030268, 0x2ac25071, 0xfb4c7935, 0x176c6452, 0x6d743f1b, 0xb7174aaf, 0x435471e9, 0xb3e7bfb1, 0x89907779, 0x925b2f30, 0xa75cd475, 0x0129213f, 0x8e0db2f3, 0x1054d079, 0xcfb3023e, 0x41efe8c6, 0xac63f058, 0x9c8ef735, 0x967b8551, 0x61b9193a, 0x83f7e42e, 0xd80ee851, 0xba9460a3, 0x7038444c, 0x80cc5026, 0x3efd642f, 0xc6a76519, 0xafbb8831, 0xa878f194, 0xf9f98b01, 0x4b1ca206, 0x2c3571f9, 0x5727d5ee, 0xe1b67d93, 0x9ecfaf4d, 0xa5a9ae31, 0xb1d166f2, 0x839537c5, 0x66022b33, 0xc6031a4e, 0xbb135039, 0xe49edf10, 0x1e19d5da, 0xa058308e, 0xad1ac5f2, 0x65340f85, 0x5b01df4f, 0xb42b7a77, 0xceefa019, 0x8db1219b, 0x14aa3932, 0xc1dafe14, 0x1a98c66e, 0xb3732980, 0x000a87f5, 0xca13678c, 0x1e14ddbe, 0x4553ed0c, 0x3f8635eb, 0x9e65ee73, 0x163774a6, 0x5de7f66c, 0x2da0561f, 0x571c99db, 0x8e410110, 0x1dd6dc65, 0xefa603e2, 0xbefcf291, 0x5026b366, 0xcb4d4a2e, 0xfd9ec622, 0x130f7b15, 0x00a84e9a, 0x06908b26, 0xf6bd4763, 0x208e26b2, 0x305efeb7, 0xb699e3ff, 0x7d9132f1, 0x1b83d94f, 0x7b20d9d3, 0x62018ff8, 0x1e4f6756, 0x28fa5beb, 0x4ec5dcc1, 0xf4628cc5, 0xfc791493, 0x00004968 };
const u32 bern_num_data370[127] = { 0xc815aeab, 0xa4ba6bca, 0x6de26252, 0xd288c38d, 0xf26cc894, 0xa7bf3590, 0x4ddf8d34, 0xbdc51e38, 0xdabe149f, 0x467ea99d, 0x2e6139e5, 0xc7ad8988, 0xf69cb2be, 0x2102cfdc, 0xdeb507be, 0x8207de9f, 0xc6c441e2, 0x8416e240, 0x4bb6ef3d, 0x32cddcbb, 0x08699974, 0x67ed35f4, 0x96372d72, 0xe2745489, 0xe4c1d136, 0x48c88100, 0x74c7350f, 0xef6be965, 0x2c731e13, 0x6d8215b4, 0x577206ea, 0x729df0a2, 0xbc40cce2, 0x2e1be1a0, 0x4aff4869, 0x674f58a7, 0xe1414ead, 0xab85f9fa, 0xeae9ba15, 0x9da283ef, 0xa7e579a4, 0x9f560f68, 0x88c2945a, 0x2619914b, 0xca725399, 0x9dbf1710, 0x41eb3640, 0x29fa0462, 0x86f9aedf, 0x145d22c3, 0xfea086bf, 0x3e79f7f7, 0x026e3ced, 0x4a7d2cc7, 0x312efaeb, 0x6cf4478a, 0x60d04c45, 0x2613e03d, 0xf11dc82b, 0x8af12909, 0xeb9a95ff, 0x148957a3, 0x70be0fe8, 0x57aee9a1, 0x09aae427, 0x9d1c8817, 0x9e954283, 0x125408c3, 0xac7a76c0, 0xbec0aac9, 0xd3a3463c, 0xcd0cb25d, 0xe019b16c, 0x18b72285, 0xed39d42e, 0xb69d6466, 0x8a86a216, 0x5d722369, 0x7b7ee5ce, 0x7cfbc342, 0x0e22e2c9, 0x392f6874, 0x83b1fe1c, 0x20e34a0e, 0x242c6444, 0x865580e1, 0x319a8deb, 0x7569d612, 0x714ccd41, 0x33cee389, 0xf6d68716, 0xd6269aaf, 0x7a7c4a59, 0xdd545905, 0x992f685e, 0xf5e6d470, 0xb446b94a, 0x00e88228, 0xce48cb54, 0x74e863c0, 0x847ce046, 0x0fa0a726, 0x34fe01b6, 0x34ec6613, 0x1ff8e8f0, 0x6b2487ac, 0x4f4749ca, 0xff02bba7, 0x15f20b66, 0xf0c724ed, 0xfdd4f243, 0x42eefe33, 0x783ae5ed, 0xe4044935, 0xcae223a3, 0x2c695211, 0x6eefdb06, 0xd2a64716, 0x54636e3c, 0x687516b7, 0xb0134241, 0x7dc1eeaa, 0xd1955ac8, 0x7ff77ca7, 0x89222e4e, 0xdb50d5fe, 0x9757c50c };
const u32 bern_num_data371[128] = { 0xb0954757, 0xcfdd62c7, 0xc1bcfd62, 0x7fd01d02, 0x30f6e2e4, 0x4a26a235, 0x1091ecf8, 0xb5a1f3a7, 0xfbbb47d1, 0xb50e8646, 0xd80ed378, 0x76f0f86a, 0x9bb634c6, 0x38f087b5, 0x9bbbc7b4, 0xc93e0524, 0xb84d56e8, 0x26502767, 0x87346912, 0xdb865d5b, 0x32d54fe8, 0xf69f2535, 0xcdb0e12a, 0x5d3fbb80, 0xae61e8e0, 0x5f5507fd, 0x91aad270, 0x80e19020, 0xd18bcaf2, 0xb0b7678b, 0x4a4386e1, 0xf309153f, 0x7c1253f2, 0x7ed685f5, 0x25755250, 0x74002a5c, 0xe3b3971c, 0xc2c1db40, 0xbe5e63c1, 0xa6e4985b, 0x4f87417c, 0xf03b0ff8, 0x901d6b53, 0x77f2a710, 0x537be989, 0x275c4952, 0x1a55ccf4, 0x4cfda149, 0x9f650949, 0xd394ca2a, 0x894dda51, 0x268a778f, 0x2720b604, 0x5bbfc842, 0x86770062, 0xdc983ab2, 0x8a30d6c0, 0x378a4b60, 0xe31a95b5, 0xea3f7555, 0x98528e71, 0x9dbf6801, 0xb803b344, 0xad73044d, 0x0c5a3af0, 0xbc64d76e, 0x180e5046, 0x1fa4bf40, 0xc4d5547e, 0xba98514b, 0xc1451ab8, 0x5db3f8a5, 0x09686244, 0x04ff7924, 0x54f0ca0a, 0xb30232a7, 0x4e4aed13, 0x1b0876da, 0x48490be7, 0x00fd73a4, 0x74f06580, 0xc6e35e1e, 0x7740715b, 0x54451c76, 0xd505b482, 0x9d07997a, 0x416c0fe3, 0x9f8f5a1e, 0xf30e6574, 0xe36f7ad2, 0xe9df41e5, 0x0a21fb66, 0x7ad6e285, 0x84247cda, 0xf9dcf740, 0x05696319, 0x9cc5eff3, 0x3e9bf701, 0x8a93b2d2, 0xcde3e614, 0x26b7f496, 0xe39124bd, 0x8d916ed6, 0xb5e654c1, 0x79f1f2d0, 0x28430b29, 0xf4bdf361, 0xe440ef24, 0xf8616daa, 0x91f27fac, 0x2d0f12b7, 0xbaf38f36, 0x45902b04, 0xffd6a399, 0x3a15658b, 0x89c24189, 0xefd397e0, 0xc47e7eda, 0x4bbccd1a, 0x7dd892a6, 0xf92ec700, 0x04c5950a, 0x1bdf4006, 0x8d728a0f, 0x912fb6d9, 0x64d61c63, 0x6d076425, 0x00004507 };
const u32 bern_num_data372[128] = { 0xfbb2396f, 0xd48eefd6, 0x5b8fe0b5, 0xb0233227, 0x6f8c45ab, 0x58a56fff, 0x1ad00fc9, 0x56f332a4, 0x60967069, 0xb7fd9cd4, 0xc7c98a8d, 0x85f67d3c, 0x81e02e71, 0xa600de16, 0x76a7aca8, 0xec04dd26, 0x76c3ab26, 0x351bc5b6, 0x0c04203a, 0xf3897470, 0x6b999d72, 0x402a4061, 0xc9298458, 0x675e4ed1, 0x0e86c9fb, 0x479f9b6b, 0x7d96347d, 0x89359814, 0x96ae0836, 0xd4c22c9c, 0x0b8a2628, 0x34d5c84f, 0xe5c507ca, 0x1526dbb0, 0x5f2b16ce, 0x11e08f95, 0x6c99df8d, 0x25d82fba, 0xf3b6c336, 0xd051ad8e, 0x368688a2, 0x9ed9182b, 0x5b7f4d2e, 0x9f7b2e78, 0xaae40a4d, 0x6e2ae71d, 0xf2cf3954, 0x83c1586e, 0xfd8007ed, 0x689ef61b, 0x30e2d7e9, 0xd966718a, 0x170ea00f, 0xb8bfda7c, 0xff1d1055, 0x4e733d5a, 0x7e2ec070, 0xdfc707e0, 0x7a0a8381, 0xf701b71d, 0xabdbb028, 0x633d0ab1, 0x7d213b44, 0xa8f1f454, 0x96b1f3a5, 0xcee7f314, 0x3dd5da71, 0xf5d0dc1f, 0x51ae0c32, 0xf7929d22, 0xfc5fb210, 0x7df13e1f, 0x656749be, 0x278b06ce, 0x9d05e849, 0x51883570, 0xe52bdb61, 0xbffb55c5, 0x2319005b, 0x24f0f775, 0xb6b38fd0, 0xc3c0a274, 0x20c909cc, 0x0cd022cb, 0x68739228, 0x617a344c, 0xba7757fb, 0x356443ff, 0x0357a962, 0x124c8619, 0x050eaf4d, 0x9c0aaaf7, 0x83695b5b, 0xd8170fc1, 0x312edb4e, 0xa95140b4, 0xe5e6ed62, 0x7f212c6d, 0x1f3fc29b, 0xf2b7e5fc, 0xa8cfc182, 0x165e7376, 0xbb97d87d, 0x5a0e6394, 0x509e809d, 0x49a71cf9, 0xa2c80ed7, 0xd26dfe97, 0xab20706f, 0xe540fc1f, 0x67ec164a, 0xaef8b2fd, 0x45d0f11a, 0xe678e295, 0x57669b76, 0x48105f46, 0x614e40fd, 0x2f2e7dad, 0x156df397, 0xa103aa1b, 0xca65e2af, 0x82e2da16, 0xbb8a7d5a, 0xe694e155, 0x085381ee, 0x6ba154fe, 0xd72db07a, 0x000005b9 };
const u32 bern_num_data373[128] = { 0x5e2d388f, 0x1f2b62d1, 0x585c4de6, 0x82017b06, 0xd31ecd8c, 0x31725fb3, 0x0809dc8f, 0x258484d6, 0x27c7e512, 0x38556e7c, 0x94c77ced, 0x0d979c78, 0xfb02d9e1, 0x25775997, 0xca2e77ab, 0xaedd0a0c, 0xcca15041, 0x1c9f9515, 0x42dbfdcd, 0x4a2a7e07, 0xa771f0ed, 0x243dae7b, 0x094305a6, 0x316de390, 0x0e6901da, 0x9414f46c, 0xa54c7742, 0x854a834d, 0x7a070522, 0x87c617e0, 0x11e3287f, 0xb0517ce5, 0xed1329f3, 0x043141f5, 0xe6afd1b8, 0x868ec831, 0xe1e81e0f, 0x1602b49e, 0x71227be4, 0x9136570e, 0x8dbc795d, 0xd128bf79, 0x53999dc3, 0xe64a6509, 0xc42a681c, 0x82d1c477, 0x3381c7c1, 0x89e57980, 0xc5fafe75, 0x8dd1c7e3, 0xc3758510, 0x4b9f1536, 0xfe0d4427, 0x7e58ccee, 0x14532153, 0xc713db12, 0x92f6a959, 0x6055d5fd, 0xac729910, 0x15210355, 0x1634a09c, 0x2b0e8f9e, 0xb128c1f7, 0xadcd07fe, 0x9dba8763, 0x45daac90, 0x23bfef95, 0xac732d60, 0x74fe68f7, 0xaef50e94, 0xd6869c5d, 0xe8063248, 0xcabe183f, 0x743b4b2c, 0x719cfe94, 0xd9c03f87, 0x3bee76d0, 0xb0caef22, 0x54c1a4c7, 0xaa3ed55e, 0x56d3774d, 0x00cc2370, 0x69a0d904, 0xbc4612c0, 0x99148ab1, 0x8091d3a3, 0x519819cf, 0x32de00ae, 0xaadb19f7, 0x590d3827, 0x7aace09d, 0x78529932, 0x9b90f9b8, 0x6dae4584, 0x7f4fc56e, 0x412a9030, 0xff5d8764, 0xfaf32490, 0x89371d52, 0x5fee4471, 0x9375b216, 0x100ab35b, 0xf24c0b45, 0xb8f8c687, 0xe1e1eb0d, 0x763d9362, 0xe9bb93d0, 0x20aac384, 0x14d7afe4, 0x5b2555c9, 0xab70a278, 0x001e10c7, 0x74ef17bb, 0x248ed452, 0xc02cddc6, 0x347df615, 0xcb219e61, 0x39b5f382, 0x9f238991, 0x326ac67e, 0x7ce905dc, 0xcd998f8b, 0x5e501c7b, 0x820b208a, 0x15419210, 0x79087159, 0x42474973, 0x8e35822d };
const u32 bern_num_data374[130] = { 0xe4665daf, 0x725ba54c, 0x3df027ab, 0x48d8ae4d, 0xf57ee87c, 0x1ce47b6c, 0xfc506573, 0x4265a9f5, 0xf5bb25c7, 0xf59caf4a, 0x7d68e29e, 0xbda84014, 0x057e8867, 0xa5cd05aa, 0xb622273d, 0xb08ccc91, 0xe0865d99, 0x01afd45f, 0x83f5c6ba, 0xe6292381, 0xd9bd7a9f, 0xf3879eb6, 0x10e899a1, 0xce7f1702, 0xe74d4873, 0x7e5b7cee, 0x98dc2850, 0x980ee574, 0xbc63dcd2, 0x247454c2, 0x2433381a, 0x84c740b3, 0xf49ac8a0, 0x65d513fc, 0xb8f9edb3, 0x5fd5db37, 0x39f62ff9, 0x09e9bd3f, 0x96e7b133, 0x0a2b1cb4, 0x6ca5fbf1, 0xb7c20e6c, 0x4e555616, 0xf1f4776f, 0x4cbfeb9e, 0xee57dbe7, 0x5bf69f6f, 0x3ca6b9b5, 0x882af4f9, 0x30ba0a6a, 0xbfde26c0, 0xcb1dd507, 0xadbb29d3, 0xad4a5399, 0x571f8781, 0x180e28de, 0x2439120d, 0xa2e1b600, 0x66b6d00d, 0x26700df9, 0xc9c38572, 0x4dacf635, 0xa963baa5, 0xdea1c9a8, 0x70e57d39, 0xa8074ab5, 0xe1cc1fcb, 0xf6555eb6, 0xac9c37d7, 0x4ab7f249, 0x793ac4e9, 0x11e98a55, 0xf6f82ce2, 0xd239245d, 0x04abe410, 0x654ad52a, 0x4aa60be9, 0x007eae1e, 0x00cda865, 0xd2a4b7ff, 0x41e02413, 0x55667f56, 0x8cf9d32b, 0x188b8641, 0x9199d840, 0x77d86426, 0xc0acbc23, 0xb2782796, 0xf686f98a, 0x8bf13e68, 0x6c471afe, 0x1d6e0926, 0xbebe828c, 0xe6931170, 0x7b3497cc, 0x18faba25, 0x841589c2, 0x21a82c13, 0xd48d4c7b, 0x55cff30b, 0x82a5ce12, 0xfc56617a, 0xb65c8a63, 0x936412cf, 0xfc4b17af, 0xbeb200df, 0x2c88d628, 0xe72221aa, 0x8b1a8aaa, 0x5283dba1, 0x5d19a0b3, 0xafbf05e7, 0xb5dd47a9, 0x50decab2, 0xdee6edcf, 0x994e0b8f, 0x1bea3d54, 0x2692aa3a, 0x142985c3, 0x6cdd250b, 0x625f5d96, 0x279ba545, 0x331c9bf4, 0xddfe5144, 0x8553f5e5, 0xcfb87cb8, 0x85dc8da3, 0x90be8be9, 0x50ef2c02, 0x0000043f };
const u32 bern_num_data375[129] = { 0xdc49fde1, 0x25577e3e, 0x5b7cdfbc, 0x70db5a62, 0x8331db1c, 0x193a71c1, 0xba1faf64, 0xc05c20a9, 0x960fe934, 0xe0ce720e, 0xd60a5cd0, 0x1f669fa6, 0x62c7ec73, 0x8e4f0700, 0x84666d47, 0xf85fe001, 0x8a8f808e, 0xbf097b0f, 0x4f51f241, 0xafc56404, 0xda485ff6, 0xa0a7bbec, 0x8edf15c3, 0x865b9a93, 0x0497e9f6, 0xd43acae4, 0x57245627, 0xd387a730, 0x12384749, 0x9a38d376, 0xe56a3083, 0x1ff2a195, 0xdadfd9fd, 0x5958dcaf, 0x2c69fead, 0xd94e7256, 0xa3cb47bd, 0x2f17dad9, 0x9305b29f, 0xe3301b28, 0x9dcffab7, 0xc55d31f1, 0x86658068, 0xd7e79853, 0x72eb9cae, 0xe17e4c92, 0x95e7cf15, 0xac419657, 0xe0701176, 0x0e2e6c6d, 0x112e2531, 0x87b8c93c, 0x1abde591, 0x5bc8cab1, 0x00e8f3fb, 0xf74e162c, 0x8b962172, 0x13659883, 0xdee2a05c, 0x517baf3f, 0x3b8fd97a, 0x4d0de8a1, 0xbc239763, 0x563c80af, 0x521de356, 0xc845bc28, 0xb424d295, 0xf4dec219, 0x43703f2b, 0x75888499, 0xf574633c, 0x0629f258, 0xae13799f, 0xd1599712, 0x91b873c1, 0x5ebc7a0d, 0x0ef87e18, 0xd8d09aad, 0xbec1471b, 0x876cb513, 0x7ca0058a, 0xd57b1c13, 0xaeda39a7, 0x86ebf9c3, 0x02346a68, 0x611105d6, 0x1cd6d936, 0xfb27d539, 0xe6e7794a, 0x3a889eb3, 0xed7dd128, 0xbd85d5d3, 0x6b57d293, 0xde2d56ff, 0xb2c14ecd, 0x6a6d92f5, 0x09e68d80, 0xd40a2440, 0x78e50fa4, 0x5ca3cfab, 0x48192d37, 0xa3b0e25c, 0x714510e2, 0xcd84f46a, 0x17c8b055, 0x9e3fca91, 0xae2b79f0, 0x11ef397e, 0x5f625fb2, 0xc617d9f8, 0x006d6149, 0xab38b8d6, 0x79571a40, 0xcb60ffb9, 0x8d5bd155, 0xd0fd74db, 0x2d3e2c36, 0xca525d9f, 0x45522d15, 0xe10789d0, 0x1b9e2ab7, 0xdf04228a, 0x47b55574, 0x165837cf, 0xbcb388ee, 0x926ae83c, 0xa3ef1309, 0x0e9f90e6, 0x04fb4acf };
const u32 bern_num_data376[130] = { 0xc804e1a5, 0xd413a9ef, 0x8d041a6f, 0x2bd6376b, 0x698f914b, 0xefdc4324, 0xec8983ef, 0xc04e9e14, 0xceb0604c, 0xadb22631, 0x852b732b, 0x664f0a13, 0x40d73075, 0x2de62f35, 0x63ad84a9, 0xc5f7c85b, 0x17a56804, 0x753325ed, 0x4d8103fc, 0x987a5198, 0xe6bf86c5, 0x1b1f4aa9, 0x925c46a5, 0x4c3fcb80, 0xad460878, 0xa89c1cf0, 0x584f0e3f, 0x88d9038b, 0x903e7393, 0xf7c81b93, 0x15d57a3c, 0xdbc4c06e, 0x1e1b7195, 0x63b6ca30, 0x76c711ca, 0x02921a20, 0xf7a25cf5, 0x80f3f3f9, 0xf245c9a9, 0xc50883a9, 0x9596954c, 0xa7933c7e, 0x3fc45072, 0x9530b6a7, 0x57208abe, 0x02afa4b6, 0xd356e6ad, 0x83c046ef, 0xdd01ef60, 0x99e87ab9, 0xe33861d5, 0x03281e35, 0x633c2678, 0xd3d98184, 0x827f6b12, 0x1070c09f, 0x1043108a, 0xa0abcf33, 0x08a3ec05, 0x07f3b394, 0x34497d57, 0x9e97fcf9, 0x67c9ec25, 0x7de726ce, 0xc6b8629f, 0xa25f81a0, 0xf8cefda5, 0xb8dcbca5, 0xfda59f10, 0x90ea369d, 0x1f37fdb3, 0x2ef52531, 0x11a72542, 0x6e87ae86, 0x3c3a7bca, 0x550466d6, 0x9fca52fb, 0x12ab7a80, 0xf926f238, 0x044b99b3, 0x166ecb56, 0x330d781c, 0xfdaf3310, 0x7f214914, 0x4c0a3184, 0x3b359aad, 0xf0392e3f, 0x7ee10b27, 0x2a09346d, 0xd2fd17f7, 0x575228ca, 0xc5d23f82, 0x6959756e, 0x13622f99, 0x773ba24f, 0xd35c6380, 0x1e81b207, 0x01934428, 0xf545b6f7, 0x442d273f, 0x84c91a05, 0x2bb85c71, 0x07b16c06, 0x103d5e31, 0x9ddd2362, 0x863069e4, 0x19e0d61a, 0x7a0e750f, 0x35a51d3a, 0x7223637d, 0x3a0c0fdc, 0xb392b42c, 0x9be598f6, 0x9ad95b78, 0x0a0e2193, 0x421debbf, 0x3a3b76db, 0x136f51fe, 0x31742052, 0x3d413a5d, 0x1488a52c, 0xa941adc7, 0x39182517, 0xcc75901a, 0x0559f876, 0x39d0283f, 0x0dac99ee, 0x8a91c753, 0x40f6ef9d, 0x000000c2 };
const u32 bern_num_data377[132] = { 0xc9bb9bff, 0x8aab0eb9, 0x1f2619be, 0x6a61c32e, 0x75fe5950, 0xb158ef03, 0xa233462d, 0x1ac48e0a, 0xe5e92d1c, 0x07497c44, 0x2cf20f22, 0x951c159e, 0xbf175ec0, 0xeaf7b3a8, 0x48af8673, 0xec438447, 0x4eb73be3, 0x4ab24d37, 0xb7e107a7, 0xf7a60dc6, 0xd767c0c7, 0xca7fcdc5, 0xa22d9a0d, 0x5401c224, 0x6a1edc25, 0xc88f6316, 0xbd8dfa94, 0x89119cef, 0x684ebf4f, 0xb138849d, 0xb59c1090, 0x9cb1ae05, 0x936e1c65, 0xc2cc3d56, 0x963e7cd4, 0xc31acb59, 0xcb2322db, 0x145ae0f9, 0xb08d8abc, 0xc118c3a2, 0x1378a656, 0x444b7f2c, 0x1ed563e2, 0x98ee1538, 0xaaf8c2a3, 0x9cd01138, 0x4af5f64c, 0xf810680c, 0x5794d37b, 0x0eecb2a5, 0x2ebe6483, 0x0b1194a2, 0x40bcabb7, 0x0a79c904, 0xf60e5fc7, 0xa140dca4, 0x178a0bba, 0xba62d486, 0x7616f3bc, 0x2869e868, 0x031ed629, 0xf7c6441d, 0x6c43ab1a, 0x63922e02, 0xa8213a77, 0x93613a77, 0x7959f1e9, 0x0a4296cd, 0xbd600801, 0x8465ff24, 0xc5c044dd, 0xa1bf2361, 0xea3d0013, 0x552eae8e, 0x2215f8dc, 0x7eb72c47, 0xf7178af0, 0x2e52f4be, 0xefed3621, 0x2917ce82, 0x010f6f52, 0x4bac9930, 0x77b64886, 0xff266a21, 0xa68f9022, 0xb27108ec, 0xf3806a44, 0x00e3e68c, 0xa62ed6c3, 0xb10209ca, 0xfa47e569, 0x03114d15, 0xea6f4b4f, 0x262375a8, 0x574f7262, 0x4079aa1c, 0x63d03549, 0x72f8325a, 0x09dc1311, 0xc14e067d, 0xe6cbbd37, 0x6276a478, 0x3870951c, 0xf34e6050, 0x6c087104, 0xe28e5bec, 0x926d84c6, 0xdb066400, 0x8d5c7d71, 0x892932e4, 0x0c63d9e0, 0x927acf76, 0x644b3c10, 0xafb514d0, 0x77e2a2e1, 0xce601996, 0xa721921c, 0xae224c2d, 0xcfb3ddb0, 0x1d876466, 0x272684e5, 0x6f752650, 0xbc5fa052, 0x962d3f9f, 0x66f5e2ad, 0x0753214e, 0xc62e0527, 0xf0a16b2c, 0x0d1ca73c, 0x80b349bc, 0xf252b741, 0x00000ff7 };
const u32 bern_num_data378[130] = { 0x56242477, 0x7f16e7a8, 0xb4cc8344, 0x83814303, 0x4235f45a, 0x41279e6b, 0x26a81cf9, 0xa8edb4f2, 0xcd5b0e7d, 0x3c7144f5, 0xade97283, 0x3f85edee, 0x79cba15f, 0x7327f796, 0x6e2649ae, 0xbdfa8a04, 0xa5c33d01, 0xf0fe1b3e, 0x7938ae3d, 0xb73963d6, 0xdad120df, 0xa849e5f0, 0x3c1c3ad0, 0x55f0de3d, 0xa7258279, 0x6f29fddf, 0xec041099, 0xa0caf2ad, 0xf5782583, 0x0bd58352, 0x6164759d, 0x72f82785, 0xcacabcb8, 0x030404d9, 0xc2e64bf8, 0x6997af03, 0xbad1f062, 0xe7092c7e, 0x257bff2d, 0x0a1b449f, 0x7b8de882, 0x845a6517, 0x7ef17ef5, 0xc8ec732f, 0x39a69ae2, 0x5c0dc96d, 0x062ab8f5, 0x41610447, 0x186753ce, 0xeba448cd, 0xdd3d7fe6, 0x469d6304, 0xfb4c48da, 0xcc3bd7e3, 0x0f96e976, 0x73b568b6, 0xad6a2636, 0x1d89c442, 0x31a9c0be, 0x3bd9d5cf, 0x376e7d8e, 0x835b3499, 0x0b91cf2a, 0x60461f39, 0xb49ef86e, 0x4091b71e, 0x5a6e0901, 0xc7cc02fe, 0x54407017, 0xca4e1af5, 0x6aa59f6b, 0xbae1217c, 0xb0b7fd83, 0x7ce6c8b4, 0xcded45cf, 0x82c13409, 0x5695fb51, 0x88987e8a, 0x4b09cb20, 0x7e59aefb, 0x31a1385e, 0x1a7ed846, 0x42e40d01, 0x6dffd5ce, 0x2c2df80b, 0xd2582337, 0x37e87dc7, 0xec0e2e52, 0x4fa8ca0b, 0x9725a8a3, 0xf6e1fdd0, 0xbbdc410b, 0x4e7de619, 0x2ba780de, 0x5d9fc16d, 0x47a9133f, 0x8d5f4bcc, 0x31f3d574, 0x8bad0055, 0x3122e4fd, 0xe8f6e766, 0x29137923, 0xfc09355f, 0x713286b8, 0xd052db20, 0xc861d73a, 0xb9f8d7a5, 0x6881a839, 0xc95dca7b, 0x7ced6681, 0xb33a2a99, 0xc4eab296, 0x21e960c6, 0x890779be, 0xcc0d3626, 0x9057b1e7, 0x49820cbd, 0x081249a6, 0x097515ff, 0xbc7fb89a, 0xd68d6b3d, 0xa71d61ef, 0x4e31d254, 0x39b7122c, 0xfbd58922, 0x3d44177b, 0xc55a5aa2, 0x98070fb9, 0x30bbacdc, 0x293d469c };
const u32 bern_num_data379[132] = { 0xb35bdf75, 0xe8f9d150, 0xbbcf13e3, 0x69ed38e6, 0xf59d0d64, 0x8bd4fe7a, 0x5142476e, 0xcb1b3b43, 0xe737ed51, 0xf8371364, 0x619d29af, 0xfd335db1, 0xcb8345e3, 0x3d2fa2e2, 0x38a01d9e, 0x8027cefb, 0x94b285b9, 0xe6f06769, 0xe22a0e83, 0x8f648c8a, 0xda2fd7f3, 0xd364f341, 0x8727acfa, 0xfa495609, 0xbff71947, 0x24692541, 0x21951441, 0x3600ce5a, 0x96981cd5, 0xa16c9a23, 0xcfda9059, 0x34a6e779, 0x8318c141, 0xbc10bf04, 0x44ff961b, 0x2d9be2b1, 0xa9795d31, 0x7feb022f, 0xf820fa98, 0x4d41309f, 0x99c53719, 0xb1b8cfc4, 0x7cd2ea07, 0xaf1601a4, 0x2fcb4e81, 0x6fbc51dc, 0x43e5506a, 0xaafe3090, 0x6af420c9, 0x27586138, 0x2845070b, 0x5d019967, 0xd3ba4732, 0xe118d105, 0x81b9cd60, 0x9826b934, 0x2b2e50ab, 0x44c55652, 0xcfd6fe74, 0x4d8754e4, 0xe6d4453e, 0xc75cbe89, 0x06ece591, 0x202fe140, 0x02e0fd29, 0xfcb0a1f6, 0x3996cd06, 0x067d7508, 0xe2b87aa8, 0x1525e38b, 0x95b23344, 0x6393fe54, 0x7670e379, 0x600d5d85, 0xdadbc2a9, 0xbdc4748b, 0xe94546fe, 0xac3d6352, 0x80a5d47d, 0x7dcdc0c3, 0x2c035919, 0x01dabe90, 0xcc058599, 0x430fb312, 0x46faefee, 0xd19b077b, 0x59108447, 0xaad44ac2, 0x975f9f52, 0xc1df60e2, 0xbb326487, 0xc9c967df, 0x1baad160, 0x1ab4cef4, 0x6376d7aa, 0xf2bde5e3, 0x0e40243a, 0xcd09fc22, 0x1418d3a4, 0x046be656, 0x6aeaeae1, 0x4008f97f, 0xed3b1af2, 0x4bb9bfd4, 0x1eeb13f5, 0xf2d56549, 0xc30f2000, 0x52bc160a, 0x849cb8e0, 0xbe0fb037, 0x0511d335, 0x064fc804, 0x42e9be05, 0xffc82236, 0x7a51d4fa, 0xe310112a, 0x05a60c31, 0xcb17dea5, 0x40d0ec58, 0xb9b75fe7, 0xf76e0bf4, 0xc04c23c7, 0xece77c5a, 0x1049fc6e, 0xc5b52653, 0xfd034e7f, 0x8e51ae22, 0x938c70bc, 0xf3adccf1, 0x45a54f84, 0xa094ff22, 0x000000b3 };
const u32 bern_num_data380[131] = { 0xb5486ea9, 0x8a040b2b, 0xb605a9c1, 0x1049534c, 0x5ef29d4c, 0x4a7436c7, 0x0eb0a103, 0xe707ba1f, 0x256d968a, 0xc3f20524, 0x6c249aa0, 0x2cfd3f34, 0x50d5810b, 0xe4d3daf0, 0x74b24687, 0x9236f589, 0xfe721232, 0x3eced817, 0x9706caa4, 0xe2d296eb, 0x7310e2b2, 0xd7decaf5, 0xb312f4ce, 0xb2448b3e, 0xc194b75d, 0xbbee82e7, 0x0974bf17, 0xdef296a7, 0x63854047, 0x7cd58e76, 0xbc8ec9ff, 0x9a1cb591, 0x7ed05a1b, 0xead1269f, 0x04d75ee7, 0xff3b6d79, 0xf5dc1631, 0x4a703570, 0x76902943, 0xbe36bc00, 0x3ce06850, 0xcd1595cb, 0x30afae8d, 0x9a63cdd5, 0xa6cbf3ee, 0xf6ee550d, 0x1da901a0, 0xa64febbd, 0x61e17bfe, 0xa9d32e41, 0x86adc8ed, 0xd051718b, 0x426c13b3, 0xa0ef60fb, 0x5e267423, 0xa747db35, 0x7df0ca9e, 0xe16c74e6, 0x8dcc34c0, 0x40ccc8e7, 0xbf15fbd6, 0xd62fe4cd, 0x07428267, 0x139c7633, 0xa9dad88f, 0x98ee6df5, 0xdde901be, 0x01f08c2f, 0xa960e49c, 0x89a6cff2, 0xe79de605, 0x4f17d2a1, 0x189c7132, 0xc478070a, 0x59a15183, 0xf703bcef, 0x22998803, 0xd9b7d296, 0x31d1203b, 0xa196a475, 0xb3d3ef5b, 0x3f80d2d4, 0x0ea75ad8, 0xa1086371, 0xe2990950, 0x51abb97a, 0x40be1454, 0xcce3a327, 0x83de46b5, 0x71b7406d, 0x631de12c, 0xd38a1115, 0xe58b116e, 0xfd1fad10, 0xd0cf6d7c, 0x9f53a2cd, 0x2606bbc8, 0xfdd7aa77, 0xd1ce273d, 0xad9855ee, 0x1b1bf267, 0x6d5bf706, 0xd49ca2c5, 0x03683257, 0x4d8d751b, 0xa7d9d36c, 0x7189589f, 0xf362dee2, 0x058d2569, 0xe4dc7df2, 0x1dc824c8, 0xca64c5ca, 0x7ade01a9, 0xe6cd53b4, 0xfb1f7231, 0xd8c53b62, 0xaf32f91f, 0x43c4d9a0, 0xf9164677, 0xc48eed0a, 0xda67feb3, 0xbca7dde5, 0x2ef7eb27, 0x41d11ac0, 0x85b84d31, 0xba00c37f, 0xb85fd95d, 0x546e545c, 0x60fa45fc, 0x3e16a5ff, 0x0e6ce218 };
const u32 bern_num_data381[132] = { 0x1c54d817, 0x3f85d21b, 0x23f93a70, 0x34f79c71, 0xf8b1828c, 0x6c7e4223, 0x7d9a4872, 0x9f7f1a7d, 0x36a27141, 0x93497924, 0x56b72e52, 0x3a013f93, 0xff443a42, 0x0a99aff1, 0x83fa2195, 0x5b5d6b84, 0x1078a912, 0x8a5f6b5b, 0x9727d482, 0xf138fc7f, 0xb15bc641, 0x612c5695, 0x1dc86b4e, 0x1264783b, 0xfb0dec7c, 0xfbec57c3, 0xdf6b1b0c, 0x2e885f1f, 0x94dfc328, 0x2b951c3b, 0x7bc26024, 0xb4485e5e, 0x4dcba636, 0x399e156b, 0x5a295b1e, 0x85a65bec, 0xf2bea2f7, 0x226a27b1, 0x3ccbcfd1, 0xe377408d, 0xa7046dfa, 0x1c235a8d, 0xeb369ecd, 0x60fe668e, 0x5563b535, 0xbaea05c2, 0xbd70eeed, 0x406011e6, 0x4c3b20ee, 0x366fda62, 0x4bf2f1e3, 0xf91a9b8d, 0xb51473b2, 0x66fbcc52, 0x114e6ba1, 0x757dafcc, 0xa9873036, 0xf2502cac, 0x04ab977c, 0x29e86876, 0x6b6dbdaf, 0x2dae44c7, 0x003df8be, 0x1282206c, 0xe7396faa, 0x0c0d5dee, 0x54d384c9, 0x5f20a79f, 0x6c25dc57, 0xd33d5e6a, 0xf11e759e, 0x0bfcbbf7, 0xc3ca3474, 0x2d0af32a, 0xf29e9657, 0x931cbea4, 0x3f9ed7ba, 0x756ed0c4, 0x29fe0cc5, 0xae082c0a, 0xbd17bbd3, 0x2a993adf, 0x88d2ed55, 0xf8f29d98, 0x825fb44d, 0x143db3d9, 0xdb3a6eea, 0xc4880076, 0xa7809714, 0x1c2728f0, 0xde2632db, 0x995cec32, 0x5e96bcc8, 0x63f6fbba, 0x30a36f96, 0x7d011d96, 0xee52c684, 0x15dce5ec, 0x5c723d86, 0xedd04f87, 0xd50f022b, 0xc4329d7f, 0xe2ff9ac7, 0x0c038948, 0x9c069c1b, 0xf11ed32e, 0xb49dccaf, 0x4b0548de, 0xe48dd2b7, 0x95c9599c, 0x6ba886b3, 0x5d71f5b2, 0xe338940d, 0x0bed566f, 0x453c0912, 0xfd2c9b0b, 0x2f44f768, 0xcc920682, 0xf3e1d04e, 0xab6c4f53, 0x580de132, 0x47abde55, 0xa2a227ec, 0x6aed4546, 0x2ea3ee3a, 0x0452f0de, 0x72f5b4c7, 0x41007617, 0x999279ef, 0x9c51a8fe, 0x288f3fe2, 0x00037926 };
const u32 bern_num_data382[132] = { 0xc5a859a7, 0x3d91d2a4, 0x3ec7a895, 0x2025d0b1, 0xf7410d90, 0xff6ae335, 0xf2a53fe6, 0x2fd0ddbf, 0x071e8172, 0x5cfef262, 0xcaca5dfd, 0x8a8a6d93, 0x5ac73ba6, 0xbe8e0c37, 0x0c94419e, 0x210f53ae, 0x50024710, 0x28517215, 0x9d1f1a4e, 0x2cc8061f, 0x6332b57b, 0xb3504b30, 0x7d6e495f, 0x50c63aac, 0xa1bab2ae, 0xdbb9a9c1, 0x2cef320e, 0x82f5c6a7, 0x4972b838, 0x98aafe53, 0x4f9069ce, 0xc19f02a7, 0xd03fc3f7, 0xd3166275, 0x79d9a542, 0x4a46d69d, 0x9de2716a, 0x61206124, 0x57eee28c, 0x7a074800, 0x791201f3, 0x9b1769ef, 0x8ac95825, 0x874267ac, 0xf704d814, 0x66b2bd26, 0x091e6bcc, 0x77ba16b6, 0x830e784f, 0xdb2b8029, 0xe8430973, 0x32ca0c2e, 0xfa03648f, 0xdd18d1ee, 0x143cdc60, 0xbfa3e035, 0x0076e72d, 0x87081051, 0x80b274d2, 0xa39c1fe8, 0xe2f2ca80, 0x088b996c, 0x4c8092a1, 0x1f9707a9, 0x103574bd, 0x45cbebef, 0x1ce1faaa, 0x73cee9d1, 0x9e89de63, 0x364d521c, 0x253ef319, 0x59ded285, 0x14fb3b5f, 0x05d2b306, 0x02e57608, 0x53c267dc, 0x21e6b930, 0xa81e39db, 0x5a618188, 0x3a4da209, 0x1dea7dcc, 0x68feec58, 0x74e721f2, 0xbbd9a6cd, 0x24dd44f3, 0xf3d1c937, 0x9ddb0f4b, 0x26ec71b0, 0xad5f5ad5, 0x1e9d386b, 0xdcf6d75f, 0x203f3d0e, 0xd2e8e31e, 0x36ed8cd3, 0x575ecb48, 0x61bbe791, 0xe6a38223, 0xa711ee76, 0x159272e8, 0xf6610b89, 0x22d48bb9, 0x3e17323f, 0xdb89cbd7, 0x0869d88f, 0x33cbeb9c, 0x2e4101fa, 0x13f38a78, 0x6fb364f7, 0x0083fd2b, 0xafcc39f0, 0xe49acbde, 0x47254d75, 0x921be5f5, 0xf7e6265c, 0x448fca06, 0x98de4076, 0x73190ccd, 0xad2584e9, 0xbe38bb46, 0xa9471d36, 0x295304b1, 0x13f5b1f7, 0x583eecf0, 0xe4b40f1a, 0x747e5b45, 0xaef78b81, 0xed8d7b44, 0xd2316c71, 0x1346e211, 0x63314696, 0x68917424, 0x001aebdb };
const u32 bern_num_data383[134] = { 0x4c3dc1bb, 0x37d8f651, 0xd8723b7f, 0xc5e1a904, 0x054b99ab, 0xe732b44a, 0xc0a676a1, 0xc91ecfb4, 0x9518d118, 0xf7c2945c, 0x86108d16, 0x8be482dc, 0x3ad29840, 0xfd870ba0, 0xda24e50a, 0xc9627ded, 0xab454119, 0x22dac594, 0x46683ef0, 0x5be8261f, 0xd598f84a, 0xb42d59ba, 0x342c3654, 0x99eee27e, 0x45ead3d9, 0x989bf57c, 0x275dc9a1, 0xca21ad07, 0x6884a1cc, 0xa07c2742, 0x770c5df7, 0x416fc6ec, 0x3ef50766, 0xb626d363, 0x10cf15d9, 0x29eba296, 0x2674d2f2, 0xbb21a280, 0x1c415571, 0x683db9ac, 0xda6b42d9, 0x129ccc44, 0x904add7f, 0x36a911c9, 0xb822c252, 0xfa89af93, 0x55a8d44f, 0x3f2a37f3, 0x7a3c46bd, 0xff4d4473, 0x00e74c54, 0xf9371aa0, 0x34add778, 0x3ad0be2d, 0xcfc3ce7f, 0x3943cb70, 0xf9dd6505, 0xb420f424, 0x7c733d49, 0x3331a9b4, 0xdee0929f, 0x7c1e918e, 0x47ef6623, 0xe8697674, 0xf1db92da, 0x0fba74e3, 0x4edf9e01, 0x90544828, 0xd9638f6c, 0xdc0d12af, 0x92c0793e, 0xece0bec7, 0x8d3848fd, 0x71429876, 0x1219e413, 0x96d28441, 0x323f7cb5, 0x76c337f0, 0x9d70e8f3, 0x0644d72a, 0x95ae78dd, 0x5acf9aff, 0x1147e5fd, 0x86037364, 0xe730ae4f, 0xfea29d48, 0x8a027329, 0x71a39fcc, 0x10ac195e, 0x564a67c0, 0xad012693, 0x40be4264, 0xe96bdfaa, 0xeb2d963b, 0xd95b3ef1, 0x17f6293b, 0x439c8571, 0x9b65b512, 0x0671952d, 0x90745050, 0x4a7c5966, 0x4529af74, 0xdb9c31fa, 0x24062ddb, 0x6fee8d7a, 0x38e6e442, 0x5fffc4a5, 0x32134b08, 0xcd0f6632, 0xe2ae9afa, 0x3c9e12fa, 0xf0bf544b, 0x6e8f03f0, 0x0f934a6b, 0x0b18a31c, 0xc7db0d02, 0x7882bf26, 0x8d287b6e, 0xf2bf3622, 0x433f8b97, 0x0d04a641, 0x255bd6c9, 0x494dd897, 0x1f26976d, 0xb814b3a0, 0x145b7a69, 0x58884524, 0xc37a0cc9, 0xa008eb83, 0x2591a6e3, 0x0fdfe4a8, 0x94349c85, 0x8bd861c7, 0x00009f89 };
const u32 bern_num_data384[133] = { 0x2a369fd5, 0xdb3bf8d9, 0xeb487185, 0x35b3b967, 0x53017d8c, 0x8d870102, 0x53003b95, 0xd368b239, 0xfeb691c8, 0xb641c97d, 0x70a75a0d, 0xf6803956, 0xd6e4f834, 0x6c81dd31, 0xaf87b751, 0x84c56692, 0x878bf6b7, 0x78702a7c, 0xeb7b5f4c, 0x69fc3500, 0x8dc8d839, 0xb900eb2e, 0x736ca5f8, 0xdcf3377b, 0x3d86ba38, 0x5d876cbc, 0xc0c10f23, 0x4f9ea195, 0x3904fee6, 0xc5505c54, 0xdac7dc59, 0xe7c71ae0, 0x04331d61, 0xccae20a8, 0x341943cd, 0xb8d9e2f8, 0x42d0655e, 0x8ddb1e81, 0x60390268, 0x300b22ae, 0x34a8dec2, 0xa85c970e, 0x2f407561, 0x1b81865c, 0x15563d03, 0xd2ee4870, 0x0f0a34d7, 0x690376e5, 0x29dd4ed3, 0xcbddb9e9, 0x79481f26, 0xa426a164, 0x5e3127d3, 0x6b645458, 0x0cb069c9, 0x247f500e, 0x7b4e1b8e, 0x17a42170, 0x39186d75, 0xcfb79f8f, 0x4563da81, 0xb7e0510b, 0xed73c682, 0xd8c1972f, 0xebead442, 0x30ba2f3e, 0xbd09e93c, 0x4f9b2c54, 0xd1d300c1, 0xc38104be, 0xa2e17017, 0x9331d6cf, 0x5d96cb6b, 0xe0a68d6e, 0xe06555c8, 0xb9d0ee20, 0xb220a89f, 0x91254457, 0xad394980, 0xf497a80e, 0x77f2a1d6, 0x97bfa3da, 0x6efc960a, 0x155623e2, 0xfa15698e, 0xe5c55233, 0x089d21ad, 0x76352bc0, 0x349420e4, 0x05db6bf3, 0x209dbac4, 0x1324a11d, 0xef41df59, 0x9d153ce2, 0x029bb4af, 0x67ba6477, 0xd81382cc, 0xa6f390bc, 0x8442d7d4, 0x8bfc6201, 0xef03ff3d, 0xf210dbea, 0xc64eac9d, 0x2c1786d5, 0x9841f790, 0x2b9a6595, 0x7f3da7b9, 0x20c0b3d7, 0xaf811741, 0xe0077867, 0xb76ae3a5, 0x327ff34e, 0xd022caff, 0x08451426, 0x64183bf1, 0x119ced8e, 0x94a857b4, 0x48f3b8c5, 0x0b055842, 0xd52deddc, 0x7d5fe510, 0xf3d6f58d, 0x99409342, 0xea97a9eb, 0xfc45d05a, 0xa73c713f, 0xda301320, 0x863756da, 0xad93f9fe, 0x90c89d94, 0xefdadfa6, 0x5ec2b5bf, 0x626e32a2 };
const u32 bern_num_data385[134] = { 0xe3d318dd, 0xf7e40232, 0xe5ae1829, 0x781fb902, 0xa86a3a46, 0x4deb0125, 0x34fda7c1, 0xbd4ed797, 0x6a3639ad, 0x02c42a20, 0x27253990, 0x5b200601, 0x8a8180ac, 0x8ae5fa5f, 0x3ef03dfe, 0x3750da97, 0x89adce4f, 0x654bbefc, 0x8db37481, 0x5f5df299, 0x9d063119, 0x5d4a56ff, 0x03a93581, 0x9cb5f5b9, 0xcc90e52c, 0xfcab57f5, 0x76afbbc9, 0x1ee98f6f, 0x1eb7b4a4, 0x4d58ecc1, 0xe8460b81, 0x4d4280c4, 0xbf6fcea5, 0x00a8c303, 0x6d359ea7, 0x13a0287b, 0x20bb281f, 0xc6a6f9be, 0x5dc3c33b, 0x8ec959ff, 0xb7375611, 0x807f1438, 0x5cd788a2, 0x983adfea, 0x4caabda2, 0x0efdc490, 0x7f2d388c, 0xf8eeb3f4, 0x5bf1e54d, 0x224deb06, 0x80d33b36, 0xc85cba67, 0x2b33940a, 0x748a6e0a, 0x090686b1, 0xbae9830b, 0xa895a37d, 0x7dab813d, 0x498b8597, 0xf14e4882, 0xeef406b9, 0xc19e255c, 0xb4097e84, 0xf3c70191, 0x4e04243d, 0x473f5b59, 0x06034b64, 0x5aeb8926, 0x2480c866, 0x513d614b, 0x465551ef, 0x96ed588f, 0xc3c72260, 0x23a7b35c, 0x6abff74a, 0x5a8f9a64, 0x2a46caa1, 0xaff6db39, 0xc7197e90, 0xa09b2341, 0xd168ddfd, 0x6cd56f3c, 0xd546ca7c, 0xc067e636, 0x0f7474aa, 0x7507b918, 0x10405fac, 0x0899d14b, 0x7ec202d6, 0x9d9d62f3, 0x472a2072, 0x8bf55271, 0x560bbe50, 0x41e0d368, 0xdddf5b68, 0x79ef50a5, 0x38cbca93, 0x049325ae, 0xb84be215, 0x1331bc1a, 0x5f628ae0, 0x7e6451b9, 0x3f944b6a, 0x0ab15441, 0x7b76cfab, 0x03ae4aec, 0x05393086, 0xfed59044, 0x7f8b1b47, 0x381cc6d3, 0x2a9af330, 0x2a5bafc7, 0xee1e25b2, 0x6f91ae8b, 0x12deaca1, 0x0cb27ce0, 0x8fc10d35, 0x5cf0d7ac, 0xf3293dfe, 0x1d2d7666, 0x6118ee45, 0x472aeec3, 0x09bdcb46, 0xad74e221, 0x74213e37, 0x965214c8, 0xb7ed9d7f, 0x9d6b7734, 0xd0cd0876, 0x99837ec4, 0x2b83e640, 0xa32e273b, 0x4dae3729, 0x000004df };
const u32 bern_num_data386[134] = { 0xd813d7b3, 0xa1ff001f, 0x15963b51, 0x7a84e260, 0x212f1ceb, 0x93a64540, 0x0986bc70, 0x45d733fb, 0x949f8b56, 0x1bb38689, 0x2e47a860, 0x81f23763, 0x4a5e7cd6, 0x7bda024b, 0x7225de80, 0x39586ee3, 0x0e166acb, 0x954b86f8, 0x592dc134, 0x7cd7f03c, 0x104f2f27, 0xbf31fc0e, 0xcc791b3b, 0xb49f6a4e, 0x559c6c17, 0x00fc9ed2, 0x260b20a4, 0x74642c1a, 0x0117f4e0, 0x4137934e, 0x3d90c5c4, 0x7c9026df, 0x418c0b46, 0x66c2145c, 0x73706860, 0x46748231, 0x0c90b53c, 0x844ee6f7, 0x60c9b9a7, 0x59223f8e, 0xbc998e13, 0x1976bee4, 0xfea14a69, 0x4e8c96ee, 0xbd937341, 0xfcdd7d2a, 0x30cb2faf, 0x3427b0c1, 0x67f0e29c, 0x0528cb59, 0x3ae1bdfe, 0xc814db72, 0xcc605950, 0x05273384, 0x1a3d8cb2, 0xfcdc28dd, 0x98b79ada, 0x8e80cef2, 0x34cf4f7d, 0x8d9c0149, 0x0dbfad88, 0x3ac83a7c, 0x72a1175a, 0x7d9aaa91, 0xdc8525ee, 0xba60c5a8, 0x7f9f98ad, 0x3f67c08b, 0xa102b37b, 0x24fd7455, 0x1d55739e, 0xd5894280, 0xf338a2d4, 0xce465215, 0xdeeaf96b, 0x16291f44, 0xef12aa76, 0x5370528e, 0x2a75d6bf, 0x66ef7818, 0xdfd10e24, 0x7642b36e, 0x8ef325e9, 0xd37c13a9, 0xb44ce5cb, 0x42ba96ee, 0x8c8aaaef, 0x2fd0ed7c, 0x5cf41bbc, 0x32a7ac59, 0x926e003b, 0x1073667f, 0xc6e3a3c8, 0xa13a468a, 0xd6e1fb64, 0x0874fbf1, 0x9a5369c5, 0xbded7f8d, 0x6bdb79f2, 0x817cd1d5, 0x37146d4d, 0xfa1b991c, 0xc6fcbce4, 0x40466bb3, 0xb9f61dd0, 0xedcc9f7a, 0xd2f2ce0c, 0xd14979e0, 0x2e1bb9e2, 0xfe5c1c7f, 0x51f93de3, 0x5905c0d6, 0x0fe11b2f, 0x16576c42, 0x8a1382ec, 0x5989033f, 0xa072c428, 0xa54148e8, 0x752727ab, 0x64eadb22, 0x10b51566, 0xade58687, 0xd65c733c, 0xc52241da, 0x17fa8291, 0x70f6546c, 0xf9909eaf, 0xde34efad, 0x0ae439bd, 0x626a9e5f, 0x9757843a, 0xa320cff6, 0x8be4fc48, 0x0009ecf1 };
const u32 bern_num_data387[135] = { 0xd7558d05, 0x6c5c4800, 0xff5827ac, 0x8a16f9f4, 0xa6cbf606, 0x4788a7f1, 0x704b0e85, 0x68e9c0f6, 0x4e3a7d79, 0xe03d86db, 0x6bfb56ce, 0x55ab14de, 0x8a7d871a, 0x84ba17b2, 0x8f5a3360, 0x1218319c, 0x48584d8f, 0xb1a56d67, 0x53b76bc1, 0xaceedb64, 0xef4f2dbb, 0x2c613718, 0xa7a52e4b, 0x568ef3fa, 0xc72522c8, 0x5b9f15d4, 0x26b8fa3b, 0x3be97f0d, 0x1eaf776f, 0x85e1befe, 0x23c2e317, 0xcbc1127e, 0xa4dccd30, 0xfa35a181, 0x9331c680, 0x2203cb38, 0x163e080c, 0x74c9a8d4, 0x65e2a98e, 0x75aed828, 0xefca3a3c, 0x78c4d913, 0xbdd729bd, 0x886d7601, 0xe0e38e4d, 0x4f130618, 0xa8c89435, 0x07c8a620, 0xf1233c6d, 0x8d643614, 0x58cc4bfd, 0x1c8ff99a, 0x2b6ac484, 0x1f325aa9, 0x813f7865, 0xb38063e7, 0x06e9d5a5, 0x5f1a3ce4, 0xfd731c33, 0xa7dc7cb2, 0x66613020, 0x16983d98, 0x591aae14, 0x369bcbe0, 0x017762ff, 0xb941cfb9, 0x5604d03a, 0xbd4228d6, 0xcf25f674, 0xcf5d8765, 0x5cb2d403, 0x0723847f, 0x2d68ae1f, 0x5f1d006f, 0x0db43b4d, 0xd536e43e, 0xe9ee23bd, 0xa8a8e93a, 0x5f0e0563, 0x8b4763ae, 0x5cf86238, 0xbd8ba3ba, 0x40b07149, 0x90225151, 0x202cbc8e, 0xa7a3b62b, 0x04f46787, 0x327beb5c, 0xd86c322d, 0x1178afa6, 0x25a0500c, 0xcd52c68c, 0xdf3bf239, 0x58dedc5a, 0xc0f2dd73, 0x016ff068, 0x0c3ea659, 0x31f4dd6c, 0x56a86e1d, 0x7e3fbd9b, 0x8302b70d, 0xa850a522, 0x5147b969, 0x3d123e36, 0xc9358bdf, 0xc87c2ab6, 0xcb18c878, 0xfc6c4c10, 0xdc9745d1, 0x89610697, 0x1f985cb7, 0x54ab25de, 0x0c4efcd9, 0x4da042e2, 0xa0aedf03, 0x72f04afe, 0x67878088, 0x2aa01657, 0xd55f71ab, 0xdbec7379, 0x51fc0c82, 0xdc057045, 0x4e06f385, 0xf749ee2f, 0x7b999794, 0x4fcf9be9, 0x061069ca, 0x648e4067, 0xb4e9f02a, 0x31b5e783, 0x15aed648, 0xe43ff799, 0x4298ef01, 0xbd794240, 0x00000021 };
const u32 bern_num_data388[135] = { 0xe251ce2f, 0xc9aa3c5f, 0xb28e64e4, 0x2e4b6403, 0x8357b0ba, 0xfef9f222, 0x590dc64c, 0xe0403f17, 0x63ad5480, 0xe6f969ce, 0x104694ba, 0x5614952b, 0x35b9a95e, 0x6aee75a9, 0x8ed66138, 0x7eef2aa3, 0x1e2122a6, 0x82a3ef74, 0xe43f620c, 0x07e35d23, 0x909862a3, 0x6347943d, 0x38c43272, 0xe797bfa3, 0x74605be7, 0xee0f4732, 0x8a4ebbfe, 0x453df091, 0xf33a1bfe, 0x4403903a, 0x5ae0be81, 0x49d8b0a2, 0x6e61628d, 0x2a937fb3, 0x83d0e857, 0xc2fab837, 0x6d6f8e19, 0xc8cf383c, 0xfdc5b830, 0xfff0ca61, 0xb065630d, 0xa6b4105b, 0x84a6a190, 0xf8bd0358, 0x5af4d5f3, 0x1e3b982d, 0x2bff7df2, 0x48dbea04, 0x2fa3b465, 0x7091378b, 0x0f222526, 0xf4886bc6, 0x2e8cf66b, 0x0102d798, 0xcbcad758, 0xceeabb42, 0xb6c09dff, 0x558f9ef6, 0xed6f33cf, 0xd0beb617, 0x023fe174, 0x7c601b50, 0x3f5ccb09, 0x59d2ea2a, 0xaa091860, 0xc24f1d4c, 0x2d68f4af, 0x6511e0d6, 0x3e15db6f, 0xc95ed822, 0xd89c6962, 0x68dfa915, 0xa8bf5d89, 0xda4073d2, 0x1bad1c3a, 0xe843d239, 0x948c58bb, 0xde01ace7, 0xb530f2c6, 0x6ed7ef78, 0x1d01e04d, 0xdcc945fa, 0x3082fac4, 0x7ba9540c, 0x8d4790bf, 0x91f9c430, 0xaa5c0467, 0x127e0d06, 0x2a9b8480, 0x183207ac, 0x2fc17a11, 0x6ce9c762, 0x0efe15be, 0x15bee49f, 0xba11ec89, 0x2627cc68, 0x1151d5cb, 0x359e77fe, 0x5e0f0a48, 0xf3d640b9, 0xa4d54bf5, 0xb99067b1, 0x5d071ea1, 0x514e3531, 0x67ca5ee9, 0x1d3167dd, 0xfd2ed360, 0x036fa5d5, 0x45ae42ce, 0xfe09108c, 0x562f1c99, 0xa4ab316f, 0x93d7f824, 0xff00d452, 0xbb38eb5c, 0xa532dbdd, 0x3e5c2fa0, 0x9b87a15f, 0xba8fe5e8, 0x846b59de, 0x7b94b07c, 0xf53d6b78, 0xfca6b96b, 0x12cbc368, 0xb16dc8f1, 0x9ef5fd30, 0x0cba4522, 0x6614bbef, 0x70db2c32, 0x36695889, 0x30534207, 0xf7feed9d, 0x68e51533, 0x9fdbceb6, 0x00000109 };
const u32 bern_num_data389[137] = { 0x49c5a077, 0x740c25cb, 0x2f635495, 0x0e430ffb, 0xeac4f34e, 0x9b1f1296, 0x7f2f115a, 0x1b20989b, 0x31e90c19, 0x262f6602, 0x4e2e0463, 0x36f617ee, 0xdabf5d81, 0x2ff48b6b, 0xb7f9361c, 0x4e3f3409, 0x9328ea95, 0xac079861, 0x710b4b89, 0x49aac70f, 0x007cfb26, 0xd595295f, 0x7a40b5eb, 0xa4b99d38, 0xc7a9b11d, 0xc5eecd3e, 0x8185bb42, 0xaa1d6115, 0x0281891d, 0x835d7ce0, 0x4e5bb473, 0xae9bee5c, 0x806ff629, 0xa9e2d3b7, 0xec049f53, 0xd3d191a0, 0x648d793f, 0x8f94c40d, 0xe996f8f2, 0x2c690367, 0xc484aa49, 0x90793429, 0x038c72d3, 0x1dd386ac, 0x22b48206, 0x2dc2d438, 0xec907682, 0x6125f12f, 0x1eb60bda, 0x73cd76ff, 0x401f9c00, 0x57c0c892, 0x9d2ebc19, 0x7b1f643f, 0x3469f905, 0xd071d568, 0x78a1f4df, 0x0247b19e, 0x6bc079fb, 0x89011f71, 0x836e274d, 0x32394851, 0xc4b41441, 0x87d7eaea, 0x9fe984ee, 0x9e7220a1, 0x3055effa, 0x57809967, 0x3fecaf8b, 0x6636ca2f, 0xaea07791, 0x5014a082, 0x1be50497, 0x34402b83, 0x839ce1ea, 0xf0cb049d, 0x47db0c79, 0x98ee619f, 0xdd927daa, 0xc9123b56, 0xf6a2e80f, 0xeef5ab5f, 0x58f1a996, 0xc01eae7d, 0x0f6da333, 0xe24e6a62, 0x14942c13, 0x150aa9f4, 0xe073d1a8, 0xa704be44, 0x3f3caba7, 0x141efa62, 0x9caae9e4, 0xf992666f, 0x8005058e, 0xb9d5bd64, 0xcf005643, 0x3f8cae79, 0x0cd14b5c, 0xe684844d, 0x13260326, 0xf3cc33c7, 0xaaab60be, 0xd481eb53, 0x33903e19, 0xb43de7af, 0x64dea060, 0xbc7c66c9, 0x8455d57a, 0x106646ef, 0xe61c9ff7, 0xe4a7fc8a, 0xb41a7a24, 0x774fed28, 0x90f0400a, 0xca8c2c50, 0x31336586, 0x94b211f5, 0x0bf316e7, 0x4d1f2f74, 0x2104a9cd, 0xa912d5cb, 0x50e21343, 0x1cdd887c, 0xc19e47a1, 0x762d7249, 0xd00f9cea, 0xb838237d, 0x9687adf1, 0xfe131d13, 0xa7dbc23d, 0xc1f329e9, 0x2212f0ca, 0xa8cfb689, 0xa38837a2, 0xa14f66f4, 0x000000b4 };
const u32 bern_num_data390[136] = { 0xe0ffef49, 0xc090f219, 0x851ded96, 0x2d23a5ef, 0x117c508e, 0x86f05105, 0x18081c95, 0x46b2dd0d, 0xa52ad900, 0x31cf48d2, 0x263b6222, 0x0325b6b9, 0x7c6462c1, 0x82d8345c, 0xd0df010d, 0x5dd09273, 0xec70089f, 0xb9bf0aa3, 0x48c16262, 0x58e918f2, 0xf275391e, 0xc1a79d6b, 0x99ebec40, 0xa8410e66, 0xa1c1f3fd, 0xb55e4146, 0x77a49fc7, 0x4defcbbb, 0xa3e17c8e, 0xbe5ada31, 0xd1530aad, 0x6743ae42, 0x25885437, 0x43e7ca07, 0x39e253ae, 0x8cb75480, 0xe469a997, 0x77037634, 0xa84c1477, 0x646424f1, 0x8ba4dde3, 0x529bd286, 0x1dffe490, 0x427a84bc, 0x813e34d4, 0xf4dab73f, 0x614bfa0f, 0x04d4cc18, 0x9cbe4368, 0x710888ba, 0xbb2cc6e5, 0x347045f4, 0x74a6a5a5, 0xf04c9ca5, 0xa916129a, 0x84d7f3be, 0x474fc782, 0x7f610f3f, 0x8dcdc4f5, 0x27193cb5, 0x4291b9c1, 0x315a479b, 0xe8e6af49, 0xef114760, 0xa4dcbf71, 0x54903a5d, 0x94f746e1, 0xb342b3cb, 0x110c7b5e, 0x1be0fd64, 0x1aa1f12f, 0x11602075, 0xc1f5b74c, 0x2cdef23c, 0xc21088a6, 0xb59612e7, 0x4c9624bb, 0xab1d88ea, 0x359e40e1, 0x37201832, 0x3543ab89, 0xafea7d11, 0x72f90aa7, 0xcd90f556, 0x2a1b4187, 0x7e86d1ac, 0x8673702f, 0xf8a25416, 0x50afba79, 0xe62baa76, 0xa46ef55d, 0xe5c49326, 0xd48c4d99, 0x34954767, 0xd9eca424, 0xa198e3db, 0x8db99a12, 0xb3f3ddbd, 0xfce82343, 0x0f29597f, 0xcfa94874, 0xf65b9bf9, 0xf55e3712, 0xf5b9fa2d, 0xc9b066a8, 0xcd0f7096, 0x46c697cd, 0x663261c2, 0x21f33669, 0x0f42ff10, 0x0290c13a, 0xa86806eb, 0x6609cd34, 0xd550f07b, 0xf3f41387, 0x67858c28, 0x46f9e28b, 0x0fe5099c, 0xfbd20d7b, 0x5f068b91, 0xce733bb9, 0xcd877229, 0x50f6528b, 0x0bcd6059, 0x61a70704, 0x082bbc87, 0x97aaa856, 0x23f8a00f, 0x37b7197c, 0x7a9be099, 0xa30b71a3, 0x494d8a66, 0xb986da6c, 0xc68c1ad2, 0x1cafc5bb, 0x000002b4 };
const u32 bern_num_data391[137] = { 0xd1a5b5e1, 0x1d92ce5f, 0xc52e4602, 0x7e84726c, 0x4ec87532, 0xc1abbffb, 0x2ad0922d, 0x0ee792f7, 0x692056e7, 0xed280d81, 0x62bd5e9d, 0x0e9d2839, 0x6e16b0e7, 0x5a29eb0f, 0xd74199d7, 0xf6339c8f, 0x4cf25ab9, 0x8d805f7b, 0x2af7dbf3, 0xedf1d239, 0xb31f67f3, 0x3fdc5fe5, 0xcabcce86, 0x3e8f5ea9, 0x8a2121cd, 0xd2b7ca8c, 0xed3cfbbc, 0xf51ab777, 0xea378373, 0x44e5db8b, 0x88a91928, 0xc3682cef, 0xe65fd5a2, 0x8ff26b90, 0x6f612c22, 0xc1fb35a7, 0x3561547a, 0xef08ed65, 0xa4b9debb, 0x2e31d3b3, 0x7f6e562a, 0x166ce368, 0x5fd72802, 0x62185ba1, 0xc881910f, 0x13e21246, 0xcb869907, 0xcc4acfe8, 0x7a9e30cd, 0xeb1b8ef3, 0xecdcf244, 0xd042fd56, 0x09b40f92, 0x5ecb760f, 0x39411198, 0xd07f8dbe, 0x8bbee8b3, 0xf234d8eb, 0x21a15aad, 0x80167e4b, 0x810c84c1, 0xdeb17f24, 0x9b1b3f9f, 0xda4a0bb9, 0x1b9e3be2, 0x4537129d, 0x7352555c, 0x12f9cba4, 0x54d94501, 0x392336ed, 0x86a67935, 0x225ce093, 0x757543c1, 0xf9abd089, 0x19ef14fb, 0xe762db25, 0x5aa0d799, 0x4bda4c32, 0xd9dffb06, 0x508f0262, 0xaeb622af, 0xa69ea0dd, 0xc8ecfd15, 0xf290dba1, 0x6969aa11, 0xbf3949df, 0x78d704ae, 0x4bc2468f, 0x0eaab7f2, 0xe86f2b2e, 0x3f2a9364, 0xacf7af89, 0x530b084b, 0xfe0b7ea2, 0xb801770a, 0x9472c251, 0xa849e022, 0xfa9984bf, 0x51a97d98, 0x43aa515d, 0x8c498a7c, 0x830e421a, 0x49c52fff, 0x25a1aa06, 0x57c991a2, 0x7187e122, 0x15e100db, 0x2beeb9f2, 0xbade92c2, 0x33983642, 0x33e105e9, 0xb712e261, 0x8269ce0f, 0x24f717ff, 0xa4fb1563, 0xa868a77c, 0x505d70e3, 0xc790b272, 0x1262e45d, 0xbf73d471, 0x81dc86c0, 0x52eaa6c3, 0xbcc24160, 0x3412d3a2, 0x4ce9a9f0, 0xd8c61681, 0x4842f486, 0xdba11df9, 0xd4553ae8, 0xab39c8e1, 0xdd2d4364, 0x2891a7a0, 0x21f87e9b, 0xef80942a, 0x52f18ec2, 0x7d0654ca, 0x00000b6d };
const u32 bern_num_data392[137] = { 0xfc7c6d7d, 0x815a296a, 0x0f75a91d, 0xa22d6223, 0x011d4922, 0xc7502a33, 0x461dce80, 0x3f0bdb46, 0xd88e9c11, 0x4c5ac6dd, 0xde2852c4, 0x8ac916c0, 0x5ca91d47, 0xdbbca882, 0x4a909767, 0xdb43cd6f, 0x1d42ec87, 0x4aaf212c, 0xd94b7eae, 0x761bcdcb, 0xc146039f, 0xd6e2cb20, 0xa7c2a633, 0x984337e4, 0xf75737c1, 0xb26dd0dc, 0xc0fe6c18, 0xb30e4990, 0xe5d87232, 0x7410f58d, 0xcc64f61f, 0xd69015e5, 0x7aa88dd8, 0x07fdcb52, 0x8ef9160d, 0x293713f1, 0x8de38100, 0x2b9ba469, 0x0feec34f, 0x1f5802e7, 0xdb9375a0, 0xad4a34c5, 0xdb11cc3c, 0xb8ca65d3, 0xde3afcef, 0xd2b5f496, 0x781edeae, 0x45744e14, 0xe8161844, 0x83fb5cb9, 0x540a81b6, 0x7e497231, 0x90de17dd, 0x7cdaf14e, 0xbab43672, 0xc7f0ff89, 0xeba371b6, 0x0b77d665, 0x3c7fd3dd, 0x87fd5589, 0xf2185c80, 0x528193f8, 0x08e091e1, 0x48fc8e6c, 0xde01083e, 0xac99091a, 0xee6fdd94, 0x6d487396, 0x4b246e35, 0x64ac5fc5, 0x7a9d9ace, 0x3d31e682, 0x6f7baef2, 0x114f3e85, 0x148a5c6e, 0xacd07023, 0x0b59fc80, 0x93de224d, 0xd402d06d, 0x5cf0fdf4, 0x516246ef, 0xe4aa85d3, 0xc2dde54f, 0x1ea1c452, 0x7d6d636c, 0xe7d96a8c, 0x3fb44d6a, 0xa1064572, 0x86018a01, 0x98dc664e, 0x75f8ab7a, 0xd7291497, 0xe0b09701, 0x05c39d1e, 0x9cf4f1fc, 0xe653669a, 0x5d4780b0, 0xa408f8a2, 0xd96b8b1c, 0xb96a56c2, 0x53d0ddc6, 0x22e113ab, 0x9022e6d3, 0xdf0301b7, 0x28fd7727, 0xb556a682, 0x18f35a7c, 0x66bad89a, 0x38a1150c, 0x757b7732, 0x7ff792f1, 0x503b03e3, 0x86bafa48, 0x132f7a53, 0xe595c624, 0x015a2a6f, 0xb2d83823, 0x0b94f204, 0x628db878, 0xd43e69fb, 0x3c10879f, 0xcc71c987, 0x5b615f94, 0x4abf6266, 0x407f95be, 0x7a26094a, 0x964163bb, 0xa03e281b, 0x18f5670a, 0x261492a0, 0x67a615c0, 0x6151546f, 0x4ad34322, 0xf5f221d7, 0x0b9c54e9, 0x8c2dac68, 0x00126bd3 };
const u32 bern_num_data393[137] = { 0xea94f119, 0xf5283769, 0x57544359, 0x1dfbaedc, 0x168e60da, 0x644c460f, 0xce6aef01, 0x8bbed3b3, 0x46e18d8b, 0x6ea5c00b, 0x8fb444cc, 0xdef9307f, 0xeba4d6fc, 0xab1058e7, 0xc9896dd0, 0x2f5d0f9e, 0x76b38f1f, 0x9becaaa8, 0x35529cf6, 0xc5f941e8, 0x85cd3117, 0xb42fb40e, 0x9677ffb2, 0xee81e3cf, 0x982d36ec, 0x8b9c7b11, 0xde6b5d7d, 0x9e3399f9, 0xe360baaa, 0x8d70a606, 0xbac9ccfa, 0xf4e9f8dd, 0xb6d55c44, 0x7bf09c6e, 0xdd4cf4b1, 0xa6e26763, 0xe337973a, 0x7828e5a9, 0x35a1dd07, 0xf7c06734, 0xf413c9e9, 0xf9fb6325, 0x05a3d710, 0x871fd602, 0x4ef93369, 0x41675369, 0x8bf95046, 0x0982ebec, 0x4ceb9b00, 0x5f63514b, 0x5fbba352, 0x5a73b5e7, 0xe68c105e, 0xf46e7724, 0x1cea1411, 0xf89e4fa5, 0xa72ec481, 0x57277c58, 0xbf5a7b23, 0xb41d9206, 0x8875d5e9, 0x62d2fa02, 0xcb4918cb, 0xd8294e34, 0x96ec7170, 0xaaa15a19, 0x34c0bb7b, 0x6401357b, 0x2aeae40c, 0xafb23f88, 0x5487cce6, 0x81a5d9f1, 0xb3f77473, 0x6caec400, 0x9aa47cf4, 0xe342c185, 0xe0189fe4, 0xf366e8c9, 0xcc7e5ee1, 0x5bdb6e97, 0x9b6ffb19, 0x2103155c, 0x2ff31417, 0xf9a6cb52, 0x7fae0922, 0x95511fe5, 0x45040a72, 0xae1b65be, 0x1cd18cea, 0xa12c1bd7, 0xeb175c21, 0xa721c779, 0x416138bd, 0xe0b7db2e, 0x8cc52611, 0x88522e8f, 0xb306320f, 0x11557d5a, 0x2e4dbdb6, 0x245e6e5b, 0x2239003c, 0x0253b139, 0xd64ecb46, 0xe1af0ecc, 0x58ebd314, 0x9a115628, 0x8c42de1f, 0x6559afa8, 0xdcd52bc2, 0xa9cdf555, 0x7c8439f1, 0x94dc3c1d, 0x9f9e8116, 0x580de39e, 0xb385f484, 0x2d7ca3cc, 0x5674b396, 0x1fc4ab91, 0xd831e723, 0xbb4d50f2, 0x562563b8, 0xb2c32b6d, 0x243fe3be, 0x736e36e9, 0x07060490, 0x0165a5d7, 0x69ae8da3, 0xb89f45dd, 0x9d47cee6, 0x2f92c043, 0x61855444, 0x94e2a55f, 0x507fc923, 0x8c95e6d4, 0x3d98ff4e, 0x9a2180de, 0x0000ffa5 };
const u32 bern_num_data394[137] = { 0x0cdaa95d, 0x6af5ef7d, 0xdc4478cb, 0x27f175ae, 0xfa140cd9, 0x027261f1, 0x9ea93a41, 0x478b4f63, 0x95677a7c, 0xf154e55e, 0xf62a9def, 0x5dec9296, 0xf2754fbc, 0xb5695f1b, 0x06bf3f0e, 0x565bddce, 0xa46b5ce3, 0xb11c26a2, 0x357ae5b9, 0x4f70a2b1, 0xf5f542be, 0x219ea2c2, 0x97fa0531, 0xd792f6d1, 0x52db7b86, 0xcc382011, 0xa9db20fa, 0x8e9a8506, 0x7ffc7246, 0x15995b58, 0xf05b1300, 0x173dc79d, 0xf4fdb415, 0x3e17bd70, 0xc06cc561, 0x82748aa4, 0x6da742a7, 0x248b5776, 0xb7ba6c5c, 0xeb12085b, 0x7023f4bd, 0x13b392e6, 0xce3e73c5, 0x10b5516d, 0x0b4ff1f2, 0xca8626d2, 0x33ed120b, 0x97d5c5c1, 0xa5f0a56d, 0x40825e9c, 0xe63f5604, 0x66d68cbc, 0xff7ef761, 0x4499d517, 0x6de1464a, 0x93b22932, 0x735df047, 0xd73d62bd, 0xdbc531c1, 0x9b399082, 0xadb95a24, 0x900d95ab, 0xda2425b7, 0x4877bede, 0x0e0897c5, 0x10d06a1e, 0xc2ae2923, 0xe3ccb04a, 0x8ab0b630, 0x79998265, 0x0e4f8554, 0x36d3d7bf, 0x0fe0c2e4, 0x76698313, 0xe7b3f82f, 0xa78dd4ff, 0x47126796, 0x230f9d35, 0x292d513c, 0x64a36569, 0x0ed697c2, 0xebbab32c, 0xd60af595, 0x6f1fc2c8, 0xb075239f, 0xadb5cdae, 0xff6d4f28, 0x3845e9f2, 0xdf73628a, 0x7554b2fd, 0x3919b549, 0xe717d974, 0x60423797, 0x8d6bf879, 0x1c5a6c76, 0x1e6deb9f, 0xc2832d3b, 0x8e2f01d0, 0x66e86aa5, 0xa8c63695, 0xea00e309, 0x5b9854c6, 0x0d464006, 0x70e4f5af, 0x955b3d2d, 0x48cc93e6, 0x70d9d1f8, 0x015b00b8, 0xd9a953d7, 0x8b91d524, 0xfa83a5e2, 0x2fe64d3c, 0x519a9e10, 0xef95d255, 0xc4119761, 0x0f03d542, 0x4e27180b, 0x776eeb65, 0x950af272, 0x4f5f6424, 0x13fb03c9, 0x55ff68c5, 0xbaefef40, 0xa166cf82, 0xc418be0b, 0x1a06d11a, 0xbfc7a172, 0x19b098db, 0x9ef6b757, 0xa0a808d4, 0x69f3e440, 0x93ec2a97, 0x0e83d939, 0x18d5c5b4, 0xf61c7b80, 0xff02f426, 0x877f1112 };
const u32 bern_num_data395[140] = { 0x8003ae43, 0x2e1135e3, 0xf490ed81, 0xda8977fd, 0x887ed1fa, 0x5e3a2f62, 0x8baac185, 0x774b0350, 0x62ccb965, 0x0334e0bc, 0xd2e2f39d, 0xe547d593, 0x6ecc9291, 0x977e9deb, 0xadcac476, 0x803f2402, 0x7c850095, 0x577dd9b0, 0x44d32dda, 0xe30a1a82, 0xb99ed7cf, 0xfad4409f, 0x744989a1, 0xa1ae97ca, 0x05c56568, 0xbec55b8d, 0x9ab4b8d8, 0xe26da893, 0xc9169eeb, 0xb3cf1e87, 0xa72b544a, 0xc20fd92e, 0x449d03ba, 0x37388d40, 0x4e2c3445, 0xa9b7c972, 0x2b4691fb, 0x836f8963, 0x1ddbcc19, 0x3a172f58, 0xd8458d9d, 0xf6664b10, 0x74c00a3c, 0xb32e3ffc, 0x26c43ed6, 0xb9052c75, 0xe2733fb3, 0xca692620, 0x56678886, 0xea19fbd5, 0xb2df9c6b, 0xa4ea2031, 0xc17a96f1, 0x24460d25, 0xe078a1e2, 0x9cd89036, 0xf764c7c2, 0x399fe74a, 0x062963cd, 0xf725d6de, 0xe40123f5, 0xd620a0d6, 0x9af3a5c1, 0xa604098f, 0x64693b57, 0x7cbd5e23, 0x2bba5db2, 0xa96f3ce5, 0xe3204ebe, 0x06f49967, 0xc7f2006f, 0xbb6985dd, 0xbbf0227f, 0x07018bfb, 0xf771db7f, 0xc88b0c52, 0x358e77c7, 0xa9cd646d, 0x351f8672, 0x3f99dd76, 0x417b7306, 0x2ccac4b2, 0xb2773615, 0x798d7e99, 0xa92d6aa9, 0x091ad9f0, 0x78ec36c8, 0xfe58c212, 0x4629652f, 0xe7d96802, 0x8a78805c, 0xd7b70aa7, 0x72c240f2, 0xb03a57b2, 0xaa838dd6, 0x9057bc10, 0x9c3a47ac, 0xec6f4468, 0xbc04a3d3, 0x4a75c2ef, 0xcbbd8b79, 0x8cf78c78, 0x07093893, 0x43f1178f, 0xbdb576e9, 0x8510a2e1, 0xb91d53dc, 0xc24a7b78, 0x466a8f74, 0x47c6b5b4, 0xdc598898, 0x3c994de8, 0xae4dc8d0, 0xb663dc96, 0x075ca4d0, 0xcd287c55, 0x51d9904c, 0x03eceadc, 0x6ac310af, 0x1dca1c18, 0x338143df, 0xa7b7de97, 0x5381d279, 0xbec745be, 0xe0f11107, 0xa12d7b49, 0x0c829daf, 0x72469810, 0x6752123a, 0xf8768b84, 0x02b55058, 0x180bb5a3, 0xfe75ecfc, 0x5d3ef150, 0xa8fee51b, 0x0839cb91, 0x3191a1a2, 0xd09dc99a, 0x78ea138f, 0x0000000a };
const u32 bern_num_data396[138] = { 0x15fb748f, 0xfbb023de, 0x1f08fa66, 0xf28caafe, 0x7cac44cf, 0x2e16468b, 0x19fbf000, 0x6d7f95bd, 0x4a678d26, 0x5a8ffb70, 0xfeb6093f, 0xb4454ae4, 0xdab02fbb, 0xbfa18b53, 0x7f3b33cb, 0x1b5e0fe0, 0x1ad7e64b, 0x595ee3da, 0xefb0d183, 0x6a889cee, 0x06d763b5, 0xe8c95fb0, 0xbef5e37b, 0x65d654bb, 0xc7aef30b, 0x481913af, 0xa1698f19, 0x022f39a1, 0x27575402, 0x8eb9150d, 0xa3cbd7c2, 0x8b60ab76, 0xd00e1aee, 0x71f0186a, 0x43efa97a, 0xb08227c0, 0x81f7d053, 0xeaafe082, 0xb0ce59de, 0xfda291cd, 0xcfcce8b4, 0x834ad0fa, 0xaa851541, 0xc4d9b62b, 0x4fc7975b, 0x826d221b, 0x81089127, 0x4fa826fa, 0x687a8b4d, 0x48eabc57, 0xa649d6ef, 0x6f5b06f7, 0x6f62ae38, 0xb99d1b34, 0xf8940cb1, 0xfa6ab8ca, 0xe5ea86f0, 0x98d0b1f8, 0x3f832c16, 0x92e65561, 0x2bdb1df2, 0x44bca1c5, 0xf9e37bef, 0x747d04a5, 0xabe386d6, 0x676f2457, 0x2a92b8cb, 0x48692184, 0x241aa3bb, 0x6a9b180f, 0xdada0f75, 0x2121007d, 0xb21890e0, 0x07ecee9a, 0xec092186, 0x4f0b94e0, 0x00463afd, 0x6a78ae3e, 0x75a915e6, 0x2c3460ab, 0xeae1d09f, 0x73b8d1f9, 0x10b7e7ad, 0x001b1f79, 0xd1096f5f, 0x93d2907f, 0x1a5c136d, 0x7869564f, 0xab97627f, 0xb2a12280, 0x01809edb, 0x4085c8ae, 0x4d89bdb5, 0x7a23496d, 0x32b9c2f0, 0x800bee75, 0xf9afa70c, 0x1f2e8595, 0x0cc938f9, 0xa2a51305, 0xea6ea6ab, 0x22591246, 0xe62badb7, 0xc77b2028, 0x1a2873d1, 0xa32609c6, 0x89e70131, 0x40807deb, 0x2b458233, 0xb4f1e3fe, 0x2d2c5269, 0xc93eb7bc, 0x35f9b776, 0xf909168d, 0x98a673e4, 0xec40b406, 0xe184e608, 0xc9b830e6, 0x639e155f, 0xc60f5717, 0xb3405b6b, 0xba7ecf32, 0xe03b0eee, 0xa9bbc99c, 0x53625371, 0xcb5f9a43, 0xa2944106, 0x76144283, 0xbea2af04, 0xfca9f9cc, 0x78870bff, 0xe212eb4e, 0xbe9c4b7e, 0xc908ce85, 0x47f8003b, 0x7e9d67fe, 0x2fe06988, 0x00b9d1c0 };
const u32 bern_num_data397[139] = { 0xea4afd25, 0x993ba105, 0x63168427, 0x97d3db6e, 0x10e6a8a9, 0x8880fbd9, 0xfe90275f, 0x1ef226a9, 0xf8ea9f56, 0x65cf5b5b, 0x9e049e80, 0xb6574022, 0x778c1df5, 0x4cf2fd73, 0x1247fe57, 0xe5c1bbdb, 0x59259249, 0x2454dca5, 0x7caae5bf, 0x1bbef854, 0x05e65991, 0x5d381700, 0x1f279e26, 0xb3eea28a, 0xcb4e742b, 0x3a542477, 0xf533b06f, 0xbaf2c49a, 0xd8661d54, 0xf31bdfa2, 0xd40aa8aa, 0xa418ac42, 0xc3966ac2, 0xacc42d44, 0xd84670ef, 0xc1a3fc84, 0x99cb6780, 0xcb01194a, 0x07dae7d8, 0xb1f782da, 0x8d2f6444, 0x596f1f2c, 0xeb77b7ab, 0xc1ebf444, 0xde170e6d, 0x6683d5c3, 0xb47791a4, 0xd4efb4b1, 0x536c9d0f, 0xd0c8b70e, 0x6ae24d40, 0x1ff565bf, 0x189924a8, 0xd60fc70e, 0xea619366, 0x579f6d98, 0xa62dbf7b, 0x92d5abd6, 0xa086578a, 0x76aea5c2, 0xe8e4f262, 0x187b0ab2, 0xd0cad8fa, 0xac5e450b, 0x184dca81, 0xc0b8a897, 0x70dc81e5, 0xf7e3d845, 0xf8ebd6d4, 0x26a3b961, 0x77c369de, 0x428557b8, 0x4428798c, 0x947067f0, 0x65d95671, 0x79420c20, 0xf5d9e0d4, 0x69e1930a, 0xad500817, 0x6c3f1295, 0x3cb17885, 0xc8508ffa, 0xa7e96478, 0xe8a1a91f, 0xe4abc647, 0x2ae9c330, 0x96c3416e, 0xe52ab906, 0xb327b538, 0x8f04a926, 0xf253acd5, 0x76d12c34, 0x4fde2606, 0xc723d8b4, 0xbabc9541, 0x941803ff, 0x1087018e, 0x959f32eb, 0x7cf4a42b, 0xbf782de2, 0x8c22cc96, 0xa2e2f177, 0xefb7edd7, 0x844580c6, 0x2446a11b, 0x99369553, 0x09b641bf, 0x34622982, 0x76a3ecb1, 0x7edaba4f, 0x1cedc9b8, 0x050dc582, 0xeda8c1f0, 0x1af40d94, 0x9e30c34d, 0xa7f90bc6, 0x59440b86, 0x7c73fede, 0xef3e6dff, 0x40c6ab50, 0x2de2bba4, 0x25798e69, 0x063aafaa, 0x9286d603, 0x3d78d471, 0x07a01100, 0xaa69b093, 0xa9c8c88f, 0xbf2d8b79, 0x3ee818a5, 0x91c216d8, 0x8e155524, 0xccac1fd8, 0x8cfbd395, 0x5161c9b1, 0x54798d79, 0xa3119490, 0x3aa20464, 0x0002c37d };
const u32 bern_num_data398[139] = { 0x67ff831b, 0xf2312f3a, 0x22f1e30e, 0xcdcbb3c3, 0x65950c3a, 0xe259e02c, 0x79465101, 0xad4aae5a, 0x51e429f8, 0x120769d8, 0x135d76f8, 0xf87265fe, 0xc3623b42, 0x146ab1bf, 0xc4d7926a, 0x664c538b, 0x307b8688, 0x469dbd35, 0xfb06ce16, 0x566c4e9c, 0x03ff4e16, 0xe3418c60, 0x8d7ab49c, 0xf1ce9c63, 0xc72d65ba, 0x2c2fc36a, 0x0d0e99b7, 0x844c35cb, 0x0b901cd2, 0x7efa04c4, 0x6ba87b9c, 0xc1350a0b, 0x1e4093de, 0x3f2af568, 0x6d79a44d, 0xd4185b67, 0x5ff57840, 0x05f3bde3, 0x2dde5a70, 0x2df39e1f, 0x91679c0f, 0x58f9b31b, 0x680e5e32, 0xacb054c3, 0x6b97bd18, 0xf4d1ec13, 0x95e28f11, 0x8b7daf09, 0xa7dba8a2, 0xa0be1830, 0xef4ddd7a, 0xf8341727, 0xf79d3ca0, 0xe7afd675, 0x3e56d131, 0xbfffe42c, 0x723c3d46, 0x07badd7a, 0xed3657f2, 0x4671cb7c, 0xe0167433, 0x561625d2, 0xf0b09e34, 0x0f2ad2c6, 0x891d4b26, 0x656a1488, 0x6173d3ef, 0xa85ada98, 0xbff4d6c5, 0x58fa8a5e, 0x1daab331, 0x679819fa, 0x784e1466, 0x87b5c647, 0x6cdd65d9, 0x8c9e6237, 0x3e9b3910, 0x807a5b41, 0x90fa6a82, 0xc8edee62, 0xabe177cd, 0xca118812, 0xa2d9c715, 0x317fc55a, 0x7a26325c, 0x526b9072, 0x56d1af9f, 0xbb612620, 0x9d777b6c, 0xa14f14a7, 0x5ec1c555, 0x47f7db16, 0x6873e475, 0x3749e75a, 0x1cde69dd, 0x92d482d2, 0x4d7e6028, 0x5992c1f8, 0x00436866, 0xfcf37528, 0x9512c1e1, 0x35278508, 0xc64e4e51, 0xbd3e8a65, 0x35d977f0, 0x109f8e2c, 0x9fcbf86d, 0xdc788789, 0x36ed02e4, 0xe0b1d547, 0xfda93fd3, 0x8cf6bad8, 0x9a20d547, 0x4c347651, 0x2f29069e, 0xde184cd2, 0x3f124bbf, 0x8c6e989a, 0x41bc8b0d, 0x6f2a03cf, 0x1f22035a, 0x7a05a3d5, 0x7de9b3c0, 0xbce3b70a, 0xb4481dab, 0x90ef419c, 0x89adf454, 0xe8191880, 0x13c3baee, 0xcba3c8eb, 0x71691111, 0xba353f8d, 0xb0e62d71, 0xeddd3f34, 0x6177a9ad, 0xf063464f, 0x08a4fac6, 0x4e08333d, 0x0d22f15b };
const u32 bern_num_data399[140] = { 0x1711841f, 0x4f756f10, 0x5c4caadc, 0x0fb18a2b, 0xe933cfeb, 0xac773961, 0x687c957a, 0x6b3f201a, 0x12dce63c, 0x456e860b, 0xe6c004e9, 0xe703fffd, 0xbeec9867, 0x111777f9, 0x001bcaaf, 0xbc5e9a8c, 0xf6c6da94, 0xdb6461e7, 0x1e115045, 0x0de9b91d, 0xac07ebdc, 0x7c8c8b54, 0xe1485000, 0xaffd8a5b, 0x5dcdef5f, 0x9dbb24f7, 0x0f8bbf26, 0x78557b61, 0x035ddfc6, 0x647dd5ad, 0x99ff6080, 0x340f0c4e, 0x912ac6a4, 0x0b6f8898, 0xfbdf7747, 0x33fba9e1, 0xe683c080, 0x55890bf3, 0x1eb92559, 0x86a51708, 0x9b5a2178, 0x96cf5730, 0x534eb7a3, 0x4204094d, 0x38175356, 0xd85a2d21, 0x36ab4d92, 0xe1e9e91b, 0x81d8f365, 0x7e431c2b, 0x5c3dc957, 0x84db0ad7, 0x8f459bc2, 0xb5227e23, 0x488f2deb, 0x580e4dca, 0xb37a6189, 0xf01c7aae, 0x15718a19, 0x502787b3, 0x95ad0df6, 0x81b774d8, 0x4f3db07b, 0x5e887863, 0xae07d9f8, 0xb22affbf, 0x260824ee, 0x430eafd7, 0x2ff7ec27, 0xb770dc89, 0x037f4d7d, 0x6629e597, 0xf1e758f9, 0x5fa97d57, 0xfaa6f4b3, 0x5abbd7fb, 0x503fa286, 0x45ba8c65, 0x53bdf372, 0x9b8954f0, 0x4e4ba66a, 0xd91f3f2d, 0xcdfaa5ec, 0x8422ffc0, 0xae9e721a, 0x14f184ed, 0x0bb3855f, 0x4935d3fc, 0x510e6ac1, 0xe6e74492, 0xc4a08bd7, 0x1c1262b7, 0x4d01bb5b, 0x74dd7599, 0xf35f86cc, 0x0759d361, 0x003bf9fc, 0x3a2bf26c, 0xbd019c79, 0xe6f26c98, 0x28c0ed7a, 0x54a5ac16, 0xf048837d, 0x09f68e0b, 0xe6caccc4, 0x50a0b8ab, 0x30a2c0e2, 0x58a7207b, 0xb7504f81, 0x0ddf3156, 0x1b63474c, 0xe80bbf27, 0xb5a9f19a, 0x6ee2130d, 0x7560152b, 0xe4d1e3e5, 0xe2c39695, 0x30f78459, 0xe9433bc3, 0x511fc19f, 0xb70b6b5e, 0x8f14382e, 0x8a4fa59d, 0x1885edc0, 0x455e3ccd, 0x2d866fa8, 0x797b98a8, 0xd9450ac7, 0x29bf952f, 0xf5f1d987, 0x79763e91, 0xba747e38, 0x22118134, 0x82271d97, 0xb73e3918, 0x51d51799, 0x41d0dcbe, 0xb15aa723, 0xa19a336b, 0xff710410 };
const u32 bern_num_data400[140] = { 0x9c29febf, 0x477d8a0a, 0x896aac47, 0x07f02e48, 0xe5d285b8, 0xed0c7e51, 0x5226314c, 0x2f3c680a, 0x064866c0, 0x17059979, 0xec6bc019, 0x4342ec90, 0x222717b1, 0x40f9ef52, 0xd37c52fd, 0x47cf726b, 0x549091ab, 0x11dd73e3, 0xe70cc369, 0x16e22410, 0x91c43a06, 0xf79e5321, 0xb076030a, 0x3e861240, 0x7bca8112, 0xbc006fdc, 0x1aecc567, 0xfaf7b9a9, 0x20c8bff4, 0xeba98764, 0x8549f3ab, 0x005f4a4b, 0xb874fd6f, 0xa4d00eb2, 0x2cf9df75, 0x11f68d9d, 0x9ac41903, 0xf5e91561, 0xf52e2ce2, 0xd4735ffb, 0x2c1813a0, 0x36605544, 0x27a549e2, 0x74973120, 0x1dedd938, 0x850d2ddd, 0x47a58ead, 0x24b4795a, 0xdf48abfe, 0xc2eb1bba, 0x3cb623a1, 0xa185e9f2, 0xab88b6ee, 0xdd44bb95, 0xcaf1cd31, 0x5b253e67, 0xa5a838a1, 0x55c668fa, 0x244b9e28, 0x564f47f7, 0x81c474e2, 0x505ca9d5, 0x117dfb4e, 0x4aa6cf54, 0xc3ae1176, 0x49e7a4e0, 0x1b0a41ed, 0xc9eede2c, 0xd46e3ce4, 0x075136a7, 0xab6a8435, 0x8bc6b671, 0x4fb43b66, 0x9fedb8f7, 0x997bea04, 0x9238adee, 0x9ec66018, 0x77f6de94, 0x46e3e6de, 0x05e00e0f, 0x52f2cc71, 0x54ff2dd3, 0x3075d55b, 0x88acd06a, 0x9d047908, 0xa643c4de, 0x3be7ea10, 0xe7e9ff48, 0x3c07a498, 0xcf0a6de0, 0x9f3c5e51, 0xccd52dfa, 0xdc5a9104, 0x5058de4e, 0xa7f2d82d, 0x19fd9854, 0x475d3f7d, 0x450393ae, 0x2d5f0e45, 0xeceaf9b0, 0x30b99e3b, 0x3f5aaf28, 0xe26f6ca0, 0x8c0eb6f4, 0x520c9e81, 0xf8705f8e, 0x1419c671, 0xe292c342, 0x6fa19fe6, 0x2cf1e554, 0xd101c712, 0x2fa08514, 0x58d2cbdb, 0xb2de2476, 0x38ed2e8b, 0x10539bca, 0xb493dcd2, 0xde940cda, 0xc6482c45, 0xe817addf, 0x6c91b4b4, 0x723106ca, 0x174fb707, 0x566e5ca7, 0xa1127560, 0x7782c777, 0x8ec3bdd9, 0x37e3eb96, 0xfc998ae8, 0xd6819590, 0x9380e905, 0xcbe549bf, 0xbdb79727, 0x3c52903a, 0xba80e82a, 0x4ca008e8, 0xeb022b1a, 0x17155874, 0x9a494f6a, 0x0000af73 };
const u32 bern_num_data401[141] = { 0x5855c667, 0xcb46cabe, 0x9c3cc5fa, 0xf554a881, 0x7be46a16, 0x0523f51a, 0xc3d999d4, 0x21ecfd30, 0x3d2e0355, 0x4d763992, 0x03915ebb, 0x5e0d2ede, 0xf7cff645, 0x283776cc, 0xeaf9846e, 0xd44f507e, 0x72ca46be, 0x1851d8f9, 0x170c5a95, 0xd2867456, 0x3fe421be, 0x8fc932c5, 0xa4d85d55, 0x3c3d6901, 0x6086192a, 0x98b277c1, 0xcc004e54, 0x7505f436, 0x148dde0e, 0x9b43813c, 0xf8d7026d, 0xd3c1c436, 0xb2907776, 0xc3ddf2f9, 0x3f0fd30e, 0xe6469e6c, 0xe85f69cf, 0xb3954e68, 0x42e45bf1, 0x6e6edf0a, 0x20ec0a2e, 0x81925092, 0x71d9f3eb, 0x18c3e324, 0xc1887b2e, 0x914dbc7d, 0xeb2714e5, 0x22e4f0dd, 0xf3330b0e, 0xb84e79cf, 0x1f3ace58, 0x841cd1c7, 0x79f1a301, 0xc8be3d7f, 0x1ced9dad, 0x6e019212, 0xbbb24b5b, 0xaa64d9b5, 0xad72478a, 0x95fd15cc, 0x1d6d6e2a, 0x8ed1453c, 0x33f9096b, 0x8c9901ae, 0xaa849ba6, 0x8270fed4, 0x6dc02f82, 0xc8e66712, 0xee43eb57, 0x7315b551, 0x4280ff0f, 0xb909cbac, 0xb49cf435, 0xaae663a2, 0x2b93f439, 0x155ea835, 0x4c850c9c, 0xf02348c6, 0xd8491b21, 0xfcf6e834, 0x0dfb2a4e, 0xf443654f, 0x99e6be1a, 0x2d71dc6a, 0x5a9ec034, 0x49716635, 0x3a367d06, 0xecc7ac42, 0x54726799, 0xcc989948, 0xe2649f33, 0x19a94a52, 0x445c7fd4, 0xa44e51bb, 0x4a2c4743, 0xb13395a2, 0x87a75f69, 0xe53535fa, 0x3a01ccec, 0x9a854e57, 0x8b7297a1, 0xe83e4fc9, 0x59e0830c, 0x92ea2945, 0x430b65cd, 0x6f6e876d, 0xa9999c4d, 0x85d77d71, 0x38f61231, 0xd69dc73b, 0x4fe4ffea, 0xe82cc0ab, 0x48cb2fb8, 0x53ddfb78, 0x3d60853d, 0x5df2ed92, 0x990aa14e, 0x0d73ea36, 0x0a74fcf3, 0x9591e92f, 0xacfc1714, 0x71a90439, 0x3b9992f2, 0xc8ec26cc, 0x380f7e7f, 0x915a9b60, 0x1609f61a, 0xb0ba025a, 0x89c69f6b, 0x310eb1c9, 0xf7a45bde, 0xe271f4c3, 0xa8dc46d4, 0x117ea239, 0x1b00d970, 0x2b4e38cc, 0x4044eb92, 0x9d4d229f, 0xddb041e5, 0x1adffaac, 0x000051c4 };
const u32 bern_num_data402[141] = { 0x9aed4997, 0x3c57797d, 0x1f2fa281, 0x6147ed6c, 0xe22b4b96, 0x5922a18d, 0x01fd33b3, 0xb62852b5, 0x9f2cd527, 0x995ac8a8, 0x36d847c2, 0x63b0573d, 0x314d96d0, 0xca10e55b, 0x4e670fd2, 0x8cae5d76, 0xc1c47ed0, 0x2abd9fe9, 0x870f9573, 0xe4cad7e0, 0x13e9a02e, 0xbe00a776, 0xe29ca665, 0x73ee8c71, 0x2dad3c3a, 0x80a3c0ce, 0xe577fa51, 0xd41fb4f9, 0x040f7028, 0x6bbc4a85, 0xdd4a0792, 0xacf67940, 0x6ed0c9d1, 0xd91a2777, 0xcd951a76, 0x0db74afa, 0x26c5f663, 0x6e1a2e40, 0x58e0a92f, 0xf1e186cf, 0xfaaf66e9, 0xe48bc691, 0x0c95ca1a, 0xe264546f, 0xbd7f17ea, 0x96fdf8e4, 0x3b7f1b55, 0xd620fffd, 0x51edbe70, 0xc0535b78, 0x66b89b3c, 0x93f23649, 0x6707bf4d, 0xc7076e88, 0xeac1b7d7, 0x48f18794, 0x971bc3f5, 0x044513f9, 0xe095ccb5, 0xf58f6fef, 0xb679d9ee, 0xa1c08606, 0x857212b1, 0x8039dfa4, 0xea1262cb, 0x6ad93d65, 0x4a11d1ca, 0x59c64de0, 0x328c05d4, 0x8b3e2112, 0x117e6f52, 0xc46f032d, 0xdb1ba508, 0x55abc15f, 0xe3e1064c, 0x603b2585, 0x06143e4e, 0xcb3032ad, 0xfa2b9a52, 0x543c3a17, 0x67cabedf, 0x5f7788bb, 0x5432e417, 0x2bfba27e, 0x6abceae0, 0xdac73f4c, 0x54411de7, 0x7e54fc95, 0xa4ffd1ca, 0xf7d87244, 0x0f5469b3, 0xaa671e6c, 0xe53fabd7, 0x57f01932, 0xbf4d4abd, 0xaad89915, 0x2a9d5d6c, 0x15667b55, 0x057a2d89, 0x2072972e, 0xf8be0386, 0x4c2125c2, 0xc9472a2c, 0x99c2edc3, 0xbd6cce8b, 0xc66c9b3d, 0x52c1acb3, 0x7ad371f9, 0xc85374de, 0x15033a91, 0x15944bd0, 0x401d9987, 0x3e6d971b, 0xed1398b8, 0x4f1e25b5, 0xc69617c0, 0x54ca2bf3, 0x5168dacb, 0xa70ad690, 0x253a4bb7, 0x27c80b76, 0x3b0ebeaa, 0xd501e9b5, 0x16f4dc36, 0xfe530a72, 0xd4a42ff9, 0x6107c36b, 0x2f150db5, 0xfca7c206, 0x97f84a1d, 0x4db59871, 0xf7fe86c1, 0x02568f19, 0x74951631, 0x5e228a57, 0x81050e12, 0x99d9e621, 0xe6e79ce5, 0x11936259, 0xbd01d60b, 0x00000afa };
const u32 bern_num_data403[142] = { 0x0f9118e9, 0x07e961b8, 0x880c88c5, 0xf1c1538e, 0x5381fae7, 0x5788a908, 0x79ddcde8, 0x2daeb63e, 0xb56e5ed1, 0x2e6ff90f, 0x6c13e79f, 0xb0a0d9bd, 0xb2f45508, 0x94917ed0, 0xda5a8297, 0x6b5b51cd, 0x8e56caaf, 0x818a490e, 0xb5d85910, 0xf1379b01, 0x22d5c6e9, 0x65b7810f, 0x14e2c20a, 0x159085f7, 0x582121b1, 0x85cbabab, 0xd0f949d3, 0x581e59e8, 0x005ea5cd, 0x528036b2, 0x34152582, 0xab9b76f3, 0x2959263f, 0xfe882a19, 0xe68c5fa2, 0x9b7d982c, 0x9cd8d7ec, 0xf62f7c88, 0x03b023e7, 0x12334aa7, 0xcb0c8f75, 0x4addf258, 0x1e923c10, 0xb8942833, 0x6d8b83c3, 0x4b3b0a08, 0x250aea1a, 0x72e82b60, 0xe550eeb2, 0xde78e658, 0x247f2695, 0x02487237, 0x6bd5a93a, 0x826eebe4, 0xdc1eee9f, 0x7d5e426c, 0x69d3259b, 0x1eb3e291, 0xea9ad5d4, 0x026e4a8f, 0xa9bcfac6, 0xd71771a3, 0xf26f85c0, 0x8b5d2ad4, 0x7dadb0e9, 0x667f76d1, 0x54d57e7a, 0x43bd2618, 0x1858ed78, 0x38411035, 0x5f3f6aab, 0x269b7d0f, 0xb1d22900, 0x9063b190, 0x543ec6a1, 0xbf90b31a, 0xc3efd9ee, 0x4e6ef44b, 0x08296a06, 0x57b8e6d5, 0x80faa1f5, 0x3414aaa0, 0xeb4a7f95, 0xda238fc1, 0x368ba89d, 0xf79b86ca, 0x37eac6be, 0x69a5a525, 0x65f5f9ee, 0x4f88f0e9, 0x9aa69f1a, 0xbb969f5b, 0x29cb383d, 0x17e4987b, 0xf8037085, 0x4164d370, 0x7001c118, 0x66529dbb, 0x49b40d80, 0x1ffacf58, 0x29e9c368, 0x9f3aaaa9, 0xc981958e, 0x2589c3c5, 0xfa6430ad, 0xf03f1aab, 0x531565aa, 0x92067012, 0xf31a995d, 0xabe68c17, 0x22fff736, 0x9275ea84, 0x5bd17401, 0xf3679807, 0x72c0da49, 0xfa8a5c96, 0x5bfdf7c7, 0x41bbb5c5, 0xf4a91717, 0xd64a41f0, 0xae130ee7, 0x2d9612ce, 0x0e2fc8b5, 0xf946d406, 0x27c54986, 0xdfecac5b, 0x7f8cf14f, 0x836a95fd, 0xfb46ddbd, 0xe664ff08, 0x05138b40, 0x233d8a0b, 0x687e9539, 0x896ecb3a, 0xee4d516e, 0x9fb58569, 0x8161dbb2, 0x5e7e625f, 0x7146d5d2, 0x131b08dc, 0xb8f0cfd5, 0x0000002b };
const u32 bern_num_data404[143] = { 0xef863789, 0x1e3d33fb, 0x14d7ed32, 0x63f66019, 0x80d1442c, 0x54def90e, 0xb7a28d38, 0x289744dd, 0x20af214f, 0x4413933a, 0xb8b61965, 0x2d23dd6e, 0x9d63516a, 0x5fe77650, 0x1f813a75, 0xd44c7eb8, 0x1c0c2098, 0x9bbf041f, 0x17b833ce, 0x0663ac24, 0x9be90c1a, 0xc32a5537, 0x700348c7, 0x4f237cd1, 0x7249efe2, 0x521bcc29, 0x2e562d68, 0x0e586a1e, 0x9e1ef254, 0x3e104d99, 0x24bbf01c, 0x0b9bda93, 0x6cb479e3, 0x81afc570, 0x1e161c3b, 0x9b119620, 0x93a1dc8b, 0xb7eba134, 0xff71b7c1, 0xe790ee7e, 0x50abacda, 0x4859ec36, 0xb6debc0c, 0x211c0aa9, 0x3cf5ea20, 0xdf7eb522, 0xca287354, 0x124e3757, 0xe13fbe37, 0x4ffdbf99, 0x87a397c2, 0x4a74eba1, 0x4a913c40, 0x66529862, 0xf964bbe2, 0x940cca6b, 0xba03fce8, 0xc607c46d, 0xc218e554, 0xceeb01e9, 0x0fbac7e5, 0x25efaa4a, 0x0a72e871, 0x92612588, 0x4b85cd2e, 0x19da08d7, 0x80357212, 0x301a1794, 0x801228a3, 0xddd3864a, 0x4348fe11, 0x8b1d6eae, 0xd99a50f8, 0xd5b81941, 0x7802385e, 0x93914692, 0x94a15b4f, 0x95e25cff, 0x7e953a40, 0x7bddbcd4, 0x771cbde1, 0x4e16b796, 0x2ad29858, 0x751aefa3, 0xdc27e322, 0x7deb344c, 0x62f78034, 0xaffa15a8, 0x1a0d5df0, 0x94cee735, 0x54c9b5b4, 0xd838063d, 0xf82bae38, 0x7af65c6b, 0xcdcd54ab, 0xc47f6ac1, 0x4f0a6a21, 0xf3a5b276, 0x0dbdb751, 0xae5b413d, 0x4598e5f0, 0x2c1ed7c3, 0xc89355db, 0xbb74ec62, 0x2e0a0fc9, 0x1da43c81, 0x93e5271e, 0x67badc6c, 0x0a11d109, 0x1bb78780, 0x004e4117, 0xdd7ce84f, 0x5f6cc58e, 0xcc9e2aba, 0x610d54b6, 0x894b9579, 0xf1c2b8bd, 0xe8986f60, 0xd038ac64, 0x9bea68ad, 0x33a7058f, 0xd77892f8, 0x041a7ce5, 0xe52d56c3, 0x3fe4602e, 0x2ffa8895, 0x12608dfa, 0xd55a2cf0, 0xcbaf14a6, 0x54373ef3, 0x45cb3d84, 0xa8d6122a, 0x74a65820, 0x94103faf, 0x80a748f6, 0xc0a2d8f6, 0x4d936d99, 0x661f639a, 0xc50629ca, 0x19c13173, 0x082e1311, 0xdef88a16, 0x0001091e };
const u32 bern_num_data405[143] = { 0xbf481567, 0xf01df250, 0xc2caf421, 0x8d20d070, 0xc801d828, 0xe387871f, 0x810ae8fd, 0x48991fd2, 0x162cbe9c, 0xe2ce4b64, 0xe8535259, 0xf0bb545e, 0xf73521ed, 0xd20bb13a, 0x682b65b1, 0x4f6ad0c2, 0xdad52f8c, 0xa89bb44a, 0xaeadc007, 0xdbe05e3b, 0x5ecf74e3, 0x68cca1ec, 0xcb8c09db, 0x8d248783, 0xa5a80e4e, 0xf2db36d3, 0x9bb408be, 0xc3e4ae2d, 0xa555460c, 0x709ef052, 0x2f966a9a, 0xba07a59d, 0x9accd1e8, 0xb1169c7b, 0x655cceb5, 0xffd34045, 0xe85c359f, 0xda037374, 0xfca27e5e, 0xe03256a8, 0x23f48564, 0xc443cf9a, 0x1a8fa79e, 0x5f250ab4, 0xc4d50a4d, 0x7a1f01eb, 0x12d9efff, 0xc072d809, 0x6721bb4d, 0xe168780f, 0xa5afbb5c, 0x4bf32399, 0xbac909c1, 0x13c0b167, 0xa2f87c36, 0xf6dfa5a9, 0xfe423a10, 0xc0e2affa, 0xad81bf5b, 0xeb053333, 0x732b6191, 0x1e851bbf, 0x721eca78, 0x54631cc2, 0x16a60364, 0x6ce8d611, 0xd6e00f60, 0xb0eb871d, 0x02aba31f, 0xa80a08c7, 0x21c6e99d, 0x3ff6af93, 0x4f167c51, 0x9e190a2b, 0xc4df5e27, 0xc19b5948, 0xaa77e0ea, 0x69e8551b, 0x3adfd715, 0x8acb9e75, 0xf5e01a06, 0x88b28cf3, 0x3f7e17dc, 0x2774eb1b, 0x048d6a4e, 0x1a463579, 0xbbc2c730, 0x29b918a8, 0x02113f5c, 0xa3d58394, 0x211572db, 0x6e3688f2, 0xb9f960d3, 0x57af5ced, 0x9040fbea, 0x2935c0f4, 0xc9da2592, 0x47b562bf, 0x5ea2c9a0, 0x14fbd4de, 0x243107d1, 0x81c013b6, 0xa6a1ee47, 0x40ca5dea, 0xeeb9835e, 0x8263e6d3, 0x725551a1, 0x453ab986, 0x54945c1a, 0x38795f5c, 0xb7b787cc, 0x9f93da52, 0xa6ad3490, 0x01eb8e97, 0xc81a3b22, 0x8a003881, 0x7dd46b10, 0xb5ec3e87, 0x3a7bb836, 0x5f1e8557, 0x1ac11e09, 0xccfae499, 0xc3ef4cda, 0xcb06f348, 0x52bc3817, 0x2c4882ca, 0xbdd6b751, 0xabc3d8f0, 0x16df582b, 0xbf873e2b, 0x39dbc6cd, 0x03e9607a, 0xf83dfbb3, 0xbffb5e6f, 0x6d1a226c, 0xe43e2849, 0xbab9f6d9, 0xc6b7d590, 0x5a51551d, 0x269c1428, 0x7982f2ae, 0xf61402b7, 0x00000005 };
const u32 bern_num_data406[143] = { 0x0bfc27e1, 0x5a2ff702, 0x102411b2, 0x22ada224, 0xa23caf68, 0x1a5af5fc, 0x8cf54ec9, 0xf0b6c7b9, 0xde52cf89, 0x75cb7b1e, 0x34a4c712, 0x7d8292a0, 0x1ac1e60e, 0xc6c5843f, 0xe610cb05, 0x6b1aaca9, 0xcad04cf6, 0xf02d2487, 0x7c6289db, 0x771deb32, 0x43d1f869, 0xf377c711, 0xe20932cb, 0x63da9263, 0x61d29266, 0x16e27268, 0x33e6ea04, 0x24c55131, 0xb1df6b18, 0x3defafde, 0xa9148178, 0x970042a5, 0xd22d41ea, 0x2428817d, 0xf35e14c2, 0x0cf30f5e, 0xa29c102e, 0xab5b268e, 0xd1976ab3, 0x771d8625, 0xaf9a6e5e, 0xde986b5e, 0xe83e9e12, 0x5aa74016, 0xd3cf117f, 0xcf9df123, 0x1c23e5fd, 0x22d24063, 0x7d7beb37, 0xbab35ef9, 0xe8fb22ea, 0x3b1eabb4, 0x56df2a70, 0x5d855c1f, 0x09347801, 0xde838b01, 0x00473490, 0x3484b6fa, 0xb0e1e050, 0xdcf17a46, 0x5f80618d, 0x0ac26afe, 0x8a15c958, 0xfd6d01cf, 0x54026257, 0xc7b1a945, 0xf071cda4, 0xf8f23532, 0x82f24756, 0xbb3010be, 0x67c9f1ec, 0x2dd5192b, 0x97bf6677, 0xbbd3e6e1, 0x241e4af5, 0xd57f1e36, 0x554cb284, 0xde55620f, 0xdd255976, 0x11c0be75, 0x4d314f97, 0xda6aac77, 0x035b539b, 0xa4352cb2, 0x6e0c0d0f, 0xa8b9334d, 0x0283bdbf, 0xba38049d, 0x71e4e348, 0xa31b7313, 0xc4f4660b, 0x580b4f61, 0x9678eeab, 0xe654c047, 0xdd5f4bcc, 0x4f8fa8c5, 0x836ec38d, 0x3268cae4, 0x746c3635, 0x73b8e88c, 0xcd8b4751, 0x9f3b3acf, 0x54d695fc, 0x56443b1f, 0xb8d32459, 0x7bbe001a, 0x10319670, 0x751eb56b, 0xf3c22f23, 0x339e6aee, 0xd13edde0, 0x0547c60b, 0x1b2b0528, 0xfc940a13, 0x2e6364f2, 0x336a8d2c, 0xaa5bf39c, 0xb0574f22, 0x50beea90, 0x1f99c1d1, 0x91e626e8, 0xc357362f, 0x5211a306, 0x352e2d33, 0xa81d9794, 0x385113d4, 0xaad9de96, 0x41d8b6c8, 0xb335425f, 0x0f721688, 0x667686e8, 0xfb5f4b55, 0x1670f4bd, 0x61a0d4c1, 0x0e77c44e, 0x03bff129, 0x0cb7d07b, 0xff91d80d, 0x3da5e8d5, 0xe4931f12, 0x66a42724, 0xa8759d68, 0x0000010c };
const u32 bern_num_data407[144] = { 0x4d3060dd, 0xc97f052d, 0xc9c41e7c, 0x1396c550, 0x00962d71, 0x881e1d9b, 0x5ff76a7f, 0x5fad3f8e, 0x39c7f39f, 0x1151efee, 0x008fadf3, 0xeeba40bc, 0x72040346, 0x642e203a, 0x41c3d9df, 0x576ba225, 0x3bcbc6da, 0xdbc3f118, 0xf57959b8, 0x9f8cc8f4, 0xa4d1b371, 0xbb37630b, 0x3312fb39, 0xc3480c9b, 0x920fd3e0, 0xae4f1239, 0xc9964b21, 0x066ee419, 0xda1d063a, 0x6c8f2c79, 0x8b274f67, 0x0f862504, 0xb310c0cf, 0x47ec1336, 0x54c7c1d0, 0x87c6fca2, 0x0fa58a0b, 0xd5bbebb3, 0x6f6812e2, 0x6dfc426b, 0xb16dd5f1, 0x224e64fc, 0x1f0bc65e, 0x4efb12bb, 0x13e52cf8, 0x2251e648, 0x86a2006a, 0x4426bf98, 0x5bc7c748, 0x91a5a184, 0x02175343, 0x824472c0, 0x5684ba9c, 0xd0d2765d, 0xb95edbe3, 0xb9cdaef3, 0x92a49f3d, 0xfe113497, 0x0d428edc, 0x25ee7770, 0x43a78127, 0x6163e2c1, 0xa8900cda, 0x4a4f5249, 0xf2c278e5, 0x5e7e4c4b, 0xa5878378, 0x3299d6c4, 0x281888dd, 0x12e1486b, 0xe6ccb2e6, 0xea795dd7, 0xee47b29c, 0x519df4b0, 0x40458feb, 0x4ac12e5f, 0x2b491713, 0xe55b8d52, 0x14ce1ace, 0xa0a55636, 0x8336c79f, 0x65a839bc, 0x4c00f40b, 0xef110f32, 0x0882bb64, 0xdbf1919f, 0xf8421fd6, 0x3a9ea70b, 0xc62aa1f6, 0x6f44732c, 0x4901ab2d, 0xb6046046, 0x9a5ef9f9, 0x8dc9f713, 0x2b19ff47, 0xad23dd09, 0x77e2c120, 0x7d7154cc, 0x70519fb8, 0xe931add4, 0xea8c2513, 0x21548bd3, 0x43a3677a, 0x137b6083, 0x03e425c8, 0xf468b3a7, 0x9291df5b, 0xfeb36bb0, 0x87862444, 0x3b36dd48, 0xe2f843d5, 0xf675f141, 0x02e4de87, 0xdd9a8098, 0xc8c8ad6d, 0xc8da8bd0, 0xed3d42e3, 0xf1fa0753, 0x7a100e42, 0x76626c27, 0xa7d27b7c, 0xfe1293d8, 0x66ec5729, 0xc0a8fa28, 0xe554e3aa, 0x4f20af80, 0x94d8ec50, 0xf4cb9c0b, 0xd5abaf51, 0x60f11fc5, 0xf254aac5, 0x7dfc0ea8, 0x0eb20095, 0x28d362a4, 0xdb3e3eb8, 0xc50aa480, 0x76a009f5, 0x4fbe695b, 0xb7793d68, 0xfbf0fd58, 0xac0b2b4e, 0xa83441fe, 0x64bb7f44, 0x001f352b };
const u32 bern_num_data408[143] = { 0x0934011f, 0x63baca2e, 0xfedf1b4a, 0x3484c777, 0x1f8e6590, 0x72d3e7e4, 0x99665e2a, 0x396cd67f, 0x9618f567, 0xa0e22723, 0x10a632af, 0x9869bff8, 0xc3385c42, 0x4b5346bf, 0xa873687e, 0x4627ea62, 0xa70c98b3, 0x966bd5e9, 0x46577d1e, 0x21c99730, 0x9a7d1c02, 0xc7cd6b11, 0x9f13528a, 0x5e534f94, 0x017599a6, 0x5d7e5118, 0x362658bf, 0x8a4ab3dd, 0x3e999768, 0x97da7b10, 0x89fab097, 0xfe95d62e, 0x788d9484, 0x829bced0, 0xbf8ed2e2, 0x9655a10a, 0x46ab19b0, 0x85f4bda3, 0xbe77d8c1, 0x0d7fe80b, 0xe1b393a4, 0x078bf62a, 0x00b42ea7, 0x9f41edbe, 0x00469074, 0x8ee86f78, 0xb9e33cb6, 0xd3743e5e, 0x74728378, 0x8538b546, 0x6bc6d1c6, 0x99771c90, 0x237d3e0e, 0x9194ff37, 0x83f92f8c, 0x1dba9819, 0x9fe033e2, 0x8359d719, 0xdc134f98, 0x05db7d97, 0x8c4c4638, 0xe7258bd8, 0x6f61c38a, 0xe597f8f1, 0x3941b882, 0x29e125e6, 0x760f959b, 0xae569585, 0xf6b787ac, 0x871358de, 0x2a0379de, 0x5dd906bf, 0xd4f413ee, 0x3c3e4171, 0xe1b73ab3, 0x6ec70bfc, 0x5918660f, 0xddaf6209, 0x6fe9f563, 0x28820aea, 0x0cbf0236, 0xa472b639, 0x7eac94aa, 0x24832aca, 0x707b1de1, 0x80c9ad89, 0x21ff66aa, 0x8ffd2391, 0x45c02d7c, 0x86775095, 0xb43508cd, 0x88bde5fc, 0x4b0956e6, 0x473650a3, 0xd0a670a0, 0x96572f5b, 0x05ab861e, 0xf96099dc, 0xfccee4b1, 0xb046bde3, 0xd083843b, 0x155a82e5, 0x0fbe717c, 0x85a4585f, 0x90990bc8, 0x7feed9d3, 0x785d949d, 0x4507392c, 0xa3d33d2e, 0x4eb995d4, 0xf54ea432, 0xd3de0947, 0xb379514e, 0x997b297c, 0x047704a9, 0x21547fd6, 0x4c291558, 0x47a75cb4, 0xe1d83f05, 0x5d317476, 0x1564008d, 0xe8dd0fb8, 0xf373045b, 0x66b07775, 0x5ad6e475, 0xdc767c2b, 0xd6d1e6e2, 0x3324f06c, 0xb7e70d90, 0x20ea6231, 0xf8b7a3ac, 0x4cec0fc9, 0x4459d973, 0x9d60a601, 0xa6e5498c, 0x37d1c283, 0xe88cb9b8, 0x6ea1f79d, 0x8847fa9f, 0x3f1e9061, 0xf672f49b, 0x393df258, 0xc68b25c3 };
const u32 bern_num_data409[145] = { 0x6bb73cbd, 0x1f392674, 0x863f9fbc, 0xc846be15, 0x8e95855b, 0xeabf41c1, 0x0a771faf, 0x6808f379, 0x0016949c, 0x8790ee3b, 0x51b7da92, 0x63018393, 0x07f4ef6d, 0x3fd41b07, 0xe975a8d3, 0x0cd36d81, 0x603e23aa, 0xa9fb2964, 0x103cc6d9, 0x3429cc0b, 0x7f36dc80, 0x5013d52d, 0xfe82463b, 0x2eb2b896, 0xf78f7a63, 0x0504e1d4, 0x36c7623f, 0x64570120, 0x29059073, 0x4374666a, 0xa4115b9c, 0xdfbcc14a, 0x8d668186, 0xf6c38ad7, 0xc8c7caea, 0xe2faba9b, 0x12762cee, 0x19313d4c, 0x0342bf7f, 0xc972a4bc, 0x8b51498a, 0xbf131439, 0x951a18f6, 0x0b002ce7, 0x1f097136, 0x52eb47e6, 0x266241b0, 0x2362dd00, 0x9d72295b, 0x039447fe, 0x2f549bbf, 0x275ba83a, 0x2be054f4, 0x0a5d7030, 0xa91ee478, 0x386ec46f, 0x52a4feb7, 0x757b8025, 0x822346f9, 0x75ab78f4, 0x919cd4ad, 0x457a4a40, 0x9297d930, 0x4675d815, 0xb350207e, 0xfe6de92f, 0xf05c054c, 0x6712aa58, 0xdf2056f5, 0x0d9faf8a, 0x2eeee3cf, 0x5ca066a0, 0x3f24b373, 0x68987583, 0x44a1e883, 0x0ea1b489, 0x57825cc5, 0xee344180, 0x2dff29b2, 0x66db2de3, 0x070af951, 0x0cb89463, 0x7db45283, 0x0f0d9238, 0xe60fd92b, 0x68c12915, 0xd6014bc3, 0xb636ee69, 0x81a1c871, 0xbf4113fa, 0x950ca9e2, 0x9b165568, 0x1ec32457, 0xfc977383, 0x01e5200d, 0x72449ee6, 0xf88c50cc, 0x8db9c141, 0x0df2fd00, 0xbd46e43e, 0x2ae3ec50, 0xf920f935, 0xde580e8c, 0xaeaba6dc, 0x95ebcb26, 0x34326912, 0xd8d5cf54, 0x592da6b3, 0x544ca13b, 0xda73ea24, 0xbf0c2a27, 0xeb58e464, 0x4eb46c76, 0x4e061fb3, 0x50c00f32, 0x039e46ec, 0x93506b5c, 0x3e9cc5a0, 0x40090de4, 0x27d37af3, 0x7c16148f, 0x8b6e4ccd, 0xcf3999c8, 0x1c06cf0f, 0x96a74a8d, 0x4ec3c434, 0xcfef1b00, 0xc3501ba0, 0xabd6ad1b, 0x057eb105, 0x45fb9c28, 0x8ef77163, 0xe6c3ba84, 0xe517a25c, 0xa349d288, 0x7b69b6e9, 0x010375f6, 0x319ce636, 0x48f7c653, 0xdb4be6cb, 0x10fcb4c0, 0xff234e96, 0x0dc2ac16, 0x83418c1f, 0x0000000b };
const u32 bern_num_data410[145] = { 0x56605b77, 0x7f923c89, 0x9e82095a, 0x837566c5, 0x3baab569, 0xe0d56887, 0x2503b2b5, 0x5c8ca091, 0xd2a12d35, 0x907b949c, 0x573715fb, 0x87fa1cc7, 0x59f2dcbc, 0x227e27d3, 0xfaa21218, 0xdd358dd2, 0xec47b27a, 0xf5b2e8a5, 0x67df31f4, 0x440b48a4, 0xf2a6639e, 0x5887a881, 0x0c8dde34, 0xb77ff22a, 0xae83c04d, 0xc9bfa47c, 0x6e3ff636, 0x9f8e8c8c, 0x9572f0ca, 0xcac58d63, 0x668a75da, 0xdca783a7, 0xbab98166, 0x4d782375, 0x7bb86d62, 0x0b196924, 0xca166165, 0x68b98609, 0xa8ed7a09, 0x2219c103, 0x0e302e85, 0x44341b12, 0x6c3ac0b0, 0x22e1ebb7, 0x36deb6c1, 0x2aba0dba, 0x6c58f675, 0x35035a0a, 0xc6da16cc, 0x2f27e2bd, 0xc70ac709, 0xd60182b0, 0xcb81b8f5, 0x7472a728, 0x0782a61f, 0xed91e7be, 0x48b02685, 0x1bd597c5, 0x11cc73fc, 0x75399644, 0xf55f2ba9, 0xfb422f22, 0xa3161afc, 0xcdcdefa2, 0x002bdeb5, 0x24a00da0, 0x150760a6, 0x3a1c5016, 0xfc5e9ec0, 0xf6237b22, 0xa17cacb2, 0x27d2b0d9, 0xc047d7e0, 0xf23a3c13, 0xc8b14b45, 0x90370d0c, 0xe1b32d4b, 0x0a832fda, 0x1dea2046, 0x1503fec7, 0xe4982912, 0x897bac21, 0xa3ba3b49, 0x101ed360, 0xac7825c7, 0x0ea8c7ba, 0x8d63b4e3, 0x964e2a74, 0x11ce49de, 0x094c5a2b, 0xc7e4a7b4, 0x3f6e556a, 0xb5a4bfae, 0x3febe671, 0x7445ce71, 0x1ee43200, 0x1c812976, 0x208b2e69, 0x06b2fe3e, 0x0989f728, 0xe6bb9dee, 0xfdba916f, 0x6d14e5d7, 0x96a786e9, 0xbbc08a76, 0xb9f4de32, 0xc3334ade, 0xfb3000df, 0x2b2e2ef6, 0x8dd01398, 0x65b08d00, 0x9d3c16e5, 0xb0611b15, 0x20627366, 0x7d5f8974, 0xe579cc84, 0x5ebc8842, 0xddb5978a, 0xeaabdb03, 0xc487d8c0, 0x221c60c5, 0x9d612f0f, 0x1e6fce69, 0xc175f0a9, 0x13585091, 0x7ccc5d7c, 0x8dc9d682, 0x19bae0a3, 0xd1cc2836, 0xb33757b1, 0xd4854095, 0x72127161, 0x5494f9c6, 0x98d2093d, 0xe17f1dfe, 0xfa1a244f, 0x8b0a5761, 0x783a6897, 0xb0211ee6, 0x4ef85854, 0xbabd5fa2, 0x50cf5d22, 0x0e0e6a89, 0x83de71a3, 0x0000012e };
const u32 bern_num_data411[145] = { 0x8a5708e1, 0xebb72afa, 0xcb3eb56c, 0x05a2e05b, 0xe344b4e8, 0x9db34a39, 0x18f3e8c7, 0x1754ad5f, 0x9a9da739, 0xd2d18228, 0xed6fd6a9, 0x6ed608f5, 0x71b9d5c3, 0xe3b481da, 0x3d9d8ab2, 0xca8f8eac, 0xcd3b9511, 0x2485b819, 0x116981c1, 0xefb9affe, 0xfdb8c164, 0xb656f4af, 0x11f2d1d5, 0x1510b624, 0xbcc8d369, 0x357d4576, 0xf7ba4192, 0x2a994124, 0x24723fd7, 0xd291d7c7, 0x2b0d3b91, 0x8f532c84, 0x4a558f8a, 0xac9e2063, 0x215e08e1, 0x389f4a50, 0xaf9ff517, 0x97b418ca, 0x792fcf82, 0x0a04165e, 0x8f3e9873, 0x0c09d3ce, 0x7bd36c51, 0xe8a3cdcd, 0xe68a9239, 0xc7ac4f82, 0xfc174b36, 0x72c5f446, 0x9fb2b6c8, 0x6cb1eb31, 0x6eb735a9, 0x6453a255, 0x5ec4706f, 0x0ce0b975, 0xfb7ffd33, 0xa79ad2e5, 0x7b958539, 0xab0ffe5a, 0x3b31dc35, 0x1dac3cd0, 0x629ebf8c, 0xba7d6a46, 0x9a503e79, 0xbd1252cf, 0xa40308eb, 0x4a773af9, 0x6b020fe7, 0x5a4c9ac3, 0xa656737e, 0xf12ae51b, 0xcd1b424c, 0xb37c97e1, 0x707c3ef9, 0x5a05d5fb, 0x4fdaef0c, 0xe528d0f0, 0x772afda9, 0x2143b133, 0xfa443870, 0x478fb232, 0xf9dabe63, 0x0a4f35fc, 0x6176f781, 0x3d4ae8b4, 0x68021dbd, 0xa7be5370, 0x7c61fcce, 0x02bdedba, 0x184d305b, 0x531b87d1, 0x7b1ea02c, 0x22f7bc81, 0x07f40f86, 0xb972bb6b, 0xcf60ae7c, 0x8b9fe902, 0x15a4ff28, 0xd3b216f7, 0x5c868d4f, 0x414e69a1, 0x9d355345, 0x14bfde8f, 0xe664b99c, 0x721cd150, 0x05c23bf1, 0xcdd54708, 0x854fdc38, 0x3fcb136c, 0x7c90d665, 0x636945dc, 0xf8a88e5a, 0x5eaecbc6, 0x580cec4c, 0x81f3ed54, 0xfa136909, 0xe8bcc7a6, 0x8e3a581f, 0x01f44b23, 0xc56700bf, 0xaccd6fb2, 0xf30a8196, 0xc6cd7dae, 0x8817e14c, 0xa1cfedf5, 0xa888983c, 0xe78072e5, 0x277363af, 0xe53a81bf, 0xfc410e00, 0x5d200492, 0x492b33dc, 0x1ccb2774, 0x0a799346, 0x8b4d5d99, 0x16ad0cf5, 0xefab0053, 0x1655d16d, 0x0a3ee0ab, 0x6a93543a, 0x34d5f642, 0xd285a709, 0x047a54c4, 0x818503fd, 0x1a839e0e, 0x0000119e };
const u32 bern_num_data412[146] = { 0x6f21e235, 0xd3150e67, 0xa7acd56a, 0x273d5fd7, 0x489b0d03, 0x5a05444d, 0x09c03153, 0x87dbb163, 0x6f9b49e8, 0xa738a233, 0xc6f51ebe, 0xb6533881, 0xd150ffd1, 0x922fbe43, 0x9e135acb, 0xcd42c869, 0x4d7c2cc8, 0xd8f95540, 0x81cf0265, 0xb9c843d2, 0xcd06799c, 0x7ac98b45, 0xd8e1035e, 0x75bd484d, 0x2a74e971, 0x55cb842f, 0x35612b86, 0x65b8c531, 0x6e88d4b3, 0x869d0dce, 0x6fce974b, 0x7cdfde7b, 0x33ed9725, 0xd6a30921, 0x8878f2c1, 0xf24f5a0a, 0xd53d968e, 0x38ffed79, 0xfc98c8d8, 0xbbbfab73, 0x51b9e1a1, 0x5693654c, 0x2a681fc1, 0x6c8c1497, 0x4f8750ec, 0x82d0d84c, 0x41ce1289, 0x9f26d621, 0x277e376e, 0xe956f658, 0xdb91e56d, 0x87c8a728, 0xa91fde26, 0xa6383736, 0xecac8fa5, 0x9f7f2025, 0x886cec42, 0x79248968, 0x6ed04f56, 0x32752fc5, 0x522f33b4, 0x8ffc057c, 0xf4cf9b18, 0xcdeb38ca, 0x1e772cbb, 0xc8874c05, 0x554e1994, 0xacc7e349, 0xaf4d680e, 0x781d4335, 0x45696186, 0x38c52dd8, 0xaf47eeec, 0x068dcc31, 0x44f9bfc9, 0xdd319082, 0x7d2e9a4a, 0xe0ba6012, 0x4ebb9fde, 0xcce09fdc, 0xb3fdc3c6, 0x67a8d6a3, 0x704c9b8b, 0x899f6f2d, 0xf5c6a732, 0xc8fd203d, 0x492a1bfa, 0xc6025bca, 0xfd4d5b18, 0x2aa278b6, 0x6f5d9225, 0x406771b6, 0x6b24bfa6, 0xfa7a7130, 0xb539634a, 0x0e647486, 0xbf9d6b61, 0x6a09f1f4, 0x94f33591, 0xfa1815dc, 0xcc2e6b30, 0x341847b7, 0x94885362, 0x5c04aacd, 0x25d9ebbc, 0xd159fc76, 0x16da2ca0, 0x2fb664fe, 0x45929099, 0xe6e98546, 0xdf1c821b, 0x87cae440, 0x8c306415, 0xe6cd7a20, 0xef215e34, 0x3e94da3e, 0x7904a66a, 0x21dc03a2, 0x641040dd, 0x32d20437, 0x61c6820e, 0xfa301217, 0x45884c44, 0xa627e42c, 0xdb453b8f, 0x7bb06cf4, 0x17dfb8f7, 0xea138d9f, 0x6bcc0319, 0xc582bc6e, 0x2f64cdf1, 0x3a490f02, 0x1c488e07, 0x990ae788, 0x61a34634, 0xf9cd678e, 0x54172fba, 0x32b5a1b9, 0x13582f7b, 0x1209c82d, 0xb5a4e4e0, 0x8a644700, 0x6c50dc03, 0x9adbbe31, 0xff7f184e, 0x00000002 };
const u32 bern_num_data413[147] = { 0x4152bca1, 0x4ebbbb47, 0x5ac4cf43, 0xc2d50dc8, 0xd2115534, 0x393d13ad, 0xdd0e1962, 0x82367e2f, 0x77efb344, 0xe52f5d22, 0x2fde82e4, 0x23c64186, 0xc0e9cda6, 0x3b7cd308, 0xa4d3326f, 0x6f48198d, 0xce3f97d3, 0x77d93f5f, 0x0962a651, 0x10ed6b04, 0x5b244e71, 0xc216a9f1, 0x89f22d93, 0x042a3dc2, 0xe6830100, 0x703a44ed, 0xb8658cdc, 0xe140d39e, 0xdad6e5e5, 0x9c0367c5, 0x2a7b2652, 0x3e07dd82, 0xa679a425, 0xe4993f90, 0xf5bf8311, 0x417787cf, 0xacb92492, 0xe2f65130, 0x12fed5a0, 0x0755dc32, 0xe9071fc5, 0xe945ff7c, 0xa40edd13, 0xdda3a644, 0x0ca92e49, 0x3a72e564, 0x8097763d, 0xe50023a4, 0xd2690bd7, 0x0581105a, 0x7cbc9d25, 0x729c5ea2, 0x750fd9d8, 0xa5a36f53, 0x132ba6d4, 0x81e3c2de, 0xb680ef1e, 0x1163abec, 0x4fec2941, 0xfdace2bc, 0x04effc91, 0xa0ecf3ad, 0xbd36a676, 0x35c3fa13, 0x0365ccfc, 0x5343591b, 0x40861332, 0x265e8f93, 0x3eb46be8, 0x56c51738, 0xba583785, 0x5fe51b72, 0x817fac3f, 0x4ca9d695, 0xf69a2dc8, 0x1434334a, 0xa3779cea, 0x9a9585d5, 0xc9bf5d45, 0x3dbb290b, 0x4f5e5b82, 0x926708b1, 0xe69a9edc, 0x9f724a06, 0xf066adab, 0x9e3a39a4, 0xa2655fbf, 0x1a4688df, 0xf865f994, 0xd6d7621c, 0x186bf0a0, 0xcce1d351, 0x3bb99619, 0x80940ba2, 0xf0e00dd3, 0x4a1ccd08, 0x6190cfe6, 0x4be0e1e4, 0xf3bc3a54, 0x84a7471c, 0x4308208e, 0x50f5080a, 0x90074988, 0x1e5265a7, 0x64b1471f, 0x1e54b5fe, 0x05a6f34f, 0xa8108791, 0x04d06e6a, 0x45736514, 0x97bd8c2f, 0x86e37757, 0x9e0177c2, 0x7854fd9f, 0x056dcded, 0xd02de0ce, 0x04f9a187, 0x3df04b6b, 0xa4e50026, 0x55fbf1c6, 0xfee4e6f4, 0xfaaf529d, 0x42019761, 0x5024185c, 0x86f6a0b7, 0xfff3828d, 0x2dbe69e8, 0x3ed56d5e, 0x6401f171, 0x0ebe21d0, 0xb7fd6e20, 0xe2702e65, 0x01537d04, 0x2463c899, 0x3895e8da, 0x0e6f9b6f, 0x92e11f3c, 0xd543c8ec, 0x250f6bc0, 0x01052520, 0xfc956e92, 0x34f3094b, 0x15e4edfd, 0x615932fb, 0xd2f4f954, 0xae6b414f, 0x006b3252 };
const u32 bern_num_data414[146] = { 0x47cba6db, 0xa1ca16de, 0xe97cae95, 0xb28f7350, 0x5c3b7cb1, 0x68be19a4, 0x046cb481, 0x7ef5eee1, 0xfd7abe1c, 0x7647229e, 0x37addf34, 0xfa7683c0, 0x7e173f15, 0x705fbe74, 0x375e9893, 0x28b6e473, 0xbbabadc5, 0x1d2fd160, 0xadde2b49, 0x744bf4b2, 0xba562c09, 0x677e5417, 0x01288d02, 0xb1457501, 0x4b59ba8e, 0x37bab993, 0xcdd583bf, 0x8dcb7341, 0x19ec6c90, 0xf2ea0016, 0xd1b6c8b7, 0x35edb9c6, 0xe3ef6b56, 0x56640ab5, 0x3ec16d98, 0x1bf210fa, 0x77876989, 0x8c0b0042, 0xed2558b4, 0x7854ab60, 0x4e49ddbd, 0xb7dcac12, 0xdddef685, 0x6b43439d, 0x1a44a57d, 0x2a5e27d3, 0x0473255d, 0xbc9dc959, 0xae5f918c, 0x7f113900, 0x197b7734, 0x5a153300, 0x2b3c3511, 0xbdc766be, 0x6cc58bd5, 0xfb03b930, 0xf183dd79, 0x1fb13c33, 0xa2de0ac4, 0x23f669a9, 0x48f148da, 0xc0bbd399, 0xdecae5d4, 0x8569e17a, 0x82f5749e, 0x28384dc4, 0xe8f0868e, 0x6a93b006, 0xf9707317, 0xb8d12c0a, 0x85cacd04, 0x484cd38a, 0x3de09180, 0x86888ef4, 0xeb2e5d02, 0x7cd0e58a, 0xae57d65d, 0x1532370b, 0xacf69d1d, 0xbe334616, 0xf23ea7f3, 0x825f8745, 0x5a2b38e4, 0x676a659a, 0x5fad7e34, 0x768682c2, 0xfa59510b, 0xbc96e6e4, 0x284e9129, 0x5e405cd3, 0xfadf16ea, 0xe696452a, 0x9adb0dc6, 0x3c1531c5, 0x41b79e65, 0x5985081d, 0x4e31e91b, 0xb6b50e9f, 0x47041c9d, 0x44c5f72a, 0x5832fbb5, 0x93d0f8c4, 0x79c48f60, 0xb15c33c7, 0x10d8a7fb, 0x709a7ff5, 0xac738838, 0xdd50f369, 0xebec1710, 0x21e5bb2c, 0x958c44ee, 0xe8f325e6, 0x2580fb1f, 0x7bd2a58e, 0xaf9bf154, 0x91b129bd, 0xba6401f3, 0xed12a5e7, 0xfd97b991, 0x553d4504, 0x0ac4c38c, 0xfb321055, 0xbc69b612, 0xac3cf4c2, 0xada78db0, 0x98a4c83c, 0xa6763eb1, 0x24ab7d41, 0xb11cd1f7, 0xd7617fd6, 0x169381f3, 0x16f1f209, 0x368d8799, 0x37774541, 0x4a360fb2, 0x5c78f16e, 0xe9b5ae7f, 0x9bd9c2fd, 0x0d7dad15, 0xfaa7c8e5, 0xa6f57913, 0x15bb1114, 0xeaf7c4ef, 0xe990388e, 0x61d0bb78, 0x77ff253c };
const u32 bern_num_data415[147] = { 0x038f6fb5, 0x765c3220, 0x92f81b8f, 0x2675e2dc, 0x635ad02e, 0x5fe2583c, 0x389dc243, 0xf3e609d7, 0xc49ffc5d, 0xc5ee04c6, 0x331f2733, 0xcc67d0e9, 0x709c52d4, 0x4b1897fd, 0x4b7e86b4, 0x0ddcfa57, 0x65ece7e1, 0xf4776363, 0x2d180bac, 0x2b45a5d6, 0x3b5159a4, 0x14985811, 0x5f097f21, 0x5f5af369, 0x92a19d1c, 0x3b60cef8, 0x9496c7f4, 0xa428c6bb, 0x52d95279, 0xefc72e2d, 0xc8db6ce6, 0xa7212017, 0x49d9c73b, 0x8bd2177e, 0xdc3011cc, 0x52ef6e1e, 0x60b9a213, 0xed49fa77, 0xa85f66e9, 0x96e50ff9, 0x02cde480, 0x581f5c8e, 0x17e37a59, 0x07bead60, 0x99c90826, 0xcd5288c3, 0x3fad54d9, 0xc29004ab, 0xeaea29d3, 0xbe8913c6, 0xae0cffb5, 0xaab1f09d, 0x9cf5133b, 0x2b5c3d01, 0xb5ee374d, 0x5eb7d435, 0xb06d44e2, 0x699b8fc7, 0x3288832f, 0x5cb3d303, 0x076365cc, 0xe8e63454, 0x7cf39849, 0xc9749cf2, 0x1170019d, 0x41e20e05, 0xdf4799a4, 0x95d5ac12, 0x7d3fa784, 0x41fbdf8d, 0xc02549bb, 0x154524bb, 0x61934fb4, 0x7c51dcb6, 0xb8dbafb1, 0xb277e978, 0x986858ba, 0x3db0cac0, 0xd28b1b6f, 0x90b6e907, 0xb0039c0b, 0x4de5a6fc, 0xdadeccfb, 0x9d013b30, 0xcffcadbd, 0xb3f10528, 0xa7746b0c, 0x9e1d7c88, 0x7ca2e0a4, 0x25c4e7a1, 0xc21f7751, 0x63862310, 0x5bbe4747, 0xe75a520c, 0x6ea95d02, 0x2c51d8ad, 0x80dbc6ea, 0xe4eca980, 0x8da9fe97, 0x5aaa792b, 0x940a8c25, 0x8b25b232, 0x3497662b, 0x0c863427, 0x68e3feeb, 0xaa0f3f59, 0xbe2ff890, 0x98d468c0, 0x74350d4c, 0x5092ed65, 0xaf72af7e, 0x717f1b4b, 0x306caa66, 0x193fed4c, 0xdc26c224, 0xc695d530, 0xbfac6dbf, 0x6152a0f2, 0x753b1a0e, 0xc177b74e, 0x92949153, 0x91616918, 0x3f765f6f, 0xeb5e8b8c, 0x9feed51b, 0xc66bf33c, 0x5973a219, 0xc8dcc1c7, 0xec10be21, 0x7053e7b7, 0xd8f8dbc5, 0x7c3757a1, 0xe5de6107, 0x63ee2c2e, 0xd82601c0, 0xb4b6b8a2, 0x16a026c8, 0x92d9b7f0, 0x29c9ea82, 0x97ad4675, 0x19d57301, 0x8e4e5b8f, 0x03ea1f99, 0x73b74d42, 0x5da1fb03, 0xa75b8e05, 0x00004ea3 };
const u32 bern_num_data416[147] = { 0xafab7079, 0x85804e48, 0xe9d194fd, 0x1c3844e4, 0xf2a98dba, 0x4b23bfd5, 0x5adb5ec3, 0xb15de174, 0x0f3040cf, 0x0b3337e2, 0x6b3e64f3, 0xb47ff26e, 0x4a43d2ea, 0x13ac9f84, 0x61682051, 0x3df25475, 0xe1bed76a, 0x73b0950a, 0x45df3cb7, 0xb34f5247, 0x8237d2ae, 0x8fbb17d6, 0x2508d729, 0x1aec296c, 0x292ea546, 0x391f43e2, 0xd932871b, 0x6a7c01a6, 0x62133f2e, 0x74d531c8, 0xb519ea78, 0xdaa327a0, 0xbb2eed70, 0xcc0799e3, 0x19c2a240, 0x323293c6, 0x920cc8c8, 0x77bcb0e6, 0xeabbea98, 0x6349fd1e, 0xee95c790, 0x96531c05, 0xa230928b, 0x6853fe0a, 0xda366e5c, 0x093c350a, 0x0ee83cee, 0xb895351a, 0x67d15ab5, 0xcb0041b6, 0xca1350c0, 0x737e98f3, 0xbc5ec5e0, 0x1f349759, 0x1929c810, 0xc3e8b4c2, 0x146ec7f3, 0x3434eab8, 0x912554d7, 0x2b7e9d6f, 0xd10ffe10, 0x8e382873, 0x9f203082, 0xbbe8c1ac, 0x55d46575, 0xf63512fa, 0xf9d35067, 0x193f82af, 0x2eaaa93e, 0x13023fd3, 0x62440968, 0x5f20c660, 0x3ad70ef4, 0xf55640df, 0xa2af7f6f, 0xdbd06200, 0xe05edf6f, 0x4a66e46f, 0x3c0a0cd6, 0x9f79c77e, 0xb887bd13, 0x4deb100c, 0x00c88670, 0x6df98db5, 0x07cc64f0, 0x6de371fb, 0x0b05b962, 0x75c5efca, 0xd6c636ae, 0x230ee5ba, 0xd11853fd, 0x73e009b3, 0xaee46719, 0x56dd7c5a, 0x5595d6b5, 0x694191ef, 0xf2026b50, 0x85ef7ba7, 0x639acdbc, 0xee3bad00, 0xa97dd3c8, 0xb19141de, 0x498a43d3, 0xd8c06601, 0x87b03d6e, 0x7546ec07, 0x85ad4a06, 0xe9df90a8, 0x59f5316f, 0xc07b9c96, 0x370b2807, 0xdc7b40bd, 0x45cd26c3, 0xed85f001, 0x6e590334, 0x7e3933e3, 0x50bfe968, 0x2e089242, 0xaea6173a, 0x53cb184c, 0x0bd72914, 0x5deb9bb9, 0x6d001f8a, 0xf3fa0e03, 0xc586b678, 0x230c0a9e, 0x6bf38393, 0xc6ccf61d, 0xf59708ff, 0xaf0a71af, 0x603beed6, 0x8960c281, 0xa884f443, 0x67828bba, 0x051737cf, 0x40f15213, 0x0407a669, 0xf1b8fa70, 0x30325926, 0xf43d8321, 0xdb581228, 0x0d4318f8, 0x85934cba, 0x065d38de, 0xf1ad28d5, 0x73bc05fa, 0x00086646 };
const u32 bern_num_data417[148] = { 0x95b964fd, 0xa4e4c104, 0x1aebfe26, 0xf6235c98, 0x08393910, 0x95d6e674, 0x7bc80b40, 0x1267c5e6, 0x4e708aa4, 0x33ea3d1c, 0x6df791bb, 0xc8a8dcb0, 0x92ae365e, 0x46b454b6, 0x03c9382f, 0x3352f761, 0xdcb38c0c, 0x8a9bafdf, 0x835a7eda, 0x9d4fac86, 0xc779b712, 0x99af1c0d, 0x2aafd23a, 0x8defd6ee, 0x4047386a, 0xfd166d2f, 0x29a3c4bb, 0xee17116f, 0xed75ae2f, 0x6c98b70b, 0xd06a0cb9, 0xf45ad1f2, 0x6a1a652d, 0x94e59b51, 0x97922223, 0xa3bfba1e, 0xae9ff2ca, 0x3b4fe663, 0x67ddbe3c, 0x5d6162a2, 0x30158c79, 0xd08e6fd7, 0x00d90ead, 0x9b8ac06b, 0xf3232183, 0x5c735349, 0xa86d18be, 0x54899740, 0x3d194a9a, 0x01671907, 0xf69b2d3d, 0x00804da6, 0xa45d22b6, 0x95de6368, 0x237d7abd, 0x41861bcc, 0xb84496d4, 0xd448a63e, 0x65ac72d6, 0x65801033, 0xc888542f, 0x7200cec7, 0xb92d526c, 0xeec867c6, 0xdaea69c6, 0xfd58c015, 0x65e036a3, 0x650b3553, 0x2997944e, 0xd9d2f189, 0xcaf9de00, 0xdc3871ad, 0x2a480588, 0xc4cae0e4, 0x69ef36b1, 0x010cf989, 0x29e00a9a, 0x58e3be8d, 0x7436cb51, 0xcb001514, 0xec79161c, 0x323d3107, 0x95293043, 0x6f68cc68, 0x01de0074, 0xf4026483, 0xd03caaef, 0x66a44c60, 0x6b6787e3, 0x217bd68c, 0xe241e945, 0x6e9ed600, 0xaa2c5ae1, 0x551e72b9, 0x2db5b6c1, 0x46051431, 0x4581230b, 0x10ae6cab, 0x768d94c6, 0x66238621, 0xeb8e8543, 0x89dfc2fa, 0xac6e6fa0, 0xb0d75857, 0x610b036b, 0xbc463105, 0x3965bf63, 0x6f12f544, 0x9eacca5d, 0x354aa63c, 0x40bb422f, 0xa46ad694, 0xac8afd22, 0xc3a9001b, 0x77b02930, 0x54e1fade, 0x232f61f5, 0x4a8b84a0, 0x131ce765, 0xf1c39753, 0x686a3008, 0xa6828cc9, 0x76a6df84, 0x987a8387, 0x03b13ec8, 0xdd6b4122, 0xbf5ba36e, 0xe0bfd380, 0xe3b09bbd, 0x8bf4b7eb, 0x1e75d416, 0xb2edd589, 0x325fbbc7, 0xb6938f14, 0xd63f9e20, 0xdf7d85aa, 0xd13a513a, 0x15c01442, 0x5528391c, 0xfd1c6011, 0x4e92793e, 0x4907e6c6, 0xf813ed0c, 0x360cc0a9, 0x56b9a091, 0x011ec58b, 0xded27941, 0x00003cef };
const u32 bern_num_data418[148] = { 0xfd610321, 0xaca77a4d, 0x5824b116, 0xddba14ab, 0x3aadd0b8, 0x62cdbf56, 0xeeaa10c5, 0xa63cf10d, 0x0bfa88d6, 0xfface5b1, 0xf5eefc3e, 0xb0c4543e, 0x2e87124d, 0x31b1616e, 0xab82a5d4, 0x26adbf4b, 0x5f25fa0a, 0xcd4605e2, 0x565a24f7, 0xa5279379, 0xf0bdc192, 0xba1fa322, 0x2551485c, 0xd8ed4525, 0x0e09eaf1, 0x3bbdb94f, 0x9a965f23, 0x482fbe8d, 0x4f4398f9, 0x9674074c, 0x984adf91, 0x5c9d7bf5, 0x9098e4df, 0x5df2e037, 0xe8e98337, 0x36c84b79, 0xeb4cc8c8, 0xc5324664, 0xa7bbc2a9, 0x251f4847, 0x6ad7d5e3, 0xdd3bbb05, 0x3786a2d5, 0x8b4d1d84, 0x595535ff, 0xb6f197cf, 0xd33aee30, 0x35203a2d, 0x011806bc, 0xfd9f52e8, 0xd5bf8894, 0x56b96c31, 0x69582b00, 0x1bb6cdeb, 0xc308f499, 0x303a75e2, 0xb4ea14e7, 0x73fc903a, 0xcb4591cc, 0x701087b9, 0x23f5527e, 0x9cd9948f, 0xdd3ffa4a, 0x17529670, 0x3b8a46fa, 0x7b9fe748, 0x7567ce0e, 0xe72ab98e, 0x0d57c237, 0xfd5fb2ac, 0xd69d4b09, 0xe6805db5, 0x0d692f40, 0xca4c53e1, 0x0d26ecd8, 0x9cfbea93, 0x340c97d4, 0x06948135, 0x2ad1b7ac, 0x12693b09, 0xea7e1c06, 0x71ada1c5, 0x67d7f472, 0xf9471366, 0x2cc859d2, 0x56ba39f5, 0xc58e677f, 0x6029b162, 0x243e9c3a, 0xcaeb033b, 0xdba3cb41, 0x5505d86d, 0x64976511, 0xee0f5332, 0xae0312f3, 0xb4132f66, 0x8a8bbd3e, 0x4f4e4734, 0xa12328e4, 0x2a333d1b, 0xcf004344, 0x0881b1cd, 0xae41c478, 0x913dcf5a, 0x1ca99c01, 0x61a9b7f2, 0x2c234677, 0xb069786b, 0x6a06d455, 0x90fc9729, 0xdb506096, 0xe394dec9, 0x7c9f3903, 0xe70cdaaa, 0x5df7817d, 0xbac050c2, 0x0b814ceb, 0x3b7c770e, 0xbd701dd8, 0xd188e852, 0x8daf18fd, 0xb3884b43, 0x4823078c, 0x4106e11c, 0x12e3252e, 0x93d27bdb, 0xbe04febb, 0x06f26437, 0x5dd89247, 0x756dfea3, 0x405af230, 0x1b565600, 0xb942f33d, 0x78a9c37e, 0x8e320320, 0x856ce7a2, 0x33109a7b, 0x68b6f343, 0x12614b8e, 0x656f96c9, 0xbf88815a, 0x5568d281, 0xdb3c50bb, 0xddf6ce87, 0x7bfef208, 0x9eac31a8, 0xe23f885b, 0x0049a347 };
const u32 bern_num_data419[151] = { 0xa4cb801d, 0x97b841a5, 0xaae3ce17, 0xc3a81902, 0x70a03785, 0x1ea9d9b5, 0xf3bbabe5, 0x5a010ca7, 0xe84c86b9, 0x1d641789, 0x9f60b159, 0xbb3c77e2, 0xe76ed3ee, 0xb53d7913, 0xd0e46be7, 0xf2870210, 0x58674b2c, 0x2990d4c0, 0x203984f4, 0x6f8ec5cc, 0xb5c1e765, 0x8ac489ae, 0x91effed1, 0x2d5bdc26, 0x1f47c6b7, 0xf5101b79, 0x9f14389f, 0xe1f5b7c5, 0x738c1ab7, 0xb286e0aa, 0xd1bcc57f, 0x6e9999bd, 0xb4ad0a50, 0x7d3acf3c, 0xe8c07ad0, 0xfd3b3f94, 0xcc88c63b, 0xaba62e5b, 0xa16672f2, 0x6199d941, 0x6ac1e62e, 0xea6e1a26, 0x27affb88, 0x5278d95d, 0x3cd603fb, 0xe7dbf4c1, 0x4c8ea80f, 0xff9173d7, 0x04f1caf9, 0xc1c666f4, 0x24511ff1, 0x5c903861, 0x6b0ea686, 0x9c70745a, 0xf8ee27d7, 0x16c2b5aa, 0x019bedf5, 0xbd0f8c8c, 0x263e5cbf, 0x6ca2995d, 0x30f9c683, 0xf5171248, 0x40fd45f5, 0xb940bf73, 0x20c6ca96, 0x57dab276, 0x3d724dc6, 0x6e52944c, 0x47c6bf03, 0xf8295969, 0x3e5e6e96, 0x42316fd9, 0x2b0c52f4, 0xf04fb076, 0xb0f40610, 0x093205da, 0xce5646d0, 0x4a2b6ee0, 0x9324add9, 0x1503d411, 0xf02fde12, 0xdd088b1a, 0xe8d76ae6, 0xa631f0fd, 0x58fbbe32, 0x41f3dab5, 0x95a579fc, 0x4842541f, 0xa5108168, 0x41660dae, 0xefbdefbb, 0x6e4846bc, 0x23affca6, 0x8631077f, 0x786dd66e, 0xd553a894, 0x0b4cb66a, 0x7a319de9, 0x5c1a8657, 0x723d63f4, 0x3c74bae9, 0x28f9b3b9, 0x19a42f84, 0xc043415b, 0x508ee4b6, 0x39961adf, 0x7ade7898, 0x6072354a, 0xb906f2f8, 0x7da04e84, 0x2362a483, 0x58f705cf, 0x5c10cc4f, 0x16b72cb4, 0x5aec6ed7, 0xfa085999, 0xb1d0665d, 0xad475e13, 0xb1bdccd7, 0x251b7f8c, 0x76cd540c, 0x4d16bbc1, 0x93e4f3cd, 0x09f840a5, 0xefa704e7, 0x1e0fdc60, 0xb0e57b13, 0x726573e9, 0x8963a77e, 0xce5ccef8, 0xacbe4259, 0x4cf85230, 0xfe9733de, 0xb732517e, 0x18fb6af0, 0xec187e31, 0xdc755b88, 0x93d85147, 0x53ea3a94, 0x060f5260, 0x8b65478f, 0xa7866dda, 0x647616af, 0x0612dd2d, 0xc26cf1ae, 0xe45f8205, 0x1f20ebc7, 0x79bc7587, 0x77e261c3, 0x1c88fe81, 0x00000001 };
const u32 bern_num_data420[149] = { 0xddafd7af, 0xedfd20e8, 0xd50ec10e, 0x632866a4, 0x9e33bfab, 0xcc821732, 0x6548d886, 0xabf69ab9, 0x4f1ade2e, 0x48c82724, 0xb7641ad5, 0x7e9ee7ea, 0x535273a3, 0x421a156c, 0x66726941, 0x7462f9cc, 0xab8bc135, 0x13f7cf9f, 0x4916e39f, 0x785fd2ff, 0x0a8ab88e, 0xcd0b4da8, 0xec40bc85, 0x98b4ee12, 0x9b09ac34, 0xac4def6e, 0x309c5e3f, 0xc774dc62, 0x186389ff, 0x4125e906, 0x8cfe18fa, 0xd23b0b4a, 0x6cfa4bfa, 0xdb31fc4b, 0xdb84d5bb, 0xdbb92ea7, 0x1b3901d4, 0xd02aae32, 0xd7fc74a7, 0x41d8a6a2, 0xbd4fbe3e, 0x38464627, 0x84afa26d, 0x929b4436, 0xb0c71cfb, 0xf01c7544, 0x2ebade72, 0x5dfbdce7, 0xdbed02fb, 0x0ec7af8d, 0x0a1f867b, 0x08574fee, 0x6e681d29, 0x27746624, 0x90a9e5c4, 0x56414b3b, 0xa79ae6b9, 0xeb2b706b, 0xa76ca882, 0xc8fb5da0, 0xcfdd3218, 0x1d9db32d, 0xb32bc142, 0xf9634112, 0xa2e23690, 0xc95c68e9, 0xf336e7b6, 0x98c9de82, 0x8327ebec, 0x948bc1bc, 0x020bf680, 0x48b8bc25, 0x422de3d1, 0xbc1bfef2, 0x0d85fd15, 0x286e3681, 0xc524d0ae, 0xce5b1dca, 0xfc41dadf, 0x1bd3b496, 0xc25ab02e, 0xea1fbd60, 0x211e2ea1, 0x811b7cc5, 0x72d0273f, 0x58a334bb, 0xdd2f01bc, 0xda3b1dbf, 0xb361cc24, 0x293b3b03, 0xf875a249, 0xa532961f, 0x163995eb, 0xd201ad84, 0x3b1ea1ec, 0x0c90ee6c, 0x3edcfbe8, 0x47ceb9ee, 0xc08dc881, 0xec6ac3ad, 0x7c49618b, 0xfa029d8e, 0xb4fd2852, 0xbaceb1db, 0x4c6d3817, 0x40901d0b, 0x005baa5e, 0x67850f0f, 0x5fba4c69, 0x87b54c20, 0x48125439, 0x8327bd45, 0x3daaca0c, 0x11d5589c, 0xe8a3adc5, 0xc327371a, 0x9607cca5, 0x98ef0a48, 0xa4098615, 0x2d5ba548, 0x73f84213, 0x73d738c9, 0xfd70bac8, 0xdb0247fa, 0xd3b4805d, 0x5795025c, 0x727a5440, 0x7c52c30b, 0xc22ed94d, 0x71dee0f0, 0x391aba06, 0xab8ea59e, 0x40f6709d, 0xd2d66a95, 0x5bbf31cc, 0x4cdabf6d, 0x009a7ef0, 0x7f6afc6c, 0xd52e99a5, 0x83aa0e88, 0xa9f37dba, 0x152fd8f6, 0x3364e6fe, 0x4e403ea6, 0x6ab09fbc, 0x9c5ab2f1, 0x4a6f0931, 0xd56aba19, 0x000001ac };
const u32 bern_num_data421[149] = { 0x786b1109, 0xb18d8b2c, 0x9bd2f889, 0x17ae1291, 0x3c14ee62, 0x2cbc218b, 0x434fdbf1, 0xfbc940c4, 0x64bdf46e, 0xf0270d0e, 0xaed14c20, 0x707549b0, 0x85f3d576, 0x71354c29, 0x82d1a9e7, 0xf3a791f0, 0x3e803894, 0x61456ac5, 0xd856c77f, 0xf757b0b3, 0x74e26d79, 0x434cce3b, 0xc2ba71bb, 0xe348f2dd, 0x1130b270, 0x7ef4d2a5, 0x86b9a423, 0x279ed88d, 0xb6d2b13b, 0x2fb7f345, 0x53e100a8, 0xf8464970, 0x453af353, 0x308a4437, 0x102bec81, 0x32955188, 0xc0810067, 0xaeb84b21, 0x5c6a12ef, 0x079a80b7, 0xb80420dd, 0xd50c5e33, 0x0228a99a, 0xa529ea32, 0xaf76a573, 0x732b480d, 0xb97c109c, 0x71b9460c, 0xf7f4ab14, 0xff029be0, 0x34528364, 0x2a522194, 0x081f50f0, 0xd6ad6eff, 0xd7cdfecb, 0xc9232da8, 0xd5a02d50, 0x1f12d3ae, 0xd2122da8, 0x736e699c, 0xab570160, 0x1a4e5098, 0x05883953, 0xb845ff1c, 0x8ee2094b, 0x6b98a39c, 0x8aa501aa, 0x6b0f90aa, 0x130c670b, 0xd45ea039, 0xe573225e, 0x30317e6a, 0x57c67fd4, 0x3a8c0b66, 0x6be87b7f, 0x8cb0ad68, 0x758734b8, 0x675b83a1, 0x3f572667, 0xd9c0a505, 0xee29633f, 0x462d9de5, 0x1a0f8ce4, 0xfbf591ea, 0x9620fbc4, 0xbead0a16, 0x0d6bb2c7, 0xd651de38, 0xf346a8e8, 0xa65c44fc, 0x75e02b09, 0x45410f14, 0x21fa24dd, 0x3e5d8af8, 0x311e1707, 0x60cd6545, 0x63204468, 0xe71954bc, 0x1f445c9f, 0xcf2bb7ad, 0xe8694b0a, 0xf3c53e53, 0x90dc7b0c, 0xf5527577, 0x5839c121, 0xf25949da, 0x3903cacf, 0x9500122f, 0xd136766b, 0x742432c4, 0xe8ac8486, 0x60f9ef46, 0xed767467, 0xeb40d6fc, 0x9f061840, 0xb23a557b, 0xdec79a84, 0x2c9cf86a, 0x2317a83f, 0xcddbb973, 0xb9d46e12, 0x47ef2d43, 0x79d63d6e, 0xae9cbce7, 0xec5d63f1, 0x478afb07, 0x58488662, 0x2999989e, 0xd99c468d, 0xe5459292, 0x63330127, 0x68976652, 0x786b94c9, 0x9c32502e, 0x62a395c9, 0x87ee3ee1, 0x0c6777ff, 0x8931f1a3, 0x2dfb692e, 0x1b69c21d, 0x45ac2fa0, 0x87840c8d, 0x6214c03a, 0x989683a3, 0xbeabb69e, 0x3033d4b5, 0x9717477a, 0x8beae4db, 0x024da4a2 };
const u32 bern_num_data422[150] = { 0xc27ebdb1, 0x056ef9cf, 0x4cf2928e, 0xd2736890, 0x525e4d4e, 0xd15b5664, 0xcedcaa8d, 0x1e929967, 0x1088049d, 0x9221ca84, 0xf9fb2b20, 0xa2e35d49, 0xe02df7f0, 0xb0497f67, 0x6be09cd9, 0x3e887b09, 0x6114de8e, 0x793470ef, 0x4a2ec230, 0xf757e0e9, 0x7828ad1b, 0x6a93dd0b, 0x5954ea39, 0x6252c1f6, 0x5b352c52, 0x8fbfa193, 0xdf4bc0a2, 0xf60a7fef, 0x5ec08f53, 0x954c5332, 0xb5fd0668, 0x82d0f551, 0x11609249, 0x237285af, 0x49fd7fb6, 0xc85e1aee, 0xfd7413d2, 0x40c0cfd0, 0x3269f6c6, 0x3fb38388, 0x34c1061b, 0x14a98d38, 0x06bdb8b6, 0x818cc707, 0xb29400cc, 0xdb3f94c1, 0x4c0a0b72, 0x828fc855, 0x620de3a0, 0x91627408, 0xd88d5953, 0x04d34974, 0x98dac198, 0x4a3375d0, 0x3ea912aa, 0x75841537, 0x53abbdb1, 0xb191f79b, 0x340ef558, 0x36a060e1, 0xb8a4f9de, 0x1072b75e, 0x78a62d7d, 0x5e196a0f, 0xa7a18b66, 0x9ce0b3c4, 0xf161ff5b, 0x0c578eff, 0x77877913, 0xbb2192e3, 0xefe95525, 0x7e9442ef, 0x09e8e737, 0x969fe29d, 0x92ffcb8b, 0x47c2ea92, 0x965c4acb, 0x80f9ec0f, 0x7aeb0618, 0x4a5d8f27, 0x7082d1c2, 0xe42a9ae5, 0xa61f3f8c, 0xeb3df6d7, 0x02c61813, 0x2c326003, 0xb8ae864b, 0x04224eef, 0x68c67ba7, 0xae9403f0, 0xb5714c76, 0x413f6cba, 0x43412992, 0x6ed0c7e3, 0x16eafd5f, 0x4ba55146, 0x6d865d94, 0xc85f9703, 0x51675c24, 0x5406c514, 0x3ef29731, 0xd38012d9, 0xe71d51ed, 0xbaa3f43c, 0xd338f7fa, 0xa47f6ff3, 0x1ae71c13, 0x0d550e9b, 0x15bbfa95, 0x2b1cc0c4, 0x26e78ced, 0x834d750f, 0x9bca5b76, 0x32b786fa, 0x2693e52d, 0xa62ddc73, 0x435fff2d, 0x69fe7f7f, 0xa40e6af5, 0x7aba2947, 0x80f774f4, 0xebe9c51d, 0xd95909c1, 0xd246011c, 0x456268c7, 0x566a450c, 0x2894dfd5, 0xd6df7f09, 0xdfd6f6f2, 0x1a4a136a, 0xb86b647b, 0x20dc7c9a, 0x6ea5fe18, 0x5ca26fd4, 0xbd2da202, 0x5ecb6246, 0x16cf7832, 0x97b590ad, 0xe759fac8, 0xc7f8e7bf, 0xeb2b6fc1, 0x82598a59, 0xd5644c8c, 0xbb0d5075, 0x7dd2a7df, 0x8ee93cd3, 0xccd067f4, 0xd5f5d981, 0x77afdf37, 0x0012b6c3 };
const u32 bern_num_data423[151] = { 0xc46e734b, 0x15605f69, 0x11e0ea2d, 0x224a996e, 0x59abdf0c, 0x5e57b684, 0x62f4da3d, 0xe2dc41a1, 0x1b852303, 0x01252226, 0x3038eb2d, 0x111e1078, 0x10d0411e, 0x729194ef, 0x275253c6, 0x0cdc4619, 0xf9ce3c87, 0x3fd9d30b, 0x799039a8, 0x0f09388d, 0xcffcb931, 0x14af1a02, 0x102624b4, 0x916b57dc, 0xf63cd011, 0x63c4ae65, 0x5f550b5f, 0x4fee8b45, 0xe3310bb4, 0x92b550e1, 0x6e2796fe, 0x9c23ff82, 0x21e31fad, 0x07775bf1, 0x557ded92, 0x57ba49d4, 0xbf41f571, 0x36ea9fc5, 0x3f21d6b8, 0xb3f1d375, 0x6c990fa5, 0xe1006ae3, 0xc6b92f4c, 0x353edc9c, 0x2af84a4e, 0xde318d5c, 0xa98299cc, 0x84491f77, 0x43a46223, 0x327b11db, 0x6f9d0bc4, 0xc86fc4b4, 0xb61565a4, 0x57eed6c6, 0x2f07fd76, 0x39458a3e, 0x29464b86, 0x3b20a11b, 0xd4a0a9f5, 0xa306c508, 0x4d7c8a34, 0x54fc73e4, 0x101ab6e8, 0xc5639dfa, 0xb10daeb2, 0xd985f04b, 0xeb441058, 0x800f3698, 0x5c0c9838, 0x1d28c34a, 0x706ccc9a, 0x4bc8c16c, 0xf57c19ab, 0x06c9e844, 0xe33a120c, 0xd76179b2, 0x8b9a8db0, 0xc1a06374, 0x53b44898, 0x0620ab05, 0xa79bd8a3, 0xdbe82677, 0x7f240cee, 0x01cc7ccb, 0x82ec0a41, 0x8b93fa89, 0xce2ece40, 0x6b9a34b9, 0x3d237f5f, 0xc9916d6a, 0xd68074fc, 0x80d6014d, 0x7ed8a242, 0x4cc34419, 0x043f7895, 0x160992f7, 0xab8637e2, 0x7ddbe007, 0x2ce4d43e, 0x5439cb26, 0x84d74e90, 0x414acf8f, 0x514c2181, 0xa78fc742, 0x415a759a, 0x760e4909, 0x1ab89fc1, 0x94f5586c, 0xdd6ab60b, 0xa2a0b921, 0x248b13cf, 0xc61c2157, 0xef8dc08a, 0x420814c4, 0xb13a9de2, 0x73a10027, 0x7af23cec, 0x61f99685, 0x529d0ce4, 0x99eca30e, 0x740b0f22, 0x227c4e05, 0x59a71e99, 0xa1e7f0bb, 0x97653eaf, 0x0e27fed5, 0x2b3663a0, 0xfa2787a2, 0xb1d00c36, 0x233b7471, 0x137dd1de, 0x02a7dfb0, 0x5b93f12b, 0x2205aa6a, 0xe4a274ad, 0xd9766905, 0xb42ba9ee, 0x9f5b9419, 0x73dee151, 0x12fcdfba, 0xc8bdda8a, 0xe0b2c0f4, 0x753441b1, 0x756064bd, 0x459f3ac4, 0x47324650, 0xcfc15bfb, 0xe0c5d26a, 0x91305f4e, 0x415f6824, 0x00000001 };
const u32 bern_num_data424[151] = { 0xae5f2895, 0x81019274, 0x2dd3e4a5, 0x74dee414, 0x8affac93, 0xa19f6fbb, 0xb38fd46e, 0xee478979, 0x66bbe767, 0xb2ccdbec, 0x94947668, 0xf432498f, 0xbf8191c1, 0xe3f74656, 0x9bba7ba3, 0x4ba0a05d, 0x4c06e24a, 0x3ddfe1e7, 0x5a701e1d, 0x379f1869, 0x20ff8ba2, 0x64626e6c, 0x33e8d36a, 0x6201fa68, 0x8f4c09c3, 0x59aa8a1d, 0x0fa94593, 0x019bde9c, 0x00186fca, 0x7c44fbd1, 0xb9556fd5, 0xb2a3ae1b, 0xaef209cf, 0xe2654068, 0x1315c985, 0x53efebb3, 0x9f53e277, 0xc656d2a3, 0x145d00c9, 0xd670ac48, 0xf858ed3a, 0x03a0a32f, 0xf472397e, 0xf6a54fb0, 0x3eedbbb1, 0x6cbc0fa2, 0xc2c5e6be, 0xf139b3ed, 0xe8509aba, 0x4e94c87e, 0x4610de1f, 0x4749a2b6, 0x8b907b1f, 0x5b749391, 0xc4a0cbe4, 0x305c020d, 0x78a4fb48, 0x15958e54, 0xea30b5aa, 0x32164b2b, 0xca412778, 0xb6963fd9, 0x756affcb, 0x5d92b47e, 0x2f0d02c3, 0x13c9e331, 0x87c7fdf8, 0x3f2b29d7, 0x15a543b3, 0xda8e7ee1, 0x92edc6d3, 0x5f9f52ab, 0x3f2b1f0a, 0xfd43add9, 0x247d30c0, 0x56debdc0, 0x9bb3adc8, 0x2a85a5c2, 0x97a73b35, 0x9b5115c4, 0xd2ec2c69, 0x32755bf6, 0x0380ebad, 0xe40a226d, 0xd3869c7e, 0x2cc3d479, 0xa84d6abd, 0x3c304257, 0x81796825, 0x6945823f, 0x3a149269, 0xd8f66922, 0xa8a2199d, 0x3f25850b, 0x3dc63e89, 0x4ab2c17f, 0xafe32344, 0x417a6c64, 0x8ae0aac4, 0x3fde871e, 0xfefa9005, 0x7a22af20, 0x27a3d651, 0x07d4d9ea, 0xcde17f63, 0x8697a536, 0x4af69c42, 0x5d1ebd2c, 0xc1bda4ca, 0x3bea0886, 0xe5354dee, 0x4a1a74d8, 0x4e2be6e8, 0xb2730cc8, 0x70df7ec3, 0x3da75c36, 0xe7e4403f, 0x8ea5fcc4, 0x459b6342, 0xd201d330, 0xaa3da1cd, 0xd9cf9871, 0x9a9af9eb, 0x05ea0892, 0x7836d873, 0x6c392c2c, 0xd682e9bb, 0x9e087fd2, 0xce35078e, 0xcbba39a6, 0x9bfab23a, 0xf7b03195, 0x0598ea67, 0x7396e8c3, 0xcf813937, 0x156da3c6, 0xfb016246, 0x7c664be1, 0x539ceaf5, 0x31569aea, 0x7481163f, 0x5fd2597d, 0x4923016a, 0xf8a14b58, 0xbef79563, 0xb971c7c9, 0x6d0932cb, 0x3491a49b, 0xfc91dfd2, 0xc1074667, 0x0000001b };
const u32 bern_num_data425[152] = { 0x809e02df, 0xddcd458b, 0x297a928f, 0x9235ab52, 0xbfd43b9b, 0x345243d0, 0xf31c396c, 0xd5460853, 0x1d77f0bb, 0xfc6d54b5, 0x22ca86f2, 0x7d080ded, 0x7a611e40, 0xe5321dc7, 0xc93ea42e, 0x0ca224b0, 0xd38e3c17, 0xf7e18394, 0xfe63d3cc, 0x4f0b6285, 0x698f863e, 0xdd41f7ba, 0x5c3583fb, 0x8cbad938, 0xa823b2d0, 0x5861ab3c, 0x8569d0c7, 0x89679eea, 0x6b31edef, 0x07ef0944, 0xfb187656, 0x8140f13f, 0xf7f6a2ed, 0x3ee8b2f2, 0xe903e6f4, 0xe962cafd, 0x2af9b42f, 0x3d156f4d, 0xf40ccd44, 0x1a3ee80f, 0x5bac6b5f, 0x1dc810bd, 0xa8f8e7dc, 0xa355586d, 0x3f11c8c7, 0x5add6ca3, 0x025f76b6, 0xd4e9df23, 0xc331b15b, 0x2cd007d9, 0x9c516a7d, 0xa92014bc, 0x876b90ae, 0x954c0a7e, 0x1b2877b3, 0xe3bf6de1, 0xc9f4d2f4, 0xb0c97a32, 0x7b802010, 0x3ee6a806, 0x62655983, 0xdf62b6e0, 0x37a90046, 0x5d6f1831, 0x767fda15, 0x65c92aca, 0x7d7a827a, 0x6a526c23, 0x77d132cc, 0x16a76ea1, 0x25bb7019, 0x16cf1e5b, 0x705a795f, 0x6d6dcce4, 0xa34fcea9, 0x5541d145, 0x61cc09c6, 0xe5c49b4f, 0x2507b381, 0xe52c6636, 0xd216c48d, 0x19572189, 0x42077a0f, 0x2dd503b3, 0x215816b9, 0x1ac4bfe9, 0x7d1efe2f, 0x09290fa6, 0xa2573f66, 0x808c6446, 0xaa1f211d, 0xd45252ca, 0xce8d3bd9, 0xdf302e6b, 0xc413279d, 0xd7101193, 0x1ac38bee, 0xd4e4e0a3, 0xbe60c9aa, 0x5368cc8d, 0x516ea729, 0x795a1bba, 0xfc4b9b7f, 0x2fab75f0, 0x9dd0bff7, 0x784f122d, 0x46f271de, 0x3f1cafb1, 0x3d2fca1d, 0x440895c8, 0x589ecb82, 0x9d3fa57d, 0xe7765a76, 0x14809529, 0x072dd524, 0x9bdedfeb, 0x53b95a49, 0x1f836cc2, 0xa2bf458a, 0xf16fbd22, 0xf0c63e39, 0xcd8e454b, 0x9938d001, 0x71ee7813, 0x16b2e251, 0xf0525ae2, 0x73285905, 0x110bc6cd, 0x9b638104, 0x3f031216, 0x125bffd6, 0x44a9a02a, 0x53c610ed, 0x69bc1117, 0x763bae93, 0xc60c9d92, 0x5ddb76a2, 0xe121e0c0, 0x6366797b, 0x20078477, 0xdd292d49, 0x75953e3b, 0x44c7950c, 0x4f815cec, 0x91e6fcf3, 0xe864c28a, 0x0f39b2a2, 0x8eefadda, 0x63a1611e, 0x7510f1ad, 0x2ff8a0c5, 0x00000004 };
const u32 bern_num_data426[151] = { 0x877296b7, 0xba52a918, 0x2566a823, 0xc71ae8ef, 0x79e1572d, 0x93817325, 0x84c0ca1d, 0x26f54d1b, 0x0a2b3deb, 0x3a6f8d24, 0xcedcd708, 0x90bffb9e, 0xe6b0030b, 0x41973e55, 0xff567bd6, 0xad8db5fd, 0x3fd16573, 0x6d1374e0, 0xc6314642, 0xd25cfc07, 0x255b9b28, 0xd1722821, 0x2bb8eb2c, 0xd95a5e13, 0xd638c095, 0x031e88e6, 0xda099841, 0xa0cc000c, 0x62d79001, 0xe8e8cf01, 0x02528835, 0x3f9321b0, 0x6ca02a51, 0x2992b765, 0xc5c0a98e, 0x829d7122, 0x3daf1f4a, 0xb4b94311, 0x8ca14efd, 0x46e7159b, 0xb3132410, 0xa5590efd, 0xa37b5fb7, 0x1d48f4f7, 0xd0f8c2d1, 0xdf6ee42e, 0x8205cfbc, 0x533043d7, 0x672d5176, 0x126f8097, 0x9a8be8e6, 0xccf42ddb, 0xf1f16419, 0x1c25136b, 0x0e0f5022, 0x833091a4, 0xd52e5f95, 0x3dc668df, 0x726a5e92, 0xf9864dfd, 0xf41d803a, 0x4c62f635, 0xbb644cba, 0x8b5f3235, 0x218c1dc2, 0x655f5852, 0xdec9e872, 0x89ecdf98, 0xb75b74ba, 0x7bc572de, 0x5d08efd1, 0x31861042, 0x1162b8d6, 0x3462a677, 0x1b45741e, 0xbc7cd842, 0x2ef6d8b2, 0x98b2154c, 0x7a030799, 0x97935303, 0x127ba220, 0xe7ac75f1, 0x96ea47de, 0xe39a6ab3, 0xd002d904, 0xe19ea1be, 0x14ffb473, 0x61df279b, 0xa71778d3, 0xea2e07d1, 0xf38d7683, 0x0b8c8bde, 0x4fd3e2a4, 0x1cd7b856, 0x3df893ce, 0x3ede588d, 0xdb06fa8d, 0x26753822, 0x058f5193, 0x70e625ac, 0x69f414d1, 0x2b1cf9cb, 0xfe38c054, 0xfebab515, 0xcaee5dad, 0x2d90b5cd, 0x293c71bf, 0x442bd3d8, 0xc86d306e, 0x1fda13a6, 0x21eaa2d6, 0xdc802f26, 0xf8a81a5e, 0x8922c104, 0x923afdb1, 0x8d709553, 0x2748f527, 0xa3344abc, 0xe3f77927, 0x52102953, 0xd65bef88, 0x3fc41456, 0xe9854c7d, 0xe12854c3, 0xdefb2cbb, 0x8b70db17, 0xdf2a29a9, 0x6c0eaf87, 0x031c4e36, 0x99631194, 0x899b2813, 0x035ceb41, 0xd104aed4, 0x1991268a, 0x3cafa1a4, 0xafd837c0, 0x294e92a1, 0x0c313eeb, 0xddc6ee57, 0x90e6fb11, 0xb6dbed73, 0x0a57aff8, 0xd137f205, 0xbfc46d1a, 0xa9feb9a0, 0x7fbd26c9, 0x51b7934e, 0x398ed80c, 0xa88599f6, 0x739dd284, 0x32f6f988 };
const u32 bern_num_data427[152] = { 0x96b4b979, 0x537c71d7, 0x0138dc79, 0x03d9c19b, 0x16474756, 0x98bdf0eb, 0x5e0f1843, 0xa85a071a, 0xe2cd2b55, 0x0097725a, 0xea7c7c0f, 0xeb7e32f3, 0xa8c817b6, 0xc0a55505, 0x93d7490e, 0x9bf4aac7, 0xc68d8d1c, 0x4f072271, 0x4c262064, 0xdef68a9c, 0xf5461338, 0x41e083d7, 0x4e25039f, 0x10261861, 0x1bf21492, 0x92dd5674, 0x60c0228c, 0x21e8e1df, 0xe2c7646c, 0x9af02a1b, 0x150a44b2, 0xda287b57, 0x27487545, 0xcb9ae094, 0x7af61691, 0x2bdb12db, 0xe259b31b, 0x12091f55, 0xd283b145, 0xf1ff8f76, 0x56f6a0ae, 0x3cf3ad68, 0xa3535f8d, 0x370eef3f, 0xfde6b16f, 0xd79733d6, 0x270333a2, 0x6835b91d, 0x2f3d422c, 0x4224f234, 0x0f34a95c, 0x0b352ca1, 0xe333a5e5, 0x0bb3eddb, 0x997d56df, 0x3ce158da, 0x637f9ca4, 0x7e3826dc, 0xe36c4f01, 0xf2f55757, 0xa05a54fd, 0x2427e945, 0xca9ae498, 0x023067a4, 0x4496692e, 0x354611d9, 0xbfada0ef, 0x7aeec07d, 0xc9d8c912, 0x67282003, 0x7b15c606, 0x5ba57d79, 0x521440b7, 0x835d3dde, 0xf88bfbd5, 0xc28d098f, 0x406a67cb, 0xc8a6dc42, 0x82430e82, 0x4c392b90, 0x5a83d61f, 0xf50f3668, 0xbc8241c6, 0xa7e79633, 0xb2251e9e, 0xb5edc870, 0x25907568, 0x9d83241a, 0xd7b1d984, 0x17e01a2b, 0xbc3fb238, 0xf47c01a5, 0xd1a1ee9a, 0x8c1455c7, 0xe1c4d8e7, 0x1d9cf5b0, 0x1fa36628, 0xf7a011cb, 0x7946cf3c, 0xd4718823, 0xa21c87c5, 0x81a28820, 0x19401382, 0xb0da92f2, 0xecb66d5e, 0x52d08fa2, 0x812daaf7, 0x6c7e01a0, 0xaf99dbfe, 0x580343c6, 0x2e5f1667, 0x0fd47bed, 0x983bffdd, 0xeb6077c8, 0xb69e7734, 0x00213152, 0x3e8bdc64, 0x360cb46c, 0xf333509e, 0xdcc65801, 0x073cd98f, 0x1e171807, 0x6009bd27, 0xd4fa9f9c, 0x66798410, 0x758f7090, 0x8015e4d1, 0x0bf175a1, 0x40544031, 0xddf23957, 0x60d8e744, 0x1b23e8a1, 0x7ac08eec, 0xe763e211, 0xc1d4f57a, 0x73209108, 0x0319f4b7, 0x28b10fae, 0x2675a18a, 0xa8585868, 0xa4fba7c4, 0x9235931a, 0xdaa0a52e, 0x09123d95, 0x47390c98, 0x18cd6eca, 0xaad8cb92, 0x7818e58f, 0x591dc4b7, 0xc42d4ebd, 0x6dc3a40d, 0x00f15028 };
const u32 bern_num_data428[153] = { 0xc1047011, 0x8bf23be3, 0x6ed150de, 0xda6540a1, 0x457542ca, 0xd0741180, 0x33ad1841, 0xc149bc37, 0x1bb8cf8f, 0x54c14984, 0x9ead557c, 0x6de20764, 0xbaa747c4, 0x860cf1d9, 0x0178167f, 0xc7b8952b, 0xa6136aa9, 0x28b6d2df, 0xa7be84dd, 0x6ca445c7, 0xccf01c58, 0xf377431f, 0x74e3539b, 0x16a1c28f, 0x8b765ad8, 0xedf34c75, 0x88c0b0b9, 0x55ed4c33, 0xa0796484, 0xc843fad1, 0xeae525ea, 0x910a5c38, 0xad59ff16, 0x3997d67b, 0x6bde0058, 0x45349a5d, 0x9616f778, 0x6364c592, 0x31bc0202, 0x1373cbd9, 0x11297f51, 0x68d2e8e2, 0x29c615d5, 0xc85426ef, 0x16bf9089, 0x8e43f763, 0xd974174a, 0xe2b5d8cf, 0xac189c34, 0x9fba488a, 0x18d0e2d1, 0x71015200, 0x8a42c199, 0xfc2cd014, 0xf855bd23, 0x6ad6a923, 0x3e7c3564, 0xc55f4cf3, 0x6c8e9196, 0x0ab7d582, 0xf9a7a5ce, 0x195df0ea, 0x966c367c, 0x0dce281f, 0xfe79473d, 0xe00daddc, 0xec7451e0, 0x96e41dc4, 0x8fba3953, 0x8c41cbc1, 0x2fa9f5c3, 0x8a1113f9, 0x6117384d, 0xf8ddc7a0, 0x118e14a5, 0xffa45b24, 0x9f17e94d, 0x6295f8c0, 0xaf27705c, 0x75b45f3f, 0xf9aeb0cd, 0xa69fef15, 0x8bca6f77, 0xb96bb4bd, 0x5dc61cdf, 0x5a701ae8, 0x39c8b7cc, 0x2516335c, 0x5efe3d09, 0x72d31673, 0xc215fe7f, 0xef6171a3, 0x326a42b4, 0xd979ae42, 0x1bd31bee, 0x726de1ca, 0xe30fcfa9, 0xa98edf21, 0x27be6a65, 0xe00b7c53, 0x36eea377, 0x4ca3fe0e, 0x99ae6bb0, 0xbe981a66, 0x523f5d5f, 0x8cfc7496, 0x98c52d07, 0x7780a4e1, 0x97347591, 0xd90edb7f, 0x64df99c1, 0x39f6e76d, 0x8e4cce3d, 0x24c2c1f6, 0xbd8f6d5c, 0xf3b24694, 0xd3930b5b, 0x8938c6ad, 0x289eb210, 0x882a0a5a, 0xfc49823c, 0x4c5dea2a, 0x28a00bc8, 0x7cd35bb0, 0x7d99db95, 0xbe094d56, 0x7a2becca, 0x2b77ea5b, 0xba1ab709, 0x33c55acb, 0x8bc746f3, 0x89c9f103, 0x94d5ae4f, 0x58b12c0e, 0x026434c1, 0x373ac8f6, 0x99ff3386, 0xfffdbbff, 0xb23d8d8e, 0xb8b814e7, 0xf82b4629, 0x0bca0d8c, 0x55264b7d, 0x8053579b, 0xd0e809b3, 0xdd62fb0b, 0xad4fbea7, 0x89435483, 0x27ae10d7, 0xcd062dba, 0x31464095, 0x22a0dd12, 0x00b2c5a3 };
const u32 bern_num_data429[153] = { 0x1f00a709, 0x79459aaa, 0xa11931da, 0x7246cc44, 0x73b5015f, 0xd92240d6, 0xea53d7f3, 0x9cd0050d, 0xa3e2b7e6, 0x8d52e578, 0xa920db3f, 0xef4ab175, 0x2702205a, 0x19a2672c, 0x6a15a751, 0xeb612ce0, 0x2b9185e3, 0x34a6cad5, 0x758fe0b8, 0xbf421c8c, 0x65c16c36, 0x661c7806, 0x828ab4e3, 0xed3bf523, 0xb2e655ea, 0x4481bb20, 0x98fdd7fd, 0xaaa686b4, 0x076e94bd, 0x1e70241b, 0x08e10ce7, 0x7d656e54, 0xbeb6217e, 0x821777c3, 0x7f2123d8, 0x2a62ac94, 0x06a2edff, 0xbe3771fd, 0xf3778880, 0xfcbf58fc, 0x1240f373, 0x8ad22338, 0x0506202e, 0x60f0cffd, 0x95b721a6, 0x8e1691c0, 0x47f71e21, 0x1e4c0483, 0x4758aa3f, 0xfe46e71b, 0x9643f953, 0xfa76d524, 0x8ce4158a, 0xf154e4f2, 0x895b1cbe, 0x85d64b3d, 0xcfc0e85e, 0x5d55aec9, 0x1b4c1797, 0x19965a55, 0x4563e142, 0x3a510ff3, 0x6f28ab0b, 0x7f6df5eb, 0x5fa0a41f, 0xf1074c4f, 0xe50ca9d6, 0x52741b8d, 0xea6fe6a8, 0xa6307012, 0xca0ee86e, 0xb0c62d2c, 0x089d73d7, 0x85293fc6, 0x1842f7b5, 0xb34652aa, 0xac3597fd, 0xcbfbaade, 0x4af55b28, 0xc37e94ae, 0x70cf3ba9, 0x7df77792, 0x0e795a16, 0x2480d933, 0x27b60177, 0x1b68a381, 0xf2ca63a0, 0x60005713, 0x93cf1fc3, 0xc7b340b5, 0x2f34aa06, 0xfa1bb452, 0xd5b610ac, 0x21c5daf4, 0x00d8e32a, 0xe4aad346, 0x005c2289, 0xd2e9b64b, 0x32dabb12, 0xe41e357b, 0x8ecafd7b, 0x98af8f41, 0xaff6f302, 0x49c7ebdc, 0x0143b216, 0x17f7a448, 0x31f2e2e1, 0xc51f60d2, 0xf8361215, 0x59f7d979, 0x000159f4, 0xd3e4256c, 0x70cf344e, 0xcbd85f97, 0x36a1115c, 0xfd834402, 0x262b1806, 0x8ad0e148, 0xc5b79c2c, 0x4b9e703b, 0x162149dd, 0x06e104d2, 0xfdc793a7, 0x0a2d6f23, 0xac16be7c, 0x87487a41, 0x69d1eb5e, 0x575657a9, 0xc8df6b82, 0x57384b53, 0xddecba21, 0x6d900875, 0x6557c0a0, 0xd329ee9b, 0x91a01689, 0x250d48a6, 0xc8be1844, 0x03fd33d5, 0x288286e2, 0x398c3b41, 0x24e7abc5, 0x9ff27204, 0xe63cf7cf, 0x05c96f8c, 0xe2317cc0, 0xba7185d7, 0x1bd84b00, 0xc87aa660, 0x4ff602cb, 0xbbe3713d, 0x5b8dc0e7, 0x2c415a9b, 0x493529ed };
const u32 bern_num_data430[154] = { 0xfde2a7b9, 0x6061306c, 0x372e5add, 0x78d5b063, 0xdca27cbb, 0x047357b3, 0xe6ba4b52, 0xfdaa3999, 0xb4d27cdb, 0x9613126a, 0x01ab44e3, 0x52c0a53a, 0xe96d105f, 0xfbbeb09d, 0xf1db3983, 0x74d539b4, 0xb6143e2c, 0xb69fa9bc, 0x298893b5, 0x36015e1e, 0xfe3fe366, 0xb984710b, 0xbb8ef5a6, 0x03b9835c, 0x3b8d069c, 0xb1d451a5, 0x750bd6cc, 0x70519b4e, 0x3b758649, 0xb4e80b27, 0x7e8e4058, 0x54fc24d1, 0x4b3a7229, 0x9f5f876f, 0xa72534d3, 0x65661b5e, 0x5805f887, 0x51877163, 0x8a7e4557, 0x25e1d608, 0x3b8c84d5, 0x04e6cbb4, 0x7acaca6e, 0xfeaef553, 0x2dae08cf, 0x70aaf8dc, 0x165aa5a4, 0xc2f2f77d, 0xc971b3d7, 0x6e4ba5ee, 0xb55c3991, 0xa8fe7d54, 0x83a9a9e3, 0x4422587d, 0x97010d6c, 0xf515d9b7, 0xb0cda4ac, 0x034dccc1, 0x7b088710, 0x9d566471, 0xc3f00dea, 0x302f99f8, 0x1c2686ca, 0x64f21afe, 0x0a8c48fd, 0x10a276bd, 0x65aa165a, 0xab4b3f0b, 0x6fb44da3, 0x39510e09, 0x1a6c36af, 0xb40e9063, 0x246d26f1, 0x21159b09, 0x61025a55, 0x35bfa0e9, 0x48011e0e, 0x35e22d86, 0x248a6861, 0x7f81e7d9, 0x8cfb47fc, 0x7f6de923, 0xef725041, 0x0062a0da, 0xda1e3bd0, 0x93b7348c, 0x4c636acf, 0x0d872ecc, 0x3a3cce89, 0x4d6515d3, 0x13747216, 0x665cde4e, 0x48f5a6f3, 0x45030acb, 0xf915f75f, 0x23eb6c2e, 0xc9a5a67a, 0x96eee432, 0x7780b344, 0xeb07c3a0, 0x479299bb, 0xe56903ca, 0xbf0a273c, 0x25f518f4, 0x56feedb4, 0xa1396739, 0x1603e361, 0xb61b055d, 0x983a4cfc, 0x18ec6ef1, 0xb3d0aa70, 0x880af59e, 0x5a83173f, 0xcc18d8e4, 0x533d456e, 0xb7347d33, 0x3db6b7d7, 0x04117806, 0x35d359f8, 0x559b3699, 0x09f1755a, 0xda7cc116, 0x2b46819a, 0x8b745e05, 0x4f56cde8, 0x20112f4b, 0xb2ca6475, 0x07bce2c1, 0x894b49b6, 0xad98780b, 0x6a18a604, 0x7b94f667, 0xe6a265ee, 0xc153330e, 0x856f2ecb, 0x95d3f21a, 0x1a14bef6, 0x01415e59, 0x3d509c77, 0x8700e187, 0x0d370e4b, 0xdf7bf38f, 0xcb8287c0, 0x83c57446, 0xae53155b, 0x5192bb7f, 0x6cb6b16d, 0xb561b67c, 0x5ae84992, 0xd823bb1d, 0x2e3943c2, 0x3b02caba, 0x219f4f50, 0x00000001 };
const u32 bern_num_data431[155] = { 0x18d50d19, 0xb6102809, 0x0b07536a, 0x1bdce8d4, 0x5ba27d06, 0x8469f71f, 0x0b5220f6, 0xa7a3ebb1, 0xe5caf11e, 0x806b1ac5, 0x869de237, 0x9a5a4fa0, 0x51158816, 0x43c070e2, 0xc64b9ea9, 0x43549dd4, 0x53d446e4, 0x1f610d44, 0xc98c3ccf, 0x8c6dc28f, 0x8f3bbedb, 0x34b874d8, 0xdfa31f8d, 0x408ae1f2, 0x147723a3, 0x31998164, 0x7c27a245, 0xd9083430, 0x2b80b428, 0xeaa357e0, 0x526760a2, 0x020ded69, 0xa0324eb6, 0x8392c8a2, 0x450e0119, 0x1e899144, 0xfd34cde0, 0xca224211, 0xd7e8faa6, 0xe4558bbe, 0x09081270, 0x11b54245, 0xeee0f8a9, 0xbde98df1, 0x031254c9, 0x5e04f7e5, 0xb88e3b0c, 0xfa710ad9, 0x9ddafefc, 0x54d1fb1a, 0xf10de7d7, 0xf79e70a8, 0x3f206fec, 0x31c437a7, 0xf7b23905, 0x818d77c0, 0x61eaa292, 0x561a97a4, 0xef6b9481, 0x45498c7d, 0xa817269b, 0x7f2b80c7, 0x437c271d, 0x3caefa0a, 0x31d76045, 0x706885b6, 0x34107204, 0x3815e85f, 0x64ac615b, 0x4fe890be, 0x99a5a0fb, 0x9d543c32, 0x2922383d, 0x331ba92e, 0x0a27e2e5, 0xbb829fe5, 0xb6d7500a, 0x2d9eb8a1, 0x0e878891, 0x5e75d4a6, 0x54fe81a4, 0xda020148, 0x4fa1e2b2, 0x42bc39ba, 0xe39ffd73, 0x9f0a4a25, 0x4bf3bf08, 0x6d799191, 0xe49a7846, 0x81fa1379, 0xa8a105bb, 0xe2e63cf8, 0x94e6eea5, 0x082b7c98, 0xc1c42cf0, 0x3328a0b2, 0xb6ee31de, 0xce970b70, 0x8d835e77, 0x6bcf2a62, 0xf63f501e, 0xdcc227d1, 0x7aa391b9, 0x87a25005, 0xb5189764, 0xf6c44256, 0xe5318013, 0xda63abb6, 0x5ff5538e, 0x5451e9f1, 0xf396d3b0, 0x497651f6, 0xe983b6b8, 0xc8a9afdc, 0x2cffc58d, 0x3b6e2c51, 0x057631e7, 0x62e916e4, 0xd5a1c118, 0x23b259f8, 0x013daf1e, 0x298c61b4, 0x67f33a87, 0x59749a3b, 0x075c5b78, 0xa1f42ce7, 0xcbacd93f, 0x09676fc3, 0xeed1934e, 0x5cc6504d, 0x5d9ffe3e, 0xcba583f7, 0xabb49919, 0x981d42ec, 0x3a4e2088, 0xaed1cec2, 0x43fcf105, 0x1dae23d0, 0xba9334a4, 0x41dc52d4, 0xfa8a62c7, 0x50e9e719, 0x0d489927, 0x0616764d, 0xa7ad5df8, 0xf86b0b4b, 0x70374816, 0x06af5e5a, 0x123c3809, 0x4174df81, 0xa7aec23e, 0x6e9f0777, 0xce92eb65, 0xae3faa5b, 0x009fdb51 };
const u32 bern_num_data432[154] = { 0xe005783f, 0x3049de8a, 0xe4bdcef2, 0x807ec094, 0x0b55a6f3, 0x92fa5944, 0x2b8635c8, 0xf10d6f6b, 0xb9064d0a, 0xd26c767c, 0xf4c55bb3, 0x6ae71918, 0x4387a494, 0x56f60ce5, 0x00bb8637, 0x05b6dff0, 0x58c985c9, 0x2a676c5f, 0x2807e135, 0xa784940c, 0x89b50fa6, 0x6d65b3b6, 0xdf93e1fe, 0x6a1d2955, 0xb994f677, 0x51169bd6, 0x9ba78fd8, 0x3c9f4ff1, 0x435391ce, 0xdb3841b3, 0x3d8b194b, 0xacf93828, 0x1452d77a, 0xb0535829, 0x9ac0f409, 0x01f67540, 0xa340a0f2, 0x09d2a8d1, 0x84aae9af, 0x624a556b, 0x84dc3260, 0xf6d8bbd4, 0x3e48e1eb, 0xe2f55418, 0x6ddb1f30, 0xe9200a6c, 0x5e5e92ac, 0xe3889394, 0x302b6f72, 0xdd0570a1, 0x034299af, 0x4bd878b8, 0xb9f636c8, 0xeb03d8eb, 0x32a1b7a1, 0x6ab1ddba, 0x07c73597, 0xa68737ad, 0x75c1b1a7, 0xadd536a8, 0x392f82de, 0xf1e57413, 0xd6ed20d4, 0xa4ed808a, 0x49f2ab24, 0x0638ea63, 0x4d0cd7a7, 0x84093b79, 0x4c5f701d, 0xc68dedb6, 0xa4677ca9, 0x6df80eb3, 0x7a0d9bea, 0x39a009b2, 0x7fb5aa0b, 0x7aaa8d6c, 0x3826f05a, 0xff9edc47, 0xbf9b21ed, 0x81b633a0, 0x2e574f9a, 0xffce3032, 0x99da2bff, 0xd8c19a93, 0xd9c1ac26, 0x1c9e6c23, 0x98a61b10, 0x61a9234a, 0xa7a3b5b2, 0x2d966590, 0x2a72a1b8, 0xce281129, 0x6a05c820, 0xa5a7b0c2, 0x35f7e71e, 0xe49e8889, 0x87d28af4, 0xb7169626, 0xfafcecec, 0xa6aad6f3, 0xdc27a786, 0x7415215e, 0xa41f3ded, 0x30bb0618, 0x798e69fc, 0x7b30254e, 0xee3738af, 0x2c14f52a, 0x04fb13c8, 0xb9f8fd92, 0x9513d198, 0xef1af689, 0xd3b079fb, 0x095e83fe, 0xb2635dfe, 0xc2b09ae4, 0x6b6bf15c, 0x690301c4, 0x7e6d2a26, 0xda243e85, 0x63610d56, 0x4e995904, 0x96ce4ee0, 0x84c801bd, 0xed1b5ed0, 0x916f2e92, 0xaf08a406, 0x4f882f3e, 0x4dc54c28, 0x2cb3a9dc, 0xcce91156, 0x5bf3b5ac, 0xe9ef2fe4, 0x68941769, 0xc88e57db, 0xf26b1e7d, 0xf9ed202d, 0xd56ea1bc, 0xba880817, 0xeadbcb7a, 0xa8279896, 0x42383465, 0x9af47ac3, 0x9823c370, 0xc53a951f, 0xeadb17a8, 0x8700f5f8, 0x8f5c53d4, 0x56feb206, 0xa9a2ccf7, 0x5b63904b, 0x65283226, 0xe42c73fc, 0x00072b2f };
const u32 bern_num_data433[155] = { 0xe32614f5, 0xbc7317d9, 0x4f07647e, 0x764dd99c, 0x4d1081a8, 0xfee40f06, 0x446bcd44, 0xc80731a4, 0xbb53f6a9, 0x20a913ad, 0x3d3c8a87, 0x531a82e5, 0xb6056f6d, 0xa07905d0, 0x21954964, 0xacf79aa0, 0xd91298e8, 0x352cb899, 0x33bf81cf, 0xed18e1c0, 0xc3cd1a21, 0x8737f300, 0xe886dd4a, 0xcdd25987, 0x3d9f8f92, 0x0ba15ec4, 0x11ef72f4, 0xbd96d02b, 0xb0344048, 0x06a45979, 0xdad3f47c, 0x9324c32e, 0x59284428, 0x5bf98d63, 0x0f0abacb, 0x0c4aeccc, 0xf8583ced, 0x73e400e6, 0xf6bf28e0, 0x1aee2112, 0xcd82d72d, 0x437e0064, 0x721fd006, 0xb8a0f9a9, 0xdd15782f, 0x21e55b24, 0x8821a040, 0x6bc71f33, 0x5a80d46a, 0xa9190fee, 0x0b1bc42c, 0x17718a8d, 0x2760a38b, 0xaf4096e1, 0x2903ea56, 0x585b13e6, 0x9e5f7fe0, 0x870a01f1, 0x074834b3, 0x10025861, 0xe33b1ad1, 0xf2fe0a04, 0x132a0360, 0x44452409, 0x9fb0b9fc, 0x2d34f9b9, 0x1b0ae98d, 0xa48f058c, 0x5eaf0890, 0x92a72941, 0x8a90fc62, 0xa3f199ff, 0xcdc29656, 0x5fd2a552, 0x7f54e7af, 0x221ea99a, 0x44b7881b, 0xe7dd2cbc, 0xfcb365df, 0x23fffd5c, 0x739b6a1f, 0x821f4e13, 0x0f474dbc, 0x52f55292, 0x752d9854, 0xd22932ec, 0x68ee5a41, 0x6521cefc, 0x6e24297c, 0x644e0180, 0x3fd49569, 0x31496d13, 0x61c303ae, 0xcb12aad1, 0x9eda218a, 0x8a172a02, 0x4714ef1c, 0xfbebde76, 0x40117795, 0x4d602d92, 0x6ac2eb69, 0x5362d9ff, 0xf45e49ff, 0x751488c7, 0xfd6fd934, 0xf51919bb, 0x27b7ae2f, 0x99be0128, 0xc68c40f8, 0x24ada1ba, 0x22cf7145, 0x6dd49b46, 0x5ac9eab7, 0xa94f51bb, 0xc87881c7, 0x0b724acf, 0xc4593b3e, 0x41abaf08, 0xe182a12e, 0x7d12c0cb, 0x83642c5e, 0xdefc5cc7, 0x877e533c, 0x0f0326c7, 0x2b014423, 0x703a660d, 0x2217f7f3, 0xe49bfe44, 0x080ce730, 0xa11f3068, 0x00d53fb1, 0x4069f655, 0x20cb1678, 0x358e04b0, 0x0ab1a1fc, 0x7bce5c6c, 0x0d205617, 0x13c4bb4a, 0x865a3ee5, 0xd891cd1a, 0x75551bc9, 0x135674b0, 0x3d317c73, 0xd4c1865f, 0x7d6af6c3, 0x33d5fa99, 0x88a68543, 0x42c0a17b, 0xadc019a1, 0x06c3e176, 0x81fb4e81, 0xcc01f01e, 0xbbfbd862, 0x592a552e, 0x0000012e };
const u32 bern_num_data434[156] = { 0xe14ef7f7, 0x6b04ee52, 0xee8e9eb4, 0x51a97c0e, 0x2228d06d, 0x5243238d, 0xbf56391c, 0xf95f0cb0, 0x42c25e90, 0xcee97a9a, 0x1457fb98, 0x2867f5f5, 0xda14a136, 0x15c01aed, 0x23371eae, 0xc00a397a, 0x3d19cb51, 0xf27e66f5, 0xe5640f58, 0x3c965fdf, 0x79fe8004, 0xfd145b64, 0x0340a6a8, 0x7807215e, 0xee1d8634, 0xb7c8e255, 0xdc92d33e, 0x823f55d4, 0x6b90835c, 0x3e49fef8, 0x8b238eef, 0x2cf59099, 0x66dffe6a, 0x79225bc3, 0xd35947a6, 0xaedeecff, 0x498c7372, 0xc5b5e755, 0xa537325f, 0x13e90678, 0xf99ea79c, 0xb0789dbc, 0x28768dba, 0xe6e28878, 0x57b66a54, 0xf008bd55, 0xd13f649b, 0x62a167f0, 0x63f6851a, 0x9c4ccca1, 0x7e058e2b, 0x4f650448, 0xb10c2d68, 0x939846f4, 0x4c63c706, 0x86892d8b, 0x3300d810, 0x6edd5800, 0xdd220b76, 0x738b633c, 0x59ca3263, 0x4d39dae0, 0x752306ff, 0xd8efaf9c, 0x1a099083, 0xe3a42627, 0xedabe8f4, 0x403592bb, 0x0e3a4c0a, 0x0ae6c334, 0x83c047f9, 0x54f405cd, 0x4358c482, 0xf56f0761, 0x8f0f7ceb, 0x8f3414b9, 0x943f17cd, 0xf8fe335d, 0x31e6092e, 0x3310185a, 0x4660c83f, 0xcac6e37b, 0xbb81ad0d, 0x053188d1, 0xd2fe960d, 0x62b5a134, 0x4a259544, 0x0d92e593, 0x724bf8a2, 0x496b99e7, 0x9202c6df, 0xda7aa377, 0x0e7d4620, 0x641fe587, 0xb10a856e, 0xd88bb6db, 0xa66d5060, 0x74736796, 0x18d1db7b, 0xbfc49d95, 0x564807b6, 0x392fdaf2, 0x10233aee, 0x112989f8, 0x28b6e806, 0x18632064, 0xd8c8f07c, 0x93081d2c, 0x6f054295, 0xafc68ab0, 0x74f48355, 0x8dc83910, 0xba347291, 0x4eb1e4ef, 0x88ff44a7, 0x1154da58, 0x89978709, 0x215b7472, 0xcd191d87, 0x747a6583, 0xf700dc2f, 0xb50f0c5f, 0x117b8281, 0xe9ef8842, 0x81b40d0a, 0x5020ac55, 0xf2b0ed15, 0x0b06fde8, 0xeed9f19e, 0xcfbb1829, 0xac071599, 0x1186e4cc, 0x0504de98, 0xdfd50b73, 0xad5b4a2d, 0xe0636c48, 0xeec2f6ab, 0x135f387d, 0xe78d0ff6, 0x553dfe3c, 0xc6ee7460, 0x55901b88, 0x9325e164, 0xca168a64, 0xde33ab85, 0x2d58544d, 0x9848a443, 0xde334dfe, 0xbe54793f, 0xd8d53fa9, 0xb8cfb4f9, 0x0ea5be54, 0x23b996c2, 0x788dcefc, 0x4f331246, 0x00000001 };
const u32 bern_num_data435[155] = { 0xee615441, 0xbc40f903, 0x7d61c851, 0x659a1e4e, 0x75658b5f, 0xc3b144ba, 0xd8ecaf95, 0xda7ee48f, 0x786c9f0c, 0x1448cb5f, 0x21e10d34, 0x3bcf44fc, 0x2a37d76d, 0xdb223959, 0xe965993c, 0x9475ce3b, 0x2a4a67a6, 0x801a516c, 0x86fafc6b, 0xdca9756b, 0x11d11cfe, 0xb8546399, 0xb5d5d051, 0xc01eafa3, 0x746f53e5, 0xe85e21f7, 0xdf0a3966, 0xf369c968, 0xb4313c8c, 0x76166fa1, 0x84627d8e, 0x8ab53481, 0x7bedc1e4, 0xeef0682b, 0x640b4771, 0xd3a2fbe1, 0x91c3530f, 0x88c08340, 0xa508c643, 0x84816d4d, 0x65b4e7c4, 0xbcc4ddbc, 0xc047c663, 0x0fb2d8c0, 0x40ebe497, 0xf9a7e63d, 0x91d6b1bd, 0x90101cfb, 0xda9f2db9, 0x82df4558, 0xb405ab6f, 0x1813adcf, 0x92015d32, 0x3c6016a7, 0x1f063526, 0x4badff1c, 0x3becbff1, 0xc390f571, 0x177e8b52, 0x1e1c9721, 0xb67e776a, 0xa5ebd63c, 0x0995dd99, 0x1c3cde09, 0x9c7d750e, 0x37fa2fad, 0x34e0aa47, 0xf174863a, 0x97ab3948, 0xbd330994, 0x919451f3, 0xa6774b58, 0x60bdb6d0, 0xa9432e3b, 0x1a890899, 0xece019b9, 0x933ebc9c, 0xc3ae90da, 0x818a6b58, 0x8a1164e9, 0xee86b8be, 0x5e7e5918, 0x5ec2d508, 0xf049d198, 0xf4116204, 0x05832082, 0xadd607c6, 0xbb0e3e35, 0x9ff58f7f, 0x394915b8, 0x6591f296, 0x78646f26, 0x8c8f9565, 0xaae820ef, 0xac2a2c6a, 0x3dd746e2, 0xdb3c409d, 0x1ca5a738, 0xb74b0e35, 0xa835b34d, 0x05a4bf8d, 0x99996788, 0xb455371d, 0xb8abe4b5, 0xee6d320a, 0x8eb4dae3, 0x15790049, 0x1bb70c69, 0x373f36a1, 0x3e5b0470, 0xb4feb4dc, 0x788b0b93, 0xf7ce61e5, 0x090a13cf, 0x81fb3646, 0xcf6234ff, 0xb91265cc, 0xc78be2aa, 0x1d0abfe0, 0x2a86a2e1, 0x684d25d2, 0x66a02a4b, 0x9d1a3621, 0xc2a0e225, 0xe0d72a29, 0x24d7605b, 0x618ba28e, 0x946c0924, 0x2eed4f17, 0x75a3845c, 0xfc9ba354, 0x6c98ba6b, 0xda179d32, 0x86d6bcee, 0x96fac121, 0x072bc36c, 0xc5246963, 0xc7ac5675, 0x6e5e63ac, 0x34becb1b, 0x30bfaf03, 0xd69b5367, 0x32ef352f, 0xb9a9ad17, 0x8f674424, 0x7a3874ee, 0x61af92d2, 0x1ec819aa, 0xfc4e2219, 0xcfab2451, 0xc9e76eaf, 0xa642d8f8, 0x1c4c0888, 0x94ed81ea, 0xe4f3a158 };
const u32 bern_num_data436[156] = { 0x6e800861, 0xb0e1b869, 0x2da7b376, 0xd3927bf2, 0x63019777, 0xcded1c96, 0x78b6f562, 0x8bc594f4, 0x440a7fb6, 0x08656564, 0xdd1b4b25, 0x730ff53c, 0x3d0ba579, 0x29d93a05, 0x90eb6620, 0x09cdb236, 0xab8ec4de, 0x5117454d, 0x9f98ffa1, 0x32381d83, 0xff5dce01, 0x82df5063, 0x21e7d02b, 0xa69bda6d, 0x53480deb, 0x4b810a5a, 0x9bc8b637, 0xa61071bd, 0x2a81da3c, 0xd614740b, 0xff49f35a, 0xf3b38329, 0x6e4742b3, 0xed017745, 0xe884c205, 0xb90a147c, 0x1a040342, 0x54f52b49, 0xf76ca137, 0x83390eda, 0x1af30772, 0xdee1461d, 0xf6352146, 0x2f0d11dc, 0x556a61db, 0x205cd114, 0xe96d27bd, 0xce171e0a, 0x6d560a3a, 0x7334859e, 0x2ddcb7f3, 0x51fe7821, 0x6e92bedf, 0x2dcc0621, 0x7bdf6d55, 0x55cf3990, 0xb85da1ac, 0x34afd16c, 0xcfde59fa, 0x6e2ad565, 0x13526538, 0xc90ac6ea, 0xf6fd3ad3, 0x22e7f124, 0xdc553067, 0x79762691, 0x1a39ed24, 0xbe1dc2fe, 0xc9fcd8d1, 0x5c19718a, 0x284abd6c, 0x218c724a, 0x67f0cbf6, 0xbb039790, 0x344c4ee4, 0x0e0d146b, 0xbc71f18a, 0xebd98314, 0x0f380f36, 0x22742c59, 0x556c19d9, 0x8143455c, 0x35325128, 0xf5088a1b, 0x38d97a79, 0x44dd81d4, 0x2fff21ef, 0xbcc04e31, 0x395b253f, 0x27f76be1, 0x819662bb, 0xf4002080, 0x6b025319, 0xf0ff4d53, 0xe45927dc, 0x9f28abac, 0x594fa071, 0x14032204, 0xa6ee3850, 0x34b96e0e, 0xcc9ce747, 0xca488bd5, 0x2b528142, 0xeeaf9fdc, 0x2b339cbf, 0x99c84319, 0x6fbddf62, 0xb11139bf, 0x7738a26b, 0x6ec1521e, 0x18c993d3, 0xae10e682, 0x328cc0ad, 0xea78f921, 0xc73dd02d, 0x8b197a5b, 0x5ed5de6c, 0xc043a7b2, 0x92f37481, 0x16eac154, 0x4c8fa6d4, 0xb2171a84, 0xcf10159f, 0x78380de8, 0xf64a9127, 0xb892ac6d, 0xe9f420ee, 0x16e028f0, 0x0bb0161e, 0xa4666880, 0x0cbb5f0b, 0xe16d1f8b, 0x6d2bbcaa, 0xc3a89533, 0x5e0db815, 0x50d7273c, 0xae2abaf8, 0xc94a2189, 0xf6fa49e6, 0x532f8e50, 0xbe7a9c7e, 0x2dd772f8, 0x3324347f, 0xbc935842, 0x58100932, 0xa7301b06, 0xb859eac9, 0x07ab1f9c, 0x16e6e239, 0xd77094bd, 0x7e65de47, 0x855fe600, 0xde33e7af, 0x9b6056f0, 0x28d66c66, 0x00027aaf };
const u32 bern_num_data437[157] = { 0xdc793975, 0x5926a9df, 0x6bdd3bfe, 0x7e344628, 0x407591cb, 0xc0163705, 0xebecbec3, 0x17b298d7, 0x0196fc7b, 0xe35631f7, 0x5012b1c4, 0xb26577bf, 0x94d8553f, 0xd890672b, 0x98152b87, 0x55b04222, 0x0126496f, 0x2c0cbbaa, 0x22c20153, 0xdf392873, 0xd907184d, 0xf8feb9b8, 0x4a356a9a, 0x6e192e50, 0x6ada07b9, 0x52bc0b12, 0x56a6e0f0, 0x9295691f, 0xb0cb9aa9, 0x5d29507d, 0x103aec69, 0x178b06f8, 0x958a2cfd, 0x6d1df93c, 0x29f61d9a, 0xfdf3fb3f, 0x0d6756c4, 0x5938d597, 0xabe59fb7, 0x58a5ceff, 0xa827cc1e, 0xf1998901, 0x9f709b1e, 0x25b06572, 0xfc60e0f8, 0x6d4f6447, 0x519a47af, 0xdd2f19af, 0xfb283950, 0x16f8bc5e, 0x05935be0, 0x7b614f2e, 0x507f1236, 0x77ddf1dc, 0x028b67b1, 0xb20fcf47, 0x18b7c34f, 0x1e86e4f1, 0x2ccb922c, 0x7b1fd981, 0x35cbe692, 0x69f9ad70, 0x81718b13, 0xb5d6042c, 0x8e6689f8, 0x7b3be126, 0x08ab5381, 0xd78942eb, 0x3dc3c32d, 0xc0533ee3, 0x9dc14afb, 0x546644c4, 0xf1eec66a, 0x0a706fac, 0x6e7d25c5, 0x49206af1, 0x38b37c99, 0x75d5b316, 0x6acf4457, 0x04150e64, 0xfb483084, 0x58adb335, 0xc2890af6, 0x90582ba7, 0xd39af644, 0x3c53feb3, 0xa1fe0fd6, 0x98a8884b, 0x88a38cf8, 0x4b25d838, 0xd8a6dea9, 0x71613bed, 0x19652fe4, 0x702acafe, 0x6a0719b3, 0xc5e9d98f, 0x270824be, 0x65015237, 0x0c9d16df, 0xdb34be2a, 0xebe5d99d, 0x6123862e, 0x65b8caf5, 0xa5430fb4, 0x24a2db4e, 0xe17de1c6, 0xbcfcf7cf, 0x648f8c7f, 0x9e5fbe14, 0xbe226516, 0xd25c8abb, 0x4f58aaad, 0x16949594, 0x14bcaf6a, 0x6a07216f, 0x52e9b7ae, 0x2396a195, 0xd76e7010, 0x3792479a, 0x0d92d23f, 0x47ce75e1, 0x13201f6e, 0x5cbe037c, 0x2e029a98, 0xcac37b58, 0x4210ed31, 0x5144bde1, 0x9f3e9750, 0x0023bd52, 0xc2067c19, 0x72ae0a50, 0x8b1f6022, 0xa87c06c3, 0xcc2a6ca0, 0x6a6679ec, 0x02807f1d, 0x4eff4a23, 0xe063b167, 0x3fc9337d, 0x1555ceef, 0x8dcf02db, 0x2a4e1684, 0x31738b1f, 0xc5e62e58, 0x2c76cb93, 0x96e2bab4, 0x0f55b57d, 0x71ce3080, 0x4dd547c9, 0x08ebfddd, 0xbd688c69, 0xa502e3bb, 0x458d96f1, 0x2538a6f2, 0x035c9174, 0x2596ad20, 0x2fcf457e };
const u32 bern_num_data438[157] = { 0xabbd0c47, 0xef834e93, 0x99aae1b8, 0x5dd09922, 0x1c5de27d, 0xcca448e4, 0xb5581a2d, 0x1053e283, 0x95e398b4, 0x38e59601, 0x4bea75e4, 0x6a4ba9f2, 0xc1c523e9, 0xb0b8bc1e, 0x7989321e, 0x51f660b7, 0x7e0e253f, 0x444dab9e, 0xaf373084, 0x5e016e19, 0x813933e5, 0x6c2af359, 0x2b22297b, 0x2a611816, 0xf9d83816, 0xb0e08b93, 0x56572e05, 0xceec8d23, 0x587fc635, 0x01cf9912, 0x340c815b, 0x44450b67, 0x09dfe910, 0xe813779e, 0x875f52ab, 0xcc863cae, 0xaeda518c, 0x339952d9, 0x0efab22c, 0x6628810a, 0x8f7e227d, 0x0725ad12, 0xe2fdb46d, 0x2f1fcf9f, 0xa058226d, 0x9d68a9c0, 0x808cb734, 0x9b4e5ac3, 0xaf62b3e7, 0x0b46adaa, 0xa5f07c88, 0xd81ad1ff, 0x6a21f6eb, 0x988ad74e, 0x0aec922b, 0x2e8d17af, 0x5b83a56f, 0xcffb05ae, 0x599758a0, 0x15e076f9, 0x45daf5a3, 0xf9bde97a, 0x6e9dd8dc, 0xeac562ed, 0x0a034dd3, 0x86cb7f76, 0xc269ac7e, 0xdc9e7406, 0x80ef5592, 0xf12b84e4, 0x83ef2ed7, 0x19b68f9a, 0xb5f03118, 0xb56824d3, 0xb399b90a, 0x375d91bf, 0x63b59695, 0xf24ed4a0, 0x2dc61924, 0xbafb302c, 0xcef8e5c8, 0x0b6ee793, 0x9f6e5882, 0x093e06c6, 0x33197741, 0x6123d2c0, 0xe1c04c17, 0x7a918549, 0x7c1c1572, 0xbe0d11ed, 0xb393e4b2, 0xa405d985, 0xb528d8c4, 0x52da4cbc, 0xa66e3226, 0x3c76eb3f, 0xd5df43fe, 0xd38b142a, 0x57795fa1, 0x6ca4a640, 0x0ef7fcb8, 0xc46d161f, 0x055a26c4, 0x6e6edb83, 0xffae1384, 0x1e8cbe04, 0x1a63acf0, 0x26448546, 0x0f082ace, 0x3bd0482c, 0xe112fe06, 0x90a66f34, 0x89af2664, 0x7208f59f, 0xd36bd46d, 0x2282984e, 0xc5e1762d, 0xf0ae230e, 0xa1f41ef2, 0x2eb72fb7, 0x8902ab0c, 0x412a9700, 0x47931278, 0xcff180cf, 0xaf29fa7a, 0xcb7dc751, 0xd86c5ed6, 0x369fd80a, 0xb680d1d6, 0xf7b4027e, 0xb1e1e2dc, 0xbe338b8c, 0x30819588, 0x160b940b, 0x898493c1, 0xf4275d30, 0x8823e525, 0x1cf25afb, 0x3c7c52a3, 0x21df5257, 0x7c74d96e, 0xb7d829de, 0x0fdac511, 0xf1b1b54e, 0x53ff953b, 0x8d29ef21, 0x83663f4a, 0x5b8cc04d, 0xb6d8de28, 0xc1f9bd10, 0xd3e35f95, 0x065bfb77, 0x85d8450f, 0x0d34e7ab, 0xa9d94ab6, 0xceea7e1a, 0x00000130 };
const u32 bern_num_data439[158] = { 0x98c8954d, 0x2998b890, 0x0c299b27, 0xf67ad6f7, 0xd067ff97, 0x5d20855e, 0x81342423, 0xd6ae7a80, 0xf1909bac, 0xb3e9052f, 0xddf41b6b, 0x22912c86, 0x590b3f5b, 0x80757078, 0x07ab1da2, 0x5228fede, 0x85a65608, 0xb3f2296e, 0x09d9a2a6, 0xe412c792, 0xfd9f39dc, 0xd66e8ac9, 0x841223ac, 0x918bf2a6, 0xc26cbd33, 0x9fb3b97e, 0xe6242661, 0x2724330e, 0x25144f67, 0x7889c5c0, 0xc338be4f, 0xff25e9cc, 0x88cc4fca, 0xceaca4cf, 0xa9aec858, 0x0c451b58, 0x6709d16e, 0xf6a602e2, 0x1c89a238, 0x65622f51, 0x61c51c38, 0x42392b4c, 0x03273211, 0xc0d71269, 0xea16f5cc, 0x7e0ce09e, 0x39303f2a, 0x8f59830f, 0x43e5ca82, 0xa5a8cc2d, 0xeef0ddb0, 0x200bd913, 0xa0efa4a0, 0x7335909c, 0x5f5610b2, 0xd2ccc272, 0x0d6b941a, 0xc78e77e2, 0x1cd8f6e8, 0x8a2321e8, 0xc5416882, 0xa32db794, 0x5b08c6b2, 0xce2ed3db, 0xa72e1707, 0x4a6fb7ce, 0x6e060b43, 0x1b89312d, 0xf3161984, 0xd9a6613a, 0xb8e976bc, 0xd99b6941, 0xa34f0437, 0x50ffea69, 0xed093d2b, 0x574fa105, 0x6a9ec464, 0xd119deb0, 0x7de7416a, 0xe284df03, 0x17f62b96, 0x1da468c1, 0x560d4f9c, 0x6c233f77, 0x3ddd540f, 0x8a4b3f9b, 0xe393c330, 0xd23d3659, 0xc1631af8, 0xaa9ec5df, 0xdf1fe0a5, 0x8d7bf881, 0xfeb9b7ae, 0x37ac6bef, 0x6fc61d80, 0x5de34b26, 0xb26102a3, 0x24166792, 0x0fdbdd4a, 0xb16798d6, 0xdfb66cad, 0x078d7cc0, 0x77789c71, 0xe0d704f3, 0xc056e530, 0x5f265e9e, 0x50251c04, 0xe43a6608, 0x5318641c, 0xf4a6cdcb, 0x4b92d19f, 0x50d50303, 0x9a4aad3b, 0xe42cd7ab, 0xf5a1fa61, 0x12981205, 0xa0f81de0, 0x8f362cbc, 0xbae6a8f0, 0xb42a90fd, 0x4f84e6eb, 0x44bfb5c1, 0xc9526c12, 0xac2ecbb3, 0x5eed7ce5, 0xdac48a4a, 0x37412d6c, 0x6a2fedc5, 0x4961042a, 0x30bb489c, 0xdc8d7db6, 0x944b3723, 0xec950192, 0x8020a293, 0xcebb803a, 0x7912c96e, 0x96b372fb, 0xcf8a92fb, 0xbd64d069, 0x687abf11, 0xdb73fa83, 0xd0e15a39, 0x4370f6bf, 0x865ed784, 0x2896d4e8, 0xa51020c8, 0x9c690296, 0x062f3f78, 0x68d6a45f, 0x11e65bb1, 0xc24f4bfe, 0x870ce995, 0xe97728ab, 0x887cef2c, 0x5c7d80c7, 0x7f26aa61, 0x79541fbd, 0x05badb90 };
const u32 bern_num_data440[159] = { 0xbb2ba475, 0x8b74bcbf, 0x35b2777c, 0xdee804bd, 0x60d075d4, 0xda4e6916, 0xf9c915ff, 0x490cc9e5, 0x9ec3b918, 0xb3e51de3, 0x2ab09884, 0xd69def9c, 0x6cb4f964, 0xab522012, 0xa1d1e7db, 0x3bc65483, 0xfa7070a9, 0xc45ae443, 0xe2e0600e, 0x2a2eed7d, 0x90a1bf94, 0xaab9f202, 0xbcb292d7, 0x1f8510c8, 0xcc0b207c, 0xb11c4e8b, 0x0c836bd1, 0x3143d7b1, 0x6fb22d58, 0x5e38debc, 0x54196553, 0x28e87ee6, 0x6dc31ad2, 0x416af7ee, 0x6b1f06c9, 0xa03aaf1a, 0x241bf5fd, 0x5223ce78, 0x6f4a2f0f, 0x850b0398, 0x00c5648b, 0x9c7d2420, 0x1abaa637, 0x335fbf21, 0x0342ec5a, 0x5d7e088e, 0x456a7016, 0x40127cbb, 0xd22871b3, 0x5328dbcc, 0x59b2f535, 0x23ea1863, 0x8348cf18, 0x4d5027f7, 0x03f0da58, 0x3feb7209, 0x4ca4f0cd, 0x4255d8bb, 0x43d47b29, 0x9405e77a, 0x7634a24d, 0x7e3aac63, 0x59ec766e, 0x422ca035, 0xe9772e9e, 0xbabfe99b, 0x184fc96a, 0xcd45a7a3, 0xa94007d7, 0xa4a8f0e4, 0xd76460e7, 0x631ad720, 0x725da3f5, 0xded0807e, 0xc82d1118, 0x0adce29a, 0x2972d0ee, 0x0772ef89, 0xbe8acd48, 0xbf812da9, 0x9115fcfe, 0x09925456, 0xfab75420, 0xfc2e4641, 0x367affae, 0x32d01d30, 0xe97d8729, 0xd4c0b4b9, 0x0587f984, 0xb62c824c, 0x2a948bb9, 0x0f0d8896, 0xb18326f7, 0x4255cee2, 0x6dcf5522, 0x88d7b902, 0x33608586, 0x0282adcf, 0xa4a86a91, 0x68a33e8a, 0x8aaf47fc, 0x190e5e91, 0xae5ddab4, 0xc4d658a1, 0xdcafec5a, 0xd827b10e, 0x9a65546e, 0x0fb9c474, 0xc940e733, 0xc528af75, 0x2c5ac2e9, 0xfc97a202, 0x639cc162, 0x2b5a07eb, 0x0c0fed89, 0x27c62e48, 0x28e8f521, 0x2267c1ea, 0x63a065b8, 0xdb201ac5, 0xb6d4300d, 0xd18238cd, 0x47354359, 0xee3d643d, 0x233cfb02, 0xb46b65bd, 0xe745c51a, 0x1dd92ed2, 0x9134d493, 0x6d0211ec, 0x38ee5168, 0xb8314a44, 0x892f168d, 0x59a41661, 0xce0ffc70, 0xdeb0103f, 0x5d81ea3a, 0x626c3ddd, 0x793397f2, 0x12f796e5, 0xf5f8f667, 0xd8af5d07, 0x527d4592, 0x1324e37f, 0xbbd4c561, 0xb80f77c7, 0xfa463b41, 0xb2e66b6d, 0x78f23309, 0x696fa00f, 0xfdeb013d, 0xc26ab912, 0x3e74317d, 0x1d4c1af8, 0xf3a516d7, 0xc02382af, 0xc5d90dd0, 0x163b6fad, 0x00000004 };
const u32 bern_num_data441[159] = { 0x80e6bb1f, 0x8706ae41, 0xb97be382, 0x0532addd, 0x3ae26866, 0xdd44029f, 0x59be05ff, 0x2c053df5, 0x18cd72ab, 0xfed55488, 0xef056735, 0x4fad4b19, 0xc23ef2e9, 0x26608e9e, 0xe0c58ff8, 0xf0abd225, 0x31e228e5, 0x3c1258bb, 0xb17e8e8d, 0xbe828c79, 0x988c37b2, 0x7b65839c, 0xb8f43360, 0xf85fc58f, 0x9c9006c3, 0xfb158852, 0x13fa9fbf, 0xbefdc69c, 0xfc9bacdf, 0x24044cf2, 0x0dc902df, 0xe07f6e1a, 0x2e01a5e9, 0x9d38cd1a, 0x48907901, 0xf2dcb064, 0x99eb81ac, 0x7bd34440, 0x593cc3db, 0x42208839, 0x51fb886f, 0x3ea0e0bd, 0x74df91fe, 0x4dbcfad1, 0x31eff3d7, 0x2ad3449c, 0x91abb478, 0xc0fb6877, 0x4858f674, 0x87d09588, 0xf1c8fb02, 0xdb7d795b, 0xe6996382, 0x52e1b5c5, 0x62458ce2, 0xd00ae7b2, 0x422c5811, 0x145274fc, 0x218d45c9, 0xc6c20be8, 0xea30fcc9, 0x7bfc25b0, 0x6a8bc47a, 0x11bc94a0, 0xd903d804, 0x145e8e74, 0xf5793179, 0x16aae0ab, 0x056db9a3, 0x05ddd7fa, 0x0ad8b5b4, 0x9dd0a3f8, 0x85ff978e, 0xd68d1501, 0x6c6ee8a1, 0x0df2068b, 0x1754f0bc, 0xa7319dba, 0xc5a149bc, 0x8d782a9c, 0xf7993129, 0xd551d859, 0xd4eca529, 0xb8271a65, 0xfcb38b4c, 0x59394127, 0xd8ee4be0, 0xef950aba, 0x4014dfa3, 0xbd78ee1a, 0x08ed812c, 0x5bc3ce9a, 0xab7ddd77, 0x13a7d8d2, 0xdd16ca63, 0x2ab7fab1, 0xd44ad06c, 0x67774214, 0xa4215281, 0xf4e59728, 0x694372e0, 0xac1dca02, 0x390e8e50, 0xacdccecd, 0x3e17ac20, 0x285bb214, 0xf4dfda3c, 0x873c19b1, 0x155dafb7, 0x4b9804b9, 0xb9f96896, 0x9f9c146d, 0x349cc61b, 0x36f8bff8, 0xec0a0a60, 0x4a0f24d0, 0x70e8f4cd, 0x8b06de6b, 0x1822eaef, 0xf2fab053, 0x9c738381, 0x77269c44, 0xc48da7c7, 0x735c82f7, 0x7bffd8c6, 0x16099ca4, 0x81de4060, 0x314061eb, 0x22055149, 0x795712e6, 0x584bd129, 0x41c43ece, 0xda642604, 0xdc0808ca, 0x54d217d3, 0x3c42a73c, 0xc7516812, 0xe4a97c58, 0x8b3ee569, 0x7cf578e4, 0x3b108c09, 0x8c7fba39, 0x5609fe27, 0xd7395db1, 0x12a28d25, 0x01d5f0dc, 0x3838c603, 0x276c56c0, 0x39a96d40, 0x7363a9f5, 0x1db15b0f, 0x2d9fd0aa, 0xba98e973, 0xf507d15e, 0xab50b7b9, 0xad707fdf, 0x9b647793, 0xca92cb95, 0x0000000e };
const u32 bern_num_data442[159] = { 0x08563d51, 0x8586cfd0, 0xbe6ff66e, 0x903f410c, 0xd353a26b, 0x87f095ee, 0x0b5ad2db, 0x7d536e87, 0x803e241f, 0x87d3c534, 0xe6379505, 0xbfa9d056, 0x2f4980e9, 0x57bb25f1, 0xcd1841cf, 0xd1bb31e0, 0xaea9226e, 0x6f57f51b, 0x753558a8, 0x1afadbb2, 0x3c61e54d, 0x66ba9898, 0x06a9b858, 0x4e8aeac4, 0xb1851261, 0x9ecfc1fa, 0x3025554b, 0xf9fbb89d, 0xea12cde5, 0xb28ba010, 0x996dff28, 0x722d082a, 0x9008c250, 0xb180a428, 0xb9e899dc, 0xa95a3167, 0x3eb6284f, 0x03bf5d3f, 0x37b993de, 0x22e33718, 0x48c09645, 0xf6d7efda, 0xd4bebf68, 0x2bf02969, 0xb009b155, 0xb3ba84f5, 0xbb533fb0, 0x3887292f, 0x1463722a, 0x64eaccc0, 0x77f02fba, 0x031b47bb, 0x776f8b0f, 0x109e70a9, 0xdbb729f5, 0xeb0390f0, 0x002bf59d, 0x21039784, 0x78d82120, 0xadb07da4, 0xde749974, 0x321667ec, 0xb8b13275, 0x904a3c16, 0x894fa579, 0xc72ade14, 0xbce7cc1e, 0x06264f44, 0x60e68c25, 0x1af7e0ac, 0x54514402, 0xbf0c5434, 0x5f1e017f, 0xcec09114, 0x540567bc, 0xf11c3702, 0x6a9ab8cd, 0x185eedf8, 0xaab78a85, 0x80bb5e54, 0xf11fd632, 0xcb6da0d1, 0x0c8e6859, 0x0ff1d984, 0xc99d053b, 0xa14b511d, 0xd61ca3b7, 0x84de02fb, 0xb47f595b, 0x4dd9787f, 0x9c727a42, 0x59703b10, 0x9ac89387, 0x71ae722c, 0xe318da66, 0xd5b88d61, 0x8871e4f5, 0x8b039cee, 0x72c3b389, 0x9d8d8c78, 0xe968eb75, 0x2425fcae, 0x04ec27e6, 0xd647e3ed, 0x4d7f2618, 0xd5107525, 0xcf4a7eec, 0x4393e7c4, 0x7d189177, 0x733ad701, 0x7ffcad23, 0x6e26a9da, 0xc330dc11, 0xd62eaefc, 0xfdcb3d1f, 0xaee53016, 0xcd19b1ae, 0xd3fccd1f, 0x69becdc2, 0xdde0b2c7, 0xe4a70da4, 0x7e62fec2, 0x3dc1a511, 0xa16239ee, 0x9f3b5c8d, 0x659ebb29, 0x066e15e1, 0x20526441, 0x6c9a4006, 0xb4062e97, 0xde15dfe6, 0x0a47bb5e, 0x63a7b21d, 0xd6035fdc, 0xc900fdd5, 0x673fe826, 0x116e62d6, 0xa8b9291d, 0x5f447e7a, 0xb35d0550, 0x7cc84d1f, 0x2e834ebc, 0xeb853d65, 0xaf2a14b7, 0xbde266fb, 0x299eaacc, 0x3cb93ff6, 0x6aff6374, 0xf5863606, 0x536d8900, 0xed777dbe, 0x6be4e217, 0x73cdab6f, 0x11872188, 0x6cd6ac55, 0xfa021fe5, 0xf79f3855, 0xb7a9709d, 0x000008ab };
const u32 bern_num_data443[160] = { 0xd9863789, 0xbe6563c7, 0xead864bd, 0xe832a8f3, 0x83dfe7b7, 0x4bd78e2c, 0x858371c8, 0xe3a9e9d1, 0x1ff62b3f, 0x3db17ca0, 0x16fa84d6, 0x2dcc997a, 0x6c51669c, 0x6dc18d65, 0xc5914a6d, 0xd6d3c503, 0xcb74e3da, 0xeee8c665, 0x67dabfcc, 0xeea3e210, 0xa7cc6194, 0xa6c01034, 0xa3073ba1, 0xad234b11, 0xef72153e, 0xdd6f3fa0, 0xc5fc792f, 0x433d21be, 0xc2f318fc, 0x1c43ce56, 0xc0c66288, 0x5d4ef5d7, 0x08b2e06c, 0x36639117, 0x08a5b051, 0x6b3b85f5, 0xdeb7f8f2, 0xedd305e2, 0xc1e2d04e, 0x73ac98a1, 0xcf49daa0, 0xd6a7a87d, 0x0e0d0b89, 0x8b1018fd, 0x5a28784a, 0x4aaa2e0f, 0xa60f590a, 0x7b2bf320, 0xa4d4c459, 0x0ddbec7a, 0x276b921d, 0x8c2e1e06, 0x8eb2c40f, 0xd885eeb0, 0xe357c090, 0x5f1f156a, 0x606a2886, 0xced13fad, 0x0a250b1f, 0x83803285, 0xaef24be1, 0xa1cee928, 0x18c71398, 0x7cb4c43e, 0x73d83c3b, 0xffa642bd, 0x84782d3e, 0x0beffb72, 0x9e82e21e, 0x6ed8f9b8, 0x908fc1df, 0x4c5a7a0c, 0x5e30e0c6, 0x675db6b0, 0x089e35c7, 0xb55ca5fa, 0x7b178762, 0x3fa822a4, 0x63124643, 0x818bf2e2, 0x074ff619, 0xe27c5623, 0xab92ca77, 0xda792c8d, 0xa1a467c9, 0x6d3c9973, 0x0c123314, 0xe6c41201, 0xc3df82d3, 0x99f844d9, 0x1b3fc81c, 0x083ebda6, 0x2def24b2, 0xaa124d9a, 0x7597635f, 0xdf7cffa0, 0x7cf86270, 0xdebf1e3a, 0x78d72580, 0x3e9ef8af, 0x1e49c82b, 0x088d968c, 0x6739bb4c, 0x09bf344b, 0x614782c5, 0x50164fb9, 0xf4f36b6b, 0x5aa172dc, 0xfb316158, 0x406fa564, 0xb531549f, 0x3b7e0e97, 0x7836f5dc, 0x159184a5, 0x0e904edf, 0x707c14f4, 0xe16b6891, 0xe6f12e38, 0x2290dbfa, 0x613bef5c, 0xdfdbf38d, 0xd8e5eefd, 0x82b018a5, 0x957efef2, 0x2570c528, 0xb59ed803, 0x70fa903e, 0x33d0fcfc, 0x9c5ee3d8, 0x02f0aa11, 0xde24beae, 0x861c2ec5, 0x2a75bf93, 0x8ca3e672, 0x9a64e7dc, 0xd847404d, 0x0623f659, 0xf5417089, 0xabcd1eb1, 0x745c47bc, 0x78adad80, 0x4b14eccb, 0x4743cd50, 0xd7d070f3, 0xfaa3129c, 0x2c83514a, 0x2c896b30, 0x6b09aede, 0x5bf01949, 0x8e38d066, 0xe78f9c41, 0xf44678dc, 0xf323fbd5, 0x0179d802, 0x59a6fe50, 0x3eea685f, 0x013c66df, 0x8ee6eb48, 0xbfd1b443, 0x000000af };
const u32 bern_num_data444[160] = { 0x062afa1f, 0xc57f5ce5, 0x3aa3a3c5, 0x4b79130c, 0x5ddcc87d, 0x9a2534ed, 0x5b55f2bd, 0x74fc9806, 0xdeef50bb, 0x8e654b5d, 0x905f4d49, 0x86188f1b, 0xe1aee271, 0x94f81c8f, 0x76f6d84f, 0x8f516e71, 0x0b016038, 0x778b2ace, 0x05968ed8, 0xdd867528, 0xa0526653, 0x151650dd, 0xd4f3486d, 0x6f288246, 0x09044c58, 0xea38286d, 0xd4e693bf, 0xea611d82, 0xe82ef255, 0x5246eff6, 0x3b864a82, 0xbf42b29f, 0x1410f05b, 0x975f7c06, 0x54cce685, 0xe01d683c, 0x26c0c934, 0x23bf811a, 0xef67b9e7, 0x820a0080, 0x7c927f91, 0x76dd943a, 0x79e0507c, 0xafe4e004, 0x888fd072, 0x96434e93, 0xea735734, 0x7587eae6, 0x6e850d11, 0x11a98374, 0x1ec2f536, 0x00eb92c8, 0x23466296, 0x0636098b, 0x914b1c37, 0x5b086518, 0x48d45a48, 0x4f8d4677, 0x85c567b6, 0xd2ae76de, 0x0bc8f3ab, 0x7bbb9ed7, 0x13c8afe3, 0xaa42ffad, 0x2f51d3d0, 0x8d22e664, 0x1e29b003, 0x67588d17, 0x5ad2b851, 0xdd138018, 0x9225325a, 0x64ec512c, 0x80abe90a, 0x864737b0, 0xa0415e2a, 0xf8eff83c, 0xcf85dcac, 0xe6118e14, 0xe1472c6d, 0x352494f5, 0x0b9cfb2d, 0x77c72b92, 0x67c7f8d4, 0xfcd2c542, 0x5c2b5e53, 0x8cb7390b, 0x307b7ce7, 0x6986df91, 0x309a9ff2, 0x250b3934, 0xa5822764, 0xc81e43d8, 0xd11e6b70, 0x010b7ece, 0x64978cc4, 0xb0c834c6, 0x6a40b8dc, 0xffad5b27, 0xb8921616, 0x78c4a783, 0x3feec55b, 0x87cdf063, 0x60b71b25, 0xe99522ff, 0x9b1c08b8, 0x34a8ff46, 0x6abd0924, 0x14e98aa2, 0x3b57c63d, 0x54ca59b0, 0xae49a246, 0xf041a160, 0xcae6e173, 0x11cff79f, 0x4423e128, 0x7434dee2, 0xc7a97951, 0xd3e00bab, 0x219162bd, 0xab97fd53, 0xab5fec77, 0xf549af2d, 0xb30d1ca6, 0x0b271ed7, 0x455163e0, 0xe8c36130, 0xca0696b0, 0x02dad4b4, 0x7bce0535, 0xd97c8006, 0xebadf828, 0xb242e3eb, 0x6c1032e2, 0x6d2f976e, 0xfc62ff79, 0xd6e7ad2b, 0xe39efb13, 0xaa9ac0b1, 0x58ea9546, 0xd1475a00, 0xcca1b33c, 0xa995561e, 0x504d8151, 0x5fd202a9, 0x0bf220de, 0xdbcb6ea0, 0x23fffff3, 0xc29bfe44, 0x50cd6b61, 0x1c1f0fb6, 0xc2ca77d9, 0xc27bc140, 0xd73c7fad, 0x58bddb32, 0x25e26c62, 0xd51f9d64, 0x88a0665f, 0xb546a3f7, 0xbe08b588, 0x000001ca };
const u32 bern_num_data445[160] = { 0x2d0f5e69, 0x4dae7b75, 0xfd2b1926, 0xd3b92db6, 0xf003b1c6, 0x7432edb3, 0x94b98fc8, 0xfca0be8d, 0xb4df2654, 0x64c02cd8, 0xcd02af6c, 0xf4ddd402, 0xdb9c1f7a, 0x0963ed10, 0xcdf305f8, 0x7bb74efc, 0xa8d17008, 0x0fe69c90, 0xa32a83dc, 0xc081eeb8, 0x067cf0b3, 0xfe8a0bf6, 0xb7a1827b, 0xc5bcca26, 0x3e02ed64, 0xe0e2384d, 0xe0e117bf, 0x3f32944f, 0xf18c6466, 0x145ce4e3, 0x75de2d4d, 0xa94e19c6, 0x2760656b, 0x1c6dba86, 0xfb78d2e6, 0x8b678a81, 0x0c10e4a6, 0x047b428f, 0x05e59480, 0xa47a91a7, 0x3482dea9, 0x4aedeb03, 0xb3c61120, 0x5a00c502, 0xa1d8d533, 0xdc1f0d49, 0x1360c092, 0x9b403eb9, 0xa164e3b7, 0x2784530e, 0x0ec774dd, 0x09b51e66, 0x48be65ca, 0xfeb29151, 0xa29c5475, 0x0c1c5391, 0xe7fd98f5, 0x11e07e29, 0xf46448d1, 0x05fa02bc, 0x136f560b, 0x266c0fd4, 0x8b373508, 0x58e817bc, 0xb4058843, 0x3af4801f, 0x224cc058, 0x1eedc2eb, 0x26e67e17, 0x021b9c02, 0xb23acd01, 0x977671cf, 0x117ca42b, 0xb1bbd972, 0x1b490135, 0x20419984, 0x7ceed328, 0x86a1455c, 0x7562cfca, 0x7c9a8d93, 0x442528ee, 0x280040b3, 0x26101f5b, 0x4f0215d2, 0x2a448b7b, 0xcfc98cea, 0xf00e32dd, 0x7c1a80e6, 0x6d0e739a, 0x27b835d0, 0x9ca3945c, 0x1f8407dc, 0x420edd5a, 0xa6ef3f7e, 0xba62caf5, 0x6b9c2c3c, 0x126569b8, 0xef01e2f3, 0xdcb316b8, 0xe0a04792, 0xc8c33475, 0xa24095e2, 0x199ec6e1, 0x72c56bd5, 0x3d64a883, 0xe318fd7c, 0x3c8ed6b6, 0x414a0e8a, 0xbefa41e1, 0x1d29874c, 0x578daa83, 0x5e8bbfb0, 0xb4e41523, 0x84afb4d9, 0xed5e81af, 0xa8ccd7e0, 0xa5a89d1a, 0xd30a89de, 0x18ec1971, 0x78967b6d, 0xeeaadeea, 0x85e92f2c, 0x5d3ef43c, 0x88fc7f0e, 0xde49bc0d, 0x4d27af00, 0x21eb2fd9, 0xbaf143dc, 0x81da8133, 0xffaea28e, 0x0bf5fedd, 0x5b2167b9, 0x6e5bb745, 0x26439394, 0x8f2f4efe, 0x4eedde0a, 0x642e590a, 0xd9b96d8e, 0xe3cb21f7, 0xf0accdf2, 0x39f79aac, 0x3ec8daeb, 0xf5928eef, 0x02a9b336, 0xe8ed957a, 0x7d4e0b7c, 0x86da9fd7, 0xe30bc956, 0xd20a44d1, 0x530e061e, 0x8695fa30, 0x03ba546f, 0x971f2fbe, 0x8679b139, 0x35992701, 0xb9c371f1, 0xeaac1e2e, 0x25f09f8d, 0xc92339e0, 0x00005b9b };
const u32 bern_num_data446[160] = { 0x00716891, 0x2650d90b, 0x9e5ef781, 0x053176e5, 0x1a1bb339, 0x0616c833, 0x4ad507d0, 0xe0795f37, 0x703bc7d6, 0x0069452a, 0xd711138e, 0xf27fd72a, 0xaaf57240, 0x532dbbb7, 0xa41b1ed1, 0xb41d594c, 0x2c439615, 0xc14abd66, 0x71e273ee, 0x048b849e, 0x6f5c0279, 0xdea844a9, 0xf70b2090, 0x4663b8f8, 0x1a47887c, 0x5fed86ef, 0xf62e9465, 0xda677df7, 0xb34afaf3, 0xe6c215b2, 0x7bb4ead6, 0x94b36501, 0xbe8b7661, 0x2ffd1e3e, 0xab989e98, 0x479c5308, 0x51461aa8, 0xcdcd44e0, 0xbc9fa56d, 0x78aad5a7, 0xa790eac8, 0x53e59a5c, 0x4aadf5fe, 0x1861992c, 0x6ae14c92, 0xdd4c9733, 0x08043895, 0x1524750b, 0x97b8c79a, 0x86a83bc6, 0x470fb075, 0xd8639874, 0xff2bb21c, 0x055dab85, 0x265872b0, 0x40b0f268, 0x87f71317, 0xbb6996d3, 0xa1ccb945, 0x8b750adc, 0x6f2004f8, 0x5debcc67, 0x81c0d86e, 0x94afe896, 0x42bc62bd, 0x535d7c9f, 0x5ef0725c, 0xa687510c, 0x865c3365, 0x87366262, 0x99be7d48, 0x40c5b30a, 0xd3428645, 0x52a5b4b0, 0x8372cf00, 0x816eb0b8, 0xe908eab3, 0xc86bfba3, 0x9ed6c8c6, 0x47dbea42, 0x80727170, 0xe72c3fb5, 0x48467693, 0x38695d98, 0x7a3afea1, 0xf184bb20, 0x5c649b62, 0x13b52746, 0x9067bc86, 0x82491909, 0xd8206118, 0x37340803, 0x30dcd7c5, 0x0edadcd7, 0x02cd0efd, 0xfb2f828f, 0x1cfb48fd, 0x94c1bb05, 0xdce7d300, 0x4322e4f8, 0x928bd34f, 0x8fcf3f2e, 0xb128687e, 0xc8b70af2, 0x2533fac6, 0xea8d3a2c, 0x719c1479, 0x550f66b4, 0x1dc5220c, 0xa46d9b57, 0x0b15f7a0, 0xfc80ae39, 0xd50d200f, 0x0b1355b4, 0x468568e7, 0x13b48f14, 0x73673234, 0xbb3c58e9, 0xc46e71d3, 0x5e1c25f4, 0xbd2700ed, 0x9fa7cec7, 0x6ea9ebc2, 0x6e33124e, 0x16990d9d, 0x0161143e, 0x3f3dde34, 0x8cf0e08e, 0x62c62509, 0x16dd268f, 0x9719bf05, 0x2e3a9145, 0x15fd100e, 0x8259f050, 0xc114be07, 0x2e101522, 0x0d73715a, 0xf7716af3, 0x31345966, 0x5d5b21cc, 0xebc61e34, 0x36fbdf77, 0x98b47642, 0x76ce5720, 0x29681ce7, 0x2c0a0627, 0xc78cc587, 0x9dcbf27c, 0xdbe0f72d, 0x54df4b80, 0x87d82b70, 0x37a583af, 0x9a10c3b9, 0x04c0920e, 0x020c7ca4, 0xc4bdeb41, 0x09e313a9, 0x9dfcb942, 0x9951cea6, 0x279305a8 };
const u32 bern_num_data447[162] = { 0x8c3ec98d, 0x29ae72f2, 0xfd03fb8a, 0xc0046806, 0xa7e7578c, 0x34117ddf, 0x5edd8f0a, 0x9b8ee0a6, 0xd0601f7a, 0x47207828, 0x1a224f4d, 0x2cb2bf9e, 0xb556bb96, 0x30aa5a3a, 0xfeed9ce6, 0x9aa6a247, 0x9bc5c39a, 0xc73ce2ad, 0xbc743af2, 0xb1a5d4b8, 0x74f17227, 0x82b9a691, 0xaa00217e, 0x5adccf59, 0xe3ca7154, 0x3dd636b5, 0x0d90b0b4, 0x9cd18d74, 0x78e0711c, 0x25607504, 0x68560083, 0x23554703, 0x83db0ee9, 0x5eb7bedc, 0x6b534d9c, 0xa6b66480, 0x73a697cf, 0x262aa6c1, 0x8684c3d1, 0x115bf349, 0xe03e1661, 0xa8426d39, 0x523cd155, 0x72516195, 0xea577209, 0x15f65d4c, 0x848d87f8, 0xd0e1ec53, 0xf31262b1, 0x011d9eff, 0x61d9d602, 0x2ad3e42d, 0xf9b7adb1, 0x4ca81ed4, 0x52753e74, 0x3b06109d, 0x0215a8aa, 0x8d51eecc, 0x1f3e20c3, 0x2c3adfde, 0x12bca48c, 0x9059f7e5, 0x2e43c727, 0x0622c560, 0x360765e9, 0x0560b994, 0x43b09551, 0x1be1143c, 0x3a8302b5, 0x37c862c1, 0xee1a7c7f, 0x9230b24a, 0x1ec0d2ee, 0xc092ce08, 0xecbd7518, 0x4e95fc58, 0x07371627, 0x82049d16, 0x0e08ad06, 0x68a06c8d, 0x83acdc8e, 0x6d09d467, 0xea86f3e3, 0x9cbaeec1, 0x4245a715, 0x165192b1, 0x56e8e635, 0x768ceb57, 0x60e0d2bf, 0x98a062b9, 0xe98b6dc2, 0x786122a2, 0xbd3a4201, 0x9267986b, 0x273f9a78, 0x9f864ae0, 0xa89c52fc, 0xbe1b2958, 0x2ddf9a79, 0x14c8bbb9, 0xaeb07837, 0x59f1b3c0, 0x4470e8e4, 0x9b5a79fb, 0x8afaa418, 0x0592b05d, 0xdebc7d27, 0xe3855a18, 0xb7f5e283, 0xbcea8c4e, 0xc9d599d0, 0x2b600f6b, 0xb27a5e3d, 0x92ea318d, 0x309d1b4c, 0x30fdd444, 0x64f5862d, 0x8a314330, 0xe602e123, 0x89c466ef, 0xd6bd72b7, 0x8dfe5776, 0xf661fcd0, 0x74b9f909, 0x36fe2694, 0x29682fd8, 0x9ca82c95, 0x7efa0486, 0x3363ed7f, 0x52554b5c, 0x0b734b7a, 0x756caecd, 0x9af50b03, 0x1405bf68, 0x37f85bc2, 0xf2412229, 0x7b1502c1, 0x183b6196, 0x081268b3, 0x20d67ba8, 0x3e7258d6, 0xe61f2390, 0x29659e13, 0x634abb47, 0x21f2e965, 0xe6a6b47b, 0x8d779f03, 0x3ee216d4, 0x20512023, 0x9d28d9b9, 0x49b6ce38, 0x52d9eb47, 0x45ea57cd, 0x0e6aef53, 0x1f9d4269, 0x2b4c4f80, 0x4f27229b, 0xa77ff8e7, 0x7e72e4c3, 0x9cb98109, 0x100439dc, 0x0000000d };
const u32 bern_num_data448[161] = { 0x9e3ea4ff, 0xda6d2c18, 0x3de7b194, 0xc71fc243, 0x2a12fba8, 0xc64ba8ef, 0xd0af820f, 0xdb450849, 0x1bd9cbcb, 0xc98be040, 0x248de554, 0x2dcb9e49, 0x2128911f, 0x08298a0e, 0x4e71f696, 0x7dc04082, 0x04101ec0, 0xba7bfa1d, 0xf84f3a81, 0x5f1623d5, 0xbb7c9d95, 0x0fdfef05, 0x73c081e7, 0x65e3339e, 0x2a6d5e3d, 0xc8c14cdf, 0xf860cc41, 0xabc9844e, 0xabc13933, 0x3afb667b, 0x6dce3d61, 0x5663dd39, 0xe4b2a4ea, 0xf96c7962, 0xe4fb3dab, 0xa0912a95, 0x0389f056, 0xc19a2804, 0x52b3b426, 0x5fc9922a, 0x275982f7, 0xf7d0bad3, 0x2980425e, 0x07782a76, 0x34481cc3, 0x1999df1c, 0xa8e644b3, 0x4dfdb075, 0xfd029541, 0xf7310132, 0xf7296af8, 0xa1744fde, 0x65e98753, 0x4f236e7c, 0x83b00b14, 0xa0b3af45, 0x11a93449, 0xf85c867b, 0xcccfb788, 0x10f964c8, 0x63c9f4fc, 0x9c459ff0, 0xd1905d34, 0xb1253ba6, 0x01df2f5a, 0xa3ad7a06, 0xc7d8661d, 0xf6b45c02, 0xc0fe2056, 0x747bffa0, 0x3ea3551f, 0x90a75528, 0x37671f19, 0x2bce3f22, 0xd8ade8b2, 0xdea651b7, 0x02f2381f, 0x8c43548a, 0xf5d668e2, 0x225ab41b, 0x75ed295b, 0x42def620, 0xa93b8692, 0x283e2f8a, 0x8db556d4, 0x6c064af1, 0x50cac0b5, 0xc32de027, 0x8b425fc6, 0xbe99b3a0, 0x72dbb210, 0x8e244d6c, 0x0b8446f4, 0xf16c77c5, 0x5f347316, 0x6c862543, 0xebf50640, 0xae76ead6, 0x17a3c531, 0x3200d56d, 0x4f7217a9, 0x03f23e5a, 0x8b488ccc, 0x15b1ab1e, 0xf133c05d, 0x5ac508b8, 0x80aaae83, 0x2f45be8a, 0x3ebdd8a3, 0xee2c5e2c, 0x58b21fb9, 0x521a3418, 0xca880eeb, 0x78a53210, 0x80baba00, 0x1992161b, 0x893085b4, 0x4d53101a, 0x1302bea2, 0x76d2c541, 0xa7cd1a2f, 0x920c7bf8, 0xef15f3d5, 0xe48ead5b, 0xf8efb410, 0xe4a61b0f, 0x7588fd3c, 0x37f88754, 0xe7d6ae88, 0x8b754ad5, 0x0c714536, 0x5d1177b6, 0xccb4e252, 0x5c3a9d5b, 0xe43d504e, 0xd3dbb2aa, 0xb272fa99, 0xf0f67bbe, 0x9b49ebdd, 0x26f7debe, 0x8d042ab2, 0x5591c1ce, 0x96062cce, 0xc240a798, 0x4672798d, 0x7efbc203, 0x31855c9c, 0x1c0ea1d3, 0xab199c46, 0x228c1618, 0xd3301699, 0x06ca4151, 0x6d1c8902, 0x56fed41c, 0x444d784f, 0x22fa0872, 0x23a0a6eb, 0x9f2ee314, 0xa2669d7c, 0x3708866e, 0x008ba943 };
const u32 bern_num_data449[163] = { 0x0e79f133, 0xf164b66e, 0x1ee620b3, 0xa4eabafa, 0x991ba5c4, 0x81f27132, 0x8c526ec8, 0xc89d13e7, 0x4e94513e, 0x38b46b54, 0x76b2a85f, 0x1c16c375, 0x2a155c1f, 0x1dc7922d, 0x1f3d5d44, 0x235699a6, 0xbd1e550c, 0xe16f55b8, 0x4cdadfbb, 0xd9e93771, 0xe0a09258, 0x08c37d71, 0x791b98a9, 0x60b058ee, 0xf2109b06, 0x6988f5c4, 0x20d2bbd1, 0x32e790d9, 0x8cb7c497, 0x9206cfb2, 0x384115da, 0xb1ca7fb3, 0xa3722f0a, 0x9b9cc3c4, 0x8c4fac52, 0xa1289e28, 0x6eadad89, 0xbc48ee95, 0xa3867e66, 0x920db7b8, 0x0b1c07bb, 0xa5debbb2, 0x602515e7, 0xee3f816f, 0x3f6b3340, 0x03e557f1, 0x752e2e8f, 0xadac3684, 0x90e74435, 0x7f283acc, 0xcebb6bdd, 0xe72544be, 0xb21e2f4c, 0xf5fd7b66, 0x5d99c17e, 0x0fb02dc5, 0xc2c69638, 0xb0187850, 0x7b4e6795, 0xc6aab1b6, 0x64d871aa, 0xd4587b2f, 0x033dfa8a, 0xceda5eb0, 0xff18840b, 0x8008e556, 0xaa18672f, 0xc3eafe0a, 0xaac7ac60, 0x8a9405b9, 0x2531df0c, 0x35664807, 0x2c33b99b, 0x5007fe15, 0xdd973d41, 0x405372a5, 0xa608dd34, 0xaa9da697, 0xf9013129, 0x8b99d981, 0x9240c9aa, 0x3e4487ed, 0xe2ee8c21, 0xcb8d55ed, 0xef7686c2, 0x978f2def, 0x47c916c8, 0x4e4b0cae, 0xad8fb266, 0x59dac95f, 0xc823d38b, 0xb76af05d, 0x23663661, 0xc54053a3, 0x84507fff, 0x867df48b, 0xae1c9088, 0x4d0b327d, 0xfbb79359, 0xc86a6cb4, 0x1deffa7b, 0xa78c1631, 0x6fb52bda, 0x53558652, 0x4e15e676, 0xf2285b1d, 0xe9214516, 0x649d2e3f, 0x955cce8a, 0x65a040bb, 0x4c011b63, 0xce3167d1, 0x977de5d2, 0x3d884984, 0xf8a51ee5, 0x319f5e78, 0xf29d5061, 0x2eaf3b68, 0x9e806907, 0x0a52e1bf, 0x250ae06e, 0x402d9aa9, 0x76babcdf, 0xac2b2e59, 0x3b9f94e8, 0x60112dc7, 0xeccbd924, 0xc6f6dc7d, 0xf8e69c06, 0x79436275, 0x33359230, 0x0bb58a2c, 0x2f14e829, 0x4449dd04, 0x6db76342, 0x9bb36fc2, 0x634cbc39, 0xba2b8c4f, 0xe2af62ad, 0xb2283704, 0x69ecaa69, 0xc68f7d16, 0x883238ba, 0x3198c18d, 0x4d7ef4a3, 0x8163c480, 0x697275ee, 0x7b9d628e, 0xb3dc42f9, 0xcd9cef14, 0xb465a73d, 0x69eea1ad, 0x3c09d884, 0xa0187ffe, 0xf6e95e82, 0x46f2c822, 0x16ab2732, 0x67aa8af4, 0xffb5fbcd, 0xea96b028, 0xf98eea58, 0x3ad0c73f, 0x0b21e0cc };
const u32 bern_num_data450[162] = { 0x61e04a43, 0xf2255919, 0x6b771b85, 0x905d9e1b, 0x73a2e7e4, 0x07751109, 0x1ca57118, 0x502d77bb, 0x911c6e4d, 0xedb45211, 0xc101d428, 0xfda40766, 0xf5bd20e3, 0xf0732dbe, 0x08b0a0bb, 0xd51314ab, 0xe7fef880, 0x7186b813, 0xc367a446, 0x56f63a6f, 0x9274fbc7, 0xfe05a2bd, 0xa7af7f09, 0xddb9cd89, 0x7bd032bd, 0x1382c0e2, 0xed0a9ce6, 0x4d5f60c9, 0x0b673b03, 0xd0c78f1e, 0xa1a07609, 0x50027727, 0xb67997cc, 0x80d7affa, 0xff3b6928, 0xd3cbdca7, 0x92cba4c2, 0x3a840d1a, 0x3b593d03, 0xffa535d9, 0x081703e3, 0xf8d28623, 0xa9802f0b, 0x51b66ba8, 0x35478125, 0xb7856c5e, 0xf3d5aec3, 0x673da5bf, 0x03ab76f4, 0x94af3dec, 0x8567f0c8, 0x435a82bc, 0x24ebb0c0, 0x02dd042a, 0xb21c80ee, 0x6daac1a0, 0x2c2cbcf7, 0x770a73e5, 0x666167c0, 0x6ae3cf2e, 0xb02461cb, 0xf1903170, 0xf288853f, 0x71aab433, 0xd1a777e3, 0x8a379967, 0x9672a3d2, 0x61054efa, 0x54f75fc3, 0x8cab9f27, 0x96a1ff8a, 0x282340bf, 0x0a702f56, 0x7cfbceaa, 0x8c0de18f, 0xfcc69b99, 0x7fd3420b, 0x537426fd, 0xbc01e160, 0x4938931f, 0x46dde334, 0x7807c370, 0x1198734f, 0x6ef382bd, 0x7550f6b0, 0x95aaf31d, 0x815b400c, 0x9520d2a8, 0xc961637f, 0xea99e7f8, 0x8d7326cc, 0x6ec65f2b, 0x95f9349f, 0xe7bbdf60, 0x0640e8d3, 0xd29b0aa7, 0x8096250b, 0x5c3b5129, 0x054e2baa, 0x3a9c3a45, 0xfa0b3990, 0x9c0b25e6, 0x75460b94, 0xe5df33c4, 0x3d0166a8, 0xefd831e6, 0x00e99190, 0x495e76fa, 0xd1c5b2fd, 0x1eb6a758, 0x3aa936d4, 0xcdc0cfff, 0x30306989, 0x314e4a72, 0xbd4b0ded, 0x396482b6, 0xd0e38d93, 0x5ad668eb, 0x9c375b6a, 0xdb658b8e, 0x5f0d2e01, 0x4043953d, 0x94df9f7d, 0xfdf91a04, 0x378ae1a0, 0xd97c209a, 0x21f399b5, 0xe3457534, 0xccd5cc56, 0xf0e07782, 0xb183f830, 0xd495a047, 0x35809bb0, 0x445eb022, 0xbd7ecb26, 0xd54e9643, 0x6c6922ec, 0xba2fdcb9, 0x69b9fa77, 0xa1a491b2, 0xe16370a3, 0x197c8fc6, 0x4c8a8dcd, 0x198e74c7, 0x6ea31c41, 0x1132aee3, 0xcc449645, 0x72f0b016, 0x3a8f9cb7, 0x71ccd846, 0x306ea44b, 0x43aa51f8, 0x49660a58, 0xe7cf2444, 0x64574ef2, 0x70e5ac3a, 0x22234457, 0x43955ee4, 0x492c3820, 0x5a586b63, 0x55d2a22d, 0x664e0537 };
const u32 bern_num_data451[163] = { 0xc137cc63, 0x8093f07e, 0x9589b738, 0x4cff845a, 0x8df6e2d7, 0xaa2fb067, 0x95ed0398, 0x5e9b5e36, 0xc3221a9e, 0x1de52591, 0x5d145961, 0xb1461945, 0x13c40bb1, 0xa0704bfd, 0x79b2b334, 0x41fae4f4, 0x67bd49ad, 0xfaafa18e, 0xd973f614, 0x69dd481b, 0x74204aaa, 0xe2089eb7, 0xd21589a1, 0x7bc34e2a, 0x942f87cb, 0xc57005db, 0xadc73893, 0xfe33fb81, 0x4e2005ac, 0x3972573c, 0xe4e33bbf, 0xede3517d, 0x6ab27a32, 0x0606e9ff, 0x52b2ec69, 0x92d84b10, 0xa785d030, 0x43ff0f63, 0x33169854, 0xed387810, 0xe7342b44, 0xb78de8cc, 0xf460df3c, 0x521e6ee5, 0xd4f57b7e, 0x5566b1f5, 0x9eadadb6, 0x377244c2, 0x43ef6a3b, 0x97a6edfd, 0x8d2b5fb3, 0x90bc3765, 0x0b95bd46, 0x0593f383, 0x669a17c8, 0xdeda9241, 0x39eed810, 0xd41dc201, 0xe706cf6b, 0xc5468ae4, 0xfae7e80f, 0x90d8e59c, 0xe6e7f434, 0x82aafd16, 0x4ede045a, 0x08238488, 0x24acd483, 0xfd25b65c, 0x011e65a3, 0xa5f722b0, 0xe0dfce87, 0xf932183d, 0x7a4951ec, 0xdcbfb80d, 0x5af75ca5, 0x019ed615, 0x794c63fb, 0x1be7b2ef, 0xf0488286, 0x024a94d8, 0x7291a97e, 0x22baf8ca, 0x4029c555, 0xfa184b69, 0xe9deec24, 0x8b22329e, 0xd1f4c4d7, 0x2da9871e, 0xe2498b13, 0x5f4dbd81, 0x6fb9257e, 0xb03b4730, 0x47726cd4, 0xc17e58c3, 0x27820ad0, 0xb688c43c, 0x5c79f0fd, 0xfb685af9, 0xcf26460f, 0xb88aa83a, 0x74262ef7, 0x05c078ad, 0x11451c89, 0xe88cdb93, 0xcf460344, 0xd07970f7, 0xdce9276c, 0xca46f172, 0xbea9a804, 0xb720de03, 0x1e3ed710, 0x6a3ec8e2, 0x0bf74292, 0xb3adf76e, 0x3b71041c, 0xd9d03075, 0xb33b5501, 0xa9acbcd9, 0xb62d4237, 0x9a0fe5cb, 0x80e790e7, 0xf6de8783, 0x4b6db707, 0x1799c91a, 0x1d04fc4a, 0x909b545b, 0xd8c0e88d, 0x7b658474, 0x96e327a5, 0x5abdd829, 0x1278bc63, 0x4ffac38a, 0x5009cd10, 0x4c21afef, 0xf8aed20e, 0xfa32d0e6, 0xbf1dcb85, 0x0668ef91, 0x68e30046, 0x448e2527, 0x04adf1e5, 0x9c7e395a, 0xb79da89a, 0x773d1525, 0x932e9669, 0xfda5eb1d, 0xb88a26d6, 0xc4cc4a1b, 0x0be4f514, 0xa9579eec, 0x01147006, 0xad68f67a, 0x879ebce9, 0x41753483, 0x95c3e24c, 0xbf5656a8, 0x10f0841b, 0xc6ce1a90, 0x4038ef46, 0x55b40727, 0x617f5704, 0xf305b2af, 0x00001330 };
const u32 bern_num_data452[163] = { 0xda063aa3, 0x38bc5122, 0x6de221c0, 0x5ad744a8, 0xfb7da748, 0x5b4fa06e, 0x0a9c8fbf, 0x9697e5a9, 0x76547e05, 0x96b92b62, 0x48449a6b, 0x97fb8693, 0xcb198822, 0xada0adf4, 0xeae81f7a, 0x6544fd81, 0x60ab6de7, 0xe1a6e63c, 0x13d6ced5, 0xd541dcf5, 0x62493999, 0xe01905fc, 0xd0024e3d, 0x52cc5fde, 0x234b3ca9, 0xfc011f36, 0x72a51def, 0x573cbed0, 0x66ff820a, 0x428509f3, 0x6dffd9cf, 0x5aa23504, 0x6454ac6b, 0x05664f8b, 0xea87571c, 0xa54d6645, 0xd72678ea, 0x24348c8f, 0xc51788b0, 0x97e41b09, 0x1f1f4c6c, 0x9ed776cc, 0x844d0eba, 0x4da86068, 0x66326960, 0x7be9e2d5, 0x99c21f74, 0x07005fa0, 0x92224e4d, 0x24703d5e, 0xcfcea97d, 0xf05e0158, 0x68cbe778, 0x051e8a5b, 0x130f5b31, 0xccf095ba, 0x59651032, 0xee686eab, 0x32cea144, 0x859805d7, 0x6916f64b, 0x3e41f5f3, 0xbb21b71b, 0xff247ed2, 0x5bea362c, 0xdf34f0be, 0x4aa86dea, 0xdff1d023, 0xd9f77fa0, 0x743cb97b, 0xb09f5c79, 0x7c8868a9, 0x64ae0c4a, 0x164f6d88, 0x4372397b, 0xe3461a32, 0xf384ea4d, 0xe3dc90cf, 0xe0e3f263, 0x1e53b18c, 0x6cedb8e3, 0xca12e272, 0x436c396a, 0x8b235cac, 0x4318a687, 0xf403a983, 0xcd8df9d2, 0xbdc2b4bd, 0xf910018c, 0x63af77fc, 0xa2a8bcc5, 0x422d06a7, 0x367dd562, 0x0a987f45, 0xc7c7fd46, 0x2240be6a, 0x4f814b17, 0x7793290e, 0x9e0426b2, 0xa1c05be1, 0xef26071d, 0xa27202f4, 0xda83a74d, 0x8be94677, 0xc76af738, 0xa9efd6bf, 0xe2bfbbfc, 0x5cce8862, 0xad8504b4, 0xc003068e, 0xd23145f9, 0x8e517648, 0x92692a65, 0x6a081be3, 0x26b45da3, 0xacbe1e5f, 0x3b6b52ff, 0xacc4abd3, 0x8ab22633, 0x4efd4001, 0xaf13be14, 0x82d15b59, 0x092e3adc, 0x305032c0, 0xae604806, 0xbb552cd9, 0xed4bea5f, 0xec50a27d, 0xb1f3a023, 0x3cbcfc52, 0xc463529f, 0x53974a20, 0x72fbcd95, 0x43f1f732, 0x8d63e069, 0x8cff1741, 0x0f407ecc, 0xdae32eac, 0x6b60c5e6, 0xc593f36e, 0x6b450965, 0xbc6cd67c, 0xf2849eac, 0x296193bf, 0xbbf3e979, 0xe549245c, 0xe882d6d0, 0xee422df8, 0xc55d4b3f, 0xc1812be3, 0x033b43d6, 0xa007a224, 0xe94f648d, 0xb9c503b0, 0x718d95f4, 0xd68d4390, 0x00817671, 0x657bfa7f, 0x8b7fc24e, 0xb36fe463, 0x9e5c3c42, 0x7fe26be1, 0x22056996 };
const u32 bern_num_data453[164] = { 0xd1f0bd89, 0x11a51131, 0xd2e710ba, 0x53156268, 0x7d88d486, 0xee02a35f, 0x14450646, 0x3199bed2, 0x3ef13260, 0x4089c64c, 0x4e40acb6, 0xc2e93cdc, 0x79d06230, 0xb9504496, 0x179d4b91, 0x236d82e3, 0xbba74bc7, 0x9bc56160, 0x091cdff9, 0x18142659, 0xea8c78d0, 0x86392dae, 0x61420171, 0xadf53848, 0xb911d86e, 0x9329c397, 0x7a8673a2, 0x7425cfd1, 0xe5dae537, 0xfdc61bb8, 0xdc22342a, 0x9c91fd56, 0xa030d037, 0xf34c0461, 0x6e5ddd6f, 0x891b256e, 0xcd513cc9, 0xa6200c76, 0x6a6707ec, 0xf2258165, 0x659145b7, 0xe8066d06, 0xbd078359, 0xb0461f05, 0xc741bbfc, 0xb594f2e5, 0xb6d56d6b, 0x8799d9c0, 0xd2aae371, 0xd8048db4, 0xe34a5d76, 0xb1064068, 0x24741add, 0xb477f975, 0x420adc07, 0x7ce28da0, 0x1f96444d, 0x437acab7, 0x195e17b7, 0xcfca81a2, 0x21cae682, 0x0623c4ec, 0x21691406, 0x9fcfba24, 0x32ed6c1e, 0x7c03faa8, 0x9c05859c, 0x82709db7, 0xd486e39a, 0xb1f795b8, 0x0aee8fce, 0x21b81bce, 0x99a6cd1c, 0x59563666, 0x98e849b5, 0x749976c3, 0xf9af5fab, 0x838d6c91, 0xddfd54dd, 0xcb25e061, 0x4a30572f, 0x908b14bf, 0x1e861f17, 0x7dc95fb5, 0x59c555cc, 0x30a32fdf, 0x66956de6, 0x03d8b352, 0x34145f86, 0x9b4ed9ce, 0x685e5ef6, 0x70d2cfc1, 0xeaf666ca, 0x8b53b08b, 0x15d2930b, 0xa84946f1, 0x04fcf867, 0xafdf2c91, 0xb9c17718, 0x0282e2a2, 0x7dbb0162, 0x21918dda, 0xf1af351c, 0x6228d4d2, 0xbf69e152, 0xc1046900, 0x86742dbe, 0x8a663fb9, 0x4c7ed72c, 0xe88ee0e3, 0x71c58ff8, 0x823c3fab, 0x130a4d5c, 0xca369269, 0x07e12046, 0x3d67d4db, 0xae63d511, 0x656ff167, 0xa55eb736, 0xcd1084c4, 0xf6206905, 0x126e30cd, 0x28ee4852, 0xe2784cb3, 0x5eda465d, 0xc209e463, 0x331b2316, 0x6d389ea6, 0x0fea27bd, 0x384122ab, 0x21866254, 0x78aab3ec, 0x149ae123, 0x2a66637c, 0xb29cf523, 0xefda4f25, 0x62308d79, 0x7b8c5019, 0xd2b0e95e, 0x75981217, 0x28853659, 0x6708ac2e, 0xae4eb649, 0x18bba305, 0xbffd6c7c, 0x03663357, 0xd8ee229d, 0x718186c5, 0x3c38ac52, 0xda1b763a, 0x542bea6d, 0xe22f88d8, 0x7f8508aa, 0xd89e9c5b, 0xd8887bfb, 0x36cc6f27, 0xe190686b, 0x1f4b2cda, 0xf82eda52, 0x2a715ed2, 0x7ea759be, 0xf5798145, 0x2eeaa2f2, 0x00000002 };
const u32 bern_num_data454[165] = { 0xff2523ff, 0x0d1f9265, 0xa7475fa3, 0x9a78c654, 0x234ddc01, 0xde1d1f7c, 0xe8146ff9, 0xbffd9d72, 0x9a211204, 0x7ac87f7d, 0xb1c6a6ce, 0x47079f6b, 0x3241fe5a, 0xa069cab3, 0x85cd1818, 0xafb5dd24, 0xb7c20cba, 0x62e9e38e, 0x482d25cf, 0x9fb3806c, 0x036b71af, 0x257922e3, 0xfb003ac3, 0x4193d684, 0x4071a5a4, 0xef8675af, 0x637a6827, 0x82728059, 0x969df8a4, 0x7f4d505f, 0xb76c2f09, 0x83f039c6, 0x2aff051d, 0x56ef8b39, 0x3aa49c50, 0xb59c36a8, 0x8a63da63, 0x29d95462, 0x6ee942d1, 0x6a13fc05, 0x8e9e9375, 0xc7695e68, 0xe0f18ca0, 0x0ce4d4cd, 0xce56e8aa, 0x575f5a47, 0x90be3f68, 0x2345c8aa, 0xefb97e72, 0xccaf3f56, 0xa332f79c, 0xd099b4c2, 0xddb48d81, 0x1fa740e4, 0x2bc64b8a, 0x2254e538, 0x99597d6e, 0x54549fee, 0x163eb15d, 0x038506d3, 0xf55e5713, 0xd75ac3ff, 0xa0a813a4, 0xedf07a42, 0xaf4000a0, 0x8cee5141, 0x4027c6a1, 0x9d7ddc0e, 0x26a63494, 0x55a6b483, 0x27c63f20, 0x52c28bce, 0x29342526, 0xee1cd7f8, 0x92499079, 0x75bb98b1, 0x8b1d15f7, 0x03a97908, 0xf63315bb, 0x2997b5b6, 0x91595f6c, 0x807e759b, 0xe2fdec72, 0x15a2c68e, 0xf2974c46, 0xe3c4d2eb, 0x27015242, 0xd03dfea6, 0x3fed1ddb, 0x8e70329c, 0x869bea71, 0xd31c5575, 0xec193554, 0x0c3597ec, 0x91e140f6, 0xba69b574, 0x34820407, 0xde56226b, 0x2a556468, 0x60804e23, 0x2c31fd00, 0xe6927b93, 0x528f5570, 0x44c6fc86, 0x41ec771e, 0xd10e8361, 0x9c9472fe, 0x1c289fe5, 0x0cb426c8, 0x26c5fb0f, 0xae63888d, 0xe7490111, 0xb236a9f2, 0x50628726, 0x8e5f2594, 0xaa2069d1, 0x30db1597, 0x7eff07cf, 0x26525011, 0x73a40557, 0x70f8e721, 0x1fd5b502, 0x5394351f, 0xd54d5684, 0x38e5544c, 0x557f82ca, 0x0514f934, 0x509a24a4, 0x3156a8f2, 0x6a96abc2, 0xd309e990, 0xdb3a9c8e, 0xe4627276, 0x948d2640, 0x34edf392, 0x0890bde0, 0x2d7e1245, 0xd6d5b593, 0xa385bffc, 0xa30657b3, 0x62ebf4d5, 0xbc4bc3eb, 0x39c8425e, 0x13e29585, 0xa89d1581, 0xa75db791, 0x845199a8, 0x2d91ad1f, 0xb0e230d4, 0x2bd4fcbe, 0x3cae3da2, 0xd7024980, 0x4c45182a, 0x225e0033, 0x669e783f, 0x2c748ef6, 0x28d2c3f8, 0xd1480201, 0x7a2f0bc1, 0xb7fc1e3f, 0xc2a3d712, 0xa6409026, 0xa7da39e7, 0x8c09ce52, 0x000000c6 };
const u32 bern_num_data455[165] = { 0x1dd5cfbf, 0x08cac4cf, 0xbac6c748, 0x1187acc3, 0x458f0070, 0x93ef4a5d, 0xa1953c26, 0x444603db, 0xc71b555c, 0xeee2c80f, 0xdec325da, 0xd4a3a85f, 0xbbe609bb, 0x2ed1d672, 0x321e97c7, 0xae3f72cf, 0x14fb7819, 0x097e78f3, 0xd0ed2474, 0x96787fbd, 0x48df67b1, 0x727f9fe7, 0x5568d69a, 0x70d329d5, 0xa3b66f02, 0x5c88ff53, 0xf77d2bd1, 0x7a72f367, 0x6efbe2ce, 0x58e666f8, 0x230edadd, 0xa6ce4be1, 0x612d2be8, 0xd36b4296, 0xb3d7bb40, 0x56007253, 0xff73ffec, 0x6eb1287a, 0x3125103c, 0xad89ead7, 0x7a5d9c20, 0xf7c053fc, 0x8e180de4, 0xd225555b, 0x8880f1d1, 0x3a6c7cbd, 0x83be9e0d, 0x74b74804, 0x1cdfd32d, 0x9a7dde81, 0x1e904e40, 0x23ad3c4c, 0x8e5c1f50, 0x17132648, 0xd581948d, 0x28b50585, 0x064ad56f, 0xac76678f, 0xfe76d134, 0x11720720, 0x7116246c, 0x19037278, 0xd1a310c1, 0x2147e05b, 0xf17f584d, 0x19c5d239, 0xc43a1271, 0x55fca29e, 0x7145508e, 0x405ab84f, 0xb92df257, 0x4a80a78a, 0x16d603c6, 0xa3b2c5b3, 0x52c41346, 0x3ae57327, 0x64f40466, 0xec87b86c, 0x91f039da, 0xc1b12522, 0x7ddf5ae6, 0xf817963a, 0x3ddbf7ac, 0x6f325dab, 0x1cf7b8f2, 0xd69c5eda, 0x102a580d, 0x8bc34c20, 0x6773b7ef, 0xbace8587, 0x84b03ce3, 0xa6a44a6c, 0x4e12027a, 0xa9128ee7, 0x036095ab, 0x8942b3aa, 0x6ecdac21, 0x864d756a, 0xcfe83bc7, 0x0abeb1b7, 0x25be82ac, 0x85358c3a, 0x1f851c41, 0x30165add, 0xb7d050c8, 0x9e852d2f, 0x2c698300, 0xc395cfb7, 0xea816a3b, 0x367fdfa8, 0xdcd73e36, 0x0e144dcb, 0xe3f0af13, 0x1a853209, 0xe3e800c7, 0x3631716d, 0x23e9d9ac, 0x725f0d66, 0xca6d2987, 0xc7a0583a, 0xbe13fb0d, 0x0f6d6c72, 0x8e8827c8, 0xbd078ba2, 0x8e496129, 0x12089246, 0x919ff3ee, 0x778affe8, 0x2fa66bfb, 0xcc7cce07, 0x8800a1a1, 0xad71e5f4, 0x9b05c87b, 0xeab04c1c, 0x71a85bbb, 0xa42a3f5b, 0xd7f6009d, 0x6ff1ad71, 0x29eb39e8, 0x8481474f, 0x4d94d8e5, 0x6e82b961, 0x4e95e843, 0x421e03ee, 0x4dea2811, 0x07ea465b, 0x37e9b86e, 0x3408f6a4, 0xb23a2c07, 0xd6d31acc, 0x8812a606, 0xd0f8554d, 0x7407b3a2, 0x18dcd512, 0xeedd7989, 0xf89556f2, 0xa00efee6, 0x6170f370, 0xf37520a5, 0xa4ff41e1, 0x946b41e9, 0x0c96afd8, 0x83cbaa39, 0x3b994296, 0x0229be33 };
const u32 bern_num_data456[165] = { 0x4550175f, 0x0337cf39, 0xb78888ea, 0x8d849b3a, 0xb8d4ebda, 0xf6efd689, 0x9d96bb6a, 0x48bb5d6a, 0x37af3f2a, 0xe6244283, 0xfa7e8cb0, 0x8ff9bb07, 0x6ceeae5d, 0xe20a5cfd, 0x1ce8dac4, 0xeb8b4285, 0xa874cf28, 0x166b12f1, 0x92d8b855, 0x86863c9c, 0xc803edc5, 0x1fa38bfb, 0x5f642fdd, 0xe4a0fd79, 0xe2692118, 0x93434508, 0xf2df1506, 0xdc871bf0, 0xd7d1414c, 0x36b6f7a4, 0xed2f199f, 0x9d240fa2, 0xe546d40e, 0x4ccb19a0, 0xdbf13a92, 0x41bd8cfa, 0xf62d35d0, 0x51352781, 0xffc98ee3, 0x96c58134, 0x82a0ce36, 0x4b88b30f, 0xc8b2b55c, 0x77c319c0, 0xc3c95fc1, 0xc89fbb57, 0x6b1eee63, 0xbf89ee60, 0x1f99fc02, 0x297b5fdd, 0x301e18fb, 0xb5b7586c, 0x0d9da8ac, 0xb446c4a1, 0xa25b5508, 0xe4698be9, 0xee35f51c, 0x2fbbc2b6, 0x32d2b01a, 0xbd3e3344, 0x19921094, 0x2d214e7c, 0x826f069f, 0x457bd891, 0xe69fceff, 0xfc47b8ad, 0x1a683678, 0x96c9b4dd, 0xccdd6f28, 0x89904663, 0x2f8d4c5b, 0x8fe3f7f5, 0xe8992a8c, 0x854b3950, 0xe83643d1, 0x2369575a, 0x61d9d9ec, 0xc0ce3cbe, 0xfac44d36, 0x2a83594a, 0xe3a531f8, 0x7655cfb4, 0x0c2ece3a, 0xdcb1d012, 0x2e1489ac, 0xcec82430, 0x2b99cb21, 0xd2e152c6, 0x9a912099, 0x28f9de89, 0x1c3dc3cf, 0xe2cfa127, 0xff530c5f, 0xbe1fee4f, 0xc3bed1c0, 0x4e9517a7, 0x3395fb7f, 0x63a5431c, 0x0a255737, 0x3599f85a, 0x328d91fa, 0xa4b9680c, 0xd97f98ac, 0x8bb853c1, 0x9dac009b, 0xa693b3b2, 0x81b351d9, 0x1e415262, 0xeee47e3f, 0x55575411, 0xb75845b7, 0xba51488c, 0x4c56c26f, 0xd2562944, 0xd84267e9, 0x8355d573, 0x8f753cf3, 0x401c2ffa, 0x75982918, 0xb55d7d25, 0xecf81194, 0x06d95b90, 0x4eeb4fe8, 0x9119a892, 0xef9f2b07, 0xdc99c98a, 0xbcadfa48, 0xea155d57, 0xb0feae34, 0xf23c9d3f, 0x1d24a7e0, 0x363047e2, 0xd8c1942d, 0x73bb6952, 0xa6aa67a0, 0x92333069, 0xbf27aaa2, 0xb6d344fe, 0x2578cb16, 0xf786c39b, 0x9d215e80, 0x12402044, 0xbb4fb0d1, 0xaa2440e2, 0xe73a6cc6, 0xf360aa56, 0x37cb9ce8, 0xcf60d3ed, 0xe1219526, 0x326a11b7, 0x2f4f0e72, 0x640e3aa3, 0x4d60e6e9, 0xb51c6199, 0x5195a6d5, 0x467deef2, 0xb34a3766, 0x638f60aa, 0x72496234, 0x9b13407a, 0x27a16123, 0xc469a35a, 0xc001da12, 0x9e422961, 0x000003b3 };
const u32 bern_num_data457[165] = { 0x1e74aa19, 0x45af9ace, 0xf3ca7984, 0xbdc004e9, 0x58e57d91, 0xa86c8c55, 0xd271376f, 0xa8a7ae3e, 0x05fa086b, 0x1877c53e, 0x5e42b9ad, 0x8d37bad6, 0x9fd5a1cd, 0x822124e4, 0xc4e665a4, 0xb2c0f9fd, 0xca0a1f2c, 0xe702414d, 0x164e9c58, 0x99ab8448, 0x2e134a09, 0xbfb94081, 0xbe019d0c, 0x4b34d14f, 0x04d342ee, 0x59bd5fc5, 0x8c945766, 0xd44d21d6, 0x5d9ec443, 0x593228e1, 0xb7f28174, 0xef349074, 0xc5da852a, 0xfe4be1a0, 0x42e6fc99, 0xc8df97f2, 0x600ff683, 0x764c404c, 0x617086c1, 0xe1467249, 0x3beaf615, 0x0b28cafa, 0xf12d76c1, 0xdd60502f, 0x5c7775a3, 0x244e1159, 0x5b4e9902, 0x96e757d9, 0x5df44002, 0x8f2cf878, 0xe2444c89, 0x5a0cd3c0, 0x78a2946a, 0x85ca40f0, 0xfcc7e679, 0x134ed138, 0x97c578ac, 0x794ede82, 0x426dcb7e, 0x6b69b337, 0x1a669ad9, 0x3962dab4, 0xa65f4d73, 0x8cdba27d, 0x9023e808, 0x5ad89d3e, 0x67b1b9ee, 0x1f0f9c43, 0x9523165f, 0xe05714f0, 0x9e7e0c53, 0xdbffc8f0, 0x340660fa, 0xd0dba4bc, 0x5fda4c9b, 0x27b9c4eb, 0x654d84d4, 0x2d57ea77, 0x540b0ca4, 0xde14114c, 0xa428dfa4, 0x560436be, 0x055a904e, 0xc58c5957, 0xfc8176c1, 0x04f7186c, 0x6eb8fd0c, 0xce9952c1, 0x8c25f5d3, 0x499e17a8, 0x7f5a635d, 0x7149d14e, 0x94d0ed38, 0x099eb279, 0x700888b1, 0x78889bee, 0x59e25ff7, 0xcedc3424, 0xf93ba264, 0x4225b0ac, 0xaa181df7, 0x40267e59, 0x0ce715e7, 0xf78ccbba, 0x049a5656, 0x0740d77a, 0xd28afba6, 0x6a1cd4cc, 0x7516c9ee, 0x12439f4c, 0x3dedac4b, 0x1ae537ae, 0xd7ea5fb0, 0x676659e3, 0x848b2ad2, 0xa171e671, 0x4962914e, 0x0dabba83, 0x8d0634c1, 0xa1a2bd1c, 0x59906a4c, 0x0c205164, 0xccb557b4, 0x2b86c375, 0x5b0cc28f, 0x0bc23d60, 0x7a883a6a, 0xa0363e4c, 0x03506cba, 0xa140050a, 0x066f885f, 0x3532028b, 0x20d87ddf, 0xf0228a3e, 0x4c066548, 0x3f59ac27, 0xba1174fe, 0xd2360f19, 0x6443ae6f, 0xd476310c, 0xd0daf8b1, 0xb9092161, 0xd22f2cd1, 0x92d769b7, 0xa05a5ed8, 0xfd238ec1, 0xe03acaa7, 0x9a82b194, 0xe9c1b2ac, 0x7b4961c9, 0xbdce328c, 0xea7e5978, 0x7a82c3e1, 0xf53ad57f, 0x9c53aabf, 0x1c029d4d, 0x3468b142, 0xe271024e, 0xc67fdb2c, 0x3273d8ef, 0x9618afa5, 0x15ff5e31, 0x5a176832, 0x27baedf2, 0x05fee697 };
const u32 bern_num_data458[167] = { 0xd3ee5c09, 0xd5b5e655, 0x3edfe0c3, 0x88f8193f, 0xec84ba9c, 0xedbe7826, 0x986aade9, 0xc6076d2b, 0xe47ddd7b, 0x51f018c0, 0x167645a3, 0x0bb38e9b, 0xe1633c63, 0xb589c473, 0xfaca4cc6, 0x11d3db2e, 0x9b1386a2, 0x38bafefb, 0x265d44c3, 0x478bdb4e, 0x9584f81c, 0xee10feaa, 0xa2d22975, 0x2f63a805, 0x1fa8c85a, 0xccb0dd2f, 0x0b3f1bdf, 0xa81dc0e2, 0x3143548f, 0xe16f294a, 0x10524f4b, 0x4e408c4e, 0xfe929180, 0xb9bcd965, 0x31ffad15, 0xa5883254, 0xaa7a9cad, 0x201df674, 0xec1dbbd0, 0x2abccc34, 0x58dd5a73, 0x55789503, 0xa834831d, 0x22dfdea7, 0x696ab81f, 0x92757842, 0xfe2ff4d8, 0x8348a55c, 0xf904999f, 0xd9c3922b, 0x7bdc4c7e, 0x86cc5d57, 0x58b66316, 0x514c7aa1, 0xfc69399f, 0xb4c73b7e, 0x80df4aa8, 0xffa7e92d, 0xe65df044, 0xd2933b84, 0xfa695ad0, 0xed729dd4, 0xf5d903f4, 0x3683c4aa, 0x677064c5, 0x15e28b44, 0xc86f79c0, 0x2285e089, 0x83dda6c3, 0xaaa67803, 0xe52f5405, 0x3f4c15d9, 0x081687f3, 0xf5b21be5, 0x80fdf8b4, 0xc32c8f68, 0x3a089f3e, 0x536eca1d, 0xc36310d8, 0x149f0e4d, 0x27aa2cb1, 0xa7deb4da, 0x15e23c27, 0x86680b18, 0xbcba765a, 0x98cc4aad, 0x0de5f7b6, 0x04c95d71, 0x11f30295, 0xa3f6cd4d, 0xb3e6d5a5, 0xda2e18bb, 0xa11466a3, 0x95b9a1e1, 0x11ae9a67, 0x2c50b682, 0x3e3ab53f, 0x13ff2e8b, 0xaaae39e7, 0xc0c00656, 0xd8aad009, 0x17831be5, 0xa79cbd05, 0x256bf708, 0xae59af75, 0xae91a75c, 0xa763ca5d, 0xbdb5e189, 0x21a0f17c, 0x362a3ea6, 0x6e973304, 0xbeb66d72, 0xde60bb72, 0xcf2996c1, 0x19d119d3, 0x9be06edd, 0x46a14931, 0x2621c9db, 0x151d8d33, 0x40777781, 0xb023e5f5, 0x6702f7ca, 0xdc8cdb51, 0xf5e6a4a1, 0xbddd3bf6, 0xf2645266, 0x992fd9ef, 0xb3039272, 0x16b97393, 0xcd886b91, 0x876e0d3d, 0x8ba48cce, 0x741113fe, 0x8025a015, 0x2675a770, 0x39463dcc, 0x50284700, 0xd9f7b138, 0xd4c18c67, 0xdcf5a614, 0x05107c31, 0x2c6f8a1a, 0xc2cd740f, 0xcb19dff6, 0x5af0e711, 0x530554b2, 0xb432470d, 0x9ce82eb2, 0x0ca3c7ed, 0xa886e583, 0x5dd23736, 0x449b312e, 0x95836b5e, 0x1eaaf950, 0x200f287b, 0x88b11513, 0x6ae4c333, 0xcf693e49, 0xe7e9a3f8, 0x79c38bb2, 0xc7427a80, 0xa72bfa80, 0x607be489, 0xf6613be5, 0xfa84ab09, 0xe1692bf8, 0x00000059 };
const u32 bern_num_data459[167] = { 0xdfa303c9, 0xe315be22, 0x8f0412c2, 0xe3786255, 0x64027b3b, 0xe1fc704e, 0x48d0faa0, 0xf900f1aa, 0x614f3263, 0xd1cd29a7, 0xc16a89c2, 0x134f99e8, 0xb46af0a3, 0xfa7a4fd2, 0x110a3283, 0x7fe495af, 0x4a11ef62, 0x4daa0517, 0xb786750f, 0x80e52a78, 0x9b7d4960, 0x03a2b8d3, 0x7fa6da4a, 0x629224d3, 0x609ced0b, 0x631b7237, 0x41661921, 0xf1f238ff, 0x128b5ef8, 0x6eb5bf1a, 0x6b3c028e, 0x5833abcd, 0x7f934a84, 0x5be0dc54, 0xca5a2654, 0x51a7b7dd, 0xe784d25c, 0x44ec369e, 0x6db2e1e3, 0x3f6fe2c9, 0x9c062b07, 0x8b94f7be, 0xc909558f, 0x59196653, 0xbdb7a5e7, 0xd6897695, 0x3cd97549, 0x70ec23a2, 0xcf84b33a, 0x81f03bdd, 0x66d505f6, 0x2b1c9980, 0x0c862d2b, 0x15b967b8, 0x66f12ba0, 0xc0afab80, 0x0d6b40c6, 0xed617b3e, 0xe958ed7a, 0x358926d5, 0x997c0da7, 0xee1931cc, 0x5dc4e828, 0x10af50ec, 0x9b69b342, 0x444cc2c6, 0x8c033c9d, 0x0d757fbc, 0x3ff95999, 0xb05478ff, 0xf908f841, 0x5d10cbf9, 0x337a56f2, 0xe3b760e9, 0x03ca607b, 0x442a2f85, 0x323a6384, 0x74398529, 0x6264cd0b, 0x931ef971, 0x092d166b, 0x2455bdc4, 0xe67bec91, 0x4edc8d85, 0xeae54639, 0x50ba1254, 0x761b0358, 0x7dd33843, 0xe3195a98, 0x3f536928, 0x462abd21, 0xe84b558d, 0x4660f34e, 0x551b99aa, 0xbbcef109, 0xeb2be536, 0x2edcb6fa, 0x63070f2f, 0xa3026a45, 0x48b933e9, 0x21b7f112, 0x898d8f25, 0x6d11317d, 0xf5660699, 0x851bc124, 0xab5ff9af, 0x1083e1ac, 0xb90b845f, 0x113f8c03, 0x5666c9c9, 0x9e11218a, 0xcecf75c6, 0x0b3993eb, 0x2c77a796, 0x6adbc188, 0xd3e4e154, 0x2802a5cd, 0x0722feea, 0xb6d32f25, 0xecac81f6, 0x45df57af, 0x8e509848, 0xeb15ec5d, 0x276e2bfa, 0x5769d0e6, 0x0adc593a, 0x2ca6ae92, 0xc302aece, 0x6ea0dd17, 0xee0aefb6, 0x257a100e, 0x032f9da7, 0x1fecf19b, 0x3494d57b, 0xf9bda43c, 0x5f59721c, 0xa4902420, 0xcec05547, 0xd5307bb1, 0x909da324, 0x59795453, 0xc62573a1, 0x4c9b4eb7, 0x7657d06a, 0x4e9f9d19, 0x38c2c7df, 0x9bafe6b0, 0x62452434, 0xa07eefa1, 0x87422de8, 0xc0fb6e64, 0x163d969b, 0xc203c67c, 0x9b656a4a, 0xd07b4bef, 0x2ccf2db2, 0x10c6f347, 0xb6a613e0, 0xdb560114, 0x516bf924, 0xf0937f32, 0xabfe4af4, 0x06dff207, 0x6f068bc5, 0xd938382e, 0xe64d10ae, 0x00005f0d };
const u32 bern_num_data460[167] = { 0xdba5478f, 0x371f8c21, 0x173fa983, 0x2aa84f2b, 0xecb32035, 0x90f57af7, 0x10e26de9, 0x08597492, 0xde792f44, 0xda38da12, 0xe75d7b96, 0xed7313c4, 0x65ec5c2b, 0x99755638, 0xf9fc04f6, 0xc254b924, 0xc8d6852d, 0x2c3b98b4, 0xc11b5b96, 0x0f7ed5cf, 0x46a0f4ff, 0x2d870685, 0x7211812a, 0x9f20a4e7, 0x3a40440f, 0xad883a76, 0x48c34541, 0xce8d79af, 0x0aba13f5, 0xaadc7922, 0xa0f91e73, 0xb917c586, 0x9db485f4, 0x0743f512, 0x6b2896e2, 0x880acacc, 0x06913199, 0xaa230cd3, 0x0ab07fd8, 0x5e9856ac, 0x0df959ff, 0x49d3694d, 0x45b2c97c, 0xc1fd66ca, 0x2b936143, 0xa17a844b, 0x3d97b764, 0x681b7976, 0xd7120a84, 0x1171dccb, 0x1047003d, 0xa1419225, 0x6bd9029a, 0xc456517f, 0x1b8d4d0c, 0x64df9b55, 0xfda50c37, 0x4f60ee20, 0x481922f2, 0x3b33fc06, 0x93a30f0a, 0x9f964d7d, 0xa7c74681, 0x9902a825, 0xafd85246, 0xe2b5d048, 0xc13bfd52, 0x1e7004c0, 0x77d731c0, 0x419c0c58, 0x7bbfb7e1, 0x3deaae44, 0x7aa305b3, 0x67f0b151, 0xba5334cf, 0xf4347eaf, 0xbeb1fe29, 0xdc518654, 0xb109602f, 0x8ee33f6c, 0x0d21529b, 0x7ea609b1, 0xaeef33f8, 0x513e2941, 0x92c1ab65, 0x184084a6, 0xd1be2da5, 0xe95f73fe, 0x9cb43cc5, 0x1a6a8f3e, 0x10b45888, 0x746fc310, 0x63cddd37, 0x947cdac2, 0x8fd4335f, 0xa181d1fd, 0x59e2a609, 0x778f8475, 0xe8e4c16e, 0x3534fb22, 0x9a6de885, 0xe3a6108c, 0x73d56af5, 0x5ecd2ac9, 0x09db5fe9, 0x5a79640a, 0xec37da87, 0x9b54fda1, 0xc480046f, 0x415f4b21, 0x9a94e4d6, 0x04dfaf75, 0x98961b30, 0x5103564e, 0xa03cdad7, 0x77146b8e, 0x5824dafa, 0x3733ab9b, 0x90363fff, 0x1cadd5b3, 0x7c2c0798, 0x6ab3a874, 0xe1c734e5, 0x3e297b3f, 0xf1f2ccc3, 0x994cf5bd, 0xba82b33b, 0xd4e65984, 0x16e849a4, 0xe70558c2, 0x9aaeadb1, 0x02607b5c, 0xf71b70b8, 0x9d511ca3, 0x0a2b58ea, 0x458202c3, 0x73445121, 0x8fac2c23, 0x97340310, 0x31fe7e04, 0x7e13ab20, 0x7cd8dd4d, 0x51020ee7, 0x6475c475, 0xe2c7df17, 0xee155aec, 0x976f0ac4, 0x5439f6ee, 0x3f4ea6cc, 0x7e5dbe91, 0x74cf5973, 0xae2c27b4, 0x237947d9, 0x47b6e1bb, 0xb6eef329, 0xee0dad5a, 0xa352e022, 0x5f588b4c, 0x4e1c6004, 0x3dc89e4e, 0x0c9450e3, 0xe8650b3b, 0x10842fa2, 0xfa0bc80e, 0xeeb5e8e5, 0xb670af4b, 0x0000000a };
const u32 bern_num_data461[168] = { 0xd98f390f, 0x558c5665, 0xc05999bb, 0x11a06c2a, 0x751efc16, 0xe22ccce1, 0x7d7b64c5, 0xc86b9f35, 0x62f4dd26, 0xcc815d31, 0xa45ed58e, 0x8407540a, 0x5ca46620, 0xb4c36634, 0x062ff223, 0xb3238adb, 0xa7abbbf8, 0xec62246d, 0x3ea85c42, 0x3bc0f2ba, 0xd5e972d3, 0x9a8ac918, 0x39283605, 0x2cbf270b, 0x2ae4baf3, 0xb6920261, 0xe4bc4638, 0x54da6d2f, 0xfd6037fa, 0x1e8ac80d, 0xfeced521, 0x1accd8bc, 0xc2f2fcd7, 0xa325ffab, 0x1bb08be7, 0x69da1726, 0x3e62ea7e, 0x2b3ad012, 0x8ccf1f06, 0x81258b0f, 0x743e52f0, 0x133679b4, 0x41b77a33, 0x4954fc5c, 0x2c554974, 0x88ebd3c6, 0x3c0aa777, 0x8358b963, 0x6a79bb57, 0x94ea7cc1, 0x783796ef, 0x302b22d7, 0xe3e011cc, 0x72621c6f, 0xc6ed55dc, 0x81494e0f, 0x39b565d3, 0xb25f1830, 0x8cc37462, 0xf13d6566, 0xd47e8621, 0xa1522e46, 0x7b3bebc3, 0x93c3cf09, 0x34703bae, 0x6d6244b7, 0x8cef78b1, 0x91e04fd0, 0x75011f6f, 0xb2b5ad1d, 0xa80692f2, 0x902514ba, 0xfdb88270, 0xfed99a71, 0x413725b5, 0xeb80d338, 0x5fefced5, 0xf4ee045e, 0x55ba4c4a, 0x261a6305, 0x979fecb2, 0x9c63bd2b, 0x5d3289d3, 0x7a16fa4b, 0xf65d0205, 0xc546141b, 0xcd853abd, 0xb95f7aba, 0x23137baa, 0x07aa3999, 0x724d5c40, 0xd80a893c, 0xe05dee05, 0x18e836c7, 0xeaf0fe14, 0x72869c1a, 0x68ae4621, 0xf74c83c0, 0xeeb9d805, 0x459901e7, 0xad0de5c0, 0x0f727741, 0xdf77d8cf, 0x70864a48, 0x905e0cdd, 0xb8286466, 0xab67ce89, 0x585846bb, 0xa1833b9e, 0xe8ad9409, 0x14922b75, 0x5e74c409, 0x65872edd, 0xfc45b1d6, 0x30fa95c1, 0x5c21c4f9, 0x46748d90, 0xdea8e9a6, 0x58d53823, 0xf6f7654c, 0x7bff3347, 0x9c730c29, 0x8a539e2f, 0xc6b02ac2, 0x8a141990, 0x5c2cb1c5, 0x5081da74, 0xbbaed645, 0x70a79af6, 0x14a746d6, 0xa3da943a, 0x94276e92, 0x0fb27a02, 0x2c5e7608, 0x5717723e, 0x0fe2b67c, 0xbcabb850, 0x5fac6fbd, 0xb17d2adc, 0xbf89a0c0, 0xfe0d11b0, 0xb71c3700, 0x6187b211, 0xbd2deb29, 0xbb99a1ce, 0x192b0108, 0x79951c49, 0x0037c60b, 0xb097122f, 0xb58e1060, 0xf8115483, 0x3035cf97, 0xdf7f0b94, 0x6899fa1f, 0x3f2078ec, 0xd8caf901, 0x1575d3ee, 0x55a162a4, 0x1ee86f7d, 0x9c648b2b, 0x70e13749, 0x7080d35e, 0x3cd84068, 0x9369c067, 0xe6918b7c, 0x18f3fd23, 0xfeb7d7d0, 0x014cd682 };
const u32 bern_num_data462[168] = { 0x68a61567, 0xc019b8c4, 0xbadb2001, 0x833e0437, 0x8ceeb822, 0x8ee3b41c, 0x42d02a53, 0x6e2526bb, 0xce5db1b5, 0xd9bf4b66, 0x15154624, 0xf458ee7e, 0xc62e5123, 0x76d45f84, 0x43b1c12a, 0x403e7413, 0x2ddad282, 0x98a6644d, 0x8de141e5, 0xa1db9d84, 0xe8a52cda, 0xbc3aed57, 0x1b099621, 0x2a4f5fea, 0x001c6305, 0xc881a888, 0x1eecfecf, 0x18eb9bd9, 0x3c444323, 0x56818c1e, 0xff9a753c, 0xeca2769f, 0x8102b9e8, 0xbeba1b55, 0xb0eab1cc, 0xec832b82, 0x7cf565dc, 0x3e200223, 0x55dd5db4, 0xabfa6dcc, 0x943e9267, 0x1ffd64bb, 0xdceaa036, 0x8ad42044, 0x987d7351, 0x1d4eb3b8, 0x8dfc2730, 0xfbc74279, 0x9bc92e95, 0xcfce59e8, 0x50580258, 0x17104018, 0x34d0507d, 0x43af24db, 0x16b9bac0, 0x4a68d118, 0xf5c2ae48, 0x7cba6c21, 0x37339720, 0x42839835, 0x9bc25053, 0x48f35f17, 0xab27d1eb, 0x1cc035e5, 0xe31abd7b, 0xec7b2297, 0x50114a75, 0xbf97d249, 0xe63abb14, 0x70c4c278, 0x494e8ae0, 0x74a81a49, 0x707010f7, 0x80f098ea, 0xb82dbfba, 0x5e497d7b, 0xd7bfafc3, 0x45b38639, 0x88a1c54a, 0x6f8c25f9, 0x73977029, 0xd3460115, 0x40c7ebac, 0x6983f2c0, 0x2ccb2220, 0xe09699c6, 0x1f7eeff1, 0x5f0ca73a, 0x629a27a8, 0x32f53505, 0x934448af, 0x5ab04963, 0x5a424c65, 0x4e04c945, 0x294c49a5, 0x03ec0175, 0xab58edba, 0x5d6b1938, 0xcb9c2335, 0xeb3520a6, 0x502cabdf, 0x44412d46, 0xcb050560, 0x3962f582, 0xca639953, 0xb01c9339, 0x19ab8556, 0x09cd1e1b, 0xd679c5d9, 0x0492e492, 0xccf86b21, 0xda67328c, 0xf728c773, 0x41f56ae8, 0x2767ec11, 0xa7ff9948, 0x2ecdf20a, 0x73d8973b, 0xbd8838ac, 0x5d216219, 0x228109cb, 0x1dfdec12, 0xe877cbcb, 0xcb1ea1eb, 0x3f188b88, 0xcd19a2ce, 0x8f8eedd3, 0x3e4188b6, 0x9ed80f9d, 0x3505ce40, 0xc34d3385, 0x0313f63a, 0xaad158b4, 0x0d3c719c, 0x62ea318a, 0xace474a7, 0x93ef5428, 0xa279fc28, 0x17baa449, 0xa4447474, 0x50e49965, 0x52faf9c1, 0x406141ea, 0x8a2ac967, 0xf23ce198, 0xfdb0659d, 0xf602dd81, 0x404fbe5a, 0xe2bd37aa, 0x1043a4ee, 0x45ad0c46, 0xeee4d588, 0x7ff3b77c, 0xd16a9811, 0xc8a49160, 0xab56f024, 0xac1e0b18, 0x6417c7e8, 0x7853f52d, 0xc7679096, 0x23297f0f, 0xbafd3ed9, 0x8e065319, 0x8be24044, 0xc9325b88, 0x5d3ad90f, 0x2b48d4ba, 0x00000001 };
const u32 bern_num_data463[169] = { 0xfe388f53, 0x76be46ec, 0x65c8bbb7, 0x9af1f629, 0xa30603a5, 0x8298020b, 0x644728a7, 0xf924c9d7, 0x62828cb5, 0xb035c83e, 0xbf6f1ac1, 0xfbe5cae5, 0x62562e1e, 0x902e6f30, 0xb5c3e0ab, 0xd513fb9b, 0xa90f0346, 0x4a4d9dda, 0x41aba31a, 0x217dab98, 0xdb26b22a, 0x6e50b2c4, 0xf3858afc, 0x5f1c0a17, 0x23a4e3b6, 0x14cf0a6c, 0x3a5c4943, 0x54d24b90, 0xcaab25a7, 0xfc0c3235, 0x53f4b90d, 0x6723f1ed, 0x0c153acb, 0x61a81629, 0xaa4040b8, 0x02e1bd20, 0x5edb1a6f, 0xbe6c74fe, 0x8ab40a1b, 0x02a69ead, 0xda6259ce, 0x3ad5b19b, 0xd0580093, 0x1bd8f433, 0xac82a6ec, 0x3a655fe4, 0xa1f6631c, 0xfd8c60f7, 0x6e8fab44, 0x118eccc7, 0x19249d22, 0xed46514d, 0xf4da2113, 0x4094d2d9, 0x7442ee56, 0x220404ec, 0x63671f67, 0x24848f68, 0x36d159fa, 0x23374f57, 0x98a1fc47, 0x4e70d433, 0x038f7e6c, 0xf2dc120e, 0x0610245e, 0xee40eade, 0x121c2d3d, 0x99947d7c, 0xed55ce7b, 0x977a7f4c, 0x80a3c25c, 0x818a9b5d, 0xe4237a74, 0x33b2abb7, 0x7b8fcbd8, 0xbaea8b3e, 0xf4ca6d48, 0xd2560abb, 0x20811c0f, 0xddcbeb11, 0x32ad7d8f, 0x9a526434, 0x7b3f4d01, 0x6f265473, 0xd53dd07f, 0x2bf625a2, 0x3e5ae308, 0x193b2875, 0xe328fb21, 0xbd9ae10f, 0x043cf65f, 0xfb22b5dc, 0x3b8596aa, 0xdf55e658, 0xa27eb108, 0x8bb8f9ba, 0x524bba1a, 0x45ec9ade, 0x4135420a, 0x1dc772c7, 0xcdb7ab1c, 0x3fd51f4b, 0xb68b9632, 0x2f24fbdb, 0x7dfbc8ad, 0x4032feb4, 0x3089a7df, 0x56b2b706, 0xdf71febb, 0xd6ab35b4, 0xff844938, 0xcf93f694, 0x691e8049, 0x4058d1b9, 0x4d74e6d4, 0x4caf4ef0, 0xc6b28830, 0x5ea4839d, 0x1a037973, 0xbcc653d0, 0x42e961e3, 0x7c764325, 0xf0706127, 0x41a8d284, 0x3903ff0d, 0x5cdd1cf8, 0x960dd646, 0xca80e387, 0xb89dfe17, 0x9fb10053, 0xaaa4b7ca, 0xcb4a6ce5, 0xa2aab502, 0x4c593f4b, 0x19a155cd, 0x3c1ca5b8, 0x970dcb7a, 0xac30e355, 0xcb40f059, 0xa679b632, 0x0b65bee6, 0x124a4cc8, 0x18e0969d, 0x671d7be3, 0x9981223a, 0x2efba3f2, 0xafd9bbed, 0xe575f680, 0xb45fe5a1, 0xeaa8fefc, 0xad091b4b, 0x2048f3eb, 0x6d255dda, 0xb6c4ae4b, 0x4d5e47b7, 0x45c0baae, 0xd0ed6ac9, 0xb0495b09, 0x2bb64736, 0xb11cfae1, 0xfa9b63c8, 0x2352df59, 0x3a6946b3, 0x3a48da54, 0xf6b59909, 0x72ff5e8f, 0x15a5393b, 0xa6dbfd08, 0x00001926 };
const u32 bern_num_data464[169] = { 0x631f90eb, 0xb9d59d32, 0x0a744ee8, 0xfed0928a, 0x8545677a, 0x4ed65fbb, 0xa9583f84, 0xe0c65461, 0xa2e14f89, 0x93997f9f, 0x9af1f554, 0xc27240a6, 0x19a03110, 0x20e2396b, 0xb2602db9, 0x8d49b898, 0x9f11a4b1, 0x4df9d45c, 0xa216ea72, 0xf9baf7ee, 0x0170f243, 0x68e3ecf5, 0xd500c12d, 0x4390c081, 0xb948aa2e, 0xc853233e, 0xf8aa3c7f, 0x4cfe98d4, 0x572bf003, 0xf1456397, 0x6cf07e5b, 0x3c5617a1, 0x3c6b370b, 0x2a6700de, 0x05281f6f, 0xa7727eac, 0x9f6d9916, 0x5009f423, 0x181f1fb6, 0xdbe9f06c, 0x26e6f101, 0x3e174801, 0x2b2b9c41, 0xf10eff4e, 0x3b493fc5, 0x681ea665, 0x6b46b7b3, 0x48fd6828, 0xa82404cf, 0x3df04793, 0x5cb72e3b, 0x1d16232a, 0x7e27aaf9, 0x6fb9f554, 0x4a6fac4b, 0x24ffb890, 0x78a75686, 0xde291d28, 0xf7966f63, 0x38504707, 0x0cec4e09, 0xefd10910, 0x45b29b66, 0xd44fa24a, 0xd1d05f1c, 0x9a5bf0f0, 0x466b4925, 0x40f479b3, 0x8c2ba048, 0x52fbc908, 0xd2e6d681, 0x6a58b078, 0x2268c473, 0x3e582c25, 0xa5be73ca, 0x6a7c35d8, 0xffe4f1f5, 0x304f3ef5, 0x3608d5be, 0x8dff860b, 0x651be3dd, 0xf449d3ef, 0xe0dc19c1, 0xcecec06c, 0xce4c6871, 0xaf83ccd8, 0xdb66f4d2, 0x65991f48, 0x8a6c6936, 0x97694bfa, 0x3232bfdd, 0xe000d3ff, 0x02dc80e1, 0x95021716, 0x3a74596e, 0x9330a8bf, 0x23d8dec2, 0x0c1eccc5, 0x46c8af8c, 0x5ebc5835, 0x56e91c3f, 0x2b26412d, 0x86bc59ec, 0xef2bc45a, 0x3bf4fb32, 0xc30d7614, 0x6b6c692a, 0xe2066126, 0x753536ba, 0x86eab9e5, 0x58775331, 0x4bd9abe6, 0x1b619595, 0xabfc2467, 0x1107a8c4, 0x63c6ec2b, 0xf83cdf4c, 0x40fcbd99, 0x5ea77491, 0xb9d605d0, 0xa7ee2b62, 0xb6717fc5, 0x4ce8285e, 0x63cc3113, 0x219b4650, 0x2da9806e, 0xdd48f462, 0x4cf2dd27, 0x8b37c42c, 0x901c8300, 0x61916148, 0xf6ec3738, 0x304722d4, 0xdbc38efc, 0x51f0ff87, 0xc40a4b56, 0x04dc02de, 0x3438efc1, 0x66915a75, 0x43c82bb0, 0xbf671436, 0x43f85874, 0x4eb3b1dc, 0xa9fdaf19, 0x6b4df946, 0x52913f22, 0x7319cae6, 0xd151dd7f, 0xe5a714ec, 0x71426bc2, 0xcbc8c74d, 0x3c386160, 0x360bbf55, 0x74267fee, 0x124e6f7f, 0x80c958d4, 0x2889dee5, 0xc1c32934, 0x0409f5ab, 0x6edcaacf, 0x0c765862, 0x65bcfe88, 0x668bf597, 0xaaf49b45, 0x1463dc58, 0xdf28b53f, 0xa6707d1e, 0x9f28c4f4, 0x00017869 };
const u32 bern_num_data465[169] = { 0x5c0b6efb, 0xa75a6780, 0x17f4c835, 0x383a8093, 0x32225da4, 0x2ac817f3, 0xcaaf38e2, 0xc28268b7, 0xa6f88cc5, 0xc69464c3, 0x559e0942, 0xe87aa355, 0x31771c38, 0xcce85359, 0x54787760, 0x8f87c50c, 0x32046a9e, 0x89d4ac04, 0xf1b12f33, 0x80b392ec, 0x47ae2434, 0x2ba16d3e, 0xbdc365b3, 0x9f1e830e, 0xdb8a4fa9, 0x12a786bb, 0x55a2087f, 0xc785b308, 0x56b02a5b, 0x25b4a899, 0xf2b0e772, 0x83c95e1c, 0x88d0e4fe, 0xffba7574, 0x5b7e9a07, 0x3dfc82bb, 0x5e260dbb, 0x74aa5bd7, 0x23e343b9, 0x6fc0bdb8, 0x6052cfa2, 0x1f05b26e, 0xc43784fa, 0x1a991566, 0x6cf1954e, 0x80ed4ece, 0xc491d2d4, 0x64d4bbd4, 0x5031e1c7, 0x3a5f3ea6, 0x9942d3b4, 0xe460a8d8, 0x13843dc9, 0x2c5897b9, 0x585759e9, 0x22cc2fc6, 0xed89ff74, 0x6db22613, 0xd74014be, 0x85a6a4c0, 0x86e84b15, 0xd471aa53, 0x13081457, 0xae7bfd48, 0xcb6c7a1f, 0x629ae4bc, 0x97a3898d, 0x8741011a, 0xbedda169, 0x64ac681f, 0x649ae4d2, 0xc9c5dcdb, 0x76403ed6, 0x5520d073, 0xc66d6ec3, 0x494c7edf, 0x178260ad, 0xfadd3a89, 0x06a1a3a5, 0xa2543f2f, 0xda88b3ab, 0x4767088d, 0xdf6b56fa, 0xd65ad77b, 0x3de28a05, 0xee0c676c, 0xb33014d2, 0x39f03507, 0x82675913, 0x64c4b5e2, 0xa3c98718, 0xf8b192a0, 0x2e01228c, 0x28855a6e, 0x856808f3, 0x6ae515d7, 0xd569b859, 0xb2471273, 0xc5072bd8, 0x34c5a361, 0xe9d22ffe, 0xceae8ee4, 0xff0084bb, 0x6c1a54b9, 0x184c0931, 0xc508fb91, 0x51897f22, 0x3f20b4ca, 0x92100467, 0x6c7c8ef9, 0x0d422f06, 0xa153a66f, 0xaba5de58, 0xd58e30dc, 0x098a6dbf, 0xd425c798, 0xa56d2b6b, 0x21d3ef7c, 0xefd7648e, 0x9a0d3f5a, 0xbdfd52f4, 0x4e74f273, 0xb976828c, 0xc4c4ed70, 0x562fb7db, 0x646ffc0a, 0x76ee24b8, 0xf7e1f4b8, 0x0853e487, 0x2c9fd5b7, 0x8ae4530d, 0x0929598f, 0xef0dbe61, 0x99f3d360, 0xad0bf029, 0x96ef1e7b, 0x7ac17f4a, 0x2bce308a, 0x21bbd89d, 0x56ecfc7f, 0x9f2c6656, 0xddb4c87d, 0x00c28304, 0xa952feb7, 0xb3dd66d0, 0xa5f9ae28, 0xfba83f1c, 0xcbcf213b, 0xb95e2f63, 0xdf571a64, 0xfee7e63c, 0xc08cd8ff, 0xec3e181c, 0x8a5315bf, 0x4deb23c1, 0x7c14f8a2, 0xdf9915ac, 0xbf57e936, 0x9b21da54, 0xe453277c, 0xbb73c94b, 0x8a96dc52, 0x25e6da18, 0x10ac02b6, 0x1f227ab4, 0xde48e06b, 0xeff377a3, 0x17502e1d, 0x0065a634 };
const u32 bern_num_data466[169] = { 0xdf4d8c97, 0x29bd0834, 0x80c1f09c, 0x5fa38de6, 0x403be67a, 0x7306a6a0, 0x47dec624, 0x457c0ac3, 0xa1329de0, 0x55b8701d, 0x32dd47c2, 0xc0be8caf, 0xa0dff94f, 0x67b19053, 0xcbc967dc, 0xf0dc1795, 0xc14880e1, 0x2728dc38, 0x7c799d48, 0x6d19c882, 0x75af631b, 0x9d5b4623, 0x6dce5d5f, 0x0f2667de, 0x122666d3, 0xf85b8e8e, 0xc7a8aa44, 0x416839b6, 0xc8928f60, 0xa0d2f7aa, 0x8b172ecb, 0x329203d3, 0x3e404956, 0x8f84d000, 0x99d81657, 0x7b5dc340, 0xc99fdbba, 0xb4d28080, 0x06c38bf7, 0x2c29b58f, 0x90f2c735, 0x96f306b8, 0xdfd64d2b, 0xc1e48b6f, 0x18f11810, 0x2c4865d9, 0x54aa876e, 0x3dada271, 0x7bce2498, 0xb749e80b, 0x775e1b8e, 0xff3e91aa, 0xf640f35c, 0xa57e3187, 0xf5832593, 0xed4c54c1, 0x684e83a2, 0xf51e2ebb, 0xe7469e14, 0xd6b82616, 0x87df75e2, 0xd925a125, 0xcff743bc, 0x03e9bbca, 0x395043e7, 0xa3fda70b, 0x5a7ab71f, 0x68340a26, 0x0fff0119, 0x66f5dbe0, 0x2fdecd97, 0x41209fd0, 0x0c0bdf8d, 0x5c58e2e6, 0x7ad8f788, 0x0b61bb2c, 0x0c493b18, 0x7022ba51, 0xc92c94ff, 0xc129fb1d, 0x07bde6dc, 0x2ebc7e0e, 0x27a4cf37, 0xb0191f46, 0x102806e8, 0xf0c180a9, 0xca3d9a3b, 0x0309a43d, 0x9ccd15ba, 0x3f724c0f, 0x13a3d1a8, 0x7de6a382, 0x94e88e9d, 0x32960c2e, 0x80520ddd, 0xf3099483, 0x11c4d5be, 0x10fc15a0, 0x0c56a0b0, 0xbbff6d54, 0xd44c3a15, 0x8a646915, 0x1880169e, 0x18f0a1d1, 0x9530849f, 0x8c9988a8, 0xcd453cf7, 0xc6d033a5, 0x58428140, 0x966e6fca, 0x4392e322, 0x295cc5f1, 0xe72fd79c, 0x7d6997fd, 0x476e5f88, 0x286653c5, 0xde829872, 0xa9483440, 0x6279532f, 0x1c4c2932, 0x60bc2a9b, 0x736eee1a, 0x2d6427ed, 0x52cd41c5, 0xf684e23f, 0x1cdb6655, 0x13982c95, 0x8cc60d28, 0xe420442e, 0x8ac4e6d7, 0xf7e46da9, 0xf07fc905, 0x2332f076, 0x562cd08c, 0xd12a062b, 0x4f60b629, 0x996e202b, 0x00f0e1be, 0x80d5f596, 0x4893bf24, 0x34e995a3, 0x710bbfec, 0xd28bbef9, 0x0c8b3478, 0xf0c43f69, 0x0e0c968b, 0x416773dc, 0x0853d0ec, 0x1d231a45, 0x147fa2be, 0x98370085, 0x9bf19c34, 0xb93bd4b2, 0x2c5516de, 0x91170eff, 0xd3352bde, 0xa285cc01, 0xcd9fc842, 0x5add7e9a, 0xfaa318ee, 0x140a5dca, 0xcb5d350e, 0x35468154, 0x994eb507, 0x2937dbb9, 0x88387c75, 0x888af848, 0x9c61b100, 0x03c0ead2 };
const u32 bern_num_data467[172] = { 0x1f81de63, 0xda58a6b2, 0x41873cd9, 0x32573eb1, 0xc100d1e4, 0x97d2fb7f, 0xc9fc30f7, 0x83b339fc, 0xe06febe9, 0xa46e64d0, 0xa7cd0b89, 0x64047c52, 0xda87fba1, 0x35439636, 0x7ef7d01b, 0x78bce188, 0xe97c22a7, 0x7157c755, 0x09bc96ad, 0xdf85d1c4, 0x55e5a1f6, 0xa82decb8, 0x0b456096, 0x8a60fb26, 0x12e72eda, 0x42bcd534, 0x09883052, 0xabd53501, 0x2fb5f44a, 0x7195ff65, 0x5bdfc94d, 0x685e040e, 0x340f5d22, 0x57a51324, 0xa1efe641, 0xfbf6ade8, 0xc025ff78, 0x4d1c5940, 0x06e0fc6a, 0xa245507e, 0xc14a99b8, 0xdaedfec0, 0x45219258, 0x791e632c, 0xd06c4b25, 0x0b1d63e5, 0x0b54eb03, 0x4749a3e5, 0x5a003040, 0xc7cbdad3, 0x03377f43, 0x7877d116, 0x5cb809b0, 0x034757e1, 0xcbb9e063, 0x098500cd, 0x70ff496d, 0xbbccd723, 0x8019ab35, 0xa3ca4c8f, 0x7f8277b1, 0xa2fc7427, 0x0fcda3ae, 0x1a94ff93, 0xf0704cb2, 0x13be3c8f, 0xc125213f, 0xa86e9038, 0x225af0fd, 0x0f5f200d, 0xdbabb19d, 0xa5292382, 0x38841c2f, 0x2f1709b7, 0xbb853030, 0xf6aec48d, 0xbfdf1d32, 0x9ba2e6cd, 0x7b4e791a, 0xa820762d, 0x814ac1d1, 0xa6e7950b, 0xd4ebafb3, 0x82c48f10, 0xec025fff, 0x76bf4336, 0xdaa88299, 0x0a93d0e3, 0x697317c9, 0xdba9f00a, 0x61dc80f5, 0x278b433e, 0xd65e1da5, 0x4df4c85e, 0xa0c56184, 0x6068fedf, 0x733475f3, 0x6db9b478, 0xae385695, 0x0907405e, 0x3825b125, 0x8da7767f, 0xc6341db1, 0x1b77a82a, 0xf44afbe2, 0x8b09e92d, 0x8ebf7d6e, 0xd33b094d, 0xcf416b8c, 0x9ee10d0f, 0x07aa1c46, 0x5310d298, 0x10406774, 0x3dc115ad, 0x29d4750e, 0x0cbf3f76, 0xc65b48fa, 0x8b645a9a, 0xdf1a5710, 0x47b1658d, 0x73b60056, 0xab53ab46, 0xed21dbd2, 0x121ed647, 0x13e48176, 0x3b3ee146, 0xc6a33669, 0x67cec5e3, 0x64c886f6, 0xb6d2dcbd, 0x7409a9a1, 0x30f9fdc4, 0x493c7a15, 0x46e79503, 0x93618064, 0x1d74d217, 0x9c2d2c96, 0x8d678e59, 0x51441308, 0x4df39ebd, 0x520386d6, 0x84df4533, 0xfaee1db2, 0x2e0dff92, 0xcbe74127, 0xaf6f9c70, 0x1bd0af3e, 0xa52ce815, 0x6f077c43, 0x92fa2bd9, 0x4371725e, 0x693fdc0e, 0xe2081b62, 0x13af56af, 0x7790c6e1, 0xbbed0711, 0x62d24c42, 0xecd51b05, 0x03251f79, 0xd0fb7456, 0xe627597e, 0x1a00b6c3, 0xea6996de, 0x9c27125c, 0x6e0357e1, 0xed98c927, 0x98c09667, 0x34604f60, 0x663d8c05, 0xd7eaeb8b, 0x52452a32, 0x0000004f };
const u32 bern_num_data468[170] = { 0x182a15ef, 0x8dd0eae2, 0xc67c0f1d, 0xea48fa50, 0x49a5f1c7, 0x333d1f49, 0x0c13954f, 0xa7342b87, 0xd947f956, 0xf20325d4, 0x33745076, 0xbf17ddd0, 0x2d2c274d, 0x6db013b1, 0xd6602ffe, 0x7322a01c, 0x2e3a07f3, 0x05ec8862, 0xfd9803fa, 0xc587bc0d, 0x9afd4856, 0x72b08729, 0xba22d474, 0xe6438ae2, 0x196a863a, 0x01b6473f, 0xb0f23c51, 0x394c2962, 0xde5f1bc3, 0x0d45df76, 0xb99625d6, 0x206c18f1, 0x595d9bfc, 0x051fa874, 0x417d153b, 0xeae973dc, 0xce805849, 0x3d501ac4, 0x02f976ff, 0x88d0b825, 0xee1565d6, 0x8d8e665c, 0x3ed2b5e5, 0xb7271843, 0x33727288, 0x2202ce72, 0x8c9b872f, 0xcf15cc18, 0xaf037768, 0x1576cf28, 0xb69c2937, 0x50bebf54, 0x16d8b08f, 0xa4fe97a3, 0x85aadf82, 0x832d229c, 0x4085e25e, 0x0cf41e88, 0xea938bcb, 0x9456fe90, 0x7bfb347a, 0x528d4c51, 0xb50a082c, 0x9a8995c4, 0xa4e67929, 0x7201fb4d, 0xb29ff89a, 0x572fa7cd, 0x595543ab, 0xf3e2968d, 0x9b2f979f, 0x4be16e8a, 0x3a5e4071, 0xff3d5d91, 0xed9dd350, 0x2202990d, 0x35072021, 0xc31d5fc7, 0x7400bd1d, 0x9768499c, 0xb4957637, 0x0971e027, 0x8d339132, 0xfff7c01d, 0xd37aaa4c, 0x2a16cbe7, 0x022f2968, 0x9ae655db, 0x81ad378a, 0xc9188b52, 0xc46de892, 0xc5b9ae7b, 0xddfcaec3, 0x8700223f, 0x60949787, 0x1b803da7, 0x3f567c60, 0x1e2aa676, 0xf33865a4, 0x366af469, 0x98f7b266, 0xcb65af12, 0x7865ce0d, 0x71f3a339, 0x7c2f32a8, 0x0d99c219, 0xe80dfee3, 0x682b52bf, 0xd953a3f5, 0x49db5299, 0x213200fc, 0xd89970f6, 0x520878f7, 0x31d07aff, 0xb128e728, 0x17b5a220, 0x38292573, 0x7803a7ef, 0xfeb2d121, 0x3a0addea, 0x663c3d76, 0x3a7965b2, 0x8429dc43, 0x6e3baf08, 0xb12c3ba6, 0xec452952, 0xc0e13392, 0x46d5d809, 0x7c94c96b, 0xa13b0f14, 0xa5b091f9, 0xca8d30f4, 0x4c85c9cb, 0xf24e3288, 0x61cdc831, 0xf4269908, 0xbc3a8057, 0xd0504321, 0x85e4d1ec, 0x45594404, 0x7469294f, 0x2e66dc9d, 0x872be5cc, 0x9a6ea844, 0x5d20add7, 0xe2a8e20e, 0xe4040536, 0x2ee29703, 0xd6ed6abe, 0x5b88eecb, 0x7c59b07e, 0xb7f4872b, 0xeebef1b5, 0x7f858497, 0x7b6fc662, 0xb6e254e2, 0xf342a300, 0x0b75d808, 0xdac28b96, 0x00c7d0c2, 0xc5495edc, 0xe7083e97, 0xe79187df, 0x759528ac, 0x24e7e211, 0x3b58476a, 0x1664282d, 0x2a0f710e, 0xb7840c28, 0x006e6aca };
const u32 bern_num_data469[171] = { 0x1a47ac27, 0xbc30274c, 0xa68e0d5d, 0x20c6cf6a, 0x9f6831e3, 0x1a482d03, 0xad8de409, 0xd511a7b5, 0x7b1f95ad, 0x792d4fd1, 0xfaaf6735, 0x9b451bd3, 0x9b81746e, 0xa91c70e6, 0xcb9c1b79, 0xb3a75ef2, 0x768e8e00, 0xfaab7abe, 0xd2beef3b, 0xb259dae0, 0x19e94454, 0x06c806a8, 0xaba80def, 0x34084257, 0xa359f59f, 0x41f8a842, 0xdaa7286b, 0x07a1dadd, 0xb50d6c7f, 0xa5c74ae4, 0x1a66575f, 0xdf12a7ca, 0xf62a7074, 0xd12948ef, 0xba7a00be, 0x9bfdcab2, 0x0851cbba, 0x3ea81da3, 0x764361e1, 0x445145d3, 0xd6217766, 0xcdde8c1a, 0xdee58a9e, 0x3160f925, 0xd44f8ef0, 0xf9383533, 0xf2d907f4, 0xfe155be5, 0xa3b4ff96, 0x456a7161, 0xed2c9d97, 0xee2ea710, 0x3f7b7bcb, 0x60e00c08, 0xd77e87e0, 0xb1edb8ba, 0xeada8fbc, 0x1fb3a28d, 0x821217c0, 0x2c98361c, 0xc3f3d0c0, 0x1765f60d, 0x45217de9, 0x04647608, 0x6a1437f5, 0x23e94d5f, 0xca48e676, 0x1ed43ad5, 0x0b9af0ae, 0xaf44a4c7, 0xf3f05f93, 0xf83896e0, 0x246f7191, 0x02eea4bc, 0xb4fe2bc3, 0x727a8498, 0x00a62834, 0x233a186f, 0x1b585ade, 0x37616039, 0x6ee7674d, 0xa85f6217, 0x45ac7c51, 0xfb45519b, 0xbf00d650, 0x0d19c308, 0xc01e2ec3, 0xb01544eb, 0xd8929d7c, 0x29d59b4a, 0x03e63557, 0x0a3c932b, 0xf70eb7cf, 0xb4eec2d6, 0xf3eef7ad, 0xa09e17a9, 0xaf284c27, 0x791007fa, 0xb1439df2, 0x39dfcdbe, 0xb35dd99d, 0xb4987e92, 0xe6e2ab5e, 0xcc7fe5ae, 0x12828656, 0xb1f07459, 0x9f1f6761, 0xf7797e8a, 0x646c9f64, 0x80f9684b, 0x4961f5d5, 0x5c66cc04, 0x86a25496, 0x2ae92c5a, 0x910a4001, 0x4260bd50, 0x7e5165e6, 0x749ee37e, 0xa746cae4, 0x8bb09607, 0xbb2c2f82, 0x22477e1f, 0x3ceeb876, 0xbac5b9ee, 0x11b23bb8, 0xe67c7b64, 0xb295c8a5, 0x3950337f, 0x30ff4f64, 0xbe1cc494, 0x940b0e2e, 0xbd5c73af, 0x2cf02070, 0xf9c47f06, 0xe252e58a, 0xc560540b, 0x1c8b6a96, 0xd09277e5, 0xb784de7a, 0xf4dc5141, 0x4f54e7fe, 0xb782254a, 0x5379a821, 0xe73919a4, 0xac80ef94, 0x26ba7e2a, 0xf84569dd, 0x15b127aa, 0xf3876c9d, 0x85aa5b53, 0xa6ddeb65, 0x2741c6c5, 0x4f64fa25, 0xd67ca872, 0x08dc07ad, 0xc603018e, 0x245df433, 0xf02ea710, 0x5482e923, 0xd9e5c81f, 0xd20ae3da, 0xcc6f2809, 0xc7b4c4c7, 0xa5baeb28, 0x5f46195c, 0x20e4c72e, 0x9f8c90e1, 0xbc65156c, 0xf4433b17, 0x1ef2300c, 0x001dbf93 };
const u32 bern_num_data470[171] = { 0x9265b071, 0x2cbdc1f6, 0x1764e92d, 0x3c2c6e90, 0xf95be710, 0xf816f580, 0x5917828b, 0x2f245f2c, 0x5c7041c6, 0x7fde351d, 0x60c10d82, 0xf7117378, 0x1070f48e, 0x5be5eda3, 0xf90bd793, 0xcf654828, 0x3a698a09, 0x92a3ede3, 0x32d00853, 0x344ba2fc, 0x65f17e11, 0xd2066fb8, 0x68329495, 0x3bc02943, 0x704612f0, 0x96e521ac, 0x263d6eb5, 0xa4cfed8b, 0x2e60f872, 0xc2f5ea78, 0xce88c0f0, 0xeb6befcc, 0x0b6e7c89, 0x650c09ac, 0xc0472687, 0x8e905b69, 0xc88af1e1, 0xb0c1f1bb, 0x0584ed31, 0xd51c5bf2, 0x6fd294e7, 0x3e06d434, 0x888ae7b2, 0x92fc5860, 0x7c05e769, 0x1097ba68, 0x50b51884, 0x1f263cb8, 0x8b5826f1, 0x2e3eb7f5, 0x0d6563a1, 0xe13af827, 0xf29c7bcd, 0x824ef3ed, 0x36c62da1, 0x286e178f, 0x7b5413ef, 0x6b0251d7, 0xa9a4962a, 0x9ed77d70, 0x5aae9ce7, 0x56dbca6e, 0x9e30d279, 0x97cc53f0, 0xe3805616, 0xb2c1968e, 0x9a7a2909, 0xe9d198de, 0x3186a90c, 0xe1a4ae24, 0x1d4718ad, 0x87b00fe5, 0x63fb6ec7, 0xfdb4d69f, 0x657746ba, 0x841d5f79, 0xa310beef, 0x0cdba591, 0x4279ae3f, 0x77baf258, 0xd77b2724, 0x5f220063, 0xc3191eba, 0xf88c60fc, 0xcb9363af, 0x7b22f2a1, 0x256931da, 0x1e8c420d, 0x92e3cac5, 0x3fa8e36c, 0x8086026a, 0xa60f0c7b, 0xe1e6391b, 0xd72f0d44, 0x5c8cd7c6, 0xa269e38f, 0xe62e1f51, 0x8edeab66, 0x1892e00f, 0xfc411406, 0xb132e7ff, 0xddc25ef1, 0x4844f19b, 0xaaef7d80, 0x32897d42, 0x4abe4b1a, 0x5b07bc6a, 0x94ac57fd, 0x92a474fb, 0x3635ba33, 0x4444b73f, 0xa7668e35, 0x6a029654, 0x359ed39f, 0xd0435c85, 0xa6bb2f3b, 0xe9ec1922, 0x5b0565e4, 0x86dc5d81, 0x6726875a, 0x53fcf054, 0x2632fe58, 0xda41e1af, 0x0faaffb9, 0x008e46df, 0x95711876, 0xf64f7737, 0xcc50c2ca, 0x46eb818f, 0xd4aeb985, 0xf87bd925, 0x601ad27a, 0x8e6d27dd, 0xf96f6a68, 0x525fa66a, 0x7aa532ec, 0x5dc2c915, 0x14b01543, 0x81328b01, 0x44828f15, 0x0e83b99a, 0x8cdafcd4, 0x86f35904, 0x6edad744, 0x11dc618f, 0x8a6eeb72, 0xd68c40f7, 0x6049e8ec, 0xc3dade25, 0x6654b1ef, 0xa8ec507d, 0xee587458, 0x9d3316ab, 0x0fe2cd4d, 0x4dbd7c90, 0xfc07cfc4, 0xdf473a4e, 0x857e7a94, 0x473318a8, 0x3c7954fd, 0x42d07686, 0x01de9bea, 0x652b66e3, 0x5a793a54, 0xa59109fd, 0x04c664ed, 0xbb5caf02, 0xc6f94a8f, 0x519eeacb, 0xefec166f, 0x005a5786 };
const u32 bern_num_data471[172] = { 0x28940361, 0x1d10d719, 0x8fa5a33a, 0xa95f4d80, 0xb1d1866b, 0x6d55b763, 0x28707b4d, 0x39064a13, 0x96de94a5, 0xb5b734be, 0xc5edd94e, 0x1eb82623, 0x0b6c1700, 0x518aa5a0, 0xa8d3108e, 0xa94e8b89, 0xc9890278, 0x4290948a, 0x0fdd6470, 0x7408fc18, 0x62726d85, 0xac5ab797, 0x28703bc0, 0x5fac70e9, 0xa394000f, 0xaf17a171, 0xbe6a2e6c, 0xc26ef1c4, 0xeaf0b482, 0xf04341a8, 0x6bfabf2e, 0xec7f867e, 0x2fb9b8b1, 0xd6e97823, 0x93b6c9b3, 0x22277672, 0xc280dc38, 0xed16ee87, 0x0cae58d8, 0xe859232e, 0xc67c7fa3, 0xc6fcd798, 0x1e97c288, 0x6113bf27, 0x8b94f7b2, 0x14a09ae7, 0x7a028f4c, 0xd1406e8d, 0x3e62c761, 0x99c6f76f, 0xe9785efe, 0x58547343, 0x1b6af282, 0x075cb4f9, 0x12021a7f, 0x4aa512ac, 0x9244375f, 0xe0869cbc, 0x55086914, 0xe05d5f02, 0x15232a6a, 0x421a33ac, 0xc417f1d6, 0xb6b482ea, 0xa7490330, 0xa05bbf24, 0x034a5911, 0x45938923, 0x0f34fa8b, 0x6f125464, 0x64eed54c, 0x16a22acd, 0xf9e74a0b, 0x51bfe5e8, 0x5320309c, 0x8a893009, 0x3bc194fe, 0xe539614c, 0x691017cb, 0x16e2bf65, 0xf1bbf8e4, 0x196ea0b1, 0x26a60e84, 0x67f7ce09, 0x98129dec, 0x801f3898, 0x69142fc1, 0x1b8ea63b, 0xe82f88fe, 0x834c480d, 0x5738afe6, 0x5077ec66, 0xb2ee3fc4, 0x6017620d, 0x8c2882ea, 0x4250c3ea, 0x7788f010, 0x2e8f78e5, 0x25e5294c, 0x0deee6c9, 0x4c92284a, 0xa124856b, 0xc43543ce, 0x566ba644, 0xc9799263, 0x9ec7b272, 0x43c17015, 0xb75deeab, 0xfcceb613, 0xc4970712, 0x62bd18fa, 0xcd495a7c, 0xe4b88b99, 0x8a9b65bf, 0x5e1b71db, 0x3610db4b, 0xea5aaf8b, 0xcbfea4d7, 0x3d081f3e, 0x9ee0672f, 0x6180397b, 0x7bbf8824, 0xeb25baab, 0xaf887d24, 0xaeb3b9a4, 0x25b46b99, 0xea100dc3, 0xefe01a34, 0x28ad8f0a, 0x9d90f35b, 0xa01cb341, 0x9c472fb7, 0x0353da6a, 0xd43ca81d, 0x1d7d0224, 0xb113aa73, 0x8c1bb0b8, 0xa47d8f7f, 0x13d2efb2, 0xfa8b1356, 0x0a31ce1e, 0x2bb8b096, 0x64923373, 0x5791966f, 0xb41335c6, 0x2621fe0d, 0xf190762a, 0x26513b61, 0xb1700f48, 0xc5588f5f, 0x0dbf5bb0, 0xea8263af, 0x98d4bb55, 0x56c72aff, 0x33409af2, 0x23a99500, 0xa48189d3, 0x9f7edf71, 0x4c7f30c8, 0xf81a96da, 0x2d37390b, 0x6a0e830f, 0xe0806685, 0x7b4ca4a5, 0xd556d4f8, 0x5158e94f, 0x194a6bbf, 0x983e49ee, 0x2f58d629, 0x2e401913, 0x7205d445, 0x00000179 };
const u32 bern_num_data472[172] = { 0x6645118b, 0x34eb0a34, 0x3f8a5bfe, 0xf9bff58a, 0x8b87e117, 0xe8039395, 0xe783e95d, 0xcb56456d, 0xe45d58ef, 0xfe5e4345, 0x00093efe, 0xa133b614, 0x75763280, 0x345524c2, 0xa00da804, 0x35015130, 0xfe9d94bd, 0xbbd2b1ec, 0xbdc321cb, 0xe72ef2f5, 0xf59fdccc, 0x80e0c082, 0x5babc76f, 0x75467866, 0x64c8d88c, 0xbb57c58e, 0xb5006dfd, 0x47eb6287, 0x8f67a3d8, 0xbd80cb6f, 0x4ff814bf, 0xa53683d3, 0x59f3eab9, 0x8d85f3a0, 0x7db90604, 0x9ec4ab7f, 0x6a0db569, 0xbec1c9d3, 0xe6eff931, 0x0435e547, 0xf208bd47, 0xcd2e2cba, 0x07d897c9, 0x8c630aed, 0x96f4e062, 0x0ec84090, 0xd4b5fe56, 0x029adb35, 0x18450e4c, 0x9a4dc1fb, 0x967d4917, 0xe0f0e383, 0x03fac6d4, 0x8d2c824c, 0x32d827b5, 0xeb8cd5e2, 0xeea73ac1, 0xd7dfe918, 0x83379f3d, 0x894794f5, 0xe0bfc253, 0x7afa73b1, 0x9aa761b4, 0x9df1f273, 0x467a124d, 0x3330dc69, 0x08888bbe, 0x544cf9bf, 0xabe22ae5, 0x4ef141be, 0x94262c8f, 0xa223cbdf, 0xafbb7ea4, 0x6ff1601f, 0x92137ef1, 0x8a57cdd8, 0xae1cf183, 0x5cc71373, 0x7756b8ce, 0xb359828c, 0x7c041352, 0x3365336f, 0xba255d7e, 0x98c3c77d, 0xc783b926, 0xa0c3e0f4, 0xaee8bcda, 0x500caaa8, 0xfdf0158f, 0xb8fd87ee, 0x25bf21d5, 0x8daa898a, 0x92613b29, 0xa5e43dab, 0x040c99fe, 0x0182cc27, 0x1a5e5cb9, 0xceaae401, 0xb042675e, 0x2e7bdde3, 0xf703b06e, 0xeca7b2da, 0x68c48d1d, 0xc595aa6d, 0x410b85bb, 0xbdbedf1f, 0xf3949b08, 0x99d61511, 0xb52a4c94, 0xcdc5ab36, 0x8835dd41, 0x3c219955, 0xf19fbb52, 0xff320ad8, 0xa2ece408, 0x74f7d3fd, 0x888de0d5, 0xfbca5971, 0xa28e205c, 0x2c0c5a6a, 0x27d53c15, 0xb11a532a, 0xb8f36c00, 0xa4905cdd, 0x4d3cf256, 0xda16b6d4, 0x7449fea4, 0x82e42584, 0x8effa144, 0x53f762e1, 0x62f17655, 0x275b0ab7, 0x039e3ceb, 0x86132116, 0xf2deb620, 0xab9c907c, 0x05cc8a8e, 0x834c03ab, 0x423d5026, 0xbc32b64b, 0x1c2a4136, 0xc070dbb5, 0x3501f5e9, 0xf646a6bf, 0x3b013cd6, 0x4cd3956f, 0x858ee03d, 0xe63a8a77, 0x6d55a45e, 0xdea14ead, 0x8ceb7397, 0xb4f67680, 0x1b071951, 0x4413a38a, 0x93739b09, 0x948326ce, 0x874d639c, 0x1ce39301, 0x138742a0, 0x4345b24a, 0x5dbf66de, 0xe28fd153, 0xe9b63d1a, 0x3c2fd438, 0x76040c8d, 0xecb4c2c2, 0x761401a0, 0xefb2c763, 0x133c6c65, 0xb5382612, 0x7f4fbbdb, 0x828b383e };
const u32 bern_num_data473[173] = { 0xbc5064d7, 0x8b6dcaa5, 0x017ae327, 0x1ea42dc4, 0x5f96be8b, 0x120c120c, 0xce03a4d7, 0x326e24df, 0x99be1fcd, 0x34b40158, 0x30c52cf3, 0xe3c5f754, 0x93e4ac98, 0xbd6bb6a8, 0xa36681e7, 0x45e74bf0, 0x26f80c25, 0x53b880c3, 0x268cd6de, 0x08231269, 0x17133376, 0x450ed8d3, 0x4b09936c, 0x28b5e76b, 0x7f76d0fb, 0xafd13363, 0x2a031a70, 0x724281b0, 0x12afe3e3, 0x97c9d353, 0x3701b083, 0xfd78a56e, 0xd75fedbe, 0x8f633746, 0xb0744f8e, 0x61697ed7, 0xfc1b64db, 0xa244a20c, 0x8c8d0ccf, 0x8fe2709c, 0x17bc7bbf, 0xce8d6d51, 0x3ca5d03f, 0x9bc4a516, 0x7aa50820, 0x37781825, 0x7dd088fb, 0x78df75db, 0x2b81b499, 0x4d2fc569, 0x771172ca, 0xa1080f85, 0x14620b42, 0xe3e0b871, 0x3f5aecfe, 0xca971042, 0xddbb8395, 0x7a9f54d9, 0xa9ab5770, 0x51e87064, 0xf6bb1163, 0x87e5fc9d, 0xa2aa2cc8, 0xdea5ae11, 0x10ea8761, 0x7eeb3878, 0xdc1084b4, 0x395c7c5f, 0x4c90878b, 0x0d799634, 0x13123017, 0x89925b1b, 0x0b109107, 0x217b854a, 0x24a62b7e, 0xd50a5bd4, 0xbb8a7f8c, 0x0deccb5a, 0x31c4c792, 0x6b114f8a, 0xc9f8ddfa, 0x8817d4f4, 0x10f8fb5f, 0x1582245d, 0x348a8791, 0xc1c933d5, 0x8e124010, 0x93ecda5c, 0xd5c88dc9, 0x07e57c5f, 0xb70b3e89, 0xb6d39f41, 0xfdb6be79, 0xc57d8353, 0x919af9e5, 0xecbde4d8, 0x4fcb3d54, 0xc7f8f942, 0x8ffab281, 0x5ceb17e5, 0xfb98f7b2, 0x7bdd2b08, 0x8d02fa3b, 0x86e12b5d, 0x26558b4d, 0xc6bb1bee, 0x5f178ffe, 0x9ab9a15d, 0x7160ab5c, 0x3280c2cb, 0xbae80542, 0xeadf49c4, 0x67232e45, 0x4678fcc8, 0xd73fb3f2, 0xce03f841, 0x524d018e, 0xfc14cd9a, 0xd27cb9df, 0xdf107580, 0xbdbc6834, 0xfa2f4af1, 0x540c6dfe, 0xf17b3d92, 0xd4838a51, 0x46ab288f, 0x70c44651, 0x3f30d79d, 0x6e7accbd, 0xf2fb3edc, 0x76523bdf, 0xf91c56a6, 0x6df7c9f8, 0xd84c57df, 0x9d15ad46, 0x9891e2cc, 0x0bbaae55, 0x937c2872, 0x0efe8247, 0x37d7057a, 0x89a5cd0d, 0x84060259, 0x47e46fa6, 0x7e5f2baf, 0xfa47e372, 0xa101b4bc, 0xe55e9de4, 0x44a7f6e1, 0x23e4dbd1, 0xafc1d947, 0xac8e499a, 0x478a9e6f, 0x90a74207, 0x9e96ae00, 0xfbe06958, 0x71df507f, 0x3264c234, 0x120c75c4, 0x7ef46f4a, 0xbf86e35d, 0xee4984af, 0x8fe6be8d, 0x7b352856, 0xedec6418, 0x88dd699f, 0x1539d916, 0x02bad9c9, 0x4d0eb53f, 0x40fb5429, 0xcc378b26, 0x5a0f3606, 0x8db63268, 0x00012bf6 };
const u32 bern_num_data474[173] = { 0x259fb323, 0x36985263, 0x6fa26409, 0x6505c314, 0xd4737caf, 0xa216ef25, 0x349e08c5, 0xdc88b6da, 0xedd3ab6c, 0x89f5c57e, 0x9495525c, 0xaca14534, 0xe046e548, 0xdff7af85, 0x36bc73f4, 0xa1a1f473, 0xe9a2561d, 0x03503a01, 0xfbdc85ba, 0x818c1f07, 0xa1ee788e, 0x035ecfe1, 0x01bf118e, 0x6b98ac13, 0xa7bf633c, 0xbe376ac3, 0x77599c08, 0x4c9021d2, 0x603c0c19, 0x7281d111, 0xd254c5e7, 0xc3c84ed2, 0xdf09eaed, 0x3dd1ddbc, 0x10772dfe, 0xacfbc99a, 0x9633fc89, 0xfd14df5f, 0x78763526, 0x73b96831, 0x8fa64d9a, 0xf2bda99e, 0xb43166e3, 0x4ff8da93, 0x09d86ec7, 0x28f2862f, 0x24270b82, 0xdcc1dcf0, 0xa92cc98b, 0x8384f24c, 0xfd8a3d11, 0x02593576, 0x1756886d, 0x420d1c21, 0x4d1d5681, 0xd0f0285c, 0xabfc0ead, 0x37f10413, 0xc54bb4f5, 0x7f1994d1, 0xca13d93d, 0x670d0e50, 0x34d6c8f7, 0xc0d4d758, 0x8f4d7928, 0x53f3e019, 0x64a3433c, 0xcbfa1a4d, 0xa475efef, 0x7c4e3082, 0x00eb15e8, 0x6963c391, 0x59af25e9, 0x12f0c788, 0xfc47fe71, 0x34eed5c2, 0x8d22facc, 0xee90d0c3, 0x54336dda, 0x67008f56, 0xa3a29339, 0x9f9d4c7f, 0x815689dd, 0xbb35fcdb, 0x042684c1, 0x6a4576ec, 0x815c83eb, 0xbbf38c6b, 0xbc78143b, 0x3f36ba04, 0x0bdf4520, 0xc5d1244a, 0x51d80f28, 0x2fd480a0, 0x05c7a63e, 0x459dcc62, 0x7139b2d5, 0x9651e49b, 0x1d176b07, 0x6a046923, 0x88025908, 0xbeb865c4, 0x0c98eead, 0x5a1c34c1, 0x48c4e909, 0x32934139, 0xc5209543, 0xa7c59192, 0x6e68da86, 0x9c7249d7, 0xc16d7e1b, 0x1ce0b9db, 0x47cfd08e, 0x5ba77831, 0x6e375583, 0xb0658d62, 0xfc77628a, 0xe45067ec, 0x572aab06, 0xbce28789, 0xe0d73d35, 0x87ff2422, 0x92b1745f, 0xd7d18b61, 0x67f8923c, 0xcb195d38, 0xaf2ff0ac, 0x3cb336b8, 0x1a2648d9, 0x0ac943f3, 0x0ff24667, 0xc60033b6, 0x75f64a50, 0x80f55827, 0xd9c8ce5c, 0x7ef67ddf, 0x19a14e1a, 0x7115aaf9, 0x5258765b, 0x11e158ce, 0x10777e97, 0x4756cc96, 0x5777dd12, 0x048af71c, 0xd0271350, 0x1f8c21e3, 0x8a13e13c, 0x6eadb8d0, 0x13de1426, 0x38ae03cf, 0xe07eb94a, 0xbe5ccc88, 0x0825810f, 0x41a3bb15, 0x820c2d86, 0x6ef8cc6c, 0xdc215c82, 0x42736103, 0xf73b8309, 0xaa0596b6, 0x79633a64, 0x2bfdfe35, 0x8c8c95a1, 0xa4f78d4d, 0xff7754eb, 0xbebaa5cc, 0x8c221539, 0xf1afaad0, 0xbb50deca, 0x8e3dc27f, 0x03bc2fb6, 0xdfc76cb1, 0x0185c640 };
const u32 bern_num_data475[174] = { 0x2ef808b3, 0x285d256e, 0x1efa1a57, 0xc51b1342, 0x58d79662, 0x8577f896, 0x03fe7dd0, 0x082fc018, 0xcc86fe88, 0xaa0cbb6f, 0xbe636f74, 0xc98d838a, 0x1307960a, 0xe1d084cc, 0x2bea560a, 0xe78e66bc, 0x971b195c, 0x1d17bb81, 0x51f98bb6, 0xef439e29, 0x9642715c, 0x4d3aaf1f, 0xc150f0fa, 0x0d502cc1, 0xc3912aff, 0x61c9d38e, 0xdb2c696c, 0x29ed32fe, 0xbb61727b, 0xfa558ee9, 0x922312f3, 0xb1728849, 0x4c418c0c, 0x521d63e8, 0xe6cb7908, 0x0595b00d, 0x9c2d20ab, 0xd38703d2, 0xdc685901, 0xd013e224, 0x461341df, 0xfe961c43, 0x7c2899af, 0x0604ad0b, 0x308b7f36, 0x530ee0d5, 0xeef95092, 0xcd392acb, 0xa1ecf8a8, 0x4db8e2bd, 0xde34296a, 0x941cb28d, 0xf598476e, 0x13279ea4, 0xeb30a61d, 0xf1cdf673, 0xeb0ec911, 0xa19af0b5, 0xfbe1b16f, 0x783477f3, 0xb1617a26, 0xa764cd8d, 0x0beac587, 0x3ef986a9, 0xb281ee48, 0x52c5aa0c, 0x84999919, 0xf97563ec, 0xa4de1dfa, 0x6fe3dde1, 0x1d0b383c, 0xfcbfabd1, 0xe66a7a97, 0xd81e0524, 0xe7c049d8, 0x37b76c6a, 0x1b47c8f2, 0x243a4bf1, 0xeacf6bd2, 0xae2c35c2, 0x66bcca30, 0x68da7a24, 0x2a33d7a3, 0x64208c85, 0x36238269, 0x58800117, 0x90ceb460, 0x7ad9e5a7, 0xeeabd1a3, 0xcc387f43, 0x84e51b49, 0xbdf0accb, 0x61ed9efa, 0xe30de369, 0x1ae2fe17, 0xdeed57c5, 0xd89562f4, 0x1abe18f8, 0xee91cfd9, 0xe6986b83, 0x12ec2cdb, 0xeebfea3e, 0x05a9cd94, 0x44247516, 0x642a40fb, 0x9706a699, 0x7242c307, 0x6520a22a, 0xc6627656, 0x79610199, 0xe7b0ca2a, 0xbd3a959e, 0xf27dc564, 0x516200d7, 0xa1fa9982, 0xe487277a, 0x605c9634, 0xf8ee0e9e, 0xd237c75b, 0xad6a93b6, 0xf60fcb1d, 0xecdbaa01, 0xe280dbe9, 0xd6708dc6, 0x2482fcc7, 0x8fbed8ea, 0x7e933c22, 0x44c576d4, 0x267311a2, 0xa89a038a, 0x8df4b3c8, 0x76079d52, 0x0c49f257, 0x64afa1f8, 0x6d11a98e, 0x6f5e3b11, 0x0707b899, 0x865bbb0a, 0x0c6072bc, 0x384b8b30, 0xb040d92e, 0x725213ee, 0x9aededc0, 0x2cf92795, 0x5fd70b4e, 0xea315c17, 0x5f2dbd0b, 0x3f8cdc8c, 0x3e7f75af, 0x84d6b61f, 0x7461c67b, 0xcbf69082, 0xe3769271, 0xc5d33d98, 0x9c8bba18, 0xd4e4ff9e, 0xec3d6442, 0x77b9feca, 0x416fa605, 0x62661d4f, 0x2ffa5686, 0x9bbe3e34, 0xafc74628, 0x1392be32, 0xb1fd5d88, 0xdbfbc352, 0x2e33f6ca, 0x586cda66, 0x6c1e0eb7, 0x6d3ec180, 0x1c42f8d7, 0xba66da98, 0x7678c08d, 0x1181eca6 };
const u32 bern_num_data476[174] = { 0x1b177b99, 0xe8ce4b01, 0x08b39c56, 0x8492f57e, 0x70138e94, 0xa6f6a980, 0xc51e1ff9, 0x40c24d79, 0x2bb51c99, 0x260f6afa, 0xdbba0a75, 0xc3fe6e2d, 0x83ac82ad, 0xd1610128, 0x3e1000d8, 0xa83aee73, 0x939744bb, 0x81e23de2, 0x4e62dd5e, 0xedc6a28c, 0xdce425a5, 0x398aa127, 0xcd5c4d3b, 0x1e6d9956, 0x0b4e7681, 0x07d170bd, 0xc7d36816, 0x9c4d9510, 0xa53bc982, 0x83c688f8, 0xd44d162b, 0x6cf8b881, 0xf43c2b39, 0xea83757d, 0x49c78f55, 0x362bd662, 0x4a86c15e, 0x8e8ae282, 0xf6792b55, 0xd8b72302, 0xccdb9597, 0xec653ec3, 0xe192e333, 0x78792a19, 0x749a2ae5, 0x0929383e, 0x522a3224, 0xfaf62db5, 0x20f08168, 0xf87d88a7, 0xf807c5f9, 0x3043573a, 0xa083218f, 0xbaf7a5eb, 0x3102c4b6, 0x0af45ae3, 0x270a698c, 0x232aef9c, 0x6d1ca9bd, 0x96127660, 0x36aef4ff, 0xbde8c425, 0x5cf61a3c, 0x91550314, 0x3b26c7fe, 0x0967a5e0, 0x4975016a, 0x3fbc3ce9, 0x70e18bba, 0x41ad3e94, 0x87a81b90, 0x4695ccea, 0x2436d9da, 0x80c8b4d9, 0xc9ec50c6, 0x8a7a35c9, 0x00ae8f36, 0x6b2a4406, 0xd5389fea, 0xfad7b899, 0xe470fc02, 0xc7ce8be2, 0xc7344ac2, 0xe47e4b9b, 0xe4368d4f, 0x8fceeabf, 0x8f52781a, 0x004967d3, 0xa728b1a0, 0x8cdf0e24, 0x66aafd4a, 0x1000384f, 0x938f06b2, 0x895dec59, 0xc0127223, 0x5701daa2, 0xfd7869de, 0x037b0250, 0x3e4976bd, 0x0ca79b00, 0x66326828, 0xce3ebe64, 0xa5d478bb, 0x276bc6a3, 0xf2fc829c, 0xd52e4a1f, 0xccb3ebe6, 0xf9dfab2d, 0x21cca784, 0xfb16322f, 0x753e299e, 0x334b985c, 0x4f14e424, 0x1ab6f26c, 0xabac4201, 0xea8b8977, 0xd6a590d7, 0x7b0b9b3d, 0x793eed28, 0xe820db9c, 0x2bf607c8, 0x84aa6ed1, 0x89e534b7, 0x7caa4830, 0x7335a137, 0xed7c86b0, 0xe9e2e9df, 0x046f71b2, 0x9e09d684, 0xe62c0489, 0x2e11350d, 0x35a83718, 0x118be980, 0x8b939c06, 0x223f203c, 0xb5061a64, 0x2abf790e, 0xc8c85e45, 0x0762ecf6, 0x3718c99e, 0xd8679241, 0x2132563f, 0x0eb354c9, 0x90bf8569, 0xed7da786, 0x2ffde497, 0xc9538cbe, 0xdd96e3d4, 0xcff49f3a, 0x027cb686, 0xff5bd53a, 0x77a74a50, 0x485d6a01, 0xa8d89ab7, 0x6ac0d2cb, 0xf014706d, 0x966d6e1a, 0x64e2e404, 0x56fc673b, 0x2761b4f3, 0xc776bb43, 0xb7f9a297, 0x0b3de3be, 0x6a112a83, 0x19b80848, 0x2c41455d, 0x04f251d0, 0x75babc76, 0x5f97f7e6, 0xf1e7286b, 0x391f4779, 0xb6d54638, 0x312a7d3f, 0x0144a3db };
const u32 bern_num_data477[175] = { 0x0db3c9f7, 0x69971553, 0x438baa2c, 0x45c4707f, 0xc19c75ea, 0x73014005, 0x47201e3a, 0x9ca6712e, 0x4edd998d, 0x3cf9de25, 0xa63596d0, 0xbcf2d48f, 0x3f25e2b9, 0x5b8c9a7a, 0x42435553, 0xbd53d2ae, 0xaec1bb8c, 0x154174e7, 0x3c3a68ad, 0x894e4c31, 0x65a7c436, 0x867137a7, 0x658d3aba, 0x06653036, 0x495704ab, 0x268db8d9, 0x66fe3d78, 0x0e7ee753, 0xcc9cc758, 0x404ebebb, 0x34110254, 0x916e4fa4, 0xde37034f, 0x61b43629, 0xd15e3e73, 0x642de5c9, 0x2213381d, 0xcf5357be, 0x96e30fd0, 0xd77c6fdf, 0x97d32f02, 0xdffd6870, 0x74fa0408, 0xc31fde22, 0x231b8bb6, 0xb43447c3, 0x3745512f, 0x0f3cb307, 0xe02110c9, 0x136d4329, 0x8bb27489, 0xe23ef759, 0x77aaa287, 0x0bab432a, 0xf5727226, 0x1998b9c9, 0xd63c4edd, 0xd5c5f450, 0xa46952c9, 0xebd23743, 0xf42917a1, 0x524b89b9, 0xcf838bb6, 0x605059cf, 0xa732e21e, 0x9e310bbb, 0x995a94d3, 0x99fb6918, 0xdf5b8e39, 0xc522bd7d, 0xbdf10d70, 0x81a9ec89, 0x51aef6fd, 0x9ae9b85d, 0xabc2081a, 0xcdb8384b, 0x0aaae41d, 0x5eaee872, 0xe8f6da7f, 0x93fdf5c2, 0x4aaa9146, 0x1edf70ea, 0xea06755b, 0xd708af8a, 0xdb50e6e0, 0xcd4a3d4e, 0x13ebcdc5, 0x288211ff, 0x92558ae4, 0x8d98392b, 0x3c0798be, 0x5c448c3c, 0x13e04905, 0xecf7515c, 0x66ef3fcf, 0x4f497b59, 0x55258d52, 0x4438ba6b, 0x2dec4dbb, 0x390c290c, 0x37ba7098, 0x0a706a42, 0xfc4e2225, 0x2735f570, 0x958f1654, 0xe2a7d7da, 0xe511d8a7, 0x299762f1, 0x89f70bd5, 0xbb50bfed, 0x1cc0e30b, 0xa1fa1e4f, 0x2314cfed, 0x6ae2a957, 0xcd18c9cc, 0xdc4f49ae, 0x25ffbf91, 0xbe79e005, 0x153bf7ae, 0x65d8bb63, 0xf06b47fb, 0x3d8f27ba, 0xbc39c474, 0xe4d27741, 0xbfdef1bd, 0x1b01b9f4, 0xa3738229, 0x9a5d2c38, 0x7461afc3, 0x563b4da8, 0x608c8a6f, 0x8e90dd15, 0x583f1f1a, 0x77640423, 0x4faac369, 0xdc7bddb7, 0x8b41222a, 0xb3652200, 0x7545b232, 0xed0e0559, 0x52202fea, 0xc3a58355, 0xdf4d8cab, 0x79335d65, 0x38117af2, 0x9a8e2bfb, 0x3ffeab56, 0x38180df3, 0xf106cbd2, 0xb9491e15, 0xa0afcd1b, 0x4638bd0e, 0x59e63d36, 0x3c6692dd, 0x310e415c, 0x587b65a4, 0x6b8cbdf7, 0x053bee3f, 0xfb5cced1, 0x0cad98f7, 0xe266efa2, 0xec2f59f8, 0xa04753d6, 0x320dca75, 0xb44f64c0, 0xb72854de, 0x4167b494, 0xea75851b, 0x9b02ec10, 0x651ab886, 0x39db0665, 0x350603ce, 0x1d60bb48, 0x47879ead, 0x00000013 };
const u32 bern_num_data478[175] = { 0x8e854e27, 0x23911bfd, 0xee5070d9, 0x0934a67b, 0xce05c150, 0x630ead81, 0x0b7eb0fe, 0x2ca91c4c, 0xd853a125, 0xb7bb628c, 0xf34a79b6, 0x9a8b4b9e, 0x79e4955f, 0x8b678633, 0xd1e78d70, 0x29b4c0a3, 0xd763d612, 0xdf6203dd, 0xdc69807b, 0xa02f7b72, 0x82703b99, 0x97d660d6, 0xe7de5ff6, 0x23dadeb1, 0xda4e3575, 0xde3ea7ba, 0x3e3c5ee8, 0xf3cc962a, 0x717c788f, 0x829ac5f9, 0x0e8c47be, 0x722557ee, 0xf2d59544, 0x72a7c0dc, 0xb38377f7, 0xc8dc3b26, 0x480687d1, 0x2a535214, 0xe9c51ddc, 0x76865b0c, 0x4b64ddd2, 0x88119573, 0x8760b19f, 0x72b02de9, 0xf1c42fcc, 0xd1f99c31, 0x5cab68b5, 0x4b463502, 0xf8736a51, 0xd5e0cb4d, 0x38fa4367, 0xb2c67eac, 0x2c7b65ac, 0x478f5c51, 0x04f756f6, 0x145f37df, 0x4a0103a5, 0xab7a8c59, 0x4ca17acc, 0xd3972d49, 0x1684b75a, 0x1a4c62a8, 0x411a4095, 0xc18a6a47, 0x80d47f4f, 0x41b59bb2, 0xa0d0bc5f, 0x7e9970ff, 0xd83dbbe0, 0xb9dec579, 0xd62bde0c, 0xa1a82589, 0xa5269798, 0x3c50a282, 0xc258d311, 0xecdf1ee8, 0x820a658c, 0x78109698, 0x77023644, 0x328efb47, 0x5ec7c6ca, 0xe3230b0a, 0x8937a827, 0x8cc40161, 0x929b091a, 0x4264f7f0, 0xdaa73029, 0x5db0a241, 0xb59d5ccb, 0xffa0dbca, 0x372903a6, 0xa396c3c9, 0x2386cf39, 0x95748104, 0x38c303b1, 0xf2b377a3, 0x306d632b, 0x2b321bd3, 0x95f0fd86, 0x3fe64fb9, 0xff717a8c, 0x1d6a91f9, 0x7be6e51c, 0x88e880a2, 0xeb87eca3, 0x5e494da7, 0xf2fdd2da, 0x504f1117, 0xe663c7a2, 0xcc21f87d, 0xd495bcb1, 0xbdb7755b, 0x30bf10f3, 0x450043aa, 0xcc3f20ee, 0x96827d7e, 0x2d38464f, 0xb9b9fdb5, 0x7bbaa91c, 0x280cf8f6, 0x63dc7948, 0x70583aff, 0x32cf3e5a, 0x659fd3e8, 0x1b99d5f7, 0xfe2c91b5, 0xfa751a74, 0x1a6b147f, 0xa23ac910, 0x4f159822, 0x8ea1e110, 0xf8ecf633, 0xb0416540, 0xfa1a7045, 0x490d86b1, 0x886b2f56, 0x587d6a2d, 0xe27c3367, 0xa9a123eb, 0xa43ba903, 0xb417292a, 0x0a84a8dd, 0x15660760, 0x58011719, 0x73e7987d, 0x1e8de567, 0x3aefea1a, 0x6b5b0cc9, 0xb846191b, 0xd4d68969, 0xc16effc2, 0x4bbef2d1, 0x8f1c70ca, 0xd0c2c5c9, 0x57e03227, 0xb765784f, 0x5934b694, 0x3c800d48, 0x7fd486b3, 0x30e9b708, 0xc6a9a59e, 0x579ff0d6, 0xf54cc54b, 0x6a8f4824, 0x0004b631, 0xeba68111, 0x13d7af06, 0xe8378f0e, 0xf4dd65e2, 0xc341920f, 0x07b6d952, 0x283d8ee6, 0xff0e7522, 0xf10e063c, 0x000000ba };
const u32 bern_num_data479[177] = { 0xc9ac1303, 0x13c34477, 0x4aa04dc0, 0x93120ce6, 0x1ad17b79, 0x6edf0ac3, 0x7ae12dc9, 0x11f6326f, 0xa7125e7e, 0xcbb76518, 0x963878cf, 0x40bcb980, 0xbf2186a8, 0x141b9fae, 0x9a9a9bb8, 0x584efd70, 0x445b614f, 0x7d317706, 0x4d9f76e7, 0x578fd481, 0xbcf80b21, 0xd98ec24e, 0x68081ec1, 0x384a95a4, 0xf526f8e0, 0xaeac98e4, 0xc3a44ec1, 0x1a4fee5c, 0x76546526, 0x3afae6ce, 0xa2f32a7f, 0x40c491ad, 0x961a5756, 0xd96ac88f, 0xce20cf43, 0x4331cdda, 0x7c55ba68, 0xe221168b, 0x91501800, 0xeb75edd5, 0x4f343291, 0x5e049552, 0xc2188e1a, 0x7049dc76, 0xba9d5c92, 0xc81e85d6, 0x76d0648a, 0x51de574b, 0x4567aaff, 0x259c80c6, 0xc11e488b, 0xccd161d7, 0x6111455f, 0xe0d4b92b, 0xb6b8f486, 0xa754e6bc, 0x490221b1, 0x0a129067, 0x88295dc7, 0xe86ca8ac, 0x45d396d2, 0x348d6716, 0x939a04d1, 0xf06650c4, 0xed5ce209, 0xdfb9be06, 0xc26e7bd2, 0xc007e0b4, 0x73cc302c, 0x7a366e8f, 0x27c76ba8, 0xed56baed, 0x7e480a72, 0x2a224985, 0xd555e947, 0x48445d8a, 0xe1f2f9ce, 0x4d3b7da8, 0xfb07213e, 0x1557486e, 0x8c535bd3, 0xfdf2c518, 0x2b3e6ad9, 0x49099862, 0x2556ac12, 0x6cffa648, 0x75b8a588, 0xd5c6ccbf, 0x215277aa, 0xbb8a5527, 0x30318c39, 0x347a6c92, 0xc1a6cd21, 0x148f11ae, 0x96316ddc, 0x4e118327, 0x1a1c875a, 0x8c6ca50e, 0x2d529cae, 0x354c511a, 0x7ca4b660, 0x871a6ba0, 0x9f7df06f, 0xf130aadf, 0x8769be6e, 0x7a329298, 0xead9c73a, 0x89b17b12, 0x895aaddb, 0xa3ffa55e, 0x10e6a4a1, 0xd16fb18e, 0xbf8790b1, 0xca5005e1, 0xe6d1e111, 0xe473c978, 0xbfb7f355, 0x7a745871, 0x4cbb9ea8, 0x5db475c4, 0x1b1a97f6, 0xb714de09, 0xf79c50d4, 0x1deeea49, 0xcfdc45a9, 0x22f3233a, 0xd7b8e0dc, 0x0d250b67, 0xe6110197, 0x7d1208ca, 0xb6be8851, 0x5b1e2f78, 0x8d5fcc7f, 0xa5a78123, 0xf72c2929, 0x7f29ba7a, 0x9c479c0e, 0x3e79eef5, 0x0cc68e43, 0x5b84bf23, 0xd667d6ee, 0xd62a8ed3, 0x53112230, 0x7b13edc3, 0x4814395c, 0x44bf62f6, 0xbeb9e0f8, 0xae799444, 0xa4c25b9c, 0x5c2ecbc6, 0xa5dffdb4, 0xe8955210, 0x710173d3, 0x537d958b, 0xf3bc28c0, 0xd8508c42, 0xba96427b, 0xca492ad1, 0x84f13396, 0x77f8173a, 0x6b34b394, 0x859d9b45, 0xb11e53e6, 0x96b5ba5a, 0x3e2eb09d, 0xf5ec82cf, 0x77628fb4, 0x5280b1dd, 0x794dc9f6, 0xa5265c85, 0xa2d33e99, 0x8a69fedb, 0x0d817b4e, 0x3402544f, 0x5085c019, 0xd04b3e43, 0x00001b79 };
const u32 bern_num_data480[176] = { 0xa4a7de7f, 0x7fe0821c, 0xdad00690, 0x258d8801, 0xaa201323, 0xc09710e9, 0xf94095ad, 0x0183458d, 0x660bea2e, 0x09832cee, 0xc8c01254, 0x3b2e5fef, 0x55b89c8e, 0xa5028a6b, 0xb3787d06, 0xa1e99fd2, 0x08978d4f, 0x4c10b14d, 0xad4f33e5, 0x96460887, 0xc1453e4e, 0x22161b39, 0x583c83dd, 0xa850d496, 0x279682d8, 0x70c61858, 0x820f6ee1, 0xa58730c7, 0xa8558716, 0xfd8f907e, 0x92ea4551, 0xdded4203, 0xcffaddb2, 0x8875cfaf, 0x2698840a, 0x3476161f, 0x40a43c84, 0x860c03df, 0x9539762e, 0xa4a4c14a, 0x9fdaf433, 0xada1b94e, 0x654dd97d, 0x670d8f03, 0xe243f6ea, 0x0ec3b88a, 0x5ec67875, 0x92e56e84, 0x9225a551, 0x4d67ada4, 0xb25bd8a4, 0xb735c94d, 0x765553de, 0xc4e5dd8e, 0xfaf8143c, 0x9ef39dd4, 0x26fce083, 0x2c114c34, 0x6ee5941f, 0xe788ebff, 0x0bfcd20f, 0xbe38735f, 0x8357e3c5, 0x68ee68f3, 0xcfb3296b, 0xf640dcb4, 0xa3f5351e, 0x3ebaf206, 0xc6735bbf, 0xd19e45af, 0x3dd3ba1b, 0xa810288c, 0xea6a0eae, 0x35f5d5a7, 0xc1ad8316, 0x766bb392, 0x6fab8691, 0x89726598, 0xf3a73034, 0x256557a2, 0xbcacf15c, 0x1cd94c27, 0xfb7bfe17, 0xa7ed6e13, 0x4b4946ae, 0xe502e4c2, 0xf15bcc35, 0x51fe7c8f, 0x5ec37791, 0xd90b6096, 0x140222fd, 0x79012281, 0x8f5f1d2c, 0xd16612f2, 0x62be4833, 0x7a7e35a8, 0x0cd8b2fb, 0x61dd39ad, 0x4a61dfee, 0xf7915bc9, 0x9e6c4c7f, 0xe6b3829a, 0xf6e65be6, 0xf52298a7, 0x774d9277, 0x011cf901, 0x9e930d2d, 0xdf1d76da, 0xfed9eb20, 0x4b7f0f36, 0x36c45da4, 0x59b144b9, 0x0d1bf8b6, 0x1489f7f1, 0xf70dec97, 0xcb1e189a, 0x36f38448, 0xc903771a, 0x02ead9ad, 0x3726a880, 0xf8b64978, 0x64e583a4, 0x499bba3a, 0xf90fcbdd, 0xdf2302fe, 0x7b9dbcfc, 0x5b62bc08, 0x3f81d17e, 0x4920749d, 0xa797611d, 0xba0a70cc, 0x7b3b8243, 0xa298a4b7, 0x96c6fab2, 0x85e218ac, 0x8a98783a, 0x98c5991d, 0x48ae7f35, 0xb7d9ae5b, 0xd2bd47c3, 0x94894b83, 0x8647fb10, 0x01faa176, 0x131df498, 0x40fe488c, 0xa14edf98, 0x681dea54, 0x065a2fd6, 0x34843e72, 0x105860fb, 0xe016028d, 0x5e4df28e, 0x0cf983d6, 0x0ee78dbd, 0x09e99c34, 0xcf55c288, 0x7600defb, 0x42219937, 0x0c5c20f7, 0x6056ed4c, 0xb7644365, 0x44a9a7bc, 0x7da3f937, 0xedad6a38, 0x3751879f, 0xb6d8f3b3, 0x51236cb6, 0x69813abe, 0xa243358f, 0x00279827, 0xdcac4332, 0x3310120c, 0x7e37d363, 0x3bfaad07, 0xc4ebbc60, 0x00000017 };
const u32 bern_num_data481[176] = { 0x8d990b79, 0x98bdb02a, 0x35b4da1d, 0xe215d6bd, 0x95a73a92, 0x984e5615, 0xdbbcc3b1, 0x02da8e85, 0x656ecfa6, 0x81e8b877, 0x2b3bdb91, 0xaec6fb00, 0x8bca8c82, 0xa46ed514, 0x2bf258b8, 0xa667f265, 0xc373b77e, 0x62a0bcd6, 0xfb42c1c5, 0x02792df9, 0xb9ec25b4, 0x3bd481d7, 0x7398b1a4, 0x00a3fb35, 0x6e32eb56, 0xe0b62400, 0x8ca1adb8, 0x097b485b, 0x88f40bd6, 0xebb7a0d4, 0x7e350a3a, 0x3606dfb9, 0x9909cb4c, 0x04230ef7, 0x2fc4da71, 0x81a0e680, 0x7b55f319, 0x7eae547d, 0xac5e2a29, 0x60fa5e8d, 0x28f78c21, 0x1a6c2ef6, 0xe0858157, 0x75f1eae0, 0x40194151, 0x60f0df33, 0x96b503ff, 0x75d480f9, 0x8c6dc1cb, 0x8a7919d0, 0xa827f356, 0x2c17f4ac, 0x53aeeaa3, 0x872e8728, 0xa4b18048, 0x312d062e, 0x17b958ce, 0xa5c4e189, 0xfbad4f22, 0xb7416f36, 0x861fa60d, 0xa9f73d53, 0xb43e9ba1, 0x06e1a95d, 0x4bae15da, 0xbd56229e, 0x7dc5cec1, 0xdd11a950, 0xc45a3ccc, 0x26bd4f07, 0x865937db, 0x4a33574c, 0x50b05a4c, 0x52eb84e1, 0xd3570b6a, 0xbee045e6, 0x3325d2dc, 0x5d605052, 0x3fe5c66b, 0xf1f91c59, 0x1065eca1, 0x576b1c3e, 0x3858728b, 0xa0395faf, 0xad772e1e, 0xc059cc49, 0xbc99ab65, 0x587727b6, 0xfa4b5b8c, 0x34d1762d, 0xc7fb3e9b, 0x2d852791, 0xf195c8be, 0x0e2c9b6a, 0x2848e4e7, 0xc8bc4085, 0x59733868, 0xfea2914f, 0x4679dc1a, 0x729d45b6, 0xd9291791, 0x69f90542, 0x4f5d9090, 0x889fe699, 0x723f539d, 0xf6692282, 0x0607269a, 0x404d0fbd, 0x70a24049, 0x4aca0d7b, 0x71ca78cf, 0x4809711e, 0x4d5f0857, 0xeb90ab29, 0xd9690e6b, 0x05abdf24, 0x27f26f6e, 0xcb86807d, 0xc927e59e, 0xc8cccb64, 0x65ef2fcb, 0x4a896041, 0x08f2625c, 0x31d8fb52, 0x6cc41de5, 0xf0a2cad8, 0xe4673149, 0x6eb626cd, 0x0a99faae, 0x3022a78b, 0x9b931309, 0xd129b913, 0xafd4403d, 0xd0bc13ef, 0x27893497, 0x51868d4e, 0xdc96e51f, 0x05ca69f8, 0x6f3e5dee, 0x10db2273, 0xd994b003, 0xbc552022, 0x181ff9f5, 0xfa3e2afe, 0xee6ba3a9, 0xe48eec6a, 0xddc65a29, 0xaec25d88, 0xf82e2808, 0x1fb9b239, 0x6ac42aea, 0x0a64a983, 0x5ce2b1cb, 0xa16d2678, 0x266c4391, 0x79482a0f, 0xa730d026, 0x658ef858, 0xb72e0ef4, 0x1bf1a543, 0x0b34d6c4, 0x4e93c124, 0xd9a0062f, 0x2243ffa6, 0xdec1a73b, 0x0d8e7d01, 0x57fa4f12, 0x19454036, 0x6aa7fcfa, 0xb15b5a61, 0xf6e6ec54, 0xc739b513, 0x03d154b6, 0x54b9196c, 0x47df2df9, 0x002aa4a1 };
const u32 bern_num_data482[178] = { 0x1aa3c101, 0xdae3a665, 0xbb74ce32, 0x5232d35c, 0x660a051a, 0x5e6130b8, 0xbd62dba8, 0x5bda8e96, 0xc4a44db0, 0xc3c8ae36, 0xcf35d781, 0xfcfed2e7, 0x9f5203e9, 0x96944db8, 0x0adc5624, 0x700b2d1a, 0x7f2516ac, 0xa16026eb, 0xccd28300, 0x91b7c7d3, 0x15f23813, 0x5ee97a37, 0x71047010, 0x9d92a23b, 0xafea22b4, 0x41e3060c, 0xe2956001, 0x936b0938, 0xa931bc6e, 0x6722894c, 0x81f277fb, 0xce6e1d53, 0x7afbebc4, 0xb47c8c10, 0x7620d42e, 0x1fd26bc6, 0x3223f64b, 0x1f7dcd15, 0x17d1e3f9, 0x2f75211d, 0xd0d92c70, 0x3e3f0140, 0x2dc04cf4, 0x6ca7863a, 0x4bacac8f, 0x438fc5ea, 0xfd2b4476, 0x19491a4a, 0xa37468f2, 0x7bed8e8e, 0xf049ab3f, 0x00dd591d, 0xc0092ea6, 0x5eb0766b, 0x02334f3f, 0x45490c60, 0xa962218b, 0xd1108a60, 0x456f6beb, 0x6e6d151c, 0xcb3e9f95, 0x3d908873, 0x7a8e61aa, 0x7809ffe7, 0x709f0cb4, 0x514c9123, 0x3c836a94, 0x22669dbf, 0x02da94c2, 0xbffeae44, 0x536e986e, 0xf2f7cdc5, 0xf42bbff3, 0x299abc66, 0x0b46d7a1, 0x937b6e86, 0xd4a6274f, 0x34127662, 0x2fc2287e, 0x368642b5, 0x9faef6e3, 0xb4725e72, 0xf0a6d32b, 0x9c8eb12a, 0x1fbcf0e9, 0x86208670, 0xaaaf341b, 0xd9e3d7c7, 0xba450b53, 0x5778fc73, 0xe2b6bacd, 0x42ac8b53, 0xa08e535b, 0x4fa5a9dd, 0xed6ddacc, 0x1fa013a8, 0x5f0e4cb0, 0x8d741407, 0x34a3a965, 0x2260c732, 0x6eab7b93, 0xe8d3730d, 0x57290f0c, 0x6b5f83f2, 0x49ca1dab, 0x7868ea51, 0x09e63964, 0x2f6516a5, 0xf8bc7119, 0x9a7ce963, 0x1854f932, 0x1485b6eb, 0xcdb80e97, 0xe6026cb5, 0x209a70f2, 0xb66e674a, 0xf24e643f, 0xec42ce39, 0x55d64f07, 0x7cf1d316, 0x6d4163ea, 0x3eae20fe, 0xa6998cc7, 0x8ef07feb, 0x580c7696, 0x8447f94f, 0x890d1e44, 0x3122fa16, 0x90555c48, 0xab3f9e60, 0x9444acb8, 0x5bf2fed0, 0xbb70fee5, 0x034fba08, 0x6ebc6a7a, 0x6839f3d2, 0x79417b5f, 0x96d48db8, 0x10658180, 0x68e69b21, 0x109b96df, 0xdf977f39, 0x59971bef, 0xaf4d9fa5, 0xe3947f26, 0x30366e82, 0xc49e8e34, 0xe9337389, 0x42865830, 0xe1402b90, 0xfaa6927a, 0x8f2cb48c, 0x4c032e6d, 0x70850236, 0x8f5cbd12, 0xd1381fcc, 0x3fdcd3d5, 0x0b69e525, 0x9ab10626, 0xd8519ccc, 0x267154d0, 0x3988c19f, 0x4c64b880, 0xe4d8f2f6, 0x44a6fecc, 0x408560f6, 0x85e45cc1, 0x049643e3, 0xe24c5d61, 0xe95e3109, 0x2a5ed777, 0x9dc3b32a, 0x8f091f99, 0xd5e8bd7e, 0x8405f6df, 0xbf09444e, 0x5c47cd15, 0x00000001 };
const u32 bern_num_data483[177] = { 0xf1c1f4ff, 0xb662c8e1, 0x34e6af40, 0x7f17fc29, 0x22dbff1e, 0x891b6ccc, 0x3d1e1fb8, 0x91102e38, 0x918cba65, 0x89bcc3c0, 0x7de1c5ae, 0xf0f820cd, 0x8738012b, 0x2d399e39, 0x079eab4d, 0x4d55d507, 0xf90da0e7, 0x7095beb1, 0xd18146bc, 0xc5c038f5, 0x3c98893d, 0x7b4f06f2, 0xd5883050, 0x83e6c561, 0xaef76d79, 0xde3d2d05, 0x1334bc69, 0x5c81c898, 0x907e0f7a, 0x1ed392f5, 0x54452e30, 0x0214afab, 0x2ca5decc, 0xfc3a8256, 0xd84a964c, 0x2e547af7, 0xe6a18016, 0xc8e7a51b, 0x76ec4b9d, 0x038a40c4, 0xa28a051d, 0x7194df5c, 0xb7d467d3, 0x32cc5e53, 0x07749e48, 0x4d21031a, 0xcf09acac, 0xa4834a72, 0xc0dbc682, 0xfdb0bc93, 0x4fc81ca8, 0xbe01522a, 0x5d4d9b70, 0xcb1beb32, 0x7207d111, 0xa8720936, 0x8cc3929f, 0x5882a7d3, 0xbbb4f562, 0xdd4097ab, 0xc4efa605, 0x1db6b5c9, 0xe82c872c, 0xf4070beb, 0x9b01827c, 0x8597dc11, 0xee908e9a, 0xcadd6dba, 0x0ee2619f, 0x78e62829, 0x148e9185, 0x7c09632c, 0xeb56c319, 0x25907399, 0x30bfce2a, 0x21c2f9ab, 0xb358948d, 0x2106189e, 0x680349ad, 0x45974686, 0xf22afdca, 0x9cfa629b, 0xf034e766, 0x0eb646f4, 0x40567946, 0x77847a4f, 0x040d9172, 0x1fe8c181, 0x5afa3697, 0xe113983b, 0xb08e99ea, 0xcf32d669, 0x6d36cdbb, 0x7ca39b60, 0x72f19c92, 0x9428173e, 0xd3b34de0, 0x243f7dae, 0xd6280326, 0x9a2379c9, 0xeac8dc9a, 0x42cbb6b2, 0xe4a012fc, 0xc8e0ff61, 0x5f29c205, 0x098c5762, 0xf12ee6cd, 0x951dc0a5, 0x5cb2609b, 0xd6dc99f4, 0x25e5f378, 0xae4b5790, 0x9d72faa6, 0x31a44697, 0xd4691db1, 0x696b9cb9, 0x43d5df8f, 0xb95a0806, 0x8753b5ad, 0xccc59dc3, 0x80c31695, 0xe18b4830, 0xa3c019a5, 0x04780901, 0xb88f596e, 0xb23cb562, 0xc6f8163e, 0xc41134d8, 0xc5b9b0c9, 0xa763598d, 0x134b3d64, 0x552a5093, 0x14cd9b11, 0x23193215, 0xccb87449, 0x01139540, 0x89d2436c, 0x2e07320f, 0x397fbc6a, 0xeea180eb, 0xfdd21fbd, 0xdc910b1f, 0x67eaaa9b, 0x6170a7af, 0x6332343c, 0x019e042a, 0x897b0431, 0x0f0483dc, 0x9b31d879, 0xa9a51528, 0x88aedbad, 0x1c6cf0e3, 0xa83ffb1b, 0x1e8ee127, 0x3733ce6c, 0x87d9f47d, 0x0c43c1b1, 0x1113d415, 0xd5f6e86a, 0x80eb324e, 0xeff13351, 0x33de30a0, 0x0b35e71a, 0xa1067aee, 0xbed42efa, 0xad0649a9, 0xd09c7f92, 0x1d6a1c1e, 0x0938ab0a, 0x3f40864e, 0xbb6143f0, 0xab9d85e5, 0x7606b9a9, 0xc476b5dd, 0x5f1711e1, 0xd374ed18, 0x2c72b847 };
const u32 bern_num_data484[178] = { 0xc3d21f77, 0xc47d46a2, 0xb02bf4c9, 0x005b9b38, 0x3b13f956, 0xb232ddd2, 0xc1985bfa, 0x15612fa0, 0xfc224089, 0x844764f5, 0xf639fd62, 0x7d0b936e, 0x72e1dc7c, 0x7a6af6b5, 0xf39faaa7, 0x6719e7e0, 0xb608d9ad, 0x346818d2, 0x6392e438, 0x99b6af98, 0x0b7fe109, 0x7c86306d, 0xd2d7e148, 0x8f1bb1ef, 0xbb72f2d5, 0x3cb510e4, 0xabcfe963, 0xa345a9d2, 0x4f596c43, 0xd239e453, 0x24a5d33c, 0x0c80b179, 0xd0a51251, 0x1e1e54c1, 0xcabcc6f3, 0x9af558f6, 0x8d6f30b6, 0xbbfff8a4, 0xf5eb2707, 0xf2fd9f19, 0xc80b0189, 0xb0f8e355, 0xe366a54e, 0xe6f924d1, 0x4b4f5dec, 0x245d35ca, 0x44047396, 0xb2004fa2, 0x3058820d, 0xb017994e, 0xbe791557, 0x96c8cbda, 0x6bda0d75, 0x14399ddb, 0x9d2240dd, 0x17be4ea7, 0x658c3e94, 0x498d94ba, 0x8776b67c, 0x1ec65db7, 0x1c0fd088, 0x8a4cf442, 0x9f1b7fec, 0x30916c2c, 0xb1b101dd, 0x6e05d203, 0x1ff918b4, 0xa1cf1b7f, 0xdb6e5cb6, 0x017bbd19, 0xf33c6a08, 0x26e794ae, 0xac133dc2, 0x34c1d246, 0x1b3bff60, 0x22d502f2, 0xfb8cc647, 0x060a3cb2, 0x32cc3199, 0xb83f18e7, 0x4647eae6, 0xf8803e35, 0x73a9d798, 0x2046b62a, 0x65b23133, 0xe4c58a14, 0x3d046e28, 0x0022ce70, 0x8fbb8dfb, 0x9fb88a57, 0x8f73ef7b, 0x3f421362, 0xfe91e62c, 0xb8504880, 0x9dce25df, 0xd0ff97d9, 0xa50af612, 0x7e8a064d, 0x2e0494e8, 0xa1f99df6, 0x2f426ef5, 0xbebd0987, 0x65d95254, 0x58ab13d5, 0x55858c5f, 0x9bd945f3, 0xcdca036b, 0x3e980826, 0xfd403559, 0xb8c62fd1, 0x615fba49, 0xc2951fca, 0xaae4ebf5, 0x3f632fdb, 0xabe28397, 0xb219adc8, 0x829e4de1, 0xddddecee, 0xdead6e1a, 0x01d106e7, 0x55d0e148, 0xf6fff0ce, 0xf2c50a6d, 0xf914b5c3, 0xb2e1559e, 0xe14ac3ad, 0xd83eaa7c, 0x59ac5b99, 0x9be9d744, 0x0705a2ee, 0xa5969ea5, 0xe30299bd, 0x5aedb8b0, 0x4772e43a, 0xf12e44e4, 0x4aebe1d4, 0xfefadb54, 0x7c6f88fa, 0x9c56e40a, 0x2fa57c21, 0x09b1427f, 0x1680e3dc, 0xc4321474, 0x3a6d0972, 0x2a03627d, 0xbe6412f3, 0xe1a5e795, 0x00b029d9, 0x67ed34a6, 0x19299e06, 0x65baeaf4, 0x5be9dd79, 0x5bb916c9, 0x496ab585, 0x137b6bd2, 0xa5b483f1, 0x892f5c1f, 0x23cc52ee, 0xe7c1fde3, 0x765d439a, 0xaeca6709, 0x8667ff9f, 0x5b982727, 0x8e27c440, 0xa525ded6, 0x5dd0987c, 0xf898466d, 0x85d035d1, 0x6863d507, 0xcf11ed33, 0xbeb630db, 0x654edad4, 0xc16be4d3, 0x9a163128, 0x6558fb59, 0x61ce5874, 0xeea5be8d, 0x000010d9 };
const u32 bern_num_data485[179] = { 0xee7cc53d, 0xd1b28114, 0xb8088078, 0x138c6ce3, 0xf75792b5, 0x0453c61a, 0x13d62dfa, 0x7c2b0919, 0xfa9718d3, 0x5ad386ae, 0xe3b06741, 0x6000b0f1, 0xfcb57d86, 0x3b12f41b, 0xeaf8d3f0, 0x7bc0eff0, 0xcbd0161e, 0xeb0b5520, 0x97e2f079, 0xe86c4708, 0x4b0392df, 0x88018f09, 0xf32c8f25, 0x8f507f2f, 0x6e1140dc, 0x31dc3ba2, 0x3ff2d36a, 0x7dac0097, 0xf0a99c84, 0x39032eb4, 0x3fffd66d, 0x785f30ce, 0xcb274614, 0x253954ea, 0xf7b8b9f5, 0x1235817f, 0x32114498, 0xd6b0192c, 0x9a1b9ad4, 0x8b4c787d, 0x8e85696c, 0x0954aa72, 0xc6580b13, 0x9adbad9b, 0xb561209e, 0x1a5941d9, 0x87a0c574, 0x5039a803, 0x3b785b5d, 0x9e367665, 0x684ac910, 0x68487600, 0x55535916, 0xd061adf5, 0x4fa88c21, 0x69d55107, 0x0f940ad6, 0xee8b0aa5, 0x49e5e67d, 0x42c61453, 0x3ebd9d9f, 0x5733c281, 0x2790763f, 0xc60f7a3e, 0x19b27966, 0xed74f71c, 0x65fcab6f, 0xf994487d, 0x1d76f269, 0x9b4c5b6f, 0xc86af7b6, 0x22033427, 0xf1728231, 0xb8291ff8, 0x35ed0a59, 0x9210eda3, 0x2b36f81c, 0x90dd2060, 0x3635121a, 0x6294567a, 0x069d8a9e, 0x2ffdf6e9, 0xf3e8d77b, 0x81015c34, 0xb4536752, 0xcc8a138a, 0x1ba95f3e, 0xe793e214, 0x7a52c09b, 0x14052974, 0xc9d916d1, 0x9bcee571, 0x18c9e610, 0xc73700de, 0x9af9e2f1, 0xd72f022d, 0xa3c5cf5a, 0x3df9f998, 0x6e4d2825, 0x48ec4f80, 0x73d45f14, 0xc8b98a24, 0xa44f6d40, 0x00f7a43a, 0xad7c55f3, 0xe6f67cfd, 0x518224b8, 0x1b7d18cc, 0xe566b423, 0x621e4b5d, 0x7e3536c9, 0x3820c07f, 0x1ff62fa6, 0xebaaf245, 0x54cc56f9, 0x6031d7f5, 0x8883610d, 0xa58158db, 0xdb0789d4, 0x194491be, 0x6774da3c, 0x955b0f14, 0xbf9983c0, 0x578172e9, 0x844b5624, 0x526e212b, 0x41dd2fbc, 0xf45f1987, 0x433e6315, 0x896e5492, 0x884a6cbe, 0xbbfc2db4, 0x57f7ecb9, 0x3a59d154, 0x68d8cea3, 0xe7510162, 0x37e42d41, 0x1a6cf9e7, 0x28318635, 0xba144674, 0x4f9bd726, 0xeaf069e0, 0x2e8ba1d0, 0xa4c4cb0e, 0x059887e3, 0xaa1e63ea, 0x9ab271e5, 0xff343f27, 0x4a52af27, 0x194c43a0, 0x96267e85, 0xfff04ad8, 0x9c445370, 0x720a2b65, 0x9155980a, 0xf89fa5f7, 0xfb7bfed4, 0x380b0f1a, 0x665de9b1, 0x8666fc6a, 0xaa632fd1, 0x715e68e9, 0x7f74e067, 0x926dd5d1, 0x9198f5d4, 0x2eb2d874, 0x838b47f4, 0xf3aa9a23, 0x67dde377, 0xda7afdff, 0x5844ae89, 0x3afa57a2, 0xbc947b9a, 0xda03952e, 0x2e26538c, 0x0a2a926a, 0x4eec786b, 0x649d4634, 0x005ef115 };
const u32 bern_num_data486[178] = { 0xdc5d4687, 0xd111b541, 0xc8c39388, 0xb3020e5a, 0x183b480c, 0x230e8bf3, 0x223e956c, 0x81cea77c, 0xc2244ca1, 0xa94a6e62, 0x30515db4, 0xc7cb8d59, 0xc2eabf31, 0x23993f5d, 0xbf35e797, 0xffa71f8b, 0x54d9dfa3, 0x5b377fbd, 0xfdf363be, 0x47234fca, 0x573d0e03, 0xb2c879ea, 0xaf156aa7, 0x64584027, 0xeb2698a4, 0xb7e9c7d4, 0x195b152f, 0xb2d28334, 0xbcd36eb7, 0xee0b4c59, 0x61a34766, 0xe5881001, 0xc567b74a, 0xb65c1f98, 0x6c57ad3c, 0x9fa4a8e7, 0x32524fbc, 0xb3733e1f, 0x10843cf7, 0x21740270, 0xcadd62c9, 0x4d3ba31a, 0xa7ecf7a1, 0x6e466783, 0xa397bbda, 0x883cdebe, 0x647b7f55, 0x696f5dd3, 0x382efcee, 0xcfd456b0, 0x60ea3c50, 0xf0346a2a, 0x006be99f, 0xe001b31a, 0x2e0ed866, 0x2472d616, 0x2c9c413e, 0x9d976257, 0x7bd70863, 0xc4e44f76, 0x6935e8e4, 0xb4502084, 0xc653dabf, 0x9b108cd9, 0x3430f6f9, 0x2c27b83c, 0xce34dd46, 0xdcbcb13e, 0x9080de6f, 0x1b1f323c, 0x3b75b54b, 0xf17bf2a0, 0xe4766c6b, 0x1174efd8, 0xee53909a, 0xcd4e5524, 0x3a762ba3, 0x98a87652, 0x89f9a837, 0xd9fd1581, 0x97b87470, 0xefc40746, 0xfd0ba363, 0xcb93ac3d, 0x0c4cdf0d, 0x438a7970, 0x73c368aa, 0x0e943bef, 0xa4f8f45f, 0xa53bb745, 0xca7a4c2f, 0x27695439, 0x8d997040, 0x6724943a, 0x6aa3e9be, 0x2acf28cf, 0xbcebb912, 0x3aece4a5, 0x7a2f893e, 0xb1b8c7b1, 0x23b874b2, 0x81bdc57a, 0x7bba14c6, 0xb7ccfcad, 0x49e98d5a, 0x180a51e8, 0x35d62964, 0xe2049b91, 0x0cd1335f, 0x927b00ed, 0x0a21c764, 0xc03d4ab1, 0x94bdafe7, 0xcf5d0931, 0xbd365766, 0x8228979f, 0x5bbdb541, 0x3788a3d1, 0xe13a86e4, 0x1f6baf29, 0xc64be140, 0x0f9266ee, 0x8b9b3e65, 0x1da63784, 0x804ea1f3, 0xa4c9e6fd, 0xc0f11bde, 0x8a4bbb11, 0x9f1d0f3b, 0x4950be4c, 0x3fc8a7b2, 0x44dea1f6, 0xd00a6bed, 0x61ee192f, 0x9949e134, 0xb293cf85, 0xd15dea12, 0x82a2c66c, 0x47cb84cf, 0xc5d97cf2, 0x7768720d, 0x83f51b6b, 0x02fbeb4d, 0x62cdcb35, 0xbaff0ef4, 0x93391c21, 0x1396dabd, 0x57811bd4, 0x99d70ad1, 0x71b6c0d3, 0xc12cd8f2, 0x338ef217, 0x159d5613, 0xf8b5b759, 0x51dde007, 0x12864b9c, 0x45db6164, 0xd0918517, 0x4caaebb7, 0x735bfa63, 0x0b5a163e, 0x49058c9e, 0xd36f0546, 0xfdfceafd, 0xaf4f8fd0, 0xa8e72376, 0xf528f0dc, 0x9f65baff, 0x05424df1, 0x661e1c1a, 0x5f59ac1a, 0x1ab140ed, 0x17d95484, 0xbbc8ff22, 0xd973af52, 0x1a026b79, 0x04ff8854, 0x0dd0df1f };
const u32 bern_num_data487[179] = { 0x20f19f71, 0x02ade569, 0x9beb5cdf, 0xfb7258d7, 0x9d543faa, 0x3646ffa4, 0x7d6c84b4, 0xb42dbdac, 0x87144601, 0x145903fa, 0xf50b1678, 0xd9b9d428, 0x5de2d2e4, 0xb45b1a5b, 0x28b864d3, 0x83ef1b35, 0xfc33749c, 0x5b8489d9, 0x36892eac, 0x15ed3dba, 0x7868e773, 0xe0f19bb5, 0xfd13e6ab, 0x35241ec1, 0x4ae4f1a7, 0xd68e6d2d, 0x31baa044, 0x9139ac4c, 0x4b480bdc, 0xa59fc51a, 0xc7f179a7, 0x457ed299, 0x1076dc49, 0xe015c694, 0x677c98fe, 0xf559f710, 0x33072772, 0x161f791a, 0x88793dc2, 0x1af0889d, 0xc0647b79, 0x90cac619, 0x828f1a33, 0xdc460304, 0x0a9c9f6e, 0x69940c22, 0xf4660a73, 0xe86d8a8e, 0xe4d5cae3, 0xdf961d6a, 0x49a388b0, 0x247c712e, 0x3c91f710, 0x6348ea8d, 0x1baecfc0, 0x2fba1119, 0x288a0645, 0xd4a6d77a, 0x85ee605e, 0xef91cfc9, 0x8e4cd9dc, 0x68c14e78, 0x480909ff, 0xc1873d87, 0x4cb5d8bb, 0x13c7b7e1, 0x3d322201, 0x8293d861, 0xca379a8a, 0x8a05259e, 0x1f0dae06, 0x5781c2a5, 0x506109b8, 0x73bbbb15, 0xbc4ae9fb, 0x909a24b9, 0x5e3d6051, 0x851c842e, 0x764d6ea1, 0x3465b595, 0xa62dd77d, 0x922080bc, 0xc94c07d7, 0xf660f419, 0x5246a5a8, 0xe4a9e19a, 0x3285ffc8, 0x2af1dbe6, 0xc4542bbe, 0xe833e028, 0x121cc7e2, 0x7f4e6628, 0x346e2dd0, 0x240e1ec9, 0x695cf29a, 0xdbb7a911, 0x07744d4f, 0xaf40c55e, 0x5f1392a4, 0x53d7440c, 0x5ff15476, 0xee3e6e2e, 0xb96b1cbe, 0x2754c731, 0xcc872487, 0xa31b9084, 0xf0c084b2, 0xe16df4af, 0x88e15300, 0x679e7f36, 0xf0b82fd5, 0xdb771544, 0x70043cb2, 0xd280c98c, 0xb097fb85, 0xcb9f2555, 0x9ac7f95c, 0x2e3fa5c3, 0x8b0b1856, 0xc4679d61, 0xa233c9b4, 0x745cff7a, 0xb15f3f63, 0x51b8f7a1, 0x29063035, 0x4a1561ff, 0x0a0a77c5, 0x3315ffe9, 0x9e613c22, 0x73a0a8e6, 0x0b654e0e, 0x7554c513, 0xfcfef642, 0x088ad618, 0xf4570cf1, 0xe0b9e4dc, 0x191dcdca, 0xff01d2e0, 0xebb75412, 0x616b916d, 0x2716609d, 0x369a63dd, 0x32340901, 0x68a045e0, 0xc5d78a22, 0xb791b523, 0xf3395cda, 0x0fe22ed6, 0xce3e66df, 0x799b1114, 0xcef599f7, 0x1821dfa2, 0x19731a9f, 0xefadf6a8, 0xa845c023, 0x212239e1, 0xd99591a3, 0xdb37c0e2, 0x26cfb5a4, 0x0831fb7b, 0x79c60c6c, 0xb9ea30c5, 0x0b9ab922, 0x26d6c168, 0x413b6a76, 0x44e14a19, 0xb13b667d, 0x18bfe856, 0xd17ccaec, 0x7c430dd3, 0x6eed5670, 0x4f80eb22, 0xe9154651, 0x04522742, 0xa4c49cfc, 0x09b311a8, 0xb4e62408, 0x509d48d7, 0x06706b44 };
const u32 bern_num_data488[179] = { 0x44ae9619, 0x614fde8a, 0xdb8668a0, 0xe54ae31a, 0xe2c268e9, 0x5bf17f69, 0x19034e36, 0x842ff175, 0xa99e044e, 0xec7f8091, 0x685db5b0, 0xf0f5b342, 0xcde7fcf5, 0x4f823c5f, 0x373fd759, 0x1b136a65, 0xd5691bdd, 0x4eb1cd3a, 0x4402b332, 0x783c135a, 0x6231d60d, 0x5bc69b40, 0x8d441fba, 0x4969f515, 0xf7b68c77, 0x5ee00557, 0x8b86a7c9, 0x39fd15bb, 0x6a26af19, 0xc9ddfe6a, 0x3662611e, 0x231a93cf, 0xb259b9d7, 0x0ffcc107, 0x0afd5943, 0x89388ac6, 0xf27a4297, 0x6c2baa7e, 0x00514212, 0x3cf0babc, 0xaddc8331, 0x628d5605, 0xd6493222, 0xa2a04a94, 0xc6abefd7, 0x0ea90932, 0xf3d65f9f, 0x111e8a2a, 0xf84f8fd6, 0xa5456b94, 0x750c92dc, 0x78a57eae, 0xc470c115, 0x9c7057f0, 0x8da17710, 0x003616c6, 0x2ec0ab1f, 0x8d376235, 0xb6dc0315, 0xf3714312, 0x60e72e57, 0x769b926d, 0x9ea7325a, 0x48a7da9d, 0xeb3f7fb3, 0xed303283, 0xc6d0f933, 0x72a27741, 0xdbe3f355, 0xb492e16d, 0x92c50fe9, 0x30b0a27d, 0xbbfb0b82, 0xcc82a4f5, 0x0301eca2, 0x771aa02b, 0xe4d4c1ba, 0xfa04d9f3, 0x40449638, 0x677cab8e, 0xe8a17f88, 0x477bd902, 0xf4159a77, 0xd758bcdc, 0x26c2436a, 0x8ce4f2ff, 0xe86434f9, 0x189c1656, 0x6e0a92b4, 0x48cf30b4, 0xbb6c90bd, 0xf6ea49f6, 0x6072f506, 0xc0dee1e1, 0xdced2341, 0x978b36f7, 0x492322ff, 0x4f4397f3, 0xc9f075e6, 0x8afd8db8, 0xd95f12fc, 0xe0b4b8b0, 0xadd03a17, 0xb0a072fd, 0xd9765a03, 0x2c270b0e, 0x27bd48a4, 0xa3951928, 0xf5b8c16e, 0xfb9adba4, 0x738ff410, 0xf44d7108, 0xa82e305d, 0xaa73d923, 0x6ea39cb6, 0xc0660e98, 0x0ba968c0, 0x85ac21aa, 0x8da0dbe2, 0x61296755, 0x15da8e07, 0xac0920ac, 0x6dd0497c, 0x10abece1, 0x7e134efd, 0x1ae01ff1, 0x0d16e39a, 0x650ecb3f, 0x56ec607f, 0x7c7f5cda, 0xb71b6edd, 0xca3e1435, 0x430452f6, 0xc869b324, 0xfec3064d, 0x5d3a0275, 0xf0d969a1, 0xed48dbb0, 0xd82aafc6, 0xb3ad5eb4, 0xd15f1b13, 0xa2d29f19, 0xba733a26, 0xac63c487, 0xd2485295, 0x201d0fb6, 0x737eba07, 0xbd4731ba, 0x22aeb1d4, 0x2801c923, 0xb24871b5, 0x9eaef697, 0x0022f672, 0xccd5f2d7, 0x25abe76f, 0x8610463d, 0x0bbba44a, 0xdbdb85f3, 0x14b52149, 0x19ae17e9, 0x17201f45, 0x040a368f, 0x6bff8e0a, 0xd54a6870, 0x1ca81539, 0xe870e7fd, 0x699624fb, 0x17a181d6, 0xcf3fd203, 0x547eb10b, 0x0cc4126a, 0x18e463ff, 0x2c1d3b20, 0x6fc6d8f2, 0x46af02bd, 0x8faab2ea, 0x403e91c1, 0x2f11bc3e, 0x0d22fdfa };
const u32 bern_num_data489[181] = { 0x74dba707, 0x1a60497a, 0x65447543, 0xdf4233f0, 0xae2df77a, 0x08b0bc34, 0x0497ede8, 0xcbd48877, 0x6b34b1f9, 0x814fbbfb, 0x07a5ccae, 0x69072f4d, 0x695ee63a, 0x10e16128, 0x1861f6e1, 0x150dd057, 0x3cb17d8b, 0xc068b573, 0x6db0cb89, 0x92034b52, 0x471415f6, 0x1629f5b7, 0x9dc2ee52, 0x3713c6e8, 0xcd81bf15, 0xdf1011b2, 0x052ac094, 0xd4a614b0, 0x889e8477, 0x0e84b32d, 0xa9ddcd92, 0xb99b2e04, 0x6038bbb4, 0x4bbcdcae, 0x6379debd, 0x3169ab67, 0xef22caf7, 0x7150db5f, 0x9c559f0e, 0xc4cc4254, 0x0dc84915, 0x685e0302, 0x8676764e, 0x282a4059, 0x32124eb9, 0x3d732374, 0x09740bd4, 0xacde5cc7, 0xe88f5d7a, 0x75d2dc99, 0xadf0b719, 0xeef2fe54, 0xe92510a7, 0x5f15d2b2, 0xe7405723, 0x5a5b6ccf, 0x5ce03576, 0x023e1057, 0xdd4e705d, 0x470fa3e0, 0xe82bac99, 0x724be7fc, 0xa714cf29, 0x5e83e329, 0x96c6e2d1, 0x28ce9101, 0x7569c2c6, 0xc27c33d5, 0x4e1d8978, 0xfa120e96, 0xac8f00ee, 0xac2b5794, 0xe807e4c3, 0xff1426b2, 0x604f7a23, 0xe2145525, 0x727e0c2a, 0xd147f73a, 0x392b6c82, 0xa8ed260f, 0xf18fe4ca, 0x836a2d3e, 0xaf70c81e, 0xd7e1840d, 0xb0eed270, 0x70b5e12d, 0x3d3faa07, 0x52962262, 0x4484ecfc, 0x847d1e2e, 0xe8b7a2e1, 0x292394f0, 0xafc4c74d, 0x9ab821e5, 0x8777c489, 0x4f169853, 0xbfe010c1, 0xebf619b2, 0xfae5c794, 0xdf278e69, 0xf06e6de0, 0xb34e7b51, 0x094c2c90, 0x57e118db, 0x82b49cdf, 0x65b5890a, 0xb723f52c, 0xaf193f98, 0xb46fc598, 0x8343677d, 0x530f688e, 0xaee37465, 0xd67f2e08, 0x1d15eb1e, 0x110bcf3a, 0x02bc3497, 0xdfa111c2, 0xdd6f921d, 0x8f49ef0c, 0x9c6e5846, 0x7d70c4d1, 0xd84e5661, 0xd7769f74, 0xb7827583, 0xf20a9d0b, 0x1b4162eb, 0xe78c7c75, 0xc1678bb0, 0xf4a94479, 0x509cb103, 0x62e4a7c3, 0xe33cdaf4, 0x1aac35c2, 0x4f5f9c92, 0x26d43e3f, 0x24bbac40, 0x63ce1a2d, 0x3ba84667, 0x93bc8239, 0xa0c595d8, 0xfc951b42, 0x076a2013, 0xea5fc062, 0x92d44833, 0x508e1b49, 0xffba756b, 0xe0fb6a3f, 0x57b83bde, 0x08abaf7d, 0xd327f95a, 0x5e47e40d, 0x346f82a1, 0xa4d81d22, 0xb4fc2268, 0x18af0b5e, 0x6600695d, 0xc48754a1, 0xac5ae902, 0x148338de, 0xf162a7f4, 0x0072138d, 0x0bdf57bc, 0x47f92b45, 0x612757d6, 0xf1d855d8, 0x492d026e, 0x3365b151, 0xf1573efb, 0xd1764408, 0x595c4a20, 0x1d5df613, 0x1298cee6, 0xf1a82ed9, 0xcaa3077e, 0x0fef3d11, 0x3d03d7be, 0x179a3737, 0xb2c28805, 0xae84d799, 0x5d274a4f, 0x000001c6 };
const u32 bern_num_data490[180] = { 0xc6563db1, 0x76b65498, 0xb0d9bc65, 0x99399f4c, 0x1e3048d6, 0x963d3ceb, 0xfdc5d1e3, 0x8ad4563b, 0xd96fe65e, 0x15590e89, 0x4ea217a8, 0xb6157b3f, 0x4d80eff1, 0x30d64486, 0xe7c4f88b, 0xa34cc650, 0x1da5ea97, 0xac4753d2, 0x18de20d0, 0x40c4e656, 0x0dc9c461, 0x271b1905, 0x14f6d9ad, 0x720782b2, 0x2aa561e8, 0xe2f99612, 0x893951ad, 0xde197722, 0x12a4b482, 0x2f92d71d, 0x21e96f96, 0xcc7fe585, 0x0b38f2f2, 0x6cbb4b52, 0x75ca3be0, 0x3af22ac9, 0xa0eb7730, 0x0d01105b, 0xe318c9d5, 0x9d2ebd42, 0x7d944937, 0xcb49b884, 0xb8737fd5, 0xc952c47d, 0x89d25eac, 0xb792697d, 0x0a372d69, 0x0107ba24, 0x653bb3b6, 0xf1be0a98, 0x39a26183, 0x7988ad0a, 0x56b7f2aa, 0xec6cccf4, 0xd34be220, 0xb65b6cc5, 0xaf359de7, 0xf7dab15d, 0xf267d491, 0x5badacdd, 0x785a8e53, 0xaccdb5c4, 0xc5b34e39, 0xf38e7bf1, 0xcc32d283, 0x5e59e468, 0x86feb80c, 0xdc7157dc, 0xc3017f47, 0x68430268, 0x471d8863, 0x3c5ed9ce, 0x2fdecfa1, 0x51f0536a, 0x94da9465, 0x74b49fb6, 0xb7cfbc67, 0x76c810c7, 0xad471a2b, 0x6cb1fc6a, 0x339396a1, 0xd4f79180, 0x9f19f8e9, 0xc64919e6, 0xbc4d0eaa, 0x7e61975a, 0xf29c2d06, 0xc84e8f6a, 0x2b65f409, 0x65fcf654, 0xcbbbf0c1, 0xfecb9264, 0xe295bbe0, 0x939ea720, 0x9baa2f69, 0xb59cdb41, 0xdbba9b0a, 0x51b476d9, 0xef146467, 0x357720c8, 0xcc4e2690, 0x3fbabdf7, 0xfe5bcfd3, 0x78335a72, 0x2bb708ea, 0x4d3afdc5, 0x18508f36, 0xca31d78c, 0x3e9a0e2c, 0x40851ff0, 0x653c3a8f, 0xde66715c, 0xeeb882cb, 0x53d546f3, 0x2546f597, 0x81d33a7a, 0x98e1acb6, 0xf38c67a1, 0xa93f9689, 0x8fad7f7e, 0x39cbc049, 0x8d0d153a, 0x9d61dfd2, 0x9af43540, 0xcb311688, 0x71040b51, 0xb5b5b950, 0xec30b4a7, 0x98ed7d72, 0x7263e8fc, 0xe792fd60, 0xe8a589a8, 0x58e2e8a6, 0xc34e9e37, 0xfa72d09a, 0x7921ea8e, 0x3ca9f527, 0x154e7c3b, 0xaf8001fc, 0x3ff1eec3, 0xc7be065d, 0x44272afd, 0x91172663, 0xf4e92173, 0x704d8330, 0xb0510c37, 0xaee8f054, 0x45de4c9a, 0x6099ca65, 0x0dc4be43, 0x9a6a4a1a, 0xe54ac0da, 0xf6608223, 0xd930d9c6, 0x4da52d23, 0x6c93c9b5, 0xa030ece9, 0xfb24ec50, 0x382f181c, 0x589e8fb9, 0xe3252021, 0xc11737eb, 0x605bcb7c, 0x782007d8, 0x87baa44d, 0x2ec1fd2d, 0x187e87e1, 0x2ff908a5, 0x832a9475, 0xfbc9e378, 0x79601ce6, 0xc5c8455b, 0x3c1b8e0f, 0x904c3c98, 0x97ba92cb, 0x521ab7d1, 0x1da34f99, 0x8e7a94b8, 0x6088b3f0, 0xfeb68df3 };
const u32 bern_num_data491[181] = { 0x2315b9a1, 0x79264480, 0x1f484057, 0x8d488547, 0x65e57dbc, 0x6ed0fbcb, 0x6f0e7f6f, 0x9485171b, 0x556f62e6, 0xc7398c18, 0xf7fef883, 0xb71d8acc, 0xe3606889, 0x8f0f13e2, 0x7087468e, 0x79e16346, 0xe3101f61, 0x5af37e4a, 0x1e6f669e, 0x7dde5842, 0x107957d6, 0x82e71700, 0x8005b905, 0x62c12929, 0x59abffac, 0x2d8942b2, 0x9691acce, 0xb070eb0b, 0x94fc6bc9, 0x0c117302, 0x8dca7c3a, 0xb463e185, 0x2074f98e, 0x3f60b0a4, 0x29e316ed, 0x6b1f1313, 0x94303930, 0x210d8e5a, 0x650bd572, 0x344638f8, 0xc1251718, 0xd7adca65, 0x99edc878, 0x2da99468, 0xb3eba18b, 0x3394f6e1, 0x15e3cf63, 0x81447ddf, 0x967b553a, 0xa8429603, 0x70a7433b, 0xad470d67, 0xce2a8015, 0xc911946d, 0x8bb9d324, 0xa548b77f, 0x3fc7e71d, 0x20c1f525, 0x74b9b65e, 0x47a28db8, 0xf4baa41e, 0xa2ee307d, 0x35ac85a3, 0xfc4b705b, 0xb4337170, 0x676a9b49, 0xcb8ce83b, 0x5bd287a4, 0xbae6e645, 0xf767cdf8, 0xb3d5d356, 0x978d8d57, 0x38daf125, 0xb3268dbd, 0x546ee3e6, 0xc7683a57, 0x625c5115, 0x2013d0a5, 0x4b494aab, 0x78b9b175, 0x6017ba95, 0xf4186571, 0xa15afb0a, 0x9dad988d, 0x75e1646c, 0xcfed3cd8, 0x9703d70d, 0xfec777aa, 0x24fc3959, 0xb2550175, 0xce96c6ec, 0x53a4d2a3, 0x3468e42e, 0x55a16420, 0x6f5985ae, 0xac8e00ab, 0x63b867ca, 0x6e43bb9f, 0x56081c0c, 0xd882a10a, 0x33624e44, 0x70fe59c4, 0x7841f648, 0x2390c852, 0x4c36f3d0, 0x4436ccd6, 0x2265637d, 0xfc20e7a8, 0x31c30b01, 0x9cb350d8, 0x1cd42353, 0xc69f7b2f, 0x6d88307e, 0xcf26f315, 0x4be05fc7, 0x34f9ca9e, 0x058afc00, 0x07d47e47, 0xc2e5c781, 0xc4a67336, 0x631752e0, 0xad726778, 0x1c69af6a, 0xae43f7b7, 0xbfeba4a4, 0x01a4c266, 0xc95b92d5, 0xd24e2f47, 0x312f527c, 0x2ffa5271, 0x1e4eabcc, 0xf95410fc, 0x1a3e28a4, 0xbbd856d7, 0xa9dbe8e4, 0x822ce4b5, 0xdfed9d5e, 0xd363e1a5, 0x73c01156, 0x132827da, 0x553d9256, 0x9586f4d3, 0x2544357d, 0x829850c6, 0x76bb21a6, 0x0c11f47a, 0xdeaa90c2, 0xe5185829, 0x0da65ff1, 0x2cd4ba78, 0x8e582c04, 0xc48b6708, 0x918de82d, 0x35be54ca, 0x4a9b2abe, 0xb1b63ac9, 0xea0c9e23, 0x6422c78a, 0x79873078, 0xebb2214e, 0xd69e13d2, 0x0651359d, 0x514fe9e0, 0x86e3d816, 0xa05d4b0c, 0xfd213465, 0x1ea7b00e, 0xe72b255a, 0x3b61c2e4, 0xb06bcdc4, 0x83d8e250, 0x22fdaf11, 0x823e69e9, 0x54dd2da1, 0x84e6f834, 0xa75b379e, 0x67930b29, 0x2e30033a, 0x5b017fb3, 0x3950ec35, 0x000e4a71 };
const u32 bern_num_data492[181] = { 0x2b848e75, 0x82c0fcde, 0xbcaf8230, 0x461c0256, 0xec81c172, 0xeaf2ee18, 0xfc9d9feb, 0x701888d2, 0x69977215, 0xbd6873de, 0xb9dc5daa, 0x67893f26, 0xe301c376, 0x9ec91486, 0xeb04038f, 0xd88a4c5c, 0xd1d87d7d, 0x4df4a15c, 0x0802875b, 0xd5813981, 0x4f3997c9, 0xe28f85ec, 0x44d420ac, 0xf86c0807, 0xea1cc324, 0x254234ac, 0x1c1321a9, 0xa5482392, 0x1b1abb8c, 0x4f2096a1, 0xb1306b1a, 0x03e32f6a, 0x41a0bd82, 0xc156c43f, 0xdddc29c2, 0x9bf2c281, 0xa39a6ead, 0xc9b7a957, 0xe253953a, 0x5a292a16, 0x00336983, 0xe238aa51, 0x465dc8c4, 0x1e2347ce, 0x0d45cd49, 0x6ce929c9, 0x33c9b987, 0xe67f6625, 0xe3076373, 0xabb4fb64, 0x204f49dc, 0xd8f61db6, 0x06ebd1a0, 0xa538b1d4, 0x16ca4bb9, 0x200ccddb, 0x87e0926e, 0xc3a2f2fb, 0x4ae82362, 0x03e77d5f, 0xa489e515, 0x5351f42e, 0x0c709584, 0x328318fe, 0xee6781b6, 0x1c00a936, 0x444a9860, 0x23fa399a, 0xd2eee9db, 0xbbf41338, 0xc6291a1a, 0x8070b0d2, 0xbf26e0a8, 0x8de89b84, 0xbec28098, 0xe093cde0, 0xb6cf707f, 0xbb358701, 0xe1e8f659, 0x15b5c130, 0x8718d3f3, 0xce8a03fe, 0x33bd52d3, 0x658c7c5b, 0xe79498a6, 0xa0f2ffde, 0x6db6a943, 0x8e3b44e9, 0x147ecac4, 0x135bf1d4, 0x42066518, 0xd52f0bc5, 0xf51fbdd3, 0xfcbc8b1f, 0xda3d97d1, 0x587e1fe0, 0x8d3866c4, 0x0c59e15e, 0xaab2976d, 0xf9193aee, 0x1adda9c2, 0x3dab234f, 0x54613f0f, 0xc8090ada, 0x1712193f, 0xfdf26c3d, 0xcd78f4d2, 0xed80c6f5, 0x91bcf37d, 0x63ca00de, 0x70e68846, 0x30ca4379, 0x7533a02c, 0xae1b5346, 0xaeea80be, 0xa836d899, 0xbd1837ed, 0x4150dd64, 0x70e73f15, 0x54e5bea5, 0x195b9338, 0xbaed25cf, 0x4cd52066, 0x562d59c5, 0x22536a0f, 0xb46b1276, 0xe342be79, 0x25735b94, 0xbfe14bfb, 0xca96f640, 0x01788388, 0x0df591eb, 0xa2245810, 0xdef5b1dd, 0x8b0e72cc, 0x76ad4eb4, 0x156931c2, 0xc5a0de3b, 0xb368f616, 0x94f15711, 0x375c72a4, 0xb9cee162, 0xa1a5d25c, 0x535341d3, 0x14f7849d, 0xc09b64a8, 0x131d76d1, 0x0676428d, 0xe156c622, 0xeba14529, 0x23a18dbd, 0xdf19b8f1, 0xe3e5c9de, 0x260dd171, 0x127bf884, 0x6e6b19c5, 0xbdedebcc, 0x1463e51f, 0x128be691, 0x257c63b3, 0xd44297c8, 0xd6fab40e, 0xf9a46c18, 0xffb36b2a, 0xaf6013bc, 0x7f6cfec5, 0x25fd2da6, 0x47661fca, 0x81189d20, 0x9dc914f3, 0x8fb10250, 0x076b09a3, 0xea6fd57a, 0xd90fad99, 0x07d37880, 0x8410a3ae, 0x609c6683, 0xefc79eb6, 0xac0a8961, 0xb7a9e226, 0x022540ae };
const u32 bern_num_data493[182] = { 0xadeddd7d, 0xa187fccf, 0x8e702cb9, 0xad44d770, 0x5fa606fc, 0xfb9d321e, 0x8825e3f1, 0x8ea08d7a, 0x339408c3, 0x8c3a4d42, 0x98d2e48e, 0x1aa709ca, 0xa259131c, 0x0906e5b9, 0x3be136ce, 0x9627c2d5, 0x7473be4f, 0x1316e1ec, 0x20a690d3, 0x8370583f, 0x03db7484, 0x200ffee2, 0xc906f4e2, 0x479b9887, 0x3915f3b9, 0xff68ac1c, 0x6f347092, 0x985abf07, 0xd66660f8, 0x89bd42e4, 0x87c246b6, 0xd893ec6b, 0xefbc4a20, 0x804c15a1, 0x4d8c1545, 0x0ea76099, 0xc5e60dd8, 0xccd551ab, 0x4815e018, 0xc5e395cc, 0x835e51b9, 0x3dc6b814, 0xa4fbea58, 0xc9695208, 0x5d38a468, 0xb2899f39, 0x6fb026d0, 0x31af141e, 0x64a2738a, 0x0ee07c3c, 0xf12445ac, 0x393cc1de, 0x22d31ac4, 0x9bd4c0ca, 0x41d35158, 0x75ea8dfb, 0xb22ba6d8, 0x09fddc88, 0x5ccadd3f, 0xc5fcf205, 0x912d10d7, 0x4e62490b, 0xdeceb5a9, 0xbefe3d24, 0x78b58487, 0xc80eeb3e, 0x09caf9cb, 0x741e26ae, 0xf10ffe75, 0x606d29dc, 0xb4a29ac2, 0x9823c355, 0x3e1eac87, 0x2300780a, 0xd6ef6df4, 0x634050bc, 0x128c84ae, 0xe0d69b3f, 0x65407d0e, 0x8e1dd4ed, 0x8acb62c6, 0x6075430c, 0xc7723377, 0xb77fd3e2, 0x389257f6, 0xdf48580f, 0x544791af, 0x1cebc685, 0xc2114558, 0x80408241, 0x4bd7d87b, 0xa7549dc3, 0x850a2dbe, 0x48cb85ea, 0x43364bba, 0x9b2f11b0, 0xd23f1311, 0xc6e7778e, 0xff0eb986, 0x28760e25, 0xce31d44d, 0xd53724e2, 0x02457ab3, 0x05259dac, 0xe2899727, 0x08a51c2d, 0x8cf82aa5, 0x72a9c5d5, 0x393113e6, 0x8e90f258, 0x1e9be960, 0x1a5f4173, 0x304bc99d, 0x2a086deb, 0x0b270499, 0x081fb07a, 0xb2bcbeb5, 0x34e7909d, 0xa725d887, 0xce87615d, 0x50d0663f, 0x1799ade0, 0x6298a48d, 0xb93dd433, 0x507bee19, 0x48b899b9, 0xc7444b97, 0x3fdf4227, 0x7bca4f29, 0xef5cbcb8, 0xa8b2d6fa, 0xd999aff1, 0x7de114f1, 0xe551ddce, 0xa59a86da, 0x9cf4b931, 0x5bab3a3a, 0x340465e1, 0xb16e85bf, 0x74b90608, 0xc810bd35, 0x061236a2, 0xbf25c2aa, 0x4fdc504c, 0x2e5e5f06, 0xc9993da9, 0x4120906c, 0x1a75c8d1, 0x8818d81d, 0xaf06e519, 0x6ffe7449, 0x1b08f2d2, 0x49513368, 0x637d69a0, 0x323bef2c, 0xd2854f7b, 0x7b8f7c3c, 0x2e941910, 0x93b757f8, 0x260f7ae6, 0x67e83ab1, 0x20df3d4a, 0x43823e10, 0x43da2ed4, 0x2792686a, 0x8106b8bf, 0xddcbb9cf, 0xd200e642, 0x75d9af71, 0xa011eb48, 0x613a85cf, 0x2dd6586e, 0xae80688a, 0x866c92ba, 0x2d7edbb3, 0x8ee72fc2, 0x9ae7fefd, 0xfb12a3d6, 0x699fa991, 0xbf164242, 0xd2c98bf9, 0x000003a1 };
const u32 bern_num_data494[184] = { 0x8b122ea1, 0xe70fefbb, 0x629c55d1, 0xceee56e9, 0x29b084de, 0x62c1692f, 0x49e44e63, 0xb3343e68, 0x487dbc1c, 0x3e1edc9c, 0xbb815d9a, 0x796159d1, 0x3cbe3673, 0x6a4fac8f, 0xd790190a, 0xade9dcde, 0x0b9340eb, 0xd263f4d9, 0x2ae5d4fb, 0xe5a66394, 0x7e5a428e, 0x78fea21b, 0x1f6a8e6a, 0x57dda83a, 0xd24102f6, 0x444a512a, 0x53c1c5ef, 0x4d0e927e, 0xf407e74a, 0x68250a8c, 0xad48b54d, 0x6597cb1c, 0x8b9fdee9, 0x98a33aaf, 0xa404f330, 0x974b9342, 0x8c081c3b, 0x8cf6261d, 0xc23b4fa9, 0xe9faa1b7, 0xd928bad5, 0x8300183d, 0x90124385, 0x0aa17a09, 0x5f9526e9, 0x324bb046, 0x54dacf37, 0xa7912459, 0x5c9e3358, 0x198345f5, 0x10ced13b, 0x3786c1ea, 0x2c91d3b7, 0x76712aba, 0x02f5882d, 0xab2cb8ae, 0x1bd1c440, 0xfcad6486, 0xf6512383, 0xcde97298, 0x8302ae47, 0x758a0630, 0xfbeb769f, 0x396b1819, 0x9da75108, 0x3bf787e9, 0xd15dff99, 0xe737f4f4, 0x674a16b1, 0x2af09463, 0x37693378, 0x4830f14a, 0xbeb7a8f2, 0x716c25f9, 0x2d0735f1, 0x00a05f2f, 0xc1b2a472, 0xa2a1a93a, 0xa952b77b, 0xc1f77d65, 0xec1f2bd1, 0x096b9948, 0xaa3f5fc6, 0x1dacd675, 0x266bae18, 0x49e9a244, 0x47ec87a7, 0xe31da793, 0x62413916, 0x1372dbae, 0x9f68d030, 0x3ad41711, 0xfe9bbe5a, 0x0fcdc64c, 0x47f7d558, 0xdc88e6bd, 0x297ce77c, 0x23b048ab, 0x86d7ea77, 0x9d7da62c, 0xe8b2b807, 0xc46f2a1a, 0xee32339a, 0xb7bb33b6, 0x7ebe0572, 0xd927dd50, 0x927e2887, 0x85f09460, 0x7ddcb550, 0x43e8b630, 0x4f2ffd24, 0x9c10c51b, 0x9a0812d0, 0xb5ad872d, 0x529d2c0b, 0xf7071d41, 0xa618194a, 0x1559cd7f, 0x8906bfb5, 0x1d0ab76a, 0xf7e7fc99, 0x4dc3ee0e, 0x2b7c73b0, 0x8abf4ad4, 0xa0a92652, 0xc9b2e227, 0x3da93ede, 0x16a6126e, 0xc2c6e221, 0xa5123212, 0x25e8ed51, 0xc16cb85b, 0x7104a0a3, 0xacdb7e60, 0x84c4dac7, 0x0d7b91b2, 0x5d6ddfa2, 0xdb028532, 0xdfe68d37, 0x02307d42, 0x86ddf5fd, 0x82763918, 0xad33e6f3, 0xb8c96d91, 0x685284f4, 0x8b217dc5, 0x6cc82195, 0x9afcbc35, 0x2d1c2e24, 0x777d537a, 0x638ffd75, 0x0d334c65, 0xed736bf9, 0xef893054, 0x5abb1f2a, 0x781f1d28, 0xbef299e4, 0x84ba7ab0, 0xbd0b83d1, 0x29ae2501, 0xaa921978, 0x7c3f1102, 0x50f8bb00, 0x00758a02, 0x33194114, 0xefdb1d23, 0xd480f41c, 0xff3ec795, 0xa97db5ab, 0x3f2e2dd3, 0x1b32427a, 0xcb1b857b, 0xa026d211, 0xf57dbd28, 0x8b42e61b, 0x66102e13, 0x97bc188a, 0x38ca1ae6, 0x0495aba5, 0x055c8333, 0x2f5479d9, 0xdce20f3b, 0x8578ca64, 0x00000015 };
const u32 bern_num_data495[183] = { 0x1b5310c1, 0xbcaae970, 0x2d74ea5e, 0x3c865a3c, 0x6babe1ee, 0x6fd25ea1, 0x0b609fd1, 0x9763d224, 0xe72d1696, 0xd3c7bed5, 0x2834df21, 0x100975ae, 0x304fb074, 0x196bdb9c, 0x14901baf, 0x7acb5800, 0x4cff29e9, 0x9ca7b60b, 0x1bdaf875, 0x349117ca, 0xfcf40a14, 0x92099d4c, 0x5ec6f1e3, 0xb93b88f6, 0xb25801f0, 0x1c121beb, 0x0fc1d67e, 0xc3c675f0, 0x1c823abe, 0x39dba3d3, 0x6b99e51e, 0xe41456ae, 0x75229aff, 0x6ac0c3c1, 0x2289f6f6, 0x1d512134, 0x0ce3ad7c, 0xe99100dd, 0x29b7cd3a, 0x7725c27a, 0x10cad60e, 0xa6a8dcb9, 0x69cb1451, 0xb195dde8, 0x56002e7f, 0x31edb5d2, 0x0dfc1dc7, 0x60f154fc, 0xe810170a, 0x427e917e, 0x6fa9fb2d, 0x609e08d1, 0x35f74b39, 0x2b3696f2, 0x80f226a5, 0x4ed6335c, 0x886b4be5, 0x6c0d672a, 0xe80b0be5, 0xd67b46f0, 0x18e28df8, 0x1f6cfaf4, 0x99833820, 0x9e283e69, 0xb80e14b5, 0x57b9bd46, 0x752fcecb, 0x68b8883c, 0x28ae9833, 0x5f6cc131, 0x18aa9861, 0x0870a331, 0x1253c77d, 0x98a3b3b5, 0xfec2fbf0, 0x783349f0, 0x22ca0ecb, 0x6bb65acb, 0xbd2e5a5a, 0xdae55efa, 0x53106a38, 0x01206daf, 0x04014c75, 0x4a125157, 0x69e86301, 0x547be4b6, 0xe332261c, 0xbfdfe8d7, 0x29f76def, 0x6b70256c, 0xfa373c25, 0x7cd99a17, 0xa25c4506, 0x9754ac42, 0x68322a49, 0x93ce5f65, 0x8e4a2dcc, 0x8bb0be8c, 0x61b5dbc3, 0x6b0d2885, 0x7c87bba7, 0x4470ae03, 0x28e5c1ca, 0xffb31cdb, 0x5ddde8dd, 0x6310ee80, 0xe81674f4, 0xbd5027c0, 0x467bbbcb, 0xed6db303, 0xfec757d0, 0xa0eee452, 0x49f4e983, 0x33ff9933, 0x53f0b94e, 0x30a79c1f, 0x89a4e670, 0xb45a3eb3, 0x32055ad0, 0xa4bff090, 0x9f464f6b, 0xf1543427, 0x67536675, 0x4c709847, 0x94e3838f, 0xb3a46d43, 0xa2fae60a, 0x20bb838e, 0x6c7f3eb5, 0x1431bbdf, 0x8f8e716e, 0x71f05d9a, 0x0a4c2a15, 0xd30a9fcd, 0x524ddd3f, 0x642ad253, 0xe2b66082, 0xe7fb1031, 0x1663172b, 0x20aa0de5, 0x7368e224, 0x5c950d5f, 0x9f6030f8, 0xc9395945, 0x6e0d3f26, 0x5af9b550, 0x731b1a84, 0x153ccd93, 0x97e0a923, 0x9a342e6f, 0x242ec139, 0x60e27e59, 0x6f25521d, 0x55241adc, 0xfc1cf3a6, 0x8fa25523, 0x0cbd02b7, 0x8ce96d61, 0x5c7f1846, 0xc5cdb2c7, 0x4188aa91, 0x4c33f6e9, 0xceeb08f8, 0xe1600e23, 0xbb9982ed, 0x300b5966, 0x2f930efd, 0x6263f515, 0x7974a8db, 0x7df1d1f6, 0xab2e2825, 0x95442fc0, 0x5b18f886, 0x2db483fc, 0x49b129cf, 0x5b118852, 0x3a966d30, 0x37a2af37, 0x582c9c94, 0x175b9c14, 0x09afcc2c, 0xe2b37aba, 0x0000002a };
const u32 bern_num_data496[183] = { 0xc897eb3f, 0xf305e0db, 0x0bd6aa4d, 0xe7029cc8, 0x2349ab6e, 0x4813e689, 0xc396d9ac, 0x760340a6, 0x9fcb948d, 0xbc6a2b3c, 0x3b3e64e0, 0xea2061b4, 0x5e52895e, 0x732787ca, 0x34c0343f, 0x5a6cfa87, 0x370c589f, 0x5c9f5f60, 0x5dffcd19, 0xc4c4d895, 0xec3a05db, 0x62cdae4c, 0xa2f4b6de, 0xbe1b09ac, 0xd10471dd, 0xf2d1fa13, 0x3b0185b7, 0x49415295, 0xaa929986, 0xfbf1bbd8, 0x884852e2, 0x8b798a14, 0x4be84b37, 0x7f82e58d, 0xef08ffb9, 0x643b2952, 0xe3973f6e, 0xb4a22eb4, 0xb9b957e3, 0xae0d3a11, 0x7e155915, 0xf70daba0, 0xd0867e3d, 0x6dad0381, 0xee2f7fd2, 0x7763e69c, 0x2cf85172, 0x55c7703c, 0xfd4e3d21, 0x0c48f44c, 0x576718a0, 0x0bee656f, 0x235e9692, 0x22a54a6f, 0x57fe8a3c, 0x19bbc1a9, 0x3c5596e1, 0x038eaca1, 0x83e53779, 0xfd697b6a, 0x5e2d169e, 0x88e0fb8c, 0x0e18684c, 0x5ef919bd, 0x514d6513, 0x77e8b15c, 0xc0dcc227, 0x80468b45, 0xe5a86a94, 0x2db0e420, 0xffbd0140, 0xb83d8f53, 0x52a29da1, 0x1dc633ba, 0xe5ad4a48, 0xdd917c10, 0x584096c2, 0x27244ce3, 0x4cb9a340, 0x5dfcf850, 0x2348c79e, 0x4ddc56c7, 0x1e7ea1a2, 0x6ff1cb10, 0xfdf94639, 0x677f237c, 0x70aa21c5, 0x8a7a97b3, 0xf0dbbd20, 0xc7b0cab4, 0x68fd74c7, 0x01251d11, 0x57a99830, 0x03c94ec5, 0xd9555822, 0xfc697e63, 0x3c2e2977, 0xdb3d08aa, 0x6bccfa82, 0xe720abf7, 0x23d4176a, 0x2089c1e5, 0x126d5b9c, 0x76fd8e38, 0x75cc9a45, 0x6c8aa3fd, 0x2b80e01b, 0x51f5ef89, 0x672632db, 0x775293ca, 0x5b8ac6f8, 0xfc8becbd, 0x6474f15b, 0x0b494f73, 0x32627197, 0x8d35d267, 0xf7fd87db, 0xdc2d1d3a, 0x22d90af9, 0xb4014a9a, 0xe4c240b2, 0x299fddde, 0xd9a6b7f2, 0xbaf5209d, 0x554f8189, 0xc5498038, 0x566e14b6, 0xb0672e07, 0x2a969f0f, 0x43c29008, 0xd14eb0c8, 0xcd2a7618, 0x7cddeb87, 0x8a091c2c, 0xe2a4fdb1, 0x549e1417, 0xa12f2d63, 0x843938c2, 0xcb7583c5, 0xea3b2fb8, 0x3bd0f704, 0xa0269c6c, 0xc10ffea0, 0xe2627f8c, 0xf49f7bcf, 0x10e8cb5f, 0xe48bf048, 0xf8784c3c, 0xddebe6a0, 0xb679cb45, 0x5a7cb04e, 0x6d477081, 0x921baa0c, 0x670f61f8, 0xebd4d954, 0x067f3819, 0x1d499b21, 0xc63dcdad, 0xae92e7cd, 0xf42f304b, 0xeaa640c0, 0xc60507b9, 0x6a05a2f1, 0x633db720, 0x1cd7d5db, 0x55f3363e, 0xdc281f36, 0x4f1d804e, 0x08668cc9, 0x87a758a4, 0x5ecdfc78, 0x829524d6, 0x90d5fec3, 0x0e2b8ec9, 0x49b001d5, 0x8dc9bde1, 0xc1a59e3e, 0x39b2fbfa, 0x74e1ff2c, 0x5e019bc0, 0xb46063d2, 0x70925088, 0x00003146 };
const u32 bern_num_data497[184] = { 0x0d2b9bab, 0x6f3a4dd7, 0x333bbf4f, 0x583adc5b, 0x615aecd2, 0xdf9da0f9, 0xde3ff4ad, 0x6732923a, 0x75201b60, 0xf75fe0ff, 0x98256574, 0x5956633d, 0x7e4f860d, 0x1996cc68, 0x0dd830f4, 0x5b076871, 0xdacb774d, 0x3857dccc, 0x6509b066, 0x59f3f1e0, 0x50adf4d7, 0xf357a33b, 0x01684bbd, 0x1eedf269, 0x88d0e2da, 0x5ee5fdde, 0x7f71c6fb, 0xb21cf52e, 0x17e95b46, 0xc734d413, 0xa286c4cd, 0xa415c7a9, 0xd170374e, 0xacc4af92, 0x15fb3e3b, 0xd3d8a81b, 0xa512da87, 0x995f8647, 0x39b07cfa, 0x3015fe4e, 0x1c20ff71, 0x6dcd8207, 0x6e056d0d, 0xbca4f4d1, 0xc83fdc82, 0xa7740241, 0xe45aa841, 0xa6fbbdb5, 0x4cd3df98, 0xff6d481c, 0x4b89af00, 0x07c1e154, 0x951366df, 0x34b229f7, 0x2c7c0de9, 0x6274c297, 0x96df6518, 0x946cb5a4, 0xab3af3c8, 0x10e5170b, 0x9079b7d6, 0x9d1b5944, 0x26a87eac, 0xa7534b4e, 0xad0272b0, 0x0f58a9ab, 0xaa5f9707, 0x4b51a8c4, 0x494d9643, 0x48c029dc, 0x2e1ed433, 0x784b3d52, 0x65d9c0c5, 0x8ddc8400, 0x3ff320d7, 0xc53414d6, 0xb3419636, 0x2ee2e28d, 0x504ddd64, 0x27002770, 0x677a8f00, 0x60967717, 0x6c48d040, 0x907a210e, 0x56c84d66, 0xd2b3d991, 0xb2b109e9, 0x3552d582, 0x7d2e3a60, 0xf2a1e885, 0xa0177b13, 0xd3812c65, 0xb0227e2a, 0x1d2acc1c, 0xfad4528f, 0x095c3965, 0xe7771aa1, 0x561b2129, 0xaa0236a9, 0xc7b0c3f5, 0xb3186840, 0xa7d2af09, 0x185ef9db, 0x42dc8186, 0x7606b433, 0x9d843b3b, 0x91ab2c13, 0x296583d3, 0x288f0d63, 0x666147c8, 0xc9cbb361, 0x2d0a50c8, 0x8b7f2b8e, 0x935cdb1a, 0xb1856241, 0x06124fb7, 0x6988ad25, 0xcb5595c7, 0x525e4e16, 0x5ad60e5d, 0xa3dcc20e, 0x8a74d6d6, 0xd1f57ffb, 0x09391a83, 0x77cf85d5, 0xfca7d157, 0x3661e432, 0xf47e2d2c, 0x8f11d7f9, 0xb0785cdd, 0x786800e7, 0x4474af23, 0x0c14ce58, 0x629a45e3, 0xc60f07d1, 0x9ad2937d, 0xf8228c42, 0xcd14d2dd, 0x294ec819, 0x4055cba0, 0x396e0376, 0x29073391, 0x8607e1c3, 0x29b2e98a, 0xe5d81fc0, 0x68578915, 0xca1dcc91, 0x302782a7, 0x61154fe5, 0x5a119fbb, 0x8772e357, 0xf616c7d9, 0x29c71623, 0x70f1b9ac, 0xe01ab844, 0x7ce93d6e, 0x79ade73a, 0x85843caa, 0xa9814e1e, 0x4af399f6, 0xf1baf1a9, 0xba35b5a2, 0x167b3434, 0x15f479b0, 0x55593bee, 0x7c4d5e8b, 0xfb5dbbe8, 0x0eb5f5c7, 0x7da8b935, 0xb710d47e, 0xc56c2414, 0x8b7d9ab6, 0x586a2a12, 0xf19eb57d, 0x43a2f79f, 0xc2ca10d3, 0xa7885437, 0x03db2ab2, 0x1db592cd, 0xb56fd5ec, 0x5ae7ff52, 0x3b352d0c, 0xe47a1c07, 0xa61ff2b1 };
const u32 bern_num_data498[184] = { 0xf9f36e17, 0x20f9eb99, 0xbad9ec69, 0x57aab503, 0xe1f913e7, 0x50137ab6, 0x8097d55a, 0x745f675b, 0x0dc384d5, 0x8bf2f5ee, 0xebe5c0c8, 0xf2600330, 0x57e433fd, 0x7e7e74e9, 0xc18500b2, 0xb2010c90, 0x25bd6205, 0xca8f346e, 0x485d82e3, 0x34431833, 0x2559b068, 0xe8fea712, 0x8455c1aa, 0x275ba9f8, 0xe853700f, 0x25ca0880, 0x17db9ec3, 0xf099a46e, 0x6659620a, 0xdc5f023e, 0xbcc3ab11, 0x3f5e15d1, 0xed7ebdf8, 0x88455378, 0x6ae12a9a, 0xa00a60c4, 0x2f4d9c05, 0xeb30e16f, 0x7c4e9ddc, 0x1c9b967b, 0xf849417b, 0x48b08a14, 0x908fe4d5, 0xb247da33, 0x57b59aac, 0x9f507e97, 0x1f0ccc71, 0xdc38067b, 0xf8d5d0f8, 0x12d8c0f0, 0x9bbe3527, 0xb11acdd5, 0xac3acb14, 0x0dd0ed0f, 0xdf5a6ae9, 0x445c371d, 0x55bbf4b4, 0x27d32e14, 0x15bd1a11, 0x53cd302e, 0x342d2a31, 0xf5d33886, 0xaf58b0cc, 0x7d6cda2f, 0xdefa8ed8, 0x78459da0, 0x78b87ffc, 0x14d81ceb, 0xa6de9ca1, 0x010e4428, 0x7554b41a, 0x7dcf842b, 0x0f1d163b, 0x54eaa5bd, 0xc0865ca3, 0xdec1d73c, 0x4ac38bff, 0xed0a74ca, 0x9d60c2ff, 0xdf7f5959, 0xc39b0f4c, 0x7f09692c, 0xd70cfcf2, 0x998f72c3, 0xd3d5f794, 0x081ec139, 0x1019049c, 0x23f0af22, 0x23bcfa9b, 0x900c26eb, 0x6b7470be, 0xedce1408, 0xb2540b6d, 0x925e0b33, 0x40a0189c, 0x34178682, 0xd61f1b56, 0x9261169a, 0xf4454ea5, 0x89d7c80f, 0x2d3e393b, 0x6267b227, 0x652961bd, 0x592a13ca, 0x709eb87b, 0xf553a125, 0xa2314662, 0xdf7864e1, 0xb92e8d2c, 0x134d7888, 0x74ee0ff0, 0x15aa974f, 0xafe10c6c, 0x2be7e629, 0x29632f0e, 0x16008692, 0x44dcefb7, 0x03d1bd5d, 0x51a8ca66, 0xe0539f3b, 0xf7b9527e, 0xcc7dd73e, 0x67c8b4fd, 0xf38e1662, 0x2dbef109, 0xed5e88a2, 0x044aaf27, 0x1a729ad9, 0xc51d23a2, 0x59322065, 0x8b5fd6c1, 0xe12e0b2e, 0xa17133c3, 0x1aeff5a0, 0x0ec04d1a, 0xfff37869, 0xebbd6f3f, 0xbee0cec2, 0x4ca872db, 0x6297428b, 0x0999c274, 0x1eb82272, 0x987691f8, 0xaf73f3df, 0xae55cc16, 0x5e8677e8, 0x03d5aa6b, 0x016f4510, 0x31b8e000, 0xf67a48bc, 0x23697269, 0x2d511820, 0xb22f1bbc, 0x171a549e, 0xa8ba9dd3, 0xe9eb9374, 0x0e7fae1a, 0x944d799e, 0xd2c6aa5a, 0x3d57b23e, 0x5f76a852, 0x3759f5ea, 0x5be89e37, 0x8eed05c1, 0xaa93d393, 0x4c4dbee1, 0x9a3e18c1, 0x948bc55d, 0x2e579358, 0x34803bd6, 0xa1c13171, 0xed6bf6c1, 0x4c752c42, 0x52d223c5, 0x933911e5, 0xc226d9fd, 0x1b88fd9a, 0x1993ae83, 0xd252a63d, 0x7e1d4f72, 0x6d64d933, 0xe86bbf1c, 0x37e76c5a, 0x00000742 };
const u32 bern_num_data499[185] = { 0x5aaf8b95, 0x18e997e5, 0xe85f3ca6, 0x9e5f579f, 0x46491957, 0x265a3f4b, 0x36a3121e, 0xd8b696d1, 0x022fa82e, 0x42a1b997, 0x6f166609, 0x308e6152, 0x249f5f49, 0xa6d07ff2, 0xdb1e2738, 0x9a208bf1, 0x89a2f17c, 0xcddd8083, 0x4538704c, 0xa60e59b6, 0xdb132feb, 0xa685b415, 0x67fd90cc, 0x9cbe9afb, 0xd4e5ffb0, 0xf9b6aebb, 0xb97b5e96, 0x177d0d82, 0x0942ec21, 0xef1fbdaa, 0x10d1ad4c, 0x8346eb9f, 0xa3b40e51, 0x7278ba28, 0xb3cc93a0, 0x0f9e24e3, 0x6cb2c82b, 0x633289f8, 0x49ba361a, 0x0fab1268, 0x557b7f3b, 0xff2c2f1f, 0x3708ca05, 0xfd60439f, 0x052ed679, 0xabd94cab, 0xfc1777f1, 0x06742bac, 0x9276a4c0, 0x715ebfa8, 0xc8fd662f, 0xa6a9fb77, 0xd54f9b5f, 0x635d1a1e, 0x66cfd358, 0x59058683, 0xa5ac5da9, 0x6b7a777a, 0xdc3ae546, 0xc886ae98, 0x490de3f8, 0xbac6fe82, 0xf5d7b396, 0x714d87bc, 0x139d42c7, 0x886c01d5, 0xfe049a3e, 0xa67b607d, 0x04013881, 0xe2fc2205, 0x174cc277, 0xf057c29f, 0x99b20416, 0x8835b489, 0xddd1c65a, 0x512bd402, 0xaefce472, 0xe6274a85, 0x39ee3bdd, 0x8622f332, 0x59e9787d, 0x09f2c4a7, 0xcdf5183f, 0x2ebc34f1, 0x7b958c19, 0x758cfead, 0xda2024d6, 0x6568b024, 0x314e339e, 0xa8761b70, 0xf3d4405b, 0xaff22f03, 0x27286d9a, 0x794735e8, 0x15b0bfe7, 0x21815b6f, 0x4eaa7f86, 0xb109b6e2, 0x5931ce1d, 0x30db4615, 0xbcc7c054, 0xbb5777ab, 0x89129d0c, 0x9e4277dd, 0x849d8c3c, 0x3cb250f0, 0xf5f1cf75, 0x9d7e4cf9, 0x8f3b83d2, 0x8a79eb07, 0xc8d63edd, 0xf641635e, 0x86cf81ce, 0x32fbbc32, 0x20969fb6, 0xce9eeb82, 0x75a035c2, 0x6bb4eb09, 0xc31c678f, 0xf17c8d74, 0xf1d0d2be, 0xfefc1188, 0xd85a497c, 0x22aa34c1, 0x2ec52f42, 0xa4c270bd, 0xbf65e6db, 0xffb63561, 0xf4c50687, 0xb70fc65c, 0xcc936c1a, 0xa4908e6c, 0xdac80c74, 0xde363734, 0xc5974746, 0xb0ea9340, 0x6a03dbbc, 0x828a46dc, 0x283e88fa, 0x1696149d, 0xffc61f6a, 0x2fd66a4b, 0xdf758776, 0x8e603f3c, 0xdd87b63a, 0xe239fdbc, 0x101c321b, 0xfed2f7db, 0x58ff1fbd, 0xbb51acaa, 0x49653f06, 0x21b8270e, 0xf06e8845, 0x465aabc2, 0x20e3b944, 0x2403680b, 0xaf18c9c9, 0x659bfd99, 0x6779bbf1, 0x8d392edf, 0x5c421055, 0x2802c4dd, 0x889a27f5, 0xa115b84f, 0xda563355, 0xc6f6f5f3, 0x5cf476a6, 0x7b129717, 0x0d654a64, 0xff2f9819, 0x2a426944, 0x710a881f, 0x6423e391, 0xfb168d45, 0x03493c69, 0x6a78d998, 0x8ef109d3, 0x410219ba, 0x0299c0fe, 0x26c74a99, 0xd0e2221c, 0xc8ad65cf, 0x78bf6d0a, 0x36477611, 0x00098cce };
const u32 bern_num_data500[185] = { 0x567e9c09, 0xc15f7d01, 0x26547e7b, 0x0973f646, 0xf5f2a6fb, 0x08cd1224, 0xb94a2794, 0x3ff209e6, 0x0e705f68, 0xa89c1481, 0x4eafe877, 0xf30e7169, 0x83ded5e9, 0xcd9d154d, 0xa879eff8, 0x2ebafc10, 0x71828c44, 0x07e34624, 0x05b1f9de, 0x44a4fc2d, 0x9255d083, 0x207c1876, 0xee43e6d9, 0x8a1a0ac8, 0x1323dcf8, 0x8ef8d189, 0x20b5de0d, 0xaebb1a90, 0x04f052b8, 0xf4d77087, 0x2996ed29, 0x18714527, 0xdc8cde07, 0x6d03206d, 0x83789ae8, 0x4967307b, 0x70272088, 0x26debafa, 0xfa6927ea, 0x10de49ba, 0x3f9dc605, 0x67db3cb2, 0x05b6d19b, 0xbcc5c45d, 0xdda50e2c, 0xda206b88, 0xb1da5b12, 0xa3872ff4, 0x82d381e7, 0x55bdd870, 0x676f03c7, 0x6ff54aee, 0x396d07d6, 0x767d62cb, 0xb713bd9a, 0x5990ae5c, 0x661d267a, 0xa69214d6, 0x79b125b5, 0x07e4948c, 0xe6ecf8fc, 0x775da3cb, 0xc8632de0, 0x8928f4de, 0x64ce8df5, 0x4f3e92b5, 0x80d1a693, 0xd655d86a, 0x03131c9d, 0x0a8ed603, 0xdb9c27f1, 0x97e35581, 0x253cde08, 0xa104e750, 0xcd3b67e4, 0x44600dd2, 0xb895344f, 0x55c8476a, 0xac472d4e, 0x0ea7c100, 0x0b537eea, 0x4ed23e2b, 0xabbc8d77, 0x93eb1c05, 0xc813304f, 0x21ab0934, 0x2129d197, 0xe0a86482, 0x9e598f88, 0xf0869a5f, 0xb5e519c2, 0x45ea5953, 0xc03e4986, 0xc25addaa, 0xdbab7f00, 0x382bb964, 0x369605fa, 0x26f70c09, 0x4fd10273, 0xbeeec2b2, 0xff2b913e, 0x503617b1, 0x30f9602a, 0xb115621d, 0x9549a257, 0x7690d493, 0x166bb9f7, 0xc19c8b15, 0x9b6cbfd6, 0xb3661884, 0x49129e57, 0x8b53a57a, 0xbfaa6b10, 0xa6d4cfac, 0xa06c9770, 0xdd82c751, 0x98e9579e, 0x061ae906, 0x99b5d81e, 0xc8eb3a24, 0xe382d29f, 0x36e7d2e5, 0x53c12f25, 0x3907c45d, 0xb19cfb07, 0x61f0620d, 0x3324a522, 0x6119f109, 0xa3101244, 0x8c6e2c10, 0x3c06ed67, 0x2a82bd96, 0xe5ed6cdc, 0x83877949, 0x6224f2c3, 0xca515948, 0x43f881be, 0xf8f9f32f, 0xd51590a6, 0x946aa379, 0x1f98378f, 0xbe1a78d7, 0x2a1be659, 0x1ca90fd8, 0x2a32964f, 0x5c5e34f8, 0x735c6d51, 0x9392e2df, 0x1da2a3de, 0x2efbf933, 0xb3454634, 0x787992a7, 0x1d290edb, 0x96ba5542, 0x98e499f9, 0xa7548b82, 0x91b3a096, 0xd87e3007, 0xf9d4b726, 0xdae8495c, 0x38edf8e1, 0x361d1d8e, 0x37b258d4, 0xa307521a, 0xefde68a1, 0x9accf991, 0xb722346f, 0x8424cdbf, 0x19fc97a3, 0x0a172d96, 0x374d60bf, 0xae0baad3, 0x67069694, 0x49fb337f, 0xd9d62af6, 0x2aa2a92f, 0xb5653560, 0xcc391c30, 0xfffd57a0, 0x960926f6, 0x24f3d4d5, 0x102ef329, 0x4c66dc7f, 0x13458000, 0x0000079b };
const u32 bern_num_data501[186] = { 0x664dbf6f, 0xc36d4f58, 0x00cc334b, 0x6616d8f4, 0xc58cd194, 0xf8ff4dc4, 0xb25aa24b, 0xa7032f9d, 0x4fa75ffd, 0x1cb4a374, 0x1f6f8357, 0x2233bbd5, 0xff5d85b3, 0xe8ac25d1, 0x57a5d87d, 0x9daac923, 0x96ff5ed7, 0x22da6553, 0xfb3040d5, 0x2b39c177, 0x68dc2dee, 0x1d5db611, 0xe2781f29, 0xc4e095a9, 0x965015e3, 0xc9771ed7, 0x68d9cd42, 0x3256aa01, 0xc9ee8892, 0x4ae0d855, 0x735f924e, 0xf7fef920, 0x4fddb4cc, 0x56ef3bed, 0x37ea2422, 0x63b2c35a, 0x012e3660, 0x43ee91ff, 0x0d7a6e0d, 0xb8cca0b0, 0xdf3dd00d, 0x9f9c4704, 0x0fcb8a50, 0x1bdd125c, 0x16afd93f, 0x7a548e7b, 0x9b19c6ea, 0xf11d0819, 0x97d68cd0, 0x55db6d0a, 0xd11530cb, 0xeae5b7bc, 0xe25425e4, 0xcd016c48, 0x457f5281, 0x7423a323, 0xd967c4a4, 0x2031dcb3, 0x4c2b7a80, 0x2f943406, 0x6b923710, 0x7ca911d6, 0xb30aab81, 0x1fcab86f, 0x4059c15c, 0xbb4fa3ad, 0xf5574e2d, 0x56fd1ea3, 0x096f4d20, 0xc38c2b10, 0x03314f23, 0x69d2b475, 0x2446b895, 0xd23453f8, 0x70930616, 0x802be770, 0xaed42ee7, 0x147c22d3, 0x7ff34997, 0xdb95ab12, 0x9d1ce563, 0x8a99d30e, 0x9f071f6a, 0xe1e744d1, 0x37441f06, 0x20e32a50, 0x58b13ed4, 0x86364d28, 0x6d28460c, 0xaba106a9, 0x24142357, 0x8e641af9, 0x76ad9c2b, 0xe0676128, 0x8e65a1e4, 0x9e88e19e, 0xc6929ce8, 0xf76b2971, 0xfbc6e2e2, 0x8d7b2f2c, 0x87f542e3, 0xab051cfb, 0x5e2857d5, 0x0ee9c286, 0x340ef41c, 0x3965b805, 0xc4604b9c, 0xe7ff3597, 0xbe51fc27, 0xcef8c08e, 0x492b4572, 0x4b40faa3, 0xd7dd412f, 0x85202094, 0x74ec4512, 0x1ea2bc6a, 0x20b04646, 0x258e9a58, 0x96e87ff8, 0x4c4048dc, 0x88c84f9e, 0x16e1d9e2, 0x11868b70, 0x57c76ae4, 0x3c123aaf, 0x3c612e91, 0xb340d4a0, 0xdc18ace8, 0xab612860, 0x077faa5a, 0x27af2e35, 0xab9a7830, 0x37e6ac6c, 0x0e08f418, 0x7535022a, 0xd7adcfd0, 0x937ac8b1, 0xb9e2334f, 0x6fe66c29, 0xad7607ea, 0x064c9acb, 0x8e7a2bfd, 0x2103b1a9, 0x874bb845, 0xdc794541, 0x5bc41fc3, 0xa76d32ce, 0x45bd7ea6, 0xa1c6f689, 0xd2cdb3d0, 0x30ba964d, 0xbd6f6f54, 0xf0327e9a, 0x741e84d7, 0xafec7f5c, 0x7c243a9d, 0x5019e3f1, 0x109c0d56, 0x125a4eeb, 0x25779b06, 0x99d850da, 0xbcbc81b7, 0x48baa055, 0x6a9436c6, 0xa733c8dc, 0x50aae042, 0x25830fd2, 0xa8f571b6, 0x38fc131b, 0xd3de1e60, 0x4a10d643, 0x9d9421fd, 0xcb2fb352, 0xfc21e759, 0x7b36de3d, 0xfba56850, 0x92f0d8d8, 0x2dac79ab, 0x332ef4bc, 0xc944725d, 0x172073dd, 0xa15f4778, 0xa8803803, 0x8694ed8a, 0x27993591, 0x00000004 };
const u32 bern_num_data502[186] = { 0x9869ef47, 0xab29b6b6, 0x2c9b96b0, 0x94c02056, 0xd3de0f88, 0xa453e653, 0xbea063d8, 0x084cd8db, 0xda7b8dce, 0xc69f9385, 0x6a462284, 0xed1a0c93, 0xc42f1e2e, 0x3961a59f, 0x5489beab, 0x35ab2ba9, 0x410b376b, 0x6b5f7649, 0x4eb5254f, 0x7a9db14c, 0xe4a89372, 0xa7d915ec, 0x43e663cf, 0x7551efc1, 0x9cd950f7, 0x91cfe685, 0xcfc272a3, 0xfe8bf680, 0xe6ead181, 0xc5377d84, 0x0ed41171, 0xce753daf, 0xb40aff32, 0x781f5af9, 0xbb61c167, 0x5e62e5b7, 0x4b8fd42e, 0x26c81ed7, 0xa42155df, 0x3ee8130b, 0x312f2533, 0x8a8a0ea7, 0x9dc0e00f, 0x518a70b8, 0x984c953f, 0x527fe1bf, 0xbd53ad92, 0x7d16ad6f, 0x12b0371e, 0x7716a65c, 0x339ed965, 0xaac08972, 0xb8884a33, 0x7b3f8b32, 0x0c1c10a4, 0x63e839f9, 0x1e8e736b, 0x3ba8a6b8, 0x5ca3035e, 0xd4a72b39, 0x49420ddc, 0x442a51e6, 0x84017e04, 0x3c588e3b, 0xca1d52b2, 0xc0fd82ca, 0xa5a05bd3, 0x21cb4cb9, 0x10635e37, 0x9d3cfaa6, 0x0186ee09, 0x9405817c, 0xd0d1d2e2, 0x1d8eb2fb, 0xcc142104, 0xbba5a200, 0x3f00d316, 0x49c0d322, 0x40aed386, 0x457737bc, 0x06fb04d5, 0xf368954c, 0x02bb3abf, 0x96fbb43d, 0x67e35d90, 0x15179ef8, 0xac017f7e, 0x9b0a58cc, 0x0d345ff6, 0x73956865, 0xdc95a5ac, 0x04624147, 0xfb0c2da4, 0xe3a770e8, 0xeda0988b, 0x7219dd5f, 0x9d14d151, 0x47081c11, 0x1e4ed0f9, 0x57736369, 0xd1c9ee6f, 0xf0466ff2, 0x7285ecfc, 0xf15dded6, 0xd0cf38d6, 0xe9bdee29, 0x1a6c86b8, 0x0504ca41, 0x293ffce4, 0x309d2678, 0xee2d44dc, 0x0661f15f, 0x03303a6e, 0x58c531a5, 0xbd083e5d, 0xf600a19b, 0x4ea5cd1e, 0x61af6b1b, 0xb8934cd5, 0x3f2645e8, 0x5f8e3102, 0x68475e85, 0xbf75b94e, 0xd102ca7f, 0x8b0d9340, 0xcff726d4, 0x24d17038, 0x6343ec5d, 0x06137a3d, 0xff478f2e, 0x4c7b9bb8, 0x324a2cd7, 0x887a91a0, 0x772317db, 0xcc150a28, 0x8c7dba67, 0xf40be062, 0xbf1aa040, 0x5128af2d, 0xd2f2b30f, 0x5d1f2673, 0x43838264, 0x0cf676c2, 0x5ebbb5a7, 0xc03ac2c1, 0x05887167, 0xdea70cc1, 0xe67c64a7, 0x9ae07ec6, 0x2dd9ffe7, 0x4b7ab794, 0x96141210, 0x04cc50a0, 0xde738b69, 0x3b752b76, 0x50b50b6c, 0x5809dd54, 0x65e9baac, 0x569a98cb, 0x8ab28900, 0x69a957c7, 0x2128ade2, 0xfac65d5d, 0xcc4bd450, 0x9ca41083, 0x620d79db, 0x8a7af650, 0xbb311700, 0x99e4a96e, 0x2a064f7e, 0xb6d337cc, 0x2f3c30c0, 0xd8d6331a, 0x70a9eb60, 0xa1e6df50, 0xfcf20227, 0xc28e8c36, 0xff779998, 0xff83ba36, 0xff902b88, 0xba8a2351, 0x7aeddc3a, 0x9e8dec70, 0x7b309366, 0x4e635e21, 0x0000002a };
const u32 bern_num_data503[188] = { 0x9c567fbd, 0x5ed82dc6, 0xd7395146, 0x35902d67, 0x3742c491, 0x85eacd95, 0xc8c21123, 0x19c755ee, 0xdb732a2f, 0x2b28851b, 0xee45fff2, 0xc8735038, 0x1d84051c, 0x0f319db2, 0x2f5d77e9, 0x4790ec4b, 0x7390c56d, 0x30bac66a, 0x12edcc80, 0x3f7d50d1, 0xa3f228cf, 0x14959810, 0xbf752f4d, 0xbb9fbf72, 0xa385c2ad, 0x4e52cf15, 0xd456eed7, 0xd331446a, 0x98da8080, 0x5c8d53d1, 0x6448cb11, 0x7190f75f, 0x342a106e, 0xb0d77856, 0xb5af440c, 0x2bd034b6, 0x16417477, 0xddb7c43e, 0x8c964811, 0x3ad466b0, 0x03aa594f, 0xac03dcdc, 0xd28095bc, 0xeb76dbcd, 0x99df9762, 0xbd271555, 0x220e87a1, 0x6e41d313, 0x7ea1257a, 0xa3b2194c, 0x8df0d0cc, 0xd0cf15e8, 0x1ad7f00e, 0xd0a7cd9c, 0x8352907a, 0x43efac6a, 0x647595ee, 0x7bd3c291, 0xa614f921, 0x7d117709, 0x37ed6b96, 0x6400ab9d, 0x5396a12e, 0x44d29902, 0xb4c23462, 0x178d33d4, 0xffad21fd, 0x9dfbb66c, 0xb121b5d6, 0xa0d2f45d, 0x81f3a0f6, 0x81d818d1, 0xfb7bc0fc, 0xbac58837, 0x82ad3866, 0xb478b00a, 0xf1a4bc30, 0xcf61334a, 0xcf500d32, 0x222bc589, 0xbc23a246, 0x39712237, 0xf5a313b2, 0xf0223317, 0x2923e0f5, 0x3c6bcd83, 0x89bbb1d2, 0xdf50e0f3, 0xdff4e9ac, 0x3e2c2d7f, 0x3f5a4b33, 0xa56ac81c, 0x161abc51, 0x5d852d7b, 0x58c87f1d, 0x8225a4c1, 0xa237ac68, 0x66c6febb, 0xcee59ae2, 0xa8059534, 0x9dc4cd3d, 0x867339cf, 0x22035226, 0x4787c3dc, 0x4fdfe8c7, 0x45c9507f, 0xcad3a346, 0x2e9e9874, 0x443cfcd0, 0x5e2cadc3, 0xd12744ce, 0xadaa0f49, 0x6f5eb244, 0xe1dfd404, 0x33a660d7, 0xe0fc33c5, 0x18e5548d, 0x61f04265, 0x757e687d, 0x5b88dedb, 0x82ba9bdc, 0xa566c927, 0xa3495f8d, 0x1443211f, 0x3ebed678, 0xb3855c4e, 0xb4e2f38c, 0xbc408abb, 0x59316e04, 0xea776db9, 0x61675aea, 0xebec9bfd, 0x19ca198d, 0xcc8dcc49, 0x958b1a8a, 0xc45930d4, 0x9d6c751e, 0xcf35b767, 0x90abc7fb, 0x999d2e40, 0xcebecd03, 0x20ad3f1e, 0x30fe98a6, 0x284b7452, 0x2c0d0832, 0x033e3798, 0x6766d9c5, 0x06426a88, 0x3f1ee932, 0xafdb3c5b, 0x1bad4ea6, 0xc5cf22c2, 0xc97a98da, 0x921e34fb, 0xb2ff17dc, 0x63cccb31, 0x7b4ab7ae, 0x776fd645, 0x8c0c758d, 0x9968f555, 0x4a9999d5, 0xb29c2e45, 0x1589719f, 0xe8c4384f, 0x1dc1c3f5, 0xa6d5f2fb, 0xeaf3261f, 0x321fd99e, 0x72977af7, 0x608efc4c, 0x2b206c26, 0xbffc54a1, 0x7372dbc0, 0xc3d6417b, 0xbedfd855, 0x61fe5286, 0xe7c4db3c, 0xf3356b17, 0xbfd05423, 0x409c56d5, 0x8fbf9732, 0xf4dc24b8, 0x3918d6c1, 0x31430323, 0x77e90c48, 0x05201ee9, 0x320677af, 0x087d6a7e };
const u32 bern_num_data504[187] = { 0x5668d5d5, 0x769f0f97, 0xce3b9323, 0x5479f647, 0xf6f0f031, 0x257db5ff, 0x4924fe97, 0x7b68180f, 0xca2a2b93, 0x4edaaebd, 0xfeea7676, 0x7e5f1233, 0xce1fce2a, 0x7e04b040, 0x096dd6b3, 0xeffd0b2f, 0x818349ee, 0xf97a305e, 0x78c50b0d, 0x793ced3e, 0x676e4557, 0xa8c1d7e7, 0xbd7e159e, 0x3afcc871, 0x1007049e, 0x0a7536d6, 0xab784da4, 0x78943b07, 0x8a709d68, 0xeaf9c8ed, 0x5a337301, 0x2aaa28ee, 0x430fbf73, 0x35ef5217, 0x24111e92, 0x789b3fe7, 0x8d02d890, 0x60485a6f, 0xfeb8ebc6, 0xe96b4e0a, 0xc4131873, 0x2080b830, 0x62896ae1, 0x1729746b, 0x152c8423, 0x2a4f4def, 0x8c80ab19, 0xf70a896d, 0x18f58d8d, 0x804937d7, 0xb53345f5, 0xaa6c28cc, 0x6a1e1c6f, 0xb98493d2, 0xc84a6d48, 0xdcd9a69b, 0x68868fac, 0x6444c17f, 0xdeb1f7a7, 0xa91224b1, 0x00b5c950, 0xa3a3f442, 0xecb2f969, 0x102411c8, 0xf3a860d4, 0x8ffa2e50, 0xe30c77a0, 0xbaf1e829, 0x5a5d7329, 0xd9d39d82, 0x8580f5ab, 0x252ef3ac, 0xbb0bdd27, 0x0ea36f69, 0x305a9e0b, 0x64450c26, 0x56edec86, 0x990c217e, 0x4ac3f117, 0xdfe2eb86, 0x102e34aa, 0x88c977a3, 0xf979d5a1, 0x983fa2b0, 0xca18c8a1, 0x8394bde2, 0x816710a9, 0x3e64e52a, 0x4245ac21, 0x7df157b6, 0x1153faff, 0x6cafef39, 0xa168406d, 0xa7838ace, 0xb67798dc, 0x24c35453, 0x7136c86c, 0xb20b3edd, 0x338c41ac, 0x7ed1c186, 0x62b7c05d, 0xacd72288, 0xcdc6be6b, 0x427e446e, 0x1b51aee5, 0x9f87bade, 0x3016736a, 0x362a5025, 0x02584bd3, 0x863a4c8a, 0xd56b5d0f, 0xde98c82b, 0x71811581, 0xa28e4406, 0x8fc116a0, 0x3e29a99c, 0x67e030d4, 0x66fa0863, 0xa3e5b68d, 0x942909ae, 0x4106162c, 0x39aa75cc, 0x509c5cac, 0x4d257e2a, 0x130424f4, 0x4d82b723, 0x98646a08, 0x86284906, 0xd0a06369, 0x3dc2dfcf, 0x2617aff0, 0x02b1b7a9, 0x5bc55bd3, 0x01947886, 0xe1fc3d6d, 0x534fa589, 0x7916d3e9, 0x77f3e099, 0xc7a63e79, 0x8e835b78, 0xd5fc463c, 0x971fd222, 0xcdfb55fd, 0x3c001b8b, 0xa34a568b, 0x26427363, 0xa3e791cd, 0x1d4c59d1, 0xe59e9445, 0x65ba7214, 0x278e57bc, 0x4a08ac6a, 0x0b24c760, 0x4b85cc99, 0x9ab753dc, 0x9d2a1672, 0x463c3105, 0x33b9cfe3, 0x4aad5925, 0x1a44cf9c, 0xa7c3ba60, 0xf6c32d79, 0x6eda79fb, 0xd6abdf12, 0x9a45017a, 0xc01ba69a, 0xc47be3a5, 0x412df14f, 0xd3e11457, 0x437b465c, 0x4ede6701, 0xb96688d1, 0x1faf5b03, 0x0428ad0b, 0x1979fd8c, 0x3a93c97b, 0xa68e45fe, 0xd1376b24, 0x2bf6638a, 0x0107eae7, 0xd8ff9770, 0x3c729285, 0x0be14b54, 0x42270e5e, 0x482b811c, 0xea427c06, 0x00000047 };
const u32 bern_num_data505[188] = { 0x8cdcb885, 0xe1906103, 0x52939698, 0xd4287a2d, 0xc64b14fd, 0x37abc5bd, 0x91a11702, 0xcc5e33de, 0xca5d12b6, 0x4e70e915, 0xf1519d1c, 0xb231ebcb, 0x96d3e286, 0xee335f02, 0x373066c5, 0xb734e149, 0x92d932c6, 0xe983d293, 0x3e4c6c78, 0x4403381e, 0x3b10a4ab, 0xa0fa2d8d, 0xf2cbbc61, 0x9a1a3222, 0x90fe5403, 0x6f5b4d43, 0x8c3af217, 0xfc282180, 0xcf97c28d, 0xe98aa165, 0xa76c671d, 0x03b052ee, 0x3f91194f, 0x46b4a9f5, 0xbb901b96, 0x4b31dba0, 0x5d80a403, 0xe4e4d19b, 0x79514d15, 0x476366ee, 0xcf7732ad, 0xbbbb330a, 0x61ca5498, 0x0cfead20, 0x09d0283e, 0x57d91bdf, 0x4c777322, 0xd2a16b83, 0x368f4161, 0x7d6a578d, 0x554010f5, 0xb12a77b3, 0x22e41a35, 0xb0881c0e, 0x2661b8ba, 0x7e5c5cd0, 0x0a2c6efe, 0x3b9d0ba4, 0x4d1d6d61, 0x80b44382, 0xebfe7185, 0x8465f948, 0x99b86d9b, 0x236db266, 0xa4ae96ab, 0x89907164, 0xc95663d6, 0xae31d393, 0x441c6cd5, 0xbeb43879, 0xc46e305d, 0x74dc25fe, 0x257d8006, 0x11e31c76, 0xb08493f9, 0xc3eb3539, 0x8b20eb10, 0x2dc81489, 0xd43c70ce, 0x8af6b0c6, 0x3503b524, 0xbbaa2223, 0xdb0980b4, 0x890bf931, 0xb7e1a004, 0xee9c8de2, 0xb1ef7dcf, 0x750af785, 0x732d1230, 0x3110e9ca, 0x10b9e15d, 0x0d5f8fd2, 0x2956d409, 0xdd92953f, 0xfd7a59e3, 0x29ab99e4, 0x1fa57d08, 0xccd76d1f, 0x70de8660, 0x4931627f, 0xbd1249e8, 0x5332d56e, 0x457d6e52, 0x79ddef68, 0x626c1086, 0x75462c02, 0x9a16c314, 0x2d5cb67b, 0x1977a9a7, 0x823e9b55, 0x58670ee1, 0xcf46bea2, 0x7d1a306c, 0xe6b2dbd4, 0x4c3a0979, 0x46a5ecf1, 0xadd66dbd, 0x2f9ba36a, 0xc3901c4e, 0xb2bacaef, 0x02de7f1c, 0x80506043, 0x84caf9b5, 0x89dce85c, 0x38b5da71, 0x1c4f1298, 0x91798ae5, 0xb3cdd708, 0xa7c2da30, 0x7d6ad140, 0xc031d05e, 0x2c17254b, 0x4c310866, 0xc5e86ecd, 0xe4f9b0ed, 0xe3edfb68, 0x33033352, 0x75259e3f, 0xb06a0947, 0x6ef31a76, 0x5a056249, 0x33e33eaa, 0x869ea7f7, 0xe748e23e, 0x44c5d21e, 0x219c4710, 0xe5d51463, 0x609d85cf, 0x0e6e785d, 0xc3d10cbf, 0xcabcb490, 0xdd464544, 0xbbb878cc, 0x2f4f0c27, 0x3f01e092, 0x5cb54eee, 0xa52439c5, 0x13d4f3ff, 0xf3f82862, 0xd5dac212, 0x6e584b37, 0x5fd2cf2a, 0x4b37e070, 0xcb932ecc, 0x4d89dbb1, 0x0a56442f, 0x20c6e162, 0xe2b5bd39, 0x25f8f638, 0xa9fd2e6b, 0x96d95127, 0xb66ed87b, 0x17e1aac3, 0x80fa938c, 0x107ef76e, 0x278a5fa5, 0x215302ce, 0x325200cc, 0xd91555b8, 0x902ec8bf, 0x081ef593, 0x4bb92384, 0x38a3ae2e, 0xbe0001ab, 0xf7dc85a3, 0x677bb5f3, 0xfed1c10b, 0x000000d7 };
const u32 bern_num_data506[188] = { 0xd966bb0f, 0xade68bb7, 0xaf7ab3fe, 0xda932520, 0x2a6469e6, 0x23e5dbe2, 0x080dd833, 0x73f6fd9b, 0x2da42be8, 0x87111655, 0x6168fcd7, 0x4bdf4a66, 0x864c765f, 0x6967d879, 0xfd011c56, 0x6409b0c6, 0x37ea7e5e, 0x84721b5a, 0xa5543d43, 0x8b278159, 0xe7093b55, 0xb4873974, 0xa28a122c, 0x23cfb8b7, 0x3087a52f, 0x9c3b4977, 0xa3740957, 0x7add49b7, 0x3d575181, 0xad65336e, 0x09f6ce7a, 0xcc8eda01, 0xe23dff7b, 0x39a42bf9, 0xeb3512a5, 0xea41b6bb, 0xd5949d80, 0xba0cd4a9, 0xf5855cd9, 0x60c330c2, 0x50577cc2, 0xf32075e6, 0xfbd1056e, 0x5e6dbfaf, 0x671eae90, 0x1e8cdcc5, 0x19ac2b06, 0x7c8df320, 0x8d04a0de, 0x8dd53bd3, 0xc57b9b99, 0xfea9767f, 0xbf5b9779, 0x8d5cf5ec, 0xc7b894c7, 0x1c765052, 0x9a356754, 0x579521e7, 0x7270518e, 0x956bf02d, 0x917fb72d, 0xeeaa822c, 0xb411c4f5, 0x20d3bb34, 0xf0d279f6, 0x90533adb, 0x570dc2a4, 0x6ddff1cd, 0xeb223215, 0x42669d9f, 0x30af0c9d, 0x3ce160ae, 0x44ccf98c, 0x0438928c, 0x9b836bbe, 0xe6d54e04, 0x4cf193ad, 0x822b8f83, 0xd1269a05, 0x64aadaf3, 0x197f88df, 0x64bb139b, 0x811362f2, 0x382001fb, 0x0c94a5ec, 0xf1ca65c9, 0x64a49c33, 0x8767cb5c, 0x47b97861, 0xc9868be8, 0x57e54e65, 0x8524cfcc, 0x1581d4e3, 0x7ead5d07, 0xcf77572e, 0x9bf21f02, 0x5a7d3485, 0xd34f6b90, 0xa46d60d8, 0x1360493c, 0xad6d065a, 0x2ff690aa, 0x2004b1d7, 0x24247e75, 0x7e0c8573, 0x52f6d81f, 0xe162b9d1, 0xbff7ff66, 0x3824be30, 0x2dac1ff2, 0x7b20c66a, 0x87491b17, 0x4bdce740, 0x9659f7c4, 0x786347e5, 0x4e109208, 0x6f7f9465, 0x25554de3, 0x8842d398, 0x7bc7fb06, 0xc6063244, 0x65664152, 0xba08297d, 0x49901820, 0xf445b1c4, 0xae6cbb6f, 0xccdd0d80, 0xc9a8d56a, 0x5f88cbf9, 0x73defff4, 0xa4107e06, 0xb922f105, 0xbfb3d69b, 0x1bc45115, 0xf85e331c, 0xc708d09f, 0x529ef035, 0xad14eb5c, 0xc91a624f, 0x5759a214, 0xb57c30ff, 0x09f25f4c, 0xaed36742, 0xd2ead435, 0x64052b90, 0xfcac7f61, 0xec744949, 0xc61041a2, 0xc46c5927, 0x37b78188, 0x847a7d6e, 0xfd739731, 0xcfed4008, 0x050948e5, 0x1e76d74e, 0xdba40180, 0x75ea5324, 0x833c78c1, 0xd18355f6, 0xe8f601fc, 0x105fa759, 0x1206fa78, 0x681a8b2f, 0x235318bd, 0x7f80de91, 0xf117b5a4, 0xa3dcbfd7, 0xd52f3210, 0xeba1917b, 0x0f281db1, 0xcd14aa4c, 0xaef7ab71, 0x9ca22a26, 0x8e76fc9c, 0x7f1b3f66, 0x1f65be3b, 0x4ea6ebdb, 0x0ceee236, 0xced418aa, 0xc6c23d20, 0x130fe80e, 0xa6b679fe, 0xfa4d998e, 0xe49bf8c6, 0x16be8d28, 0x783fed0b, 0x9cdc18dc, 0x00000237 };
const u32 bern_num_data507[188] = { 0x76c32edd, 0x7856e725, 0xb74c1230, 0x769535d3, 0xeb3f1186, 0xa98a20fb, 0x978b2e12, 0x25799d54, 0xf8696ef2, 0x94bf967a, 0x70e5e664, 0x3b74a22e, 0x4ee51720, 0xc0265f83, 0xf89c1fa8, 0x427ed91f, 0x81004a07, 0x407d3b4e, 0x3d6c8286, 0xbcfe9d41, 0xad0310e5, 0x577fa465, 0x18236727, 0xf5df89dc, 0x5c1094e0, 0x6005d6d2, 0xe95b6b71, 0x12ed0d3c, 0x94af42f1, 0xc6628725, 0x22f5e9d3, 0x55284b7c, 0x5474bfa7, 0x54ca8b75, 0x7b33ecec, 0x770b0140, 0xa03ff7b4, 0x5ffd17a5, 0x60c3d5cc, 0x5e7370e9, 0xe208100f, 0xbddbf168, 0x3bd4f2d4, 0x8fed2eb5, 0x089d40ca, 0x2c1df93f, 0x035db92e, 0x2594593a, 0xb5785148, 0xf5448c95, 0x23f375d7, 0x81545b90, 0x7bd41628, 0xdeb26791, 0x0ac89ef0, 0xdaf7295a, 0x64aff7c5, 0x6f45d764, 0x7d4e0268, 0xcbf54c39, 0xcf479ba1, 0xe99ef28e, 0x088512a1, 0x69a01a42, 0x06a92ac9, 0xd407a3e0, 0xec00fe17, 0xde4d5c68, 0xbac6da80, 0xb1073213, 0xc420bcda, 0x4f237a58, 0xc159e046, 0x368e4f8c, 0x05e6a969, 0xe81a2549, 0x2d072da3, 0x01e88c97, 0x2c1c2b20, 0xb6a733aa, 0x956476b2, 0xcd7e00e3, 0x9a6bd56c, 0xeb4edc46, 0x9b7ce676, 0x302b99cf, 0x9f90f2ff, 0x76cc7821, 0x8b1df64e, 0x03e21320, 0x52483b1c, 0x4f1ef946, 0x6f7faa36, 0x2e4d2670, 0xfe943b81, 0xc0144ab4, 0x09aa3a52, 0xf6566e90, 0xbcd3df1a, 0xdda6c06e, 0x755a2cbd, 0xc57c61ef, 0x5d997277, 0xb44a1175, 0x0367f967, 0x0e4e1891, 0x4f8679e9, 0xde83f5be, 0x8d46fc97, 0x3110b711, 0x6ee0323c, 0xbcf2cc0e, 0x2cc93e3c, 0xb8ecd4ba, 0xbacc7b0c, 0x0bc58c8c, 0xae0a3487, 0x844e1908, 0x1b113a75, 0x58babdc6, 0xc2d8ed32, 0x43c6cba7, 0xab12b558, 0x363fb039, 0xe3eb6856, 0x382e51ea, 0x21f48997, 0xbcc5334c, 0x880c1b6c, 0x11e808b9, 0xdc86ecc6, 0x3a2b49e2, 0xc1c79bdf, 0xca7f8aa0, 0x1b4a7538, 0xb6ee95be, 0x24902412, 0xf0879a71, 0x24fbd995, 0x4c9239a4, 0x536b2981, 0x53de8ff1, 0x986c57b4, 0xd5fc6395, 0x7b68e54f, 0xa2dbb316, 0x2495607f, 0x53bdbc1a, 0x4bceb3c4, 0x2592dbdc, 0x84cda6d0, 0xa945ea9b, 0x2176cf9d, 0x63c550c6, 0x114e2bad, 0x50f9d254, 0x6ae33b98, 0xd6c2a714, 0x09dafd9c, 0x006e3ccf, 0xdc63ca97, 0xd0ca6fa2, 0x49be1b63, 0xbd337ae0, 0x7769cfe4, 0x36008179, 0x2221dcdb, 0x926153d4, 0x64a553c1, 0x1ec61f14, 0x419ca91c, 0x48541e3d, 0x14c33664, 0x5ea5db50, 0xb094d785, 0xad763f6e, 0x5937781e, 0x4f115598, 0x8f45d1b0, 0x6a60105c, 0x46a67e14, 0x10f49c1b, 0x2aa7ec98, 0xaf806ebe, 0x63f59685, 0x361482d5, 0x7e2cac77, 0x041133a2 };
const u32 bern_num_data508[189] = { 0x34ebaef5, 0x8d2e946f, 0x9997acb5, 0x45431e03, 0xb08bb6a6, 0x444a81c1, 0x11489453, 0x07e6a18b, 0x2751929a, 0x9692eb81, 0x1a905a9e, 0x2bf703ae, 0xcad40717, 0xa051b396, 0x77e5a02b, 0x7029e58e, 0x707e57d7, 0xadc8e5c2, 0xaf667606, 0x3e93c078, 0x9ffb2ad1, 0x114596a4, 0xb54443a2, 0xe214bf73, 0x9b4df615, 0x76c5ccaf, 0xc7338f9e, 0x63c15d60, 0x6143a48d, 0x0aee08f4, 0xacbe38d4, 0x6002e09f, 0xaa891746, 0xbe01a535, 0x786e1136, 0xc855dcdb, 0x4ac1173b, 0x5631f8ce, 0x7a824905, 0x4bfb26d2, 0x6396d069, 0x87836758, 0x3a96bb15, 0x54e2e893, 0x3f716802, 0x3120561a, 0x6ad354dd, 0x3af60be7, 0x1d185ca5, 0xbefc9dc5, 0xae42db6d, 0x56bdf9ca, 0xc74533c8, 0x0eae95b0, 0xec5ac985, 0x6e27e9db, 0x7a4b7f89, 0x6dfedaad, 0xdffba64c, 0x32c5d1d0, 0x9040e19c, 0xb7486e61, 0xf0bc339a, 0x61dd259e, 0x35481399, 0x780a647d, 0x8e22a7da, 0x8864986f, 0x6c1c2f9a, 0x790a3bd7, 0x45b0ffd4, 0x37ec7598, 0x8d4444c1, 0xad4cf341, 0xad0e3edc, 0x9dd8a03a, 0xf8eeaea5, 0x9b0dd208, 0xbaf4e48a, 0x3961d859, 0x8331af72, 0x329a388c, 0x5d674a34, 0x1f1bd690, 0xd1607d87, 0x828f0c18, 0x1f3eb5a6, 0xbf3f2e0c, 0xcd570851, 0x438d3f5e, 0x42d90888, 0xbf94a0cd, 0x2793b873, 0x218d52dd, 0xedcc0ba2, 0xb10f22c3, 0x21431026, 0x0fde5d43, 0xc31095a4, 0xc184acfc, 0x0979c326, 0x6dcea8ec, 0x81395386, 0xf6d78a92, 0x052a05b5, 0x7e79c61b, 0xcc20eb02, 0x80ae13c3, 0x524edc1b, 0x37ead405, 0x2c470fb2, 0x7196b37b, 0x16a1a8b9, 0x19bd183f, 0xd10eb106, 0x605d0177, 0x323fb5e8, 0x655e6cda, 0xe8ffd501, 0xe43a5216, 0x2e7a3509, 0x4646e666, 0x657ceca7, 0x6de4746b, 0xe13860cd, 0xfb9bd73f, 0x97d95312, 0xc78b9bae, 0xfe407c68, 0xd79f2703, 0xc715c0bc, 0x5401e100, 0x21a76b1e, 0x205b6e2b, 0x372a343a, 0x83476f6a, 0xa32929ed, 0x77541c3a, 0xa9b61f18, 0xe5e2259a, 0xf9a97c6c, 0xdb1976de, 0x10852d82, 0x26b14b41, 0x872c094c, 0x85b5865f, 0x9bf41c85, 0x71916e54, 0x4c293f46, 0xe429a210, 0x093249c4, 0x38b71551, 0x33d38144, 0x3079ff6b, 0x22fb99e6, 0xd7d8380d, 0x0eb34e1a, 0x89fbf906, 0xc77e78ec, 0x0f44c73a, 0xc468dd0c, 0x690b9a18, 0x123ea4af, 0x8df4943b, 0x1640b599, 0xeaa37739, 0x13abb753, 0xc2a0908d, 0x5a5a8e01, 0xdc6021bc, 0x465f98d1, 0x61d4297d, 0x0b9b798f, 0x7508b1c7, 0x84286cc6, 0xa367f830, 0xae4f783a, 0x144f47e7, 0xeb88fe90, 0x512e9fab, 0xd9e6302a, 0x94c10f4d, 0x2bb5d7db, 0x082f8276, 0x66fbbaed, 0xccc78523, 0xc4bc56ea, 0xd2233319, 0x000000a6 };
const u32 bern_num_data509[190] = { 0xa5bf2b11, 0x2f9487bf, 0xe83adc73, 0x468a778f, 0xb004c0d0, 0xd730376e, 0x25566ff7, 0xbaadef9d, 0xe549ed71, 0x99eb448b, 0xa6915414, 0xfd7855d4, 0xfe3aec19, 0x6f5b808c, 0x26a48b17, 0x4f9a7646, 0x50d0aaf6, 0x72820e15, 0xf4d2da39, 0xf7b98951, 0xef2a5caf, 0xeefc2df9, 0x01606820, 0x45cf6212, 0x0ca47b77, 0x0bf2c8ed, 0x88b0fb38, 0x17b3c86e, 0xdc58d399, 0xb8d2f20c, 0x9ee620ee, 0xa6adb236, 0x89caede1, 0x6b847f49, 0x7c47cafa, 0xe3dfad7f, 0x973e3a33, 0x0048b9ef, 0xdf7203c5, 0x1e4d88ca, 0x518423b6, 0x2842d5a2, 0x1a04f3b7, 0x16ce25f4, 0xd0bb8a7e, 0xae867cd3, 0x11373d43, 0x14e382c7, 0x9abc9d26, 0x4badc7b3, 0xf5018787, 0x6ad8a671, 0xf75496dc, 0x4c58c7df, 0x8c455ae6, 0xb868ace0, 0x312f0c98, 0x130d45ad, 0x8601334a, 0x6868c8d9, 0x37ba494a, 0x43fb9315, 0xb797dec3, 0xd2ed5d36, 0x2b055286, 0x0d577e73, 0xf1617ff3, 0xd18fdf4d, 0x640def3a, 0xa0eadf94, 0x3980285d, 0x8e5c321e, 0xe8a8989c, 0x0db28739, 0x6c64aa95, 0x5fd77526, 0xf7b1e1f7, 0xfca6db67, 0x7db49c88, 0xa0fb995e, 0x87327910, 0x896182ff, 0x6795caf7, 0xc524567b, 0x4eeedddc, 0xe7d9b026, 0x504411af, 0x469bb53d, 0xd1b303b0, 0xd621e4ac, 0x1645aa33, 0x0cc92b4f, 0x501d5043, 0xa9653a19, 0xd0778623, 0x5d3afffa, 0xe6aeacca, 0x7c494c5c, 0x37620e80, 0x89d2e49c, 0x57631ee9, 0x2a270b49, 0x730b44a1, 0xb01bf579, 0x5b7c2d2c, 0x0a0970c3, 0xaac0b050, 0xb85bb325, 0x97cdfb54, 0x6adaa722, 0x914bc9c4, 0x6ed73a49, 0xfee6c799, 0xe27f2efd, 0xc9e12cfd, 0x1db5ca7a, 0x45c596a5, 0x3a4460bd, 0x83da604a, 0x69d231c7, 0xf574240d, 0xca6df5aa, 0xcf27ac3e, 0x4d32d27a, 0x8fc47ce8, 0x1b4ba599, 0xc4f009c9, 0x9a64618b, 0x7de39486, 0x00470fe7, 0x6d762a60, 0xfe139d43, 0x3c0ccc5a, 0x58aae7ed, 0x68cb46ae, 0x1a37776d, 0x0eec8a59, 0x76d288b3, 0x0614938f, 0xa2680b64, 0x1564da2d, 0x289f1790, 0xd1451257, 0xcc5efa14, 0x2ac732aa, 0x37edc508, 0xf2068825, 0x4ba83ed3, 0xb1853774, 0x4457f943, 0x4c3984db, 0x138cc596, 0x1aaaf86a, 0x4970d311, 0x144f1611, 0x7128596c, 0xfa421f73, 0x96799f6f, 0x42df8b70, 0x7e112832, 0xf78b2fde, 0x572c4d2c, 0xac00e4b4, 0x7849792e, 0x1d7a38f2, 0x2914813b, 0x1b0e34c7, 0x9ad88ca1, 0x0f47a640, 0xc44cafed, 0xc0d87472, 0x0802de11, 0xec0df9ad, 0x1793604d, 0x55cffe39, 0x05ee9d36, 0x1b40c100, 0x0dda1c91, 0x8a71ae05, 0x10dee94e, 0xc978cb10, 0x693042c6, 0x9ce26a08, 0x19a5fcd5, 0xaf2215f9, 0xc47cb3f8, 0x4913d517, 0x295eda91, 0x2cbd456e, 0x000f3da9 };
const u32 bern_num_data510[189] = { 0x13569fa7, 0xc5304355, 0xdfa49865, 0x2020a58c, 0xa1a39421, 0x203034d7, 0x3fefbbcf, 0xcbf8161e, 0x4b617782, 0x66836a67, 0x0896099c, 0xcecdb800, 0xfccf6ae7, 0x700120a3, 0x7db5dc93, 0xda97c8c8, 0x0b5b4d3d, 0x425dd2bd, 0x6cbd63ff, 0xd881ce88, 0x1714d708, 0x2883850b, 0x002d02df, 0x28fcfe15, 0xd8d75bb0, 0x92617d33, 0xbd784d23, 0x8f0cc056, 0x631349d7, 0xbde2b504, 0xf4982d92, 0x80d1bfe3, 0x1fd30f57, 0x8853f10c, 0xf5d9db68, 0x137736e6, 0x9fb109a0, 0x6e584427, 0x02a55ed9, 0x9b5a24d0, 0xd27db557, 0x4fdabf84, 0x4458dbe3, 0xf20141d5, 0xbed25d5e, 0x133705cb, 0xaee7e03f, 0x44b15944, 0x2d4b6da2, 0xbe237df1, 0x3463b3d4, 0xaf8c9709, 0x870a6d6d, 0xe79492af, 0xb4da6300, 0x0b2fed51, 0x101f1b83, 0x107b33fa, 0x8af9c016, 0xf17165af, 0x602a5a53, 0x95ef26a6, 0x412bf80d, 0xd9380cf8, 0x1f2bbda4, 0x07a4c4fe, 0x91597783, 0xf597f658, 0x94bd87b6, 0xcd73fcee, 0x9e19629c, 0x7969da37, 0x899ae29d, 0x87214b52, 0x60def9ef, 0x5bdb4df6, 0xa36b41cb, 0xd12eb174, 0xa41fdc07, 0x39863b15, 0x867cdc06, 0xbd4f8d2a, 0x1a70d630, 0x5fdf0df4, 0x3698372a, 0x57f6140a, 0xdd79c5ff, 0x838f1b39, 0x23416d4d, 0x0b29f29b, 0x77ccf4a5, 0x3922dffb, 0xadceda7f, 0xa68ea196, 0x0f83ad06, 0xa2fcc8bd, 0xce21bbf4, 0xd5cb0305, 0x9067c62c, 0xb7b6b167, 0xee2e6c9a, 0x102ad32f, 0xdfdef6a4, 0x77be067f, 0x8cfa1b2d, 0x6fcbc8b5, 0x90608af0, 0xc6d3138c, 0x58c0847e, 0x6d4df877, 0xf302f931, 0xa26964e3, 0xd578c0be, 0x4d747e28, 0xd062f6dd, 0x3e467f5b, 0xbfc002d1, 0x5f5ba935, 0xc7cd9cb3, 0xcf18dd88, 0x5bd1a282, 0x4811f679, 0xf1d296a8, 0xc78484f3, 0xafbe7786, 0x07529228, 0x327d9931, 0xd8ca5ae8, 0xec9f2a95, 0x2c9f632f, 0xa2276da2, 0xdecf761e, 0x7ccab5fb, 0x3af0410a, 0x4c5f7cac, 0xa65d0448, 0x5ad0409b, 0x8521d36a, 0xfdc916c0, 0x6b1979a1, 0x23732e19, 0xbf274339, 0x11510384, 0xee3baba8, 0xb7533a46, 0x42c29e31, 0xa80a1d68, 0xd57cd92e, 0x0805cd0b, 0xc43c0427, 0x6e633b0b, 0x3d9aa9ff, 0x57d14964, 0xa54428a9, 0xed70bfa4, 0x5d9a78c1, 0x75fa9f2f, 0x6e80f6bf, 0x18207c9d, 0x7bc7aef0, 0x4051ec29, 0xf2941c3d, 0xd7fb1c7b, 0x661c2040, 0x049209db, 0xd1bec544, 0x3fe7b535, 0x20469181, 0x2674f31d, 0xd93ecf3b, 0x4256a99e, 0x4914deb8, 0x14019360, 0x298ff786, 0x6db0fbc1, 0xb2facda0, 0x6e97d192, 0xaa7496cc, 0x965af180, 0xa54eb2e9, 0x12262758, 0x25bc1ea0, 0x0120cf42, 0x4df3cc26, 0xd71d7190, 0xa97ff39d, 0x91831feb, 0xd21bff57, 0x06ca4fe0 };
const u32 bern_num_data511[190] = { 0x985bc801, 0xe2efa863, 0xded6a118, 0xfa7978e4, 0x5397de0c, 0x04fa2e54, 0xc43eb18d, 0x5a9e8956, 0x3218c825, 0xe185ded3, 0xbbb47b9e, 0x6c22eb9c, 0xd9c36983, 0xac1e17cb, 0xa263e877, 0x6158848e, 0x4ad26271, 0xb6a87ef6, 0xa2082640, 0x026e2950, 0x5e1f0c2a, 0xcf3ebd7a, 0x548c6228, 0x7e023799, 0x24322ced, 0x0f52f22f, 0x0545adab, 0x0ea1c36b, 0x1d678d90, 0x18fb12f4, 0xa8dbfe99, 0x8c6d853c, 0x87344bfd, 0xae1107a7, 0x6b79fc9a, 0x963c3dcb, 0x5cc48cbf, 0xc95196c2, 0x23078068, 0xd0051639, 0x39af7274, 0x5cd89a3e, 0x238df6cf, 0x3f83b9e6, 0x9d6e6c3a, 0x97d49ceb, 0xf3404d4c, 0x5c65b328, 0x04107b9b, 0x079da3a5, 0x459b3089, 0xf5228983, 0x8db7dc29, 0xc6ee06d8, 0x69e8c188, 0x39646ae2, 0xc5bc9377, 0xf89b40cf, 0x700201c3, 0xef411c11, 0xb0029006, 0x9657701e, 0xc28d5b07, 0xd7cfe28f, 0x4c851a9a, 0x9f4fc983, 0xf3d1637d, 0xcb144809, 0x4ba0e117, 0xd67d1d95, 0xebaf12dd, 0x9aad7112, 0xbe474114, 0x77897e6a, 0xd9e0753a, 0xadc81dd9, 0xb1d53b0e, 0xe9bffce4, 0xacdba800, 0x991bd08e, 0x77f85667, 0xbcc5c3d4, 0xd382ef33, 0x3c97cbd2, 0x0a7a4d40, 0x5ac43363, 0x4f9517b7, 0xbdc3792d, 0x3bdaa228, 0x9f043cf8, 0xd13cee93, 0xb912906d, 0x23143dfe, 0xc520adc9, 0xaa4519a3, 0xf820adae, 0x16ceb3f7, 0x91676c5f, 0x7c57a23f, 0xe557125a, 0x37d097b7, 0xc55ae199, 0x682c817d, 0x968df478, 0xe87cd5b0, 0xcd2fd551, 0x388ec3ab, 0x33cef349, 0x0200c067, 0xe4a84732, 0x34f279e5, 0xb11364a4, 0x8f60b467, 0xbcd25e9d, 0x3e518db8, 0xb34f414e, 0x79343222, 0xe8a05ebb, 0x267acc67, 0xea64fbc7, 0x4e95daae, 0x4095c98b, 0x1cc82dc8, 0x25d5a5b0, 0xb0a28e6c, 0xc68c59e4, 0x01e09e47, 0x74f89ea0, 0x617d071d, 0x1fba355e, 0x73cddeac, 0xb10b0d56, 0x52622a1b, 0xc7052f12, 0x44a29d4a, 0xe71202a2, 0xc031effe, 0xf08d7d4f, 0xf95fc2c5, 0x74c603b8, 0xab60549e, 0xc445b4b8, 0xfdc1fbe9, 0x422fa77a, 0xeccdf247, 0x861fb382, 0x3131874e, 0xe7abc01f, 0xd2ec805a, 0xcb26dda4, 0xbcc27681, 0xdf75a1d2, 0x54ecb550, 0xfb1698b8, 0x70ed30ae, 0x91168827, 0xe8d1ec82, 0xc4352e4b, 0x1c1fc990, 0x4702290e, 0x57f39102, 0xc555bc8d, 0x0deef87f, 0x290aa120, 0xf631fa8d, 0xd21675ad, 0xb75913b2, 0xddb9aaf5, 0xe69573f0, 0xcb299802, 0xbcf705eb, 0x58829809, 0xb798630f, 0x05583262, 0x6454fcdb, 0xf9d4a8e7, 0x5e5ed66a, 0xb267662c, 0x3084066a, 0x1995222c, 0x63d2362d, 0x52bc2726, 0x12802b62, 0xfa8f284c, 0x97c638ce, 0x2c5a6a96, 0x5d659642, 0x61e9018a, 0x99a4f93e, 0x00ea9aac };

// Bernoulli numbers - numerators, headers
const cbigint bern_num[BIGINT_BERN_NUM] = { // BIGINT_BERN_NUM=512
	{ bern_num_data0, 1, 0 },	// B2: 1
	{ bern_num_data1, 1, 1 },	// B4: -1
	{ bern_num_data2, 1, 0 },	// B6: 1
	{ bern_num_data3, 1, 1 },	// B8: -1
	{ bern_num_data4, 1, 0 },	// B10: 5
	{ bern_num_data5, 1, 1 },	// B12: -691
	{ bern_num_data6, 1, 0 },	// B14: 7
	{ bern_num_data7, 1, 1 },	// B16: -3617
	{ bern_num_data8, 1, 0 },	// B18: 43867
	{ bern_num_data9, 1, 1 },	// B20: -174611
	{ bern_num_data10, 1, 0 },	// B22: 854513
	{ bern_num_data11, 1, 1 },	// B24: -236364091
	{ bern_num_data12, 1, 0 },	// B26: 8553103
	{ bern_num_data13, 2, 1 },	// B28: -23749461029
	{ bern_num_data14, 2, 0 },	// B30: 8615841276005
	{ bern_num_data15, 2, 1 },	// B32: -7709321041217
	{ bern_num_data16, 2, 0 },	// B34: 2577687858367
	{ bern_num_data17, 3, 1 },	// B36: -26315271553053477373
	{ bern_num_data18, 2, 0 },	// B38: 2929993913841559
	{ bern_num_data19, 3, 1 },	// B40: -261082718496449122051
	{ bern_num_data20, 3, 0 },	// B42: 1520097643918070802691
	{ bern_num_data21, 3, 1 },	// B44: -27833269579301024235023
	{ bern_num_data22, 3, 0 },	// B46: 596451111593912163277961
	{ bern_num_data23, 3, 1 },	// B48: -5609403368997817686249127547
	{ bern_num_data24, 3, 0 },	// B50: 495057205241079648212477525
	{ bern_num_data25, 4, 1 },	// B52: -801165718135489957347924991853
	{ bern_num_data26, 4, 0 },	// B54: 29149963634884862421418123812691
	{ bern_num_data27, 4, 1 },	// B56: -2479392929313226753685415739663229
	{ bern_num_data28, 4, 0 },	// B58: 84483613348880041862046775994036021
	{ bern_num_data29, 5, 1 },	// B60: -1215233140483755572040304994079820246041491
	{ bern_num_data30, 4, 0 },	// B62: 12300585434086858541953039857403386151
	{ bern_num_data31, 5, 1 },	// B64: -106783830147866529886385444979142647942017
	{ bern_num_data32, 5, 0 },	// B66: 1472600022126335654051619428551932342241899101
	{ bern_num_data33, 5, 1 },	// B68: -78773130858718728141909149208474606244347001
	{ bern_num_data34, 6, 0 },	// B70: 1505381347333367003803076567377857208511438160235
	{ bern_num_data35, 6, 1 },	// B72: -5827954961669944110438277244641067365282488301844260429
	{ bern_num_data36, 6, 0 },	// B74: 34152417289221168014330073731472635186688307783087
	{ bern_num_data37, 6, 1 },	// B76: -24655088825935372707687196040585199904365267828865801
	{ bern_num_data38, 6, 0 },	// B78: 414846365575400828295179035549542073492199375372400483487
	{ bern_num_data39, 7, 1 },	// B80: -4603784299479457646935574969019046849794257872751288919656867
	{ bern_num_data40, 7, 0 },	// B82: 1677014149185145836823154509786269900207736027570253414881613
	{ bern_num_data41, 7, 1 },	// B84: -2024576195935290360231131160111731009989917391198090877281083932477
	{ bern_num_data42, 7, 0 },	// B86: 660714619417678653573847847426261496277830686653388931761996983
	{ bern_num_data43, 8, 1 },	// B88: -1311426488674017507995511424019311843345750275572028644296919890574047
	{ bern_num_data44, 8, 0 },	// B90: 1179057279021082799884123351249215083775254949669647116231545215727922535
	{ bern_num_data45, 8, 1 },	// B92: -1295585948207537527989427828538576749659341483719435143023316326829946247
	{ bern_num_data46, 8, 0 },	// B94: 1220813806579744469607301679413201203958508415202696621436215105284649447
	{ bern_num_data47, 9, 1 },	// B96: -211600449597266513097597728109824233673043954389060234150638733420050668349987259
	{ bern_num_data48, 8, 0 },	// B98: 67908260672905495624051117546403605607342195728504487509073961249992947058239
	{ bern_num_data49, 9, 1 },	// B100: -94598037819122125295227433069493721872702841533066936133385696204311395415197247711
	{ bern_num_data50, 9, 0 },	// B102: 3204019410860907078243020782116241775491817197152717450679002501086861530836678158791
	{ bern_num_data51, 9, 1 },	// B104: -319533631363830011287103352796174274671189606078272738327103470162849568365549721224053
	{ bern_num_data52, 10, 0 },	// B106: 36373903172617414408151820151593427169231298640581690038930816378281879873386202346572901
	{ bern_num_data53, 11, 1 },	// B108: -3469342247847828789552088659323852541399766785760491146870005891371501266319724897592306597338057
	{ bern_num_data54, 10, 0 },	// B110: 7645992940484742892248134246724347500528752413412307906683593870759797606269585779977930217515
	{ bern_num_data55, 11, 1 },	// B112: -2650879602155099713352597214685162014443151499192509896451788427680966756514875515366781203552600109
	{ bern_num_data56, 11, 0 },	// B114: 21737832319369163333310761086652991475721156679090831360806110114933605484234593650904188618562649
	{ bern_num_data57, 11, 1 },	// B116: -309553916571842976912513458033841416869004128064329844245504045721008957524571968271388199595754752259
	{ bern_num_data58, 11, 0 },	// B118: 366963119969713111534947151585585006684606361080699204301059440676414485045806461889371776354517095799
	{ bern_num_data59, 12, 1 },	// B120: -51507486535079109061843996857849983274095170353262675213092869167199297474922985358811329367077682677803282070131
	{ bern_num_data60, 12, 0 },	// B122: 49633666079262581912532637475990757438722790311060139770309311793150683214100431329033113678098037968564431
	{ bern_num_data61, 12, 1 },	// B124: -95876775334247128750774903107542444620578830013297336819553512729358593354435944413631943610268472689094609001
	{ bern_num_data62, 13, 0 },	// B126: 5556330281949274850616324408918951380525567307126747246796782304333594286400508981287241419934529638692081513802696639
	{ bern_num_data63, 13, 1 },	// B128: -267754707742548082886954405585282394779291459592551740629978686063357792734863530145362663093519862048495908453718017
	{ bern_num_data64, 13, 0 },	// B130: 1928215175136130915645299522271596435307611010164728458783733020528548622403504078595174411693893882739334735142562418015
	{ bern_num_data65, 14, 1 },	// B132: -410951945846993378209020486523571938123258077870477502433469747962650070754704863812646392801863686694106805747335370312946831
	{ bern_num_data66, 13, 0 },	// B134: 264590171870717725633635737248879015151254525593168688411918554840667765591690540727987316391252434348664694639349484190167
	{ bern_num_data67, 14, 1 },	// B136: -84290226343367405131287578060366193649336612397547435767189206912230442242628212786558235455817749737691517685781164837036649737
	{ bern_num_data68, 14, 0 },	// B138: 2694866548990880936043851683724113040849078494664282483862150893060478501559546243423633375693325757795709438325907154973590288136429
	{ bern_num_data69, 15, 1 },	// B140: -3289490986435898803930699548851884006880537476931130981307467085162504802973618096693859598125274741604181467826651144393874696601946049
	{ bern_num_data70, 14, 0 },	// B142: 14731853280888589565870080442453214239804217023990642676194878997407546061581643106569966189211748270209483494554402556608073385149191
	{ bern_num_data71, 15, 1 },	// B144: -3050244698373607565035155836901726357405007104256566761884191852434851033744761276392695669329626855965183503295793517411526056244431024612640493
	{ bern_num_data72, 15, 0 },	// B146: 4120570026280114871526113315907864026165545608808541153973817680034790262683524284855810008621905238290240143481403022987037271683989824863
	{ bern_num_data73, 15, 1 },	// B148: -1691737145614018979865561095112166189607682852147301400816480675916957871178648433284821493606361235973346584667336181793937950344828557898347149
	{ bern_num_data74, 16, 0 },	// B150: 463365579389162741443284425811806264982233725425295799852299807325379315501572305760030594769688296308375193913787703707693010224101613904227979066275
	{ bern_num_data75, 16, 1 },	// B152: -3737018141155108502105892888491282165837489531488932951768507127182409731328472084456653639812530140212355374618917309552824925858430886313795805601
	{ bern_num_data76, 16, 0 },	// B154: 10259718682038021051027794238379184461025738652460569233992776489750881337506863808448685054322627708245455888249006715516690124228801409697850408284121
	{ bern_num_data77, 17, 1 },	// B156: -81718086083262628510756459753673452313595710396116467582152090596092548699138346942995509488284650803976836337164670494733866559829768848363506624334818961419869
	{ bern_num_data78, 17, 0 },	// B158: 171672676901153210072183083506103395137513922274029564150500135265308148197358551999205867870374013289728260984269623579880772408522396975250682773558018919
	{ bern_num_data79, 17, 1 },	// B160: -4240860794203310376065563492361156949989398087086373214710625778458441940477839981850928830420029285687066701804645453159767402961229305942765784122421197736180867
	{ bern_num_data80, 18, 0 },	// B162: 1584451495144416428390934243279426140836596476080786316960222380784239380974799880364363647978168634590418215854419793716549388865905348534375629928732008786233507729
	{ bern_num_data81, 18, 1 },	// B164: -20538064609143216265571979586692646837805331023148645068133372383930344948316600591203926388540940814833173322793804325084945094828524860626092013547281335356200073083
	{ bern_num_data82, 18, 0 },	// B166: 5734032969370860921631095311392645731505222358555208498573088911303001784652122964703205752709194193095246308611264121678834250704468082648313788124754168671815815821441
	{ bern_num_data83, 19, 1 },	// B168: -13844828515176396081238346585063517228531109156984345249260453934317772754836791258987516540324983611569758649525983347408589045734176589270143058509026392246407576578281097477
	{ bern_num_data84, 18, 0 },	// B170: 195334207626637530414976779238462234481410337350988427215139995707346979124686918267688171536352650572535330369818176979951931477427594872783018749894699157917782460035894085
	{ bern_num_data85, 19, 1 },	// B172: -11443702211333328447187179942991846613008046506032421731755258148665287832264931024781365962633301701773088470841621804328201008020129996955549467573217659587609679405537739509973
	{ bern_num_data86, 19, 0 },	// B174: 4166161554662042831884959593250717297395614318182561412048180684077407803317591270831194619293832107482426945655143357909807251852859279483176373435697607639883085093246499347128331
	{ bern_num_data87, 20, 1 },	// B176: -1369347910486705707645621362512824332220360774476594348356938715366608044588614657557436131706543948464159947970464346070253278291989696390096800799614617317655510118710460076077638883999
	{ bern_num_data88, 20, 0 },	// B178: 1124251816617941290026484851206299982774720467712867275292043701618829826708395745459654170718363182143418314514085426692857018428614935412736063946853033094328968069656979232446257101741
	{ bern_num_data89, 21, 1 },	// B180: -6173136454016248924640522272263470960199559328290655337530202055853397791747341312347030141906500993752700612233695954532816018207721731818225290076670213481102834647254685911917265818955932383093313
	{ bern_num_data90, 20, 0 },	// B182: 4277269279349192541137304400628629348327468135828402291661683018622451659989595510712915810436238721139546963558655260384328988773219688091443529626531335687951612545946030357929306651006711
	{ bern_num_data91, 21, 1 },	// B184: -857321333523056180131194437347933216431403305730705359015465649285681432317514010686029079324479659634642384809061711319481020030715989009140595170556956196762318625529645723516532076273012244047
	{ bern_num_data92, 21, 0 },	// B186: 22258646098436968050639602221816385181596567918515338169946670500599612225742487595012775838387331550474751212260636163500086787417640903770807353228157478339547041472679880890292167353534100797481
	{ bern_num_data93, 21, 1 },	// B188: -14158277750623758793309386870401397333112823632717478051426522029712001260747920789473711562165031101665618225654329210473605281619696918061316240634857984019071572591940586875558943580878119388321001
	{ bern_num_data94, 22, 0 },	// B190: 5411555842544259796131885546196787277987837486638756184149141588783989774511509608733429067517383750706299486822702171672522203106730993581242777825864203487238429479957280273093904025319950569633979493395
	{ bern_num_data95, 23, 1 },	// B192: -346465752997582699690191405750952366871923192340955593486485715370392154894102000406980162521728492501917598012711402163530166516991115122131398542029056286959857727373568402417020319761912636411646719477318166587
	{ bern_num_data96, 22, 0 },	// B194: 2269186825161532962833665086968359967389321429297588337232986752409765414223476696863199759981611817660735753831323900456495253961837175924312108872915089534970310604331636484174526399721365966337809334021247
	{ bern_num_data97, 23, 1 },	// B196: -62753135110461193672553106699893713603153054153311895305590639107017824640241378480484625554578576142115835788960865534532214560982925549798683762705231316611716668749347221458005671217067357943416524984438771831113
	{ bern_num_data98, 23, 0 },	// B198: 88527914861348004968400581010530565220544526400339548429439843908721196349579494069282285662653465989920237253162555666526385826449862863083834096823053048072002986184254693991336699593468906111158296442729034119206322233
	{ bern_num_data99, 24, 1 },	// B200: -498384049428333414764928632140399662108495887457206674968055822617263669621523687568865802302210999132601412697613279391058654527145340515840099290478026350382802884371712359337984274122861159800280019110197888555893671151
	{ bern_num_data100, 23, 0 },	// B202: 2250525326187264545900714460628885135841050444551247116222631411681549780530233516069957534394574922579290608180427520318235621123686109474343887857944611842438698399885295153935574958275021715116120056995036417537079471
	{ bern_num_data101, 24, 1 },	// B204: -110636644250856903590976481422794879200517231299540994715372334521128669716264196333811025709747746193210786820114369025849897345722531098042760530922656878891556664782168465095563132092311332073097630676251482491663634626858373
	{ bern_num_data102, 24, 0 },	// B206: 2525292668891404920279427026668969389456388249389889339455604316691573384284678293620100066924361693666444722338743839198221347931651916807651198800935942493038194104759967208073711284671045255047521429204396148980705984836743
	{ bern_num_data103, 25, 1 },	// B208: -12407390668433023412711473483696990726334795896412761472587854072142800403373577087021298541061094633377354326966623278849423631924808044397822651135905640812063181221280972334965193338438214107578486417026806166184210160001817890901
	{ bern_num_data104, 25, 0 },	// B210: 4708181368529492614110644197951837317202610608341257204206693195241245204360822875910613010433572133227831741097261618833206537519198885812254347219150482005543422997225440204041473518187636442241332621804718967775203938403965710395632762155
	{ bern_num_data105, 25, 1 },	// B212: -1856110669947388268389361040689764027464160460436671923253131176853224087741924378432403442710398247642246902212818749685974336641529240178398124235555437625251481044526024910356131819016670047949661636539964662370375622630863327168696307
	{ bern_num_data106, 25, 0 },	// B214: 4005748930070152861935826766476856180706477227448622268042052745245798242539770546339789899546160341590069109467023517085578618986055969187202731878271685432460708841118506310943865592568791360294244451765746911808994482063783730693703607
	{ bern_num_data107, 26, 1 },	// B216: -11993122770108617858536443322964878003618156069559794803117809279608039120818829088000103355036592864877954563564831932363414886811786054601318517206937549605059298307895591515771731031691422489377098686236263367916404512751010916862894129855138281961
	{ bern_num_data108, 26, 0 },	// B218: 5646413644023523531472659729552574911763686780871700375627426663366507837122353997075891736706811337698248660838754243486778190331522785903661556458651175061469825204821206611273990250663647381261360659950519735730925202117606150672170127523599
	{ bern_num_data109, 26, 1 },	// B220: -8717064809960074651332043679796544474420053189621803209941154764877242575579617540185166306094852502223738126111951612525627910517501081576202264770178546608710937474005742969950212404955732473198451623024108934373488641161751158901712323446768306053
	{ bern_num_data110, 27, 0 },	// B222: 13368053158552172665210852539359893340369870651951497976111882891296650008003955172160792457229376320993686817755409436399268291095350295968657381088168219133490277914269064723832062615431730061224649980566693258603099340996988542301914519271322675688591
	{ bern_num_data111, 27, 1 },	// B224: -3018240015081392087620978688311925380399983229633120268872695911807562982111154053235820050168829922189401964755775948260724401542319799566237745986245598102255191922935742610508280966462644022540839619861091049093129359799053781543195492373882916779852781709
	{ bern_num_data112, 27, 0 },	// B226: 3168221108903401670436878558215734893322849540781208738796672473984272484396317849596978630272031342024194689871467916186898192771267438982228710525079886956295106197431401217357893460897221381410667385636049264583380749631776691121592016493432807733153743581
	{ bern_num_data113, 28, 1 },	// B228: -1906502909997888166123201923177385833567729039151413143876271870599057704445939156075718972624235764657102074902610737729027517674632609562387841658709266014329005407533521950744449109807215808770201247724932231495252981632908042371307965561986133763291349835081839
	{ bern_num_data114, 28, 0 },	// B230: 12620737044909818561832856090355555624016887319605261762997689571062646649745107532482632213152948299491122977690702642386377706799989565320538433072623252159464115918057294711396625436506736041542403370025258477205101808063594056759977272469883621048184279331863155
	{ bern_num_data115, 29, 1 },	// B232: -2277782962749544647786193093844710000584561145527861043594866852071596440076587235747852022645695523676561694856919437156369375152041285055935622032497285897151359345040171955786899011718891877065760345722163063921177723102631428767500963315657655779698470644544064472947
	{ bern_num_data116, 29, 0 },	// B234: 480867224771001697116513683699011649496855159878152931805742068517626950204279499281932407966997815888727039144001177194783700618900740782637516562256421883686495287564849123342843286211825800198337962453448529082007644439295666002669973893196613894216505936316966183107269
	{ bern_num_data117, 29, 1 },	// B236: -321467133590936589398380572003196190798000628347443663674019204361034039315014370869884972981404460888272855773233080186485230316544246541168364468343631969225480324799028067015621769939718443419712110857965409179947456994970687005134042835903494172569465751671057323145801
	{ bern_num_data118, 29, 0 },	// B238: 21954828084819816230623427376391154946628510524415478471365831649487269438565442138452375719697629394886161086199009071745032148355699097673730377547354631757000924688032674454208386076360699273002129330161098228962653466112032300056534380609136268347425707537340996253935261001
	{ bern_num_data119, 31, 1 },	// B240: -212191008579182060478563837945461872287372869333130175188325135660897759482730035448146388858205966593247205572842356279587190846758925659038643395344396334821348861518596112373605365460921821915409949436456394757252173113308288776951844012432992719925522001911419529928297005743854184672707
	{ bern_num_data120, 30, 0 },	// B242: 4535049728315239205021018362829154800039522502549714840841943960634084990270225535043892135549408608572877513963384530325758104248133124392959997485849004663162061065909846598215984547677506961593292880902830325868627515047168286738527241360778218692535254144583771935549805772798793
	{ bern_num_data121, 30, 1 },	// B244: -1480677868678810347062135814574727890490996459903153909612611791768134015908900253197632543925157559965099005581639883558125985134242978146873558628010545299879178299856929100217178891524159543673803785481607540954533057560554704283718320006046424881681934129216249889269701182688055001
	{ bern_num_data122, 31, 0 },	// B246: 262668605206102118430195944953058387315319589613263079853189811674338644589939356676047394737425651989092115424635212785341601958591806782599345416064945113338168378810138043832891536358769753916174695061208903056552776976154338169779827414504134808495078925108569042616724875466536400029203
	{ bern_num_data123, 31, 1 },	// B248: -3507445546375253318342667741949651253516986113349672180095468758145505921133172244240023419466113277413785800736682458966212429373095894934752041434119711352215164597094886530278429206637066302031501412499166263642447542289785723225064437740655097573160922291075175522551466276032634749948001
	{ bern_num_data124, 31, 0 },	// B250: 3053985414762198703102020975667535181880294373982570358384262712216099013630127381226064671248970168701164841859177635139561220373102316273710980757409295039231697360536736113380473515993580188204966808323201772081668695321316425977503713933894934399351348240918411922863059423248058823372368106375
	{ bern_num_data125, 32, 1 },	// B252: -89774288871630307843644520580598652632613559409413344033893019938898862113876440183943307724290509165539815764354254584162176909463971675189351699717189454959415964995262823025743004001915975128242680213612581748367743077774468104545056300803334120339537905702856877606246855867891786763741486735368783092237
	{ bern_num_data126, 32, 0 },	// B254: 2884759276650094186013272224259584433367802183845217969121665253431996536437413850716488026971480747022580182931940812035472752343853999483816456012957551120812115224018480617695398681102870535795278832047330709610952952566962354787854087985127629191094880078635434933391568643930279007460403102076327
	{ bern_num_data127, 32, 1 },	// B256: -104203435297641800915507592803138769896333127491490532929531166632958450572751929026080533456531382568746630428805839898606131705503722712567379172835813497582706763790263297372586804372654090271412733654409742029405259156130663560412599913831518338400385290760913773448329773518728092595019422753511174189569
	{ bern_num_data128, 32, 0 },	// B258: 56081693586889462275051589447484617682656486262465693822181172785524218338951641908717980184709547885060218908068568000776767834360070429300833879662707069272458173745883316346369196270761641325176838738153606175963665383216626724969370509650128327157862121275587666040290047452303859942885949047756404247033
	{ bern_num_data129, 33, 1 },	// B260: -5218507479961513801890596392421261361036935624312258325065379143295948300812040703848766095836974598734762472300638625802884257082786883956679824964010841565051175167717451747328911935282639583972372470105587187736495055501208701522099921363239317373617854217050435670713936357978555246779460902210809009009539232173
	{ bern_num_data130, 33, 0 },	// B262: 6225500408881102797510043328034969466304425964851480796588968345345616249056035479080489691323529597769377127237910326626106353639640430862662758276037155818313797361926063056784629357346246050085674910484712331211955483400507386944492614175497512823803191508029088188458205305675244351279445756172428826335261196513
	{ bern_num_data131, 34, 1 },	// B264: -2597900408162896058710572658949818524468219266931291835479959418094890120803707468900281325124704535527442908101022615930505212028093980003061941163493997948367473301269937152541190254678821414979800759785215240308773060568770563333752614741579673909061322574414039421772773951907381124389083123642187877106727324831409104559
	{ bern_num_data132, 34, 0 },	// B266: 74333782054653889423743469213152655799143173104421681719953140280099539295673341397636592724713785397334372991707306538931885461890982390991361955644690371434518008626267056713898856350449471518770634624568188698734199687848634136577815884007651660546155376602651878199847336975669075705029220024942988801596540479832623
	{ bern_num_data133, 34, 1 },	// B268: -181215287752963297591649028858266281596159320543301504003425598637697061538040522696126018237983659329700516696739148841351912957174525785315414144429136591554131215700560325949733256954674813149699783016318415338094395743152932542723256830883071638325957369194991055197776850603497527503600109515880553950890416293966947553269
	{ bern_num_data134, 35, 0 },	// B270: 3046520935696995573515824242272701117754774305790084108344788704634810391537752246673386049133783821395486096239148415641722199623177956366799133314531041402021345562799254459886856571341036470447536143349353694309187363616222605848012490292828963830868021774140963898080446961958927794750526681977409210580806334902707423302910890705
	{ bern_num_data135, 35, 1 },	// B272: -5389479287019828859012200442343326192355509012382167997444221939499202340581932428533725140323939479047999949436682248001244967154707104896269136682582392582110484972339408510822230035412430172890925658230152084954903826143390588854318458185729506889417244891371385482660658834892925089584501833253476537744400283864408173645832802729
	{ bern_num_data136, 35, 0 },	// B274: 876921640102601760383168273082801324788039055564836901409234298002253995782034121007322766508391364331313364222035613918206397636790569250311165509441010945170696883786500399759308075144882184008248023432975450281978336106603716700929424210717924897570827498252893067062775490058563356806930680935200945326351681714440032862515566687
	{ bern_num_data137, 36, 1 },	// B276: -1388182772753480224524259543538426023294781120119840766760993950456297256537536762358314128425435909635398077811882539199662711471185655335807263675649242817349083277475519035786895107126764049407549359856712249235123586468592541328115099760851178135792262280438168965402774928136789551166963401124472782522202058296880872854126156007513528607131
	{ bern_num_data138, 36, 0 },	// B278: 3288574272791325983707258196648395370596305758341699742238893225440550539879910098002426164478935667759666907669638986616709137799200377160559516125812795457124992507785560266265469172399329113247421069765604730822849303184464007727659407021486798188927253139176046166778181472669994161900278671855691024038916704559966546186751742476372279
	{ bern_num_data139, 37, 1 },	// B280: -8490228242595311199119920565849009760217791023572798918266374350550246366225435144540895862924269878096526376888988896473279190955432566511173411205746712397692187887537779437718173050158951105924254322875775498449791436769311967741327489636985694874281460516082075289295724305512800386456299241907049270636679469815489106102786158831873003971980149529
	{ bern_num_data140, 37, 0 },	// B282: 25875593499348128833220857256544133843109199942629172661571575831896009002717379314993110538912888759932261638883397790531299585084426973156913779915781848556311555818927755071422637872741239146696501724664788565419251002500248036396312656297993421996811407029386847063439782311617981818206546311041142991312322619717261878315979033851316268092742291
	{ bern_num_data141, 37, 1 },	// B284: -132959963583526612558423182997702578242047892089625754241387587021938995020766563989990185987109982064786136276402406795608981540644133005568845598733701027267134930895872207756078937107416605123323092749911180763524271940975157312568091937739185681066178901105822385739566191012805835839265694429000135104051173197039224461050364993416415448157657001
	{ bern_num_data142, 37, 0 },	// B286: 1262786340764743836543650366374180273258073609841543441787781675688541881984249268360325012510167918286412665710785332495002470256724535451201518584261363284544626088778140281353574806840036456927404244048497506339393258324386379574048562781825209799628261527492591555049229691481538713081331723845462120745928641410668923052992096071568118182416749081409
	{ bern_num_data143, 39, 1 },	// B288: -4426158122015997656918081228667589801499808940970897924307086870252646875948841652238923933674489065786806672342321537012751674084821846458685429618183214525289276658012594349154796284960120596423811831259041410965661717709958659062147534583171671141655182016580199364485449629732438469542501153689517957906763036169880300563526920600913900347892060168169080524563821
	{ bern_num_data144, 38, 0 },	// B290: 158378960459933745353732673983377704622086418682000111407542005580986544145352715435649528631197645211762019722767661122078958064217177336225880988737955740461066476486097551548991955116319546315427449493825430704787375985685635337262886136570504412827663590990198163434342208367501561777230870660164068668650416176368657029205310526817730948015526849382859712055
	{ bern_num_data145, 38, 1 },	// B292: -769496271232217048566454403451119653773906354892060893481293713784107951847019857310739767770463076516560575249619621659718985646126964039659981825577646225301189082287264198134787013538174178383958494473734277012586809351930781277345290942985827690026019144748986116319143448962997698665018791994064217597704711709748695678908604180272686662449493086793580970828093
	{ bern_num_data146, 39, 0 },	// B294: 344977368185637380304333898730614153996525419281986770522385915720139215554847760949870834982202303432587625997234795118134923343663265548204594792841811439303451011251437993865656175552484850145014444202587617378736472160288579064961864004275382498994164923679644150818450558302750885234058860046684381556954878962153088786251490404112306387375170114820733240249707147
	{ bern_num_data147, 39, 1 },	// B296: -1888575590158495996440108433926788958859450449505827069108529221911737605491094242128180304966356165162290173103044092702582217959772178183606221416867140355106476799094653551123469827906281690228047604677838808485752658196964935031379587556530427680306537879720377479310817318584744711522453387072627648438830200285728320936098194745411999104991803838665658699650727659349
	{ bern_num_data148, 39, 0 },	// B298: 5683175611528696607080062478072501820703250802520963611339740016328084145085898175251616359343168595858108624167762131679681416977895536025003761007598913177279789271071880600643885302907670572288368816385439218707793725555126269377090645484013184046265389329719449523663221529092764894703813815177897980268745011893371899061378940560801507189664711567121796987700152153839
	{ bern_num_data149, 41, 1 },	// B300: -1863878995204859011995045341848156066182191846635905937518715320655775958174360523134990756922303410810482600528769479642021001218415879006164302955370460829146434807964717737195356935144151583424833154250047747433575584999029126775186293388721514970183351129809976971603227633930434923843984829580311593372565398574762880028289167635570012415606941367995702212211519561707046505473575241
	{ bern_num_data150, 40, 0 },	// B302: 29732914652005326308069038299046877228165947489285775398232775554326821654997284254954541436759755619186929818878962419179787160694148360451817997811323189321730570436847238527392204080083670713746104123180927363450365552833743396887002966884296848913481132785586683120732369858597153076261127975076406564459518695821788635361711463230165952857117226399909961673058570176834883271
	{ bern_num_data151, 40, 1 },	// B304: -5896752302971586952817880137553548037522952101385717862219869597959540714708235406233632122536677446426246295692119684486036889235399687553979484886254426933587637080451003789769961323298135257953657891721726854085498886402779031921701364180427128346719739542203363106920603436185256970882544947794042043194815113693600814746189709447821507079960920412101317160689806936226622681106017
	{ bern_num_data152, 41, 0 },	// B306: 689735739192864790938869842200448522491622174065530181755219067505817267965189978776569968680399983089600630968341102178380777713630583306140103562669027424552384203113812510243331805627699809267240054344772443480095752572066698167737729190346148297831547431732607091731942172905658944645576233950351675859756367833238423434368779109181349635099892383418900862720397266277623080279813067604999
	{ bern_num_data153, 41, 1 },	// B308: -1310028313878567907114692495908315703121191755911131111984360268010339291958527789632281425987720420051304810543373657881574797353695997625625576992435250954115647419075544944736054854015711074248873686155373327776946348644567049129984144807198780234107278733859628145334731952115798551768101817753443736023659080348249001450368140437083583099127029870537678245450148711191680759214684176445667
	{ bern_num_data154, 42, 0 },	// B310: 3260606235276851195099437047707916012280054709370077715052312896011476347066426313756906147929976324639617487079038182718315850586912998681890040154101217023601746358548442139356881761209491879344448144235471024519916730280314406401197057752850694124801781598205133338269426259564611182358074475139266646779460335469700559434884540406485299632013344690352700850048935613677493364152601347478976955
	{ bern_num_data155, 43, 1 },	// B312: -219310221923496085124921823808404575155215719519880743817262187359846676808720933963496193287320441312135479981243085410780329920552595746251706979452929554249409283208988310305531179583355242953344731240610852110199480347842183280905881606393786883347661578747110380713468900860626627458517735797820729101052113795399477516376330508889102106163067720003973339359314302749857453315620772706780505888813811597
	{ bern_num_data156, 42, 0 },	// B314: 5831963211655227469096364047000879785191356939385161602680269994879257080042651495531334620369899431331189755049833242684170073167978643108706019166324688447112227778757784415956624614457808484212568132108937476630344240535741105415692911032767001030027558118855855057952089777910853586423077582781831060554157175555095233630076901455631073919888020711465283697536929732899568769525385745975473155407
	{ bern_num_data157, 43, 1 },	// B316: -23306762036180954707239902303733182709978468580325093149239040051634149745258544596562134540960231525935441270015799599621135682414015382311861534597843756730857227145200622246509066032795288017634942726754909458234645264430702930529842456653080378544365215066466596986953601385998432554535709196917229350478449221406496506432167664369239478872974247912601100426306339312275565475595669640092216631914518917
	{ bern_num_data158, 43, 0 },	// B318: 28122967090195287981055019523746421026174611154606607881410834553821571195600077156388139504050817072318352135336014937133504488344591033637378875175488860842142200215544952457462251551728305545862703146471647483394138505742989863336231595764600339418866218322681285266901817977284569573044604541872422517736195703069383015638214571378546092320911382385141634160156861783095114673655212399723765743717305197851
	{ bern_num_data159, 44, 1 },	// B320: -3721822981147963543473628721718160389675395897437503779226807860482566691214705959016239951890193486758232537597591642279654459920857716018601998378015710967458002507660860624568924448328452560808376796224541899685756821793434321138838512925307216420554703983171171540795387100799809353390519107647717976213032752752815159815739322121041527686676774334782328158773314452206678687770745486976844581551304048486668867
	{ bern_num_data160, 44, 0 },	// B322: 11947011202513683767723104489271471097868501873399758887514336934592822829976646702161909309680237660201998669294617552009638464244432709441651377979627696796385888263305915811924616794303093449550416640107641304231571552322204363229110497299236034396583681906657985198177302972578027688117382447661848083476283296893356637990999976607059658190271101386708876477455968880271181353449021120174672279118531405266405457
	{ bern_num_data161, 45, 1 },	// B324: -3829393826694851442367963605345986414644123194149055126713238369521199883032584377556163984602775965899294620028160948209504229098195604243661949859717087550540749941206115020546490009175884700307199551574107407855402424207686775155726579245497021834551699678553804651177095786249593672236240744422195553711332954204942399883879329051596664648871055498926334411033125995310873151284771962309916237507813788879633942447325937291
	{ bern_num_data162, 44, 0 },	// B326: 1808383072515392862130370135635372000131626793093148880779287649928820293768508592707521055628027708276165829705670838064031068574527612930799078981578676791129015219438793213734036863426110360623900757855812426023541159774905365518756692026508213803668789819570234151094586211640196633499617063941661470860479560003474875427679061750173843509685528353151826146684405535206504936136026796030365288231301797295663647612503
	{ bern_num_data163, 45, 1 },	// B328: -2038920955732166704563544675871539298534664548832344594940419211031004686244887980129990722833481906996574995006272283772989552251711645339529824674672295721387444989765197094356625686277258759887529063884063441729464466695304817154879753936013360244814470171255312860420052459456595966677396165132301906628818307744454944935388834925108370678592735494494812411438800013100442226704887804736057100084506757161238437561170752083
	{ bern_num_data164, 46, 0 },	// B330: 16450740261761201488286514086666341385844412580813949724000155038308870188720719658119876451207931032748030811189911338403495201879917853940007778344522354341186748832271809821828409298207968739139227014609598106703237472043228932298563800984396865943755795758369082954888437302866500408097109163018555655697695594114688192421141599313689189778427690359665256283948257291245464556741556264558183330312680675299274129472749543281530376155
	{ bern_num_data165, 46, 1 },	// B332: -31404740573139387013607323899060788461129734403267877740839079468522117216337083625061725107066347029224470970177830290797457104821060170534363148276651160571699094881049180803660482733644591278636224534484481850814754420273709821201199908209760469191567840252247706876075856090781209456764232767086688491357087469900906692342923336064928179724546370791109956974800789303951709599892246386582961297095349501749155074025993332911366367
	{ bern_num_data166, 46, 0 },	// B334: 105959450712139358561614326750678748291627849550191512662380413294068107407247886566713525350838198788534238121678429166419664041236233803606051817627731575939553790154021616196778501189528768078400811107009317850171384096998455082824610437919969197421385189475358775596537026092374519645052975059595487888618614275545703577191947383711761849232715855501325445057452043875112980841528855594013764288125280661970576229405994478822053767
	{ bern_num_data167, 47, 1 },	// B336: -110968358518556750910569006059104612436322304793290197896476208195051113971187304256671882613201063543710887491006989203213468862095728086421327649757926706375373160032479060881414285316805050049998250096629298691714712337731033133063244894833650574221421335477496494331790029997128928883270452912343595756835759921082499027715633187483508227173954421007445739076452215234463953952029377612275096135644427285378787750547213980148328191792731369493029
	{ bern_num_data168, 46, 0 },	// B338: 871667613876289947152259213998641324359438367113245978510277002562210922288209180150151793852558736029189876363096736208315035600167649273464678134646229708161579214485318416128870291425640987624153304026736765522468963515580422620761261195314156252082303726799452238319359220112879725078451979791840912313059346932550771416018721541922207119333620480831014488368439858212426770461809324187079997350701358985200574078187666941445255865364959
	{ bern_num_data169, 47, 1 },	// B340: -139969199374294532188729693702577000000465664934371179035889932037927222630615161871008568258760858093560212970955512057983700284904139662988796471588843837914664871339017278834524915750717069973487760152722966363103180527139199261072959205960570607504345672675033426810959288741490491658133099197637151741354653719448795255505120643394167214213806837785207626077991226383344774422283805854628774864645574223075309564129905544107459811288704862611
	{ bern_num_data170, 47, 0 },	// B342: 999866869350557363722458479004395830847953169240152118030482972984856254139343285563059710426142001310818604300278555911104883557186325333153917124330048368249458087059040520529706556642732809436335612822769043297715578151918469336944179483860946506334004186007324467864842978559250174108263899703085692274142353761805113570952308838426945093917953996642662776561930695988488695006166233701104386823791719249365863288962981240951731129450241042813203
	{ bern_num_data171, 48, 1 },	// B344: -19435667946412236600006355752680318177378018998686558693047046847185922842569405850478643326624807107024135785299799674685846584030230598008329461654964640062557602833521189158599030670653044302429200521250792329717629531968392422269289900710918148435060503372045597753741275339144955223007618411222546697775810780747446478661790743019087588298611993809224843559412437328287256779856482337754827908028601591041648043989896358637724179061858684905231780173
	{ bern_num_data172, 48, 0 },	// B346: 23574815095404701575006138342677814737611117002189168884514625588124591088321558700476292561495266316421750730681754426899890383276767887403267480686627676268685966493677023072554534770488586483642062259843015737466820417963854802166458232968082382836216212063844897312505105552626378830504014452088433926239997258280111620289793360632141212087877945966075033938687737132829040482438463044913103827680386355585682702291192692673999705957317036687127526488661
	{ bern_num_data173, 49, 1 },	// B348: -1946958244926408519819928540035312319794025231154312283846941445533833885684884185938663359749293528922631351379885288320544746558558870084671027543542465268801245629638273090846490014696481293058172945225573249920181321736453062629022981688433233577329127459928765113606300176648832109875139888454987326886636880988465878410619882237596781152380489370724295257792104332503696582825373077048086525583941198173749084587321884232599450628448598711165788748886648206781
	{ bern_num_data174, 49, 0 },	// B350: 502172089109637973079905157308517324166048351810351159422375337574332573514046742139861365117790762795398322755462389540876498686325519933386024542998456467504352201616875674226702066988781736776780983675270711591178536297327588046501114273115924942240089195877277170211145955479537604561876530663522061491492548171664129861255728492613537859772665546205365872403842851465588616941966018356565181922169705164734493393477247978508055348618032704534473742084629023675
	{ bern_num_data175, 50, 1 },	// B352: -123595612458163473336102111542838674764831835495331502431774135351050074096606458390189947949855899933224956382090454659506523733852842909886351324966274684823091833542355636103776512914842749831251392589846063826895163366115470020631076054800071496634622909233303706997995125130120515859762839469193960001284685791277467069230539953616534532549898448827387071275667857164787765007253139087944551495091418632200084873393873944046407490699550148256008464127109223283763137247
	{ bern_num_data176, 49, 0 },	// B354: 44586958800126786790452414833451737276485269217604041493957832153847748776691019563443875873891685730191225792159808508144405955278309411839337401759278396174609624192685884123993968501104767184346477939067903846512439522927159649898761965816525286791728854346485686727420275292569511311545587705052888988969140031330003151200601432709893613802729701685072968681090703554561525613786761794587069881004247080811531298610122589066840923344874780872870506826198179146216889
	{ bern_num_data177, 50, 1 },	// B356: -18249520604687390491188873019557839254274215818941916557220148305863171323999328631073000715354712349442824804877473011208435647924577393976121564194070391790525169749128982828132077146902780721841387850162775862442199934474879939605150425883830706636702361084052335568869843628198626221242494076538767614229186803516353130263179834649242288787960314531149564506544752097614513847899020629776701115098262552562151629993531946710430672386743677617308205579019072302696542508379
	{ bern_num_data178, 50, 0 },	// B358: 23698146493089350432280213985162669959262841111102470546871456237323693618435911411642184657663645971277792033537906347762183635901158641375259341789919760310568146035244593237879245436647800609988327386298127942914981131212727307691555784531721623262685912374782653802898934200911324353096490548706043962852465907958751649549222286885339380268684947173053181005751121488921877337975992137735046528729900037937548187674111044469106308867226010497700021930277136809473041010432321
	{ bern_num_data179, 52, 1 },	// B360: -778920925563520089023277887716919839298513486135455047496265119151473505464734957690937635048394537294415972122421086877478533967411348994474171388256074145035237797802154822761617528172700015731068657547092679836095543042179681364991968425138238530710252585175316218097390905698054739393609117605669741881868029805237983772228322424502491583995084065878787104609542382045050185577023575049548616444750140539582676309391395859436260664778641733708499657047550739325300732722680932200039559718809
	{ bern_num_data180, 51, 0 },	// B362: 715341102258098940319912343996707811685084551356244645540933308810413928160891724298276851619649551829973697033587181069271380692407132317161739109284011945227649892560360729074672778640720680874112214109997197387525352062913504682830983772725393570468326491083187300331970668449041594296073065276692887678729691114916079642579900288026881432235979137544823640729868705093774645241454622836223176904124630526882732099120398430089179339282190314646212515622936459121100998906169917551
	{ bern_num_data181, 51, 1 },	// B364: -18399470428456050908014333117886494595730651014055636288722717429950917809500136272557117402977052839042105693597404693257617634201600598895359708213302738206862242849606975947076539483777341046657860376203296993121539300815161693660027527850273081527494673550440357634430596208643360358204371232957151165657607509017253243152916116719712350843286172274487990507840124030754833011930721808729659207188165402273267771908929719004881279785191361391914450528631012111465559730900716078151518537
	{ bern_num_data182, 52, 0 },	// B366: 20813243679670197402657864594700362248333105628735574505407748752194329210363364029904045498683920274785904391711886368296491226342074760936891789529952828353712861964615536938434038079631985205838319830159148784466890765577478710750411239086707279314113340423502528151089538256774657292895067372560433868261285932669643784461912885034984352745012134324851266880718011466493208024572308839966018431480701067038072465848677106468318507151450224167148317101357641051334844151154035628560478914687
	{ bern_num_data183, 52, 1 },	// B368: -110725230879881321879568054811797526267115166186538309029826133137308115277324207270571040263441920262386242076342056949047866353534514266980024412370434220187359560062050493440457221035440089226046696014690219122751069156630764313360960761587856716000690131098571105908045239988081704908481660126863809763243757816063349431021332536632587298653399772920535661074013239670953426088742833252653499763654446938447050846790045870317112050534444840968778815676707175954631059728590843972403931253118799
	{ bern_num_data184, 52, 0 },	// B370: 1054364681019267121830159662373420279818225480653781839149178920561555806813202030269003305294989784104213489890426332509828119920399712689187184649711689415835280384720994979874232796860338473523737136345243289020296312370876276856303158404225225651223912805235434755784151235675589206423964860803286777387807480810963355146229723274524146948489417884118537852386976826754447246469153480716621041563108596300892747446848622658459755002905969181236655822204297783975692352381312064835994355860201685
	{ bern_num_data185, 53, 1 },	// B372: -56868988747972506254659596935683883463716573524427146597376366171981802233487630537261600452515928180502785214820124586232687460333822056190451678107485446400177877446417556715711032055230455854240595868388654451080202675047744244991416192115524025084813812227930163123287145588705727429456779082968390877093897979160965323905993195706278985485896440595636775123847679345910845046714163301325224520710766325936895600819434580574518875433796519293151389916795779147962584026929392606854485528272956190655743
	{ bern_num_data186, 53, 0 },	// B374: 27233521998844117466571164441681703778822231688822656418920849017523981696494911618651082582707143082377020546888216407884466480834780583096823087696141619926246646927066679156637706667759198043548965512948036645725109831717082230384665542660596536212413188407637782216353393129995452568219713750918323446571634462816666446106121343241772625570723451925602179037604045813434065564118195563426039220880907100156027093090547687363620867038635244235643402355449232121698090257432456131056504444320853157345201
	{ bern_num_data187, 53, 1 },	// B376: -21144886325968847421136862640933605790730878065158231117894812330764874940817232709655287449203776974910988576503561661800249278991319113309582335281592647442495030553208258548341339318764197461147432848991686338242711098654931144304725148541437215370995347051713517773502906169174089944259231510484935144428438091067266131242394201122670888252772064856423958372374082615970685597386991737179844349495505700142239123902982043714578671787314293339023048726217119025452344630237832665698519639606247957083240801
	{ bern_num_data188, 54, 0 },	// B378: 4202152324841490851582198491734154054898910989229835692416027795481485467411812516892366095348619673337490550280425989691409092856177027846893427878738640633197809375983848427036487478678839362355759610808529212110936501477008097429319817529927993776215011685533261432410077791728458394351343228912812829117361997697793433448908490531697660725893829519644454139967318758247135377025444352170089166553939801451419735179550891309557305319624844923751198154628001739638691998206529289924753014269328705445340396548203417533
	{ bern_num_data189, 54, 1 },	// B380: -585016197049150516429606755440285431916223316191798033687181061470667150509536113671258201054717866226570169976401850360230659699699301963057743166370714339259000981058060988677132844370590538962044247092297537672905410985648312911796535010450651733583075122028847986584025427113069993778348629306554503407744980050377057969061170508810412927919930789637438916383763636475443274955653725558963454824998976936559504337387796596709727547538729277633022545136032386860825147973153846428111580196229784765036789760566304701
	{ bern_num_data190, 55, 0 },	// B382: 78631979609289345055469501119395008379118096513723589634568877004799927202495863945986283823608714469880713486237817037414979036031006235383025032476262083964387973243898060840722936009590301165543812264089314197515688838727901018644687053389435289951515626740339208758682375061416597195951759290458697298602770109818453665947288873748972700580769864649544946817207071904078063454972954577208463927530056857030200986057709786810533019838606174872050746460837475834260566055441410395805129523481902672214740177851314801113
	{ bern_num_data191, 56, 1 },	// B384: -110754162756402172153014550168566972984876925083693264831143127544432717811904992984077240231351850620045442158975752476209437945003921292257289655906112174208294630503691959241009346814626779961417257948400146389011140929210993075671069409245612465372014808443841918963732454979635619634196765514065569765406021995951240364020270070411437377187081353045931837302854850452592893523482298799136698133585855070465304605234654821626817847160151252277371211732021978740981118935331815732788765628347320001270460720535171080710693555387
	{ bern_num_data192, 55, 0 },	// B386: 2879114883186609620826723532068276104139845449825894019948530676086618349883233245139084663416929458760597036667413717978530021472148264070597286070616857893183807259158771980877711836973364470227289919568822358886590073234578910075775184060367188577311832614887005612354400063672439629984465735358226535865532910705094242132700635264096296205052370626838252677418749801518077664289390262828965585623070897002640768910479324438878660938953441067263764560452279108930457475258025425810584201571774449957241464340109525100976383
	{ bern_num_data193, 56, 1 },	// B388: -21299114788094757397153706724714536413292077775222009197296487570276368549767668483739905654759629794289722059088574391474394384116388842393472198779890845792835783368209072403070166818305644992935634095949389005892015797599060514475400351300665686095027668428158520105490245612578226308332064019874832238296603858849991741989885454092253889660892754436759635904520725519771622791567806625636568537908996210911982475409155309551762403125143065067389753960600797968698009862634474184891040512288957749239742206998790145616588343479389
	{ bern_num_data194, 57, 0 },	// B390: 1039554412204304060999050471842935871664238236129525031050621197904673190252061816306076783004652192616133527774723493749394461545816137751676691165637363944930483826319036927422553141330104483296290342476507053344206817648719129001417301179730182909494636606795995576156560517060235847592695182729113023238975218843912996538779543747649999358252604590089345118921257104639445913236211149024538216358616556115899687337155136781007563112551684977465108319504450250735437471011340987371661862741413337000516697089619657504784045957077408711185
	{ bern_num_data195, 57, 1 },	// B392: -4666956320257517816926480178489878702719387148900232522527912339796188714409776663856362141719980502875970806945762712937180144475887677992558175799481301586019202060028185307056311432687319799854135340241062231395259919629305490635354239890090217072557890791528689479267987496699263598146171495893203013485575227547175970131771602894568516495986613037151863666577390670765165933422564746168996994413125484969251071189411262200344536746879649016328422523901374916569404613335757056186544409616787583076594896302119414868190918059336879970513
	{ bern_num_data196, 57, 0 },	// B394: 640808912350356174378073333715330795309912947431801296035514496305956924194050478724997308276302531933458844716623312895516343306208024932183790655351844102967791249508631724180677304236114904329953319103713608769803340518450516179464461284806009110502342220743568034682133273443656465906102058462073733441986152637932219455262690498783033366796807895595451968974170018589790265173871732540219203496470134837096254721957294282692027321105998231580155273075570903000709400332769684568638209079266772432973508791091418552966827434770217964847
	{ bern_num_data197, 58, 1 },	// B396: -98872162196656114876533219362632891391774839342005000436956938726481191695417122725991435991920485003784886516420949151408274403750897124053086048470809705387715020563676318491207223028465413318847625119271235350352217955302858427960756286710348612322463571556662841990100314844270405671459605112346068263402145070889841697007530455932282600691314028702416310723147417755942945877131986599840610369192441659461647425950295710718456957848137284733782503430592302360661270817820862416426647830439342025098395116603056716015807642935747540566951812504354652379
	{ bern_num_data198, 57, 0 },	// B398: 10161900313215566319953421591388637402328180425349211048816698980319072816903521145345726221163084105611450343443221137527690722856383209708142471452342875346539666863558482835019156804751669116932322755085721460877938790181414341174421583630169802248409852214724801939766701626707662229904797008779706437578874336997303238218116573968772216970036489561373747407630110362020821819680854208929607112013855668348426244596961480597381595137016528270815603652018778457314919825182032768360703403384404569260876760458965758437801728169587522360995301639
	{ bern_num_data199, 59, 1 },	// B400: -63783639210289998710088973624588233946566075008131539459746377225328551512763402330278905606150965942861218654753440979855135225080751599455762303374322801376784474875903535720147084146967619965166480436166324915138652313161158459147438440579563255414402868679468643443725452316589751257887343519347376962412796543353378510329227640325960354800434372777469890448460017461964152127411007649663198873691188302850776549851095445319674329831032713432828366945325817352958745749412125525231627662590308189489017131904402298383855303749523779093820302379681027746367
	{ bern_num_data200, 58, 0 },	// B402: 1174239835539994552190497513182360535032387583605057260007722004883059102557958144704940674287492304226247212849059989833910250445125922032127665436388239538661698487981932513000579577766999325929606223291472664224576178291713742872723127632853994169543584403270186239889883934311766077803787140536031309605772620994720158177432481254737877501095184402972656917745175226661913130878960138618730840741958163788195850901560843232573640710143138001159729682511610291187234554610346621711370121346135534129198492308718185558865166313048808914617330314355609497
	{ bern_num_data201, 58, 1 },	// B404: -3459038918426949807320150484933956945853243159595350413053075601122470521916955664973829953506019998422380872167968566067266857401026670310184013796611289015884412134623896705526558633772056365694507697389600886696154015160862337140032194111117938579681157914085424486545326355341017764587852271884318010152210498883089816668030790992239717499457275164513815414692072356653908445653642502944394623033131400812242246305136709927393331111317205972671896631185417486747798871333208226992838344653421293924893416433794558513589011611309370041563779286876725823001
	{ bern_num_data202, 59, 0 },	// B406: 170003857441113621055924711218201581479060969973774823543550655221015298985029713903581691625806778175064153013683952617568923683195904825491671562597778394848940698100060988046881674679194048284424046096930240621809667552628402886187489064670995742803216624905991737595831860741767548013712391467620520309900241319253287943675129083092747241525094828376937402590205346662298390862562643436019735148452642958172300132516340448730506554851256643796686115524433824609798825320819953662000059899761347431172299049404919145053054118348793890650129877368554102264664237
	{ bern_num_data203, 60, 1 },	// B408: -31826882167847269036795264135997035261326106742393531631262513546951621739538129483912871462979086464612269631159787510831358937051013784806855551647371523568233230776308094926266913151377871925647720334390123342313810138336493293789276924639127443823386014514502682882716709333886588047556737429630427737978891250291212164857441066067952971934975332936367526583068834875982474415309122221371543750940258579267452360489050995048217629796997409692793673935051432353130414145045187876172429836566644615416398029958336369046123993446514393441794181039041943485420490171529217309
	{ bern_num_data204, 60, 0 },	// B410: 47002375233508680615492575022874518250580216595322188118729388581779057270357890909757660925961204865010764157357677339640679419801075529375841405834200075859710151539426985792722765113963198773076233038710305332376160833224527455197843754378242330663125902354233318353062799203163603734366135826055833545210943663972100422012871119726280972153082552774282015316310107675884741591238987329522432070124995685585469794166878230612009713252291615918394199230644202167695522574730295764175556463982949470912949002495605091357997599244798045099081157657094553333043809915382015
	{ bern_num_data205, 60, 1 },	// B412: -1104074382679040449322457640474906559564674033012018040552761693975196623398701263395843134574919063111979334979001689856745801791431844835192880349897217288293513020820761816536292340772895413243616457931467439624320619545324679396693426479472670415005491693729301629890910865952928640236591593400805258179861429283108782677380853799729252550169975507441841656878779871922009807575659278905966164200037561186284335874588669047079319694680280463911923325143499841983743646211629813016265241858462427586701167961402272877528256110590588675820001821779929699856406082793746601
	{ bern_num_data206, 61, 0 },	// B414: 830966056816864165219563221691255172504816245427194942775778460297239574008254673723276280782798993878568376502765275874049468633347470545478154168815827272595416765071482194437630416545142455883532025709379623773918422191234979559992742090527602639659473260751398640580101548381014113971979542275363074811349527026580264739170503267212543977947471780118824749687917395812884246155157646166836076504356150965742303158590029916282708649948973023160673477590749360021799996465506161348017383225242179003450331850903647117458837892565999818223864269663453594385683125383821474811083023
	{ bern_num_data207, 61, 1 },	// B416: -18840632174653835864968232583541556084424607654449238363350816356454780409921315489669153042640423571904583615446707687427327682018540206290243741793046153140931788677169249364676259458302231885326120895149522010431725107071591063425627272025446059167464033814661996655342902404678020463898666363623366708637084399729725592271785009331862696316729612579245598615561813162507665448387066401343329999818243511962109583265019621658883154231991893552479038765074765515515428784392050898556152995633956321371743766583910838111997813677461374152418833832478425757962198139801618258600291701
	{ bern_num_data208, 61, 0 },	// B418: 177948829071244383748461224300047737954439245366393998814954157666837290036442548237545354559654248140762601235025124016956688571054331709927511568833209554328300942088687575803158770352778902946800416194092364129368960809507136675944946524355529271391513095831833834095214141413201872443533465259338559071060276534081662109185490926535115165429017697889522123426359409741271701359896235732490827288153220352311977810488328925043422296933754175073177948425972950246944493271200423473793223213272148300689418662045121140562185310116950518967585206995379939580805302928813353440147414740763
	{ bern_num_data209, 63, 1 },	// B420: -6126914449391766463123273102284652981370509248391971126816109275821466096976801669348238710361647712578179757979414761992440067232917335164055107920780363262942782633482006999971350591213671109122331751122081373688391335194625200099100643843244514246383231743873282258287892336340426940736781587230644995704054335003998425945469627545685623200550970324534080404065484535299953386337281009271537528001339179644699195404880031646796095372570028624110131487675467842335793522121252328612723178264941963550114480615755660790108038424472918326815297861578110970433546154844146996383907171442617576638221916277
	{ bern_num_data210, 62, 0 },	// B422: 370417641649773203811105792421530317349989434553176611030631322780037740921920903496806496686319103807921979015270437429241936687918394087764863038019578527638851481686403847480960464641545840936004289242306394237365086284210791291343989458767793541220855587660095196948191905734357956461535121861354233393019487098593606068830314737953863466706245485662337370451037774820208643752612698330292374600196793018724057118532300846184682702881492970790966220893763118615367891028920559173128847556946881708070136133779182213573320504698972245409107308503781210793753700634159761806826499289415831
	{ bern_num_data211, 62, 1 },	// B424: -900309704889057549412703055487959300250691255243632314995356843469409197586598181836315775665695203810817228257767800995208832223406044287944134381117528642679552487333128252142131375359121793415508211496537834167452784284536412724329064314223405159310288664698829339128075019109308684058290006604682848685269913509631592635991061291910848588896849609801431590823098722376633326783362640890294817117428008250878447534568070706275064939211743430644145531251375121140903646902567865610094036531542192311798685900713287395549217317410664958760801352234360088468504559813801913565013476710034147368107
	{ bern_num_data212, 63, 0 },	// B426: 54022537803660305299034619951080701815883244369748020425073564798052876966542443431399087275857901045210724481101594546860129641620399468102807793533371090463155019439376300426001111110082554857406340378848339696012824680258786824575893953186081095194738031315027987901599699063076400850373460929533644671669856383541718682959908309284048987253429549866158169260473899283324734840555471844451471581906629081405048357875350755464695286397907639138344100989311969291336190793916170606327076279174475858929332637620247498179721571404122810497608597392310341741689230018260320576738940580419471886026121
	{ bern_num_data213, 63, 1 },	// B428: -178631832601908536171004558032761096296603555642069337022466657948224618220000462860819307447255038425012723042570990636159393162920489265496945881843415223197089039558399046230412722134470564185454526546692168928856644009854678892565378884116563496393911506002791803756925372034984042436244890477408434546164564440123159575118382731762120541349243900708792397436983071602078285813659425066659156365690242457074462226267478374244243395380526750495191218544888861880143020865916520055167383158922400486128739977249726236354738468036532667283720083951543434880992597829033564904575040629182418739065389001
	{ bern_num_data214, 64, 0 },	// B430: 791452428000395052990463674367408774641299277169449382275797418384963666743647706199968141726577699871535620647877271680371011363641725875016441804003162706216814077280766553803448788712737779201122868425785256450531121303233116813021906603098871081632396261587905577208955217566658493203885877312418398060846091120975165767009344894679683148265158035296420969642632188332444968324025169811975004853721487927435823390089679208323886268818820308870377103259885100640557295098484358112295185600733503211183865432570364543715288518332255545140994972346903247999234036372815320143622542006284391778075614230370915
	{ bern_num_data215, 65, 1 },	// B432: -14750577990707069090892640643627890396790588057597932870361312797605339877218555318290483697927533647647152620207786705312787195868985834595937926758107692208298403338603695989231215167692521223914659443461688651180043473122600527834618929052569980773595567060954830287077779819370475900148020136696922033144977602316267162377565896641961582226753571000379259049438007003714263998786954349001656043288757745179230747108219268158244213583535560775121257993743283335146172958812409641851314398652207671071800026121000251318559834563893238437683153099891646143428578083417759291169439869395337214083816200847999672131739013721
	{ bern_num_data216, 64, 0 },	// B434: 3747779487230132491900784839670360702621969953197210049501251358419118141986190115493564102700854690955620245536804192644210548283959203482329576239229460642292110251158496706142540965642461705544532623844725391336993674360586090434899264849404330015359243509766947985382840962057755044491819343032537950612194324352600097426145059000885091707883730246793387324549656578506520410600783165826659781478577755966537904539285939024535631431583555662911156572916830417427298791392192762504813321994018595884981406242206002171583618182559028568019214315784771237935918859841167713230012475726056827372638626381963585567
	{ bern_num_data217, 65, 1 },	// B436: -90024360230387232926513776967323326794697521699014742623495978698606015115117275163938036449925194916848722477911818639649193586017040660336424190717814222779195576374240102808595115759449145109628358599211511306846046027111627976699604296466038648254628913968475783753631135765609682725844055075467512860033319632741902401109514097069147699670253945763189080474357381924555174022637039432337932007567967360013189225484557699891500723386807516891972255376800483482791579348941380904127063436404359870716285253826928676282091132256974170075250937201408937099856598602948280585945432968199829410867368026769199252595801
	{ bern_num_data218, 65, 0 },	// B438: 268255361246337126367778228815259545045868431029437849645589178925638795843497414272945160749514714084165426561127725005493039810079480452517290207498185200717509668055892683546318815665341535697032808106797631781867079778636900617376382054640817598394038676153517033958597909974830544311249490853122270098045783563026899566057862076965478508567587449877041567729076139718636854981066664507897053160317558190734639340443419436918626125596334898307900637096349388220502296543130848656587202710882968136604232104512201075293126007959863944130551986019010434312311477565523149656237135607816533477227160969517648113475415388407
	{ bern_num_data219, 66, 1 },	// B440: -1971549561515498045945281707781358725202052418820469210287100375124408635052889958528421462206148998040363604314916692108315970766317682360194568697651597939992942608607863240436440670587263898825900455009148047595679837461799849465343687138591048044960789240368282898014290879082621858961237901928382366671020037189395193173411370422088058940123720113875828797411348581899556685938975754080936775135639140747303520886284176117348920517204041675362641162399925576576653291783247744987573436710429594592096815313807926352292662762861675065257056115521036077036706726455044401225578559120921795944351508096992367201543994966078858397
	{ bern_num_data220, 66, 0 },	// B442: 934217844394639862121876161182125782629662966798874841047916685310521671553962326103991809647198275117953002131456853984058360472753503867675200497447364861473654065939291320525986944570166180778722315422080724702421323386482784126733369118721815203984881266971497573448614086191554625693617723971683850141789064565402372607797348631247017594179350444633051496340472506374723019936564961282558140233726105870589191017887960191293607258806456016263231512800235871497605920995641449875958591869460832774676734017514779283735936104646380107986104389604327378999649850427118391694149262577932479289635308490619974233553612397882181813
	{ bern_num_data221, 67, 1 },	// B444: -158845135682583637310050414378214595799174539534413035558457927180260655307343938945950776141757261524377755785578389794390713400424204955224064287421714210308705949074744929596932632241358688262813726174958748320025797188191224303535908875129465586234092629175800592249211106320935394054787272761311671502199224520443098879151573888801771623192883526328927129807622792528335792700318705689540933290598347707055522491251314640804320693900281215224262309217387438431268666875059083616022905739177343532424279695920452691897028237708410245697642781733124304062104070106669202262888345577753573178251769219880004565578924500260455594131928657
	{ bern_num_data222, 66, 0 },	// B446: 52820988550912804071451884491873707077611397679084704441786148606552305037050330902476831330763618274617948135285949957728028695870688501651855365293214261665763024004555565085202897776922988749231163862901818153108264790734253251559229193150038194654616836673701295399639842711610882623238385854157477150420529686140635722118527587063478286467506193498289348590140209058848431175257465051090606564081140432276211107220257560552836024246626312132223879207171064190421730933829702220468746118116687590172977326777807226148473634828964585294322560361223896420954749054906526495733099883401725824247665659378641424764700866014787892724263
	{ bern_num_data223, 68, 1 },	// B448: -33509969560310951077673300385182939173120218233464878294252193880216174489593173505823838246617056145585882555706860451887313675357842060706217782059762885287365030658978615168275599290138352468354789757259008089648541137547348110439089815672768327313180473534796888815851856313394644427062261422524265399511451721069073409293158382781768172256354047772889044225230507510811482737634673210381142106400974943160605739571810507050337114409751599167906471400307782233953490003352622899793151422802066630790773271959078676470883432223098011999197297967048507289842238199051754189231014498571762573655266437187969662451821328060350075608863875769571341
	{ bern_num_data224, 68, 0 },	// B450: 9391055572765375337084396117314557817718180166181509161271561059129443589397485081513018424705071474206174166639082356181454829444072491877870552062694059378849770958442322223463829270989901750468144609171516219648902784638712130372569713998758894226403154437364546237046936234486878313444740508912905759996491085406313529674400225188471243945850641568659710670402270969430805001894842922440442618558016542494360661268867597331176547554831945263940482855409773467788716571946235493331362953065136196925332392537268524281812660120686916907551456071718059004900562940126515655638458838017179782433551203385736031994621640626329584486625252298313721425
	{ bern_num_data225, 68, 1 },	// B452: -8036788600329789637554905408606434751151763343827636999239373595458189088012226087443084910869936431803106244357312755090962116368482475276694252905815888538084063223859971526076599239358507163699508542178943276854150562290682856423508900798777112787185623445870747150615150782172422604213843730688721433197193927654307261557625517124764287228841421171512634534585391620401335799765458353101463743603983062786131145017655611914534755704275915462765633857066185411573999789535405190641054970837982446446314245641839258145246102021303507933166787126508119006984137728812640057612823780541560848078401500756860998000273851310662643557278203530509156427
	{ bern_num_data226, 68, 0 },	// B454: 36887651095190359395978631707450897701552180104326675120919609694820560648030474979171133539537862210662044736026621541679008373532300695155313150561362479551904410240432070856446263923979299500092444516028968803538104878672539814981236198854450478175391010338000353791751383268673072000938944246515277386132140583257856132696558562847161814996976075174769694748695438632575090586824991284249542651404132205213670261425227222486264304182560679963038720949995579422933796694986011135385677383318542530506241731018476230796808445574699332521366132935744942092063737117719972419446305379041821531028902499051591918182645467840089773846410376436748099927
	{ bern_num_data227, 69, 1 },	// B456: -9231251497205337786805280106627035365614237424730160108604924651736976180075798896215248792654225922031690989989936814428616639799004585592248516552105228745115600772090469618649949110864874437364870818222898493364585027928374556652768749981360929058298243205794495656723748164403781748730579086335638752417431277593473211309077070359896017274789066550552469547698979828077256389389589765286385150263946322137435703489322701057413339409715907420401015745559280769997899350755949293570194811595617539775432300877948131084500469766803745905331871839118178605120693482483577762003279580322707699760471279269534859347690610372106577357727353920929624706796074041823
	{ bern_num_data228, 69, 0 },	// B458: 1027825635381261025084137509518564962560728450132223539521526948817353636181702656928583828828717439941582449877622669707429906934288552278291471518913824570952553234368789724603442838567318141441615655257676812187239952554217908948438076178377910225560489116748839886969453337695309781684455928141552611581080216941930192968523416897195063762538557409287539980661256894009392408089358915496977576627225148859236468505369342003480428366798569334698706219583396397757047422466674537196192952267180837549901710490935337309113676890484857602521544773316821275084647927509602731787989854783170081148513873085444058741939360926584684355544622280387129474006982319
	{ bern_num_data229, 70, 1 },	// B460: -6550760154113509955322519520324689762818345309330319372044343946911206397745316500483812442237014438941335293944750087907405849513426436624910542114024406950056919447434524096723352448017446297358873710248617421245570015225121262135612027972284197922153718331776532945085169610851088437877134878008919341980631531214431991715959299563428081327762284421994333768251921757188656927704213872171465925501861603885110199062495929817244864046765240300372782070942306808931353298237329193104023648523727135025613272860312485759776097808925561726646874622086120677449738708016595010877049123286575216517173385795826972669505322466175106064791167244415577645190187783109558537
	{ bern_num_data230, 70, 0 },	// B462: 6368886588855890529015573157270243329857473927510055032448029799766753973277733490743802481131249684574480516536707396064341401134831688716527812955468642497995612469570965195817160487421985680788793411096140356661976146745150228102075529102340373723482996983265766606390143860966670113764902836475227042342140853703902690953653738071098617987052339494008437294258743953709135498602090607507693690330811502343804351805921729587694688949530767925472547494085687987805410410505963373499481785590861551304643751957929639863906451583045448988420712969430083368919548554903489673904877295745230080254098114031395040280378645921227902389659674535661931328259201472684713522055433
	{ bern_num_data231, 70, 1 },	// B464: -188572988301799749241127705615416162812212213841895020766690762649760470928083270444552850572643956114497215752611047787304109375175847805695151784532184851620320647579855705925496701761448465808354795813973779680808888167818764964700925538842134054390992956001669225520942778629366261309269472085949866705644243058822229069911401050274835800403163105897188918692416516840686738234446171587614205164199212128303162013809506690718962024295099161224082167003915292076143373222944136866167556404170101140178710147326875675233494871699877286279336655831877302931691870727029196060937873178589575033953909097962613832380524097498719417990532304114093172036385627503846689476887699
	{ bern_num_data232, 71, 0 },	// B466: 413664867987222956244209355804553132010737311619873937552617773013514076367023256312176160835062661892330568050774492900833764272232882273128949537336490168744752502048943049241434525025420643944559491826884487174091266835019079457750298308269731643882842579624683236689298288625957015934020852065186333120537819299541510992711232749590370342660947186143661434743740645683801183663840994358198551336011498396150912151423938206307866725487635171065947029616755552973030152102744795495331947296938243287814790516243968203740094323906300807997945263580249967044922095488324059855868304323339162224087731767838889133184638682384777584272685488996638922752221799803151101166568141
	{ bern_num_data233, 72, 1 },	// B468: -1031107841715829258343463911912030698033011526937248355743056689674697602723540112990172956648590063031143260600724004347065027947507100488450593390705595096537384272550134562580809036689346664720973019306107636742232165503223693884139986374204369981544077656811163988149479258369895200746359684803254154401124622678491322587940166253688363451761279210145812935556959005617096357884154904315169217040557989251752098016262897990226072225936970292748900280469462419239068829802849814616525273947160256662458312243507612184481586372693712226732955571148746164223940290646509705984881548422992991644255618458312931517172972824955609103863870050004830358982153156128215328921678827090764016307
	{ bern_num_data234, 71, 0 },	// B470: 301188512670574409973522039731799774332284237966284386701245748565406164428681036128926063056095855532173991462477799681429260898037617758622985941710976235577943559100259786932475830383970536995316845412258295246742979426181833225367398491810295210078233611825547244385629725708901995508766557190851612705431746456650510895626334976810141560416672624945285953742157497174172068239724208754377218814505115022247180573164262593883452362474468782982223281207823275802362572430210812017251300349771480681113489830696638136842926883664618708287688430079713258060558978096084995295625323965331459365135957743350303225791768643943305879602716567061428469743627314569410061103860282955485
	{ bern_num_data235, 71, 1 },	// B472: -770937004570847542710916650565931789612450235859854061364164699012203056638918055135259895416107273426948797500232897203853071790393885116465171393875976673693385000879337198213556447794398434782352654738563122022624642967864571454383814267648876048449590603480115693689162580755992686116534563663816203506520969500954741353683081691871170841572853932684457019190727452579388269518761070066012225637906766598808889134766906870857170491069727522854987604110140202165701028056317715546755482888281141979064206161119893213557441124682697844058662867837317718568074632672139404775850673801367503450134341628737627508058275331031355246875710092188894581462212753275513865164976897399277601
	{ bern_num_data236, 72, 0 },	// B474: 6129522921698903924225094098894493975355342495202583967070268649960491527425425546286128994652359747795614576729300901193288468364098351921425898605865990737737763196859623939630382031884908027628137877044490771874628629780057338048896492947577968007519815003168246395643465584343043193237880881635998419368585273823574720837496255282601496997088803126305575254814207239481124819310777601851780008004534530982225452330277362311532174615219685651873091360796309808900938980799843045197724124205459703692404692815206856959614667498156439854860378606039596585529438689777885628862162187008631192421450307071680585728728072572580947780239520470275779631590328798136283209653623721740978652009
	{ bern_num_data237, 73, 1 },	// B476: -173794233423007364057178441776478220477329295247992746246194028033098955394598434863688615219916214324301023001093357893746330083903744204991166650812061841423746487587175286790822799578241212757499312100323647899801856816587814694250535160608651214203178715194330829602196319299830498255481024809653516681647938371069642056989453238492194899464534194575984259211778777474726825907276342679607943595029925764974686120493830750858815144111018156639748863065679944594300279690320295481014774768770077734050367942856894507914571711299927762683035011101547081082113463840150439878440505062095907817860452253434600485043521832982039217192780017205043143542812887267054217968944656636429743815938366731
	{ bern_num_data238, 73, 0 },	// B478: 13873674832923745170636547493407974778812031787162484396922203584245099363875266410392579249977654901546226138255725682890165166445534326211967788770965050606335620329629392266509006667636060346080828403980900870728472844701200849051031032721110383896992993960600720447264177011379489696922012639234054945046493515830646916075528778995875263891724422324224871104321292779816866047869594198817075501831319907776354543266924566231340617726210269713505336228589002649382821152876769886796237625064939931597087898226387660507299139385252112368241337865982079462586705656758449262979906152409703115811425535504703782935179149721682887228861005266932595149810184020272544138033841220106232249961984874041
	{ bern_num_data239, 74, 1 },	// B480: -26012984231082938122321205711106137025736836308811099420978321017146930273005671218213801512995150233049010223325808387207760652312185884489040204754381130425223206104908949348483694397053700779323806598166397483624967026385155584314813089275200872985931085543928822164664368156111249818285706698582816847860316768251385568355911376789419906820360322920270272727732554866797105317523759568495736021299387762599572352567156747373223964524139683333489545030164669822955224449969772265055374313158826483073058617899550929715104043848380098396583498089878468223019258239295983312553586622706514962679548326500707178484227310027019877548445744372693423428185302230083093969160616600533454208539007576331211435405256579
	{ bern_num_data240, 73, 0 },	// B482: 990616118004405209547336756803741296643221987382321931721822820900299097210222317336001831102939236490395767769383589450743538317573906480157831910388399026009549363482047723522295682385225255084608513720106406633464966275709378145660935302980557499077874664887504148114522460257788204486783699727500508138689641080038916313291730518751063292404119140988768624151887967557709255327422581104429283482510069570158085040668138860662778558327704232203358594262804010229103345601462990376149249652299540260177492690219461257167020609270211173637016502365724336529333125021542322561542486553234490872949324335738034611680591470710376104053043734142034650737431499785882884589522913671849942865299633710178111
	{ bern_num_data241, 74, 1 },	// B484: -674583921974243806727583626605726893305001263343470277847644141353711283719144748396214643464815527720051176636837830641202715031912558545751272265963459158832678711777574436725109883048688054377892408030247686556398952252471378342025741011438575099484896341336771053946168596117603779433009583486087778261092733102095362575294914815257723299413552987428930625441349976483182063565793384408266465380474529520534826114954047630754878668040735849610788709880820541989250906334800119386014176221640220454426941644202670624599594997416757514254570930031264863092952803531973860879930032899029342578124854325385199562765121526103213588359312368828453688417972133504757523704888418645741605357575301183566273541023
	{ bern_num_data242, 75, 0 },	// B486: 369763997577304898527792056092078784633064579850215089906718927953975408532819407204558577594984146089620623998022051043813802512840569387856574528038951679028036813020229062675066916989178254799161955591299056486170972788431152654760791766791190599466061280142672740585701636947897534361260451582259758691868004875864277790983654375073056163053627813804545640618169241729192679530964042280652574338325670662894789508966565337142721844903092886592945025900894162911247219665577745221033424450158824779569415157792860757313903143859765449917326253963605938268777389669269349544451932422774330893531316131993509969738757701435869993709233337662014445697606454995935095546520785205839498933104702647973917548450654482159
	{ bern_num_data243, 75, 1 },	// B488: -1054181687381409638131616910853911354455980657913781692616470855145305376442167447677966359041858772154880528891461759759408670524036867330393458847554077805022113371551512761301353668641881943315640673862411986402084705908271833037248441148559758203373649679290148162009307104085713861437407027770249084665069566424802818695978402723455508336525572007924797995088668996393412803006736971627889522618048536287908252622198057721526239638561752413227961375709262141133204448616567780414625262935283998346756442958214463663418419136319815181399963230777047415998079220041299699187067412714951204651656933821520847527577289722382000754063804433988042815372396860021515945936788059415457004917777955610189853432234056001
	{ bern_num_data244, 76, 0 },	// B490: 490708060345718168482949551065008296976352341812156850912460754793773228598743021163789697895339848508047563198613297970895771272423084451586762411542433689884882582217920150615320261296412657655420294950882472519077107436411891314989684272827405143453664676299901282427746214002776016429289992734596941647026794542862610180682813869753438462413802302318288921935542654412271101075502309306996459972517715826132089736597584320511669263794701105417099176436055541622722611853665479429929243382275785136760788118477444370781356616739167758192241507716005871662971992278037186350173271291067722673038829083878521474773044108789762491726385320922397469619970046438378452390321367551511627206765616414040686450916033159995734945
	{ bern_num_data245, 76, 1 },	// B492: -295710682036368660462889828594612232955924955002201524705248520206592222985898208468564409024643552663319217301279279456599515167727625150606450018918397365866826625510003837807762234721907229268939728260753209578951485832358379661753320905096937054954098245328282838820612002927999827875337943367582502020545668956501113411001279555402079055392887648432396357270387066730514118593546561439603919778742559512015901475146476123141564243291327909428505227081149290897384800809797729594081307795911125761034063373560371910341119307145118793762233074626775908914657621875311827273319354160489425009975655550242275976199551186361927525119846700395907422799296606519248369841030425783198567324724905036753320437659605858401058641353
	{ bern_num_data246, 76, 0 },	// B494: 48304952056070024985817756788239978908682438355340656791822950062590796355241246689448963611728938505601369463215719576289607035969877364225474402150107267021033472617633002498666739540719726067208908400868629471652429458078768484626439283884479517280978247192859399400878296914805548929586054952054550941690046726387385343252474507896205536559285343999286125673465838911018803676968634234058996143076453319007358347695097769648224143191413651220988411012365741972645136470905240747776225223601701498704103140362659865756058524036705273180849600017203422636276522059566343973347678362590339657974928808786150211385800610012387411013195229675295096785833478392423958039918096194458403331849842918089944679987935690252652536647
	{ bern_num_data247, 76, 1 },	// B496: -25535109222241698972694173193973518774716242178265877234279078154218306288190453574391345349607020347701104389306082727640662249328994752154372973422361999092715922759633521270378541507790769763357456276378726595626459724623679603915577643947700472106673593583118436960062894166402312867190376592931480464022802240967436286930003098509086131781553808335933575272888361402715107788113154287996385861486207257531899222760762747086758473894396360217594584387656887231071811145643960111628458232775253525983817907496407600357182919744162523813712195436135703038816616947504736640465073624938220282345566631808140813969037396579578863663701714202683178828730441933582773514024218332915875259194767588507001149870106803558286434937883617
	{ bern_num_data248, 77, 0 },	// B498: 1098651228481515846116735605942901657544418942763685605483819128454976385464899434737242367240952385067444749008365642568063670579728409673461751272924549125285602795045413203741844230426358616759853983294227411821897092348333446120995756339616373490620446536298890167517709746328742870299157366295356390032576984786436553789735950197578753614711411671045054914305425293539519785975913292188458435472840034103326532984267720997838197057411785852422605414587329459898626238314431604983174665957920693815755227736013545929781603072985638923688324355299338791368472239159091263112230452362400314432752766640687084000308229806355172210181524971644942859893996940410875091940649202106109066788663807627887433701124817799811432100659519242101309
	{ bern_num_data249, 78, 1 },	// B500: -16596380640568557229852123088077134206658664302806671892352650993155331641220960084014956088135770921465025323942809207851857992860213463783252745409096420932509953165466735675485979034817619983727209844291081908145597829674980159889976244240633746601120703300698329029710482600069717866917229113749797632930033559794717838407415772796504419464932337498642714226081743688706971990010734262076881238322867559275748219588404488023034528296023051638858467185173202483888794342720837413737644410765563213220043477396887812891242952336301344808165757942109887803692579439427973561487863524556256869403384306433922049078300720480361757680714198044230522015775475287075315668886299978958150756677417180004362981454396613646612327019784141740499835461
	{ bern_num_data250, 78, 0 },	// B502: 38142160866467232884554309224034651634093138120562408229937284335262462582150075796219859552052172031621040304395639116490006921543478655667154940739556377503624120354277544396762810887962942382325268406917540639101080669724764495814187297806062515207318249672295291766329723921826377856515614624615956440515767735038166213859359258260596787181638471860235900018041798849234264568412537290039238616166689649555178242643505175730845234684718491759030264918961278228933277428217322561407632723029650720023471432310416563550665717641718762997568990168391379348328588305018146978038035813910304323456744326056421227644920216556161710045794909005682363208754600486590889788250260509713591684353378394987140492585724853790406456014075678089228508113
	{ bern_num_data251, 79, 1 },	// B504: -1800677132945039166830463177507754585266379503826991151092966034031576449133878587142596465305242073160144152559961898077078097501165163926688621532562053786332313051581764169357553522652874187792692396402130149762806987993277139084391032030046378044998249662099092714127575238051587028714174701755384004616631602375127554782384747315933204589349029147149516932515107635948095098164610210913536208041544450420100527704419751371323572700724631061364176730785513373102292249369445493318934314234224568935547305550656813935645001939035328053977546993164816506035208503720862965294463401376513971725070845847755610266543649189247439588435678329734616774448010477321232208947899575788038500962386042680131078463676696610992661373557922895517318715229936758650701
	{ bern_num_data252, 78, 0 },	// B506: 3407092664000888021203452531321854097505574771780010323140115243639329695760641501216890274687602915403500330881286718226524973566279456800400995134023663766304189552732495113127402966740937585046378308097118696467145417064767837733510564449576436746093048912312056149374551847538467854985306221689031067872127875563501593887856208806316695135594877531447824003167096036065617575705056557384022148460627515690208386807704103923921927218191582002317705749682277713972085609961797345781490424738543548344071197524236264188717806472578552246183743814096068932014761972317033941959670114396114234500931393882909952332774975285733817488641743474162149675896597913803331622535127687151459453007625739740586548355715148750010148880114637554413024765424290583
	{ bern_num_data253, 79, 1 },	// B508: -52330872178864919159062934248811034677716346435451171579625680157504590875649650612604071777425057835576694786058730875910671528004523387504518166814277738052868766866355057576748290359718969833452822491290378051432150449875893578677161725044098600023286511690481099580507383765244539884609683069965610545535720187021317978962117739273816300866637103926903577096852506972785978366778165411897640281470897335963093004160986149712861282324545139248731784241707150208210973241489236159298771028866236477155299508578436092419084781731382688534659597130973002574127128838580705882780124058350777061662396371643479550445807460673182703996222427053489945756261651236145314233440795152480496528484684484783377509237409326975075232834132368554805879249824492525509
	{ bern_num_data254, 79, 0 },	// B510: 33242069394936347841416452736699473427024172138845682019256576584119765871190312926606100656637908214423969569484651870584454499241507744956940778895391539107083764018592997271437966124168906294468533029528366336963948950374238950107488306060566590126749853866854830453845258555855047785657680603517954774581467944730197051859476737155017727889337947707074200002710653424029485315372953356563089252705065809361030808343082143705610918949319677129142905096758815602111688895068434563700079775055764612171351726142160801487301473752028348109382050140650202453637215003346583729252911026192674908235270003351956741037837298762012702317383887345712556891668990317718217392336674707264997388324092541227765928407061361719176124984332381749616812108779909330327830755
	{ bern_num_data255, 80, 1 },	// B512: -19574090030244434047213351246572287349889224090386105332085530021565212468309629078867733735082393179869360807348367069978848976650308351642234932679401041693373523083884636419791481410049596925094734909075722364890598079520710349410498082492443132331727391159087801199795999981412721502899511443450789947024862600168168142673409305962634689502298433085733432678101898354175041732136336805601649931124766200234393846083129971259028671079883947611022235924234367655079017649320478568127235277626555274100732608797872995058244863960865024164628482909246406276310802734955042229966804956539569782508945050791832760086043325797818433262717417889163900766948683071025772992337715877718869786571877810172471257113404842472203190786613590614226393093167710566161135264769
	{ bern_num_data256, 80, 0 },	// B514: 5984808793592019071251637705639237012665034751468238111630335377609785723336070982378286418024225681281626410225515065228397902150289621812250810050066713773137305297561881349925259814592218358693284064924138179550537643713173549079240512847652044362198021481696935137262912855751675971206048699430621377704335929946858886599525522767412796544594312493895730432672117789950613433051224768884345819401535426025094832732693352787549517647248433642893799072513242825793109661296142041096418992861647022071290587539066270814851821043847232935810713510671077324193385224732158432654589178822740086968512399377268040349081257115406529446007290293312976943015861418307127771290664470891625392551366150283915791140376237220432528560560396842964137537614815594687897259007
	{ bern_num_data257, 81, 1 },	// B516: -3171063754130662024524418208962167067839045665148673268688919788201122137993583170971808364662074274232666642053133416092689792604211548622761248164434705090369709712064325733752984791992995166295609910020711239553079790654718521438346662873716045934093264127240248286977372996484267736259265008438815998984993336599316663270012023125012925214851790655351808172000672749838840693509655263266601401037528301896401650239914332804014938251599783809089361608341378084286920983943097636310860163773870739980391209823884437560448434440200611799173871557105368827962979286668722271636912267960931855169772297597292043759562073364001053592129443037821577438519092603891356839904444624214933377703308448877887265978135387594080421289664078487170109243854104577168788777527205195143
	{ bern_num_data258, 80, 0 },	// B518: 273280120135903400796020253856496684011788906317364748953085333993961201260103100240458401853886188153815729448551782636694969615369921631309790968386191316441784908017981662481469984984167042448669367248157448891503875887451536439734237831153280451449416018604604766043854195342721279546881034771821254740522985524013298494222843478038262936400568637590829723962229916157673134572264808025853029183736196477170743136876861347086019061648771011440314259278873592910071332879887012089047348037711009115437776321582669271597906200622918591149153504310087714501499195741647501615811271701261514080038678771942746736185575324689976357305256911162281729889368248612935815145764264376288803018064102298711008322925121890227372020995066241641153616485840062558888315856481206999
	{ bern_num_data259, 82, 1 },	// B520: -15238788428605039378115047740536176804744567206667015273138665811936692401854938405838569364075998824220469141187088855638530878988136135319459512241969322936054349829360703375345376810354436271719677891043872577529784018194689598522436288937138335018202318283345082383679491434519114921168761309340363181574377119858546985793819404059166287930359067460156279862548079893608415891765800532767931587051491191292999534306031712249512782532969062501087104696613607997651856092534274938155634110698340371323359964245551053589097908706914112812993613987014493133848964717508266531939188324895544881815213543990830716909231300022370961250882369322358639313176875466799030845939901373969474799475354197376777647985632239823850663381353339891722507727003481892612429872120342512898069057384453
	{ bern_num_data260, 82, 0 },	// B522: 52816891283770605830077313331325789955558710696010957259309916992608464599553601004164441698832027454322034763661693020779573599472311554568849875071790019787050620902841007240148701905754808785000458860323773087347981419699929543448193106713776496284107398113095480898620685833840352675013723575236537189257924190093984849739023291378611276456223939354491128704514238280550106193234350647361868367416876774790024674680222528279157734701378989561563691117830705929496218169940721931851924015375348720429393651228375905390161938965947257218549658382698320728298498834652132730439501740226639576334501780433382797745216592563966046711397430192165221772484001795125540602705007126518637806490789572495829953718618948715519020409362715121908839845068242809457961462253873037690356310131011
	{ bern_num_data261, 82, 1 },	// B524: -117480689361211447313166166251468009699623620454033000216107989040817903547201604849842869006326350982666775508399353499159203374500285888028447665181130108241126172167265986373064691330530553024545765476110712894561169729072048098673803229242910482386856970956568830040163881098991269512281296124417734272552022576687786356962609072212836896669778015016245778355013380888419277861827003621062644161968802514468533744167950366538463316869812931658475867856655072350049487587289390473130318039550347659178734481501648621396798501613546563272272704829159777680214124833778561525567662120386659779981866925304959142290233687496668297602084940618943320049850094716256329797604439611200357006052235483000447850393635260429885343381872766018447878560995989244128205649813558581691382994627263
	{ bern_num_data262, 82, 0 },	// B526: 624922331312776473211378904153389829248973306126285038561741107081420976896525537385643705333526763797786358447120246174604555658992998043496072157747024812232350202780442603988225504946101054051661947279251877978889787914507425007059014379105059050080892493923329971127871558484129692266997214231422939497821275958312524972071295653314997165691359417693165165197558722682436343466845938272292369295435336576723143069179064001414719858458622191463865616166613658973530269861409308522003562719626332284828056988947988712694494533014209801757219138142932589205687989733073245175370157778846928499077678366695372554280745592938157075898431595570739719329594212273234574957664704878574178987844560659396962992842215167838977644596061384309307907333496206835233208684597271417843187595652103
	{ bern_num_data263, 83, 1 },	// B528: -4672655990954839727182789331684755237834285507423963336884147799519175436273732254955879819142241895493860287798232014575611082898902754832341321973148625966840791876440313670580607382894622829503843025713838701891174266939268132646719705817644560470340153831933636852129336125409755916693365550931828487993121082015657955371528439473548434002466717913952335044024396994493575320039613233883990121104963585659956375487723200594996147237107827547685363506391821101773022047300781845387306617023644855853425140033428338607683729246063478782511534824593436516644787689470072408943075405713608970657285530930211555514094423302176024475598533778184193277126776158978895476899604148694904598292029749388690660651931551523149851560783893779010603199577460480607922177403015050448976145877354014922894271503
	{ bern_num_data264, 83, 0 },	// B530: 36817908413010803398509588732877269625137726906083650287817517530107470500695285349472123380514365935078839438344466400848515329756406032515164693946879104606546202537909958193401389763718959409817044412151210208559503870021018465608232451954302847873087047205992822435311040347574916206895930896485351574554258211988636826293914893271488345415912540598101855918273666347914064105580451823989599341876736830664390042035163126654892476751456202225423628916458797486573439171702236779587801319076436089424466243488556684022179323104282377234009970994445607857011848305345344470728847609669767493888251595755152498185525483674212914626503074658909340865656701536596935866858799840380832774730872375222250326017795168130904890503970553801632058318637966915598284381440795284308145231580399576973574855
	{ bern_num_data265, 83, 1 },	// B532: -32456155026455675360769905111180654622508404843762530841247660453239800770668973012867664180175163984858456776032922618591751896662991039519464608583859082132273770709610634041625641467598288952475313266353385501831211835207085524953724544644532820179539688619760497628286736719168248207139942843410731126177177620301665071512430494461836373239009273797313871491581599808076123462671306548360928341916252282132924203215535378621665023296439299234488278952881221480832478979891246496808283914007023125300000123955751041426956064851910536565906869167100057739455234685986507613545939322527274811378866649653003975155189636356612880949696578635081530573335812504038257688874621239224100548372996586676217328068475714642391572425539761785774784367839748175278335122646185615511073543896904071545643689429
	{ bern_num_data266, 84, 0 },	// B534: 2022035924433823188054937332388940414231368246000031572487127075647937222495239409244199173197317303835935709038932011277916762259303354595639372151520975991223219830408513701112796270986444021581902256560856252953496150104891955346324838387410848571031150278405824133869811569887447584150558933922498270240375681483793954573204045041260184253511784638007775539666301500346131129959877773535647108148757333765720976412285520327369929452298850887917377514115608147200819239121557185326211776689798789923768514243727556185500853168843483960336383958278590853351856133850118672384840316598185331921698656558788781123180230703458579441607101061715172422690996009146610551808977017032386714311317878120978407042589516503818496358013263651987713431663738193546421305435586518335365531551312509697969065357260851
	{ bern_num_data267, 84, 1 },	// B536: -15765905371031816991016168745985921399465223598953169464857737857167065352327697327892848826222444689835763985871829060261843423642779073760519271344765936992199892222732330969593488352729514888675684087463396334653356058140817941385320583123214358305279797745913780309211345103002802683684358327894348857436840475494249145132191715265518749110724432648585465791414764261715503653007585904095941848649857764097368186961136590573813312638808625873101145107303397935713485505108730968874984914732495519801963889006601334821370651061926648784332201054179719104091690089363328503566416438330985529437752445281733695496666751699226768372872862817335217209326347261257508684687769055003164001753794911071344684335674790233909371175753451937237660541847973151979396416384385140903041826399574392074661696204780295469
	{ bern_num_data268, 84, 0 },	// B538: 85781464384830033800920099278532694776644061602046561861142995062395560333187007345554287528952755692280440007882552551960617983412025978053063746377626274495673635040968852339965017845469947323739823480671130708176222573569115272742053285601451813179286295036391672278339952309963493610916241392781793698985242603977648035336901407983711948381010812821108540655257853670793689113889320794071185769613990963196939786051409222705953719573439801552921800394473384665942132331604172897450226514450972314368863956972483417626576497225768905672109194380395319341181314454846350462163205278848768966701430493969621667484760656073673206136810533272080293246296628728103939992505103216710887242716794845947895338292938878327936459830851647668380536703772173214394640845293602528467252571710530587103307343085568380559
	{ bern_num_data269, 87, 1 },	// B540: -12171351609243598146631088080985321595410760217930796403637441217548561659496768565425899392102260935071065297940048299063791797225962328790917181672783341224767509482269026218667327294712840945355622359123603940204695669253755345808151066406578718609964731286873393068504144451317925298631227284899392887131171548186226665413539605492197008355839131648537673126698226747732577116410021376468656522074560317117491683373719072710206033579095031803281234863070273013055696980678785319755776714505696596252672773784016581730948548106095646904438644744398006675783628732869093543033593688634341858070832257680608312802225649261445854510121988008553172137446540352097812849340552022425879982042563503883542339132103346721332386992885521224501387626282095562546007302026827084498790745776150005311172070377227975782150829619623449640152487
	{ bern_num_data270, 85, 0 },	// B542: 4697351496563216369039601858939210405967639931455080113827251539715361944797287867254319537407319373016498237760713177278138570077149070167902367956836589928342087041151605002319517032739690353307717343778169168769619302710532264830158504635954868694771269371923705243639709056775171899907914138831258799050991981949151825306116877382439062190694048877898292839219266288472502159976894454552287537220440747975368015433296336387787137255274324177031874937984422031370753423352915186194677698125745346293250902759939044729376293137493841789790497724102188023276079766026530587614295384652523815104830542054146237245318257844637027604811829663808515704854054530521893504888253347638251056606906027343148639914686242808741717596663708389523869389861859906049909520844299447669484168665761423650431175604890691800389004391
	{ bern_num_data271, 86, 1 },	// B544: -409290387023473775248835260647129861970758042011901661056499746406028216126982834198487752471014106649176794240098617857389400930953608525626221694384037343964702719118752298209027307440804070988372510063045266328653725489832706189871898791657973653618019014682959688096828231352596514169595826928309856981850745774527642819584555960181656273465218274925766212793449648123487204056899859517711924277445767485052015257453057444536683409436010085672496154332849462743365282782408311691807207406079597664739736590127610914003332863961309794445416405322682578414997085527992423560016915501437653580184395684332131354110550486864695196624049604532977996195803867969807522409772049040415367170563619717157493419819344585193889525287893198108048649416883437659718958760708562501685944958930128768621210729203638757125376903167632329
	{ bern_num_data272, 87, 0 },	// B546: 3445897643935893913355348265433237598244381836555397457114664070670570065842444132278675845822502311156590707729651745431607078436655000053783613246806340696462708184603211997532579401874331985028504487125885791951630947869078049772775507936289086452623560440969114255482191029257925644141053674409767972830103755850240488880000471525223715372269588662527663226499567896120074082843462853371803237694862153432052896648059217879499631409650070210023181374364219516303407227801699203863854712949245241932192252739776361798695356884210426876547321378550936587084858365908524483491218368643194686159330965367471963518620876023237685660731420986914118787203671863610512167776253057904949556261018857562980791634597691431979674537380808579719575775338659603426161646918585700163883740291345524983531838815070138776450866906420237295560119
	{ bern_num_data273, 87, 1 },	// B548: -10057721652543862907389496468574329907482184435101302015719486039156334756782622213411394638896047545208471597437358688322270250435446485993348183601688629696413203609360509115136881729592114766492884963564454326057145160963345836969078000700716483265641995485536911383365150791476009403046858133168450623098887441427375663030348914150853962507911136675756817597623849253244012376477389339020724309259621296518506009819517180413228489419137463219655376390995507318403823578598618301809556621008692289488206821586124887094994405674191903779855167061252872037642332161277840582214617596287061552028157366732169264079134601106360756818860832735080246025233720611664119846884174710459149216142286898946338153987252272413548517049105529078237919081828159991557972850907149623451558165674602459470229143931492203265278088277283294483001
	{ bern_num_data274, 87, 0 },	// B550: 3892471365521782032237640229737977423210491331582483417918691830705492817482205291331688098697693130365656264445918868404393380855153761082365922662676896349260370510305553464332524251529949058852243753324970742153759757627234479497611356830169910317539359240537252510885951806727940586466406302607695117040362098402246176941387978430926217191333509082326459632886940293345312704620928106155478829790174234644035375911018797150196509379481546511833986209578085251687992815210429328616524891407707389583570464832538553519488677308069721509456088943390720521769459319084663756060082471411724921499509907785187844900767221898700870783139695246837940304546076735508356082681608337922685251949305791840285956359511001159093513588278590410486730438415748604182413208038321853489746458643971788600052919596530988245088868714017818659968470075
	{ bern_num_data275, 88, 1 },	// B552: -97597719297712954419297065072476484857650613432550406209463790187576752054930212409307609378910541079190304643495954121999353772151261549948190393378660557118540484536692953548056923362073761926530937196186608073257991632349725226823248865884355977485743967024941439805795678137893624201567622026057726239663831253419458506817657710425103938784469702409754991214522748621180918527981799543971819965570183266204766346031779684819319620044149412521558990093233832972765056517676362698434056534469834873485585160042427007536530214733810647205890920571873320040086954443739958192451881490196299605517925544332501703902969279708025973968512765020128841136035735702319987171302081424963136852024771100787585869194001866466960279752691662854130060793691348367161180080171354594583561921113739576805669709547717448994546491959442145090731089412565670931
	{ bern_num_data276, 88, 0 },	// B554: 919837274385564027108565804168805091879316978599242889907304637320299689877933321046930079211451569937589987795952943086943729605812867340752730202735145642157546758460115114580238782460597691880138858556875841569424962824745542414759852566985562912734749045106643099685895960056459267158137629157553840131662199201100001363654265148800047409464167938369568934612206186111290512337982038182481478102520055673865423358394279934388121652755235623456785704645178321997100452371325527893907356067815190333955704851395804521190238279144814666423533134090014633209022724585156981635894351670764122832311070831774284690372533616445660310351023913044219520966996362909438553835176008798327143054692110041392886286623054663775742929101832318179516524224917879469521062407835632599593048476814887660233310505932812251166021252402118918189575083711727
	{ bern_num_data277, 88, 1 },	// B556: -20023695941767234604809302513321574301543637835426463870006382105766480730314902540436699796895722585664700684896640067283214487879223430747101566088611348587408410963954704064350857240706219686103219067078230585092154932814251612979457960796494940845849173878702149203851057439649964566504390475710852759682526940192491333472279476292082596230613334327194567271392405484411227828237736648563841730637001292391399823767835054767501899270965093286050599823810897127318257706601313386232400671377751827635601017102041865262675835738943383134098935878014171312186729805713920621846910524108297958126616434160643630363946618755382308119647886431848799752368662596666036311637284763098902480881460323176028237438713811390572624063256394458014194955847673780602728634247307733814803964928023113761478241998304666178648519679133216787444267139410390691157
	{ bern_num_data278, 89, 0 },	// B558: 7528359345681027935543704452601439108806116010971579155546963735121846679134656386034467199624718069773193074248332365443492388634099883691874248248650573484158539374152286510873717109457017765530920162137646377132081942627694826703210554990879482161225848507967806789349243235622622992904461924760331307969677544916118232924352815689928683724785891187411209002410967177686163542931630657629042028494282943793022262961021365670015638905391408837964320761185283154556786898685427157529839438621428815159779683670930289918942919219393799565172311794277536348678478759925141898541494168287693542580429897443762522971387181928928376996381872406361731549028579372946091582358850425250092379412508014132848646822440622423109222611038909394582062978015920036426213688667745956530676072788505332508965977288825720507482857057525319526472592451371566512425827
	{ bern_num_data279, 90, 1 },	// B560: -1124929680738236847117747381532243069487447091583275609127407522022609251832041378380296674168116340882307062154805164862612178672282933178669553705746307542641369365450303844494534673736682122513332793200548506624544471474550156512439762911471549552293845807469952625121106942021076713175043611884082977040496712493918883269034242034224749464214727800779825142403358037901244950631693416564335425448697215373065578844530439204641664414119937960394840839259257622170047901127720847932464305038796467864728562372851774734658837090725389767731427923431611886529941415676484770574398431195211011076760245327508756073074813762358720380438063596428888935229246926185566436604106588288890725770884980911628419275864002604647453129862254046174211701213966255417173046208936946027571690973978282698632376164533835301012074557384841145080245840719413599215535273112085963209
	{ bern_num_data280, 90, 0 },	// B562: 2018071889293022394361282043531516872200020780147997721449326447843842904458124040319694919242716222295517426679724669814538691590749901232583244642385817034419095143927135405483207166551310148556380441548480993429231827875779597109241531461096480372608261346356711780884982927464351227013360086816568147315130594534514181012948884108109809882432866806391272570120954240064724334279106538671271267173832304256774453898662615371583028109475995316393440092687970931792789467601898016640052578905633887887672260433861159119073311959941315374488839368919063704576570772368090899135090945217161370287372750105792417348267022697853200601861906623827376786465695040615645592193275436958161465819513005111313951739420415384906354618714137124553531268707699351832368222690263563846375126230505068426025553466479619157307634297607494981755990820870157027966119107700013
	{ bern_num_data281, 90, 1 },	// B564: -3712392036529339896593467620706397405463566881769230828501320214775153641069972242111175488407771229757162615957283751000026116892543574395472289900431546625853852526533456003970253274334282513920898877393154598857022957811153905355517668604748898101752145542322759254364743110289234568440928933457726960772535263733301648081660197474850441493887631957369820539802337071308312202792347672402835712401545724433667242130732155786180187165734730040620956398938321069965252398088018436381743699666864463859854670523675128930405404118784989476472955388253680572059292020783628646875203972598099038587160652988859496322386522131125640868286532668870455444800290722448283019237674875520067401094542223792521644174694476287031551568609998738672919059525293594649879068630329088226432394969792704394115490618170281123035361237178804315742084310922554805774430111785345928753
	{ bern_num_data282, 90, 0 },	// B566: 233539928281682397144228763604675584426582129698587509237197645477617193438672144538618049985987758635228852250818157089951549837534430955113719241445933642459216372141884653950874840134705722491469961456522529082617589693998456963620858352860292319843195908355357649433794531419937783240366595403310433292809004747435067892014584550340146491427319452853235899859188695839724373253041805566790600408363217985778616020469664637898510899443796669465717217483480222650770778341841593290683800814951952086740603773927067300292044562535918813620072914495855687855763602749814085749579255440589277654058253130612382298920013338007492132443803459376748400442157535565868044766616562196913015267903318435354647498759396772318730186233659165614126921527143666045718036703137967415196488844163292732143279078561708210776046862978305153880506024859310948059607952076902572023
	{ bern_num_data283, 91, 1 },	// B568: -5420196995365946774640701997278978744365318700353500622682320874737275118475797356922630682692024657642189427374680503940159866593826808827899421076683918894074358435120621944790551380744816358886528681747763190314171048576593498935865743178956221340311089096870037990493268354490316741575056756489263425273806502884623822103030428832277145947285386887711105864664418357765968634919674428358111535082281254486646020345617562489417873547977517317003717724709272547963267307405948622989618682959486175692599333707757217863475028966155900373583886833998058685439737238650988190920607579214486355002042867839236561324364054620211340397627488088968782514075371861562054069519219041701867911884946611808451519137788471075071578591960156987264728728258261312242315297992908616833578245242532478691860532764435298952070294349881920885031784858916215062993105693549715846551468569
	{ bern_num_data284, 92, 0 },	// B570: 4074572786264219143469192900120238996600461609211000034099325785851406081522788953499013400828072592995079481107428634032317095784370000296894194929746402375190904082980542664489576379498899257882769036855523373981679529964842242102536456913793572640484272412210045540055550174796566443364139558126435665024592713421108509220549369168561322031465073995868223774497250734750783195394931491397565813920639786998709940911175642154653041708488735827933671721701573803713446058025396584678999698380657866730526042017128396520101056449003761896274073326819242926158887048806638690142258048002755600510109871251004489693094895768745471902687029557677413130676192354344537372992147648846754200074366275668647927733154336727464674305848486918037912187072416391133128297410790963324410890318816445280592830609252122487635083134777856635683576335429819224942651690543385535103039143066710545
	{ bern_num_data285, 92, 1 },	// B572: -789234926341422253085971846760849325046100383265585519250468786674681319770916367671428214847821734817119018862819068165448127134317182065223048376744498149570148057578541140978457124114304769525095904212367848729923094706544671553165805558598990955086468233694684521490706410450323155090744193330337503423306486376258131340422966930381283826016011810540028978988154074090954172596523138592349259273954780646475583562010292304259002773876575918362503910582518210516650399494836383108209142575190189432617400291856116957069397001744021857153108110152256850258778559995897803168813836670635574443327627977826559039784936076799578534817018090612624254749218726416252610059803133273300885776633152898243253736549028208078154083083801169652868397914680405217619144573079796499062973485482374739964693028127993428997512429964797617732865536949004089947068698455896117876484325482410619
	{ bern_num_data286, 92, 0 },	// B574: 89540075468412134189489891054646961764433293381433185018855965376764053934681810272214021468365701068529763062961626523824745643651890632383826805341345789739052329519173554476817984645777641305887327592918199141981667687784031939924884607020106720834071471863939848587847345985612531289964539876176563398176389470552077333316129004423834167607451626213358144913636997028841266651605282410443523393661695499094464459666436113942321255604963280978838399727605774371359761153294762661100532052833403606276606527481327343046957098631324041978395767078894374539282761507432642022563047408490666373893586799262278082305362117875973867487722230965335658336883354480005772596155718228414308260674281212818393496182823453456510538649433910057977507436815609382466186078710719659208244219747909435046508593501036891743215423389474938432691397219367483487451627154833791551148136734990093221
	{ bern_num_data287, 94, 1 },	// B576: -38807289881532469022078038805443936994330523214318196735637683263662583940392605557282712533282516756666919539426266422557684134014238407199317916915480727656244111995712685835047924808932860056093375623731999779267212410249827044330151392935511662971534087898484760737220746917126027575902708937602628325122514356595433782966605998317885889559051990233360748106207368435373718345187380951970082615325480069222905346178961860766621215940324196970733329049528965752060174318363840549774016678339354995241220862439538209659705474784926366311930153972076044017076505163570729397562384645930326761213832040478500582877417304825409742138224911986943065886130599606602783960854405787504142823460840304226632283722460423002359183104394885957530215032230648576752112045075407602245021860265575873377614298930845430388239374813274723340683819295169402934423419832790566792561775366448094077182269546990219181
	{ bern_num_data288, 93, 0 },	// B578: 76456404374547568962535823340522068834644927640173049161417691836626944910285272012832647014104895847683424165459557887917510763903366385684671407581904954786069129625322396390646877295244064962122242792898611677889163993524286946352135604681198729353357654956994487225972629658339684006741272675346675730141290537850822364563920876030528447783608097817034367033425595795892296566731849597807670929984190248648882874081322363379640459580537900987473062332968938910633461966244631407435385222853866708978110089187501755408664595498468797040255821984595866374388997462146265638138510910046951750618130949533004155623095222889700213811819286015587220588578210729985578585680643897799494466478810612789264101163035931142901836938424340175361229368877523737196011486173494844721915045304308211738941673293736821856828921594991830628771752738827711079972763638351163810308806638474895438775679
	{ bern_num_data289, 93, 1 },	// B580: -2110451575512625858198809958449596679764906814836057034201418876024678595827268376847982574304626867924619943754416042327501145793867448891494589946080335096859258590566432652497634866444744653395610521435021783823771823630877556239081465337445258686102513818089249112213562276178873221433766018290437431153495805376010550920942027074022973404589112810377874054716669637655819085361612949692003472194741837434862090082705306905786555733808375526286767715784901034377285291592360302359469342626554313010656660884837917661107438575000776433351536932602316179559078216457496561464001154693106642600705304537664909396942078343281617538536954296877999384753112173226709888836191580962116408808247838381821597844616234512289372921879806438846148097792143102246372711739103155918170228201670588825014421827377310189221825133629685161643828280989839367141402025366326559349026535835606329956118300218049
	{ bern_num_data290, 93, 0 },	// B582: 38994029049050579414561575498649314660388540383814676149709695556880566175281245690907958060292652045838309050922476115105581355279751414021086954995038922380340882822110432918349101529369228894005153720887757613082076653750177570969209671111416315124387760048427991590687566540690274347687681235719206243942734998322615946503588853855131902104935240217969507893968136148929220138712160754574536522273550331964615156035124161625023704302555833647574506294493044992273847998893188378952258398599134242445365426587184929022140301451954971887685473007343614094671964390445653577442908305926788885376566383345069043450620573225168488091803631840922726929941315842032340871615324970582129839115610660088821212928733646700828366940593072244372892975839970835561813548016375073826259977750501231362985377274965534955340772336359889003534025005789545973984457862405194971461669153950462276063814122913377
	{ bern_num_data291, 94, 1 },	// B584: -70381636494801248843782868551007693130071864397663503612736573300057649805227115208487798860177317543991711699013824079350141481989208700654482628186525482301693762923475687436746934487679442604567273558972710870926712476340755886255695145701498933070613274828010375037689169698418638755085393057209893090180940002106642281967181274643082018489174577379964810939263017948442637865098737422732303450562498842294533723770681855664872930984691688877586325164125496507328911752141952281014351303126666676752084871168578975483173623537565814659388711588339118843954939993745321157296252168036543285913523638973791012374476110668822738731559371466121747880865702181425181053904030331288871719554804130482349233578225832626355274548151858594000669528450379250715504443806380633455433896690293886145388700714248326563884355058277505564176009284158858662301917854894988101924728004191978596080362551169917696293
	{ bern_num_data292, 94, 0 },	// B586: 244880150023689417851569872635647637024597274141996121710500373483959778134465362888553147153601305230433519724259816948413513752427863659546445392963997483728601960673580722140004104162696031048697888717780655734372514592831917140699091334720766054643485626137741080947808019349119679929259647219272744758193793203013470832331404795691778911098027429848059753960123828595665578844950471219605576709611351664945220428806982887233408034985515902644135911076403828980912577191158064997993558578409561692457674428234975483009425498206467167158855848979568274132531324674903579184081822660487117401274955208037679340313607197474741162846378770767738913689498041311406420585511042745916848724220308908834930585593486456056200660041139918156370312109455496111843132879388573015533681857897436289296726890667031941311177162515265667487866831307936241470906027060817819461200182415421609257484954079225869807742021
	{ bern_num_data293, 95, 1 },	// B588: -407676096824069796402509817445917748634821745414963766161974576002090849358593663694401003605297202558666159323985995344127987467925073708460859785988617048783598856991424455561132216187944669065351773070321496412513906145790161772321166337598493313515362017732061990635349221932925232524265751114732030907754602807278109829510670083818397163311811043450379402326864754800400102998198678941422063650040082323201192061858562707678730174179400893792423564941189975455333880317486656751099841626289274368620995257302745427909303699422618702544315817214418682819984913760647495771206837826007009425045326941885502491349056017139096139227743899135412114326071511372975767026262087914975597005083384362747226997194225101069840059178213278932977678378461658235484684301039576813869123872576976359981667236651770400446757157843634652630326592012051723663958894282115257161339112601024773890615175207513447796813539857023969
	{ bern_num_data294, 95, 0 },	// B590: 353159933920923640148308058830731815633794363002599330815821655526863571316927710458029528268025536923713623477804946105123346797437149076276998814013435640126610340215264971119171698230336386230702822699227009108343756952768538458052170606383900471822908498298935853901909134352067918414327461675541262948939556957236257017619479099887927014779975804399420113729878704191899089806218149131127575967980609799526558521625857882820227597394733588337521052981494327670901555944977865409532187152816271762447903437167518973778441314097036483500517706661267209009136757154286811787375307633094483921764494031155363467015088967418678339573264369181939976786960649883444407237223030117614509477198016280927905141481098788916645591499598227031580540242709473972797097467008740366860616044501709246125167829963123354958870223546654752556304460518996788597023301189557869390542915167479645785033684717770396284623069988045
	{ bern_num_data295, 96, 1 },	// B592: -2136919096349081027269835409593640948156705654619128018845340472501002151125272833749804451874670140263700532460602637946999778065501079225176805688108626474250191983130652519314238680590139958513297878999805282504335767206037465459929078716734107847287470817213852122705966018728599895473334600619095403265757155389358813893215675682950446749265635450247341884653458104366032083633998345831764834719931106876932563616288890070367814429760290631112296874698725318567732700759148099405850225715566863515772259332104691204637497105033010635875342567101836945078885603796131898146860585007714286826786310997742577919535972555292633819900525377509956992152709256134537552568594093828279984095346840431894013067288425338191473378553325710038971646234539139804240036524342625724277086736354119986204437406602288330851417663906420839409329624463622982338734450720625176025003513159877146112604070531738592778847586396893846054469
	{ bern_num_data296, 97, 0 },	// B594: 103542095569540287363449206089017325853194627680282163948800616086890629518794422724881285683203655626550847419760695463389526152512158437330672247729901557178972045169826440757428827743249851212088971218823605220239284974222739031107871724766258393227003107694055957732789506340748065412389013087542761113817091641305068574175570965574213584518977258539902792488524648828199894745454936313586385963381306653252872757652514041564663529579951497930737198856221253042937962941430529245932400748710504685184566985952107355347191655865459932325895793107743154974461795605062061778394664346272538231518044594509514317304185995912817413765060138987167917307865624256520821328191058364108789514202746008506152556581708309638123317064669174333637774930214111313309238438267484977861547600652580507094335988595794086904391313442717139088783869103752036163778572391136913759464596087307133820205711460281773406037410619696151281644860209
	{ bern_num_data297, 96, 1 },	// B596: -114020538384834865558282298730806944768408442602816245434773803952680564631047883262979673350022204254537018428680165192325286149373243573308326887767011429136922699778153104912665990053003674118991799280580350701640487583643638783946304250561839315889963979908939398102250041851491409233685646851041837081176306268576753102930670765071518505708028059236757351308466715782860670858176347736163833076475299516147707682413410857778655167734848051940692432857997453272102470141991443557575732644893165096896091431501008033211766423373049955341440928448411526626334445244777866403156652942097088267833682099613567312108229756403922347027491212802596755665595237180265285928118673111348415230669476263294022534789227843412894759269519250184333303805308885339569268714947057393469717481152044911214599756160059850497327916154573828564863836369001293047159176149730576324834372628587274522655932579445271289490178906196047725435801
	{ bern_num_data298, 97, 0 },	// B598: 5805685978238098325781247413523980462537384691573103008809238300906770988295022177356554273842865414629597617175777742691375357883482819450016239297860120685236679970562437370860708848111710663531771962490121436603208140855247262533308555403407798072976267636744498840908673663925786296540751686660717727222504469101373902186807589263009047502893333529985153632269955023928620469648554453328749750137113039741521649473655820610170762322085207911187423452817488933910963217010305838200800119802446551213543140068760539191710503515598861007305722166740367980326428103422134679605003596624175375613715637869637083145243965611785741515184675332201055159650525425258176361690514577479754366117945684976186813766290752041313218042055724298246812912756748566249262763055175786885601490703095003598287672296888646452640653906823448218827076169957052961271604417650602140540880442522168191806419996178244599870658105137244235781656230669567
	{ bern_num_data299, 99, 1 },	// B600: -6677278000090700162426567032369445125412028400412787787480158880869319723275254255676783833678110639430866412715003092438412243084604778771890765852030273472700694210753450091363335146488610966218665541073167004212841403698183395541652966155020109204536523126310128491053250082490497485386820461691863475915039362964348935797517302336694692752183971511940716801155446425158334394277492558257902209230645134515942981491420477975047306660064065674425820601047536594927442936735491657795571854797561972626698082037907816525986506582113246520697899133633318275535079819427279511592096113079709432368401513891953302925715503102789458643803201575971792058177730486368527635740538218368145043451850180862521919343987372595332043940003681328048958224554578150364934711077323958081238169329080806130058125680847459636923988181306273980276628643595656744328295718679762913882680874320054542543100963283569438153746943360158805353625486236702376603433408481
	{ bern_num_data300, 97, 0 },	// B602: 17205148443463342902987981572627518879431756395561334286675303134134403304167915210894055258717922971225099483143828084671128433713291472050261087412514743606863809215996612335853256029588473443467119442118020948353318635265232977946045091101692241250622468090060959164935200817628834373604573534203953055965378997477468887353844449210057635374824257325425636162817138963230371191273654520624541864674318602700043415046715330008568214702545711741437884393218046241977553283021553831531959794988586820183775028201887688022172205156376904648458694515828347318127770318556191738051570282370519283399036057549291984586750671013679114232308734747419643035755788385070203020911770408082846435552543286799673886679761548075808620717543991525944037856871035835257908141281180599983576868965002273003332219933505021357086179144373534978708437786465082483806003091671813208223498301612113167541084043364784592073671754333469816689928263722694671
	{ bern_num_data301, 98, 1 },	// B604: -793638892481727174288930366134852917782480957671493505462348404631698112405049176965385529082133844008811169124999973475621432513709114554247202591440557037100692788717076421591159246284938242024665734501915857590616687801922267231972180807715194769272005928233785276416690800610614418567158255189478887423741208267694211616358898703905805409987509987260011316118333948616854026522454382514590140097213891092345517078329321576175456363286878498910197499605429851328698099329323268339731182458811162655220645516711407623375185757780390882136504063219184900393178525263574646675342238435654836654451545551390514675107406117552815715057824313438071149723111271035852801314523799152053928027163692348157675357702908415401643806180150161512825724526401345884773252381819345787655636933124042361624704989017984768118406043585888235184867135410203754161553797956557667988562257881562724742318575671607041945898348726589393236807818986577030633001
	{ bern_num_data302, 99, 0 },	// B606: 6263368030365709437885141245762735285880599156693031165843900116186253886410623564713327372542017573018960843263434101834884406259941593830978012116476356695083986455242807730435967602199014325340617810943716870241916844667314067301644692415867549165188591391438304332313722677844738462847069228225153886134472744187500781028959335912768295897724681768780620853679717727122240025759618264551032225176651302630389028462766538484260802826070404354173326301932081472281509607740129402206190003314502262945435881600379115309002179990444120256316118216502957102177940982224003278870860229205078690771182307952726892728419410433265559812375020018175363733777002859708558792075016396824209232749234262085789665252554994226079502717979416675376344138604243679791437685213052873232161175518023661439937948251552800182235313292605948617382695636830497728219217347697242054108154809330396206889395612376259673152960991959269629619021606645776233307951361807
	{ bern_num_data303, 99, 1 },	// B608: -1171312180360152932983499434137960383971139213340640612106645703562733251286341222738931318430837725745504261010954813108345304408210519953916331832572041584527944478594823761896537659326491973238496187466665265153236373929003115910039697867903126360322260425380289674432297860069320590504686073279271064212196161020863967924074764403294084186583806091848445332835840481786534601637802502385876846147380022642399569738851393186502042395714434685446344243839777304613426754099933561614958346266817311923616456644797386729512555407044438657337247114772325547780811498623132801577387939685256061495178659596886864830503611977891037816869030731015465709309920739683548358971223590929656253969844762351705366451513347744582115208215112208346679633252560716871755528926113433571932591185211591255306101055233563694753677735585558909755258526727037367206725653774413198450342364312406018408081050712427244575773339984855108026838255627804349953264705390017
	{ bern_num_data304, 99, 0 },	// B610: 1426375300481863555372020180564686599861587775897848785954785248006589698367050425488151734090776148263721513223728612275147488175392544229971781732929100979268608865692479265080123205141488293148197467102819291901672605288641666809229438694060008002063704908914901643483024273056638307503420849694051220167640255627508298610724390546597124747537034546487221066377223224401935129539884526637116257572538749926519583052464925767410969710473281644910100632447341074339947307808760630924142607915957155618408137487231937552945210335493302062300598893054740136493496227147274452332578144640034552250322639420637627996658235695351320585673428717991303494104499757338180564924364897030095852656128175509438223110534423409872748092036687048920251685140425028129558865004271823591811715906473562354813643147364625240411429645397777448525437650686626513453752519689330742970628918165862401911075901684396694473248756523229948167731709512204628061529006713882805
	{ bern_num_data305, 101, 1 },	// B612: -7615121146152685586160505216828269551004522063296549507511009569548267873964356891093826728695188026801661347005322781156076480035612121704334369114930559312223678788355267473281916141546753390848274728889451652928002065780518123302220050649533509420210916970210545478056042818477919493620047891862109264538720857863380288433596634408987668296220326627069546032520885328876704287674464114885623347889009992441795644083689834344697727345991915595621888320634577725280205717399381911900460182908377805346037708153316740058391303905509527169432277490384000542912381551721407650566650329055016018680854198882015917138135597913188826532535314634304658843067541510358518214807982512170021274726800910609818278476700761655965102538907524393489336257811251536015041507298292825222789093341951342561290924199280518686161456923289996629804740076955465769835463915860816107255535659554560129984912300101557848956550248650209034847342161163598594188811658448580549184534311774229
	{ bern_num_data306, 100, 0 },	// B614: 11709628836254887696276417404796822201660345763194368734116532442405343792849054264381201360625201210137318757118737329841540122057656898430034047214530548654065080676553781348747664555474365550897699908730273772475373145824641720863164224719085163784261204071384254588748914114657717507937437447673926947986840846507933352372540038947762727436074569124492725589072088747809489404169692380301541758923233743909307189996662284280683428625740294798628480149209875388455049871685048873695697634626610263487138742942245433351914338691353757787033087606182846297626448818089388613827237235805954509847457769794296922778593849860207592473539511460346934859797509116348648841484361907412176700293837572950811630242789740282427469106079847565956013255129835641046343100825630939463913372589466084509909346852965360735200481310958449647756431993258551920418880706743209633461975734297525641197636386631881692971993482096648796722151228847781758015846103497741141910807
	{ bern_num_data307, 101, 1 },	// B616: -20578334836160473869042016406407373156413002907256309367401505590495838421156891891986636904554537207720145131123495401875897544830661157001533021834793096373249318781293253306982602000261670660172538313099210446833389965746136394508162418471559220536715495823791472328525007271950462126548067528493989327754260227316646110866053689559608528211254657606056346991805732380052705651413486863163735281369039832991456542076838975210713009970149814769422699209831875883640043537041408526037084965996882352330058635447129039031097121666640674471757734181109121959916025315015774548756767517535530506586480685757350363708379453705331844967110773410773433000428091540346199658304297113527297663690010800288658870636520680004235977291454802351415345559749509639442558942039330969566829798303702644222193459665302109264069345444222077066105821883635644769548958552997158703980914905066021302203214447147645760692172870655963224387620345904815253445003325920343402935167301627223771
	{ bern_num_data308, 101, 0 },	// B618: 4702640848968349212535790659414962552600894858662700143036282870294965360926214848337787266798698853299470263001034189879900805074114624292206144502221943678460236576932688846887986419087355361211719668688610262321932370198171934733371882380089236624327512374633670331031937181531783019713049044864577566470012281621782990383369236573427382849268281435988618039499576867235254838849898615640707862860549918568326594218012730758270494177955446398912596944041637217484845057145929781990250987300456404581944177368995544530827479178038683434286126913543096548898189551525932506191399790618374117857301190284650485348218502879725283382809282401477323744044052989719837439870951541846644053353813511864558513028726230160963753579570126875270511326073848349245051452508046328205066639470501074269980568818149402800663423930962752189171562160064591344332582388300046151926029021215141641674855051021715873648145687854493294297197000712083845396306506493173071134788241426384067
	{ bern_num_data309, 102, 1 },	// B620: -180467417366399984623173006427811276936371955887355025325471441485900767756072559013609085466678696346336410349349550324340212323840821189709757518901784202506515367536273232513290582242415206538006898614116856393600099548700749480811858063651955315325307277965877118489089243861749232252704875408616016210610463840985419165891699079978090815754589170286606052124701442537213776008934585972651678671039352989860401838986008635757318213913899636068737752594128308666165968294842374205204658773319436791552604249203974466275547509611549694274346881255110190190913739666044960421922456575351749272432578621541155507105480891927547071525391051880785736532405511438002431293593634043742020817422837231156832149886713363081883109338207589927285144818931783316430373656938679768203403121987969631940589538801097367876585536642393773860707496056923388402314497125312695528946250421925813973598909660007138939396105817409464038349153218306017705037945797086438347603501060743849894021
	{ bern_num_data310, 102, 0 },	// B622: 103228109281171688825222174805257685458800311187444099552027068690944594949751058179546518147343327263041074268784793207596513816462044079574758046261865288077341830864416204984716814247932789228242942959167143059870360659576494229105147537846318527968725802880438916750977796977510551541840803820900357405504935693047802941338462515258911573199625239146117741347617118291438598275718505202181070366255162712677560957764117938304657210602568925328715594762076689308621893408709584926793313843441979488332572631860211560492035901549274810135804045471711079501865763419735351533892968354896130368848451449068354765998271507598651288244256069751346810309850324699863862715701799638402612962607095526383389972623017272019050629344684661347473323575484369164585097368784575436409808233764079390613711965725014930723279596008245177563821033252598848912999662866110409297991721092202175089999043106185709520344742701372871418458178932549504666834028054459934082300379976579131983431
	{ bern_num_data311, 103, 1 },	// B624: -1617775080366934067568827631898405139389457145546229679075945801820482658467762538007950877768619564697041952846064555799844423321744219111648265172961991600027265828413965700759368678915610892498309466666625952156291146935129693767585849476060867204726032995369974531572725294947243744551879851431250524165868318950504347932214561358961987816339130237333146762243086103193663144936856789648328482499574541113505992166549382079545849438440659762024416882380557319849421723318598950749587105690769595734551013125524488911492462109408327408029314569390672622704961436403784520828795784389696160660303435295935285940074171894390761497276916420356801499413273131377024619599953365838532592738275983792196076619397242558281421528940606582482369426266617624672984836953818968845467092280304493669165237368667262148017013830499781510094265505311041876305543105493020204076556142636605134220846405911803901534510370402091518575961021238113069974455061153121644383050217476067429142151963555820324749
	{ bern_num_data312, 102, 0 },	// B626: 10074082111507103223698817713708783216975903914869650812398627005176310785783681171379277573675210902514508702885907251669464215904274158738197336390112326035402058464688634200037916023789627691726701146623567829493308151708923708816480061970878980559523600545682825171366466659482112552129974234098623231515786394728777225900378570730096055920225265419393813879662183938945503432652028475745132132932832754245944708325744610960205777245707643367566390956205034730919466077130144559488232425738414091952790682425947143837401873715507568717923553758259379319019587126695085757981872684008094819500396680655924938490988250605138646659599197349545980277479483961086584247636459837397449766963570755469550491451827363689836435944492434787234385886035746352038294437940291690522406192632955935111050165161616258361893121964538807423295231482256036278890595137537207380050573623911448987849908443718659629593176211548694828480351409206943207216872123478813902123811799315263512456426271903
	{ bern_num_data313, 103, 1 },	// B628: -502392258429927883880743252192324483699124428647074485354516742055977953209736465902030154899396073440247607887201911017564110553061149788477899202878162032407555290509113889627298825056249476026127650629519150600936031582122915255546872199278098647934906948268686975283726214707058806061661576434565922139071864647982266550324837792450865053227353692191566657670038420567879620542311345590522241048099084228168243153368015963284084009373621539322654494553245011673458403385062655871143667811497036441213543139944457328459151942342812965044071575546797834455586505238499630947451451923470680140523046088169105507520209195845757939857677480550889542757383126494367817381551728222474438598582967797754659315315762466278795544592072541800736521312712784635356374347017730121042091925790180835705435763418567722323153793154226057616385921577373615628796120482957324018883516636949008291152390768465189050220018653385341633808839036123622525012333633729057613211527540982055574869016646679001
	{ bern_num_data314, 105, 0 },	// B630: 2361308618050159035852714602638224189623147590131542018509894407338568678755105484622041843966022329564083444156666301321468080871748591067344362376963536927183678141736680080966333411301138034152197243891202890569724913343510387212742006708329684580192809284123462945023975851495601784235942034175090826352129880275053683504430513907625492176002037714789004621342338008403056792312682503955737485641851774607005467089251439275632431035496174068683699902576199730219815247417179824023890556199414759159319688088237955690503410641038479004384865028326202453298127439418883851228581762522638568893030567068436660949107633736148225715787308546695551793052314502670368238267106755355486612943527993127535642483253831753765649341865403071077646443757014662108398283927891024841155976434003982238957693119104977165466801638072601962854387883995991175690433606381754218245608539813273758583220371274930358449682091518825121402206654690171161234381002988834393456182932796532053383883208846685510852704790686898145
	{ bern_num_data315, 104, 1 },	// B632: -16148060199111996087213909834765557872999624269047266627000153041502917078500388524997561703784136835979218592432014949038664600738755341564832321928348994793049385519241254806436820649636975822625079755219301240596739448758812366719163397407496880611107616036015485927830370592369873415739984656349351902365775188120179815588032836898328036170519238989614869007602746218338080680532521222894168256572274976576828732549832671035591786379363577623380324586745585139762317274564549194843491628021787195964207622705268210652505268136316763808076221546055785319516240391141344595716021499521894710730753376737241795683397375350343816796051511275743391237457358201451935886787496436896023907529045768677243163351131604368703561214733210656224706781568060893554665227202715981510672265590438963445720493361131339871865012885870743224376614171800125955538020944404490579015109233322792255169691576277266616569527384808168027179745795949665413350014668090439047997838810086436037421436525251620139596191517
	{ bern_num_data316, 104, 0 },	// B634: 103567698264680901251032958895806906917978143770984571499590763435926139516032703196676307713410005747756010864664874919021057850403984427364298868537514719164114566920401677617781356578869020588649689755584823555649278280036780754030304864493027030783191416160437510805986713960883277142920852377778641300851231159884100064191287884324580034818244107147708524479765744203673218935309991907568584485759296657933368664206916230335555482215225097514614585175530937140733003406901531341151899494467265487222062699395901663728455819869487319443329669198715331593520066972448843071830556569039452620906676083234020650432300978530969471774189295067885604830984185189464104621615300026583757323919623281063594728672392979440526822360809712754023823125981670311553213188128600761573946190189594640133279475608056774517180559318988141828243592445437767141857365851548310098200099650131802484067657977230216126679901684541580729372818975733272394260095030193545740348230140957322057593946217816130729191849167
	{ bern_num_data317, 105, 1 },	// B636: -51581100410344114854124812660564279098785288102369227854807839463039348777381734503957368677557001399129650249928426827311653045000569732135517075615711763481921657685941674400780755575020656412334594505985909876230419143972689273318328299802432698290735044228510863584750250307015530863173436774044135849531717378220981047987219322049818614806049107618374684178262159593190939434266754538340235661547649329090891056166054710173930877127148872687153525718591570008673247810901176827514408609797338067260452099507500917848154119353970162668071646924774126405724891163811425988594811111131942247205466515305101314303362581181514088659202041374737101499946729783274192651839336103415840961252710660593844941470498283866460802738517214372787228194560792143377253658619560387780506001585927335818518905626511063485065050583866256566973399022707930880540341343882932845529226271461641554694564989111557628494357378863259827810831458093933719754341293466045482517386651738366605408142871586999695048885762467964337
	{ bern_num_data318, 105, 0 },	// B638: 14800474895878659009090162435920805352340071033997879676555697422815019236676981398456534922220060119942626699198746049006282303320622090004465530005135561328185835171635103952934990880768785537832314366803208348605231324693187862281750582478438858118635446861071599695365676358119242414293748179005594324091219565556895005708483544176573177217000531607240184769258886727782808889581414789681601621490357505909344848379787479850347190748416054524132343658141046906884375877966915479645788911794989886264311289566067381456590954308876097487941754999498435982313310770987685865166584668318704603053363456510986675859263587068633619877417459947309901035032349776057978079879080397221252183176711563035213207481324760002141950672737512754302046397519386064705385261257809594112462329135832876443953913709818604941573004154738063293138261283652025548120779833300352701160958244119131205014383433848620561612289804248949379347721099777620596662173855670650015679182679955401357817171987892511471121453331593042703163
	{ bern_num_data319, 106, 1 },	// B640: -2776325586192800438440427572181521722153037251600742436900956444107136540889428545579317024347431741832846054826043964247281595128516094640933770490179380281243692757894794523333558171464569201009771922816268811686998098929912522594638819735645848867623014739481321038047573572967172622357104877031106401278831847924501335810542671719404305559978457663987565862834717517347141604563817942505625977807392390314982100379049566545195075376856213727581533923397354714422659133654285503951987119537447641516023761004353101530324848324751383933778770260195316744275301683651099242448629600702502076561349667246748851246327827568370058401988766212247976767902763277926129366253485710171425310620070664258210919557669756845446675856983147981898722873723516001943581081175193962288198416601717162822407162226136923328250740153649398351596781385906644005348843937324486976979740230398712646335438357529010584336117908389822821798030739894127361165858339887395051967469427922342875248075110303738995158302710301801226037980519747
	{ bern_num_data320, 106, 0 },	// B642: 5301017429849861016755965012811272305171846536147487312866041100789134530612343247281414886873872391473363102352615991326441608868844535365312783812703851137404527427147663106697436957414283356635151427876642887895939798391368359643183822533599636351630132886469555908634330942599931259351388606688461145639007218286596373219179141873364584257177275217108559072005190375394950093144931675701288808560741736115157286147560471616199466800887307563349193380680225663741410353488593747494930623369452568496643030274963124920972394135114063931014212517819535756278061298114366654466998427728318500470018718559393256092914728329342308704322826971266211946484285333998390821842072186983524181115350138091773466032994655757905151967156294349990426209913190567366576089578646258728268011375729177011888851423237909033919280928647069684156440488135717885410834357162192615690195115869025628550031745795614209937665745732462109134749118372206581277793978211655159203268475654831070942910883960641571944306711947793551972377827691
	{ bern_num_data321, 107, 1 },	// B644: -84188579731737262957896367998265036596672660715132507820640822466505551201996814571686824027736640608617683971144564747597489714332568352425244362999555815004346503169557323150319394981970946961133255083401644524094030771309456325355315023355387585765869856135097330803267550554361369125655176989178125922372948677817552846048197148198807618599425915000632773386829159616284225521816636381135661871031103937353995084274890161211973343868283198204724584972494527372944682165744969256858358682625153452259111949983390810257399853062287408068671347964872520338384563767450709942574517062658856993144018308687486756908390896323704502181668606813730927322950167959896175829436052675349607951585841373832502127789725441793848019698243893322282730208669814850257546766900793246864181106395135094448801309485526033466771962508917215413180535752704453251880373643349482782174658478460831663883781667253284363789783228126946494755490645142723263931062507671757713283372753170993274507626706539536318290428850964984662300935071826363
	{ bern_num_data322, 107, 0 },	// B646: 84357577464183249246230745561665740261674772459820431820684647300937282622407569966122250263623141875961118370814475404106841228970212748341986588104081984900808951198131613961127263021911445568047314477086326480347471317992057136692569864523239677933070633208717329948227865988364953331134082436424523098721332418267952490571736754744716293316788777640132963394394255507048423727919565279552164489573396785013834888025686601195178550418643191361188618959541080394848542910933233251941269598636938536215414536627523008941471320506576897428090286522476065031213105945321422781609591354329336220871486536888977907353639729681900278174669808775301249181871902284332421986524016465913185271150313922811867849732973341701003546405092885560245368764069230529370150921423345377677528167674222298018995512537817727086547503202047394322107524578685403131096022399093097725259699612063945018167290781769906540288393324783315037232487719636858329414376362511097229218217035679325690184375098494617593636331614033489190181924033710539361
	{ bern_num_data323, 108, 1 },	// B648: -574437856145659945473013137192508638693046024644461800786803223145440131234385842121309578405935197436064274091574765689322675796133949134806496212200496397237993328693990851182172030180316276457260553036283123495530918617975043391229483265205845606870219724413712244819471888884231673373966410696567042410891691897497435490826909339623878275867635801407224984473895501018878664719420248056029832148913332573652401642930121382589703068397519797063990710914400229786647022789332485338037873251953767053352864678948830339260488323270898188324741118073390756016544037660512703321286062047251778448976393752365149849713449129416643274026392355159022921987217494105967941325472628211441053641255221151931712449635934475511744663747808378801826401859038423484022290336382118861542173579598810031396663415577592129706170190964551090975177773153295272535085893436810335964740318372437324477563217759470008873363045922825396047935131647277210521340366396836213121224409085303763501083942922956116547240021178659808103385770903606876126128955109243
	{ bern_num_data324, 108, 0 },	// B650: 21320710151639306352799505110961406558871463203237530574129708738094727918560722116774761266543276598540972453171997720098774338943242755318626415650445450946029830936312996120593372698965637374978014629304181306712451909036265964893474920292512462807140564948889398436447783423233087426031999190140866470387054934226991550692438037221412949774489062876078893844502448544484975726148585179074947510340604397836910458953594746975114157212282456190928915129482448818026533165328940895514234510867945745017301260487397838955910056614117501891287964610223841512468926817301635013798345378259078511782242979841450842099497594910631208732782387787550824307845707823565591173151485514493061459216585409844052544140803272312472881680973530641457035669596773671758767878800330924677380980129970602165356188774639923012470884644039276900260144547878817429434101340818399649654470383156216859047648355437196078584285966321688301772141571372294541118840274825650646083318335922093073947560966253869768067925071230610881316359069330825171166962575
	{ bern_num_data325, 108, 1 },	// B652: -519385377400510417297449890307406779825406239888433781731530037975658609917131080595184311783459012680270541027939995345150053930651426429432859403296305744157699335869258871003588367476867001350384200265081923941980530787691551184958914370140932568815265309584801775538842604542793254486227268617503627542111675197908933566860717255477571230498413666967489029047428885591388485631413296826465014410190418908191659919583226300359268164895518482942234476269961103043515263496651967976623038325045495264726179300686749380940130351077734786916230191488503718976414893220309796026308811170730244211874745542460083200941427373188486791922281358252260332834620831064981693849672760943738416166512662935072871124074837661871505414537125274672201365791599064483296239946747292520012852252018351579952140186182603594200161113214556788728699864157684505475283373113844615543727417923380658579120154963715868463870385350420815465935608650463873459842450501943393631544214425828302198918390223541157009388616369943736142693711210727842634373949582453
	{ bern_num_data326, 108, 0 },	// B654: 12045803261765449779871365753098906759972738690006160440708783195123690196426176790922157505853739803290343722691245368219016095862418935478627713488903547092856360115743878726509322957042630943256537453596966114469363436585789337913347595575970476903255838722815859445621316170870716426890350105391695062941370642214963133587747318342209051681405038252726532558577411381450786802218486683661355411875544377501375555837344479720669074963313957858176346400666388260803515748150075724050287571112755524419072656577751638558720448257413344804828516718944969578847503701114130508895719694177433176770193952058441075917909495805489338396407809639002283652932872505806226570645148081208682549403134813164955726655652990907636022605266099957804071791618674174220595798574577108443151853481220606673291112539830650693271154222457913300593839908286540137862253476266090054447944142327806061443190270105224334452115505154779016900870418616874448906014334011084984251728688640382965339233506655753377958381624465129789149569697246238356712453794064689
	{ bern_num_data327, 109, 1 },	// B656: -132135692923085674896248924730965676790198305787168678972647906642616836115797589919510956843728196478009299734541923178338291984398776701186778343249693195922565052228173007289377100873160357624631101278310987182508639915862032661960815227308837636008374343183747684666491443438458129626278161542466151612778314327108998260477847003119286671864482498377027281811014060246197719458239287398087734385897419511453683693397141944020458615422803173554658995129736578773401702028650914470443289290283463859744866713617431928301734885898655454059129289173709243361285330286073802085222617228496986242174860406821639085943701391360671433146080748820752564284780842375998966299389965991607813128040202291591300277269304375467546236426042226643570088868794573575323007298424098801435026202713018638751754295439822364629971511871606836434139213982353850776992804721496827877765132339834046389061589649634875230031365747447333268293276606681159878463485693646288764132661511766694018880183064901989163806365895154187433177444676186022213393191149330092940211
	{ bern_num_data328, 109, 0 },	// B658: 135157474916999209244631341056946345828717019511151896321270499095964571244245925552131781210313706520111842560257740825002176046827949512945311740431518445703739997178129553389802800024326612523132348607597567149344707146116684451851941074446922595504392027616858410128369259461460775775610667069098860532002691150875105387210120203548514816549979524536436601708148301552218247591116898682487588830922645919063350960878628925189101483908202455349271884127398725939486426187310291143154904076506900187861768215446227866362660111954732931900248886919245982368532438163142089358083436173802051207913056471575363496511138975877467712063477883205139194395830091184585809323144100587291252611139131373325113496264776163714356101882665315470748516716519664458416515305484893884746823936483491444554282043703097925131839937678795633659906378100694767034917340143812805848113600781455197394238181703360202745272761873304613979003103679378902694201089764656989740865441940441827449934976456077799974879543968309776577910836136404751094293679127991293297268621
	{ bern_num_data329, 111, 1 },	// B660: -7210277355747349053115932725350522631709137055506753274837574033990326495982550371647056285996359889855369986485062368626438337422691139773734455437255048805888955818806241928193864368045390107491219478016119899657214155145913386756628454048017732090840350056568144024921095326932254276929146625547570353273134946210482945353079562853807849661120591494684054474429579713521985122168120290154518365194070965397377864115556070565035398600387510458343462770175480871338220263867102883903185298428704229307604536366540221486962349337277750609311794156355893181568677644395961013819219256743336354503415403424627479455356015994375537468448657952815548134551842617908889947026598338674234211392008899014224596740136342489331971566126441941040575271027742428764164079348682303386606103209351082929195658430813839539712669738753629893692890622382993903383530550219961302100475438556232944434490812078385857004516713480232348053935407676631211578708872279187377254320477448882636195706154820276546995175201533640901654750371227223147817356459803015111324928426485595397214121
	{ bern_num_data330, 110, 0 },	// B662: 25045169802991283840845762310176546523264480068467838676156029521711818060415271182062960835089158906032403210304116557557519363097879468489797329477098964128331392732229304793290609662474213452319999622865927057915645059444978118241644298369573615193351471569265652039225287804003401481822241733020367960473602329931317379658909739244392683671981463708006034495717599350623874561222382980210906621448006553953384122185924647571281523112152079088193295317582593649535089461621461040799787120597823109587397016671182046563818518690024360144966416412700215090417158731498482450696899058237648318546536969696954829782939355578522802308550131475548241257346083379533659221741052303859425150806268070425112853120432259569140738270353877753831999450971092921413156978368264563327344254133561933049903089015416384895980014063358964222545575584540196698796405847156665444158978038890890109211357769747357653534312573680924755273467025657051822133928627295919167417837137216592050334664209571913014756095659034200169813453300670292644729456358812148694221548048951
	{ bern_num_data331, 111, 1 },	// B664: -233202030237834826195141973015237406578664677108169910561704931112947685601080553713731758018204100142820923768818654131463406533398427442046206378504825426147529978007118890307165021511509030914914274402886220283032665423193312970934353305446768971561945685065992558434648424803347529095906003441247086747647019261194783758038639742923103905834849668099015199435958998835681560567232107441156898323535089587299941122237479265100954409709533862140599108387482156354031857388426630256801375345890141110586216053212803491207144702034310843717240296071594995985462706307951763433551023427838615330517651863316856506136389525047213270974562593304988201341550958798154173639839263107352510470515172957376026152939755138047568233683235753312422350548947452291580117985680946395552892967181485240110240623754840222913343766703999078036976170319118039077642742164152925649258131531294409614246755328633159866399871988772828679096477820871119076831290568634665110598934741762151708629878067580500364148943364784876896743137613079754878134847996768431555288869937541852167
	{ bern_num_data332, 111, 0 },	// B666: 92926267458583318426122611876468045079841419865346107907250038756130856341956626408645198491460040980539039239328552167818108861127090362501504987423066595942556711470012447706170007153820168801474429230439546412053464435208407092673819153890233721876658375070136178499565874014030996372031865028042023609697509344184481675005115983405034962313483480276446210735163705480618978498222679527971509883714147500883613463277918152190410065191952566280440497885203923581429970064099389740364773511715382372088117152707477564454801850024436401496173451474054201197338758169050631557652001318522266128310914588575287965382219174775702423753542271436427039755077892294236923782399247357102098271696869279143145115652582501206934650470701737859126187251067314620203658174974372786417829110758232726755087666564330946552125550165151571183242042546620101778422191187331591524545050530879358275382579560039614682486486753254621995430093422183834132925177489213130429722334248376038999191496963555301384622223815997343121680403127663838358665062082836342684394788209984385552118357
	{ bern_num_data333, 111, 1 },	// B668: -176805004369920457632290427908661323820944118897891400922077649330877469838383223856202072528048175148545928897783884353572896400800009759702189574109694647048569335249337336163134856104509906218936298788181647572865215299330045839832120019060826381946057577570475968155629140532990768798076669500689975868621290335434038959085004842022263183969551876006860201629876372798856912889310168565236475975914727200458559752734036058088249253766014088140590764122754895185003019207604927033127967661086599897800201698496948527058691281595826860742863462933214623502100401029873987517047427377808669761532255732486680602184461304729364415918918041897939297548760608906505806161697406817239363695996508669737517719707189168295045069568456929373399791491903136669556642231141944454450182565252949916831438102376795717999703617943642225697723768607501680167849891466391300185056236415291989147585760132919823059182510959394523018130527587588104519538844802632572250154405424929733070720101681707847912708882070764680950206318778284518957427321445906933046593056795494373714617001
	{ bern_num_data334, 112, 0 },	// B670: 4416298479500380267166275607115526616106680470080306088802048220813770753582049895096356327145045271673898411351622649979923554902816940133892662491512138895457518216120607636529935530984665591652038692859399036197697523344292824123052323434996068816864579835168087278681450005181748562376016774949719966611676619984191704022989661872195419177576237805081175656849431703721524909511600455613737225670719931982656137096493311981491021192964686684423151862232579649996923201737796295859152380491398224946198787118343956886282998815274750919080174884043349693768290390082434537535665665153247220024850648231407500273330336036814507145379302422755273274352484464727275355505831498030902781366486005693418388895501999979351665969392369914442837753996372836694082312460071874600679696721029427659261572137615145990974423644186795539192831892200600568408106769299424419133095663426770574853676970790625743678707132402357384914956020371436053958748230432662296586019203150609857871320986995158172941134986038132661217654129697986647707720324249475241904681434019859483206149663085
	{ bern_num_data335, 114, 1 },	// B672: -109956195201884542016738299010915047906570253997891486835374229237456931920694110061377118982744560659113672167417775143356122955776267931072576874366163121964053482508428337168950682128164076791070372952886383743706073570210059084170240107507155664991945050714523505443516074021270719436494090171899579734848425927058496127097357436409178802679288388058189552320213359623588819990666001905556446538941767449346519838142312997974174314133902122794744281825382722697075716871177780624431746917969116286123981697855792401368967838961268275015784556216631029786589452992654419725519668727379960361357519368549480687297731014158568941313175715297675305086414073599448432350511256539946489181186665287285230267926549515045106150530186014369784740048963721118535802809370369791846146891772399144955459561580288444271489824257009686881043297363521050751769534452536326887153431177012216247614864645050629090063036699140438887580104527778656929311808153987674819355157658058070746178667949485684477404852891516289319448739198113018465520409138836847163890755921504612900017857250334937047255201409349
	{ bern_num_data336, 112, 0 },	// B674: 52688157704643804773712496556608338994919737438991531539716999366911930607221207556051711224896018314851798652033272227214590468050452676459260543222363767411077217565229284088628584508547860749064965346324280845907449691560388262585390140962160243301695818577378739677582873486530549397572790880307881421645700588407147418627213327169391142474717934567993964948951724365924173490482928139591899985695891774081713542959391058607807901780419006162385255889610403651832537076183442976372860726742424299168266106832855463858669596672994714333135881953162346278626910685610105771026637059227020169726361596087293477650504369432483580905234488786969863085207259338934350166140834187560100096225040364620516494662420937375022860190956500205562265212616871544039124221666304874083501879399572218762554292108895447873990745078369346031174998636765726072913865293003606181979799330121264735066017618746263567815887389219680133334783581662196413352243053192270021561088184329351348710759888286734071005740250699191292489336587407142176655852482278296751112349240293977825340111852151933887
	{ bern_num_data337, 113, 1 },	// B676: -109254236893541848719820174722599596195373705369434849933436102092573789533624742962182073970321849188145687265128239971485729111163528562960471488675421493264499711752911018599148334299984433343456600929769977509688409133035480982759645773442645510499905923715002658150963063749142387324703850638057744330685386782424703385262760942768179500943342993365503636447954310995794983411355607046591660781514595988722465168620607299678793479530240048731439455374556730306296608448177542505435227298008728656157197947802245659157034853777729560178591693082270606415966551274782760593936410992489391535139415253101788052107767874878238936447694507584055162600699981097078153508838890578888358101183616365153154533865492516163867782245082897260294329000198297649844002574622970472092121951055127936135094491602989736295098309799496905212004327342208985643631472692040083099768653731510338575750654920565944716004549085379257667944030588971769199263596732808524258227736454185823795143980491653038514085208918208473310944233536957316866737280084895286663736830656532130518667258304731071924166555681
	{ bern_num_data338, 114, 0 },	// B678: 11250874191561100330033540135210459385280923541414336236420072017724348906681780883323079363854785703556465411156979558356688073202860371442756121119961366357743297441451814637161114663433171698884051862076555552069400313787292043271601341614938937646351496389950015500630635813349459241248577781002161184197450034354924075949719631517105070565212984082874929243554366823369935193186884365726685487058385676641285476294486217861607925518269011751078375902084792017137968298041196728267760477462322318361243677326137153632422504863852752917144851353856628534178683946270967708232380574241648829521273394078543054698269139571091502886625027548959055943396240071580527426962413465973187874342023355341312991431668797194846921819287595752866391465616405463132822634840741083405122443931955357511057178259346093554732237023240504102916178480354282991113553255168126532207385191425857961351285712112035657271576531640290190355721093374830258291452508436921268188472726089963309373040735847771600243754719018083161394283596825756836940953268527899649784314436015195630279653044843936297870172088131
	{ bern_num_data339, 114, 1 },	// B680: -25582821158154366398910084299563912493888363020567834736487229662630066339001528678307964484035227558886528860522492671522559048059035022807174802073962265024257342936210401566568935895910167011061131811269257438743120365047151563195388848234414855914826972552769277881724435692705375966279341237998218210482671378615620087718683969360041857422589212609035923387661385085592026113176047635165598956796591311912993426883182673865412860395160129495787333943358628214517058843936050789579458332958840925683065711877949694002049258649458784090782821807608025564800137434954238494255587380752766211450443307667228585798148240170509517579283150574849478115134206981520376294737047093020784711035425574979380316100148734306495004238614531486458417874323924771524100013241912627238913072669544485262815462375206647079928806203070183305986099830715644533082383605698101807380539809383784493037277346150816464064183168451170140938033908676405626499281849089923115766074556320417198052270480658602525351976403749945297220556443301815333387407224698937303805390566839711214767712369606982896338130481057752987
	{ bern_num_data340, 115, 0 },	// B682: 15303882090959532171923672123506400773146854214705446981328225361576629087075975198198633049309420841735066995944108735191540201299375322147691837283514675587774512413367375931999886059904293466267426762739974732284899530372265531434033160827955856783670708695537546443630600931126876874041761583530442441887664032044695388004171888868886532717839410262107218911273823724013385381787818619202169802560532695098214428048134887932500381707346929640749176854756584586451193126309187225635960155351984375799833593271721404773048276284845606602291725605903399108020535654427073959062660498529506544170414196070491069387600676296674391594923739795265315206516641703043681863621500127143920429121130367106772861544717279952314368200703773373720588312551608065198974744942002124278746302798798979896461398807812033891615344053716680041731100264846104247818798177383297309461337040198055628852156231038475206932344389499403785051890565650627742920254531844148970723459398723594423192652274101771994096130255086604532612037948222808113254076452763134243360978244835105912785541833771726000357923369638528294099
	{ bern_num_data341, 115, 1 },	// B684: -844446896661779294749606267724585660324603020031667746164653773729372611224315232939593880819432856455263937634467483539153539019259466143059096922590356040228489928432495828931155327424175626612083223621136656851570834839195441021139431431275890351838401985736123639748983085764202487411641842682548406457860319903452144687176672615782496759100453106698670201334653463463174595743517188513813855176739407030697583232415713018294274998423573629995450464189025271126585781507571337786460428102602938827563414420942133202194288526164940125039639725166610687430016532776494723508245900722079818003726951792013645138621917751442100503738498535204678574473071464245561991152182150670517515471196650037892179142110731227725061217964174332626263040967115683467466229376847966616544057133027415082858884985304470007825094112864725399542142535166785888420996980386555852307469999394257027144212634729833320288955898695353939588078899238375103588535551906000149240702355453791199283433288428457122808157168939495518892569839816666762122079911249076244074599295802363284038569070326284480459374597515189139339155358817
	{ bern_num_data342, 115, 0 },	// B686: 137222425172037009171086051298327436018113746135705497009967966459977432086445704794065789323414998364041237586016294207097237138716451194303907695725201026372675105486217561488788711730284146955839013186712453786895649473767480094363230650847517143446856476766360363339233426284153553297256341874613407418568085111890325341359517329617798015066635382942869740954479031153498383450554356059016096962821215566531281028610381778568728292343050565783779209961073755356064588625534563088609800585184966600485421067959349767785517690531712171341430581095599264843752393772699016468495484803711873198156036702042392785729162320426126082779144209663017708060035693608435796475108333465986187692368358823808143303707487051972576571116527133502402556333949332507513566162002188754054138624854496595840702505500124448607556227506413024610485261500149582355661102214521735181780944967174113516014781323331356223754012039472487155751251179771302733996584444402650701299298651464211292184669036601724779894393557776418365294627178203528449842819311457454828535786675029739840698088436110614671493246249439823899555783
	{ bern_num_data343, 116, 1 },	// B688: -24158811092057821157624766666330131552951570498080007569842503388410187686556231593814138830225653037905469510599149250145569340712997372811429098971086555522405708258207856803806934070546075724661645976656273621731524716202698320237278555780460060928785642979643700623885064130859034226353977930856533141414919337687355616040886180871799773218311823358959175950108626500687386314003724148716394211429116377775893994826086175288479874273904256364773972046435761199673039990255727578228388904610966312315553892702295377242915380885084453333917650204640153438465076673532371774233175527980227998081670618422681695175751003104702573777767865721219984667931298768417992497429217159538525190066358014956727256350967701123262247324370802508489261092230592445229411503814957420178491369154067221586862609034857577529477456171339143869413433703166113718083790570129358004404853997774082592780104326537147310706410262806621524133314612216358108889158617997820471425009545332031800279930438246449884472167311957452542392468800891314049762997587561293975259317577956898151121329968762498437091228560702391819857835259788941
	{ bern_num_data344, 117, 0 },	// B690: 213187741906148234365632949188903634761980742957434979778642953684638694213181796044300856508239276280674103031378417078320497390062213151294480496309891110874352703150464335482916316989033036401001441055216785284795886375134584742527617786286874089367523157912355786611318909603230484707371390763124592269816833947322368048317090632288005895226221160608184014406262540913871889143648760505245511864439745342749500918021098947005870336475689348297376643234914959183854176345896007254663678116081640448536521756521798897227006877525044478900274731530965311260856947612400419973592706055324956329555612331832729951059407264963069514599796595716601200783745169462722060071789269760619294544674531278089000637628615242345161453042312963105592509372859897107703998176088155311401414153451034786961494613016991690928227250189397852093886933906586735572126854014374531142042190135489460641744575512614501505776728203446610126434526372978018627695829283814278009924290601230714887301611155624311704994382502149355353202831583444444249078756385088471449058564049739037679165687506408517183200130972156331759334166155643754901540595
	{ bern_num_data345, 117, 1 },	// B692: -415760273225621191145347898733150925280332766867462558934270354095168445328724762434773439061639854997201849887473587634228456705341085059484153926219850235832470833146622637534943713956815054659109962301647161759233830249725371727856810080988944112037003246850381699848092904147992704466811308560450215245372867379460575034051511594650199129063930368257683644120273874743027275122237249192023112591361756176520481701691154119978088771046959646084091800694130440694534197510999223197262907788811110214331111338571565773092017903581669514095823487788160909220888738244090052599371480475788273384694400299547593434454738788466890635790261445355988815429832096670319355776688392800736259811467010834155110291474560995040456818545752429807214451081242352093327939455377775461840534913772279490071743676437071317282047668071121562980088102288737955462252349442614827638242875505755161395849250391137886513237971246675213825960174633243680128865719911485577633493445809952436594957888380851110299226567494895732885273550258054990675964774647835161708434148944537071311419222005292202177550352273643864977511403124824674896547
	{ bern_num_data346, 117, 0 },	// B694: 2919284883531441280226428385341388204185712898353794342479596917865741602414563042585356870041041917519517005285226584087610667466367999183696227704924361621984570498904009013177821837980538506350478481030608101616279058371706711468889728179988878878220802244337371575957954188735640203958566771622241034689986901773926126215524393799954312128165633665314640450876494458231757996544940197047820297460268633182292618003678982200769782023330578023862229311918041774033650305315929622199636325090710953326567923737521064088113952107504134415070996381568082846123233281899913536155205930226141446302335649058652983308550839288092255580883816447233271164227865696537425049562650829173171098030952661142616460149757031083974851274785742098066204662163162306416829570426172934889749119180553633063316330967396256791804250686597717007493141777735713459853404678364628412948567397867944072953945580407641806844489842664328039139233425482036833777248510815002668625047988869077616649145356894851246679220480581008503269160029942819227108947337546335353335335087759798782491171147818651125480009591098975624491199489366285506880247
	{ bern_num_data347, 118, 1 },	// B696: -78082829440778606627441963702715324805059428266709315138067585130662218877040172966287336743676756395780412216122806092119519968587470721374106961129232650806563295231454854592084349353884567196398679415264095874738296540897392112219937071662034470289266625166901073422072705753092449524246419703476941352042412534624210007837275583201307839906184149708954649254271397830942357564809754742694854965887391908506378062338511098232029147239986024093095680274772048254253853180003272496909301537914993939270385712460254375142534290321529002204731619616952827302656270920430350837084359509781054987796228253626255399711038947821265730956018707568851909371411055685833492005269689683631817706767965375767409453067856261536178509862159325059101823600839129649569153499001540455022939214286170469289912460077562225018612954587692111160503815167366803224444659903405048339030552119320201497303535669546415036556366379621876439132507390737686750363007626776941239371897532709716528939826965858551509901429658230110434270778921010629582326379804523260229284917702767689704962277021581320976262648648664311916531784700505485314713190796752849373
	{ bern_num_data348, 118, 0 },	// B698: 440797629105449569286854418385832430006485784955329746850278862710895377450299093510980428579384211051825028442818565495859849239383964825194126340254149814498726536039955814366726228342934697165348989880951312847482681909645231323627059115465965075977068684888812335305151268129155648391425387380617724588942638013662659652451604709865208874538474563550281813608808124726530519444672621515473879797272557119130261214569635160580691362946395741966954877564769832044618874483345510609815030007931675224849998562962465634413808909006594112832543582828975646531966071755211464171802583089232109022591762806588603032412631163595223903849227003837387936666311481076215966547790937447818684876066560933174953090172795723739717618337863771764079804266134711227680157334597460059332771076578301103280277703448498589292073225583116301526577204757006539331223375626235258904623325244272940294545893456872898971858313464232882615625748001109522401742844478645311097524743947069598839008505340077816649876552760841212546517219001353468081314605574698231480160141849342349484539046999893118327169706605767680795615628557618319219198087145039
	{ bern_num_data349, 119, 1 },	// B700: -43803938125898238087496359059275986660376356603654101547226886697285354027681645452356703984474636238165836462360639792621594190620080826890179294466303884028584783865702824084845103839365906731702500395923943823116392966589118933370170982850049622365268353459591466192196562354419535954135223902987661488155889758591520546033572481268520095254898319453556500711040757249700742086895693932619982936833918920349060715053130062429458585315275035392971818801302959868849139425402314721184260337200157113774072321522411269542686890053103892218131942089244775068987538764393286881488794358924461638916699645627282851159373119315282437553229351017573521309134381770614149341759362804201517598331293510487658626672354012654239406548121660544115108033654273411532834620713710117895721632555942989136287384540345970906056525218295199753766541640926164026132626018268651773402945187010906194204247392672038598532779281495623389366013410720401356594422011034314920215152401445897390822484199587504504443364792811928698507970992443521011543996998877080625865430959870626496411480874671758187335144178168079532283172617587901357815375517711833179095811249
	{ bern_num_data350, 119, 0 },	// B702: 715531659908886852296757960758092229584559320559242829880767487684315716065121665926780710966283324798846622569403717499637703648980499665828883657171696621932606079102329192970740178019770997142503030066642498471502868901787800232010592375568764272095763652557991440314186187213627891602301367301259029221891706011295966777236213957692379521672239797112606948518001530046418025951837225251797703790307935721683407688701671792450729032833798540380855716868044525171575065691331050336653125115712846530833701017879749031291205079724691541011449931566547410672070682007113450428935605663117733971277128518434232079428877597501709290503581770174841646034090796329734509092873235266097551745450670588365271386245152262451516982551021098728602875371617487393302495172548367642085385128216664972652868723919288523418149157452188489620804180101663878663427654501093712930552023420484414268770387674026292987561257260169477533762370168358178858111155759090013232648116231353449253671534898638482262603449533578377742177878432563944644309076451272853997187256073642248459164234888883367997915565121310426299882737052180127738847109129251524484634797
	{ bern_num_data351, 120, 1 },	// B704: -52436034866358147206669503506074142135401184179542975853560105676807887291497545413126694553031328136146764002852879505368923922245528490054674384379527627837960683621607599650945410292326443584744806762179852862060382916275571995241432628774203599857027266407860917219136882408492256356031390731771335109151979395715629614340221494078306878613477197906150618286909089138549370890966628921591578248813251865256760317151077407037541481931076321632763707237955355574715097261550946085993782895571049797079559193578341399160263677186813382341478026907057001409858165735948014559003928764832935106868799301540225175239097807198023340017866915042187014279234183303637767940870280780541885186962466427682496992092856305050483663528329711066253138658723221000915570933816042756459528140117005268097847858994441753685951361082746195846567704563477199877528113234001084564831226864512848651428283059915231201106248981985891054944459621547230214455616413038761920418909186654174393834564393947422158851133320471005114597031193946459759222910291126344068881049670576677829390625474123799894127108737363401347146045753323121736327016544918714948266659810070047
	{ bern_num_data352, 119, 0 },	// B706: 10763473629443551855038815483488007273449984357981791245275403428870962276687063364526533905750719318355212385951568234120183767762494201600502678933635425894459136596735664549665447989392802129321764637082466797488021916312659352935240510918823113550747640633315659095220375810599301982472173898688835657296963279344350108947235577494092652163790130382652947516589721882345665803040056444475680334548470991847759676715588513011088536049982724632621408289453471286517175343308848993234126249332020568452828136702766758638570726760324713741746377890731079533354733053009269091363025820550799823193937273253454525939018076320585019877446767535060688107261536980446801706559690723750666372331475328838732309526972692734848073288144138412402596859117679201975259256929967910867412344462914042318944103443513029318241864376419365085011285046507331394456462425365956423816879976472789905620029415510155169064719531062377062581580567614542782343470619938416508869036814974679977413137607710489332539861550407916938341897442577560177203338767991922110295924084606986676421996814107902957409971835210290147601684067176166530149663828948947693545591535743
	{ bern_num_data353, 120, 1 },	// B708: -44025370321238667615755023281305246577924761209265943350172514616508554528979286953731743826494079987682036868430455373145636407891969978678460430793289717810700454389601502496785943256051302860751110859563688936810277321502490852242802338371972483289663701856085548089215580278834439118110329558753892537300831115301854574663815152575395788456307514189805352878538365316550913230837214257806938000742535657133897377443199233196294698070079112037671256712888706904055152873041906407845131813892949937346209635685534303129446887344553958913099185726972724668687552067433834314457363847798212764657775108338253069433440970164001765027691065788182940301757107863005962890925588251294693704106794581877820859753783552781095419728883738097253352830188658286363813266348580037463175120512062236628669732385215530767640858859300712964913107912613882602926370575846564793023740989067797468869324586769109911981139581127407239349440683449176001562821082845259210374290217357267381561722715712102972408923792449951668216758487965517468745713838584137721480106439218749369823814551688340542125040437845700232606321780825047965812181638866928159825592217799210749519
	{ bern_num_data354, 120, 0 },	// B710: 19141806346145918781250460523242769529143141707702527402938386786607162015401742130547363996445627077473354391579668462652314957411117151419647245558630417412882404203048988118779006479754632279878399726553339411426072202862394370614047916091423282775235216630196828676548098747721352220305435468558315285624604560588720918481143465441177452029966928348304833412044975353938525438535629671324164660562966623552775902741967147290863165944496571607883257284804002669328229778868386623308958654100174566983312293981735512903900995084255077078699707774874157696386080860208841270567451058536024403264698314442577690060398835859798718512261805893316058123765500679831794108738843702039209439536628034389678302354696825145270170329629214898035293069802625518702355321542198433385919454000968199327786305683987545115410643932810784421345204791620797990240643366263962030579115487122394354272549577476147107923922349986667628182908452553426823682972047282514911183933309713943101105370187981644356490224940418495635998780296301355353796027984404035510836188227514760675739595350703377145437469069348752605321637878591674220047165440404799449722810929709777596605
	{ bern_num_data355, 121, 1 },	// B712: -19971152412173966965128081158164387929546810852837968914663411114740520905359571480688140021613921051203801761902311993077967179232511718806488294028022525853782740837769321843718200030617404303035873871632454036733185743404026167826009359079205709491368689965665860243543556337724921375355322865183573714740412918097114837681656887651332552430188039047729650933041055917489661863215466711888773136271102119026144909569994913618568688378524205934547746077571622647614909742487048437784231441554580117065480217992812609959780540680047230234218758778155222132780218089338058844197699272046925039981283167662869021723023858723727726721716528335414653429271896488487694746373626417610227541553896080358869863650197228601561123840887938140360219028883331885917569470472628328888241445229650489749252899598730198777787000299108635923126967655184796943083891397317098783565414133292843832218630549316004118718531420796276206380790407762172622655757201572552602646815697907454564187649654636615558204816137388328221028895621953400009112020162816844709200607777618531222588697918915972834072707834383958467038211328301973716392143263053238971688091122202198497033286579
	{ bern_num_data356, 122, 0 },	// B714: 2132110539075884666591682681005739676809339688135887608296222076620792188429200707977629501785531063572949834936932055373439200845384256359590698557360420063951105814695844327190770837692560914143110377026342454294244716234407807975335139494144548583522656500163924745947888944544051114366176680835874944287561989134112336345451904347090107914327731355108474059738825370247649104367457797337299248734677164027571568319627147187210476231445603752798105641351577032125012925663660185899410381376257520723651521907873883559789474819458341439155962553458450922452713856833546088969717946733916489295437148800819190771375880136817698721580518391967903740935371271774267045268537116292039155210883788088918993361292633582988315288070631505077935318287256665352113585022809447255627629518482760544585540356375812379866872174963706174928058265657726445923230067614787010395396737162244897771803743595304320358617352488752168756045629171116523055087597939102517150890034366206380338612290547950158661177089609447421508990486111964312934550888186314082395025122758743605935160899279748270880630667867758077920315030635408429829188518994839106238910981636108960815722671503452219
	{ bern_num_data357, 122, 1 },	// B716: -6697795386140624970987403262977006606015235108994220596196008778422563902212709882645921850837883018971972447768824620181853357789108478058641350350091510034437411083733220736975325437359398245529143662974678572179722308480038064414941409495373802829271683577925204077586526908061560279856399532344634010172145870376431873022930675988693897291631850794009873582849577875579911003553385830460353567508954364531914146878821121937043976449343083340079689208297556434916145051000122529850319671790176998295257315346631109048665146149495041903670401457615353715856745362711464367925740974173379297716526128487159882979762630341189932549868143056527777474328519976768253097098461561941501065687315673704923906598949204775537337830711280848352263641306482641343228963749810359994155258035349341478725980802831009970710560826327670793425507307353904786991213517771198388817042724636035890448477934867337108027297368047742696990668857180131216755954522228023647367670770525250268363135941880461488589567205998774522020298473090101823629043281256801809698315269787315946273254506783734808406466486185214294454511791586207953839900971181806134063935892535093421491428558490342559
	{ bern_num_data358, 122, 0 },	// B718: 34984862923870208894793459606050216984066312041265035684950224340511408942235036747711369412293333748781077647506502323265327456003769302489972524775835878429478407659267647876865782384121086332849392134240583737752677735690197502738916703174355308193976365095866333921848179336669471249916603384141950455631401198783165426963098009876221462363567786121947091011521791311741813572432380543101599967612734241911397557820030076005946730950309967815126294482251814810899003903556502700147686960662890941311226790803328299908872486098748275139287921750434482276590499941684078338429230837320911959829953449942970750661243594207050698713654351711532434911480939357063066152708549473375884068101903121726770159455868586841930539282502477359655341741747172787129180981647222169677413121902397488259784448203686188361481674873925421300693819974651776604258991214264304686292546776075618896799834066289644784218812021695641707837945866033659326484691232363290238724188164742757752064100531252233326293852464720638609726912695901977913031147401690124141241241685374262544921629099850440018497010331761866278966557576634528337694250076943881512200463221928742824411245921854691408681
	{ bern_num_data359, 124, 1 },	// B720: -9422260945644983611335741957770954095262097178435437705517952373091595695957359626671008570117400925235051624306593949022593104133202564781220991007267664363322035749036806535245603016185775018688439777032352272047444059777221667388624894335512436295142347244597842331918456102570382513725854109997613669765317094988528933154206067073068646875855017674878523531707635473835973773275454311369493452006956220447525683318814294825553719261565430418400467542290624133569013867668321875113871343135601800625535686393951809922231390039351320964920240363731298974205892664101799106907849283312297252752214094938211498513641991837665034421389367567294201002776528186344095006063775631479122242718693546890970556341726225791561728951377689653554753770640906691172535991417133399084473870347437944586128322268557414168908971407422900832643191889614716745517706179841877055438360763915079076606973158515840848178492467318479669260733553975268392767871521905850236958798711061509081081262110782578330173435648445839556974531525917466737393174632693094345010571649251219282674867726556826737780521753433016552550116239291670958338408125823041873885411916526616325773880811670448985655804569875199493722473
	{ bern_num_data360, 123, 0 },	// B722: 8413286182044705974762976192814225973936830741502296013184378937051325156031063941315482247431499030818254036065460225927233576828245915528687038437299738693788706308694454888112145511227268774651148085984649782838048883098743484330224584791533786138177513845010593846793512382733047557844160286288785861639446564827174432490718785864624011052471708397128653749984801934893132249588053898889503596152528347273786740624257769568559125849277715754351123083497021342566543337590219963381353633312298882700505210214472218175483275590079291368965413048205855146123622432299954367418189618029234239722935174050666011981122663573825524153290699815320379979522682599787763500168622869457422337784712451737734113586905596857612204466355563604718193594002017311527502882311804106887767857855337554628280154709906296872301998040081565944687267805373741821883234383428326845916535376806251103891734943856915173230323544072386279647211041925526721978761819544878221836238568231004457018254248751543892888606178542254685996504512911993037493645447188480156833817165259459881002133176788044270504337724716046793205201345188938342490328781380957786210191802552257246248931520254746165141867231
	{ bern_num_data361, 123, 1 },	// B724: -557766970639367625830052231607817608461695386552501887327586251258307831941781452346631315180974124126200462122259322991989078640443893377997164127730358152430528163244715005675727246069715588460298380579863599436157290742310081371084967758344251562157196846663005795684062446841788366200427684952906414742709164142505069083709150843039960373303482519600438297546907554211626555863317601870264733591705384097737167173108041131604300139177067832735505590807929020106418846636059677640034152309298106970674638291249304218790112697397644522921781770201930057022684744711341187600927147875988954504460031731795134473484880237134996345458804547477327792251760463578790124998674175049215016699904220441278441467795744653368053632892490313183677960998274936231069073773404285536474288093409740517041554968162683646088275191106546145606715298537973928086060906875160102130886826176812020345667154901595796404718345742117755052877156193414286718988001110312813884317075725678698989575466882546617238258890992857991109009107610916149359193343776992086886114096046159936482273863869309483409848338963756918416435433239337988839155974124657362152705290229267353213755312500818338972407772239001
	{ bern_num_data362, 124, 0 },	// B726: 11663604071713673414131132702393063549926068901968178688929901270171083788056534454869578618882858350130159567138964094721194498761561666974366769165331061647858711812769105062653253624926485057687389226521735077232764463755042089960284705430995413097216290909428461250803250132050091595915639395205195415878085174346047233208759720904685585249970201423844255549338759880823477311131298065579481884981623646780223787432841652952732901288773475656132396638958752440663094759643797316687705813444378536718799439282387166745461905155283673894820988513089726250592238725488226689556511315376891987941729942123499800165078326323549253470411542422477837278738588987642370678103038763808978181265996651106686971132515633097427147321257776809623004852215978219088082196483982303810565134689458522065581901204059187512383118336115327798425884474355028328034568523432978867498634756601438973309798353968267350634850347197454087492496200363662266945257851069080756294846105015213709912839675173477855338562777019005879785732903957873506901740515088906420637368211075121928134836772886436029719285991262453826415530626980209641004864863107441052221843718085165804817443491903226444776069087539006167389747
	{ bern_num_data363, 124, 1 },	// B728: -153231341780667376422246876060068794272703347555980704890903803437865638602299274956046996649197700536019565682731117459129708953519356748064731272068042703470488772613492597759710973524880850922939189777793179411924786825796188601321358127352189697592964040484030180446794558147987263375773747077481050331677530401946326068992702773364650446622846077899480097173604844685060509449625739043174688098442354653409314625613691711896241368983493670620058083456841268771891634924624219182901090524513871363697585194551979391700567326760524019053046303955280047996259198318931462683452406353701974581294630198213317299758385346223088363240810518194268209594742620417232061434677081502087813043002615917767980446648107300483186214190447187272011671435446365052721454169968803573223056200474871810935633237582286339870734524137180993328866099456347485749527494735795809313173890505431456324676511065737667705489742139459796056308535502687482382315362531943704078799407789231449958679950055691065693966174124059927598375376793875913856385954289571234167780225151051371555233261060084813696371639826094527320211960251797276665786622316138714024664299430528857934511466509637321380833796176089074179989537
	{ bern_num_data364, 124, 0 },	// B730: 2956562536826234881339437420872764531342971855038194181847002863824919679860628106638216330175981086870275911043791329860236003640226700721078086435712115125976944864359684513784423058104176003906741926686200034410442494369084199371857614539767188985597331933131114979400420668939520370911450966414792567538285654323945364428525931497101809745013950505176405439038870175215489545992650267597803872147744326039503725310702087367853134468617737487505452307212561589190110750256966336654308539064979375905614971672658658703240376919737994998302499913353523725842494364051911829189688762985303215038830388703874802577119922746688373592220864287797134206411270091957676357084636878955694712801417641291165952238681531972498392972759605303735072043136576688935873415387550586624419917881261932243574840204788982703495072896187284759288729081837314789014358134011707708686187117233501250382754838219722780059686102657332415075636784997600781268598432538825931106266534007350535466067126725259508542971163615178559527843122033811167678541032751404119265283923738494358214478801740978939923400690251936329225349710229180001118241031465177027185030963625463930809621922040627241508349470872002193227987365
	{ bern_num_data365, 126, 1 },	// B732: -445907257874709875475603109299106623171256282963054371492802952860584668662531764115850176467284181320452754566802329841855766245736205178912974846574279437937378954046645279905467534334709631369654668794976410887893828306238303702491027232761697541229299290900107379490820102894266423126492645570037704805205183794903992724067112795271205812656657399483376873218428520295969778869306534000424701050503476869349473816017936344308499228903554146846379163707579626835125457802487034432582180400253603825102127322187311709379305782424953150389190804450820451784649515230154085668910382672546822471917548343234401661222262786252245731062510647929796742367420524372180488909763377347305410294565437499975145199660511989650394228059252841901737825050064292553317094768412073917512992106849632532998809489734589817444023763976216719350129058167415185909408139793879975574370396355379943620267702606477999211674271422199362299345836574543404777647754476237033152075209120416060830454133006368941262513775845058560637619124477119649709175380919345159468505624746617023827994061320632616157568245150133891023739337982915374289512450167695284494687280024494416553184885136638344522876581829628389900017533820756418601
	{ bern_num_data366, 125, 0 },	// B734: 49648188090741477647102425960547326573617516516247616588193170091683375902407933501580829504228912224447939170441079780709199039342471923502677764691652150334850190678376849707157411919403766059890286721983264903813581902952613507327080404561032820273138747555211194430544374562695827445276783755360820034588664891462435992329951020280014011570719734532139109427612724497288859046095705988906535205520826214691080875120015123468311809077336101343218555130921642787504846499211824880645756783987627877864800893857735652630489227367909752511204201866218583130554954438309735229957055960125148754021691455835100347260802448850867063852428361860889962549373456277913609173740675285721960064402097894164719572386550496718154116690387126061770274426095834794539215772700074765224998049668686932174497516819415051497311883666142413064921014615352110205059363707549186450681878564197255632007375036820717698945985750089119044695628174407184493394699733972765326800515587231399740303994935648463622197203892666395476888382654700767269588537996756879275718062754546360330215053080861374682017891138101187069543857162804932228402336020521347168195844894228505946157076658721697561069392451865671839755118878580967
	{ bern_num_data367, 126, 1 },	// B736: -2717850750109075924203653937655588741701084735510808799150877550721084966979167440521062823826172057218857683643789775263284264942817898514306971377038872924402368850015976209611820909823427958916002306751820878197155220281152482710470603123834747476275246557000412040194883766793331231632154152335798438188531012742782686629971402728659343638947572523855077047454118526773873184698490335018863858250278702249704242712543323782559405173579932086944943095898255918849303215685366600803260299308314823253677798821931351632170946474513691919159494932441652175239522305482760405067483021553662642973579745068227700173205122707797037885064933185798902855514287755104493011606912821043158974231031584454569205526420100242359339218450218286355765238098673075528796400180283046077633378992464976737451619024864117016978785352830250642990678960295492680048423709139761725094425303631355590009503565061504840074625356223806903123330541961305733145859809985581090621145041572595135767221463136412269204475112393148679706740842536202664750417848436945342666059915160575937041296858868906247899755644719323728413497427679054253800856630652905626090757205841252498121720034398084277324519903494019810913866038822925724869999
	{ bern_num_data368, 127, 0 },	// B738: 76462255531881688635630566278268569546684047931296183714901182318450269546951330592148292182219112538916245355547994298204329718146140214392393539614433846075474981774401509081317493444999218094181644711613943744004524453244172018491913789870356306036948415489523529331398784982185656957840613177888618536370554571956894581521456581826075538128500597617465243638476065393682221428420708178610237482825324487906975387364532497137464287261750591551466904568701888935477628691332754804570475524999532337809021343948668921678101842488397140497914411831618581782097241635633416344648633768089885930511258072018010897383049383462290245625082727057028433205378112693859301523707808378215371942390749346906575858619111801642582145627038348383785542768804575868279634707229727729620857615674120481148581854338561021894583248476676077138852305471466735368133934441690158386532215954912584511789891128465359789401895567176933226769620353252746596958131541518823437343413867382768735524511564254978890319454170369957438283963740473142728728457462611755533721341174156102623508660329349233992032175770872179364281490826142353291283105886189474530890760764139086524403921771336002724115470353054904097715249592539289627774718809539
	{ bern_num_data369, 127, 1 },	// B740: -1063991877425359800981559563695910407172277688872770656672616535839055938235993724271263855666455066907004474590676538279840556263888029906979966911793914207176443198283342882655352501494958426013371041840220942673520780344740398135401040155012608647724235285754763116764690695564961988388378009417714354872235774035542026830838738618113467728194253892969880552339330144154707186223293553280298793152315493516312552559880033706959351537851541021957462903539078130993712227451331552392417172791903678912337804111267431452215593509943221262395105308390454492255684032744558441961845766201493115142476453352531831894566716997448532274543586850567577348225287115113006767663581317675990744726759092507753456265121168268482092440812375453103750031931059534769757015186489895554551810747394914248952002005249239251841257537656519324523535395994548976571496181516038547819256650303263689874987513389014048485952949652583880908866840201957714267528357310625234716326005515709189853035064120354714155055638765168870998542276356376075289804946858852513413412593213749561547021111859047082576523126828340772737778254517113445249551858838251542558704798712325407473138845363748446261243154793138533807975237739650781484098826269039
	{ bern_num_data370, 127, 0 },	// B742: 143755451373397788256536713264991908153625861319614210998919963264012512451328679289207311758793295962715131611761334296701058532530156501781288379491985906223556556723181756368408241775758020241628221452857829533161274095812152603067810376814917109458695555642610218941312658751904801094233297311766589706466858434077714662656960256280913927877945271687042277679044268370977408051304733265865357480396123927927442225501433648315288671768325882242151159118201024805941520167853154877292549053951023203338896281026395973165454645867856636824206279545401628552681968352072541398198298585073056489477747627418298955538042883432122215821402363088467608527378660920762992941512901853968165682639987741878596449458215042988824601383554050246961271562063249959834938366134949120681828309159437904199862403129726316685646728245947334493024746979010505131838590117924617312785241496719745560239469446403524875153699257387133358271621454058561403072695697451378736878108069054828427349620477645550566504370077781567132289158788546283958786929257157945759158259603622531247285031162717686314224150130375557248636199101347938709573109524152272411838699910089152914298211379076537387168026226537872080294104829589517043151140407498616491
	{ bern_num_data371, 128, 1 },	// B744: -4297085274579500631937861520723742174957719749292640918797591237697698707753439339387606432354803701125133238269043091880287348467664936620575876436298556490226484749406951817235675441056389761839643383844260724479933894449645827491908172744076824612774182738450046796459660046974060256996180104276412280976517115904123988313548259311025624355027491643917790168329139907350567961337532507943882328956754221951866533301630275778709470057086198633902322286182239906839805933377631701839729075488816210085265829829246527798140586708324674768641369825334371497568493574130505478232942229352455074272262041636066274931728510705366428077032652411449048811762976927488794319227090497403944653557283341370763581760718520004957694637653554431167616487983722464174984345432578932361265138943501694943923748362600791759581350521281713046471468436392105382031916482270910469140664257949760940391103185751279909097794981108661369437000893284453442500096394505238120789241931253330992796824091385924290261094493801111833495570697758623703362764715711394186834651564074725903418965356860005196457984993058364891653139608081491537801446670805916847536406262098074311058644608577416608750371813646291509861845775568436192867127921123832496473943
	{ bern_num_data372, 128, 0 },	// B746: 356442193234262618531208534281770490039862481543500201955428611346735272198640685705841091760705764076984391362146961630735699805023821785273384681655788391473450467118945930118513655245265275080911964546459125670426843427777334609618696580373015235177390965402781115552770990355475218082648569378148892634224329231776605360901379408245307754557215586895161625048115899611699804161991792348273598916203260213382495757107603590326414870635602243141757291819067751208193452395841939863990553996498442899089174796202177962884723175479160127278366826558225593028894608023089654009778412546371867371497667277572754363028170407204121533674291678010978551702738975563396637433849155649315877441057520579547864851490152979837288936132550703457596972370244863323033613517507641434181976664849406857247718889325064862416821407081175083391146995303795624117207297550772336078493242927555747652857805985339138489530154780696958490595871856087437546697650244946683667341364687493786780498512091408468082775052104529613152718735284650157489964179752451994022234346223685031307576325273795597123787694498315412677744969344768705337410450929517346862354995257163771457037356756731385042806087265473691498939287844568702607389841782509575223663
	{ bern_num_data373, 128, 1 },	// B748: -580162175030906009779784763923714429020527571982946630281759277057223466429653121227792606543641334177987868051745496487410237589791913724241001374736847267208607262185477479560387959258785162153286874500272390532450585036577129401854776671234126487860399820088998397097731283010060151910144838893180157811625660826990964081560290141425031785867240405288128414136508244326881068681801148175561305675593718331532348648387533473751517265076741435858153075240338465395622333568511583303739393608934100980557034894686795124097315987176654670283102488942526417844813813956723000191461461096832928457478198892385031634791986140664850274292204326932377814234755884370685520913417171409857897165728913025806807116032275077167629461712772775216139810335823453483365277009023258214393279229946878675848111240333326436152275438339736088527141182946907669074547358413849607162736400381798996777046263426053944890756122519836911332225419853513430130125994956105759578534240643091150683338196169065940405287248781827226061304888468800299432498350785619908092451296010701362998023982225392428470709092708984764446419634161027421631581487501625307636958470396066179537276082776655058889856595759505051375452033908186041417227299180528004659545979023
	{ bern_num_data374, 130, 0 },	// B750: 4877282814969840857684263425220099465133486439064962295844199101194494595367802300060966400758071029408555200564400891713869064352359414975123219968358592332338586087494062177738660448362999494125238886026407711522071489609851627468038499099607512335209347912581193157149102670488205840629873253894652256164085091527580574571664697397803674934897099514018834401605699118860976239833063866399696346339390332599197255969579317400050047804685171925127517195244893975435599832376114180059403283296321699018924547511603595889689991492847705249796984360414992542936340928762917945170194886006655058606761888088556909977453245481044217194157883267012249868586936722021106390954980462079439097210899386653460591807610571383337782260647855190132906403069980109443979502171516592642385456857889802964230409256643612460509671746745829147862797397938228757191624175276298142412816296082425465521978072030419655558016219673771262630297209035898040845788276546257878459860956577225020848186311941698792095975627201943365523261871855487630026402769575347693503288315483195955605757504109687457298292770977451627445008945710941923411863957578665101422661829962672596423393230235808727245853446811836386450299041001789225689442194603029530004208376711268245331375
	{ bern_num_data375, 129, 1 },	// B752: -87287465059798584229468762271416469940015585849467396877122751286011010823101297518150778930365553652211503720475420196241089959832852872685810736700681190062417256304139855580933052384290087458838700511632475101792165137640430599367617010650243316533633711621003877444854656729232802143378506828483828471138454570043963157097732506014657957305494550683095963494309361002992401728276173743965503934565278178008141509322049939956072528340236796510942058331239925410738542258858442660402754777707160275005418564129149884226522546634966670845107833846978049509483712924208871294180875030767560845504196273476176922511166825097008778803714225650320109999134929150454112717177792546596620580380914980952589342307215172819559760673931943657722747003860103650894951140855756245535328713226021706594005730507200728720434667263614475138153957562469610393440260844619287108350007062445071433103448724595937147692556741521907299017945638529446691806408048442938324987184913211017585598527186240195059852343084068894319633749263823591119983417677489192033071799607641289043590443272815321495028481616667495346215286592470571837214412194969104115561736862263372346634483453813943626911034875445244924625359732575475239157752500972799882979476654418165217
	{ bern_num_data376, 130, 0 },	// B754: 871347827029321093198138678821982078858894883488777800866680359140601375076372167947777167055709267214201654827816027486904769353966641468125200307185495794135803340204649496380154765873147792039840653215252973711987401087724453477981361033620667459730385405933434547641916794237344305478988472963823756478589480355137573164994429758167925597448557707204983546175788719873643851767783004479042543512240541917803131251308643155730005776495772672314533806556094793309153728036320959228625177180963287245490161593113701295154480145736378611908461948737069940774097957074955917756421167055652958097237371685739913516831954641689873704855532090445284960937116925905262251726144177154992790584097309217537719506828707102706318300334962034013006334843271874452444871658698577421192255663302666119329730347745339260473968521494826608878366295238756683702120969030477309676180349804411239023409542111156988156526888724294738499368943354421419074508841923122922253427619060722892506810637400642128484225457019515009421298865256769344911314485542687719248306690968834416451299499407500774752970654264975899070534456616950252569633835262186196011288397039423888952915566119142432178188851304601508651816429621644191508193783854693849168688422085168027984293
	{ bern_num_data377, 132, 1 },	// B756: -338257188475183466394785653152018341863463436633286152605018093219117187210823581661548063044616817009858733023150407217514232306163153934451534245748552466448880915293751503852141735451116607693143614177343791730840145269789048204233838554768100622469215576914986725433173183046817837538105733071204671243107649377940165819556268628618279439372912926727358185372176484716198332258967416133565092301510825222527896322724958199963209234842384450636651401291205658231978726199616877075753573971502666766400029021285525463252842098441294636811499381140386732959993669058717381901785347016878623381959570111626159191771909802818391240568934266968269557210715060373534894964298108817045114952513119314272029205146104458547214874147731734268290527927401568785408100996958417865042021242866408373284580866172273572198379457872580681141908543365330070851086118336674738989361112317603396408613438543953624314654181135615383036912088942524927104606111422932425095680900745639055957926462910238149434765869970971988799202943194827104150690922139827103444104560801679363453935941218447795411614376028901270942194754858462981930751757602372023497648770976320322552658831444843271812820880988959365169852388054425953757759946328445976754588182227507678605296423590283847342463999
	{ bern_num_data378, 130, 0 },	// B758: 3103515363769150378594715765280224237717107045589942738922526690445227636726959203764579779956190560444822961746023520555168850073577538148242466885104789318865881078139714554662306114874528431738258905221928641441362885215026054120401715671489281017378999250601912513677815826184925355596146321090606209966409125166689202062300921049472672421375802916413647965644102477914005987883322130961401606707859754304339917527905249962869709229751877670226581001769619184931810262426371564538228955728113439991945505586022043681171358040758523033598690920102545649566582245663476281680125961447967205925092934269274890837648149035379596281289892620000107160451197231450771907603372634915828863903456201207414875178203997275723335061360265722870864121957774949346028622249141070327272945091638883445248774337686191582985612459404405963559399085171108171864189406202648133858367501713868825604295979766535539373755703931719259144008952708120157004923802175633095611086493293244188615637443497023225698105062565608550250155439253785581903400257086114411995870393174354905871943654748600290336723893143352751762712646829211985200833432854677243678796125965751264366413036479289091485896016035102995933920624637776471556167610654329044268501363206765496183019545719
	{ bern_num_data379, 132, 1 },	// B760: -14863260906377567179961363496395106795210446486155011996635673007880194887530464495945217475534835384624118115544922316253793577843478952397722041366813136363782898132162256372389900504917991908812282300240929463527703238044392034408067713611277577111087269786260873770764261138480983406675719525479147462362605636690014541507693132498320061815766620215912380696199801317075217604609053149453297804798188853126031366511826136618034963261656949289014434095050885553356674993081436709532558192233834701567196139454817337928691939884157838307399960797901159666321291025161491646642994744721392851808479118644038473328247847524059994789713423667589319310970031447723971110684466178348553224960057276102803429015674637409922578496141078650134489001332760678907029928994347874080906531995312284706506076125967384767020947477605979996393654273755866956436729701607580892532216479378636739443834479229508572485422804057563898390675034063750888852524478671520000177924843516682106643318682205417605583410944386699593010537399319459528864784577515541985657631244681031050851306418840118456961365737145322401437513094515446339560581085906866832862663663548592099251763099100396216983281770744129146118809798037823436298723272505695193180393863547455753673340844454086365142901
	{ bern_num_data380, 131, 0 },	// B762: 4662592519141217681032888244185108757561591925131504123191807757086418105309317274233355528747528650214734341149605539844773471123264872076804881883063549335712135360623462908982438986239470942183373441744990015033852686928884504610933524414407518919508631104539218604357199245961109181650021274541622900893941859134538460324185431093567660010513909040064496975828930104812786638922149336847676399030974929472623458906832307460880029746188945786624191896366262175967102601307139072605951350162799664853943794140795369198469134378512800851218215244917223994817712977856737575286316249112033634837278624788364388677812510362403645051398676229416934259846159292472794417702117983783226655287330750581931945293598085013041380455190340520123007771893248112288547747689706093674890703939164176604671078305621039837114907911242263382572865786573915166329437103489426776397322403300444958111472653693421101563930164254511919171245270784979600936511779710494336426136797005125969992569256085590439665112705098405061834612263211365286589141106935586330487254611408605823782141475158289746914631787988799690170750809305154636137916334026474557307696510755647074479838073487837626652057317155380856245530466621961912826181038542645529678881788583027916040010192462692249257
	{ bern_num_data381, 132, 1 },	// B764: -18834598236857832311355903849300224065216269211940679698161640308909407876923426609181936166323706820769488011542013230914048337501080233171864741606429652966333396296920028547623790419019645501575939207509010252431518209883398486175456145180231659067963326807643170105809308161725925351309881344390103297007547347309808536281908340244053893085823736238303876500362477847061327883145578457848769836848456805538589372511188405362441988189993457979460400845744679021207411901768211491666394758189222985599536634191282978249685365118748771367189035498345787041130664286634446900300945086328029817691743391367512777174724949718383494124881850991385005931153786113953027765854668972705000116838071029062537088818341370034502953913322002855374013943211295752162696265572576731626905892194707207138694285034475899054868057134728395242758004463736252435799446601963867874104079137563744114826295148267414187738593914127515283205306650422008745826833513848437941542910684023897299459675738560317639589690979660405754991368556813998912829551190838275551215551772065288538190679217061205243666158258732855435517605085128225042452960662801553523389057242271280844411648556229184436541095992728299459317388516875387946413128920860579489569775723826988121662709892240091366078863383
	{ bern_num_data382, 132, 0 },	// B766: 145988299689153757703130872724002647558987561107857157251047955986102162896902923043398230163593115177498607640386631215972976717780392236818983570945490627749405123506069943418224536673359182677805869430213694553330519277687009670598144362501794821449844030233618029675993866950882144215549321526577206665053412761590048268375252687359487244630793782523467463229537312012001029624396912477885396883336107736747726831928341462898191570574379744613423322017851061490189164815801945612758508962167618383378950337906092844089215882005704851959267418029372812781679453922222569167398077176237193948538917004911717345755236504181948942814187633175367627414029149559830137819815634300710454737730824099668679669247908450799453719903921230066618455638648288169326400966517000735841263329876494010105165059184925407127710317504716395067919330638130334931937563527749758363317007336466711414128668775378940890466363646448103625367120325380020954759578032973376747669627404646801879806132187090824005651576459366746583958331404804888473892654607670905272180587242790336827910363169747648350056652989379992591500234161212691995161637861397001908722502463079606410318585087987642973919875424163431315242194084840913468093871774027461583655839596919882152268976494377185205639731623
	{ bern_num_data383, 134, 1 },	// B768: -62339558488622736583034775582910955936400757674677329048177844203655998556937052928967822318966935051722176479746795745306985286162065124376690792837234284888249203433900282564049107633549882142242412858877886837418257793187285794418282100097941333774061780885130957705370145830091470225435620300967827566402621423674062459974941022428378599316528291950415047174503546743713896875029367938559622775705641875915570621354057171303620250042605082766947021754660955091945248637096067743515775094462124723962129312520629012905840035074938359468519964175284078164859179581492995143376826333674924348662335690286034951199601234336468345531059305505028713774566276669852415486561689799475748696520046775136448360869041119429229328858892014312821105705803766448272080783586314203249967617310158134730795496896882785360974545822452955994304473663241780896799305113188673032682835966126133357115198910586015256433727310531007759140493573178900393542452946680272784818314278518615280782123274905847836805707555051171505773429108580734064026786745954530800217880811756926668264720476255362105206304863709678793616488358527074711719801732115799980228142699045139456266596907821888590644483598116357556822924885972190279467421531734865802113573995077249714327725680005044612103814045507118847160598971
	{ bern_num_data384, 133, 0 },	// B770: 586882413739583895085368057503105513110075727687295593950163834594272685996596912080487661174441866721119448414808345151038997417999305630512421151398387796612754347876101705161575339502797255483142414248194966337161255561473688039356427340518331001232202431090886957545687160420606402437142100390845362616469765980546790863220235826283707034935965002783537149692314375543579224850131621337444648889440715360076850260215976965886106995766362344589206609304916127590113264757589009590631957448410883434625613476855728393880001201741713570970160766803552330418910936096936703422354768292773923912351978368085052087324756234338583302176849071818840115759744774068713299205660918398508296761473830292724896924269128761934282701464124890216271364037359271610440778800489219224395721091487182779174901425087441192500161884033881232721477518844760196522753563910637972355006668902252640050738598733243897368376894889831867342151098445006274930699993845117569911861885702727185966192278178919846153225684464196544798745196726250002219487623931740309879565003412090494528348148559761412613252041858427513160061499337300306812691203105987191160160471390027543413770879647138540197779243677662788223398278602383409343120855722912996175804173624393982666256386899095630697856708742237176373205
	{ bern_num_data385, 134, 1 },	// B772: -1903854109954965810802490949431302881453554457134121494511460032346742514437205318954972725710056888586232568891943420829581598331412986767918696914962860689321688343147935362799924910301738442847739939711259420041327877728095586273191170581853570202791400303725947973770573367709553967963196808394626218306579837656105208314519728543249129790726447261373051087582627698763907661720373467100461596548249020158344257827754393584067683076933813315401929849660619798325097984094155146015737010885243517159769948091872079522414340230573635538923106129836297317056886984328730481239204557307568171173675684888132310465131978385545756255210943819014560858088207576411838156888969585186323450558155136919134721893053200813355382029698644236707799840870404060026960895894967085257402850226560912201653265377101169054673270064824677222754516876702687864117556555711857311287417637103576744366617877851662658406286177671407015359328277656715673235419988320157068923601774496920350372621608578783746624136466451914027764746199141369200073959853883756558822232421929904092156914616600269106829608012840613936224013246623417842904615163510614275323976900460593606558526467278469955265519658302005261350919493891253682876964705961415028784106528002187858743367727966840326891889448717025338432100573
	{ bern_num_data386, 134, 0 },	// B774: 992879460119759483717129015496461304615233924106266979453307618660750625582823989325982123957244550330435213597281705162046523197719159870950442553883041937893243506514602988166124628009498833654690632467802316573822412183090091043232805404908369653771201317967999722957332448160842564743863071648916832031648331900562046851247058813144222043140893241799574300437398362557587095795352259147524384231440809503876002913646313226375532155873056379574976316908568281998806054802442787289248422184096341122810309789233749212652183619004312750589714002919768377940044753839331551383010063866472445241876131628390148401949251079758349752199256284509461538968960478068436406918430335917325145294085711445884208693040332794500032032689030521563418423574938724386132895855586765342341798657344674803926589569127520119224121902161661871556404988232488785345467071166975073762161286094867311891525833209825936200415010493503373911943631421694450390276555566360444074640774520864220058847605718783594148808763707675760968805622473198376019603504240305732254014676756892333508197113983193541055659926419703341041487977142195510851434349572228605153460547098165290924806159391709285557875199571638187878119478884153635880528471558016475567199135149929514655753042851616892608093996450948495956109416371
	{ bern_num_data387, 135, 1 },	// B776: -221191369830392442605100490401027800849749507279858475615450096308527618660450116180416128368926392894260562370097961415340583854508054475651507274647974508005989356710279021918822810794678950467577626156146983844181130605797670880252100965868780158601191505211082232239984228430726070031850515309260509176582623746671774466124108119875856798035502926803077492840549232124237422289842684390861372823690232126513778313562130887398748702582414889675124163948782592209356103566171573648905975159159045105445283429407097420568612560341719481240925931639750892767477487299742277494855287217240391408301827570477855750513857475962465932251241913648313593443577064827675795274542760012100828546371384097664013521795862622933678369265384408532962471521310818872637038554972268747371723405970351896712342940484997114512487507958858401865323447346869434030969076997951666776213624536354665690165211557993616351050369714018594400052763914198870893312755184813342660711736968282077919121435990218098152497086606140622761927527323329653328930421941271749981702866939741616009963191331275256295937588190770152180544492943934888357805558472611998163882696253108778371089392704692109759850990015952170940462055294809054630698706852756065637544187825753333783155616979730030348267914887592590557137713059171589
	{ bern_num_data388, 135, 0 },	// B778: 1741363557988658936522021848083701571067738385346185718048537388850152170234107749111364864252587718315493613698302655929594877833296076632297690332270010712268256578143453873575974504845355812573803426536631231107444662867721668911643369059122000517782207923546407440654730498978620247119278987799814418726308616050249330169963942487830166800267308164304287878537107436049460455469007195139420124767114551804401601356126502136127156849703583497384612217411882248875122897151683738636267934062318947579145694865780100548961861352239808140968622768142776973903765967734749874303029327302790082759323040313728261040174931413501676471609461496073225177857135664817971939286166020723113666634013955884599788828415151404647636436121959761940025702477372842712601651946369478672778746356148987321433905850022132228859029892640705109386214688944471981306522730232950588230764375795702101836363080861002346504396377315486389779906133809341773112836731945500803855720615674841422441376362958930016332415723473647176245651980840444054608789169734157191950967420411252113289361939364356530537051327453855841859188794142995851805531520954569876763877693234136381666968584939972205698272494199981571431462954872462571384329829639908416211446004529069824480918538612545919276667062774946820777919291415711279
	{ bern_num_data389, 137, 1 },	// B780: -21843956090890437815941353909678183006951748071395829125367663689307092517790111878333020292892989877131329090569890104989695007965651048089262353079700998641421408231346797674795906780318511255613149236570865898443820628009293314196543489048154486258797556712980945344786413788428275629306971037695783650263296326055457144279425017550126813282532554108168594567493718012845965254543017415997964231527789873728734716829608956674643278210900086834230231742673359344058445616886041095258911598984075862677429565711034008154562201043934743632651793167160992270675975016197313305235619672856830853151718449058598859792858791316026735235777145057689139405747573086357016934423310906584970525465206171317131992402516851356535841465602913596969532583566443831777072412907496269585904040002214109378645569543632203770640324924365437127920525879202188672919299664747065626978895324650829074654399475322128557056011005540360511689094133106506650887479013592719856396304749993477980383861662460869645904048839541970693287361337249740450338156373313743763607487364657566106563392555011444962526179730040213689969658678671628551900276834384960504712390685595476962099748922842291866860247077774981313691760010405516444791805474877986160001104079222821365385170437450620962107849390824231515118951518659273857813111847759749239
	{ bern_num_data390, 136, 0 },	// B782: 19487569785411534942163332140520639280864288949474788326168830603282366384194254927282762508144637971901444719471908991369276438005477669302088813404267422197164144403299246780904635953689467192088583658877995611664931102814430853214901628650165490007164017129618646326859643556748626332131243039875436806476072901663518636142506269678412352998506275084135351534896999881875626223152016210013977637203661284475930181652023312165602945219051768371376823707724402984081557451235901243866173633149877300159245266683605977631650833255767596689115952021762420474113943602166252415989889176654693154786678763228402927689985079144017813765153062943416263157682596290388719231665891782602247517589878159544548062902849548743478435581503072475900090787751846599636832558339177548823130897081018893820837769502454778469835926953229706350677604152467048041872863643995998491634094948630683648525724401841173251466924315294783407676734643627661254754350434796253213643367232313707902878953096541040098757524171013256512186339499318221010378586978352817084974176330299659635891104002920266172783548547029277882303985564054526061932033266415662170956178943924148384409412967944512619483388420968713472114233139494434233336498962335959592466975157737052329605031348040894277756154255604985222555040325941882643384627017
	{ bern_num_data391, 137, 1 },	// B784: -353785074370106777412104421902615818708526748201734885581938377295505641495347366145446561303418061487058302215700466975429856769556580668849118774523625911128112538215528889896152083255826090140860514333282688297346712846821483934840689571596290599885159985657413415305133545537001080428697833569058102083395747916341210789241409534512908185776279814512565008303279162549501804373343646571975002016994718557778625797330731760916668879924715049761101277319841367041040323559017699900847954831789264826044552105794079193640699819041409764308964150877089554412219962751156765027126014192377222983409459133723142810648610679475890396355225613625520730973803217598069802124141439542042073151239450581650183185362607408901181641869715776159760858334748518251768882228752816716304048142033122296039859917366023804060264126084474669699770449073510044566951733579472490453434505518555868783498273091028888352352909997197600679377364715626191811283806367778467177326856258845941052340870352643908707973380798659947414621938178376760509803521966519353258909360784172654704336987974808308222364500285016699003422408992434239030192498800644775181467532760269635622277481105093703528541334394776878494794598401791460330617291972299492537705948231861678864797434044359057322737596398230816979826550813100433217390186372301960673
	{ bern_num_data392, 137, 0 },	// B786: 145995308603509318051546893836312952089283098553172335662787791446974126234337408323402067136563580015710280744632523494223323521954458500211188391773397530999403144529759438016064823532966809918717486964933291405501244106602566120181899335977431686066380708165262556591933247439876604960837309960763693333685578496421632117968935149017751648844377603121632590050041176669194811407879733543003925284933368152124575030228296528423758758258584651123019711780048021148233560287001427781903644182171378410260297927585663736506355336388240841302288447793920366641665596887351956021682582113853098996767256198203689227007966533117976625234617217868462740209235292196129362702330284807679593779419771944031257889080011062493058507548206012794522175209821795547316748202637770860454981347558652550841288961700279652272601094184189702182851946471992908675824328722421164073467300610839200819698121581815333244115657915963420791565576714602529172031267512497644271825350673595410024160450657339820975727871790976332186548591550934232705297140126315441061019587895692052824273007132542929797344410221697229236797041231542816288763798497491072411702637704951069376930391336714646140656853654941000083668434149701818980822560235210184567458450587142163180658533750299776604322156239382293621067531876109517401996961677589218094461
	{ bern_num_data393, 137, 1 },	// B788: -7914465622936938662549385963230931692287779254498350834276425504609288176306257055861397460743732681742795804161248610519581552402462134240443481402518056771048751292592015624588191568334454871998218322845523892973451859978180570116055360231272395286166375253877870178916906128863169685847356809589228256679564969517307707084764594829844943964316495551074095864798501833695522760954866025767570059446269240224731384322059095528327275550152093691892146207673094451857319325608083340266845184609689898699841872398674758370790397439830462237710906934555650590226952425626550135033707657325234403316168504557120078911879867875078208056842060212002085826560575059192502344474060132656142679383709366201267874365541425991905357669187677549723488440518494137737593184694380884905770078265041787528499617980924029511567777994760911313036248484363863142510460841456069887326672032109431738655767622227363767996583620431342730982920073564772425613173886646810077795825326574441677487058582897974529397612758580644703149834121450716975092953185050186009138790784134103015564270876132820263113221528283652433302496253250963173305380493700837851143175895415429049436704481100366970104817235476574481731301369905233114052651319352915538490577793985031635024759460766406231032467474212666151963759332108010269148650882876373791001
	{ bern_num_data394, 137, 0 },	// B790: 274908795917755175125164392140272234963391636101866548347166169459527828506545273176756803722475308305277275387459231211364930054591366553178739706751635396049022418251720849409570962574525339653450991438849888644206978442421584848834672566510807291009128753277936205321879605097450517230707926327530885762997110191877480604319517271696480731423417237450165086212621573184931610084719705247685755633097004816207700936559770619819333150522705449508804846647799540496074767462827279037208194381750446443269630255969005000860354863477554490818793276625657671530656814168686694987937204719904227614579916385789024342244278190125999405389470691175587536021006942856806935452365653794306528297816721194900883241121233060083418746664969953119066028952240804028655600086594569575843713294913503075422759682461152720202081810853174393141351421082008897586469439201923179206750583773735751754941201732547443166263805293671103390920708768115355562025046331789466569096151246442165876617361052854602394286585849841457235011705366896310915539460449597750295352677685926166146467306988276420646618550942675620881252825092397530022181641195824193271643757728417963051909706604572765099996930727699488921444073155292661281293667849053615420068560613562545445270513379234267805036656895541568611481932297930852455514665193292093145655645
	{ bern_num_data395, 140, 1 },	// B792: -100337595466791121860019552347831917017526640965792247242267664236709795266944143323088523498556848362163888997493697112470789836090441746104709398160027994617887513172193438505007703604800345896494972896792536757869950548683342177299197828147959834604976166602074849988217477018611198012873432053412223910407798769258505595378313916544384575609388242888883562338299937235699382086203647531423274860592131405185079852120939971412565320526580925270420145438223395181304213498742786073872719257144306176080105823385799316076859123296335504153690005822720691121660610814387767017684979716304609660691562888800872990896082853975846661373110385635886643578958104814525526652191709290991131331139032232733169680378648586886600915001258330711766526099890088149548744035746469489468352722552593644645873442185236797810735034646484654534795519010503372806595168392663159203800506415358239859410038973501831816862682631214890603569461699396635139954770665901686312814887077450537737616244349744187220337502154499911830275179706103400553805084562284114125688327446216872541016935431904840026461732837415139693373738982710631248509205670276111696631674894267511225352730860975335797856803894028584282879375073316771818175282053436512367864100554498975556471816369711826074333326691506871270814704308571212513569383801451305707022277673385557606787165763
	{ bern_num_data396, 138, 0 },	// B794: 6325164603425047977452360155775075165161860984644518682354030696158848339915567364126854544232676897208294767254764773951173713883956318113674999881871473875007375230473141145902436316200032688403714288975726329085741622582820018009311524552330434297237590376704670079139367806780547538921286885986481152737713472999310041105126202650845028219905515004234985810155773408553014793639380257306066419162861441219593146617034169340832237284188914931283650340375241938774077320355972778269597589351810432370021700767102854649404003347286291800682247932067952660916126657737698834500330709822364335481380687004089225656440157914682305690350190770721243140956186281334939258604606589641446753974816119434573112901306178913725748972157907042974367858778655650342975851862049416148527018041863460331200976698030293653144443321390019462626415899586639687580417100659635001747708535766453548735003225648683944162285576942215495224122973292504369326841805643356630942395832696801280149108803675619703345898454428814852085892854888932364997073494187971512859102362728932827859880459740732529877791539491357383015834121267283377163626494844945345634781463908578391132892308714045728627636785644995724645692482123340351540617445007963549184890934802963966490514545339629063831541871931927313493063944755167348059395553472683094906461526652047
	{ bern_num_data397, 139, 1 },	// B796: -404036515780513482847696468883335059169149737775521724663862676066114526991322475765039707543128266287892799182544348536135946129435812472886367192321230450182625753724969462622558076084944906994086879104449973582846721576627872669544981936816122634246806201251184184549242903082304599338438172663849653769101140129492823146008683967606170355024237175297833338615238605189081669336859346256222059312155426009106401579220352364307851754053048467722497525181673532534017269915449802746381294775864079498489677151625150763946937774410006085384540003328383345956880144397108185385014327465706691786319160917794604108572517486085960487377714888398250061637304567118217729326743355871624190349736529098231269465433396707238955144118052489170970370996376741715658284187839186618216433939476143840227514303569535858405830465560282676429368628455464585310121990089076078545214327869760698720616726731231696825917804852768169692121066082341521167957826045397334698838408091508846287661034836053287901616621064062604840224192663566858236115505276730153692347614277258233033047594636738794561595604943419344787387299913599319913670687222777409396744496266479440047917305311594185443469603458432197624948494048086081725682479923318168284504832252996300431360448359336532222334691440024290677817029541591863112249882967023419058824571779768734383397
	{ bern_num_data398, 139, 0 },	// B798: 491654776997627231020428229679372887668237995235517431600574583845975623052311528227742010514679512300142759642482295942285005885537507737856815652180610808915994797588015859659337176771034342797120835952446709912047948534248474813827466447567128971312958419642814916123522131511273545855041635395894476835201357061406270990809862481707149801994634427210983541848712954625335792476834972649682522030692664751588129214374599510941132493120621093464698480649819878221727553247521599723783532014709691019615260597532449373496465143496730819997927709845905125037697252922201040924427150893677423940907348461106071373166800603513563673600447160843273091981144848937895973519156695685071882956056341813598888185108038974271483098746556380339950670993946874324568368663619511469030929656035586715101848334403067876323605864794335198640207602638026738296560550845116633560492135877671628247658634893587643662716642882732167713875756901139927994343156941336085183294531460665371411290208202779758572390972502196086934104944407913468186818437381763545672018237122518626985333523313759828533923190036638664674331442177837036218878838814166245871969229599150848148182615125665487808609153091769575233314427978772465197428055069018897549733620879941215263896203077146794205326237251735596752840440525635544441107223512217556828614828934192049539744539
	{ bern_num_data399, 140, 1 },	// B800: -41061235346615546657396903927228785276886894412732487888167656661591617854152684694652686517113765365165395222982225448665622930559248908904983727047290410221139110076501976609570901426618375630359578469182035023509649861590893258291215204517686529291245183855019878802793440500200170995640208921654817522736541334878136990426983530696619017220887966923741417397981925913606706379526652569468956082459010104411484648674686538242768414311868999866645935699492586483742420943225309311759617255659774084528366192706382681745469215957749267172866285092042992436005591429676439390303307555396059861863617607183352464687870494370009007783994669446388468248453804220039809569912438168499194957749658192716353785937745532691438746502611288741675237116958243936280705520238840646420246659029401766836628457975058396933676799835625612458942415887134413152855755929547330538168973013641404657275840795035865374776542748102034586989537366463148071494148266959586797283903246998051069644831495646440223587160578412529616599697234922984470284673813752691399276111329519188859787099643236726316124689515087592927387939156289976668479644673348118726429646553860045573108896244959944531822788938204158488489370769236971264716356368796781356252522641783452637720264150222010375658260796450297923993638100853388201919914809199648992288850412878735155812371020154766367
	{ bern_num_data400, 140, 0 },	// B802: 430346172638514218151892090894147790061661904289639335139126258690088813533040666517830078975865443003981291523197221891741746134951165095583438136200850986997837171936827363861214822778125336120305818969747550910949979033647634125762480722518715323255016754096337123771402422290772328838597079561517101486529058552686439968892885934609179585100446632414077272590223118758559737702693230016140514678146247486833253120963410812847987059895480975618289576701231091404078778092615167558673706773078960174643659371738814525743799517028656678896813886793071352799372468193823680065373486605579379330255630373048698460642865739359666519657000701809158419054075775181080019850895821478281113561637683054868911973213193178202148656433160748244515927063070077647544496955453362044465025383855252095947546738338325306428555332740345388730687198889107861306200321863611263794432481530116060109974072971382983753239179685447229410885686649539393354382415296678070867328531393271186989703667623820470244372350962414707044011288086223737006251864522552242949903324982424501105374382104503272881523524912798988685898069039051391291597883423585492434149400687210464185312257171692421727271125536556386204485862854481981884462157649752160326049636440470492665626380397291312538739991632288216977745802678599961903143154428269157462504393965546950338243809902271
	{ bern_num_data401, 141, 1 },	// B804: -861377411586601214654266961132517880043222268421169222661765206472778077519094873262267091344838580372579305465551190328693012089609197834799845533719988505166680069335371984621962020016540291990213464178483310336011630171815062898855847566717136530666237181403028885239325301508682521899099802007137789263411129434471593002199755495383018554910170637404043305105694224672106943910055190303824350551561035174223144042292291553498235484975236783124247006415626856654238253900296765788629431192219179768119806195323077623743293903574316929018159422863845018569865289756154288115587973241894236661137529017718145426245561545636793610977437587932974350422546736856031463317443454770486757372559801539866074305330397532552859070573951301083206943736066197080056601852889476756948508282046145968705521962573264752965576411972001829986115605305499528026796561570145910992899391638831423384584364192671839391605465017880341041312759692020752719735932952818339033800808388838634890573242044067648187815005653700253754231133636292465580088376774633810953068862933547579031985490712064591779639018823327832067101145386845997166950717089794632732564166760205292289288254251582556140168807711706222175928657464367449388346689255779444275625264051139358638837502534091754564502261096276157586433528245173222023478396811607705567869567205550600239429093908862765221479
	{ bern_num_data402, 141, 0 },	// B806: 115664740444369462677289497680892703680335302573750388428684943056020599719573442785759887992834232465048344743389166628048931150682680480165367809706680579306110760355403676073669859375214786040852529388470275878610964615849698429067156682211924045196118479310226387042176201766642097270693228626068315054968695198199415227689182077267307600806813815695951559678936517755058281096094001236840862508680430261475887033065979491216512618500973454454337946948476012831001905933901297652312456873395898407795568472050978828560706226955524721850967628652315192012197392904147346220611038688944988084532565792675533923280728194173526063931800892798635835797903816838422918744352843206855224047551895335106924497640679253074626385783101532804397524966109662732225466678187663657313143271570240021704844684334268954359179264974006448234509480627082419435213288876653990207475659679285282159514046110195205813634823338424862786511404947751839268362783094259988043060860254217132716902915311451105135964381781694201492182269211315306736935070408003800350809367130192563873163166568605713381063386646682117703762536272109370477485440282482115995788352846703508951693503036954192797599056166424750992182707819591898916184653479279306705747244904160468228217080180371592145947897093572288280384958297952798820151610384814533915247065562356018172148624550697146075543
	{ bern_num_data403, 142, 1 },	// B808: -7727600685466337020294147864029560737964147808197609461135193395729249571000813905035225983410782620725301046014810948306708351659822520643834465010344507082908833740709353817701300532975541313644046745526303180021134819806989401002942518405132634408353066254208894231422753505574212044718988815281733504301872698773516197942840050854165225286046378912981259481134610765392001012510781129922425692987111381404764212458162281126744821954107677850938323290223034020911847432840359298022701930941698247768726851039709598394591188518360368744444174995003860431308146163514708665806310830355047767530300744068233122255354804152514148597230599818457861770301726965076864191058318926820079260047019843157383810355452164307440699694948289455920959450137206605016583577021930328177803675883548197916377388920182959964245936561347839514098865823645692803442413418932880050168803519638263040543068397292855570212325583117220360503035870111446829130791320770350307467217635084297667487210440512390985362901427305613578407868901433118314624953697835297161623446711474336609249608726815607850163623242176728186114243036177320729043317224202403591913520547901906119621969905594027354321119709577180795447887433288701652299423731351123855681768465503140623131035760814969248800149876845455453513756976514742611974666863144634482487525791627482710261778203320410846581302040809
	{ bern_num_data404, 143, 0 },	// B810: 51520933058117038136661969222879645486062380884834585440240919056175354662878718676631856114084970982390263270044093720101685387439476610322976137953382983628268449849698258185968604813923417628379596615450052650269597824106615560307110588097946844119005712630070910023333569838100347370182289621548302344964594510084703901422418305158624631606420108512028994921788110192108379574302640075350464986612212083806269376411351239483397513950783423588515614731989450787114914784401808433132892268447986494458079528482584828135876636629689180184744955107263391590003461008285542488944824471304082161161571055046594070372273291165224739632036698003758676189479933175789247939591399823815047459818307357191472243709621409738932926183088405353077058728513284405166217203612391449233587340742238729179746874631580721352453355351862309846842191108027136573394158177188614361136580964130251186376655154988148458692177386797891564813796855497742742419542014046764298786432163511729737666360432699913872115434454154304072243022025874031673925490951685709873327460539298665988573585322149851450340797863792459183683281018636293825747684940829570533383777181372382119590106669908594828660969742573363417893700494487084188129325209500659203403632659746301629346023497037722163064771052510015227634121188202318288139371310348305103469247414228767649674848236802761144551837108103892028503945
	{ bern_num_data405, 143, 1 },	// B812: -4525193043061111799565413937127745341168632798243173047820034518282560435482017602720481632440496463983650396970345482969591193330148807481049707062663364890285401466764089375816684084983208876469300038115100401931327503369588400317075682754440769622133883898504267418304238647474934293037112987731599510102128080831757228809466199487325392103937981357314053963816590005744021561408251250062881206910428844910660140929999746214245070206340442371589493482239106154594518642658309526783064494790202160769120330511227920052722147994309284798744896244151907708410741385111498579452318348239080121620917709074251235452118621513259537436370127007015439278731830449211545702267077072867495731166287609351730002583295397997852998792393138887178670144792231890550139956862878760733926364855276172358064319462090381114035724064248083144653233662844354669195019164020132371330435462001619889514556843265571139739111451761814584530345654949752380456998873806004239305998789204493771448963302935069843886471367886302900615017055203483364097172610406330423967771990170629486730326554720435222196076079644324230610078735114931283546831138884398023023142319997098832599539416597061345460083279038138527986425842904677786162126352141631309118044499375152967099370539747874451991381417843470975114024896841205939196008483463359274182976702603203674630787981976832066217551389410978174311
	{ bern_num_data406, 143, 0 },	// B814: 203938934842581728186225525629022366755648876178086465690278973940340927752287126042355301446611833875597622446750660583567312553504639197892705557288362997565115112953697955426440871451634123349183301098404691973474833652915385504221617846923950240658215446113909715461949993807732394544200107862138838362138828792207164108898606236833936919078238779948956767299318749565516307315113353671685701037833512019172607846092418445354856915260537596806176277417497588851800355799561832783052220744988479886826907424473039313925184292546795395204775719427502115515015423356030239760339301343256077187813142947302723196085837770548165287435799629820234409285383122010600257493106069270599425155297241712194053496280078109829408243281178137551814963639658261292662024794681703609425260087156355547061956106963133762412791832159674779370532618569764871062847828273144409165694554706599040060848989620060299697322916184838763818134987367549489238475393966511754043100934620932050698517439811896494022977459599179451335899781638552991275290925186072250708221864471641903344465039295469917346402565746637252174392447783389583431716320018553684420153372233097947166084824787444873309071890019174654118768194107114561449384909943339163949986207264150843344038731587010387943038882049193973106095059954920718801372882994596014262722672334916397549451000937090198825284798566231017531361
	{ bern_num_data407, 144, 1 },	// B816: -6668094704889765006599061158866306357800063003699378697771677901686030148864596275061594965336094147412882071039884368584435408964115332387667278903448581416746558592909527986054550229884624861665310676140261753210051716334311264932648548189340758658345680391436100737004754122099149659682703864534293839361517421262127382218716259347643701555338780948029910155757175032226592402712082301185431993849051725519237925948946790638853451086678049101025504118533851611674484901997141255253924050342882134548015071074635952226292925174022284144876424749677228362694832409435934967062047373151664441721673892438099876182352609908306898822398852630484383911404849996811599757672676143706020235771371470161635611216129923212658548994607842763183095722325247801296964840455060031793915860299421355552456491340939533368451062751360413868936858163953689803485495067630493312766135411440114173370279263110073944264148568607290838799836900473037361594774220225252108346705337563421948371835137866595392864153999379985563398832331882261213363434281083666479918942067164611274413703980782578927945588484190493575748009263359539112281311988976625807644641893059135927550370786872887771671123736073530561104487795712565111010864678817806180090734921480541893768110911559776313320073942495626904831947711227494957381667987239071872990147488410528761214903980809599898248988340959256681135801734037266653
	{ bern_num_data408, 143, 0 },	// B818: 2528575728807045851807385797531306284922583980691726631975981765714575464204261534148344905728778008696081630975508411556996755990511694563605826823242991671472150161577177200454838964350035862164652700525627158532223734734356334521056330313268354068209802820785117625515278233310337901100449585940504438323749916917368964911324424923514347519868253054695960223216588134543772788414544471909827827700896103672936045074899727712518479577548959578785334596869066833763638927239570298541658674878497424537703597741766786124959697140265774240510959840200274679457294700390537932913951813910337008985285210094289837921776051070145529706650555088241516961146720510850079917973526392927866961102096371960013182031660825519453273146049121972655544711689668990460992310994301325578955006985067194341730455908349353899288020607584970498915098034519415664422320041838097490069154685743943189589773611168137856921783074948335550391231150172650036932629314835449302562744606701997472399364535091361745364396903065253198084649658173497156087948060342833457919440244254879112491568778151282277729244701455570933544833504986978550166983694279203091779202046395338393919501683088781787841267379268856875333919895927481544336732546603287459622027707385324018730235235496135572615583520723796369343791405663014501692782444899061757098722141888916070634821948764117993011890704312289738226918490399
	{ bern_num_data409, 145, 1 },	// B820: -161212206193457835064768659530441811763767866502745389885382345011558196335702738094299390208406616635117374726695364268171052719710273601071341089970549786676530728243303287357377299329536533306932694009109468727484683797704996395602897546932972544649276691791332086973612721536871972103845582058779728812757143266997113368735626569587051994421814573266763054885372631411038269696171291479652820855548140523937433250308707024860225802580075043348957538610182577718062439866642231364068359989722239486790013268553175140953541202128380516235277642138999233595086494423395988059628550388595842759011786638121647169892764842224569066347630847949338446522805504610794398224495300184174791646886833508146110695295860255610008040760343615573490175742086390798601692149387958249560741001467888004705528039312287128692324536933164961991044579809302445113395991735848763569204279512273321760925185867193770912680362383416348918799904198027445913003974110213405967526760550550264608682883593852587154223166941986151226818607881929573028586824191512904993802211347347780054529700459166546639068271807915294791917172253367489586875940042088207339337694897245068399671836999051137279672064708319423225382947753559479342511488445095358877516493445385036686176517977663526569610393064294780381225149098920353051636751072933994921049116902484636274261973149613668656885767036584206769198529898356458077373
	{ bern_num_data410, 145, 0 },	// B822: 4236108698122305149806774703666841935855596753194484876305275846921512231518627201769387306472569766019259042421589495793231214199815875342061025911078633987090972310617018677334531614406186554103046224939446392971910395759007623346194846201032082974452193814411957566568686980180249049207223616114277001887227640213622815483505675864451834884660237874649503475788590132360927916490717828313129581618926001723146395404653223045737490615223157146071946268005105158273612774865242791106617141327819996066564663181455308070334708443958299645673227772110242998291698332498643296782433354420586012634264293754628152798334268766190855766226679419367697101799858868038709000277684963446797247024757552597785818054769575500291507482418344737307470987314999871477081590143723341334487596361336170592706542921106630076028774750640414674087614190100184242975959271353262924849843335962551487280276216924150679761950054193893470449946307098803930236553794866636713050165161092848891031665508932401958735580899802755734486230790699724651294437456212746458031384453698699838168782148547202966302463105341136660349718040871379473419116016552526280814751992291901435378193946882709197980375599327920350768195729405518950164624995207214172405009336476623281641105256343181257546993197776918439717304371643517825906605573041694312491619884089300062698897335497301716471404900002713391066190692366733254089591
	{ bern_num_data411, 145, 1 },	// B824: -63154824821613584418238507808695616899110623691572515166591232729596298162878199092430330335122645745577606120215779615326177514413858338436744507901578724047261396510120916002233082773493681938036093388323399822465972488280495983204799437162955804982903054438036367572903408516638600566783369251525614250435306965342899592013294551033794789904304288212750626547327432785033671016971935504690085596926928036566058877647056369295115984062844289727889073871822027877652852502454842797517217905431393976562861488110491101984226786333102761632478651167259096743242380587499053379852608948289432496355850358040741625038260511741449306880473375063563933215357071078515730923703251685965122135840739509450473065444450479146836754931622161151008909064487574056055337034043179860551111399635470836805974864281378973355465951736271010692374653965835887244681033963771218630397930169557542665064538347886122238917038488320386128472000370766449235174109182242927140677122016209104135221323609213727231024994666846877196729613614623241147462555489599293099432091110456278853293049799075374005756716699351520125620236457340688040269737343852302204295924263547882148707957860586727618917955803691984582085258547715371463532939204127193160871643641335047396810971376199987947037973863227392425168539965658659994620953391994861215811764340726105066905015680618825356121092066225808119715615157510908832844001
	{ bern_num_data412, 146, 0 },	// B826: 180308540993492302485705903430892052654632340051200269541259397100497658452170480351343454109861731935554469477192706437373993969032734812907392103342102745311926560840537094013322952127185687803978573470361566421688341063450859131698772920183253464178496272507902348098643549758712177885541905581556177635053172780495887945706910229544074827452565890940607149085387175484435346866653245608369978896515373805388304053728824794901191197872161283440544520217915521602102451409645530090094714840432248140209828883643048672222047386570260536527278659163675863098680032844663110226567918775450475002824060771648782371408817434387385437942686392862512494068395744725954989576925142461322194989504283647225279722467362906142793865580546138326705735350470939790897796453126193754886864382558199332367349385324519420987704845616578166047012416552408358761635314673194336461454924744734410391845282293199097637249249265865512173275306387855027182975596171459309801473942655775302271191888486264149667484184029362569528720306221671606038782034212401586722096494140221403390076474073852157645966400729199312082559787545208360470275203123585494770515381811698211875887911281709808059383848736302753411273122361665989151650325495846546681506974925383633340458677662248491239496660174028843053210010174483779197086969150207676627397872132528603927551155823923541166093601145448303559880781089151186578859188412981
	{ bern_num_data413, 147, 1 },	// B828: -1814682197697697490504189048436543226043726826712369182231681389881099359619418786291399614776485026332635401545943566524241635533188848796374828500129806478017329641789926469506454883036766170494769871098817731552250188306672246233077855411132747379179045301661097533740579611234912103877643823431372158783516568685330657104508126312524797108775385725396612682918964492179164231326382042388418004855472967100538779765676101454237905018998707807605139471782914062544938670354375808437037963928245014993693937359341703299020693416075946361916511042039917965456792980486625350596391237254308778591939432882367172763455522251098887062175114056722691177214360119289863183600247060041380121771312488143117112389525204339825378215179426858360368905475079507388457798028675070959989527904114407049234214089265372000935406171146627864822701833031711125391756609765948945114771348022345955353193269521595558048680627757668356069022716205398385065411641831695218211589839909332344089337188532201206439571378364590966820035221654955646935026123230320424406244836976752839201110200137009906329512335529699256659350928010514649192605418011740830730949931306899843755192385253642816444192780968622667670870257667730968146123222181549493758542423313474367140354265695270251886294778253282481461480773619760411263092551344692790964755060454733249362722753274318967330602410930738596325949476036473682803852078544746108291185294497
	{ bern_num_data414, 146, 0 },	// B830: 121079032440082225602325384320920833806928693294312290005044081405711444069264014019698592267355268859112157195649659754118569356347448949935246385348516984067811237022374381204787341841234524497713087121267021725642301629704069937699705288082214968057870916091994910962559296553363112978233444350940558848705336375457566965024448179854498452271058116105183596374881253207436908636067196630691803380867556983798332675193578474901978097598267558139649073757046877661357043148808366240954160825312927956032599728082137474826342516792240521289983553690280616453004794942425827755842983585861317453883983737434146184604838013723140859304072961007390430387393097384859400591643802632246975495163449662933009440592778282135636445185261983901590910731803603976512907248292596232712814751861500775012267374912075513785415542882231516780526498783155227367818819137791984845551224527148894637321593968643085459543877854349777067400558807607248759822828548509997979225998395318354030073014631056059281445551471277881701917785213921482091229292843570708978919341278012870078552832716915215105212537845822157527039950172909210029586265251034673940089600427898122533058257656569998843361445201585536600146552069607139897248764721138506995884687269872520617478083001257359615356588591666756664318345242123935538136590123316231364409477939122624333003937486890609381936452881856513074989290373803696379734223043935490254555
	{ bern_num_data415, 147, 1 },	// B832: -5200189788776545404220659097960865538776404673687120006764483395358294453511687724751895870371112409783949567183705957126761275246445747948368070930803053221280616197792955723865531531604946821511566402511613640254203066194506844032475859188633472827868335627921954569959707077697049607172511850176213560296627959072521198888576872590481380120333236772575521214117124690316918496600918245624850130617636861936791211691471069464837036640479524830955286856042004184201561916827501066249881485832173292174831593530484601380921832910883647925693471668531752010667563193315747193174283898211941275522869572338223549493230863992766834418004616524156985580753606405991694270236359518178141472248039963173195446272125460597569974370347806608259933731110879382544532185235703777518422950074442708458835280090912460447956028888971921350252030598281662608471791453515729321269690663310303095161834416530698368454269463075730742053280806348184533276695275368748714030047472789316164076665732160832908373038462008704361924703852682644599275003890749290710014536188025843772896385050787648057751483378827318673907219253301622743539490619495727611754699558917090716296928627148470992437513570711275264800266687532355695115516302615505013453962396759520249508141490931898582593936385618710974880132029567788051898893919826823698465542012719783515622169695888946134051629656490038220715275144423112891802639186869240640637464501
	{ bern_num_data416, 147, 0 },	// B834: 142191538799097566170028640483965291946906756111824279749547001649690549225841942284229434461622635385108125489015477309157637450978570019277887012738358300073414637994904722776793284463008042307654267837355954336669169463706433050757099841753792745256785795587061251790111046648604532563522922057493685663214303370292457394637654265173598368289095885597864283155549130861479926494810668342012441520507033146054807828945434510663520319700862292177273181639403938890466186216001294997362989961029059998329687522372734839531843045577140227403192642036755485736500283070845892821574838266041600628899596992374644852102038562791202379533200643557569796298969786999592830827194909095856246934521296350415524505880189455413344398903938140399363266636629274935665026364077964251610587233458646129975692267341822728302755243407326194481651274793215807383059370284924299746648524012726716891664116665861401990367439046517410764298429388494592259728727878194925738197447848562549768411418815057942998055905539128564098198397831054872414131235431027688166741705671054751619344691870353701403867371935633781385988934353821725110329182360597797307914410346060620821495484226704968952711874044981488550110257528207015194354866046718443661172980386892065351500501663478580080433480419864519040840182555768458199155246018651304769310183965686173438007277873360584251189016331834357977913071884316033384850213595331643981095989369
	{ bern_num_data417, 148, 1 },	// B836: -17306952179794189355520182673758982816003822367400941899519142734094526258564031758287709274221515020616876736517281868255740384765817523545081657575770136081577093062390840733666105716994451317879125418751416674300502540661483605010261848419344063492546490863536742450368217888954963457566099503563601737091019912598133816941786939616618429374868307513039878117328402536110296353891753092430738644949493831476495175213136312259402399513324013312093244221660866696538663558539419297808895321223065342849322016815240271616094322686970597953930339208081556744772664489997577966400144597469908205879993240277863006490296530488451155674777574587898825772271199409946880011078668357937331899244128030320963726754976191496581636362468020494885161642922153244179603113862350364752531951632220905643339510483673462282753791138859048029057640753857180925001280852828672847653890528700114237317205032577687952962703969603367630779514853760614076160162933177383969919289674376960527885820047287332510610131527869379765025761580692214485088936698508978604489753281938044864557934099721467935981434920351221822748155955480352259568126986240522325809672640074502782524577342582869089062143235343770360960324737147904830696808831434433288987611526522822628536070281237272140784611884351106826326622113259648586039316960367252441643108575788124860576401771137434501067497995162534990327537610768743309180937832338570887856063316949034237
	{ bern_num_data418, 148, 0 },	// B838: 5354025448359650190249424923134927214343991296796838995513119929924925304657056776050898935622456074220779425768441476840513861804978216497630412986769865565025886293772008286347223018771790282624113043329712426848934915094152620203660011637872118393848678350572329842382393735936196712392466955247928881913606099909074377737343608759507203384088739658792973724594021312796803008077506478000133562792302751998790946537136090957167172903103715439626000478714629596679863785370604707540998367472493329174078181455363768495192835572516881653426651864643721588559442636380668660059169147592442914667985007257970159968522153067917891180250711051580613372357604166661271103459216022806037542730248943940777990631768817743150562292024835166992413628695811480604911427520689773460817482535216209916054881101093562597562848523737832460701882998661399625838775514192804334571651554615543602880850503120858684636885969271784028301260023504965394574123473125072048302661430403403937139894564009473008286642777788160662616565514320162410760078671004576223329026922989252264475566508151718682314879255633708275174024597691319486300971485917975561950318597751201016081582775622746132485995342299743713254265885087079288152984118277806224437990019648934625746904552393193047584385132010539301238014298854381598123333946012773409376405296062782889025811193184399467085200870712369222182956631008748583399122866382806991065828532641033421601
	{ bern_num_data419, 151, 1 },	// B840: -97695626230739138378432972325884206879859446858552718035849014920101652234034828235309310949845279910612807938706471913416723545190738085864603231422552561195914129911748211587443760933810110111229399982345883239088634079525558008024602390218388401306168847388818260057158651787503501407882448274848712046890055778546223503793768055719487193541803688440190622281340873569547361945981523881080235268033235640471319231595020474566817470760974067809413024169792273516150485572095556948685924506136355772191713949222578378823308162302412254156131836914440301243362066605135398097339898496851873675206912508498976715632651396127839405897853140655624410372203193121160268763452062238741652061377041670285999544871158986484584422541702227730196410859190877379214179110045220461355992770012214102832684099126828969553269649563873716724090533866439800635707510795141152150060911159401850428761789231114724627152335766338811809278811104962905165955899931779431498995192795083134928568471904464756072227136354875234179973910599243896081661725959583675212086734922411972939229752318379137602809514843847256079628190759580101481218517377940306865129337550947814899127246416086912724131004873078692396724930218913647473217311844320798806705036622923703945153295467471892023853107566693439985790131786868196158085109481959083925078858812825130843025690467551168533658046557627336782808717020205872165457811026969165862502194292165259012260707675726048211468317
	{ bern_num_data420, 149, 0 },	// B842: 2043376201704265673541235867035965958319718958260855023289610788639454579623035326276192287813044411419855351269900418910785099809799535830497991014148694439791331802366899649292885452471950837889335474994821290864650679248971871043577421262883930253504763932792211717710663298108730458934804073779314304835605119317890388095371173886159789643084373955233323105256245152121123087668593681568124585233438680292259324584828046291756498316931164290057472157634967740789202259990539250410356832523794249041323044397767746394072131288318528749826644244464439314260104332169868074044460714411138579607925592232190174488626706599985522362276164011113795312842632761959989014810827976754584078057609014948859784112392411280414148120373664591984391531417370165655195871509744099138370898237601238173325780994601026997942522402505147005008723377763897400525026906262222876025480197095585184320695461242795539751549918152428065108228995235290020584578540164218770512522187581830278914031812321464139126328270289542368386813208075374565414904976399138170345087489751943836467728182727609107856096742348747977354639018270787991783000101684021238450807423755205448661903478772227648066190529094672946816816773706347968171331297799790569644364132519476888906284431065124815480529494050296385609163107417570232521826848926028024456206752713985791589839321681301574900764643668076339121264139646442628621462209732953587184980293672141001942095791
	{ bern_num_data421, 149, 1 },	// B844: -184131724208533501097731918381674579997317573610833243272923927941174930521127315538513217565970473822280484470487067292724272199325970145820890273304200295418957067466427762287248293064298947816395069494698390870939567313627289900862945288361182530026197107671608548192640137200510001074727626070375788672609996791973612887543418420532193145824107123094171987266925403492425999743009900705718867284968453193983162878261995540328850273755692974463356322371019916361490534132503196442717566529658955253383514113186898247123650730397855288349156438998569493682085252408078912660843114471071579620683152006862818665477282515318082211925944773814167438526275512761405950618314250866348021111743584908656232016099120950306121572457350206041317187625140603301844088104121319457410018762227533930093993548613214663365044364267775970716922276248691132051163730635735284508320449596987180414097801164395384633939322802422331863115524292180614737074782630547566015006209964538810028720387063428473161112904446994628953505020666459329718597342181743861081049506034578390585062648144525819172815127806357595136324178306471494346294993198200984997485248092990797261891741251315180975840191092182432631104321585687196090500957124793479468744803596867194463208667416486443962862754527630231435014703983631563552081976087857421346115259356483308666229392686766938504835421093829833358444496805870419419342731000916646732387317599829922878166080885001
	{ bern_num_data422, 150, 0 },	// B846: 25099439734327906451454016897469274998347533666126460299051640161049464114064065589514722979795549683287071689876684830616272944378054667163977105761710916291099638733809330857160398733358956525271677388644391042187138189962874694808089224927208428368827147880161345464436539345502247424198000616868622243126147609709606577189085938387905967093594589513216548813870188293479988305994117405695089584122692217401857898048639776889331330699319232840783801096653802210354017605618048638651810899107201497878263976455539533377440025532017879248730086528745003296270769574269934872999557137119745329604683505911820498028085160336565551387235708176700505871827945786449582051871897417733182739087629970862507906623605667007135457627597765152107784313874130272675689383308541927064868204171118219352116798630467471965303549149448738302604409037310960021246160523126679296547537230693699285429686042949225963314012443864655844025559981004143691434785357442616501807292885340261798049962132600255896781574961928378823241085652091089099246971617253016770576054012335730607936995809096504767164736014572500999636331854658711786772602226135881557219779482393545776443837857082686390131882019784382057877956715968888216439271941761096554117972430558495861012143583132282050700878780101537825914442748149436702646260020879963054364062985322044936644856125394265704388039352196559751910057610703459876156309747659061366773835565243332019458837254793611623857
	{ bern_num_data423, 151, 1 },	// B848: -110343862015381870230559504544889488733326286025932396882106773688381927143708549796468324401313062462226631295867292566228903860503095255789744879905675772585061435527995879860475416104999192842102974227187655884153321223946148130939885916540029541505482986874478823951185473526903076329332655926140419267718428755080593019083824282266472069469983806391031209894741238526484569895140915643542334518663654752262614547986797573626826911083605626701020693656270507805806201166831091937522081597119938480007937737600659743143345235862771306418048112408688942259438104998196483167175494921123220587188600543065089896363188128135600380596487776793823252461286838725296145141046565897340697738959387066427088562623383414091536030860511570561649094417663695007134342376884365232723797853700966966099685131557928526847008635775344233387325921618178413204705414581846892776450911571119392208388183271561417014500743463797970848493104601528973149445704259959539528305759338825495237284147165845501763848633506892850695406237396764790635110995905108362186751785719960190863926655071427537492365088593042240695850541166828114578892957973164820441540198041568630509446117202908854352675985836301049026112995825684833815069596274796402187257356647856590300932032290899065018720623438507206694991705973018935232902007023349301831082941609698269630625548666207729444898048436885933453371217123733420602366970397864667714904563413592666291417339267602008559743819
	{ bern_num_data424, 151, 0 },	// B850: 2439523697039315495954755827188335630511091475316951942563905122255145786440454243502241416792528161096017358929520293858839336839784325769745942701722607611187644886529457096430029825288770403550100478775498507463012507155328306944162815930762801580233336627744937068417163406281266839826804901343923835093207765611649284783414730340163928101060109740183272456623981704459294163363714822456021168854950363125153798592793314066035446689866467517034337605080328747731001956259915339143607296617716434630217635453192444235051361502779936285608738317569087930902733619501081745259199445810958414678602622586460023721481587265740820354642178033610551304933069668483562153169448008723556899175690826992592136023985209407086086785365923153865012395315175572549995849273560780619913365712284149880067427660293662960292733511791788609137883767291570554027350727313223544837261346486598039299295413183598953064979514626505457317567295695039296893727928929399697952834984213851334517470199482882058637644444130726920177717214628067696977946994392672440630268941645360344717596458779483793955651886273956236613630608237607914404064662283675590410278155209252049211157861787866984367949255181937705065248698195313218340451550116805266376937472419534970268315094516246281656531203514099746632550547699613693580579465397856764165277364856758280369354403709967538119907126587465858197137094850439064680575679926866834812660415966094355725063294098122970939467925
	{ bern_num_data425, 152, 1 },	// B852: -1580819199547312330593701028766533159152617970565836207541433159725369204283819651528503743068853615149346274523021863571803616127737161021748127564196236625214385714648097868905055704159386999096567363619409017175556693970200881565292286801577378205234037427091327453220103983020627407800536351166425485488498313430654946432878564466315050595261420115433066084438271810944199919289718472473129474385739374890082261533099528983881208368677517786012211131005920740405043126717375975095615353128533488530495779102272316196838074860515575202007453230967492219243108846949592739091424758250992917960247443022215644120806416014411234960133003190058495944600049380553509447384822303786216493083005402049738810640265568474556107866862150168210928667579812796725915862675518609510887436236200513473488996112982373469163279771349554883123708254657238844438344039463890600834524961111751248264453789942826010453580432924379829025490882316120748777039115649058741368272720375489610303546944333624199556813578611501807781615636379947084567185512725127936796633402248745667001484629772163869682847452745495235308112461808301145456098512163420322377606430069464998824801066771680200056760734418311956526785430118860790215685669749156128281105555913294234974662377710890357511556518197182366893775262357553993280472243696397891666214244324042650241040610073948141741752227836964042696056866447218498402633010882805325480623659018683778784748429341553319244126167771251423
	{ bern_num_data426, 151, 0 },	// B854: 75156913982943573241913008129418910699418916148789558235283928641089662474992041429151542981297883125996855929484533106385599301205550709259155656854977382300662050690664228258013027466149998886292668210388500306852189070316083961897042525498596906649432774374750989155907604980169309764373478274403833446480495608071194061920045660534291675833960557314987251145568953073077543456368215892202960123897528567050852394521484357549418499929292013804990745190783652885155719698734823325842377586026593586681358617860281584398501001174565110084382155016222707628971347020539964845319114636233401113737642249375208103785275577424181611096755886059695961038985362133018894767268893808208944527534148123264073304877648828697555943853216087156735707121994806914121352105614536239448148924562764250609711633622671228937033946435288401752177290954154262608062936946773596325616812752131510012693839768078244088269809845168378657678677096473889563579250331402358530268852592650696691885883410808855966654555182962094132524919286034107953075717777551027737280867025378352630062747516353494526137764125806629641296678488815857704084239996278645183810376870967926659838088935506343707142760093709613051542579082526800543209414247746748518682158681579911471673011187174581905796211260010037345242452477951649457908067055897048119974511453629650610571400689129932572371114831827803459557267592841055804833614985156950481153288187846543163005244343583327874077309740947127
	{ bern_num_data427, 152, 1 },	// B856: -5970351603606194824010505839879569580551942186690229715763571704569031170442088758918467960514296343508903010131033362678659084257216427722918541496245289909390424984130588675917512102262492806180715330960193199886823150053430319605685199913524538685947926713517111080847355330854486577126470019067551600350464794891032425609431946393091807372377338294005142004925949838558606269455056189993386827385015650694357563432608416419009801283760911223405748417245230142317419029675011299389860879607674752315719921555526254390370746346829444259473089749389941140266680749930533682075856586116212355774713472351781547967985271768965733465873360556160188316123772600064590813787487457309998474266338832253621431629739342145137264274935336872575277760135398433164469344349665437689316098769656125971692976244134707916392852080721826616755643414059892793378893225568584902476429366688544401039392325346888557984123165210053316580556543288702876212135688475537402864486051429081994099723808320825279734052347377397307732082035741827704279155503158620200362118235600067893042780772430725400785140794428191207148502139326848122238510190311760738397488388702953235419628352020306507201596677553880367617902435104736358390550471203289612268359668166681697612833055606025443555792149244421321811910459789115998451631620684864012805714810263411451968595091694052375632000454853635764562794624556198827949778958112103268507335125068857596699545250241283586330079447846705490606457
	{ bern_num_data428, 153, 0 },	// B858: 18996709821126970795791663321270967108150963932708143859760868396972715591167297732071960577736172734110533685809649802067989169178111568509157415436995035891541539456985107877786883974224167957841903591398441998507237138373812785024865903656605943323380504985269692423312131273265248834137443753515679158938014275101591541295568511606102316510671766314632422257520584874673765968942265775678558348702979472639717963442996596907463136552630417403833035929962438403544940832072981799751313474291442210443475500949790571475407363843541742175707205058946769472129862302496259068334913954565402705037688510354521435912852082124968253246222958300684461115371787776667559799063014692983099726909502279729162594100359370766275332211255667880574075165544308023132893373938836205778189074920055758112327120592363505278113348765891242095042725669472456389412709518989731363005414947748514426060301666128413497778743401362793813037804064891559965190411232559931992385333344595913569095613742804640750818091724773709986339919966173431226251785062523319292836549991736860685288530384312517502709281920034468839043089433798510734750175307238495516392620841305501448703579067097400457478777224746892939707512470285140533647876161643948716742874194214112245239312222964171711417404837567451460961258670975966256342576722069824408089149784433827330428380395531628287240341629975517583597277767723964513589366234222530034924879939154326869043185845562441136081516691760947854027751896150033
	{ bern_num_data429, 153, 1 },	// B860: -1991477463638106897058880379002710762101098225360888567299584505346611342308130499666015074114146279015966808635687778859466299740811275257854515075380725087664154186700366561964358421810958269883082677003517771107197623786840635924580641022427558270726672808562994670757443189802308546359258208404455825566925094361065116349017787102803982022095804748527704930178795860851084852783541315023613290515716467200487506769124764280602923133897297231121584388572017288387049723892812998279693989911319229516227833375842604425630393707170553716934639838878129522431050611955374449614957047875839739768070806201333042786812912885003682311703372966326305258852207412552856164791301663841143363128684663092673808894465026748125775234005636279709635880083929917722765993166888977850396361719742315443461740437487502995720474315952404365588002793534148139797065757135188732442656110739604469757876587213635086586339997194604482308387830657889018147994483308629556757457862994381967899351614943070472899000652084647462515101436921119178370860001027953117735626035362479695892357309690953831662767741282105651427318303739045689366604739981019616561302311986792509743985559857654622058503975192350779740145354686221355058234277756263248381776574083699693618518347896768155253570924433454451722716732816426957148141299181479484103288106341419885809175386137366569040779032890774794103321159122579260971153213984314567372866076295571351347065258666397657296290051907209427421606561271817993
	{ bern_num_data430, 154, 0 },	// B862: 7878631890365960585246452305502962826625870490185595125627237793254512737370605312341454788879622163730824448117043213295063038986429090585080449661307254565101747521379397671815114202266949161489511319799605710225707359767381694015591423580203469352492065306048365507741334160915096423384632320160899048821405003568157967641928074934287168411968040569909262080657447694441034102294950370592361590536571294859650510434964154104662551403626620850160003433032335443779943052615678139166078569486811767799010189819858205604411119197929377473537621512386203676591844815593608985613795700654224742842623564368382206855925890961425145154937501436098679366655995845812865443920806257382968580343036385802185016775938739613959826525957307045704285124153080593079438575385980395773426069842175536825392079308546771607286564449014741688541866659113162777670669702226080537531822798686772851951556589326599471749687252723449521057300841785216396052517458049505273062812727801080430968968824856937892370422995674027960546353567683339997139752058797271161262247423271998403679831559338288286734002016602362255666223179899084787728722636189321837879278128001438998184344547153694679420488109557352442462593697696714011076682589280980076819809907987773290460425464007704109603999996083455893955929243314881668310559597151910915959337127079217771111725372813091021852829367465226831925559975150533791205866454920146681416914091347536401808457220228546656284871569945534511124525656523843513
	{ bern_num_data431, 155, 1 },	// B864: -313349818234433103109234109005729755630627358189145665334204965212221866133349888532905787317336732294609570109100299489936797149201846182676693872089137252017380339559354084578048925786344005825156896821431534101806813930969150022266517166564825379506162183124638812300337957621622373318022606035045353893325652388485798909991655505270037169239704912281942529747069265067758054887230733847620309999113241600841642245731822823282710594926098266195254472030728828896394961056084636711302940572125852639379004768318151819698369201156393478301020437459147833473121093949245705683826879692718261907574859657507206703601727466713626018741376388148259799218738971858276410956206758286335250565934417019818804279172069984144840881008509502342442444161617318247999169769287470665342238078740683110277858655140427881815436818809187836920173097269998287749239572479435049324004634094204045890428536489240717669938854200315129381948576672988239828407726522031120262198156471492365198726322599862645155866097871952692671393401490973065885555332194900016241252597992695879090370646757189618900014398292526702085649300874714525111475508217651831563238031071703048882613618103980991678139811111793755916464161932634221693955996318667162371432738616582219512962956942219538332027897581840772850741380259830958288276255615968570537146988876211843283609418704671265657741193360876499040061778946273667838370216967325354059305968803166150261250534532028154197209451096305131644333712337291839682603825264659737
	{ bern_num_data432, 154, 0 },	// B866: 3271742218367293982503915703551365727002068254659431947537411181896034180276793612555231070924525397900268020405352960178115691029014625805769582790187160100289022173695076764789042586435396314551352359943160819059352850424272265787575126063117706373751077471867038188970266749496686986322675981570393602897703189072418801656524344247086067428144111404105598453724836820160188743320844422593196199820202394974411681240717320507045921966664695124249864525149469350122187441191457326579527552217561680354114632026936587713016618415355433589946123001605679044497771407934827097430907197417432573301805047485721452093228410273799336850912477316413485003250897659637709861812234138608597581863368454188895083830185881034791811159333072276555167811168767286440681917269124917491858061946459912624563233688021937772487018632798058505229491555020032756383630146351747142118879161208160018347696821622138276432445204529980166170031943237908588678313816592200430978865982264134333776138487275671946295232830103863762672283007478160201575127158634759790268085738584634389975224155915011350361741577902766415265454201367855892086776726250175169336318203917931735093165811116748551169727138515833002316484573430964950716632676592231704004294684396172759907982190965364380768232924824579035682663866543562627371412813037956743567194875579179844424474541323548804020467329900854978901576511712463910645716250041512688337241905933407239660193678624528512969565809738722412470707334885063744911423
	{ bern_num_data433, 155, 1 },	// B868: -9043283926076332652789552695043059888106076715166135440816839347329575609867888835441157624559371855961969940627127026804769070867848067822464432647428299037714626880878446016165329215733050764572833927024163088373702233061111294231414677702420050373136046001203748551605679571681321640304581089074596834060570615370397857586973379572985182120384131912051931179239464440643418180142282360197830384766320501927414097321560563471551913172910816781731677294953717683660483995026287030534037105027530709090791588340755654528086973859918578814539374171358087004888449356167355526695911585311894685678930898396342490914659030419637825101804245758790413272615858538792535525342932124356885559761818370279550041260790095373064467742174663212937297691162383442186939427869722768183832898997007133170734510788419546902517657741922051565089425925557967671988130262568696281807345009283158504718743656262974796461874237842142690394255935813402167353443060787656004324732054125506909303684056425852616206010412416556065203796540861174634647188016595356945413439835855177546056922630233333196049693207049130041417888401599185061546058494183647008382681820847106599567794851291986406156592985961438157446576730637346286969082368314839311459209749833256538929134558638161598505767408238173595682456920793809673755133664437095142907004122023215116536825160906376388064190401661212029242425744660080724748342574864896845145664408347025071835476961228088564044325467897820117289906703347549944460448503029
	{ bern_num_data434, 156, 0 },	// B870: 168206156403215883279602864007942522893803433507073115279447118897607710537426403924717260414520426363350813470162632667237929803675752215082145328872010774893833754127112422181007268364347663610230803346500182119908761419860875331125449680307092218412458317235621790087460671383900687338833690361984788458868275874565960972413466345876488812034670994746820704348039334835342793589538540187055983591519845513387419541361857036630935387510414472288434054418806441048164064912951597307680972589393013713078213845604205812410821018514954901353956227750701110655010229065435807675164851603470768864105377998035413384745864720495080843257438272769837926026069215476007735709135136804217974172790542992335819285619201418855044051611797723404920803078309987810361413953168989391752582452927022720598546219751580165144094938992176018492989691737341423343399696413630703291744411405317407235123161258451152666644028878944518986581969353542329951454327860241291892773253321669870610729034734865482684209890643720586522056399202404190110466455422479630387316567119646489028552744730896145733820016146969051444187570159578944326465537793517523768376352088131096943364467751157266902879824590371414779404404624797317639883701381895904018698471985143230383297534769067423514282415437896484606387570958095247747494042971970975942606099509424645892509476873206597172379171977886632457640413952450721075412361659545598174033837170297388018231657857170838834935438400535781642198590067249538685996413138158680055
	{ bern_num_data435, 155, 1 },	// B872: -114890035595213312308633602052830752146848573266118373498525105584070720183812816394557174698012625271207159002952635798440691925113601722812864375912952163377062036082655774105915845248061765414170821712813535632110017571032443496251598208677929287346501391972840528276533915989413578920253254591757949178139307839521204375985597082894520477420619971830797146580987947503080172798679363264444358775031017792317840555907421217003281017630746163600458244597314353347023098029848800235424599841414275771906551599761919314255135726337076569843660120749519308943193157045798071234021267942920077948765198031243445675554091626488761608886348017082677371445835164682213295719222178969756405197261983027941544047035938563416658320178945424619056590498109094674856618547398774787533622202561810853277845996881355391192325029043447843459421946336740949261727009194026002147536971164562224942732971689492068909677139309589650875275286384507440133297305442815496109980860055308783946156120513077088931127300450617884495772361861184322300900637037872774948760711236420753797442143624973013704473045771047163724586709088874511471396713007156031109891743275149844782057328810449089807820922479119740788026167298924014668542776046147619822706927280985213126602536268881819743815630691716334667296934565711838533624262509896702911086836964968333509934432271574278649817444166474574692413122889614777991599397625728486893522866147942994866651411925662307927290802928055212266044162200637415767456461746126017601
	{ bern_num_data436, 156, 0 },	// B874: 20872581102078093526898873552860064061873773984764467144613222994079404684709357782408409583339901467227440138947471637993664553906455002867060892804150497647924335061458635603392311483724304616775307572051533018352451483274049584930965409712909648716791754339513903123105380720819197812918869110481829059746328235930035540284735402170524539409736570697846411446679452022667460299787772454322476979935336758934537390535811718072422392460976095651327516217184032915603194661149148986616826835688857119934132812328895362687436343161219767297494214938113351209922579137263163982681558443025839410249609818135032127237137182197447203071038510613649861995506589759327531300072708302670802562639278376772335522777600868004551768223603993325921594463477868378661995322764179115269735807474277410203068017473930192830157486707881344887791907976338185892720591280292671820647264245462305857712730962038755576573022797824516699847455148726256125437963267237199953907821729037734492872154016057024646612822086447068122948073410321134636216536322362917546111728482500071942865830471144945504486154426309286886111475405634188096888410377612987995506835608852945167130227552637638094007727563444578843892009032694108924520769800294183709157878240637196816447402223027017782366311135407283574246879800272135719893252544052509691723497044244621446214954143011235441999014990818269234311426390997007414047862684046850334295948687725024454954097684442174598700620763544192993930845712853478288666950898483241884321889
	{ bern_num_data437, 157, 1 },	// B876: -442561726186069965408980458678568096071788903389797513617211953813891634408248131533598172079555810697852172012143128969574033162073377582413218474087664338081321170821436922200263858780595402984183596433525413833512853102909912604426036720063615772825754338083441784591379408518499990806995829035852680352262697905088230016622395765987834496831837966927257742848183787524990688560639804053482731491677425224548682362311440516825813692863742634856902838821188191074572054177294968484451891063067554042897379126880613240936966472891092991946097807067315099476955626082359690162058120251356518012188200570089642918068532724613067877018354669974065517726517395323233291815251885497752167835568758225008939882343857125873487337202165062785479837180263842060853476911616359848947337087834020929917666639043925880723161853770304056413020222805573668632171394985176836608428797750479922713925725950460377060394682401625184982336454497942191072146309516783790852871194760912252145617757686173803801313910092281728073330544158274868504284032345179976738719991518531610389251742316768440900328141310539331363356438737901301730477343432052731990134730429389420640729186390847647029735372673395212407130651382299712841322241090841470357704590202582141344857290766250512844345243209846078903570118787773612589131099001536956437634241218082421540134419088625568846017920460116731432115176523313695131567185136693854527043948889333946523992126553217338204683967392887894361888455685399237814997185994211049568242739672075811189
	{ bern_num_data438, 157, 0 },	// B878: 168176416502152045683994873737726241153692176628158605376030710064483648127210662397016473065782122387287060441706589508342837701608681177805110267923582233146339328187431184890567579937077936040564492309864792229114151254931206879601838193613389861710963627065465540112905519958838767648112791831684561332356117837319309675544700296104141656539318699699180510313326571898035253647447105936465023265866718669468846506070056553243012471344233302550818734014903434393337756352531678138918998514772590809446371996071605493011351058316217984827138594230966857751402137646660262884929643056767083473164938252602464982820816940013818014453228409208407478179893663103015027586150063438532735756641998362871844088029800898212502111218532687722700166107290259794450577816905372538920761692181314107690809395876639799477509269845056138558762824775084478148265670205299536946351957537065832458418791830757200346792953604096992798764145289018200914316707743105471779551192075080448400551294448545202412294743372173033825478872056985410874873829142633177457524359651423109816639882831444871993698173606548607976322469811149674681866498698700110906086300409722356920625402794386022143015105126961035177304261506751173730820190069505479707413137717860076296479809606524009003666277459310183833561275402594708982864271707250262081197266263325740895588929302141285959148859291126338035067048162462229946345000943914790114107203519697193166438631311632084726960138855981302127235520141987820567615181361767684110544004779079
	{ bern_num_data439, 158, 1 },	// B880: -227806506213155057427295951695334313729815409839259062555614494518745239151141297220735730674035867865010818769814308400581237503323556842037371809360581971630700063812403426205938830415683123495463948552031001189319037387207352833775061558664058554353634056480385131384943970796503724719291887358916177035437559969590087844296536483632988944396486499407590748491800782836294072489179790665363870664567910669989259991628039948649462071196923509346378456327459330315153401584258351746439256842875777647692583579018256285811266241693232040555219188052690351178899976592987823935430636130222255323184400357019846602709524904489277334357442886975109376882457083215086798773403004549976969203253870336260217018418541211632791156438707722868522368479494912514867683126654205420344698622202310300791940928697060773384093506608276367195212492668886464034437302021193268007781446344002771378980277494925416417684922283726446415372041480982973419539821466783097526180924363704283854908798552164782604776131437811584048331249979178337161349481600666784067104103801729678028294070674221492941053926109800876733364660287206443950235742340482972889517917766524255330650441740264750920212801417939279358793027274360370993283045625896048680883151340056988649006475870997098051148814876225906238620901833567487798177633164212257736377746044947630590761969714856196650135405899739267601097226082742978318176133793726852658982569386206649643707010423261063924134932930424609149584373567011579172909943788998655245833362185855531471455425869
	{ bern_num_data440, 159, 0 },	// B882: 41595484063593537516749451421251228686925122271475583490581435051041170969067938460668568269625811122664004045354022501181581740567676012023531579864374634834902702455446954648111072542324528557343472592096157980799427284620557657902365798700125963388203479739778321221320597852279609704278711125688264249925787390252857202925539730267557207888945814908599677757504777097074391089707940162756506929116560327915333739076654221916879878694908490190016416057830390024673301727311613096776984597135450255369199042799408901383029124342340317489307143067094454420745539508140437415249397137817869677965430311352844401651526202245415272397493410285614439020777432429984846682420057618833946474467719307838703560436158372458582423442606764119630959840329781285572629603643159740560230780268046678710011560764796314813461332498178877334757677763434261864629605962562971125114909799478263150472969293447241872655681568476127386466562275291069359745824203600201249464702155782828425742700532021393411032203181087835324377349157574633881373702721580136332567232623393650683904269860002897851917632432604373423275882350980393563036655192166852861395244495046043712349559139714862757811858586143509320025856150529794627413022354551359374548189423333683679621690675603240960879877024131689479668061872452512851530289815275651590632641875099822700808105932408213304852775928144659100363441804054381827585438715896268285967708140525019063726322992173462951013328127000219655361949462108263735585778124481721854493676966721061921934250058869
	{ bern_num_data441, 159, 1 },	// B884: -150544361369705845080344045975838935366868420357100458370636526855723828092046281656464220605423020785728410526172165465903272356969918335645242789132149808200101679302241313970979671784657429217045667798319488444536108523463818080208109912631362628802295676291097221159630974802364423352076525954204642604738969045339890305570334558259018795730754082545783910254982340684687813770992328921848017263046222340645322811821622930450152843931350892256264264501883320789654868050167113074185364211618282221438668470809390100011870663445716808383373044690964399345049310939772640951875323248492079149568221562671391569302328543389864570638665104942532889328221423614398315794044669680235444440530855175877531604183803920222996728235573285495706090157390782056576445323695903723750620448456178045755196247664518277440259287994574387133704053960417612668312588792158801832238378880546669294538138691291246423961992702042845435063491487913432418511884958787502001316192942193569416577666624518590768213949389131383008716212975917170174773798337253321047614963735670285105079013541394028166608966539241034207138887915993817649013804826568619723306414316395415096336613778766478851034011967599201547277588636556889109796990345046704086706927099099750926098010212548303114363411507697706963610504580627355930687136364847439811027908314239375190790635193999851309538603444357685490103879169733117272106349921887257495223611819929801297023941610252904994800967131329719950530860057335713754099836081916531180701248726565190247867597896479
	{ bern_num_data442, 159, 0 },	// B886: 22592056693948002362777757159083337827335304584778766857865929987009747116510021406379142694207783804633956278832048739835550652240736421576008388455111775368069483596977124548438762338949210111596485790083011882773236135516698609583542252378096134695240351380729505330941342867895940411574152224812197400935343182106946588510475141546763161977070872957028745129576470553888358983556212113030759876181369322641032010724830321957224374250117987447659176820386974832842273622308704298557083285028680115118466336255738971140323472028910288072904021045478974979367304369416225566065813837537136030371562153113438771956304787815342546285222748510725246637040487507129953568631135366294482539653105461994269282677099522443587291020127796791925638484832578676033634210182715306958921766443359162707313753639143167327176241654951960188688935878490519694534496607270167429410718325644367387843743503248093815879208553607160599665288076530737339235817687416692777842546348773945587205842790728355497912231973700764093791670837685836160358686475491208058496396402845562282242945339626968746402974819989775131568625906214538542438208343736865337772140863859127927056737542315663203321246149569288106000073632569211028021881326606669300806303923950791425882918351231469528499644761247490517438328117126949848139329146653523641372817324726144379940888295632533891186082904790646617764149001498026889828971675092245716233525348584209574768699547588785058184296590194838872558840266651209105529098149308909332559934822089550042108584613264721
	{ bern_num_data443, 160, 1 },	// B888: -7682658455799846002304561138520568766241004018060556891332740893330403383309810502252588760035099586895855899034853992702004849783582630161376812845989910280342452423314571227602120970015235679848460102335478373358992443805603524807661536815998413662966367405413908489672762933172060553434564979170396352296231880691189724446843231912714178649223959092521867744946014091445019241304638242898521389875559391885193529839718468050219126912256013943510086622133436828029744272440735607152927534844874125494354076437865547168326751400337595268795486178799046932594369747152640432326345386257183829792608709124562076923220198806159442921162711920061693502800787607187761217342651682087890500005838985125489126328230391856551537355745925321304974746619547828655005857019222639439088115699310810690969154000086972152724564760722693758498407413177618625159794764538680371536254879473244826252023800015409096902208192407353343398178074384819556102116390789005558493444694561340922414870163937438880665087489966054149781420729175137247150437595572085808078736023346642992087463634940759274478099342467918745450725220871760139162008699479666077175722474266860847818414544520229904849777830001763955834405137615157502857814798796438562664138144070968366694831720753488335459362627726261282050620692945605145727498500253329208450335948264291430071070468463042635581374022456370330147266707142901202193893945065935693926524916710771131646637543189094702666214143387376435675280115376101884020883439225602766744951200467745712602162654739454937675657
	{ bern_num_data444, 160, 0 },	// B890: 20053341296350723620721490483944286369064502487032941353618840858850584394306901131602277843349127933821025831384941345159520561174922284672700504573963535231557649886878164208590133634469973608139567191666430718254069122963151559785320521426820887296853931048008277865796513624632143529000419488640348090399341618535517362986524548061996535992640817992533232520651261187107527853492829599596521903547880467979409433020787832740476530406184915901399582665834776666621078169768178854999870229510288543371689673558331610242154189417533994097935242971679212850721529844225545676348341140759882692514717238164877052040481931241153084056275909410739776544563108794486421705444027996004823308136586379491718951080991341670490771318305670033944751890983641537611664030872190627548405046554391933604840579268029418504827222689626689902855292407206860085627405258660223162644155831004753674282833464459519062276640681989539502678889709787636346186568996526512318144125572512124198347081740936749558920778593047090687560956217720054205752410204945568073677509954717472209137705559071698030248444205637082023953344377986819062309985580328015639265538695406908082569901808560741568738670652602282513541189393772891631826177969339168426909396760585674421108921907384332760258401453262917473550203679890885921705558957435719574820211873378216630394899187284217444701061786887914184731675093625934082372686715192387158067148114317718152781269069258237897482797746347899121711505527008203184366026866604220363700989816373279840668664451823969202010655
	{ bern_num_data445, 160, 1 },	// B892: -1025165199769181172685604812132201206161690547507667264975296764212437981835787345868045911272762894025255579982221637323927226270744499582591933928179946237628358917048269214551180219999830883196053295958662113274630945259528831134123997942017097793040314430884782327178331653320181106425827494818599115231282400755702794789800878682565938386795051567282681977767015116485877421457001290363858984943534347389454467739556910904445719965653658828803329262698313758515068273612869415534842688506014023263774555471405214363333681983131150780457468681353061623203914683890420375554236238697395746794840646658156888749300941275486336364884225820086070838306795024215919156075070414752772294696910092437308803158891890591750072980032704688659369884969864685038582055894496804984385886546954057996294546477152784343293380308579518040454168973879196140625398053753329996193636162312469670584825365491777410975666344602002170317150730569844005719149893631353936691208708892806891169381435825527564665401288939744017661377264408865080880107821560672731355018256194825838673750815110143200600215321012978328428960325768255498378723695334227150631570313668472351376332656144595073446912723037033461308941327641676717258033565305163159345181563767652177277685166256794206154759284209721798778214913432158640698039255391920142726851921862272396296004078760531634096762052844505008464637400895760139527113100386699180402578041899317073364655834812709169003013433379650808904637231943754677214351978455296068722573372911335540764417999127166824997674601
	{ bern_num_data446, 160, 0 },	// B894: 29023590098335407900879879456162575341434365270091095132188514484932313043081897238244450617641600921701300576080979795224928363747899786132207501928814236265452825477627283276782452086531485759303793341390787552118738803000182655972465622420041396150483055191926320789276343986315625396101959028840944094709634831162787761817822675122169468441513339243006000550806361018680659301670823472969024952239008947836276915928655756027735423620552986259612796138389291349259941624971497444307923606519904264802923048691639344896042044326516595680342476997202816958753364576304076449805179790806097114975841155786902072601192575927296529420226001051999114301588928193650018467161634670987539270535716071433879944409599246999384355096801587266789592998818970312970657347502462408479949544459041462008930830308162728148579405556523623269622009320350394704927871025323960729528267297756220118854222572610014352554203307113859821061756080435687699002226312711719617372763419317503507236226024141700821153464150699229135983252185720397270289203364953429849488668142635953776180831016849166143408253901460369641079576181210341547899822328472202593519862089039559779100616056047482876181772756503252520858281355505729768344873596752001205117012302469517953202077182963216583544863044971668936845512206327724604900381307398560976591838011382615374484321505054996301942351465202274277169914825531839132257050638712351594575607414903146597642396205684500563815565762994108085246347203393583226756041067835797574241414655603265143872402087892448702793723766929
	{ bern_num_data447, 162, 1 },	// B896: -10533340131913093341274526999801100810957651362348921641056049914580684330211271214110487269307697418426462808039015260388651086176596696017437681996230301232177160673337830012321496979814215232333959731245411734758153104233399046656432121418070755266449257575495861620076266376262211106277162074103363590843410802070598320054964446836083555492137644303564644844383923283453687033859399028970585889819369508151304950542407547311751257659858676140423298167304594053036174569200945982613637676206067411079546312481605596894391993702848723885589582297491917523290550688109368916669569500099745315839305046015175409545903196705713882387498008675803894443135959731812231046980265034469802081834324797345901568830521331507455374922276347716986099415888938860908229521598931708471260024293150801383911149006920075773364464224582725166211461396285608253972907770597315378157646826838434845997829479934041146156506785452513504353309678734920713009384415921203630547584973079741634534248350154266800325186178306057611049899265566361954527287701587693013184964600834032442789894260598219791560097260296824152089437750530661080593289259291554252244830912524763858693194626416630848633848669111256661675556723506835033086977220652084753001998541292891801435778498067876514400891855053909657708927648675493567664267045620097829456466255247728616448616769778031533866434597191116935590868508306372020944272288196153317924447990834146574053078976535568041931462098601624099311703735104326965965023799939704784381908780324932091314519289463673238137662954810461038496141
	{ bern_num_data448, 161, 0 },	// B898: 1718436319833199821139406160612715266631884665198763438229394786188056871503972239921994589712758435139277196142342778437655818673759595764815998082942577213341380226837181189182073295256068466616101138453733605610661499363152352003583421219064823864649728169569246603331465783202034081278696475351278024385312675246680302277513993039039911437166163624685029567234963470290096720670812051739729233715237804783874759271327806149237022748800681634244133791183800349341896828392533573851281832990965196642002596476829877632357431031144795706234937127635946263801983710976253802609582151992671063713383212541419741963481437259910286739691542056215594579693786166391291967546243687877490289855481887223123947159293948627633996585448497956949824980679948216139633406021994131446037073174705425581212646086552148680220043381728289349170352635698825407992241355249560509503268394532426257435507333800076769524261518841570642352913463656680169017032948958560575131579868358743674188215100368186720986753563105709131753051915813168766980675492048846972467115636763635995819538432632174894819210581632539282887553239957571961181139305615398095838423568040651143720074292487353502511784101829352902292021044211701844633657966985429895319379323381723190509046122782423486316738745397426456690792824782614861815563391392727177636221860537079718515306033137081830904391733495857533751707173046005121860322516607924008720460886374800054520229461539725324817553872338093675483952324541650538825814294214523403139447352351294494868166162178250196290452280489617040639
	{ bern_num_data449, 163, 1 },	// B900: -646850233392158818168471803387065863792369122660372110726709509324926842950308614070364298611159332468443107380158258749308367909771244521648883664089212506864270478421814485078201849383280541207615441680459410787240988273861501623775780566323710939088674645795806555242553768950795038383425485330770912826115178259886089807959179331165218201046822482363978349028853826766102069188606151864359465610715449903857038220397754786063543782991628210333625763715727617800967360318071642669193354533466765612635706614451735462875371929240395631105491562447172334916142189143924449762909143038060525902051025784337309923633885219010059700124310053703505101042516299573637609696697049925477450815434321239058791485432692781109391862284320264698552787512846662502494102376505015892316126727372853052086869419166963676444580126609578130538123958823183393628526244095681309790258313836274870570352206120205181929965271977210007807138964372856574537393565031169014088393010797540433639657083131276275450172370778390195086910108204483626179924597106184856932688091900833347672782089339130298326691405784778497737610898447818617321907666959700403768632577214906195102046539172226051339614824340351328016065476089117160211457591485930734597296181213270960355594295297828499279477187175249868727580456610008044509709277823111782161507215307990004011710242976492770709114603732187802559627526849623996434715539293076448528195606081904035509844147470732137075043510633691684492872532071342880944149210454673147548769080988948623819981233843066876523763179680495308484885872628714142560563
	{ bern_num_data450, 162, 0 },	// B902: 1384055252297803049379172499781070868539606795736199202122478666127060993813441126038110690458549328212077845308845734236094060307129750884250464413054303204757475872627061651751631179326594624615183421812382722130133698694452172813368283663927794860688611283177262453992526775332214948919650230898082833697601777985624087351328661189564581155427618696209362109827124107764018949576494456272415752646735661054416832112135221914857476849185737683718065782386924607552160558715962991107604091554893420015716995601477214534382043782006602213998855810703090073281732599227156422277623079399903386306057906969762015677818689788739467072479351058449963834364979186726234825171261600700833530033734104254879656441193298531034578844171599921720909351305887451166275274643720079568254762054688211713440039596878122306360644352132030047581006390207857848454265723581735199854612582550335335564476751892108295724098956578455586722372679204120858429773464868422535787390969474157367623979573680013354696195849186632228934785926212209886290752496395966999599179219674806729069119642804374256653575518244338643001533269483246331948429401423998921427263717520203404417991397827158325152685100143339820157048276013924933132722571035146338996462445296931947698538779688242930487522383402390300130131719745765128433930661916434852004703513286730638907010315383689913622018437296356996509578952145646805288181872695306085021879768065534965866886408336869909962731200143798278218969805641977699638632586629614438210222642856073188319341185318141369212632358432298434334778120489539
	{ bern_num_data451, 163, 1 },	// B904: -17015307613976490176246355806366798023551222462754199510021404319741699531220087390289330452839734438834657032662263600038138596108780411338416535322722035088874211944151622375238056541935700510515070173107275944384195212374554032183311991227371073245640447908196202581617521744045304666065342781038513256184707897224124044044086021158624407774973555153179068982084819719445508205579136721826097312153963153468889691195931257852412362149461133813897922074348182802114572417509620165310751197668151104256396194687986715315963635865387555931145506956762596279832423363051706343667743097793094048217637109862297709700014012210038630866603658609201203064506487446231904225485530906034138153864341760290169085213141059718481291314219544988327173645021213134153276139196178994381723476913496085520003950441136309317275524178307248395146551546912323318292647531771515472283569773196318186763997283830277966624402965740252804481660479102341729543637111080812930662019040089794960000864878533627638186381674271257852823293623869605963701747825209365633503871277326550754579262850942508510739933182461894686269897081915396000855584585730441373055641794458583028309109513319058124819544847703054102669866880683781968100647005995531662245005449935593019733299748960134227827466820970223473284102703746859447438018074824138065465049178306453283029903601497696785391202968830031555067503311579964351610509421138381794008416912590832883969869529486602585532240922634483030158003434075550247459454834877034874754162891860216929459961027001244210568942357188602246009646930856496227
	{ bern_num_data452, 163, 0 },	// B906: 1976816287514974291361395163679533597185833851624508803276108624690939436383552019958780014662587564471660763203546840155427815653719647053569708902692800789084819562103249208532497846413405802962352045386385579189604334557390935762124817934967372035198659763988055188366436801732291078263086186561268827199617265885708595080728775058309231553184617901385393827524588213933323547562681089655833772353621514152250453486745555552998949469646779564843578980892607781810831351134036971187699000671576567190681568069331221781242672090364398817767940392182922720339331554038596825042918557294545856652904845550602082424763693486307256542372928181051490156203315195734170042321856609924040520738996646090429144845370827126012588215500495516828462952469322800172381264356682571444165974903514993559315965083681578823763625867333489712364974441645209434243110777301359963561113242773156566458670343530755299184237884461284083632222613712702462071786928871198224843576157480473339096158136216365096163557268683890305229547004853061728094449635920080759219450886498747420494388026942139822923038806393427750546992125338647244806260309285593759400784078037348272032178555226998649557192147949624825887416986300337965098645942263465570852424004724683784579891845428861464016942418085737481286297369361824920992582209323793542314129462370351000253890798073322575799907880042450018429725887330150460010081581954927460140955213649855133634966163919542305171755729433729186164180763089537751536954728033217919134559402806527214581015831509440316413924389453099230040132088049527402412707
	{ bern_num_data453, 164, 1 },	// B908: -32476138645317488827718363699423050108923296998708792883927851991357877423705197918784222939048624192684519541545443569411235816931305075415558789827391559997593115066340129055214607842044522087664721362687549333148798461948447383599515865019336364751738683383133777421213600431971070203147569389573175724265453543728264211001606241242239400551480000866872156694733951690737777376427682472677427020792894127425683509687997974293606186909308121776094765727539409175136738727123627325340313998484378487760083666682526563725073777648996629436219284413465792897330656483132465227394347553550914402195544536766270190025549143607169879896376558526295152711802702734537531499799865897640340490681614430014383914075538865619424838477048195865279978484704644749826687985624816789081557103775242323779650068838354642697123766029619157813478625420616082111771843003281715139587061090019007356521730054212198352074382330052968561410517281945499528871451461754688139332333941353546402403739391896781399703138917626287108936651807134585249461504264429482600194559979351229633648463589706663546055337675726536151553643171321092075318966735598525986089361051803458797246102705438741328990191168882845135842351842091814309218516009483991577400081447719700343601710889016183996485401377631306048343736740894042847554884029723891107830925933923483488404349571035521272118204043128683399520639553265258892243546966433214576676007760819757467157639557061468800189143400243001845316255957068955115091432315115974681941156062011213169370476680776208770989371667185426923195239252278116200005001
	{ bern_num_data454, 165, 0 },	// B910: 12684712483907479178602683683412199964184437348220865129576446137359792924326478396971407755825741775138957644425335139920583837188543887730449280210771231821213518645625851420271525927636199986340308767837488402218571759993192954080644493257247276990224703932664091734117967736721172276229535911386823958902038477678490526794118137565352332838078750235048312609211071772709599313294086610927947876649019076037350622158352120483478578278203508564426684885767113991936481088685431638453392768452496826083622497414099582153164547953605854543997156324066739220562509210686263929395212857845769869276516357724304387685349217205980447164565323324256168879714438608356629025161551641951366140675669375239645127373866521242131213213717934039389523963840786905607598078368737803248253792827068418921633513829341137899090799007888525191176097649894841338711051134129738659540763348812821851435085056989449983795431339668062128987415768027071044556741976886684516745210617765708599941458362987944525039833778866953560922493734512497891631511467482874264971142244911287998811171216390965513671188731465010130816072604684936788454554004913947542507056308050289797864510982807840001675943953456737807278251788654488732476401477769393323671075789084497146363010197508521237939777521760003438165313189198711847533510574172914650214659842487575396503392667498492435683312781502996465635558449914856179143804159385802193068507101077885047979354895285373803035491203278887034632037497432069251727310206251377049866432698128347822751576308983365672819230351815539804623957202525554108717797741282272255
	{ bern_num_data455, 165, 1 },	// B912: -2318490924986933459459481903208005397734408756573458676813834923513587613162773798569755003396710867163058399647098472328998391692249286480298576540855710395902979199049420774321933690528814498305139513064921637307109322903231052731063518824120107267742774737513998853107013247028727302025713858320553643871397351016054588812241890997610724629450381889935179783975968503114082275639472417102774393551481477719747146507406928954314471130222508666590116044479541586247694390979601581977939677509831155041299284623384303639476364276263985913861791823681783772175074090415752191230342633746462151947208898974995566247188247643150253807834040337313661520624411936545002497468789303084377856464561183371674878103714235588658584417274126904421258407620572967703009315911336540516422936204950393928222360297758083654901698885521577709768760228682671494259231654249816645121759963086762015586555921072675815351530109564640413026967260622439880833009209713548080748134463718813138193322733015139443192089402188600862898456312435613874325762396948152384631503073391764602899822903721830297233208613738278255119684868278562430426246791256843771024971235551066253686838944504899535587425306635624126672543591512147603119821366053993372554393809974148729268028492555141650876094411916396800031331669355141105785641367252788789127066267351624327321207518374858417932136509185007516267954408912590142381749032788590973916663948086600658180578378145647670810752266821077814522064344074181029360656842064310247368717068083463628952347464947669601079352915791991213471496900890024118976901541039820980473791
	{ bern_num_data456, 165, 0 },	// B914: 60541145840099930515216772115720458384782130297707338799406552205655563768948451247043388195234295605788750121248142895723875104564645203984249041055187966956431856451866869939678802955971363157521241571463808217249064034451553226886002780479730085345353592789012784671982172566221727888114132486355905314811224087354299107838418265776603868259690524632954001036390434029697465068964156076318079778122007267537322092423864921706403082924479783806772878931780366418109260891344263768324994789087501365424263224557887691096226440349090625188823730912700311169664916616851467990216295774594735064547715141392800282910128141300360356725075026507476181163024806300395005892184620946390087054045687773732576391484855381282702248554202015979555263322918230449047869592001388265476640950591174216545894456154373512946404539973803397982048783644841636211813421716885588350758544393654454397727874706844398678666005785642678719042406491997368091600411427462042442359809627337443896546567525564804110009147051219192913674690325092652748909145990213847347885347952715321680977441357677972250960215623109185670027822084362430069191169312872726061694897486120925687067930272558258171332458222713677984012290461623291816279863457792898256634514875694126536222975268865820979732161657069805471959711512581303005856927931474498692546032419793094689138332060501261687179416310611028191213866956251881157361269314544421211063127226023266089932928828465636861948467059147007477399082137690530844891748968045007304567806102652104579427814172244203494963630306094542827749041340730222813735155602606266207
	{ bern_num_data457, 165, 1 },	// B916: -6426543799569705531981719080077826417671142101905051707446808156749085156791797138938352971483203848412330882109688802787507077223000942935709697561129454288130189147589717918508292564747320504321024896211955019550675660593875737240349422306318034773671686086320741515613442074469121591328238128054568146451401504583228695707610642343692268017296054672713602752526902037570682995281355988429909325477134692538836702021705169806990060876056872765451809664588826410763890788985384370199265110942455479404359640901366451724469778355713582960299974160232094009605347016077116757417381679094339046109256418596108279919819021062499613212265053244166577129949249430000123300443970710627634639982714813138412509245996800706600531225198778696789126762076155724710939939016163843769228140782998433698544368928019645507623765107244669806618546755668284265537455455251719536794977079259540039775130252400786361493040960889553004342889761572388906143378610077650889776822881911113281489275107342574780738740463603187815212399165508208130099492472630518120806089657348150769673004061355006247619148401342632413243739690372633081815919401979050487000007798725983191079444179376525944742577304982967097260887344533573035655087853530325608118031977686088107135657860368101073393829115384973753817104537726015883919086900782280119716874553522937617206002652315724420543844031528050541559473868818433998601074047503662779977168553062661951544838865655918254466743843877514591568332031632357871035972867256482910935125252711886277815074895478040223928696748934614241951140226569946449289240328751141709195801
	{ bern_num_data458, 167, 0 },	// B918: 105925982309001711817758470680803708054950145190635970480725532908549343933073887143517352281595012906091582138887875918467553836999447909570091651050262685299635097002381183505030047634669471821851287304700320151000338882393837955800357560289065560129026571728128463050834653170415399001724739945278580042027090260949329566009856763621791983194638499429072443027809588628583553880389074629400229887036588919799371216611059007628631053663177827507704120957986029612595944903075196334142728908747416155362855152664340511817094251078074955852104486654990299261316864070047048334908990295865974332274587546615547978265450054207900109175203928470613789266000338477297724850892106173118486588745405835337030234083494829216683853944362282797690352841396984579245691233601609792612169197117287576454521938575396779937357174032240939180398470327276990467621919524928885225571190226621406778468793648234193887382973540249324594701790537143867175840514543341174486501080163058131143942111156080197329855474198307425150347073514367078573807286724180234498254181508518860774408939508694336045589894267422445963092129966940794618414924406622755640973832207166199360010352464066716987653574976772135737518973553372125120165937662774071554356167102550962680192048722295649039846356806797589301621295597840680021967585427090259510954492952647208929041668382000520382099244334037717244690761794187886388638907654554138042629111237721600604074326925830273809984732798768487691913924455829265777390619237296228010695601740822125918536922275555809321630176694248482634693442725585886411423372973017740275135187707776359433
	{ bern_num_data459, 167, 1 },	// B920: -28677988031282661403934605942927364402050497681540159215023983473608730732622554204437732681553541773427504502530125277499901854975916017095883437728655414138135415233660091348142332205619495291064448729619987857797271963809039909935612579392945639508431141961894555874959927619683868438425431903330906050192129130758106610847257374874302121593253975585025635652099894713522637183539016516910745297812233186495690866166616164382401316446240428107492587887926408921894575967915590433420730441463843512017343877219555356608818897430195808313613943168459070457959495872785000693036152113099960302598170531631311894758634032845844056366871186963806730894315267512280911176839522436631472691453103291980403578156627989265553960369213857740583323511532952927874162193281862959421527935584089686403952479876568427538281244477595295427731851098891732133105834964103054333170197326089871343125351122331774706028869696932370223346506341859771188382090879037526310934176322130592069613305958835939759685411652356947612175108839891596781700250753558063982586789934391913955560989185790578458013713826760828219920808096520601433726284082585024265135099846987834298373701893641557535793832459928804286580554216679431300305965164226550126831451922401942479915505252868511965305879931824131314891026674748031497885084985997839273905098550624036144295199726908654829728802843423597247686801357591536630773182371156087241759757450489306932534046811289576024722644459318686592477901917149317389971397464842052098189571549497264135102441996136093398643794909554296455694676368962677418016670094214244842444039065817516803017
	{ bern_num_data460, 167, 0 },	// B922: 12625080738582521691457827345908390468235566167033024196724211608413998173043665213620669771196483790665996371813269684838504803006128604870811890152899539420454934074178155272712615709301657821174343212493664639452255292887971034407788168146783460746126971208711856675227888383196564586914648087856291642573638785852028160888777370196396313729068838656068136631032234416247064808290111436221002726890856725257630236195217992041867091982873364711359296317585896632183195230297288721570971915023347874110380869739108931574777898856993143477753601912970386863837802121472338929172594500590979932523653645072610094352651212820556878954288827482997546079983680874936407591008929403888342973816830945852177096339170418727547100781132233346739172273951329962720170820955757547116046876315024718943298342865120465576315997011317758175515240167116616007398343780533367772140098427803299100021768717404315156039860011357028811844749785208394897425935210986301511067285630037851822417882014080184403322046917463308304586858314396297753895170290469315930156982297862114527946048524944094268073608305133390830971039240664390193131591094848013663982142998826070024017141959741738447855304694705291937808278992425762378819515772442258721069283787815987534508201921995207033761470365094224261163293656767034089518407539178450218827894880527901541187316997008545447433515310768191135220850755777865391477606824010903017738113511121858800765571949427539303356632447785709611762945441875759578487932589902336677332871037273685804629292324529332177424948450297317325324631576446128196418305680192004713215130453338834831
	{ bern_num_data461, 168, 1 },	// B924: -110410297365188554223480576207654991192191877681804442850961244304659078008377006115500899130305511461765008788909684172947730319591764895192080104948640919003348082551622863421427337322565413256011184689107912518948635325365233894590112491264254064043211870753563840927826494324449400709939426090719062764530145676320521072985424298115474625214914781667126940095269968139921285596618493061438735853690917352987749627399398805654292721548992138597387326808107744132786131928621735003309252978434210435594405654681623283831809538964013447857007599334399730306163014706889011314995797149867289179477633596580235251627588363755503129446699679292985963171097300569119492638134054922404982826476481201876295206545607907135290843057237988851421299307561710584698051016099260355796614840590168292198641784967421635746705951093877945476176662881139563225856025423802965396659279756271171186864868401603038703097548113633486680334793618520843138505640325947632538704002915192431130949016707887894866677014503483263243047619497716809548147599404181781711196051646865802826695439020539183716419850720992130066334502372927380747541956740594375885583978418995248068088525178027008098375903948112399114445414609515268215141490380668760691493525916122529488327974914165082435165533759544666682512504320866863468756022689723490516735940656213853556099542662347698089011797028994910771846420898724256061832921494062674878025973610683407601438756942253676674752598459815697139768989212922770141689199421130713404508317715366968393990203391760282141728796937879206292575117627612786366196461104188872201279240609551561974288001998469391
	{ bern_num_data462, 168, 0 },	// B926: 5917538366765656525562244047082541081878442066759352179329409976014170560782427891705262572924161765140903890288792336280844083860733381833868616150136749845980196984035784366911965435379369128038603468716299439287569866001503306369263723734238491394104788599628365426087006147420228162219549170116405194596252500762349084758124197277246845518096546855437596504159015265087840167592427840115501509697400262990418103072430428396062856270817089327762913670023893905237721653330296277504400613362957078125398751398347886653104395816020684406265735756884967747011590377450232290918197494726158535787040510755814884625994276391546299251505067065206604986569646191147406273696780127435508685156712899877974931778396929377595222476880767083499106483588709375092395157402396470789045708515774530995380470421575396085300943232661630573619184871754013123060419028605152645007747063946768169509970597983500742560269639763542772732497053969149432912143472652653486271032946102129650293838845117216630903117581326803128671725537406417011303486625988708778559608187082193898133468786528928472192179412355698296460023681096405403858754015674112026524715232116870977323479155840898338897605466166945229106788913519904523754650873970070147751882268174565467587731197029509740966423356302788539588076851172085547935425779853033790073573499013894509472022478677019558804064209298763910011866427815829564497662121696117710781949363781151239224078812101542531869179015662951759433075761015236648873322785617320829317068081594115886721431083247175153135684870594160849049650032717340023720714804169840551117550493596916619944531303
	{ bern_num_data463, 169, 1 },	// B928: -139975371373905015222949069863898259815463809512043381822899004084300276534845329110836637292273904217077308226151754619739593787073457283621238729290589207547597548908218582209024388003504098861346188278916508664511139283160870647719431702665290587043772587339957647729255500391932428816684206293804806458646394222013440372600940959229216505972730714197672248128691788034822436647378472089631085533900493259629904865868401927391273277478513541297295223695488815228130338056984247023077224566539039498344313477922098186282712496291192138388262049252030885622881229716973375413896968172651233373080462735674084429626702197755569047026013469419540145607579336192357511896458243119645743792024852561859552287881612102629320038954561014138770630183090974622109716981843598221572673790327773613848153089877500028063382036205825550604570867649267054299715628046351414084272152273577842488759801532996846874120457788251972800898455405052090168643317869735518450345346431202022790138361542852495218301446004318460407421820646952577374357145031557592910741360235605133677206887041415803491992099314451359322633548745813897970427144830035694092694156167694078419987288632332878667402947217783066728049001957193938812159204201619725592459122976663548611727355024341197094143935424990575807324526618620637481268313601466041570915115534131632220808950338575558829184084148035738267408818097270733292968554183937601607711111138853150359766818771716178664985960738276457674925056003751485585097856934950327504683175686569855077585901993039422007950570162108429734781483460230045729314130949319982514653871295579211576935505745857601900371
	{ bern_num_data464, 169, 0 },	// B930: 2094887907729106906134663599140754468081802292724309856622386006124147625159019152962962744789330654518242168099242826908836751911826951939952809228690654047678072753663622638837116217292154835482938304226296548403635031681139363795990861132203041950306365906277794699378676585791413819794464120618087907923018346822004751281417555787388235750651113580187173423340141658082774837513267439778923155240324479619942212848480514240281681557254110229260652181338493885793660322956718568035903492803617937951990471468160858584524195287340381079731602728832171317173114378864121428194092658787315648641727050286524607778371538504012613899995576483604305606468153261606851209624288538185039739935696087438904293291703477431578850486924970348923412061845451896374405822557092604818707085636097065178733927972030310403550968216558826414900290705020242244424225327620680254586885460978461873462368734234352317658928017021207186507255408941556066392414855986349011028257143290152728612179105591752673872638650417194356832658921700720704920371542150279109033743090085996910851176423869689538401467880208041493621234438896672386562457435501566912787599546254646319649617911980838138750061576584242557937669655062026671969580650649210676049371204695124003957431067527000583441349610514154456917726641262595058485390749412630906969314542114500597514487435684872246140376536131808590301354341069151027268299706953583645450876228705668773615863239268340496032516202041312942579766119661700981926686454014549090564896784993862796016405427466424513703972778228466851705789966394991661373286958315741242690717087997195555369101462826266124062955
	{ bern_num_data465, 169, 1 },	// B932: -144824061685482041457284283814138796073352832936598235332491917999320584092739817278119746896819095587596424319799597307967852703959218511167075572715472586907380718050029461129319313668579107774468603961539963122406322671597857265141568682128224883633461041895237604053227061342965402384466457222348047187766032665850850521803406081128075116823292990889271580874993146860870605303334940986824202699717782185568743884009614901661980718351130209199418695817010703053761208481073458899748122038423392467983906464106938159714948138655742082882042338649306495342399959059419045850314985527617640957270495105000314725737495037227473004617203913884865762565427224066236716905935078083195722425009923505178661741355922961093027860089242891545146648905311024563915789336660839894696351210812234894749671914887825518977770303423627769511574631033972135743044387945705477229748838925586784003324163797847418632577806229071680753734941338512887786014738553138490873018843431632478441229447983636820357700870782883190682887240957458244462695637488939171306956876851042883361832970276894086816254311143321099131200818412805313550623202247311368673287433494699236122577774456253054299977893120108843989425066219403574034595272199821095572250773587929106056051071315928864022000976478133633917073677850787850350598149428496196723245236351744308819345213898625069214442120669455803531271559123892112420493858382744905228250355889994905263309991882026997377264367413321745408279413684781199730417590393860015282139051001150408731901228059796782775206490056297922687127063518176648882266551621253186842209304770130642926469013898637507675516667
	{ bern_num_data466, 169, 0 },	// B934: 1369060441142309278039644495475986308673386290904225524377342917140857775749629190937693811271645868174868262688396958299397316895710556168558712191289130591790163164278785421904296938310444167644726879902081235877086157673937131058759972074689176923366647597986967392933755654141853798582734593550904250756876851241579275497605153318203409010266114113304797402837671618257310332863963514767279927703384281208524488056847765675334684508938455390478654257525314208959154356330805136077376524947254294799354553639907868798811926632223708027188456921438231616817092945609594969708973834921239946993868466889048013907995323774937641542756621000850209180169585015846546525921877982423842823708827530534108516925341384238680966559419853049737494124879222657392557783991801089397217734973910932080029701003954167583963156049682698761320653633862498197474336876665178862400214119060497269821028651097941278353156558219979386715666987045896052954723298028035132864417852222223624940867577576762841656548286194910197828060566930969243934475120701178033647666220631961665735254001877412729070297862634552028010338790224510394186071970565935108434528397377870740868322175087168534526619100711437534134577056535788900171968697723608476285602578360501993762506137849847506816471590508653281741794724091367752542436563797768449758108978320015800989352670001226096256502387316471130064590476544086941340231551478758716561152654850240101116753256851842241382087529509059841300467644042837811302520170869007749083686812833547598811228044915301974677990514481755604767831577782268579866614727399357055918107348318157000138032629872176194397244567
	{ bern_num_data467, 172, 1 },	// B936: -136623833884914029966388485912443289304959914514284095445299941055250578395236743101287234156262418124964242766765093857042956594137555409010879019458034969000053950570557086915845227411262914536296989118623207276191181530663856303132815466483987345853851600241189519827543901470686735686894080158420157686331777290927199334525461109464590658649409068999026230724167658491404773468002030209738003136442199537851692042778953264407405367982659838598981987964781342421803299383281847918363774760051068136913309701670092990773224644982096271180649434391632678575241512881129731167710326486228445173557966550606536109885468411230892361001867686845954389791182731695774634373808680707960038743418502785114831957281093700135087725115689541165577801203374619757452805368327670330678736405088051606227701913302559274631029957725384251911905835226953393295649354215466427714413202144716855520472718522745638329148901822315600790998083363549028432341071517209895556435606853220094268137503183904714711128506428146028529624292048082388141268378380107215998507720361025769727200058107579764310881777305030589692779438567983202487253420383745088962557709746438513587479284479903262421612956397294689041940822117410451512082093474740817834530077744124112259335566042531594967930427117637561089394273593793209253266538283767122281622835721206456905937573310535370814492094085287763023736345421474734744265194875741494387142019838206024653633511867324101891744681737116401572769214495791455618565220063600847557314373797403281745998186964225947864814121335342395877674037426409278952977410521568775643332633401905542833801836167121889003722061923789778501129757384291
	{ bern_num_data468, 170, 0 },	// B938: 675667511794714323385528162532534695664965771012121136572172425250646810624064477283335409732303690922245918074603740161579224837123311425836025627657409281625493575900375604928541174783682303967137611887944598165892366423924879756427786704102983345068604297418429339061352297330782444273418510567605213589900094753813324099988737486775451329379207862692387823635331435812048705055453696268091824664058761979396677604801328203651183926877185204911992556698435670262651342661601330280838126757317903328305029757701116897019107887530253401677775658754736415089797463780078915403786460168468816999366832629591429892992820974973335778798567477311150389803711924671087587854278969040696280526727170978818492223764173667628704935661664869596284497724225388206299004310028173004473552491251497047723904764232613357445821489863648476887152220000151747713458780258735414271375567966514071323063428619804124017680480358501449829400340845144600650843958060361717550998610434892622853666387346597719982121236614396197969327631414255256262923532097655124602275158477911081072898237263852859168354652504079921983412592320225910249711034487566968548527248401126272805828883389107909826778913420449470241910730765866440466454423527541544407832801148054183928466929491036065229217802238557181256142588808769010224432543320696703808204379989424537975260446993090574950266132399203246734831009183294100597448482761517649999619761532804884594730190463512680719360592348619927299957676995037745961674015628754480543449955376862375036612022231117640268839662944219848837409320807313318293275218703121178024188655924828749351422829900295225057109353939211759
	{ bern_num_data469, 171, 1 },	// B940: -781842112600034139265286297098640659598249192337892490018791623277693143860153230314525117966826666413335100087811128218208965181481264895547543320883023113907666935420418078842694659231601240465035392170588507660072876839768709841062283674477172413442665743756841953997870926434808275685575650693417323560330071757697642643373405652555478187692088764168764683512502719669282492294884471590278996274113481523985844154471526892023034176665584404040545376221429212188487001338732733524899039335062471923515061302597255234627381372784069028176564100547148507345052706467171188637663194010888143621038681828952647128559053872126379046522876813396323322003667258599363631430280915355609394522610456734920038217115767875691971884869813963184938142611356592303887917816908895458824502970921295239804804542701338065704447753211504245781707305707995596456639906186967035433822328485183450966646729930185152043682281038385993715096059523023209583100508943560135203367069144864600860258463449261199135952757568904175566734558389225026253262433385602470840579832460170331346292320032274413043707869763518905655492973676870525801909107641865036676374446750282916912782334787546193521908462785372368898141555247389496592687370794612595096434819010522384111870740930524520945301405415837740717640279898586108158672167307299514950231256870639623200737329383201055502616364028322349829638490459038881571542512416600603357900110961225094600747819652116110953107341852641504806168975218111746330625818755709124815857460875109033175431032147481214790623580321526651904929903169846275292268180068805124203096956068704415677729347237868958868669663970504389719206951
	{ bern_num_data470, 171, 0 },	// B942: 2374354579876294423093351336821772948632200924025364968968044991926270940271615694663265120413269819062556710574203082798448235037544263007934986186591902369747158438668295908749155585660778784134559760135843011348825572397698400268890498224989740740084377830404620560192437828066451448415416944785113280305853792578438127572799102716174527590638155125926636403235070862904172888786281957061475898129636033620556199818500334294334118275290163754312307861870342322412287735272593863045998629505012361333950013392154557293973086106530843171460325055423984644452916500050646306339639006992725360738222529380740902497865737637404726017825166490952828938773090285566562798129368718804399450623623579350606367088321685626046143843417339195132036770615139646000477123167571976943630365825723915831591659505301112212943816384129182128927054462176979933104331055994363569003757302541764061415893832942900066801127655852060268680807174954565285787668579137449027376880976373338073906070019573187851161282241439256466486778109045138378503251740671083731569227894348246115134556745523680811518342091980420399801632497859165404343051004449291337809170394407673857575421960426426757527641512707976241412783187401646792840825421989276210445328937399344756093099807439847342374175138141592109376405128026044735912201625783237756314772898554340355650218397087185952113952680786359663704506668735541797470673138009748268233999157364532081769206274532288579988754945329495692391356849638079365509103061711373733041338277649175473077552498571642048270160092922031875705296376713670281743211182637446655511503958453825436478151890274722817926733545916215924818817137
	{ bern_num_data471, 172, 1 },	// B944: -650115337285147812533872074016626099043487718558267251906741752317511335473071613375702354144234609954971512272487163585206623626404051151914470515349032692545672925061932265332531516887808675791682067163279809516396613273124979699033987917079162611764851958448737058519433114614564761653761417726540736017955123306558350807788834358790186605421193630964411427141675169287309413517188713567723682446083407794613428710594079157408058410598267485414548898287099535696579519278513867520589054748807627477425158689933599729340250869515140991286171304063194653764921123440709783643605548007765470692528554046148503930715390148510169123467012245784684772681202917478477631976100928718720289594113564293410927084905446969374794025003121121254645488306872318491505755196310881633554632515466022613340651352258275341347925202885055516740097636182364017461774380459255158973353744692732724430030223429170786374697520483669016973248635052246651435187901941740630188561437319285362258192754967012420916609340391956741025826833513161092478269542972262237946648854910714926223957553980473551022562117743363137718781115015217936983014243157711136938125723497756736047039348020606297523605925504062361418523531380143409952373317432341452203335297300413893430172701516625538171567186828881772765165566468078693119177355254152057788654701206470995428860126294935443631671462041838119461168693848401336585072268378392012902097018052798590697404240876809209576691853199323575737928747069221760159942310513963628544892509725186993099814254762239308931504526859594782799014582805532480223778718676144165063095074211787001977499931793017559745300726161437488503785031730017
	{ bern_num_data472, 172, 0 },	// B946: 3772354598849599702373613335184487054127244978386082816832899472018331178483291896662213528253688797799640897565582049948890357142738861456804926139456651954195917916255654937296197250557716555904631607301561520402259313145477937605622858843806418768367706096531780287074725891715680215608869827647597885351815459561237935368558653122246716431634602909134551467622177368960312930809441150412945321238689796341571891910260384989063644931413945818301102885241032911215746655418482215903803291906711676101475040591681026356118504227253674309091048315390473558363514511992501320905783429761972963351147570495453101962084123799932698553537189362115978084999254808533878907135175249017309770723784586393767951348875909591666736338146416412641926905443684400097824151598576836920308854956563921720031246512786626873747301255623677197035863621130192720556938606490303774876889465989228278698076490389731908694177670608164739796839523125987601099723340696198360095091783142927634213940351553399204890489243432007039732519118290088570029850974171788319912122179090849976727760939253727547636266753644268044353085661023336346150206776151545059985131480330978656048189494084173687420267360977024808367184972564684439294248292496970165445365405518932019400542156178605234901169774525168541049835984077275662311415235971620232601560520887649231542085889831016060062292937631090411434760625000916457318817693579407922037617758632618410726597480850937108662542485044521855468444990031809073855490557361655570983985093384871734340769764576142101072003916555288172436655168283612472366053666182679901592745376743148916167528403018970042723510375222183082353182199153774891403
	{ bern_num_data473, 173, 1 },	// B948: -568072718403326163199964095066335087992449669349571329681089590583476217112963238315076535116389016021529235631669466141907741449607110236684729753648082688818969643085082092038710203179219685392973895824117209016099417696105329030420211704634937285001287517948257429987343068678542555874765703660536334565908048658723310195019480897548350254846498952779301002690285688071700774404126460072976091705893444943341615620384160938141950754617453564653787921554034053974967353331175678197939079855988235359815054121387325450817875489473648101566900763941182333812922683807819026225133658098937644427426833634336816990581818248094093977468418008806492257446823559165124891999026572119117168184609261517961420209279560984151502627281828143547487083175512791818770579889810319068301697326279240143952897890610057928647935802236629688065192779137524474549686483468711574582723783139767076812542067461444788048723290943163665908801172137832955600698166393050648755293874993486586886917901666566394313710507198894364017745844630832608004878724926865634379752900123231091948934225160448032809148814105188366817679517924284732673001956371792099900436801512914571703305025042125860201211294926219932080514878292700848198401528177687830219511810411957569602450287653435869418730749057812985226225803643040822488371569035412131378566995611743564497877835841716602379111332035470553519411487738745965929428323793737904906623020744341312189586970890852551835481676523858972459421553540019909320668404086852042040261036814942574369707206008902712795560067904626422364627578202472254659701347778913783583734059857972833767040173275905702284961964145598571410143091711808679713989847
	{ bern_num_data474, 173, 0 },	// B950: 188968496372274522632439341545445003945622778183347679785091662706816357275563095677559600809868067546105546607690624671950393364456406170264837556188768890253273477319602252302997864242898685470304233892155691286918826344918540037567460417173842164454710077075999637690628575495723225172706181654062159755208640511094627880114188240158667750445772752960574444732927340855835384168433784003230512458072993253829182819559512723249867599020215549494138900675585362238488288133749250458870424234231026543250069330968972689024246625017804818990428107072095901896798289503923171771226488200194638558373091429472732683860862263299428027148189428947841775145222273228146207133184368559609482218827030394435910843692458553954227426083944408011206442531623870362076697439613121551673870432838951620220756642618096634795013163808133546835765090741306940971174743504430189308866451377637878394293865617088929445825096161433906682932947406164868030474975476995323597909739325087019617127618108792588177861670640029523354609043361961133466794922621573658990474755918191729059880130045062696606339822609230978411521284725231375390064951435068213621596981914240385965101457918721680247289286591794602455725115679467202333988817648859943550808880593129706224012412895539777898849169966394381066759583316891023347419678236814503145834999423764109016627923591914797506650012792029545214170238248502444657947746894353851472001338007144548473436923341391878177523306272543506247331631939638320583287149975751571946614480290387520812330933645193092723562573170625043825807513947408358765027064988092916901770662485752832826036527799324773395782839546409033101586505772605924931799069475
	{ bern_num_data475, 174, 1 },	// B952: -9332552776158644123207551592580390932431548478761155509972537078297414435912822520554903916484056403814235022377993591281834404372232494738558306698115564313161313412576645331410664800843103451271407723469940412445047154901540597381950010378803477618226307387498601194327033644605103332046023138911606618620458738090828423603166824427613155064754927663295553405433499041242389220179887597984464659084471183121281591918970188109247292526720882149904885203348368494782576139164753420889367521138424098326443168891225173253616469481510180123004862995913117946793739674389350922467133086261758754188022664025051843536014412234135937765016116323453681561909273562132219246080375456606182576125204924644349570738534464075833476981787931038770456016006966999234841508270469906335534968551436321502652948819506014295694424229457389026954657443787892393902169393790444695975347941495686458978238862051522142205036334669204497888978091548766327835741154657190206352647051314757090481077833787948496683360232051275005232539685443120293107187991736258651568473563867832731909447285087527833285477860972997503375732394139619137703727875050752585523190039412721429232740399217373046491087490514245979638885110053297763633215038580676614226331612183520664837853605183698290558601683511263286045830709019789346908680350391863180365795587082209592003307497531890055959563513331567814920719036317030381291064339206225635787164423663496472535686177158569754549489397960802468602107230215606853427696257309930994140241333225050132035491835779614482911992629782295882325643567247910587565151878279594192768088526320331135456872415228393434061874947587702711744926430696452295621300810795242227891
	{ bern_num_data476, 174, 0 },	// B954: 675986528100616156915380120051345589213373727153170063974675764060201679804154163720773815165942934999842154009132438639491070253679526692183716617293575241680466012162512874557087561161380631982433376502189811099897005480805990908060128044514802254133029137557802021117173097649347557939614309419765075925391842426716107778567630053062002542641671089266383375883772265621730738550014751585420091051509027645890744942552500442131588464707413331790902051857446771429078462759425689729050523083208859061284732615203623887341757676957371747815290100765023913922473546280263787035119967811094176654749524046348413840889108807620720553612117643123247947836896794790438369639836835799934949785396660487820219522995647040529918435322464551201389617437963611426395297919808627771901954096100379046644851112279195149460019589525812506201167336434331319142230509829783771646386584843206451683148596733946980393015929594089954214045486635904706660098985795831879307319637447937401656612113703042013370026512588017244557880355403027032635062725682999280891590994251267564659212731676821860220679866497154929897495333162700477669967217066003967891245253273280533395236463060693075258869918983606393866303590551237068722791478320628961577003885308691359530206508896388732895178395586012660842468729054460105071837476465805858542063532668231900398457575502296200835748665762802448920392807572325707561605333512954322370088652050132021012162052048909136967980547870060285132155805666585473893935755275636127431492023286060658442783698673095962658874160604267383963536829118674264914686266839060527471731020737490531848570432263223564175641523285384780143569542065835158679914198530071690137
	{ bern_num_data477, 175, 1 },	// B956: -2630932265386235131490213659225202560683885100111394526275507072174448365542989255019344626106354558197916201287007444718909494490386980691916435740423343748461919774205996884370896810767634000042328261995665801248732817986946703875208247476469366946849446515825203052014275024596743324875036537783119116259850993538909317793498094477193785721248535771400063934979470457748796484653467399683194539145736659683181731925678859164593818775340944735206909166685904004892086792776444645915189136371997395399361385317597592996900752349488507229794573641770022744775673943858562197571099256999870558780705932002036463891809400352312610700645478659645713785750056136050097119020995129310267583576735559509929138492125854466710255625560122002816781891276394709843181065505630121957519987859275663900438186665819146922663586084577914279046685276290735380346397298957526068301265613365981451784302465449219904643288663490770043378502740802888771513402738982595355243039213645278510480411319859742967160263224453202791111722966259634816699763517514000105472717830727114418165932071662870585385792776292172296086052688527232412762739252566476424951213704973524538639123537295135633820990596180806506655823236200317274384016540290718867774732926659208769217844309255221896422317593303621074437780067202697920879687857728846505720315136096501037147419475340950783296791160415630941936033009159463119566451144938109309834774096274147123055267325953035542349450802741166525821731140130240322129027145975284684468809922827683442180623429807777797241629808258035109597168576620915697382700201155006733281129508792133314138302186854027939716765482460712272021059948639279906047859730181145643698679
	{ bern_num_data478, 175, 0 },	// B958: 25510669684964519367165068818572551079962014788595187957517181156091412348628063804436220758678689938071107045822896678928238736624667605339296159098946886220132982073418815126416315617362003391231071236644540004444726268241634078756262776586099285127257639908407755022736005821146221664603029596016629860518563499573977966451189491584413709541368289437444201263964759986874130481791851354717028905425070813781539219627180895177083100696075592798022251481505512857141322893226461252335311951966245278403900309567232296352087023336858772234927762476237443136308331629258264791305323123928050433797569629085857429948456701207729800639631422236319351377153627876318045602606354482515686375596401842043258639015159361891703832436321445277608158805122128005845037557960484839759008516437367828466019829174884640745064836212232853066894513681805321831695667143806357987553943376430228448574639301428377925305304971378742572533597155702157549571270690849369756231013343361947618802052146765965695995126704470333524754740031183660768707176825938040404834655979540678440444521381091106224486694769681018760029650964117427410776382090123939063086322256187711093948636522898032793051081363722021507357426036491948965938534594367234775617659431432273473643979107696060743410417843845624557909542822887749029813027963134619845336920796804323865266850646466857903549653920019530688701099305684296976209930035785056776245388818252568704091491015981893514524301776585663008285642512914007116991062104102950213583952241222007962265543613037507369864255362749206706895255847677366969274986769729718549117086117141584446543741739480152860307687438253749316334085307469722504835019308877222229921319
	{ bern_num_data479, 177, 1 },	// B960: -17706243710599040267493199848758098881084196573400516800807618283158501519684778443003386750592304997238372018997653231682585275972451101511251152943358754075232818237710591973273371292035382216395040086352372231894281315535421317512696687728632138694327645716776793320209139385840432897246393678456290772054313473174852238457463328573443235987621676672503373172999936475657863958926239371646078274892783178079374032999049244094491911818103307068161105139668801221524473516843271211938396509118705733198491760505352746325810867170133357930621628748333923593893802430007146875764781035719534499171000648800216823522143422781404300756719311318271391955617124363097485808867228081900116165017865416058974662005248918438982462508609545755755870373410211263177879422904422154818619357025227958954923438697013398036035415645487627269703864639054094191527230787666125865559656145741905165018111002417082303083284239642326886860736209362196660409956505259484282009941533625770193579891884386948481265577428833489022847612535959761302990565267749979995032931342987086897999017695524241620527653169672051253648795130814907774526370434465082633829423207665078297719688162661206715264537835642911245197613132068954233882056675743168445410508758403378496837595834532594797339396602597536643444817361137575779234829661785743267078856590250791635957226674322751208911424404648339958088460415467816102911593852080331784424007516330822756153295659963966505343629454477588897685000843992231424674882530956017208575366593705647511357716153421927252370317019422231508934501327224644590243971664929258792397597956393142120803689298308978720381363266262911599187266228323457800991241920870292725725297843186353671607423747
	{ bern_num_data480, 176, 0 },	// B962: 13931269251820185982687364983400006311332083435114869408740815078471240758090884300260382709592209819533543024838572282800996848765560103150190516105080854117348345229098209979791982535332350201106246503429906660853578924015911354186888781066502185913552353457715113059896963399031326180804141100107624276581220792314618564811672893009072376336572993639617416749388448592460093452548311906122857850068032464586730268137694304050546653514851315151673253848176168524596531334509278325528245419828844943635776309689999831765306986062462287268696771864687224550596967302145585723516930393665404366711694452173595465322621654215512717202711322536848787592856659392683251925205433013395838788011383219355013738664132019124249125418595362297959782881229777414854868883396855570076326687739550148517685764025107337938984455857145248524717797990377580657004218213170977844834872887587588230519943383855866206739145175696108672448339324097393580497950411849483750847267876274568133010989711592460940857635186863646079162798029480886357721781230442307086053300191302689445483883239348559189613315158246833687239921156122623959826749703957151578741673674717488048896824758040621933275197082104475733495451972097028403974740634504994948733632794719629091212254270869205284110909978397359213223332846824301045589153315501356140352521304797275608865663742683671338549235352416964108876914039494626896752475079160632910695882501314438426547841404558986528494050236237991041527310255316714194731058979889604455372361177493675227317545106404901734926071247188146590527216216767929349150146354355217197246738940776102498466917750959156650370052638982447644497765684604503904108878999759471676343853137780351
	{ bern_num_data481, 176, 1 },	// B964: -1637963706738498174843409631157265341517916072362803249241505125126325928752874042417177804965152247661525326028443360486406481662275425361045136690140661511724182245394570375058070572504344843451462071384055370451971789640725592800055294868353681203173375841546854536714807525561403287523725796032872728239074442167067270598421858210423526344666682933948617386929399357164810130358346177326342245902915333923094199333276447795364290131704979229061694108363809476753201214491041309496152047037145845482510972272557816980387343266412536770330746715393362578619783157309784323322263238465277742186514619912970990079604188151466312944487205615223938157233462206386970131104535950879777561481464158205094216530807726263878905104903689834186315388663775497070686561058052590334417151067480058937911005153792060863005859707782069327305935906086223269353277386847076480079630410211928749685909497077221015796500093276398503975011598100506397890628039412028254061416638204525865777082476688363417365446521580183343234530505613934274122508023807782333367389158366342396499370041500162165925412559767791421769449851647573985465930137756318527517101466014335124217668454730919707705928506918109083487353840835829401245784352814788269843172650123850031223343646213567045886807631558561172708061289683750340467579787828636612686021032238773942811146974213756186557201492931393081464177038893162865562589344180098610797901136443488334948640228663080683961748995974541555043435655894875157190079944947686810281854577722658024140744179447595361056331333734020309791551568296845798105816363745544811142387703761815824665860648656771261608947713559471490157781060984367654853631148843567150532230314287028571001
	{ bern_num_data482, 178, 0 },	// B966: 14709049219382002348450203368881088686185263922847275929831955156251549794562583759921571777364003515320682751347265542167952016503518546676156345147864913079362010954466731595937832412174423335014838513581624149561076414275634112628622073469559236386458539113426074736925648077455560147626304102963985417836518286483246283346164850174696848786496558648033375248759569949565768434834859283201522984627734653741258594570300750342709216758401151638338532228677912605812749093936961088212636415379442858043889414578318496486878672970934473159469643033034922433431098576499077572135248143659194994438213000454549220786994507491235809207064678587837678165783619800830822053433462075696904941769939170007117314826611601517048990204549560473503502254586960499153505620897551165061709093445183660702353300356530282903161822754406291006894817508771683345075394176269375452201364650043645122629214003434607668933416393592971690541688573025625226719753056895956504110379031576523749330099765293202481092780566769225659534904784464352357250896037017176461151985174577860377275187038028348044301496258227321717027014491763696783093631522277487050525508853774686271666596047413713651821138240893875808668055666396696617918736866249934398030776023501913961196626940682390398294301671320413689424756173570979997286908736146099420446015499242726280322408864555096867399821793450353393526195036803087415383480678108885633597600091474507809998250774183589772269735371326242417090316528098626566038916345052605430399517639340238373109539954552362816851870122546050856237618223123000279520254073727298153812743692915715727782712477305904978410451888382708619101558442305952868475268612252121540179027563865960250756425146679553
	{ bern_num_data483, 177, 1 },	// B968: -1877192952189184150647500209054408275724331693857503522006354277574331545173238500624296255624855636712841243772657504046261438659632771764029653425638198370849974018384815952003721703953103736629828265914319920140639982830581150703555847115624435628171830447493612749789246245798642097864518788009828954107732755841503880838997843869626179169313654442287866903202635388658125229833426864742662447826207114372640687090946942667372689308803424035803653080700760775678069739196307487447184089431188495147506481560538632062994572672063670497162460695156189357888610248823576710366054877167014333543573966681659750063884007131295412351845328952717219051195813785090482156811351951904334309412300795089020218846369646659821723643396432450651147491754872690802148200490180618708768900719881443099693028219651227788052450319375078628689805314374197103480648174649489421772351915295364221976617338571562097157995075723910480881056356642797901868460682700946947978641722839195881340257517871041646849796794778139892306743321086512775907997091138349809930956648041843161104824071820162838087692853523504281627823307986526663559025561299467972312706927560762182911421670602777982833132739746532294483593396094883708076840992708059555055693844236920852321160558545448150597274758243593373896854934932061561847727499125022568731698399609443404493087609213636885790474960213740709712539751323505868612562845636128496321835504653489520118159027306621709984841106741559755426146028773962394577238837096118131133569164985471786168568535190512923507447197981173805138049540099474355341704796544995848666557288816221726953632376656654728225654054512799596272333176527302721384381349783130024333474647145468077598875469346047
	{ bern_num_data484, 178, 0 },	// B970: 46641097127642069320236615219354452345828693552876060179127872387482737246756688857346462574430233057439036759745698473720414831364934429920700791815113051085306372734273573651772326777137552495984187833820715582943177988082493517514905683065391105168343034412436426164067175045824885395511370338118340174543608508555473576070897631937519892468185315663983003709076895577121364075957005371984956020240107075012600629515914998229566278817187739798228007127619645830253703980153379391710415353431929264302584375380574047626752397596066642879712490082022086521430227002737388427348558988069068653396281299702349728066420984395130884377307625233478168142964834345197319775158199632348182328343077070135297923306236485311666565586123446664598516818597797487728346740690095823403238978548651538678581747178005366843157496634874012659983671773322151931537609203817223237255038579958229906462833629346976934711747066053482844726035685032109200046590972933529817515343078675196145680469735372956603419184245625309147097898800823889544758509807477580500546459111737159723472069444864340466655213479001992423718676451552085410424207795751046379426111220404623500950042136643710651515807102832579004607972692531526071851381492230206951822656321366578614908540451596900905638763666972099782961325726437520997484882983496218990912793389746859894375929562830442732895321152163757337230849699232529408250928835971445040440756444169663267093705046368132428953872419605219568501220421658853194330192758101750196790849618119017830841613095507874244169539703744310169105929437230388400860185163840869025932108712215423085130878446560690856007791966082393155732396588227309387127727348801577620852752290170909452236822057145474935
	{ bern_num_data485, 179, 1 },	// B972: -288929832605438676009190047083641203897326345301058186570024553707972160965986955772993925461477604921364711234302069357012498388182941676362052553850806647006737753078562485734077479615781113765764750973564195295095637863191575163659530411316962432427910361627189603735206013633908596304723082416296288011457732947909494924053650276434728760396140665947339520072983227658813864138548905011655961433821296725818824951669360322591389097258044959199379203910897290148516921353202496556230696120315701137982004911758094466495056714199737052665675725944732933533533975176112197078296411589366053254759166610564784009641826933480656330544047364687242726944195264234141434868154828826162978329438707552556680709384828102671920411838766395458067446189883383159939901070432002143659358143428982284924786620618947868380213031306445365033684297853168908892876449002376580078664440393197266858250276177513420644468804302006061058213858502266766315679452045387635727037300117333556964410415351050105977424423819017772432092970595002797370348945532001868147695446524231897257494146086147821801835836251936438808739015857613818172705041550685670183310071606623371212101602252443752544467752290885050989144277085057282153342621657508515193779073315746899737778478276593100755134612269112089287442917107503972568991533446987439189994457786704424711437306558583515147015441279675071779370959535216307754482501182003659729356501726264665632146832989351540639135650717116535822272805780202111515487164066568410742379261749966962210549466461493001359469979977895954189609144192694720287147992307502243199196576636115837751570194226011691837667405726640386134522152961422259125426048255807525706894139647845808980606360564012492032303922201917
	{ bern_num_data486, 178, 0 },	// B974: 2506078445294227881682442983567668244142221964403226295717285407244378762992214969541238672858309210562595114616697556515721329990425799659366613937782662379826920261760974664082108355993263855624589256112489562863761335645740960293875356585300084287927822373871998682772982240363176352406223338187850405004795524183325065655054301910184417338307493358000957546878511288260193749587539645111202681879957433913845475603376900064699293860168638461218049125111219781252132696697037812835700379583401765174359391122039819331377984753746952335559142342325162443490185207292133315034671927202456422961720085086177241681578935124323343588451766189697157148913032275496564640083209442578716458497040456370848433096597067696778816456595660899374607295927212750654770959169700837834389994729694910808453323355918646415972336079599544489128751668518632639986754038072469377216790241675856242097164561785134562854058434401143911512727413564271860685887227424716003818982959250548031619580848071893958910474892239768995454697697364743996308335126445698521447026353569520298283445800425123518011811231387053847685628538937034019236917615409918611814246653412479638459620914448634779558930973804202028366438137808976381671587798237187480260151102062660824667896595033221683175965012706912343151397653544544634442852043615034988689778153757224458117432958395372024915007376880323452186286815372292348999626077977782749995451079991445547798191661720196231298707350543511851242359634399161990557388338502641038247473649082695804813749916888500404079409565598556273016468123720257856937003896687492264478788100928001645228587274074166915245001640054390701679471173369069474074375058442548201871895112431218399918124345136988647409287
	{ bern_num_data487, 179, 1 },	// B976: -5016523456054382461011926306658888238543704439331798279789632201462791213295740442282139699843297307078463640644775732160897904967521216569913794521577389829510965841080407963320931335877751742112193714802355175347781639513992459815109876708427519975559364635975421661084923616287964365081373069971416059016697163395330060917731543343542444466488290062106387752339309144178392339905590589850155605812778110080485608511642589381934488360703065352645520192153298883333121047781057751546798768306995172553084754232383846126595333997416893306569109585453583274446545784301213111414445759827850260226340990387432754387695911120505530497675209503265802165425841071413625415142322256987112816865367314926118786382302224452058938354183152781827888814630037527241977611895428887114226057207500522472903345459642810505300422719222828479481622733854056552682680069397875803917475286816976535718927460203244008878606096157229615793803388344307887758611046259934872917118475003942978884305709114808606243464237801957161708365300128874936215472365592463087166153818390173788421816847700916358249725376367836696458988961401596608072899118936851900323669659955297572561579766329520365110063351983344407783524032117053270678718134792253998916254461030920257476319839406370674762098836159117164098953308895097554772391083602437355281310085839556076761344647656489335397074017387186795272369166927968553620084647075393373961312821379243027972484745392899710971034658196281295150008490391334157373022720733149258653821142261737260750230937964530576147311464964493886459751292745058807501478834561668986737300132837101213082879162610949225673998388210873755035079785574079561379499194890886714438436042663021297261558643749558593305320233213809
	{ bern_num_data488, 179, 0 },	// B978: 10234369193620506479019460067532993834947551633202557988620337489401645231692683276785222530798137749036916016708065727677699660459992257519024927301708611382957466320233542747329206886273856710060422347889504853091233301007539244731371118812306596084625894914957152688981319211772439845867867448440111357080786871468976266187322209158778650498460121530899279176080758813086261600125977360577401080806154598231914684474079825594697262826321903115436538057186963119039439635459645811929820157422443210629251588937505308985333515830682042213814339834931678843377177369070114913806878466315897621576267012669618817089328698626578697601167283944309029797930369196360193135375861073267879808587228843345905866090314649234007308248864441429527580818976466503109680444188930611479404104933532190193115734831478549877147947010969012999958378655876590021758855161069840361479894144123256472706511037802619441667705567069375680442003368665139102811384006031334535591205911768851378902201912334821295967745761567893007139337892297982257399176914505066339532844822450860737744983320526314560053741660751523310474667213197603360667587260482068577540004952496194668413139275162100031131585387470285678699687862614390670303296445583197706544705780531087182831828199212334218531287031407389609511326354835527035447062156993330227172707947528437099567990115114566129739773202183927185857352134667214428734591685667940239275740887985556317333715623865330207692252858984537772631678653060729757231062098390227943094553718829669786053046548744593472840758724941123538893391710539120382146508743729339310749577994037158894500596981454926924958171914730156050578285512115130280526223961048385813148759591247535082069436416438023386136059759728153
	{ bern_num_data489, 181, 1 },	// B980: -389205370922338983105388132226608518729230081748582081232633294607561069757934905220301736935236553203021179975996149325058994001465352482571148662513186277841064644845884372316376825900472235380778692404001743979327307049175346764546869942627226339533617206818682197492263787664304846886897631825914500846100840233507642405166053305659188260321897986151830766677277516264990695478469090449668430414742427163507193368940296106194791892234703125243952439244100516250438621980704639112194388932517270131704469981376408050099387164639294361343096811827030839607355467640922784314591101017713681516917385392293922568642075338414025795525497631669787753216516181251344540020280308736006135445519066485735120861385529409618807994887279335978859404764313637588455778660672154040566784720140047869737865065690382804316888591112081844042120926515053651519635365480394497854223451039758023406958495119306867003297804156696098936673240833807965977373113468103219617085886737641448801179066146220478679758680733290686104906426464266573494500649127999796528684843098976338985458266167077978032982199476246975895439969743456748764377908935802750556403372034914543728568599443729710232888159279117323119885912334130712551462629229690705566346612451120267230663298995010735077127640886333153115597025099640341079770217958275587943809139353059249828375484569928606869335988396176674009304055303813329727383925834675292211951587871200686258888105285511657524463307942129062259750680733420070218280451827971404737624840530643676811714574993041441557580529394467753771100069670045109382379179101340614815679574839979114457918291502068228060963523901956436836812419753499236931365019695281851035840018507688242167786187099229306930930388896952849571243599623
	{ bern_num_data490, 180, 0 },	// B982: 852287946883589106961550675127270030219835232529759304536038246881329034539294140001973167524149371351904613060419269728600406773535729533655759673858725959559719171033185981416848154192862877375348411201662777556569179643827274925580955060418313547662388888064048678854840510463923229369248514042103038739857790180490344923990395836777606252728832539296846850390082991651128425166325528446524506704513210056361178696715597667223948621116581980192958208652215232011183562298085408662321344165630742721136645450479368020617073449954548252245155482310569342478877223122863690470150356137729006662576983478521225236990833138071752621697144322618299658696253988644393634622494775033557166689996147950799576790669858630380912745701552625033522556132148932935642535793727203646428816702926904286129635269877370543593055836462941409814241408569620053768863601953142248825315879909789706709470265583564182236699854229286552373775579382903330065688828467356146970581871862993867421723792723742043532113776268346879992319806255561878011828511132864411249661001758080066037859319647502612339672703812303349628546056500743686508505600993646866916683318370061465085360974301367812317544075878191285698095382195131733291607169426259529933502136934062041693722939461936901352239084654362327392343138151857334853456057217303450685102627211841331968223189312068626875372166160041435648957378904590707128960766451709878543048386583905280107718783275624419679343997171532882095736459869080242659580378184087473197534404679798706774910623841285499564734140022464808043595871409417251248648574935870599090441059334434584397574511925737108605564713594851304779773330117421982970920861825751841222726534671799682034089037403014485729456739669615876431560113
	{ bern_num_data491, 181, 1 },	// B984: -802252718496448527584917343539231479955802569007139174047498566899429583435021246762420125514600291986775356246009369876871822295327465585196061915411679678994703298709672048994173628923731417527022168437242360227482905479591927560258150246616417468079659642306263289321879175205272383773324067112327852953015684462829574928239287163612908866538243956424334195364935554792987187026295419297104416310678936264464364274853867859412842090050250546103479023873104181944911294482288020365182352296102724659471580929546791756100490319835205675010003197254235809743946369189299544293343606260566651953069470797129745711496695293876445838989530451512057029415162810797882231432244838746698709756879695723614849911458344985815796891092690388717687332897476186042740879138033063594068983743873573605546242839504086638136153587030563414988804169262911630743610157128509404858994779986647372158067253286299691946994366462920612829009323157571594990083262159160486343048617197714093174231916085374466284508396293730858530562973086596604921160855266087124899812501389186155073098607945665474106786966901580273620998131713220315770973442469885826535833821648918631617758185322647063845130665248922090722200878638810665738308641185852285700199703075405528861980407128970695427090139215520028972361311422141106690989316055563399702311386943780123236918790172967057670939490564723737548740213648062634179297186818714845404898316723143673703066789759359763863340895966193234722191356205022941884356970786098145752099672144536943395416700652942998013918627899159105078211460361746933658618420598930338944460889456606205215142368905479600915395643008242531030751348782073857701568289648130119237623533810309621818387126043762382851642412788627982539534449883553
	{ bern_num_data492, 181, 0 },	// B986: 30833805514180792841352198438483945313962421027875567893732715982706338586406154369470633830584560778389618742218066996271160082763050643724106820652189671292755230174483760201186892778817167127432384251804770079843774944338925953959087501690948458572312746754335486578816709440416477812376022375723856078540326301927135709923157761078311905311173496241597796060011015437945449514645589835385696659826276118037073155847389536858248635405364559736666996470215861051203401533286938570615869317235984753287652396322034432407580021699190694211544507386782141512127219400106336944390978803508359964961636613344848199475500529342378943621818677105999627891815514092275382046799147796192712265416120133188915632159671267268444573898878066052536706427859280752431090199998642804877251483691873398145583082260432741396887969939645842466935864443373010516948168945191841087780610562683844321783311770048243823525518122230919106208548985780529336458517856495269595735245608192558205778504253255833841848785931298866920090561469119695478675541574593759123456392356669416801695653079449850374476717537195933441222438956156214895450993684092434111347772444210749780705775496842540080257449471123509286321278755027549141310963120087927368478562357330210940690882164385265891908839842210448943396631407022595734830742722016218028802666660547953954316667638845682063669127711565800860951402764792779159999454749202454200752564545117363988136968692901889395145219596418640486601779288433276500959347528386066521412243587825101623780724591605447221991662756508863485542762385031963746979193650858277962793307741073438573247401096016367311004287934683569156375308951240781246694392231402023824652891126791030969610650810609058154890244040139958820027235706375797
	{ bern_num_data493, 182, 1 },	// B988: -3420860399329938496653196410549406579570647015435117179412557562972570862798549121055092455887154439349166065741165045150218234431948919693049014816094293865326606320461696155930833123351500172467991637210502484082458427374897381684489583805897308965612911089772968370786527035462349754448403682893252810481390159050291868197282464521752114968745036270233930722169684314225334864251865196270151787751549615465008471478764527595052581685811643477991954554907372048258479023095411071646672436983170208915301264365926168573621976731056273375869492000270882978102581518089352942902729672692631750430508181333552076718313069036763350167699742021786064640531141514442311547635167317776758094306215920271076207819674375845014715678786727006394572687453941864972545245149527089019510704578576479817910818562088271469498456701221022452901164870606868564512361220096178733642036302773888662712491429044239948930531523938508689986924584179534633751824368761870765172284824541333975527489149284863279002372135643984517677574154579004546348885458271969811894585396071348152307081796079565584343849441951184896778623130917109832462272929804265500497984517891112334746245045789478529282018828389139342663019201419404522564154643958069885175580634579005690893836683952643155753459671283356140050499391125262569332645788591643295351987596771763650497165401851030704914926104743568477109583686232461289590847245160077304884979013190922936184210322391637260531518280840628302711027582289087254529840136579062455619128149520440706003119400898873102167505045922247418435675691615719747166726211911485714205732599712977453680759651231504089542590820031655160686136612266499504877481062217581761278520965613975528975310602813179543637808642731104837701860556024404893053
	{ bern_num_data494, 184, 0 },	// B990: 1460577514662572988477110364223995291291861646507171729859378663792013705905210869521051235557895931430677508936979194611171250567014942082902441399900415482037302964770356505355163241373477961734523746635600307534693601800463796602306688193516478010062985579140306885029732599175454219723590573744795397924059942813591221009958607982979837401181836362690530087230391689293875389952121068040289378392619840922237486028838670572644309671955464689233470502624027558364581994252430857375456808242183617668357001996328636481786466782428805241837481912478440909939330117141869819738812227939773404024263946177901368759638998610511608666787820043637144728740638988620250922339412892401072608565542627234339625605251931120654081939750174884575214671214021634304434420567172098824776925098258365276527208215412545002079816407570632336403948142919381838900929149650981597861320267981516921817114265256627956836618797664031414925453729726258132672206569554131731976458566385255953851477695004567092923655486047632464142098131369698896490175618742598614726508044964131999144414064523297135287940311316153060404032579949336824912588738290255056569854813964370386787129478249781881037701041812400471129288895948239618343723305128849388088093008166932155348680579270839049894572673183423038848876880710442447787904665283647071821163167214650297244040656419792380160764549703439917101820774332551896422732270563191659288590505217731630021287044194294022410252481574509147014137627829018596492095048587622795837177255187798324487147657245622079112389966349252970685899437317912444233840468459116126697077390302370017699844595066402748370717141286316220317068023521745830891368884084859924246045649779849779814013479212132717190850796294916351898238160712713715012432670041499119265
	{ bern_num_data495, 183, 1 },	// B992: -677650468250858114115488966772615426608196252472570275397762447266737898985982294853866368547947037174689885892177015794738812123073312328836861637215410405588496614776974783760157615512514991918393597828675082543353399083989962246988499500701698806948776628595300306862167985748373974239189984801915311921079454206815580977270449212271876558166632811148239521820265871117654190383070877893031314907372590513916211299425951445441384527017013840675125856529551878174175014692291364743878675800994929796332636488369930070915591437129984014291365878951579522699313908563790085138611966660676513942041787881168762024464772394252008991092771519041045638761234010150457049712503383241441701934017390820515429785625325992445685108711075281404996203645858307202495483947456778772869243027328893931419423740176785737745356116725347985018019022250713970513482333084755333254757292931666092170560941351331039774063826480737809690676923722897013094993831550592174708173910562126152564738378736891550902017170994611398348554940378734885352315446527066588948436015707783920879078108510279477916664729627806400188417205552756699723348338975752217980856815451447440413898021683928757357571063447274030449152077407220131568115931674220376162265722667477118917443737385376737786081514522863746591513540360137602421366688666753035482638378288702997378896333194080210693504450536903381329049315259364302697289211085878401215793026838537196995733498172664677682075495147421734633095903984380461085447296447152393045170497810552241319081505286644634417587972599155503117391633711408757043233556114082066558632245830577521546455452407722094392630206380028564413012236778867133053116296903743089460246546195010056688689494394000248928239757610909601775695915172855973015920513217
	{ bern_num_data496, 183, 0 },	// B994: 199325431633975044014825929419086255867138042025322277701630519405467064640723093039004935266550562088049153757563441397066902128908108825073497954300403479258438918713287185035973886986095240173130001334286789273675563639726597719778991354035236347873502359480343559806242685188528056263738360736328089033078963257316339656372845278721819447597567104106469346849112839049738602775994348778696616082012058487680884121235786969040234790551173457062543796516145811950030338710841807299396811460461842752775629762449951736712581312257290030817175316362312267607366891737144266961700810595745695859126241163495260529764735897747118693033940061296456204000287803118071636354396070535967121493044362447317428726032002362734395460718674186626230372921729384944532787026371952006575443750780625529218529063824281157845550157004958126207161140116418625126816938361721052217759605532670868962951461623426594438144589286226876436993072352865060371750028695519679207128150163946864835170535033260214998266081898228971899032896615304138579535851220140929320967727767361505874075197180316041269928752638319272140538807938405181380614560199359621940760589478907529094976082907862170495415932378317408609169713777917782069056313342120954795395162856498842824774198504382809381117499374096347689942388916217088902965076149876026803653155403993563771644265977078819001904153604227365858867524570059005867319069671364358037677753161332728956432483527652233616837637064523180302816391508528933577120833736646159301516145988892626329817511993584299495664672375191196902483780953302590133413409231083250776408924658838986207012313039265270984017068478409617000453369907382632638967854675306373772674741402077603116568697364820999643906202837169327491427174063024102238196751395647
	{ bern_num_data497, 184, 1 },	// B996: -189151141879377800681581654270073708163356918057416192467859186708643281846078020785886849123366945652296908218273361616683776088630546934417128128751146835601788425702579257980374236407994731011267531115132956910515583089614811898377949329495793825831832036515705425810266689624655266978332518869028246771229477641281870789937181301427015849175229695435957458742192642441252273639715414892633019137378542709189794334126071828264779935524882324621555549413260478404342389547485551681496650964893092655654138028993530372658042876281354295093424518568579926063455040655790015525905956450370638466867747785740069738421562064882127439779800094467242622285676795904149779581132706613450972179948632543044769368021350060428796869923003641741134990342827229156334633494285912459769862968522954865258843255412507214552046845561986515435240839041143772085566010322768491794045460647404699089845540261533323083008160637620322707733916047478848393875752410291398401810276954493963050769976990510026214045273460258754440970402317724141497695204435785976729709415683810531622044961428402492078539930257493166986620457708550347643916784260382969622198069441615626226361964807096572292002587144337787673313816540323061497378200113203878737881219011290442714767134326746376595957722616619261684009137099148715232137308935122230113785170660010263642436061820316516320130609638735527990060766922655632494412243683663474422220503114489512658973338297323261213397580451650969153328640754105660659225418279561975549749577525837699149238126947220076658045219069613996065504427487798612976725521028167391642658919718713144888941770748670224403274832599176727259114878991416128382592561521696096943584238672483999494616239914424348309031397727624992204215470911370191921645136969417099414438910891
	{ bern_num_data498, 184, 0 },	// B998: 126110532226875863722186314413078643743677295049627612138078103746867313823650974407788470039178497753501219072295466558204298679021991671711901057083571660349677840304397840997074483381514474480661602660490046690668088731170670380133091686845468077021063400829579140293359786653218682193528189318801646741026740793259424016952009293462026946799198316332899071491347494944041085782241308017736239549963732065050373644221544978616159768087418085198497694890715766041501695143179263948104745259670173455411482148884186062230481614423354499052055218785989601099947233628100889320409496216207128872794276697919914667387527356824658813943639604235167422131658773516729251414078594519207005439012507379392784428581233302719565325567235223276538155192287161014650235044439664428014262805462451269236647717815412575497770647804459985509784528784530310324757300767119695920887860367486333787522887053011574656270645594819053282414641055526457658358379431133544756011094709319131077411065220648075418542264567637748424759225090564715057186717617824429985472133601813093844675587587441671994069908400179805840933850793196660540787863632613345299516754957464415702089790674117193952188311456857639257787045630780126044288081811914449235275542952718508143533725003855683936245128450379708683853862295355267565912631620683659519995078691010061144408127527175631469088337225466384837819686974013046719878758370629021093215774979336498964835050489835164833414143570388669233570954286958335297333080381980591126278578115726870897319958151389818107659471574252392835478588093793684423143438701186458587437943171837031275741043029225393671639978213559731661409269915745354551204097446997574825101698420609135221520337025019188600540186171138749270324831903396490535562503969561822588439
	{ bern_num_data499, 185, 1 },	// B1000: -182431047386618872545726402568577888793383368670429060521971581576411262572624911158657472577321069709615489924627495522908087488299539455188791856758224155166849269724418491401224257983095561709862992465225174097919156372263614283427805489710022810454653084411613723506969202201162441791760680262602019620260255790058416539271332852806000966628467639068343422638070295122610811666617281581715702361188930366816683991915637976838778456901148431227534274268805917998837802553382786645786602185045895962670442011443630321460259486764674312436994856054301765557425137115021340105105840867987476635295274917873497367685983470762388163462514714899425128781905743235312990704069303094773892517387054176806531183648189451892725726445949589759600705334767585389769924857630972963997636483244264351262207385878011073153983309981755577513600811117079762505973229513088849006701133391676419537939945123776103061984293109331214632141683542607746641232089854815064629129596536997380608256428801978490989730165826880920355503069284615191706946560725764114918719765109055159668403124118455436505930214028492216913418528197912335893019941012291773441794027493574651881059432274494354092231954894280742068472714619294213343605461147540486788631325011439968153275323642929062590934110003913683363121389156217015359548140842087942416654922942707733476055878415765927582014214726584822236443691314366097570085473354584000998591519058404733793433129733940339271957909399584231274683687116967497864609134118725271669900471262221093459338473589242309517183798837432563465487604170316077418754242710065269818190591271690695446633836120374525551526708821838399633016420340373236533335212033827202131971800359942204589948764600183502703856341178077687451616229338340631455056219106004731529642292049578901
	{ bern_num_data500, 185, 0 },	// B1002: 567540962495526889231966824817013756464073334197074758518291152935749349790778611098768359885641185079731353775235180662855905658685332960596461694242812306618981661418768678921755102744902798787461891937770289226822070917694146489328938285295417652955453989339151859660622703672108766011367202214723299947922342066700414049260859405101748873215742181822582162588263734783986073797381601042853437109453923295892207179115570168692534234962406573138248766748102948852884112092942688693388749932732785937694262506336837918284330287972344946821227777084011566579581034484349761350632499594902102804035020037927596340345715230008256751980318436968410038812174082225423201969083863477177651924265548381892992176856908072679478812250466387778984513267278241441091952136554836733730058527839724411357662883298172371855487347805611804902243009150735158146726091466195866463369731262715658945029361346271900107512377678519533336771198723959565727942140145052221737048924062881623687366165730554305595437601859342027531154376655496095228616611195035975007243604776496573120886662738803575979778220337269190485465915328572370070354534520746380245759849896354181897330131907273824285731090271853551599615625753333651808261614958137247140865044308419855497525650175607940356310985942143374075272102483205270256067669686126795792217256412065450635247526004345596034661864969869902540197153815959710873256935656305332028574928215165986320263292816466976122484459490271021659921827237998770329422371399252928950379520503143084780471381269951468182067944866044633365383204349679343427288357508944321162916552137627549177649096958801162717628561988891617998075743464397235378583701300588126796913957523947285512008702584157413871485073347372961178279323809398177879931697770815599346884986969097
	{ bern_num_data501, 186, 1 },	// B1004: -5201302002209436015191029818686407401105865825823274005472625371122032902426356025576199199446540086856362401076911409591417524603432324760702550811540835838028297593501518272922266639305403539232733467756807614810148767428853686235841832898371027763033981346485303849067140020885335991346380685877894925773843991617113448766795379881187509327591147475831708903283681786246117721795540021965032414191362513292922090508167406692306945326402621571195743497844569556509263488396150644306172511577626680821781992055149489225672640307624177489989619921568334011483135909270428674747006596604046303479947437731426183159499539307043953797213579719280801383541037721957875050509898405073251154245363769966000535045132987297574903193288602377533724103963178481829116416645789031585109319506454443643077816059209011052126455865459604379173312326621807827080429998814958524947070705264877306105073701230274082012586813319459913144394568939820869547562943586933269325348255429872090414874659961901288411356386653686873279868044060120883960995578225999837534408853175291058788706442437296799372151981710890932140258568547500903382824361483607653384395318612722335359695866426948321997375151981750851083307471913340844484456926424148920988137047504085669622078773743795006104561777877631456743879903250052482305397540024143022973521155779945280886803421369229773702119931261874693669715539376755276815326316340118008218926460795388641468394989497903081900134602535237218909169994774371017266204797374906582112125504403949242758256368467614067592295329101631818281727838108198101485649447958249157070550117810793900037994966075586757191163738253306694283102867977221646010570112862415927255364096907157231652503504175827890350368416396152002664252005224510238891814781674818848704915151093423259503
	{ bern_num_data502, 186, 0 },	// B1006: 52963708572184701456539725040549117992200255212935579099561880243640134141797164309321670462693821698068100746254003688302206673489038431437945522807773038906867942150081462063310848355635810591405172765225362882537759835949512219462443189868953848683788733780452292966094149231696053069071142492048358169609219320677859376923404861980141756092271427862419767410285249377542898954923105912331957294499592811913834598089298487843762877661909646312627237350080276117557758917084334670051859625959087344565217457471978131049906980511230425935824473692714715059967139856370773637185879417045775539837385224254698167693728735125148887011707594362067298237564905117112925202581940414979706170378383602178586600686477916625452787950143422990456504845486298789841846640968936547212421931608917510848208503610291980700178853004394693739316610033964287729924325441170933063562508049785572809669286634177319163686027123719393573776859023654380040903979510218887707557510180284330867762031358069947442504333480133452711388616037982897294297272367368323651749983235522985420918604067409602366679498785350414075519506576938237347644400290097910868815975251792214373920415964060516947125133062111437451605760454344472362182467269151652440885267661856269520712958611790170635253261005630074220201544509752254585150958117949910474775262940683074666530826934415650385855590118407568031384520238773552570980351896752126536578704439461082322419762253856283619339273023807810867536617047794200169316124449109197674339615126124549050391565259704887808923479167135291413432541476119023543770046685498862112328382235967848635990623299721901529308107565383714025759562005375973970359564171461418733423136053292340598470809839260204160436717704185017851016035571407798882824683879059634130360697659430288355143
	{ bern_num_data503, 188, 1 },	// B1008: -3289401161082639693923691652417587318579473465299734233151687503333307387003650841646441480367027592056263590933028797628154320974832664745297931659872391256658610911162850118917319719047091837807099385217285609473303187089638160576535130550170064498984542165210717475452062687648872562266708755470263206465672792343879490321948622134423946497300196451985120169102589567955122678270567203266238931578180307540070287518728048895724861307464960472611638787003910904284594612676186745158639875800483804741619814384509959498344162596570261905248874327181832480898413721671021446375545648578852121260930825939018556938338298843073087842961784177859558383002273878622403376277007079308671196146064365876558772263619389964154237134147423461583487488380563551767890875035310026813259464880044006428814949826224082137004766573013065224639942438010092946278060486373012326887511497008885414382553133526451459118218759608553290520116961514707861295973858707453110555411587092620149900381243000056503839483524314897017686990773169608329429721687884276391629998191220954429312094427031399360014173850763221961473551105600666178322124496571588769233459012487541186022585917880820046485309824944807926865698460259230515720926925334892864434775404760834393049072487305960798572603211024977623396420867667118215501756826855479621339056226003324497292557038034602153363431120836808854929738566087676909605765287713946031371239393956797094800085448896362507898903537526151838847086303073728592120340449978472621943117084129629934415450385340664648007361197421382797359547285384643248462370064641525392074117944073416609193424519220277954493111735213428704754726136472099837496657848649575110577791217707615298182456740644256874081563713054648826651867780909466477880025754220692555236666531277652437048917047228643246931969474493
	{ bern_num_data504, 187, 0 },	// B1010: 386682165121672764525876009309682433905846138252556702307162065265754559818988217175569052916558003210725321081091362276098819373865558765392441891259364604111038920012725311852342247810109029126405767132911913829049752801329419932586343860009311250253694795675579141337991890006583244951027771966929219211189156715041338757230852152623881949584221867777698335147472379377185847065545387359412311541983360936328098500947413647044829727524937447737100047492408018228379436019282510892376795818775843022826515229945400273556020617209790231245896451811365881374976416407412686584056148963677235637104711219508018750444018977117297674567501580578237476797750348536818566528971836063886768358629657986321752229901960127527424697553057876163246448428324756150191330611658742316245901823503628385619249598189894052346252453511105495966837217290037814727529998321331643139807713232793351057722389668802279606860019906381039450762024098467953110585849703158232477758719300141491886725092315545077688559030442196171693862497319439035653289869422845261706450675183034514146230137128570111675346650582007018908886926313618235372951017088749444563670360381601625565450121578966756787723379634110896363428314665309241197197092399237902283641039623946042463093559162201972981880300893050445690938652953747631475372462429026442264656454837914794684347008064117367564244548174487079436474363441203699006122480122103884905429029295360398603514857334119201914176026161451576802305031232853399221192844057083494731939868174897864091089705369754041362428436379181653307964088834730746214288995912264214575048885992064109138447820902888711530675586312349532352541869469889308513840875956126957377045250979693858576126407670479840187107838520896413838907257341863668485273602788261318431087240771626168714299731138005
	{ bern_num_data505, 188, 1 },	// B1012: -4988138821297372476818841697876663200713015059129592444485731778681110824374131980961901397406753522399477798007400785885552259454510159761974785131441923995013705847164332702997521946552788124152851350702777918800931007542144702589275575525268425111068834821457863463405736304380161890215527252881781291763064311403389151156782105204697421532138138007339171426046142762955198895355919433242330256733979006207852568406869681003968555005097797693767185065370690018601637571928102428564750131096718650766018595118985990521604144619701000715640835603637446737315877780768870811509096593290837730337091304675313261771820631845943582854526391397335657237404849404390436406199492531181494345066859465569353275001060051310505699385088260827291858488227192146452775485233208416429427776063165739904119426021523103111595128715492842823175743035104820373239598076873522758588042178979242906457199843596182745912996016038003276192525082068270156891846852390803872170586849244849246910722571174038444932685328766526593826016540477068287666691402646130617918191504163517151047131203606748978236320706792327942906339317930776111895953674954351323881829352205189403424897496697085994969205431256037152985087131894837246193852091067776111158197401897051216538051011145923023582231936082105052248663014598370828003845091121592616198035276860490011572576611841927703842255371685284281192799490268179360183021934851127346526355510353964170899419508682246310873241742948632230275904322188473223019013688232033737963309013511736552034117291316873806287920710473291585029003022347211820590663478308833906285022016815778410412272401666849862579526556380946692313201941111535002328686526188566052685205729893089747424211636361809965610574308906338951511898899876978726952485703550332733686123677965247345877916862244912113694853
	{ bern_num_data506, 188, 0 },	// B1014: 13108294283532129272820118796537015378129384972764728164263224334710779099411752201196087163241888324762297040000644533977673943590030321817482112721063240447873340354919648753631633600671491070372455122145309434336106090079122654401472994200209979079518722437279820421270231276326769356696852672056023309633931883770287030004766409686530451201815267851752392727075602859706533868408300433711635820740935115065440143361930784776415623987717784152261298228971391923400509583071083978777290352649097752045582265020219244012119924688927042570699900336571916258176373168754475764738726170845839299234976836603955754916219715816674587625870011546235919052621024471751033673991816232582287114135523541687181517958759941894651778495752956950136924792783527948368593645283569893826465854964868422044089518443891362994252955397310809713546246942359484302403489328639164495298968968982761048313659223609762414147134133068826979079819853572717933230818888081336198952992211993747388656957495297972058068921408510075832308731023429382253484090280604133064697787191817197724607003732333153269794295747992665277122315523355035075170207941339689909437432331713959740853112897414745076626292592820011914541669173463022009598233845538541954620928943423334916600940813929130582100081953023544799345454108205408894417648184183751031534560472772888783933228164233724946636828270135536174063890685481309275216710293953029915293548043829744480769491033261739293083739789202715376403697377598342995881173929954002154245664367671375218455129727535908179713216087124471986721322617969823809125484601018913424695725317481220872875679557543673143471068249581238098842675021375056864702253155230110380360613765412738194484027794261937096893188563915912992190496787536119760268807236347382771094875497155407377314787734768451498457871
	{ bern_num_data507, 188, 1 },	// B1016: -1575828140462461430126143083400937341631323448016515648821402393978301622100485032392230321532075924237427286638499238827642705083834302259331152359145261636998533953621378982279658981843976800607487139111976519270338007777405326766241407434806261006364214636718502229416275091970145559116166526190821334266361393784468396243367163514952773445190240183258808413697856609966803473640043897898434083755556404378087645175737134415997018825141021858269804537365691883015156086743342146762969333788738559181354060839864878238870927072024099040643368902556676617396830824817491450142716034018233227461791071126469053728953828048757131276420602584581077062354200806515842230811320922583921793831085241514906305742875035351436058208619797428160842900150162072700661327635656060919839975017835424737093227241627341390264390021503699492830265618850779183423938263275519464285606671687498184308601913421127222635751300037129752984774602224694397462944664238316174209720671161808199572909359208883276133136682239299668191910105679554992662013527588690988406350167188876070046121132926172973322404578334227382680849061172447247298468781159389590518258618527387817971453643722113936041428024496048050847622517626627943995966726352049461852577272318574411604787082089396816307002835916683110089959023820742832072346606943636165641083123206039843158663458867439268034600358302913376132031427239489214384119495758746459893106863152765404512836210141676132131798295698135083540438891435529334799414054202248749027529163260882647056043298630448703093303662706567123637323270107330072044029370439746759208995100023085889356472565374343742371150133858262358915412759226145222702626986715368348205288725875879187339917351711422416521180347309119958078446532609256477923626848777031702822888889880080568521117974052376862995045887709
	{ bern_num_data508, 189, 0 },	// B1018: 16546427593675684524414174464904225252642217954882626489552520230932595515726256724854263440326272733322786005068986737938760351659002286218124357548661347124836785339822805254472114726585177703283260146001299751372133959431174517528664870584189296586904779436223173236078256225523808211470789794844789492662859054705542843020761026597879377125390294813100198147626362962023845477146377338140481066989551750816948625317298411014168231599778489902549230768583330509205157375203216371344300780509566875184306525869721198106085313902431711533879596633136757910025194158431862500402678714114138874572014204795700052457398421996208788123463402265722542702729785617569188457298126246774584905508760762608395333638798311903819941079379151207721556225042397508796217354501822323800603688043866606672591349265961900926907854572774501989006277569658386960638459061839239402907656837950652639964890440540983279255903452299856590025240337035761092579704375109925242726382441738065063200324024009221844485046068487469599282172771368559339529413405221066965972522590676074896338977241990101727015180675158833651352201488369184170214056858394031638605392075675424223282800123210027104525086941984420033187464612000923878555619370305685300920999444683405506313942449296521495811826295497752889311915593672107394863153475613224499728518554073681880707229032830724101016335476010480970987052061761943073048777142825291365258102556641128326499274732283738958728065965951622387086741446685369633727415417624971231307304966800885165615085086587336191732203344632672357383147856824621880598685958886876710286310032089023503100559387731924176781468065875487152621778555774384585543059414287036813161377088478770831058465752229194388310214980358340342844003846225013987292456642107938310408420750006763004481592952672017070832288107572981
	{ bern_num_data509, 190, 1 },	// B1020: -425503616542258221625182447196825506420675128383045198921582672588840635234776171356442697786742584274822371559877600279435282370370391921871026294975989313139558507967920801080538402527644390959373734824511207128515195443228872055922505761737778851583253730605378167577745226593943694923253932807788853809593654893270252935979148858490950535571781411394181074476905321332685205218804730597030132558575552701330411778892424747570624357078904587388383817476023055130409856157725146127254713077403312050904397793810102505399849065791491734073751645405674918740557978599969924734031643706661608930283800135601915403194866803686735241041676835102490059631109397740616664054654413953208798784474344426298329118637427083972934332445653521709587573549240136078281598781984824461675043962081095687036837521871533384064519056202021308643972876799492736398435623396787630636584109573862967568136473256676888796341355012629573832902500974004818487028346244904328333744036318424058197884937000376661260617612803769806829453534797631227659537274801940212052324181106974212559828633809361291398277838639426223363248856836351447725338487987499314614749898525595195213313589748989836735380176021152636638623121442453731203265530250553212334077415655191421728036432561769814240500073802443862998016478359176522007622101030250080106204210912699920455125795407424840735746869043971294197980404603627942373703239579042028227422101360225354253917120273803706647015955974973820316418707308770396656727240099481264853408188555576882325443406458003540941321053390053846097211856064496964954779345020188239292638181923658514552379943878564070148241093026730304999886898779081057315395781047500668052846760716958727349553573876254857764517152351551604961068511017294817227560181802432070158792335521210814973054459912888318986851393110796804100974390033
	{ bern_num_data510, 189, 0 },	// B1022: 11299561218700608453416597551229210510832484765256034068450688855812143726206253457748104582234063456541764089542532650030021745706640814910655184767024010552260901050929929944226715758110551111110119049787650626364479577567907655563343277332587466854154433100482211838821317444746119926423665537927579930766043509019925595280937048516456744579859905960309907795878692208215723536483200277078402385032185715313583102201925605715877280197639798214437449377288568680368393780957220641524033890404339537933842924603037056013634042097401704740344343963815807352237505432436376281227845284826816672707938929669259418023511382335776356409467030599296939291630776768668624010741890264251526373530450556557944077654494267892203240615245609880012987431119545305404672604087920189493401892632829193356064186333816867294795171447202952096753913615715407111096733547176824573147182711846513180911425110975350147446001537639122196916750480350316451683901285591288683826859297799832295851334289135440974718421243394604963460689749695829117027620390780409855779985230775144814090760640375814337408472906308047189805258005053351968518228327158839318335709686202002487743053548681953504801175946329268615397451728172792570053759828469194968383985346353468668550312886628614444664597269077192340473869267254189480223240018954214178249412535783517140540916546292272568610303309357469024824592430395389723685069337038211501526246789145566421294526141799478773526902866854175780583661353354383719365863982573660635089652741451986578772836621609685650188037868191468414537800823768845378940456026946844865544241252651349694105888997938798223900641994464011377552371939189548636666241580022939344196922474600293579627509991347798026481099537368203581404331446383969272682301445945726742540992646627617078500090249678438579304498266765125918631
	{ bern_num_data511, 190, 1 },	// B1024: -6549821765693430323027503583817441401786793424589085278434159197071455082803099063143235757697352951234387432737608863469855389882972638734538474311143179088843497775114451670287870996711606449479204957968972300227924552884445956535319179610285221737657752352980268488105108048930089166604556526347388967995522049182625008413960754244279951511743141245426532914834818330317943304108714195226920481879045188656188468886769369330442440303253194452771570912476506153407799607448166853668266958162934901039192734206989423161930248803071867252232289340528921547786977948802725345172014698778095642536962918685446747843938172068442769933706091333534090056176649167453506863267278381870562880223194286546549426578052901588348437683771779206086859816800581042172467878832846388484381091057689456837198894248851439900126758868595643458742542744002252961917464839577526502255723344077167659325101007812336317861363211742458637517110563898661267757966357293123827005292753090647723456351794726749015194608387172989902498293258102667819207583704816806412749469195364679372110616304904746179010393492989858843037447869094329252800514090474770126925161819636877831617804722528466756709866691966008497699126778074905700291481821653299153176186221620740532551528642769927718460382297215389587684529527833156459664618464330116911910245815921897868650161853650083500051901522686054941196726480808903109479086431067732822114368418050502707475416922512306362889840805742986710622074376842802081576641621118274307113687521931788231285556464619488858975710942695462355404934564620593707285464458642439166301747045864844482490285914493498099484399917603607584720355003593946719833445920521366856850310772737637085943195582748468444728937215422403498985035191995453977435488974911674589793149221949610390697809338712068559555580964411391315939423930369
};

// Bernoulli numbers - denominators, data
const u32 bern_den_data0[1] = { 0x00000006 };
const u32 bern_den_data1[1] = { 0x0000001e };
const u32 bern_den_data2[1] = { 0x0000002a };
const u32 bern_den_data3[1] = { 0x0000001e };
const u32 bern_den_data4[1] = { 0x00000042 };
const u32 bern_den_data5[1] = { 0x00000aaa };
const u32 bern_den_data6[1] = { 0x00000006 };
const u32 bern_den_data7[1] = { 0x000001fe };
const u32 bern_den_data8[1] = { 0x0000031e };
const u32 bern_den_data9[1] = { 0x0000014a };
const u32 bern_den_data10[1] = { 0x0000008a };
const u32 bern_den_data11[1] = { 0x00000aaa };
const u32 bern_den_data12[1] = { 0x00000006 };
const u32 bern_den_data13[1] = { 0x00000366 };
const u32 bern_den_data14[1] = { 0x000037f2 };
const u32 bern_den_data15[1] = { 0x000001fe };
const u32 bern_den_data16[1] = { 0x00000006 };
const u32 bern_den_data17[1] = { 0x001d48d6 };
const u32 bern_den_data18[1] = { 0x00000006 };
const u32 bern_den_data19[1] = { 0x000034da };
const u32 bern_den_data20[1] = { 0x0000070e };
const u32 bern_den_data21[1] = { 0x000002b2 };
const u32 bern_den_data22[1] = { 0x0000011a };
const u32 bern_den_data23[1] = { 0x0000b54a };
const u32 bern_den_data24[1] = { 0x00000042 };
const u32 bern_den_data25[1] = { 0x00000636 };
const u32 bern_den_data26[1] = { 0x0000031e };
const u32 bern_den_data27[1] = { 0x00000366 };
const u32 bern_den_data28[1] = { 0x00000162 };
const u32 bern_den_data29[1] = { 0x03627f2a };
const u32 bern_den_data30[1] = { 0x00000006 };
const u32 bern_den_data31[1] = { 0x000001fe };
const u32 bern_den_data32[1] = { 0x0000fcd2 };
const u32 bern_den_data33[1] = { 0x0000001e };
const u32 bern_den_data34[1] = { 0x0000124e };
const u32 bern_den_data35[1] = { 0x0859c506 };
const u32 bern_den_data36[1] = { 0x00000006 };
const u32 bern_den_data37[1] = { 0x0000001e };
const u32 bern_den_data38[1] = { 0x00000cf6 };
const u32 bern_den_data39[1] = { 0x0003827a };
const u32 bern_den_data40[1] = { 0x000001f2 };
const u32 bern_den_data41[1] = { 0x0033f216 };
const u32 bern_den_data42[1] = { 0x00000006 };
const u32 bern_den_data43[1] = { 0x0000efe2 };
const u32 bern_den_data44[1] = { 0x000426f6 };
const u32 bern_den_data45[1] = { 0x00000582 };
const u32 bern_den_data46[1] = { 0x00000006 };
const u32 bern_den_data47[1] = { 0x0044b10a };
const u32 bern_den_data48[1] = { 0x00000006 };
const u32 bern_den_data49[1] = { 0x00008232 };
const u32 bern_den_data50[1] = { 0x000010e6 };
const u32 bern_den_data51[1] = { 0x00000636 };
const u32 bern_den_data52[1] = { 0x00000282 };
const u32 bern_den_data53[1] = { 0x0c78031e };
const u32 bern_den_data54[1] = { 0x000005ee };
const u32 bern_den_data55[1] = { 0x00198066 };
const u32 bern_den_data56[1] = { 0x0000002a };
const u32 bern_den_data57[1] = { 0x000006ea };
const u32 bern_den_data58[1] = { 0x00000006 };
const u32 bern_den_data59[1] = { 0x8ac65dba };
const u32 bern_den_data60[1] = { 0x00000006 };
const u32 bern_den_data61[1] = { 0x0000001e };
const u32 bern_den_data62[1] = { 0x00427ef6 };
const u32 bern_den_data63[1] = { 0x000001fe };
const u32 bern_den_data64[1] = { 0x000021c6 };
const u32 bern_den_data65[1] = { 0x00403152 };
const u32 bern_den_data66[1] = { 0x00000006 };
const u32 bern_den_data67[1] = { 0x0000100e };
const u32 bern_den_data68[1] = { 0x00042fd2 };
const u32 bern_den_data69[1] = { 0x000a5e2e };
const u32 bern_den_data70[1] = { 0x00000006 };
const u32 bern_den_data71[1] = { 0x8df61566 };
const u32 bern_den_data72[1] = { 0x00000006 };
const u32 bern_den_data73[1] = { 0x00001176 };
const u32 bern_den_data74[1] = { 0x0020ffbe };
const u32 bern_den_data75[1] = { 0x0000001e };
const u32 bern_den_data76[1] = { 0x0000008a };
const u32 bern_den_data77[1] = { 0x6af74576 };
const u32 bern_den_data78[1] = { 0x00000006 };
const u32 bern_den_data79[1] = { 0x0003827a };
const u32 bern_den_data80[1] = { 0x0001fc1a };
const u32 bern_den_data81[1] = { 0x000009ba };
const u32 bern_den_data82[1] = { 0x000003ea };
const u32 bern_den_data83[1] = { 0x0033f216 };
const u32 bern_den_data84[1] = { 0x00000042 };
const u32 bern_den_data85[1] = { 0x00001446 };
const u32 bern_den_data86[1] = { 0x000009ae };
const u32 bern_den_data87[1] = { 0x000fee02 };
const u32 bern_den_data88[1] = { 0x00000432 };
const u32 bern_den_data89[2] = { 0x5e1c00ce, 0x00000692 };
const u32 bern_den_data90[1] = { 0x00000006 };
const u32 bern_den_data91[1] = { 0x00000582 };
const u32 bern_den_data92[1] = { 0x0000002a };
const u32 bern_den_data93[1] = { 0x0000001e };
const u32 bern_den_data94[1] = { 0x0000313e };
const u32 bern_den_data95[1] = { 0x33c9788a };
const u32 bern_den_data96[1] = { 0x00000006 };
const u32 bern_den_data97[1] = { 0x00029d7e };
const u32 bern_den_data98[1] = { 0x0e96099a };
const u32 bern_den_data99[1] = { 0x0014da02 };
const u32 bern_den_data100[1] = { 0x00000006 };
const u32 bern_den_data101[1] = { 0x00044a66 };
const u32 bern_den_data102[1] = { 0x00000006 };
const u32 bern_den_data103[1] = { 0x00006996 };
const u32 bern_den_data104[2] = { 0x25e96b3e, 0x00000002 };
const u32 bern_den_data105[1] = { 0x00000c8a };
const u32 bern_den_data106[1] = { 0x00000006 };
const u32 bern_den_data107[2] = { 0x8e38e38e, 0x00000003 };
const u32 bern_den_data108[1] = { 0x00000006 };
const u32 bern_den_data109[1] = { 0x00001da6 };
const u32 bern_den_data110[1] = { 0x00002496 };
const u32 bern_den_data111[1] = { 0x00198066 };
const u32 bern_den_data112[1] = { 0x00000552 };
const u32 bern_den_data113[1] = { 0x00098a12 };
const u32 bern_den_data114[1] = { 0x00000c1e };
const u32 bern_den_data115[1] = { 0x00064afa };
const u32 bern_den_data116[1] = { 0x0000f642 };
const u32 bern_den_data117[1] = { 0x0000001e };
const u32 bern_den_data118[1] = { 0x0000059a };
const u32 bern_den_data119[2] = { 0xf0a1fdba, 0x000008ac };
const u32 bern_den_data120[1] = { 0x0000008a };
const u32 bern_den_data121[1] = { 0x0000001e };
const u32 bern_den_data122[1] = { 0x00000d9e };
const u32 bern_den_data123[1] = { 0x0000001e };
const u32 bern_den_data124[1] = { 0x000040b6 };
const u32 bern_den_data125[2] = { 0xc43f6a96, 0x00000046 };
const u32 bern_den_data126[1] = { 0x00000006 };
const u32 bern_den_data127[1] = { 0x0001fffe };
const u32 bern_den_data128[1] = { 0x0000002a };
const u32 bern_den_data129[1] = { 0x0022f5f6 };
const u32 bern_den_data130[1] = { 0x0000062a };
const u32 bern_den_data131[1] = { 0x16512582 };
const u32 bern_den_data132[1] = { 0x00000006 };
const u32 bern_den_data133[1] = { 0x00001f86 };
const u32 bern_den_data134[1] = { 0x04653e6a };
const u32 bern_den_data135[1] = { 0x000110ee };
const u32 bern_den_data136[1] = { 0x00000006 };
const u32 bern_den_data137[2] = { 0x26774cba, 0x00000001 };
const u32 bern_den_data138[1] = { 0x00000006 };
const u32 bern_den_data139[2] = { 0xd298742e, 0x00000001 };
const u32 bern_den_data140[1] = { 0x00002e6e };
const u32 bern_den_data141[1] = { 0x0000001e };
const u32 bern_den_data142[1] = { 0x0000008a };
const u32 bern_den_data143[2] = { 0xca3e1ba6, 0x00000035 };
const u32 bern_den_data144[1] = { 0x00000f36 };
const u32 bern_den_data145[1] = { 0x00002256 };
const u32 bern_den_data146[1] = { 0x0000070e };
const u32 bern_den_data147[1] = { 0x00001176 };
const u32 bern_den_data148[1] = { 0x00000006 };
const u32 bern_den_data149[2] = { 0xa4ddb31e, 0x000000c9 };
const u32 bern_den_data150[1] = { 0x00000006 };
const u32 bern_den_data151[1] = { 0x000001fe };
const u32 bern_den_data152[1] = { 0x01810896 };
const u32 bern_den_data153[1] = { 0x00004e2a };
const u32 bern_den_data154[1] = { 0x0000502e };
const u32 bern_den_data155[2] = { 0xc853ed46, 0x00000082 };
const u32 bern_den_data156[1] = { 0x00000006 };
const u32 bern_den_data157[1] = { 0x00002526 };
const u32 bern_den_data158[1] = { 0x0000118e };
const u32 bern_den_data159[1] = { 0x0003827a };
const u32 bern_den_data160[1] = { 0x0000011a };
const u32 bern_den_data161[2] = { 0xf069fc1a, 0x00000007 };
const u32 bern_den_data162[1] = { 0x00000006 };
const u32 bern_den_data163[1] = { 0x000009ba };
const u32 bern_den_data164[2] = { 0xb36d117e, 0x00000001 };
const u32 bern_den_data165[1] = { 0x00001392 };
const u32 bern_den_data166[1] = { 0x00000006 };
const u32 bern_den_data167[2] = { 0x2101e3f6, 0x00000201 };
const u32 bern_den_data168[1] = { 0x00000006 };
const u32 bern_den_data169[1] = { 0x0000014a };
const u32 bern_den_data170[1] = { 0x0000031e };
const u32 bern_den_data171[1] = { 0x00001446 };
const u32 bern_den_data172[1] = { 0x00000822 };
const u32 bern_den_data173[1] = { 0x0359bfb6 };
const u32 bern_den_data174[1] = { 0x0000124e };
const u32 bern_den_data175[1] = { 0x15f730c2 };
const u32 bern_den_data176[1] = { 0x0000002a };
const u32 bern_den_data177[1] = { 0x000014fa };
const u32 bern_den_data178[1] = { 0x0000086a };
const u32 bern_den_data179[2] = { 0x4565686e, 0x004cd53e };
const u32 bern_den_data180[1] = { 0x00000006 };
const u32 bern_den_data181[1] = { 0x0000b41e };
const u32 bern_den_data182[1] = { 0x00003c36 };
const u32 bern_den_data183[1] = { 0x00005da2 };
const u32 bern_den_data184[1] = { 0x00000042 };
const u32 bern_den_data185[1] = { 0x000f89b2 };
const u32 bern_den_data186[1] = { 0x0000008a };
const u32 bern_den_data187[1] = { 0x0000001e };
const u32 bern_den_data188[1] = { 0x6271f632 };
const u32 bern_den_data189[1] = { 0x0000f636 };
const u32 bern_den_data190[1] = { 0x000008fa };
const u32 bern_den_data191[1] = { 0x33c9788a };
const u32 bern_den_data192[1] = { 0x00000006 };
const u32 bern_den_data193[1] = { 0x00002d96 };
const u32 bern_den_data194[1] = { 0x08d5a20a };
const u32 bern_den_data195[1] = { 0x00029d7e };
const u32 bern_den_data196[1] = { 0x00000006 };
const u32 bern_den_data197[2] = { 0xae3843da, 0x0000d480 };
const u32 bern_den_data198[1] = { 0x00000006 };
const u32 bern_den_data199[2] = { 0x2b414f42, 0x00000002 };
const u32 bern_den_data200[1] = { 0x0000002a };
const u32 bern_den_data201[1] = { 0x0000001e };
const u32 bern_den_data202[1] = { 0x00000162 };
const u32 bern_den_data203[2] = { 0xab203fa6, 0x00000003 };
const u32 bern_den_data204[1] = { 0x00001566 };
const u32 bern_den_data205[1] = { 0x0000001e };
const u32 bern_den_data206[1] = { 0x004f8c96 };
const u32 bern_den_data207[1] = { 0x00006996 };
const u32 bern_den_data208[1] = { 0x0000e1de };
const u32 bern_den_data209[2] = { 0x7b7f5966, 0x0632b4b2 };
const u32 bern_den_data210[1] = { 0x00000006 };
const u32 bern_den_data211[1] = { 0x00000c8a };
const u32 bern_den_data212[1] = { 0x0000002a };
const u32 bern_den_data213[1] = { 0x0000001e };
const u32 bern_den_data214[1] = { 0x00006f1e };
const u32 bern_den_data215[2] = { 0x71c7160e, 0x0000663c };
const u32 bern_den_data216[1] = { 0x00000006 };
const u32 bern_den_data217[1] = { 0x0000001e };
const u32 bern_den_data218[1] = { 0x00004806 };
const u32 bern_den_data219[1] = { 0x01a69b26 };
const u32 bern_den_data220[1] = { 0x00000a62 };
const u32 bern_den_data221[1] = { 0x05681ece };
const u32 bern_den_data222[1] = { 0x00000006 };
const u32 bern_den_data223[1] = { 0x2cba32e6 };
const u32 bern_den_data224[1] = { 0x0272fb1a };
const u32 bern_den_data225[1] = { 0x00001a9a };
const u32 bern_den_data226[1] = { 0x00000006 };
const u32 bern_den_data227[1] = { 0x11077a22 };
const u32 bern_den_data228[1] = { 0x00000006 };
const u32 bern_den_data229[1] = { 0x006d1a1e };
const u32 bern_den_data230[1] = { 0x4ccdb79a };
const u32 bern_den_data231[1] = { 0x006afa9a };
const u32 bern_den_data232[1] = { 0x00000af2 };
const u32 bern_den_data233[2] = { 0xbd07bf0a, 0x00000125 };
const u32 bern_den_data234[1] = { 0x00000042 };
const u32 bern_den_data235[1] = { 0x0000001e };
const u32 bern_den_data236[1] = { 0x0000002a };
const u32 bern_den_data237[1] = { 0x00032c3a };
const u32 bern_den_data238[1] = { 0x00000b3a };
const u32 bern_den_data239[2] = { 0x2d61237a, 0x00034987 };
const u32 bern_den_data240[1] = { 0x00000006 };
const u32 bern_den_data241[1] = { 0x000002b2 };
const u32 bern_den_data242[1] = { 0x03c69576 };
const u32 bern_den_data243[1] = { 0x0000001e };
const u32 bern_den_data244[1] = { 0x00231b9a };
const u32 bern_den_data245[1] = { 0x0003751e };
const u32 bern_den_data246[1] = { 0x00000006 };
const u32 bern_den_data247[1] = { 0x000001fe };
const u32 bern_den_data248[1] = { 0x003567d2 };
const u32 bern_den_data249[1] = { 0x007fa706 };
const u32 bern_den_data250[1] = { 0x00000bca };
const u32 bern_den_data251[2] = { 0xf61564c6, 0x0000142d };
const u32 bern_den_data252[1] = { 0x00001956 };
const u32 bern_den_data253[1] = { 0x00003ba6 };
const u32 bern_den_data254[1] = { 0x0016825e };
const u32 bern_den_data255[1] = { 0x0001fffe };
const u32 bern_den_data256[1] = { 0x00000006 };
const u32 bern_den_data257[1] = { 0x000734e2 };
const u32 bern_den_data258[1] = { 0x00000006 };
const u32 bern_den_data259[2] = { 0x652d5396, 0x0000000b };
const u32 bern_den_data260[1] = { 0x0177bb0e };
const u32 bern_den_data261[1] = { 0x00001ed2 };
const u32 bern_den_data262[1] = { 0x00000006 };
const u32 bern_den_data263[2] = { 0x7b637da2, 0x00000001 };
const u32 bern_den_data264[1] = { 0x00001b96 };
const u32 bern_den_data265[1] = { 0x00000366 };
const u32 bern_den_data266[1] = { 0x00001d5e };
const u32 bern_den_data267[1] = { 0x00001f86 };
const u32 bern_den_data268[1] = { 0x00000006 };
const u32 bern_den_data269[3] = { 0x9c3bfc42, 0x427c3d6e, 0x00000006 };
const u32 bern_den_data270[1] = { 0x00000006 };
const u32 bern_den_data271[1] = { 0x000110ee };
const u32 bern_den_data272[1] = { 0x04a6d636 };
const u32 bern_den_data273[1] = { 0x0000001e };
const u32 bern_den_data274[1] = { 0x000005ee };
const u32 bern_den_data275[2] = { 0x26774cba, 0x00000001 };
const u32 bern_den_data276[1] = { 0x00000006 };
const u32 bern_den_data277[1] = { 0x00004146 };
const u32 bern_den_data278[1] = { 0x0000031e };
const u32 bern_den_data279[2] = { 0x49ffcd2e, 0x00000dad };
const u32 bern_den_data280[1] = { 0x00000d32 };
const u32 bern_den_data281[1] = { 0x000bc9ee };
const u32 bern_den_data282[1] = { 0x00000006 };
const u32 bern_den_data283[1] = { 0x000042ae };
const u32 bern_den_data284[1] = { 0x5d19cbba };
const u32 bern_den_data285[1] = { 0x00008eda };
const u32 bern_den_data286[1] = { 0x000001f2 };
const u32 bern_den_data287[2] = { 0x53392da6, 0x005b66dd };
const u32 bern_den_data288[1] = { 0x00000006 };
const u32 bern_den_data289[1] = { 0x00004c0e };
const u32 bern_den_data290[1] = { 0x0000002a };
const u32 bern_den_data291[1] = { 0x00002256 };
const u32 bern_den_data292[1] = { 0x00000dc2 };
const u32 bern_den_data293[1] = { 0x27f94aee };
const u32 bern_den_data294[1] = { 0x00000042 };
const u32 bern_den_data295[1] = { 0x02af97b6 };
const u32 bern_den_data296[1] = { 0x0e96099a };
const u32 bern_den_data297[1] = { 0x0000001e };
const u32 bern_den_data298[1] = { 0x000293d6 };
const u32 bern_den_data299[2] = { 0xff75ba9e, 0x004bd105 };
const u32 bern_den_data300[1] = { 0x00000006 };
const u32 bern_den_data301[1] = { 0x0000001e };
const u32 bern_den_data302[1] = { 0x00006396 };
const u32 bern_den_data303[1] = { 0x000001fe };
const u32 bern_den_data304[1] = { 0x00000042 };
const u32 bern_den_data305[2] = { 0x857e1b26, 0x000021d5 };
const u32 bern_den_data306[1] = { 0x00000006 };
const u32 bern_den_data307[1] = { 0x417e7f2a };
const u32 bern_den_data308[1] = { 0x0000658e };
const u32 bern_den_data309[1] = { 0x000190e6 };
const u32 bern_den_data310[1] = { 0x00000006 };
const u32 bern_den_data311[2] = { 0x4d92c1a6, 0x000008af };
const u32 bern_den_data312[1] = { 0x00000006 };
const u32 bern_den_data313[1] = { 0x0000001e };
const u32 bern_den_data314[2] = { 0xc133ec6a, 0x0031e824 };
const u32 bern_den_data315[1] = { 0x00002526 };
const u32 bern_den_data316[1] = { 0x00000006 };
const u32 bern_den_data317[1] = { 0x0004750e };
const u32 bern_den_data318[1] = { 0x00001fce };
const u32 bern_den_data319[1] = { 0x08c9b37a };
const u32 bern_den_data320[1] = { 0x0000697e };
const u32 bern_den_data321[1] = { 0x00009fba };
const u32 bern_den_data322[1] = { 0x00000f2a };
const u32 bern_den_data323[2] = { 0x8e38e36a, 0x00000243 };
const u32 bern_den_data324[1] = { 0x000021c6 };
const u32 bern_den_data325[1] = { 0x00004c86 };
const u32 bern_den_data326[1] = { 0x0000002a };
const u32 bern_den_data327[1] = { 0x0000a55a };
const u32 bern_den_data328[1] = { 0x00000f72 };
const u32 bern_den_data329[2] = { 0xb9b5b5fe, 0x00440538 };
const u32 bern_den_data330[1] = { 0x00000006 };
const u32 bern_den_data331[1] = { 0x00001392 };
const u32 bern_den_data332[1] = { 0x0002b722 };
const u32 bern_den_data333[1] = { 0x0000001e };
const u32 bern_den_data334[1] = { 0x00000042 };
const u32 bern_den_data335[2] = { 0x0313edf6, 0x01ff21e2 };
const u32 bern_den_data336[1] = { 0x00000006 };
const u32 bern_den_data337[1] = { 0x00106cce };
const u32 bern_den_data338[1] = { 0x0000253e };
const u32 bern_den_data339[1] = { 0x001c48aa };
const u32 bern_den_data340[1] = { 0x0001702e };
const u32 bern_den_data341[1] = { 0x1a32276e };
const u32 bern_den_data342[1] = { 0x00000006 };
const u32 bern_den_data343[1] = { 0x000158a6 };
const u32 bern_den_data344[2] = { 0x0dab6c0e, 0x0000000f };
const u32 bern_den_data345[1] = { 0x000028aa };
const u32 bern_den_data346[1] = { 0x00000006 };
const u32 bern_den_data347[2] = { 0x0caf7ca6, 0x00000003 };
const u32 bern_den_data348[1] = { 0x00000006 };
const u32 bern_den_data349[2] = { 0x3368f00e, 0x0000000b };
const u32 bern_den_data350[1] = { 0x0000f642 };
const u32 bern_den_data351[1] = { 0x15f730c2 };
const u32 bern_den_data352[1] = { 0x00000006 };
const u32 bern_den_data353[1] = { 0x001d88d2 };
const u32 bern_den_data354[1] = { 0x00000042 };
const u32 bern_den_data355[1] = { 0x000014fa };
const u32 bern_den_data356[1] = { 0x02a6613e };
const u32 bern_den_data357[1] = { 0x00002a12 };
const u32 bern_den_data358[1] = { 0x000010da };
const u32 bern_den_data359[3] = { 0x9bec486e, 0xcda0b994, 0x00000004 };
const u32 bern_den_data360[1] = { 0x00000006 };
const u32 bern_den_data361[1] = { 0x0000001e };
const u32 bern_den_data362[1] = { 0x02cdf85e };
const u32 bern_den_data363[1] = { 0x0000b41e };
const u32 bern_den_data364[1] = { 0x00000042 };
const u32 bern_den_data365[1] = { 0x2bc60e1e };
const u32 bern_den_data366[1] = { 0x00000006 };
const u32 bern_den_data367[1] = { 0x00005da2 };
const u32 bern_den_data368[1] = { 0x02eadeee };
const u32 bern_den_data369[1] = { 0x0000c012 };
const u32 bern_den_data370[1] = { 0x0007474e };
const u32 bern_den_data371[1] = { 0x000f89b2 };
const u32 bern_den_data372[1] = { 0x00000006 };
const u32 bern_den_data373[1] = { 0x000002b2 };
const u32 bern_den_data374[2] = { 0xea372a16, 0x0000005e };
const u32 bern_den_data375[1] = { 0x000001fe };
const u32 bern_den_data376[1] = { 0x00000162 };
const u32 bern_den_data377[2] = { 0xe57135b2, 0x83e85b9e };
const u32 bern_den_data378[1] = { 0x00000006 };
const u32 bern_den_data379[1] = { 0x7537eb76 };
const u32 bern_den_data380[1] = { 0x0000002a };
const u32 bern_den_data381[1] = { 0x00002ce2 };
const u32 bern_den_data382[1] = { 0x00000006 };
const u32 bern_den_data383[2] = { 0xc349a08a, 0x00009c2b };
const u32 bern_den_data384[1] = { 0x0001a502 };
const u32 bern_den_data385[1] = { 0x00005a96 };
const u32 bern_den_data386[1] = { 0x0000031e };
const u32 bern_den_data387[1] = { 0x00002d96 };
const u32 bern_den_data388[1] = { 0x00000006 };
const u32 bern_den_data389[2] = { 0x12c565e2, 0x00115f8d };
const u32 bern_den_data390[1] = { 0x0000011a };
const u32 bern_den_data391[1] = { 0x139fce7e };
const u32 bern_den_data392[1] = { 0x0084a5d2 };
const u32 bern_den_data393[1] = { 0x0000001e };
const u32 bern_den_data394[1] = { 0x00000042 };
const u32 bern_den_data395[2] = { 0x81f1ff9a, 0x151115c5 };
const u32 bern_den_data396[1] = { 0x00000006 };
const u32 bern_den_data397[1] = { 0x00005d66 };
const u32 bern_den_data398[1] = { 0x0000070e };
const u32 bern_den_data399[2] = { 0x2b414f42, 0x00000002 };
const u32 bern_den_data400[1] = { 0x00000006 };
const u32 bern_den_data401[1] = { 0x000b34a2 };
const u32 bern_den_data402[1] = { 0x00000006 };
const u32 bern_den_data403[1] = { 0x00005ece };
const u32 bern_den_data404[2] = { 0xbc2a4e2a, 0x000008dd };
const u32 bern_den_data405[1] = { 0x0000c882 };
const u32 bern_den_data406[1] = { 0x0000008a };
const u32 bern_den_data407[2] = { 0x5d243a06, 0x0000003e };
const u32 bern_den_data408[1] = { 0x00000006 };
const u32 bern_den_data409[1] = { 0x01572096 };
const u32 bern_den_data410[1] = { 0x00008706 };
const u32 bern_den_data411[1] = { 0x0000001e };
const u32 bern_den_data412[1] = { 0x00001362 };
const u32 bern_den_data413[2] = { 0x5531eb2e, 0x000a3a93 };
const u32 bern_den_data414[1] = { 0x00002b0e };
const u32 bern_den_data415[1] = { 0x00006996 };
const u32 bern_den_data416[1] = { 0x0000002a };
const u32 bern_den_data417[1] = { 0x00046956 };
const u32 bern_den_data418[1] = { 0x000013aa };
const u32 bern_den_data419[3] = { 0xde364766, 0xeff61467, 0x00000116 };
const u32 bern_den_data420[1] = { 0x00000006 };
const u32 bern_den_data421[1] = { 0x0000001e };
const u32 bern_den_data422[1] = { 0x0003722a };
const u32 bern_den_data423[1] = { 0x0000d52a };
const u32 bern_den_data424[1] = { 0x00000042 };
const u32 bern_den_data425[1] = { 0x00238872 };
const u32 bern_den_data426[1] = { 0x00000006 };
const u32 bern_den_data427[1] = { 0x0000646e };
const u32 bern_den_data428[2] = { 0x05ca1f3a, 0x00000001 };
const u32 bern_den_data429[1] = { 0x0177745e };
const u32 bern_den_data430[1] = { 0x0000143a };
const u32 bern_den_data431[2] = { 0x1c6f5b4e, 0x0026bce7 };
const u32 bern_den_data432[1] = { 0x00000006 };
const u32 bern_den_data433[1] = { 0x00000366 };
const u32 bern_den_data434[1] = { 0x000ce4c6 };
const u32 bern_den_data435[1] = { 0x0000001e };
const u32 bern_den_data436[1] = { 0x0000011a };
const u32 bern_den_data437[2] = { 0xb3d97006, 0x00000047 };
const u32 bern_den_data438[1] = { 0x00000006 };
const u32 bern_den_data439[2] = { 0x941aca26, 0x00000060 };
const u32 bern_den_data440[1] = { 0xe55bea82 };
const u32 bern_den_data441[1] = { 0x000abf72 };
const u32 bern_den_data442[1] = { 0x000014ca };
const u32 bern_den_data443[1] = { 0x05681ece };
const u32 bern_den_data444[1] = { 0x00002e26 };
const u32 bern_den_data445[1] = { 0x0000001e };
const u32 bern_den_data446[1] = { 0x0000002a };
const u32 bern_den_data447[1] = { 0x2cba32e6 };
const u32 bern_den_data448[1] = { 0x00000006 };
const u32 bern_den_data449[2] = { 0x7e43f04a, 0x018781bc };
const u32 bern_den_data450[1] = { 0x00002cbe };
const u32 bern_den_data451[1] = { 0x00001a9a };
const u32 bern_den_data452[1] = { 0x000094ce };
const u32 bern_den_data453[1] = { 0x0000001e };
const u32 bern_den_data454[1] = { 0x215533b6 };
const u32 bern_den_data455[2] = { 0x217f1c42, 0x00000001 };
const u32 bern_den_data456[1] = { 0x00000006 };
const u32 bern_den_data457[1] = { 0x0000001e };
const u32 bern_den_data458[2] = { 0x6635d27a, 0x00000005 };
const u32 bern_den_data459[1] = { 0x11792ece };
const u32 bern_den_data460[1] = { 0x00000006 };
const u32 bern_den_data461[2] = { 0x86c0e8f2, 0x00000235 };
const u32 bern_den_data462[1] = { 0x00000006 };
const u32 bern_den_data463[2] = { 0x843768da, 0x00000001 };
const u32 bern_den_data464[1] = { 0x0043f6fe };
const u32 bern_den_data465[1] = { 0x000036ba };
const u32 bern_den_data466[1] = { 0x00000006 };
const u32 bern_den_data467[3] = { 0x96a1ac1a, 0x76d769b1, 0x00000001 };
const u32 bern_den_data468[1] = { 0x00000006 };
const u32 bern_den_data469[1] = { 0x0004bd02 };
const u32 bern_den_data470[1] = { 0x0000002a };
const u32 bern_den_data471[1] = { 0x000001fe };
const u32 bern_den_data472[1] = { 0x0001fe7e };
const u32 bern_den_data473[1] = { 0x000d3482 };
const u32 bern_den_data474[1] = { 0x0000313e };
const u32 bern_den_data475[2] = { 0x521eb83a, 0x00000006 };
const u32 bern_den_data476[1] = { 0x00014d8a };
const u32 bern_den_data477[1] = { 0x00003822 };
const u32 bern_den_data478[1] = { 0x00000006 };
const u32 bern_den_data479[2] = { 0x363bbefa, 0x027a6ee9 };
const u32 bern_den_data480[1] = { 0x00000006 };
const u32 bern_den_data481[1] = { 0x0000001e };
const u32 bern_den_data482[2] = { 0xa80b406a, 0x00000002 };
const u32 bern_den_data483[1] = { 0x0000efe2 };
const u32 bern_den_data484[1] = { 0x0000fa56 };
const u32 bern_den_data485[2] = { 0x599e9576, 0x00000f1a };
const u32 bern_den_data486[1] = { 0x00000006 };
const u32 bern_den_data487[1] = { 0x00079a5e };
const u32 bern_den_data488[1] = { 0x0000002a };
const u32 bern_den_data489[2] = { 0x4d66d6a2, 0x0000000f };
const u32 bern_den_data490[1] = { 0x0000170a };
const u32 bern_den_data491[1] = { 0x0003751e };
const u32 bern_den_data492[1] = { 0x00000162 };
const u32 bern_den_data493[1] = { 0x00000636 };
const u32 bern_den_data494[2] = { 0x47193f4a, 0x00613f27 };
const u32 bern_den_data495[1] = { 0x000001fe };
const u32 bern_den_data496[1] = { 0x00000006 };
const u32 bern_den_data497[2] = { 0xcf528b5a, 0x00000034 };
const u32 bern_den_data498[1] = { 0x00000006 };
const u32 bern_den_data499[1] = { 0x1471bff6 };
const u32 bern_den_data500[1] = { 0x0000002a };
const u32 bern_den_data501[1] = { 0x00003af2 };
const u32 bern_den_data502[1] = { 0x00000006 };
const u32 bern_den_data503[3] = { 0xeb08c346, 0xab4f42b0, 0x00000311 };
const u32 bern_den_data504[1] = { 0x00000042 };
const u32 bern_den_data505[1] = { 0x01f54686 };
const u32 bern_den_data506[1] = { 0x00000cf6 };
const u32 bern_den_data507[1] = { 0x00003ba6 };
const u32 bern_den_data508[1] = { 0x000017e2 };
const u32 bern_den_data509[2] = { 0x6ec41a4e, 0x0000056e };
const u32 bern_den_data510[1] = { 0x00000006 };
const u32 bern_den_data511[1] = { 0x0001fffe };

// Bernoulli numbers - denominators, headers
const cbigint bern_den[BIGINT_BERN_NUM] = { // BIGINT_BERN_NUM=512
	{ bern_den_data0, 1, 0 },	// B2: 6
	{ bern_den_data1, 1, 0 },	// B4: 30
	{ bern_den_data2, 1, 0 },	// B6: 42
	{ bern_den_data3, 1, 0 },	// B8: 30
	{ bern_den_data4, 1, 0 },	// B10: 66
	{ bern_den_data5, 1, 0 },	// B12: 2730
	{ bern_den_data6, 1, 0 },	// B14: 6
	{ bern_den_data7, 1, 0 },	// B16: 510
	{ bern_den_data8, 1, 0 },	// B18: 798
	{ bern_den_data9, 1, 0 },	// B20: 330
	{ bern_den_data10, 1, 0 },	// B22: 138
	{ bern_den_data11, 1, 0 },	// B24: 2730
	{ bern_den_data12, 1, 0 },	// B26: 6
	{ bern_den_data13, 1, 0 },	// B28: 870
	{ bern_den_data14, 1, 0 },	// B30: 14322
	{ bern_den_data15, 1, 0 },	// B32: 510
	{ bern_den_data16, 1, 0 },	// B34: 6
	{ bern_den_data17, 1, 0 },	// B36: 1919190
	{ bern_den_data18, 1, 0 },	// B38: 6
	{ bern_den_data19, 1, 0 },	// B40: 13530
	{ bern_den_data20, 1, 0 },	// B42: 1806
	{ bern_den_data21, 1, 0 },	// B44: 690
	{ bern_den_data22, 1, 0 },	// B46: 282
	{ bern_den_data23, 1, 0 },	// B48: 46410
	{ bern_den_data24, 1, 0 },	// B50: 66
	{ bern_den_data25, 1, 0 },	// B52: 1590
	{ bern_den_data26, 1, 0 },	// B54: 798
	{ bern_den_data27, 1, 0 },	// B56: 870
	{ bern_den_data28, 1, 0 },	// B58: 354
	{ bern_den_data29, 1, 0 },	// B60: 56786730
	{ bern_den_data30, 1, 0 },	// B62: 6
	{ bern_den_data31, 1, 0 },	// B64: 510
	{ bern_den_data32, 1, 0 },	// B66: 64722
	{ bern_den_data33, 1, 0 },	// B68: 30
	{ bern_den_data34, 1, 0 },	// B70: 4686
	{ bern_den_data35, 1, 0 },	// B72: 140100870
	{ bern_den_data36, 1, 0 },	// B74: 6
	{ bern_den_data37, 1, 0 },	// B76: 30
	{ bern_den_data38, 1, 0 },	// B78: 3318
	{ bern_den_data39, 1, 0 },	// B80: 230010
	{ bern_den_data40, 1, 0 },	// B82: 498
	{ bern_den_data41, 1, 0 },	// B84: 3404310
	{ bern_den_data42, 1, 0 },	// B86: 6
	{ bern_den_data43, 1, 0 },	// B88: 61410
	{ bern_den_data44, 1, 0 },	// B90: 272118
	{ bern_den_data45, 1, 0 },	// B92: 1410
	{ bern_den_data46, 1, 0 },	// B94: 6
	{ bern_den_data47, 1,